import pytest

import torch

from fr_models import _torch

@pytest.mark.parametrize('x, dim, expected', [
    (torch.tensor([[1.0,1.0,1.0]]), None, True),
    (torch.tensor([[1.0,0.5,1.0]]), None, False),
    (torch.tensor([[1.0,1.0,1.0],
                   [2.0,2.0,2.0]]), None, False),
    (torch.tensor([[1.0,1.0,1.0],
                   [2.0,2.0,2.0]]), 0, False),
    (torch.tensor([[1.0,1.0,1.0],
                   [2.0,2.0,2.0]]), 1, True),
    (torch.tensor([[1.0,1.0,1.0],
                   [2.0,2.0,2.0]]), (0,1), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), None, False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), 0, True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), 1, False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), -1, True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (0,1), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (1,0), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (0,2), True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (2,0), True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (0,-1), True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (-1,0), True),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (1,2), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (2,1), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (-1,-2), False),
    (torch.tensor([[[1.0,1.0,1.0],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,2.0,2.0]]]), (-2,-1), False),
    (torch.tensor([[[1.0,1.0,0.5],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,0.5,2.0]]]),
     0,
     torch.tensor([[True, True, False],
                   [True, False, True]])),
    (torch.tensor([[[1.0,1.0,0.5],
                    [1.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,1.0,2.0]]]),
     1,
     torch.tensor([[True, False, False],
                   [False, True, False]])),
    (torch.tensor([[[1.0,1.0,0.5],
                    [2.0,2.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,1.0,2.0]]]),
     2,
     torch.tensor([[False, True],
                   [True, False]])),
    (torch.tensor([[[1.0,1.0,0.5],
                    [2.0,1.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,1.0,2.0]]]),
     (0,1),
     torch.tensor([False, True, False])),
    (torch.tensor([[[1.0,1.0,1.0],
                    [0.5,1.0,2.0]],
                   [[1.0,1.0,1.0],
                    [2.0,1.0,2.0]]]),
     (0,2),
     torch.tensor([True, False])),
    (torch.tensor([[[1.0,1.0,1.0],
                    [0.5,1.0,2.0]],
                   [[1.0,1.0,1.0],
                    [1.0,1.0,1.0]]]),
     (1,2),
     torch.tensor([False, True])),
])
def test_isconst(x, dim, expected):
    assert torch.all(_torch.isconst(x, dim=dim) == expected)