from setuptools import setup
import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name='fundsight',
    version='0.0.1',
    author="Antoine Perrin",
    author_email="antoineperrin.pro1@gmail.com",
    description='Asset management fund performance and reporting modules',
    py_modules=["indicators"],
    package_dir={'': 'src'},
    packages=setuptools.find_packages(where="src"),
    classifiers=[
        "Programming Language :: Python :: 3.9",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent"],
    long_description=long_description,
    long_description_content_type="text/markdown",
    install_requires=["workalendar","pandas","numpy","datetime"],
    url = "https://github.com/ahgperrin/fundperformance"
    )


