import re

get_bin = lambda x, n: format(x, "b").zfill(n)
get_hex = lambda x, n: format(x, "x").zfill(n)


class AnsiColor:
    RESET_COLOR = "\033[0m"
    SIGN_COLOR = "\033[1;37;41m"
    REG_COLOR = "\033[1;30;43m"
    EXP_COLOR = "\033[1;37;44m"
    MANT_COLOR = "\033[1;37;40m"
    ANSI_COLOR_CYAN = "\x1b[36m"
    ANSI_COLOR_GREY = "\x1b[90m"


dbg_print = lambda s: print(f"{AnsiColor.ANSI_COLOR_GREY}{s}{AnsiColor.RESET_COLOR}")


def shl(bits, rhs, size):
    """shift left on `size` bits"""
    mask = (2 ** size) - 1
    # if rhs < 0:
    #     dbg_print("shl shifted by a neg number")
    return (bits << rhs) & mask if rhs > 0 else (bits >> -rhs)


def shr(bits, rhs, size):
    """shift right"""
    return shl(bits, -rhs, size)


def c2(bits, size):
    """two's complement on `size` bits"""
    mask = (2 ** size) - 1
    return (~bits & mask) + 1


# https://github.com/jonathaneunice/colors/blob/c965f5b9103c5bd32a1572adb8024ebe83278fb0/colors/colors.py#L122
def strip_color(s):
    """
    Remove ANSI color/style sequences from a string. The set of all possible
    ANSI sequences is large, so does not try to strip every possible one. But
    does strip some outliers seen not just in text generated by this module, but
    by other ANSI colorizers in the wild. Those include `\x1b[K` (aka EL or
    erase to end of line) and `\x1b[m`, a terse version of the more common
    `\x1b[0m`.
    """
    return re.sub("\x1b\\[(K|.*?m)", "", s)


# https://github.com/jonathaneunice/colors/blob/c965f5b9103c5bd32a1572adb8024ebe83278fb0/colors/colors.py#L134
def ansilen(s):
    """
    Given a string with embedded ANSI codes, what would its
    length be without those codes?
    """
    return len(strip_color(s))
