from .buffer import RenderBuffer
from .context import HeaderContext


def render_class_prologue(r: RenderBuffer, hctx: HeaderContext):
    # fmt: off
    r.writeln(
        "// This file is autogenerated. DO NOT EDIT\n"
        "#include <robotpy_build.h>"
    )
    # fmt: on

    if hctx.has_vcheck:
        r.writeln("#include <functional>")

    if hctx.extra_includes_first:
        r.writeln()
        for inc in hctx.extra_includes_first:
            r.writeln(f"#include <{inc}>")

    r.writeln(f"\n#include <{hctx.rel_fname}>")

    if hctx.type_caster_includes:
        r.writeln()
        for inc in hctx.type_caster_includes:
            r.writeln(f"#include <{inc}>")

    if hctx.need_operators_h:
        r.writeln(f"\n#include <pybind11/operators.h>")

    if hctx.using_declarations:
        r.writeln()
        for decl in hctx.using_declarations:
            r.writeln(f"using {decl.format()};")

    for cls in hctx.classes_with_trampolines:
        r.writeln()
        r.writeln(
            f"#define RPYGEN_ENABLE_{cls.full_cpp_name_identifier}_PROTECTED_CONSTRUCTORS"
        )
        r.writeln(f"#include <rpygen/{cls.full_cpp_name_identifier}.hpp>")
