# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['discogs_alert', 'discogs_alert.notify']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.11.2,<5.0.0',
 'click>=8.1.3,<9.0.0',
 'dacite>=1.8.0,<2.0.0',
 'fake-useragent>=1.1.1,<2.0.0',
 'pre-commit>=2.20.0,<3.0.0',
 'requests>=2.28.2,<3.0.0',
 'ruff>=0.0.252,<0.0.253',
 'schedule>=1.1.0,<2.0.0',
 'selenium>=4.8.2,<5.0.0',
 'webdriver-manager>=3.8.5,<4.0.0']

extras_require = \
{':python_version < "3.8"': ['tox>=3,<4'],
 ':python_version >= "3.8"': ['tox>=4.4.5,<5.0.0']}

setup_kwargs = {
    'name': 'discogs-alert',
    'version': '0.0.13',
    'description': 'Configurable, real-time alerts for your discogs wantlist',
    'long_description': '# Discogs Alert\n\n<p align="center">\n    <a href="https://github.com/michaelhball/discogs_alert/blob/main/LICENSE">\n        <img alt="GitHub" src="https://img.shields.io/badge/license-GPL%203.0-blue">\n    </a>\n    <a href="https://github.com/michaelhball/discogs_alert/releases">\n        <img alt="GitHub release" src="https://img.shields.io/github/v/release/michaelhball/discogs_alert?sort=semver">\n    </a>\n</p>\n\n<h3 align="center">\n<p>Customised, real-time alerting for your hard-to-find wantlist items.\n</h3>\n\n![vinyl icon](https://github.com/michaelhball/discogs_alert/blob/main/img/vinyl.png) \ndiscogs-alert enables you to set up ~real-time alerts so you get notified the moment those \nhard-to-find releases go on sale. The project is designed to be \'set and forget\'; you customise your preferences for a \nparticular release once, and then sit back and wait for a notification.\n\n![vinyl icon](https://github.com/michaelhball/discogs_alert/blob/main/img/vinyl.png) \ndiscogs-alert enables both global and fine-grained customisation of your preferences\n(incl. price thresholds, minimum seller rating, and minimum media/sleeve condition). This \nmeans you\'ll only be notified if a record goes on sale that really matches what you\'re looking \nfor.\n\n![vinyl icon](https://github.com/michaelhball/discogs_alert/blob/main/img/vinyl.png) \nIf you have suggestions or ideas, please reach out! I\'ll be maintaining this repo much more actively this year, and\nI\'d love to continue making `discogs_alert` as useful as possible!\n\n## Requirements\n\n- Python >= 3.8\n- [Chromedriver](https://chromedriver.chromium.org/) (if you have Google Chrome or any Chromium browser \ninstalled on your computer, you\'ll be fine).\n\n## Installation & Setup\n\nYou can install discogs-alert as a Python package, either via the Python Package Index (PyPI) or from source, or as a docker image\nfrom DockerHub.\n\n### Python\n\nTo install using `pip`:\n```\npip install discogs-alert\n```\n\n#### Downloading and installing from source \nDownload the latest version of discogs-alert from PyPI:\n\n[https://pypi.org/project/discogs-alert/](https://pypi.org/project/discogs-alert/)\n\nYou can then  install it by doing the following:\n```\n$ tar xvfz discogs_alert-0.0.0.tar.gz\n$ cd discogs_alert-0.0.0\n$ python setup.by build\n$ python setup.py install \n```\nThe last command must be executed as a privileged user if you aren\'t currently using a virtualenv.\n\n### Docker\n\nAssuming you have docker installed, you can pull the latest image via\n```bash\ndocker pull miggleball/discogs_alert:latest\n```\n\nNB: the `discogs_alert` docker image doesn\'t yet support M1 macs (those recent models with the ARM64 chip). Support there will\nhopefully be coming soon.\n\n\n## Setup\n\nBefore you can use this project, there are a couple more things that need to be setup.\n\n### Discogs access token\n\nA Discogs access token allows `discogs_alert` to send requests to the discogs API on your behalf, as well as to\nincrease its allowed rate of request. This token can only be used to access the music database features of \nthe Discogs API, not the marketplace, so there is no concern that you are accidentally granting control over \nthe buying or selling of records. You can find more information \n[here](https://www.discogs.com/developers/#page:authentication).\n\nTo create an access token, go to your Discogs settings and click on the \n[Developer](https://www.discogs.com/settings/developers) tab. There is a button on this page to generate a \nnew token. For now, just copy this token to your computer.\n\n### Pushbullet\n\nThis project uses Pushbullet for notifying you once a record you are searching for has gone on sale. You can \nchoose exactly how you want to receive these notifications (i.e. on which device), but you first need to \ncreate a [Pushbullet](https://www.pushbullet.com/) account. After signing up, make sure to install Pushbullet \non all devices where you would like to receive notifications.\n\nOnce you\'ve created an account, simply navigate to your [settings](https://www.pushbullet.com/#settings) page and \ncreate an access token. As before, copy this token to your computer.\n\nNB: when using pushbullet, please note that you\'ll need to open the pushbullet mobile or web app once a month. \nIf you don\'t, the notification service won\'t work, as it deems you to have a \'dead\' account.\n\nNB: support for more notification options is coming soon! Please bear with me (or open a PR!)\n\n### Creating your wantlist\n\nThere are two different ways you can create a wantlist: 1) by connecting to one of your existing Discogs lists,\nor 2) by creating a local JSON file. The first option is easier, faster, and fits within your regular Discogs workflow,\nwhile the latter enables more expressivity as you can specify fine-grained filters (e.g. price, media/sleeve quality)\nfor each release (in addition to overall). I will add support for this expressivity to the Discogs List approach\nas soon as possible.\n\n#### Discogs List\n\nUsing one of your existing Discogs [lists]() requires only specifying the ID of the list at runtime \n(outlined in the [usage](#usage) section below). As of now, there is no fine-grained control allowed with \nthis option, meaning the list you use should be one containing _only_ those records about which you want to \nbe notified immediately if they go on sale. You can set global media/sleeve condition filters, but you\ncannot customize this for each release separately. This approach makes it incredibly easy to add new releases\nto your wantlist: adding a release to the specificied list means it will automatically be searched for by your\nrunning `discogs_alert` jobs on its next iteration.\n\n#### Local JSON\n\nHere is an example `wantlist.json` file:\n```yaml\n[\n  {\n    "id": 1061046,\n    "display_title": "Deep² — Sphere",\n    "accept_generic_sleeve": true,\n    "min_media_condition": "VERY_GOOD"\n  },\n  {\n    "id": 2247646,\n    "display_title": "Charanjit Singh — Ten Ragas to a Disco Beat",\n    "price_threshold": 500 \n  }\n]\n```\nThe wantlist is a list of objects, each object representing a release. The only essential attributes are the\n`id` field, which can be found on each release\'s Discogs page, and the `display_title`, which is the name\nyou give the release s.t. you will recognise it when you\'re notified.\n\nThere are a number of optional attributes that can be included for each release. The combination of all \nattributes applied to a given release are used as a filter, so you will only be notified if all conditions \nare met for a given listing item. In the above case, the user is looking for any `VERY_GOOD` or higher \ncopies of the `Deep²` release, with no maximum price (e.g. an example scenario here is that there are\ncurrently no copies on the market, and the user wants to be notified as soon as one goes on sale). For the\n`Charanjit Singh` release, the user is looking for any copies on sale for less than `€500`.\n\nNB: the currency is determined later, at runtime. This is outlined in the [usage](#usage) section below.\n\nNote that all attributes relating to media and sleeve characteristics also have global values (the setting of\nwhich is discussed in [usage](#usage)). This means that if you want the same filters for most releases you\'re\nsearching for, you _do not_ need to specify those conditions for every single release in your `wantlist.json`\nfile. You can set the values once globally (when you run the program), and then set only those per-release\nvalues that differ from the global settings. Any filters specified in your `wantlist.json` will override the\nglobal values.\n\nThe possible optional filters are as follows:\n* `price_threshold`: maximum allowable price (excluding shipping)\n* `min_media_condition`: minimum allowable media condition (one of `\'POOR\'`, `\'FAIR\'`, `\'GOOD\'`, `\'GOOD_PLUS\'`,\n`\'VERY_GOOD\'`, `\'VERY_GOOD_PLUS\'`, `\'NEAR_MINT\'`, or `\'MINT\'`)\n* `min_sleeve_condition`: minimum allowable sleeve condition (one of `\'POOR\'`, `\'FAIR\'`, `\'GOOD\'`, `\'GOOD_PLUS\'`,\n`\'VERY_GOOD\'`, `\'VERY_GOOD_PLUS\'`, `\'NEAR_MINT\'`, or `\'MINR\'`)\n* `accept_generic_sleeve`: boolean indicating whether you want to accept a generic sleeve\n* `accept_no_sleeve`: boolean indicating whether you want to accept no sleeve\n* `accept_ungraded_sleeve`: boolean indicating whether you want to accept an ungraded sleeve\n\n## Usage\n\n`discogs_alert` can be run either as a Python process or as a Docker container. Regardless of which command is used, the\n`discogs_alert` service will regularly pull the releases from your wantlist, check their availability on the Discogs\nmarketplace, and send you a notification if any release (satisfying your filters) is for sale. You should leave the service\nrunning in the background at all times to be most effective.\n\n#### Python\n\nThe minimal command needed to run the `discogs_alert` Python package is \n```bash\n$ python -m discogs_alert\n```\nthough that assumes the prior setting of a few environment variables: `DISCOGS_TOKEN`, `PUSHBULLET_TOKEN`, and\n`LIST_ID` or `WANTLIST_PATH`. The token values must be set to the values of the tokens created earlier, while\nthe `LIST_ID` should be set to the ID of the Discogs list you want to use as your `discogs_alert` wantlist (or\n`WANTLIST_PATH` should be set to the path of a local `wantlist.json` file that will be used instead). If you specify\nboth a Discogs list ID and a local wantlist path, only the latter will be used.\n\nIf you aren\'t sure how to set environment variables, you can instead pass these values manually using the following\ncommand\n```bash\n$ python -m discogs_alert -dt <discogs_access_token> -pt <pushbullet_token> --list-id <discogs_list_id>\n```\n\n#### Docker\n\nThe minimal command needed to run the `discogs_alert` Docker image is\n```bash\n$ docker run -d --env-file .env miggleball/discogs_alert:latest\n```\nwhere it is assumed that you have specified the three minimal environment variables outlined above (as well as any additional\ncustomizations) in an `.env` txt file in the current directory. Your env file should simply look as follows:\n```bash\nDISCOGS_TOKEN=<discogs_access_token>\nPUSHBULLET_TOKEN=<pushbullet_token>\nLIST_ID=<discogs_list_id>\n...\n```\nThe `-d` flag specifies that you want to "detach" from the newly created docker container meaning it will continue running in the\nbackground.\n\n### Extras\n\nPlease note that you _can_ add to or change the contents of your wantlist (either Discogs list or local file) while\nthe service is running; the updated list of releases will come into effect the next time the service runs.\n\nEach time one of your releases is found, your Pushbullet account will be sent a notification with the title and the URL\nto the marketplace listing. As long as you don\'t delete the pushbullet notification, you will _not_ be sent repeat\nnotifications for the same listing. You can test that the notification system is working correctly by adding a release\nto your wantlist that you know is currently for sale.\n\nIf you want further customisation, there are a number of optional arguments and flags with which the service can be run.\nThese optional arguments include the global versions of the conditions mentioned above (i.e. the global seller, media,\nand sleeve conditions) that will be applied to all releases in your wantlist by default.\n\nFor any of the following arguments, you can use either the abbreviated argument indicator (prefixed with `-`) or the\nverbose option (prefixed with `--`). The complete list of options, including options and default values, can be accessed at\nany time by running:\n```bash\n$ python -m discogs_alert --help\n```\n\nHere are the possible arguments:\n \n* `-dt` `--discogs-token`: (str) your discogs user access token\n* `-pt` `--pushbullet-token`: (str) your pushbullet token\n* `-lid` `--list-id`: (int) the ID of your Discogs list (NB: either this or the `-wp` option\nare required). \n*  `-wp` `--wantlist-path`: (str) the relative or absolute path to your `wantlist.json` file \n(NB: either this or the `-lid` option are required).\n* `-ua` `--user-agent`: (str) the user agent string to use for anonymous queries to `discogs.com`\n(please change this to another string similar to the default).\n* `-f` `--frequency`: (int) how often you want the service to run (number of times per hour). \nThis value must be in [1, 60]  (default=`60`, meaning the service runs once a minute)\n* `-co` `--country`: (str) the country where you are (used for things like computing shipping) \n(default=`\'Germany\'`)\n* `-$` `--currency`: (str) your preferred currency (default=`EUR`)\n* `-msr` `--min-seller-rating`: (float) the minimum seller rating you want to accept \n(default=`99`)\n* `-mss` `--min-seller-sales`: (float) the minimum number of sales your accept a seller to have \n(default=`None`)\n* `-mmc` `--min-media-condition`: (str) minimum allowable media condition, as outlined above \n(default=`\'VERY_GOOD\'`)\n* `-msc` `--min-sleeve-condition`: (str) minimum allowable sleeve condition, as outlined above \n(default=`\'VERY_GOOD\'`)\n\nAnd here are the possible flags:\n* `-ags`, `--accept-generic-sleeve`: (bool) whether or not you want to accept listings with a \ngeneric sleeve (default=`true`)\n* `-ans`, `--accept-no-sleeve`: (bool) whether or not you want to accept listings with \nno sleeve (default=`false`)\n* `-aus`, `--accept-ungraded-sleeve`: (bool) whether or not you want to accept listings with an\nungraded sleeve (default=`false`).\n* `-V` `--verbose`: (bool) use this flag if you want to run the server in verbose mode, meaning \nit will log updates to the command line as it runs (default=`false`) \n\n#### Full Example\n\nTo clarify the CLI outlined above, here is a realistic example. In this case, we are replicating a user \nwho has their `wantlist.json` on their Desktop and who wants verbose logs,  no minimum seller rating, and\na global minimum media condition of `VERY_GOOD`. The command to run the service in this case would be\n```bash\n$ python -m discogs_alert -dt <discogs_access_token> -pt <pushbullet_token> -wp ~/Desktop/wantlist.json --msr None -mmc VERY_GOOD --verbose\n```\n\n#### Running as a `cron` job\n\nIf you aren\'t running `discogs_alert` in the background using the docker image, another good approach is to\nrun the process as a `cron` job. This uses the cron command-line utility to run the service at regular intervals.\n\nAgain, assuming you have specified the required environment variables, all you have to do is run `crontab -e` (to open the cronjob\nediting window) and append the following line to the bottom of the file:\n```bash\n* * * * * python -m discogs_alert -T >> <path_to_log_file>.log 2>&1\n```\nOnce you save and exit the file, `discogs_alert` will be run every minute and it\'s logs will be saved to the log file you\nspecified. You can then run `tail -f <path_to_log_file>.log` to check the logs of the running process.\n\nPlease refer [here](https://www.hostinger.com/tutorials/cron-job) for more information on cron and how to use `crontab`.\n\n\n## Contributing\n\n1. Fork (https://github.com/michaelhball/discogs_alert/fork)\n2. Create your feature branch (git checkout -b feature/fooBar)\n3. Commit your changes (git commit -am \'Add some fooBar\')\n4. Push to the branch (git push origin feature/fooBar)\n5. Create a new Pull Request\n\n### Setting up the dev environment\n\nIdeally, you should work inside a virtual environment set up for this project. Once that\'s the case, \nsimply run the following two commands to install all dependencies:\n\n* `$ pip install --user poetry`\n* `$ poetry install` \n\nAnd that\'s it! Until you want to push your changes and make a PR. When that\'s the case, you need to run \nthe tests to make sure nothing has broken, which you can do by running `$ poetry pytest tests`. \n\n## Changelog\n\nThe complete release history for this project can be found in [CHANGELOG.md](CHANGELOG.md).\n\n## Author\n\n[**Michael Ball**](https://github.com/michaelhball)\n\n<a href="https://www.mhsb.me" rel="nofollow">\n<img alt="home icon" src="https://github.com/michaelhball/discogs_alert/blob/main/img/home.png"/>\n</a>\n\n## License\n\nThis project is licensed under the GPL License - see the [LICENSE](LICENSE) file for details\n\n## Housekeeping\n\n<div>vinyl icon made by <a href="https://www.flaticon.com/authors/those-icons" title="Those Icons">Those Icons</a> on <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></div>\n',
    'author': 'mhsb',
    'author_email': 'michael.h.s.ball@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/michaelhball/discogs_alert',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
