#include <iostream>
#include <vector>
#include "bigint.hpp"
#include "SimHash.hpp"


template<typename T>
void check64small(T n, int base) {
    size_t s = sizeof(n) * 8;
    std::cout << "====check " << (std::is_unsigned<T>::value ? "unsigned" : "") << s << ", base=" << base << "==="
              << std::endl;
    auto t = bigint::itoa(n, base);
    auto c = bigint::atoi(t.c_str(), n, base);
    if (s > 64) {
        auto o = bigint::itoa(n);
        auto d = bigint::itoa(c);
        std::cout << (n == c) << ": " << o << " <=> " << d << std::endl;
    } else {
        std::cout << (n == c) << ": " << n << " <=> " << c << std::endl;
    }

}

template<typename T>
void check128small(T n, int base) {
    size_t s = sizeof(n) * 8;
    std::cout << "====check " << (std::is_unsigned<T>::value ? "unsigned" : "") << s << ", base=" << base << "==="
              << std::endl;
    auto t = bigint::itoa(n, base);
    auto c = bigint::atoi(t.c_str(), n, base);
    auto o = bigint::itoa(n);
    auto d = bigint::itoa(c);
    std::cout << (n == c) << ": " << o << " <=> " << d << std::endl;
}

int main() {
    const char *v = "175217521587616124467546910193601601183";

    unsigned __int128 n = 0;
    n = bigint::atoi(v, n);
//    n = ~n;
    std::cout << "size of int: " << sizeof(unsigned) << std::endl;
    std::cout << "size of long: " << sizeof(long) << std::endl;
    std::cout << "size of long long: " << sizeof(long long) << std::endl;
    std::cout << "size of n: " << sizeof(n) << std::endl;
    std::cout << "number: " << v << std::endl;
    std::cout << "itoa: " << bigint::itoa(n) << std::endl;
    std::cout << "itoh: " << bigint::itoa(n, 16) << std::endl;
    std::cout << "0x9F56E itoh: " << bigint::itoa(0x9F56E, 16) << std::endl;
    bigint::atoi(v, (unsigned __int128) 0);
    std::vector<unsigned __int128> vec;
    const char *args[] = {
            "42051104994139258118942948757380092102",
            "115500668239670441780171732429666432077",
            "63102502303061185953695408114602988923",
            "202083857812492002179563084814898178385",
            "126222923143006452248359041190647942913",
            "256861925082103443335871550417713334943",
            "313041531214763722150074919076641642950",
            "321079534687901442202950756653678487820",
            "227468283694519994958694479413018858302",
            "231418875346975353111124481157593448548",
            "256861925082103443335871550417713334943",
            "296811946180548347816357283252691083196",
            "165303613561475475781491362899829119935",
            "2449025636878415118544441536416177822",
            "210984332358786823538377311183785551469",
            "330938821210883710615521011170867857397",
            "143373499297714118109332641899072204587",
            "152657619753753130407672820658490943826",
            "56496666532001978087988056922629789816",
            "129225031005445212147837225307942214790",
            "2449025636878415118544441536416177822",
            "210984332358786823538377311183785551469",
            "330938821210883710615521011170867857397",
            "266493323281952602873877528082076354381",
            "105341935440056820500018093575841257389",
            "266052497142675405930199716329473782105",
            "2449025636878415118544441536416177822",
            "50478373786725969472968739983698982775",
            "68955308833981257909653495942423581347",
            "263732000469656201801401392217131575345",
            "2449025636878415118544441536416177822",
            "223055496230952111128117094655592350847",
            "21940203120563574837460016038132160812",
            "2449025636878415118544441536416177822",
            "270226671188106464621586066080740315447",
            "188967520547926627503710238257772769921",
            "2449025636878415118544441536416177822",
            "89762492327247816635969903897930764987",
            "18781203593125129336722884135059051449",
            "2449025636878415118544441536416177822",
            "316685112295962834850372516418354793749",
            "49124659561162638747331735309613047271",
            "208705029382316847604194044694069351224",
            "279455892696625487765973950741182352279",
            "232598020021967234495093262615386781689",
            "2449025636878415118544441536416177822",
            "338306649444009351446927119111019631243",
            "282552477228850782732958310643860046065",
            "56496666532001978087988056922629789816",
            "194639531915208578495127121069941984189",
            "29530944608110212741102660537730722723",
            "49957782598285310019151658372506452136",
            "297070332517950463210393247046717183906",
            "227468283694519994958694479413018858302",
            "29360493110378196128575221774843399125",
            "2449025636878415118544441536416177822",
            "170213831962391037828959581640042998358",
            "130237289125019244661989341583703420795",
            "63803345380476871380617855969950197145",
            "128245261432939537783830630715075587484",
            "222912507869830232813521811767362429470",
            "311551706743680878775090972628017275587",
            "219409197069224674865346234379038094981",
            "316155336838885753417148500362755614600",
            "202596031110325436916958313100901904063",
            "2449025636878415118544441536416177822",
            "185821098307828256561751903224487298575"
    };
    vec.reserve(67);
    for (auto &arg: args) {
        auto c = bigint::atoi(arg, 10);
        vec.push_back(c);
    }

    std::vector<int> weight;
    SimHash<unsigned __int128> sim(16);
    SimHash<unsigned __int128> sim2(std::string(v), 16, 10);
    sim.buildByFeatures(vec, weight);
    std::cout << sim2.string() << "\n" << sim2.hex() << std::endl;
    std::cout << "===================================" << std::endl;
    std::cout << sim.string() << "\n" << sim.hex() << std::endl;
    std::cout << "parts:" << std::endl;
    for (auto const &part: sim.getParts()) {
        std::cout << bigint::itoa(part) << std::endl;
    }
    std::string s = "1d5920f4b44b27a802bd77c4f0536f5a";
    n = bigint::atoi(s.c_str(), n, 16);
    auto r = bigint::itoa(n, 16);
    std::cout << s << "<->" << r << std::endl;
    check128small(n, 16);
    check64small(__uint64_t(17668899877662), 16);
    check64small(__uint32_t(1766887662), 16);
    check64small(__uint16_t(17889), 16);
    check64small(int64_t(1766890887689), 16);
    return 0;
}