"""
Subclass of ExternalToolConfigUI, which is generated by wxFormBuilder.
"""
from __future__ import annotations
import os
from typing import TYPE_CHECKING
import wx

from .externalToolConfigUI import ExternalToolConfigUI

if TYPE_CHECKING:
    from ..application import App

# Implementing ExternalToolConfigUI
class ExternalToolConfig(ExternalToolConfigUI):
    def __init__(
        self,
        parent,
        id=wx.ID_ANY,
        pos=wx.DefaultPosition,
        size=wx.DefaultSize,
        style=wx.TAB_TRAVERSAL,
        name=wx.EmptyString,
    ):
        ExternalToolConfigUI.__init__(self, parent, id, pos, size, style, name)
        self.externalTools = self.app.TopWindow.externalTools
        self._modified = False
        tools = [t['name'] for t in self.externalTools]
        if tools:
            self.listBox_tools.InsertItems(tools, 1)
        self.listBox_tools.Selection = 0

    @property
    def app(self) -> App:
        return wx.GetApp()

    def updateTextControls(self) -> None:
        selection = self.listBox_tools.Selection
        tools = self.externalTools
        if selection == 0:
            self.textCtrl_label.Value = ''
            self.textCtrl_command.Value = ''
            self.textCtrl_directory.Value = ''
        else:
            self.textCtrl_label.Value = tools[selection - 1]['name']
            self.textCtrl_command.Value = tools[selection - 1]['cmd']
            self.textCtrl_directory.Value = tools[selection - 1]['folder']

    # -----------------------------------------------------------------------------
    # Event handler
    # -----------------------------------------------------------------------------
    def on_listBox_tools(self, event):
        self.updateTextControls()

    def on_button_up(self, event):
        selection = self.listBox_tools.Selection
        tool = self.externalTools.pop(selection -1)
        self.externalTools.insert(selection - 2, tool)
        items = self.listBox_tools.Items
        item = items.pop(selection)
        items.insert(selection - 1, item)
        self.listBox_tools.SetItems(items)
        self.listBox_tools.Selection = selection - 1
        self.updateTextControls()
        self._modified = True

    def update_button_up(self, event:wx.UpdateUIEvent):
        event.Enable(self.listBox_tools.Selection > 1)

    def on_button_down(self, event):
        selection = self.listBox_tools.Selection
        tool = self.externalTools.pop(selection -1)
        self.externalTools.insert(selection, tool)
        items = self.listBox_tools.Items
        item = items.pop(selection)
        items.insert(selection + 1, item)
        self.listBox_tools.SetItems(items)
        self.listBox_tools.Selection = selection + 1
        self.updateTextControls()
        self._modified = True

    def update_button_down(self, event:wx.UpdateUIEvent):
        event.Enable(0 < self.listBox_tools.Selection < self.listBox_tools.Count - 1)

    def on_button_delete(self, event):
        selection = self.listBox_tools.Selection
        del self.externalTools[selection -1]
        items = self.listBox_tools.Items
        del items[selection]
        self.listBox_tools.SetItems(items)
        self.listBox_tools.Selection = selection - 1
        self.updateTextControls()
        self._modified = True

    def update_button_delete(self, event:wx.UpdateUIEvent):
        event.Enable(self.listBox_tools.Selection > 0)

    def on_textCtrl_label(self, event):
        self._modified = True

    def on_textCtrl_command(self, event):
        self._modified = True

    def on_button_command(self, event):
        fileName = wx.FileSelector(
            message="Select a Tool",
            default_path="",
            default_filename="",
            default_extension="exe",
            wildcard="Application (*.exe)|*.exe|All files (*.*)|*.*",
            flags=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST,
            parent=self,
        )
        if fileName and fileName != self.textCtrl_command.Value:
            self.textCtrl_command.Value = fileName
            

    def on_textCtrl_directory(self, event):
        self._modified = True

    def on_button_directory(self, event):
        folderName = wx.DirSelector(message='Select Folder', default_path='', style=0, parent=self)
        if folderName and folderName != self.textCtrl_directory.Value:
            self.textCtrl_directory.Value = folderName
