﻿from __future__ import annotations
import zlib
from io import BytesIO
from typing import Dict
import wx

artData: Dict[str, Dict[int, Dict[str, bytes]]] = {}

def addArtData(artId:str, client:str, size:int, data:bytes):
	item = artData.get(artId, {})
	itemSize = item.get(size, {})
	itemSize[client] = data
	item[size] = itemSize
	artData[artId] = item


addArtData('wxART_ABOUT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xbd\x1d\xe0\x13\xe2\xfa\
\xff\xff\x7f\x86\x86\x86\xc5{/W\xcf\xd9{\xfb\xf5\xcf\xbb\xef\xfe]\x7f\xf5\
\xf7\xcc\xd3?\xc7\x1e\xfe^x\xfa\xfd\xf6\xab\x9f\xde~\xfb7{\xef\'\x06\x839\'\
\x1e\xfc8t\xff\xe7\x9e\xdb?\xbe\xfc\xfcw\xf8\xc1\xaf\xbdw~l\xbb\xfe\xed\xfd\
\xf7\x7f\xdf\x7f\xff;\xfb\xf4\xcf\xd3O\xff\xde|\xfd\xf7\xe9\xc7\xbf\xa7\xef\
\xbf\xad=\xff\xe1\xee\xdb\x7f/\xbf\xfc\xbb\xf7\xee\xdf\xe9\'\x7f\x0e\xde\xfb\
\xb9\xfb\xd6\x8f-W\xbf\xae:\xf3\xee\xca\xcb\xbf\xb7\xde\xfc\xbb\xff\xee\xdf\
\xd5\x97\xff4\xe3\xce\x9c|\xf4{\xdf\x9d\x9f;o~\xdfx\xf9\xf3\xb2\x93\xafO>\
\xfes\xee\xe9\xdf\x0b\xcf\xfe^|\xfe\xf7\xd8\x83_\xbbn~_}\xee\xfd\xbcCOW\x9e~\
s\xec\xd1\xefSO\xfe\x1c\xbe\xffk\xfb\xf5oK\x8e\xbd\x9c\xbe\xeb\xfe\xfe\xbb?\
\xd6_\xfc4u\xfb\xad\xbe\xb5w\x9aV<jX\xfe\xb0c\xf5\x9d\xd9\xfb\x1f/;\xf1:\xbf\
s5\xd0_\x8f\x9f^\xb4\x00z\x93\xa9$\xc8\x0f\x18Te\x93\xcf\x82x\x8cI\xde\xee.\
\x0c\x1d\xac\xb2\x1e@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\
\xf4ue\x7f\xc8\xc1\xc7\xa5$\xc9\xafk\xea\x0c\x14\xda\xe4\xe9\xe2\x18"q9\xf6\
\xfcs\xbe&\x03\x11\xd6\x07\x87J7t-\xe2\xd8\xb1\xbd\x83\xa9\x8b\xb9 \xbf\xf6\
\xbf\xf9\xa6\xe6#G>\xbf\xfe\xe6\x9d_\xdc5\xc1A\xe9\x12\xc3\\\x01\xa7/3N\x8bw\
M\xe29\xe0\x18\x12\x12zxV\x9c\xd6\xe9\x03\x8e\xa6<=\x1b\xe3V\xce\xe2qY\x9a\
\x16\xf9\xa4\xcd\xd7\x81\x8d\xcbo\xef\xc5-\x9e\x1c[$\xb6\xcc\xf5\x9b\xbe\xe6\
\xcb\xaf\xe6\x87\x1d\x07+\x1e\xed\n\xe6?\xff\xacN\xc0(Bgq\xc6\xd3\x87_\x8f\
\xdd9\xc6#\xa4\xe9[.wO\xbe\xe9qg\x13\xc3\xa9\x9f>\xf7\x0eL\xffp\xaa\x9ac\xc2\
\x8f\xed\xbf\x1fK\xee\xdb\xb4\xcc\x85aR\xb9\xcf\xect\x07\xdd\xbe\xfa\xf9\xa7\
\x9f\xf0\xb7\xf0\xb7\xeb?\xee\x11`]\xda\x19\x93\x03t\xbdj\x89kDIJbI\xaaUrQ*\
\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\
\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x91)DC\xf3\xcd\x16=\xa0\x06\
\x06OW?\x97uN\tM\x00\x84\xa5T\x84' )

addArtData('wxART_ALIGN_BOTTOM', 'wxART_OTHER_C', 16,
b'x\xdaUOmHSa\x18}\xe6\xfcX3MSt\x16\x86\x05F$\x8b{\xe7\x96y\xe9G\xabM7\xd4\
\xe1\xc7\x82\x0c\xaa\x9b\xdb,\xc95\xd3\x9b\xa4\xf4#\xdb\x88\x8c\x10JE\tA\x7f\
\x84"\x9a \x84\xf9G\xb8%E\xa3\x08\xc3\xab\xa5\xf4\xb1\xa2,\xed\x03\xfb"\xa6\
\xd4\xe9\x1d\xf5\xa7\x1f\xcfs8\xe7<\x07\x9e\xd3Z\xea(L\xd0n\xd0\x12Q\x82\xdd\
f)g\x98\x12\x19\x8d\x9amk\xdb\xbd\xdf\x0c\xa2\x8f\x99K\xccD\xa3mgW\xcb\xda\
\x19\xcfr\xd9\xcaK\x88\x9a\xb3\x89\xce\xf9\x89\xc2`\xb8Ht\x9a#Z\x12\x89\x84n\
\xa2t\xdf\xd5#w\x0b\xd8\xedDi\xb1\xd3\n`c\xedT\x96\xf7\xe1\xc7\x9f\xd07)K?0\
\xf8\x04\xdb\xcf(\xef\xbe\xa3w\n\xdb\x1a\x95\xf1\x9a\xac7_\xd1\x1eD\xb6\xa4\
\x00/\x80i \x08\xdc\xc6/\x19\xab2\xc2rh\x19~\x19\x9b\xeb\x99;\x05d`5\n\xdf\
\x08K\x84\xd7\x849z\xfe\t\xd2\x182\xeb\x98;\x890a\x99\xf0\x9e\xf0\x920KxDs\
\x1f\xe0\xbe\x81\x0c\xaf\x82\xcf\x84\xb7\x84g\x04\x85\xf0\x80p\x87f\x17Q\xd9\
\x8f\xb4Z\x05+2\xe6\t\x8f\t\xf7\t2\xad\x8cR\xec\xa1`\xb1\xc5\xc3>\xcf\xe9\
\xed\xecbETR\xb9\xa3\x82\xf6,<\xad\x8e\x90\xaa\xa2B\x0b]\x8c\xc9\xb41\xb2\
\xa6\xceV\xd9@\x14\x9f\x12\x19\x15]\xeb\xd111N\xb2\x97X\xe3^i\x12\xb5[2\xd6\
\xe9M\xfb\x98\xe4\xb7[\xccN\xdd\xb4K\xec\xd3\x8a\x81\xa8\xadn\xbeZ#\x9a\xd3\
\\\x1e\xb5\xba\xd1\xcd\':\xb8PU\xe8\x82*\xb6`\xd3a.\xe4\n-\xa4\'\xa5\xaeOK\
\x8e\xb9\xd4\xda\xeao\x89V\xdf\xba\xdeq\xf3\xf2p\xcf\xee\xd2bs\xf2\xda\x0e\
\xddx\xe7~\xe7\x8cb2\xb6T\x1d\x9c\x17\xfb&e\xfd\xf0\xd0\x80O<\x1e\x9d\x9a\
\xbbS\xa5\xae\x88=\x99\x9b\xdf\x10_\x94s"\x95\x0fL\xf4\'\x89\xfe\x99\xae\xb1\
n\x1a\xd2]!\x1a\xeb\xd6Y\x06\xbf\x94E\neK\xd6\x03\x92\xfb\xa8\xe4\x11\\\xf5\
\x1e\x06d\xe0\xf8<=g\xd4\x1b\x0cN>O0\xe5\x0b<\x97\xc3\x19\x04\x8e\x1b\t\x9ej\
\xfe/\xe0\xf5\xb9k\xaa\x9b\xfe\x05v\xe9y\xa3\x93\xe7\x84\\\xa3`0\xfd\r\xf8\
\xe7\x02;X\x80\xecV\x87ed\xafx\xfe\x0f\xe4H\xfb\xce' )

addArtData('wxART_ALIGN_HCENTER', 'wxART_OTHER_C', 16,
b'x\xdaU\x91[H\x93q\x18\xc6\xdf-O\xadL\xd0\x0eZ\t\xd3X\xcc\xd9\xe2\xdb\xda\
\xb0>\x84\x9am\xba\xd16l\xed"\xa1h\xed\xe0\x0164\xfb\x8a\x14/\x86\xf3\xa20\
\xbc\xd0\x9b\x08A\xa8X\x8bT\x10,\n\xbc\xf8\x92\x94\x96^\x18~\x1d\x16&)\x1d\
\xd0VH\x07Bg=\xfdG\xddt\xf1\xbe\x0f\xcf\xc3\xfb\x83\x07\xde+\xb5\xce\x9a\\\
\xc5N\x05\x11\xe5\xda\xacf\x17\xd3\x82\xf4\xe4l`\xdb\xd23\xf9\x9bIF\x83\xc9a\
"\x1a\xe9\xe9H\x1d\xefc^\xe9\xb3\xba\x1cD\xed*\xa2p\x84h\x15L\x97\x88.pD\xcb\
\x1e"\xfe\x1a\xd1\x8e\xe6\xde3\x13\xd5\xecv\xa0\xd6\xee\xb6\x00\xb0\x9b\x03\
\x0f\x9a\x94\xc0<0\x0b\xc4\x81GH\x89X\x15\x81\x19\xa0\x08)9\xbe\x11\x16\t\t\
\xc2/\x11_\x08\xef\ts\x84)\xc28aM\xc4k\xc23\x82Hk#\xb4+8\x93\xfc\x89\xe5\x1f\
\xf8\xf8\x1d\xef\xbe\xe2\xed\n\xde|F\xe2\x13^,a{P\xba\xf3\x12\x033\xe8\x8b#"\
B\xb8\x0f\xff\x10\xea\xa2P\x86\xa6\xb5m\x92\xe6\x92\xa4\xbe(\xa9\x04\xa9\xa4\
U*n\x91\x8aBR\xd6i\xd6\x04\xe2\xb6\x85\x15VU&\xb8\x9c\'\xe8\xc8\x87W\xf5i\
\xe3=Vc\xa6\xcb\x99\xc5Vf6\xb6X\xeb\xce\x13m*H\x8f\x8c\xae\xf7\x17\xb20[\xb0\
9,\xd9\x0b9[\x14\xa5EyZ\xe3Q\x165\xd8\xcc&w\xe1\xac\xcf\x13\x96WWgm\x0e\x97L\
fd\xaa\xbd\xd3\xfb\x06\x83\xc9\xdd1o\xff\xa9\xb9\xca\xb1\x8e\x98w]\xdeY5^\
\x1a\xf3\xde\x18\xf3.\xe6\xf7\xda\xbb\x92\xa2\xd0\xbd5?\xdcm\x9bz\xf24^\xae\
\xd6h\xca\xca\xf6<v\xbb\x9fKF\x83\xf1\xdeh\xe3\xde\xe8\xd0\xcd\xbb\xb7\x9b=\
\x8d\xfe[\x83\xc1\xab\x87\xd7k\'(j\xc8\x93=\x9c\xafd?!\x95`9)\xf8\xcf\n\x01\
\xde\xd7\x1a`BzNW\xa1\xe5\x0cZ\xbd\xde\xad\xab\xe0\x8d\x87x\x1dW\xce\xe9y\
\x8e\x1b\x8e\x9fk\xff\x0f\x085\xfb\x9b\xea\xdb\xfe\x01\x07\xb5:\x83[\xc7\xf1\
\x07\x0c\xbc\xde\xf8\x17\x88$\xba\xf63\x80l\x16\xa7y\xb8\xca\xd3\xf9\x07\xc6\
v\xe6$' )

addArtData('wxART_ALIGN_LEFT', 'wxART_OTHER_C', 16,
b'x\xdaUO]H\x93a\x18=+K3,\xd6lj!,\xc1\x88b\xf5m9\xad\x8f.\xa6nm\xcb\xcdl\xae\
\x1f\ti\xba\x9f\x10\x14\xcd\xbe"\xa5\x8bH/\xeaFJC+\x82\xe8F\xf0"\xc1\x1b\t\
\xa1\xf8\xfaE)b\xe5\x87iT\xfe\xa5\xa6\xfd \xfd *vz\xa5nz\xe0<\x87sx\x0e\xcf\
\xf3\\.*t%%nJ\x04\x90\xe4q;\xfc\x82\r\xcbHX)\xba\xb3\xe9\xd9oAq\'s}\xb9@W\
\xd3\xf9\xc5C-B\x9bBn\xbf\x0f\xa8\xcf\x04.4\x00\xf3\x14<\r\x9c\x91\x80\x99  \
_\x07R\xaa\x9bO<\xdd/f\xef\x17y\x03N\x92^G\xe4^\x85\x89\xfc@\xf6\x93}\xe4C.\
\xa9\\T9\xaf\x9212\x8d\x8b+\xf8\x03\x9c\x01\xc7\xc0!\x90\x8f9\x0f\xce\x82\
\x9f\xc0ap\x00|\t~\x03\'\xc0w\xa0\x06>\x07\x1f\x81\x0b*\xdf\x82\xaf\xc0^P\
\xc5B\x176W\xc6\xbe\xccq\xe6\x17\xa7~\xf2\xe3w\x8e\xcc\xf2\xfdW\x0e}\xe6\xc0\
4\x8d\x95Z\xc7\x1b\xde\x8e\xb1\xa5\x8f\r*\x95n\x86\xef\xb2\xa4\x9d\xa6\xaa\
\x17\xe6:m\xfb9m\xdbY-S\xd1\xb6\xd4j\xe95ZZ\x95\xb6\xbaT\xdc\xc98\xe9\x8eM<\
\xa2S\xfc\x85\xc5\xb0O\x0eF\x97Ey\x81\xcb\x81K\xab\xd2\xddB\xac\xa9q\x97\x9c\
\x06\xd6\x1a\x96\xa1\xc3\xcd[\xa9\xc2\x8cW<>g\xfch\xc2\xba\xc4\x8c\xb4\xf5f[\
\xbe\xb0j<\x8e\xdc@j\x7f((*\x1cVa\xb7lM\xb5\x1bC\xd1\xb2Hhj\xc4\xa1\x1f\x1f\
\x9b\x1c\x9d\x18O\xb1\xeb\r\xc9\x1b\x8c\xfa\x8d\x06\x97>\xd4v\xe5Zs\xebU\xa7\
\xbee\xbc\xedhQ\xc0\x1f\xcd\x08\xee\xca\x9e\xeb0!\xcf{\xd8W\x9a_\\p\xdc\xe5J\
\xf1x\x0f\x0e\xab\xb1\xde\xc1\'\x8d\x0f\xca\xdb\xa3\x93\xc6\xd6#\x03\xd9==\
\xdd\x83K:\xec;\x90\xdc\xfa\xfaF\x9cN\xec\xceT\x9c\xc7\x94p\x99\x12\x91C\xb5\
\x11A\xb0J\x96\x1c\xb3\x94e\xb6Z\x03\x96\x1c\xd9\xb6W\xb6H;$\xab,I\x9d}\xa7\
\xea\xff\x0bTU\x87+\xa2u\xff\x02{\xcc\x96\xac\x80E\x92wg\xc9V\xdb\xdf@\xc3P\
\xe3N\x11\x80\xc7Y\xe8\xe8\xcc\x0b^\xfc\x03\xb91\xf8\xb7' )

addArtData('wxART_ALIGN_RIGHT', 'wxART_OTHER_C', 16,
b'x\xdaU\x8fkH\x93q\x14\xc6\x1fKSgv3\xbc\x14\xc2\n\x06\xa6,\xdewnY\xef\'\xad\
-\xb7t\xc3tA~\x88,/!8\xbc\xbdEJ\x91d\xc1L3H\n\x8b\xa04\n\xfc\xd0rEQ\x1f\x82U\
\x14\x0e#f{\xd1\x16\xdd\xe9\xa6]\xf0R\x84J=\xfd\xa5\xbe\xf4\xe1\x9c\x87\xe7\
\xe1\xfc8\xe7\xb4\x15\xb9\xf2\x13u+t\x00\x12\x1dvk\xb1\xd0\xa4\xb9\x8a\x9b/\
\xba\xad\xf3\xe1o!\xd1{\xf2\x9cy\x80\xbf\xf3\xc0\xec\xd6.\xe1\xf5\xe5\xf6b\'\
\xd0l\x00ZZ\x81i\n\x1d\x05\xf6J\xc0X\x19\xa0t\x03)\xb5\'w>\xd8,f\xef\x14\x15\
\xbam$\x0b\xad\x95\xb7\xaa\xf5\xe4K2L\x06\xc9\xbb\xfc\x15\xe0l\x80\xd3\x012D\
\xa6qv\x1e\xa7\xc01\xf0-\x18\x01y\x9f\xd3\xe08\xf8\t|\x05\x0e\x83\x8f\xc1o\
\xe0{\xf09\xa8\x81\x83\xe0=p&\xc0g\xe0\x108\x00\x060\xe3\xc7\xca\x9a\xd0\x97\
\x9f\x1c\xfb\xc1\x8f\xdf\xf9n\x92\xaf\xc7\xf9\xe2+#\x9f9<\xca\xe4\x1a\xado\
\x84\xe7C\xec\n\xb25@\xf5&+\xae\xb0\xf42\xf5\x9eG\xc6&-s\xbf\x96\xb1O3\xa8\
\xda\xaa\x06-\xbdNK\xf3h\x0bv\x88;\x19-\xf5X\xc4#Qj\xb1\xab\x04\xb9\x1f\x9eV\
\xcd\x99\xdd\x05\xf9Vxc\xd2\xed\xc2\xc4\xd7\xd9K\x1b\x81\x84\xa4\xb9\x8a\xc2\
\xd9s\xa9"\x8cU\x1dN[\xec\x9b\xb8E\xba\xd5i\x8b\x8d\x96M"\xf28\xacy\xee\xd4p\
yYnLG\x87\x94\x9c\xb4P\xdf._\xef\xbf\xe6o\xac\xeb\xf5\xd6\xd7O\x8dON$\\\xf0\
\xc6\xeb\xe2\xdb\xbd\xc7\xda.z\xfd\x05\xf6-\x8e\xc1\x81^opb0+#sM\xf6\xd2\xfe\
\x94\xf0\xc1\xcc\xb8\x96%%\xdbJFB\xda\x93\xe1\xa1!\xdb\xb2p8G2\x9b\xd6\xc9=W\
\xbb\xfb\xce\xdc>z\xe9\xd4\x8d\xe3>\x9f\xd1u\x08hp.?}\xc29\x15\x11\x8b\r\xaa\
m\xbbZ\xb1K\xadT\xca\x1b*\x85\xc0$\xc99F\xc9l4\x99\xdcr\x8eb\xd9\xa0\xc8R\
\x96dR$\xc9\x17\xaco\xfe\x0f\xf0\xd4VTW5\xfd\x03\xd6\x1be\xb3[\x96\x94l\xb3b\
\xb2\xfc\x05Z#G\xd6\n\x00\x0e\x9b\xcb\xea\xdbXv\xf8\x0f\x85{\xfd1' )

addArtData('wxART_ALIGN_TOP', 'wxART_OTHER_C', 16,
b'x\xdaUO]H\x93a\x18}\xdc\xa63k\r\xfc\xdbg"\xacbX\xd9\xe4\xdd\xe6\xd0>o\xb2\
\xb6\xdc\xc8\xc9\x9a\x0b\xf4"\x9b\xd3Y\x82\xa2\xd9\xa7\xa4\x14T\xd30\x14/\
\xf2F*\xc8+!(I\xa4\xe8\xf2\xd30\x922V~\x98\x8b~\xa5Pg?\xd2\x0f5\xa5N\xaf\xd4\
M\x17\xcfs8\xe79\x07\xces\xd1[^\xaaK\xd9\x92BD:\xb7\xcb\xe1\xe3\x98\xb6>\xc9\
j\xbe\x9d\xfd\xf7\x7fs\xd0\x1c+\xf1\x94\x10\x8d\xf6\x9f^;4\xc0\xb9\xb1\xd6\
\xe5\xf3\x10u\x9a\x88\xce\x86\x89\xe2\xe0\xb8D\xd4\xc6\x88b\x01"q\x90\xc8\
\xd0|\xe9\xe8\xe4\x01\xee\x95\xbde~\'\xc0-T\xe6\x08\xddm0f7F\x8cM\x8f\x80W\
\xc0\x0c0\x05\x8c\xe3\x97\x8c5\x19q\xf9\xc3\x0f\x98;\x14 \x02daM\x85\xaf\x84\
\x18a\x9e\x10\xa5\xd8w\\\x7f\x86]\xa7\xf8\xf5\x1e\xe2\x84\x15\xc2"\xe15a\x96\
\xf0\x98\x16\xbe\xe1Z\x04;\xda\x15|"\xbc\'\xbc (\x84\x87\x84\tz\xf7\x05\x03S\
0I\nVe<\'<!< \xc8\xb4:JoV\x10\x96\xb1\xb5Uy\xf9\x11\xd2\x1d\xe4\xb4(\xd1e\
\xd4\xddDV\x932\xbb\x84\xaaad6*IGxCT\xbb\xd3\xcf\xf0\x07T\x92\xaf\xbc\x82\
\xa8}`\xba\x88\xb3\x84\xe0\xc1R\x07\xf5$\xe6\xb88\xd9\xd0\xe2\xaa:I\xb41m}\
\x12\xe8\xf2U\x81\x8bZ\xc9\xedqj\xdf&oN\xd9\x96\xa57\xdb\xf7s\xe9\x82\xdbQ\
\xe2\x17fj\x03C\xc4jT7\x82sd\xdb\xc4n\xedM\xc8S\xdb\xb2\x8b\xb5\xb9\x86B\xbd\
\xb7\xcf\xa0\xfa)\x0c\xc6\x135\xdd]N\xc7\xb9`p>`\x1c\x97w\xef4\x99\xb7\xe7\
\xe5\xea\xd3+\xbc\x1a\xb5)\xa9>?\x94q\xd8\xde\xa6\x1b\x1a\x1c\xce\x14\x8e\
\xdb\xd8r\xcfbl)[PM\xf6\xf5\x8d\xcb\x9ahu\x85\x8d\xb1\xd2\xd6\x8c\xden\x93Pi\
a\x13\xa4\xee\xbd\xad\x13\xe6RS\xc7\xba\xa98\x18\xd6\xd3\xf4\x95\xd4\xa7\x0b\
C\x91\xcf\xbc\x91IrVJu5RH\xacm\rq +\xb3\x14\x9aY\x81\xd9j\xf5[\nE\xfb\x1e\
\xd1\xc2\xf2\x98Udld\xeaD\xe7\x7f\x81\xa6\xe6\xba\x86\xfa\x8e\x7f\x81"\xb3\
\xa5\xc0oa\xa2\xad@\xb4\xda\xff\x06\xc2\xd1\xae|\x1e \xb7\xb3\xdc1\xb2/p\xfe\
\x0f\x8c\x1b\xf8C' )

addArtData('wxART_ALIGN_VCENTER', 'wxART_OTHER_C', 16,
b'x\xdaU\x8e]hRq\x18\xc6_\x9dm\xeaX\t\xebc\x16\xd2\xd9\x86a\x0e\xe3\x1c\xd3\
\xb6\x0e\x11\xdat*MYf\x90\xd0\x87\xcd\x8f6\x98l\xadc4i\xa1\xd9\x85\x15\r\xd2\
\x9b\x11\x83\xac\x8b\xa0\x8bm\x8c>\x88\xe8\xe2P\xb3\x90"\x84\x9dVFEE\x1f\xb8\
U\x8c\xd8\x08\'\xf5\xf6\x97\xba\xe9\xe2y\x7f<\x0f\xef\x03\xcf\xb9.\x97\xadN\
\xbe^\x0e\x00u\x0e\xbb\xc5MX_\x91\xb4\x8a\\\xeb\xc8\xa3\xdf\x04\x92\xa3f\xa7\
\x19`j\xe4TyO\x9ax\xcaow;\x01\xa2j\x80X\x02\xa0\x84\x84E\x80\x08\r0\xe7\x03`\
G\x01\xd6\xf5\xa7\x0eg;\xc8\xef\xb5\xaeN\x8f\x15\x117\xf4\xe5\xa9\xf0\xd3\
\xaf?Q7$\xdc\xed\xa5\xe6\x96\xf0\xc6\x0b\xd4\x9e\x14\x10\xdf"\xce \xe6\xb0\
\xccc\x89\xff\xb2\x88W\xf2\xa89A\xf2<\xa2\x12\xcbb\xfc\x00X\x80\x8f?0\x9dC5\
\'tZ\x82\x88\x0f\xb1\x04\xb8\x008\x0b\xf8\x0c\xde-`\x82\xc7\xc6A\x01\x7f\xf1\
\xf8\x1d\xf0\x13\xe0\x13\xc0\x07\xf0\xe6\x1brwP5 \xe02\x8f\xaf\x00yX\x9e\x82\
\xc2<\x06\xc6Q\x19\x16f\x8b\xe8\xbd\x8ek\xfb\x84\xea\x8392o~\xbc8L\xd6\x8a8\
\xb7k/\x98>\xbf\x0cUL\xf7n\x9b\x05\x92+Tvbd\x03v\xefq\x80\xda\xfa\x8aDpy\xac\
\x81\x845\x9c\xc3i\xady/])oR\xae\xd2\x19\xdbI4\xec\xb0\x98=\r3~_F\xee\x93Tm\
\xf20!\x85Ot\xd3\xdb\x18\x8b_\xba\xa8\x92\xb6Q\xddc\x07^\xef\xb8obv\x9e\xa6\
\x14\xb1\xa4L.\xbb\x90\x14g\xa7\xa7\xe3&\xb1\xa6isN\xab\xd65\xb7<\xd6\xe64\
\x93 9\x9fJQ\x8c:\xb8f\x9f13z\xafZ\xd1#\xce\xc6\xa2\xb7-\xb7"\\<\xba\xb4\x18\
\xe7\xe1\xf9\xa1\xf6f\x8a\xee\x88l\xdc\xc6\xf8\x15\xf4UWF!\x86\xd5\xc6\xda\
\xb4\xadG\x19#C\xd4\x9cu?\x178\xc2\x05Y\xff`\x90\x00\xf44\xd3\xaa\xa3\r:\xbd\
\xde\xc3\xb4\xb2\xc6\xed,C\xb7\xd0z\x96\xa6\'r\xc7\xa2\xff\x15\xc2\xfd\x81\
\xde\xd0\xd0\xbfB\x9b\x8e1x\x18\x9a\xddj`\xf5\xc6\xbf\x85D\xe1\xec\x16R\x00\
\x87\xd5e\x99\xd8\xe5;\xf3\x07\x9eQ\xe5!' )

addArtData('wxART_ANCHOR', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4'x\xba8\x86X\xf4\
\x1e\x9d\xec\xc8w@\x81\x83%\xdd\xf7\x7f\xee\x9f\x8a\x97K\xd9M&]\x98\xb4\xac\
\xfa#C7\xf3\n\x17\xdf\xb5/\xfa\xb9K6\x08\xafi\xde\xab&!\xda4{Q\x98\x82s\xc1\
\x8e\xdb\xcb\xe2\xd85\x84\xb3\xf52\xad\xc2\x1f\xeb\xf1)\xe4N\x9a/\xa0Q\xe5q\
\xef\t\xef\xea\x7f\xf7\x9df*\xccq\x0c\xbb_\xbbl\x8d\xde\xc9\x93\xa2\xd3\xda\
\xea\x0f\xcb\x00\xedb\xf0t\xf5sY\xe7\x94\xd0\x04\x008\xc49\xac" )

addArtData('wxART_ANCHOR_ADD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd\'\x91\x15\xc8WH\xf6\x08\xf2\
e`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x10h``\xf8\x0fD\xff\xff\x97\xdc\xda\
\xf8\x05\xc8g,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\xe4\xb0\x97x\
\xfa\xba\xb2?\xe4\xe0\xe3R\x92\xe4\xd75u\x06\n\xe9{\xba8\x86p\\ONp`ez\xc1\
\xe3\xe8\xc8\x98"\xa8\xa6*q\x98C\x8bG\x88\x91Q\x95U\x80\x89)\x95\x955\x95UDp\
\x87\x94O,\xd01g\x1f1K\xde+uR\x05jU-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\
\xba\x06\x16@\x14bhfejhed\xa2m`de`p\x8b\xefc9\x8a\x86\xdc\xfc\x94\xcc\xb4J\
\xb8\x06C\x93\x10C\x03+c\x13+#S\x88\x86\xe6\x9b-z \xafy\xba\xfa\xb9\xacsJh\
\x02\x00\xc5\x86R\xe7' )

addArtData('wxART_ANCHOR_LOCK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xd7y\xba8\x86X\xf4\
\xee\x9dt\x91\xafA\x81\xc3\x95\x7f\xed\xff\xb2\x7f\x15_&HY\x15\x89E\x7f\xef\
\xe4\x8c\xe3[\xc1a\x98{/\x91\xc9\xd6A\xf8\x85:s\x83\x8c\xa2\x86\x88ash\xd3\
\xde\x92\xd7ig/\x94Y\x9f6m*\x117\xbf\xd9\x1d\xb7\xcfx\xc5\x0e\xb1\xdbe\xb7\
\x1c\x8c:\x18\xac\x04:\xbf\xf3\xe7|\xcfZ\xb2\xe0\xd1\x91\xff{\x9c\x8e\x86\
\x05H\xefW\x9b\x90\xfd$/\xab\x9c}\xf1\xb1\xa3\x91\x87\xdd\x9bBu\x05\xcf\x88\
\xa8Y0\x9a\xbdP\x9e\xb5mVJ7\xd0%\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\xb1\xc7Fp\
' )

addArtData('wxART_BLANK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaa\xd4\x18\x18\x1aZ\x18\x18~\x01\x85\x1a^00\x94\x1a00\xbcJ``\
\xb0\x9a\xc1\xc0 ^0gW\xa0\rP\x82)\xc9\xdb\xdd\x85\xe1\x7f{\xff\x99\xfd@\x1eg\
\x81Gd1\x03\x03\xdfa\x10f<\x9e\xbf"\x05(\xc8^\xe2\xe9\xeb\xca\xfe\x90\x83\
\x8fKI\x92_\xd7\xd4\x19($\xec\xe9\xe2\x18\xa2q>\xf9\xcf\xf9\x06y\x03\xc3\x1e\
-\tG.\x06\x03yFy\xae\xbfB\x8b\x80\xd2\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\
\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\
\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\
\x06V\xc6&VF\xa6\x10\r\xcd7[\xf4\x80\x1a\xa4@\x1a\x82\xf3\xd3J\xca\x13\x8bR\
\x19\x02\x123\xf3J\xf4\xfc\\C\x14\xca\x8c\xf5L\xf5\x0c\r\xdd?;\x99\x03U1x\
\xba\xfa\xb9\xacsJh\x02\x00\xf9\xfbS_' )

addArtData('wxART_BOLD', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xce\x0c\xf0\tq\xfd\
\xff\xff\xff\xe4E\xdb\x81\xa4\xa1{\xe6\xdf\xbf\x7f\xf7\x9f\xbc\xfd\xe3\xe7\
\xefg\xaf?3\x18\xcc`1\x9e\x15W\xb3\xef\xde\x93\x0f\x7f\xff\xfd[\xb1\xe36\xbb\
\xd9\xec\x97o>\xfd\xfc\xf5\xe7\xe3\x97\x1fO^\xbc\xbf\xff\xe4\xed\xad\x87\xef\
\x13\xeb\xf7u\xce?{\xeb\xc1\xab\xa8\xca\xdd\x17n\xbc\xb8q\xef\xe5\xe5\x9b\
\xcf~\xfd\xfe\xf3\xfe\xd3\xb7W\xef>\xaf\xday\xcb)u\xe3\xb9\xab\x8f\xbf~\xfb\
\xf9\xe2\xcd\xa7\xc7/\xde\x9f\xbc\xf8\xe0\xc3\xa7o\x1f\xbf|\xbfv\xf7\xd5\xe4\
\xe5\xe7\xd9Mg\x1d9{\xf7\xf5\xbb/\xcc\xc63\xfd\xf2\xb7\xee<r\xfb\xd9\xab\x8f\
\x0f\x9f\xbd\xbb\xfb\xe8u@t\x89\x0f\xd0\x91\x8c%A~\xc1\x0c\x0e\xcfn\xa4\x818\
I\xde\xee.\x0c\x1d\xac\xb2\x1e@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\
\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\xc9\xafk\xea\x0c\x14\xea\xf2tq\x0c\x91\
\xb8\x1cz\xfe\xa6\xd8A\x03\x91\xd6\x87s\x96$.^ud\xc6\x8c\xae\x19I\xab\xbe\
\xd7[L]\xf01\xbeN\xbcz\xedY\x89\xab\x86\xf2\x1f\xf3U\xfe)*j&yH]\xf9\xe2$\xf3\
>\xea-\x1f\xa7\xe0\x02\xa1ye\x13\xbfv\xd4MxV\x9b\xc2\x1c\xeal'\x93\x9al\xbar\
a\x96\xd5e\xb5\x036\xacb\xa7E\xaf-\xe3\xd8p\xb2\xf1\xad\x1fc+\xef\x06{\x06\
\xf7\xd2C7w1\x88\xdb\x17\xee\xbd;\x97\xe7\x83\xc6\xfc\xa8\xd9\x87\xac~6\x1a\
\xfdz\xedxd\xa3x\x03\x03\xc73\x197\t-\xa0\xabTK\\#JR\x12KR\xad\x92\x8bR\x81\
\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\
\xb1\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\
\x0c\r\xac\x8cM\xac\x8cL!\x1a\x9ao\xb6\xe8\x0150x\xba\xfa\xb9\xacsJh\x02\x00\
\x01 \xfa(" )

addArtData('wxART_CDROM', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd\'\x91\x15\xc8WH\xf6\x08\xf2\
e`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xb9\x00\x9f\x10W\x90\x82\x86\x86\xff\xff\x19\x0e\x1c8\xc0\
\x00\xa4\x80\xe0?\x90\xfe\xcf\xd0\x00"W\xe8\x96_\x03\x8a0\x96\x04\xf9\x0538<\
\xbb\x91\x06\xe2$y\xbb\xbbp~\xbc\xb9\xf4\r\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0w\
\x18\x84\x19\x8f\xe7\xafH\x01\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\xe4\
\xd75u\x06\n%y\xba8\x86p\\ONp`\xebi\n\x88\xf2\x90<$T\x18d\xc6\xc7`xd\xce\x94\
\xb3\x8e<n\x9b\x8f\x1cH\n\x168l1\xf5\xaa\xc4!\x03\x9e\x123\xd6,Q\x113\xf30\
\xc1T\x01}}q=3?\x9e\x04\x01s33\x113>V##\xa7\xc6\x03\x02*Aqq9<)\x1cN\x0e\x0c\
\xcc\xd9\x1a\x12\n1\x0c\x0c\xea\xb1B\xd5\xdd\xca\'\xbe\x03mS-q\x8d(II,I\xb5J\
.J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\
\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb122\
\x85hh\xbe\xd9\xa2\x07\n$OW?\x97uN\tM\x00\xfaou{' )

addArtData('wxART_CMD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\
p\xb2\xa7\x8bc\x88\xc5\xe9\xe4\x04\x89\x8c\x037\xec3\x7f\xd5{\xf1$$&$$\x14\
\x14~WYQ\xf0\xaa\xa9\x97\xe7&\xe7?\x8d-\xbbT\xa4\x8f\xb0^\x0bKK\xb9Y\xf7\xe5\
\x86f\x07\xf7\x19\x9f\x9e\x93F\x0b\xea/\x95\xb0\xa9y1\x0b\x1em\xf8\xff\xff\
\xbf\xf1\x9f\xff\xfd\x92\xcbn\x1c1\xe0\xf9\xf1\xff\xbf=\xb3\xb2\xb22\x08\xc7\
0\xdb\xf5F\xc42\xf4G\xbb\xb9\x89H\xcdO\x8c\xe0u(g\xdc\xe4\x18q\x99\xd1Gp\x17\
[\x8e\xd4\xc5\xab\x1b\x12\x8a\xad6\xde;\xf4\x92u\xd2\xe4\xa2\xffK^2O\x97f4\
\xd35[\xf8\xdd\x81\x83\x03\xe8<\x06OW?\x97uN\tM\x00YuOn' )

addArtData('wxART_COMMAND_LIST', 'wxART_OTHER_C', 16,
b'x\xda\x01"\x01\xdd\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\x00\
\x0e\xc4\x00\x00\x0e\xc4\x01\x95+\x0e\x1b\x00\x00\x00\xd4IDAT8\x8d\xa5\x92A\
\x0e\xc3 \x0c\x04w[r\xe9\x81/\x86\xa7\xf0\x14\xf8Y\xde\x90\x1e\x13i{h\x9c\
\x92\x10P\xab\xfa\x02\x08\xcf\xd8FP\x12\xfe\tg\x1b\x92\x95I\x12\xbf\x16H"I!\
\xc6\xfd\xd2\xa4=\xd1\xad\xaaX\x08l\x7f\xd5\xdd^\xe4\xea\r\xce\x9d F\xa4\x94\
\xaa\xbc\x10B-\xc89k\x9a\xc2\x9b?I$aY\x16\x91|\x02\xc00\x0c\xfe 0\xf80\xc1\
\x85\x84$$\xcd$\xbd\xeb\xc1\x96\x8c\x18\xcb1\xd6\xb2\xa8k\xc1[\xf2,\xc9\x93D\
J\t\xe38\xae$\xddA\xd0\xa8\xcc\x9c\xb3e\xcd\x05\xf0\x90\xb4\x96o\xe6\xae\xe0\
2\x81\xa4/\xe6\xb6u\x97\xb8\x1e\x0c\x00\x92\xe6m\xb5\xf3\x03\xc0\xfd h\xc1\
\xd6\x81\tH\x9a\xe43B\x0f.;8\x81~\x17\xf4`\xab\xde\x08\x0f4\xbe\xf2/\xf1\x02\
\xd4\xf1\xb4\xf2\xc1Z\xf8\x89\x00\x00\x00\x00IEND\xaeB`\x82\x19\xe7w_' )

addArtData('wxART_COMMENT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaau\n\xf0\tq\xfd\xff\xff\
\xff\xe4E\xdb\x81\xe4\xd7o??|\xfaf\xe8\x9e\t\xd4\xf1\xf7\xef\xdf\x1f?\x7f\
\xbf~\xf7\xe5\xd9\xab\x8f\x0c\r\x0c\xf7\x9f\xbc\xfd\xf5\xfb\xcf\xc3g\xef\xee\
>z}\xe3\xde\xcb\xcb7\x9f\x9d\xbb\xfa\xf8\xe4\xc5\x07G\xce\xde\xdd\x7f\xf2v\
\xf3\xfc.Q\xa0i\x8c%A~\xc1\x0c\x0e\xcfn\xa4\x818I\xde\xee.\x0c\x1d\xac\xb2\
\x1e@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\
\xc1\xc7\xa5$\xc9\xafk\xea\x0c\x14\x8a\xf3tq\x0c\x91\xb8\\\xda\x1f\xc9\xd7\
\xa0\xc0\xc3\xea}3\xf0`\xef\xef\xf8P\x8d\x05\x02\x87k\xce\xbdVa8\xc0\xc6\xd0\
\x90\xd8\xcc\xad\xb69@\xde\xf5J\xac\xf4\xebU\x01+\xce8]Q\x91|sTz\xc7V\xd5_\
\xd3g8\xe6\xc4D\xbc\xae\xb9\xd1_\xfc\x89ob\xda\xad\xf5\xd5E\x13\x8bo%\xeb\
\x1c*\x9f\xaf\xaaX\xfd\x80\xb1\xea\x1ekB\x81WN\x0b\xd0&\xd5\x12\xd7\x88\x92\
\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\xaek`\xa2kd\x14bhnehbel\xa9m`de``\x13|\
\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\x10C\x03+c\x13+#S\
\x88\x86\xe6\x9b-z@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\xfd(\xa4\xbc" )

addArtData('wxART_COMMENT_BROWSER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5~\x08\xf0\tq\xfd\xff\
\xff?CC\x83H\xda\x01\xe3\xe9og\x9d\xfa\xf63\xd7@\xd2\xa1\xef;\x10|\xfb\xfe\
\xf5\xdb\xf7\xcf_\xbf\x7f\xfe\xf2\xed\xe3\x97o\xef?\x7f{\xfb\xf1\xdb\x9b\x0f\
__\xbd\xff\xf2\xfc\xdd\x97\xa7o\xbf<y\xf3\xe5\xd1\xeb\xcf\x07\xef\xde=\x00Dw\
\xee\xee\xbb}w\xdf\xad\xbb\xbb\x81\xe8\xe6\xdd\x9d7\xef\xec\xb8qg\xdb\xb5\
\xdb[\xae\xde\xde|\xf5\xf6\xc6+\xb76\\\xbe\xb5\xff\xce\xdd=\xb7\xee\x86\xaf\
\\\xb3\xf9\xea\xadMWno\xb8rk\xd7\xcd;\xdb\xaf\xdf\t]\xb1z\xef\xed\xbb\xeb/\
\xdd\\{\xe9\xd6\xd6\xab\xb77\\\xbe\xb9\xf6\xe2\xcdMWo\xad\xbeps/\xc8\xb4;;\
\xae\xdf\xdev\xedN\xc8\x8a\xd5\xeb.\xdd\x0c^\xbez\xc7\xf5;\xdb\xae\xdfY\x7f\
\xe9\xd6\x9a\x8b7W]\xb8\xb9\xf2\xfc\xcdw\x9f\xbe\xbe\xfd\xf8\xf5\xf5\x87\xaf\
/\x81n{\xfb\xe5\xf1\xeb\xcf\x0f_}\xbe\xff\xf2\xd3\xbd\x17\x9f\xee<\xfft\xeb\
\xd9\xa7\x1bO?]\x7f\xfa\x11\xe8M\xa0g\xed=\x9bO\x00\xfd\xeeW\x12\xe4\x07\x0c\
\xbfg\x98\xe05\x1a\xf8\x8aD\xc2\x85\xa0\\\x14\x8d\x92"R\xbb\x81&3&y\xbb\xbb0\
t\xb0\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\
\xbd\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92\xd44\x95\x94\x9f@\xa1\xe5\x9e.\x8e\
!\x12\x97S\xcf]\x17j2\x10h}(Q\x1d\xfe\xc6K\xd0U$\xe4\xcd\xde\xefu\xf7\xfe\
\x17\xfaH\xecu\xf8\xbf\xf7wZ\x99\xb0S]q\xa0\xbb\x9e\xd3\xdd\xf969{\xf2\xbcV\
\x9c\x97\\\xf8\xcf\xc1@\xa4\xcf%\xf9\xa3K\x90\xc7R\xc9\x94M;k\x16F\x08\xa9Fj\
\xae\x16\xe5[\xe1\xa4\xcd\xb8\xe2\xe5W6\xf6\x0f<3\x8c\xbe\xa8\x1dX\xd0%\xc6#\
\xb8\x89I4\xf74\x1b\xef\xa2\x96\xbe>\xbd5\xf7\xca\x8f\xb6\\zn\x90`p\x84\xe31\
\xe7\xe1\x979y\xf7/\xb8=J:\x19\x1f\x13\xf9\xfa\xec\xb4\x83y\xf5\x16\xf3Z>?\
\xad\xdam?O\xff\xfe\xff\xeb\xf5\xd5\xcc\xbe{e\xdegZ\xb3&\x03\x9d\xacZ\xe2\
\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\
\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\x99\
V\t\xd5`\xa1kh\x12bh`elbed\x06\xd1\xb0\xc9p\xdef\xa0\x06\x06OW?\x97uN\tM\x00\
\xd1\x99\x9b\x91' )

addArtData('wxART_COMPILE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xb2\x06\xf8\x84\xb8\xfe\
\xff\xff\x7f\xf2\xa2\xed@\xb9\xc7\x81\x0cw\x9c\x19\x80\xdcg\xe1\x0c\xf7=\x18\
nX2\x18\xbag\xbe\xcffx\x11\xc3\xf0\xd0\x8f\xe1\x96\x1d\xc3e\x03\x86\xb3\xca\
\x0c\xc7\xc5\x18\xf6\x9f\xbc\xfd$\x98\xe1\xae\x0b\xc35S\x86\xf3\x1a\x0c'\xa5\
\x19\x9e\xbd\xfe|\xc3\x9a\xe1\xa2\x0e\xc3iy\x86Y;\xce\xdfy\xf2Z3f\xe2\x9d\
\xc7\xaf\x97\x1e\xb9~V\x95\xe1\xc2\xaf\xff\xbf\xff\xff\xff\xf2\xff\xff\xde\
\x0bO&\xaf?q\xf5\xff\xffe{/9$5\xa5f5<\xff\xff?\xa6\xa8\xf5\xd1\xab\x0f\x0b\
\xe6/\xad\xec_\xbc\xe5\xd4\xad\xec\xce%\xb7\xbf\xfe\xbe\xfc\xf0\xd5\xc3\xff\
\xff\x17\xcc_\x96T7\xfb\xc0\xfd\x8f\xf7\x9e\xbe\xbd\xf9\xff\xff\xdd_\xff\xf3\
*:\x96\xec:\xdd\xb0t\xf7\x96\xab/\x16\xae\xda\xdd0w\xe7\xda\x8b/\x8e\xbc\xf8\
?q\xe1\xd6\xde\r\xc7\x0e\xde}\xbf\xea\xc8\x8d\xe6\rW#K'E\xf6\xeei\x9f\xb6\
\xf1\xf5\xff\xff\xdb^\xff?\xfd\xeag\xf7\xf2\xbd\xbf~\xff\xf1/_T\xb1\xf0\xf0\
\xc4\xf9k6\xdfx\xd75u\xe9\x92]\xc7c*\xa7\xcbEL,\xff\x97h\x05\x0c<\xc6\x92 \
\xbf`\x06\x87g7\xd2@\x9c$ow\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x98\x81\x81\
\xef0\x083\x1e\xcf_\x91\x02\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$5M%\xe5'Ph\
\xb5\xa7\x8bc\x88\xc4e\xdfsW\x85\x0e\x19\x08\xb0^`\xe1\x08\xb8c\x9bQ\xb8|Gv\
\x97\xd8\xf3\xff\xf6\xad[\x14e\xdf]>7s\xf7fn\x86\x86,\x1e7\xe1\x96\x06V%\xa9\
\xcdG\xbb\x16,h>\xfb\xae`\xd7\x1d\xb9\xf5\x0b\xcck\xfe9\x18\xb0\x1c\xf6\xd92\
\xd5\xc3\xc4-\x9c\x85\xed#\x8b\xdf\xb2KZ\xca\xbc\x05l\xa9\xc5J\xd7\x14\xe3\
\x1d\x8e\x06\xedT\n\xb3\xbc\x12\xb0\xb7q\xd6\xda\xb2v\xe6i\xbbJ^}5l?X`\xe26\
\xf9e\xce\xb9\xc4\x8dS\xc2^\x9f-s\x7fb\xbb\xbf\xc8b\xde9\xf1\xa6\xa9\xaf{\
\x19w\xd8\x7f\xf8\xac\xaa\xedR\xf9\xdf\x81;\xb7\xe6\x84=\xc3'\xb5W\xaf\xe3\
\x8f\xcf\x14\xb9\xd8\xf8\xcd\xc6\x07\xe8l\xd5\x12\xd7\x88\x92\x94\xc4\x92T\
\xab\xe4\xa2T \xc5`d`h\xaek`\xa2kd\x14bhnehbel\xa9m`de``\x13|\xfa\x19\x8a\
\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\x10C\x03+c\x13+#3\x88\x86M\x86\
\xf36\x0350x\xba\xfa\xb9\xacsJh\x02\x00T\x94>\x95" )

addArtData('wxART_COMPONENT_ADD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc4\
\x0c$\x93\xe6\x8a\x7f\x02R,\xe9\x8e\xbe\x8e\x0c\x0c\x1b\xfb\xb9\xff$\xb2\x02\
\xf9\n\xc9\x1eA\xbe\x0c\x0cUj\x0c\x0c\r-\x0c\x0c\xbf\x80B\r/\x18\x18J\r\x18\
\x18^%00X\xcd``\x10/\x98\xb3+\xd0\x06(\xc1\x13\xe0\x13\xe2\xca\xc8\x00\x02\
\xff\xc1 .\xdc<\n\xc8a,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\x16\xe4\xf1\x01\xd9\xc6\
^\xe2\xe9\xeb\xca\xfe\x90\x83\x8fKIj\x9aJ\xcaO\xa0\x90\xa5\xa7\x8bc\x08\xc7\
\xf5\xe4\x84\x06&v\x89\x83R\x87\x0e\x1c\xe0H\xdah\xc1\xc0\xa9\xc8\xb8`\x82;w\
\x80G\xa0\xa0\xc6\x95G\x0f\x19D\x98\xb8\xaa,6l1\xe002\xe02\xd8\xe0\xf0\xd5\
\x89\x81\xe1&\x1f\xeb,\xcd\xc47\xca@CTK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\
\x91\x81\xa1\xb9\xae\x81\x05\x10\x85\x18\x9aY\x99\x1aZ\x19\x99h\x1b\x18Y\x19\
\x18\xdc\xe2\xfbX\x8e\xa2!7?%3\xad\x12\xae\xc1\xd0$\xc4\xd0\xc0\xca\xd8\xc4\
\xca\xc8\x0c\xa2a\x93\xe1\xbc\xcd \x1fz\xba\xfa\xb9\xacsJh\x02\x00\xf2\xf1Z\
\x83' )

addArtData('wxART_COMPONENT_LOCK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xd7{\xba8\x86X\xf4\
.\x9d\x1c\xc8\xd7\xa0\xc0\xe3\x1c\xfdh\xef\xcd\x93s\xe59\x14\x8bs\xb4\xbc;\
\x16\xbc]\xcc1\xe1\xc6j\xa1\xda\x10\x87zf\x91\x00\xa63\nz\x0b\xbc\x8c\xe7\
\xaf\xf2j\x08e\xe2\xf0u\x9e-y\xeb\xcc\xe3\x9b\xf7\xed\xbfL\xac4-cT\xdaw\xc3)\
\xa6A\xb4t\xc6v\x9b\xd9\x8f&\xdf|{~\xd9\xd5\xfe.\x06\x19\xc3w\xb5\xed\xc1\
\xab7;4\xa4\xcaU(eo\xd8\xa5l\x9c\xeayh\xf7\x87e3\x9e\xf9eY\x1fd\xdd!\xeb\xa3\
tt\x82\\\x01\xd0)\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00@-HF' )

addArtData('wxART_COORDINATES', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xb7x\xba8\x86X\xf4\
\xae\x9d\xf4\x90\xeb\x88\x02O\xf3\xfe\x1e\xdb\x1d\xdf\x1f\x9d\xfe[\x18\xb4\
\xea\\\xf2<\x05\xc5m\x9e\xde\xab\x8f\xdc\xb3\xe4\xa9S\xce\xb12\xed\x0b\xdd\
\x99\xd5tPu\xef\xf3;\x9bgi\xecZ\xf5\xf4\x9bh\xf1\x9b\x1e\x156\xfb\x93\t)\\\
\x0b\xde*2\xc5l\xbb\xaf\xc0\xb0m-\xef\x135Q\x9f\x19\x9f:\xee\xcf\xce\x88\x8e\
TM\xbd\xb7\xf79_\x9d`\xb9\xacMh\xc7\xc7\x8a\xe9\xc63\xce\xa6\xdc:\xc8\x91\
\xbc\xf4\xa9\x98\xd1\xb4\xa0iI\x1f\xdb\xe7\xff`\xfd&\xf4\xf5\xf1\xda\x87\xde\
\x86@\xf70x\xba\xfa\xb9\xacsJh\x02\x007\\Q\x02' )

addArtData('wxART_COPY', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaam\t\xf0\tqehhX\xb5\xe3\
\xdc\xff\xff\xff\r\xdd3\x9f\xbd\xfe\xdc\xbc\xf2\xfe\xf7\x1f\xbf\xdf\x7f\xfc\
\xf6\xfc\xd5\xc7\xfbO\xdev\xaf|p\xe3\xde\xcb\xee\x95/\x0c\xb3\x8e~\xfe\xfaS#\
d\xf5\xebw_\x1e?\x7f\x7f\xe7\xe1\xeb\xab\xb7\x9f_\xbc\xf1\xf4\xd4\xa5\x87\
\xe1\xcd\x97\xcf^}|\xec\xfc\xfd\xfd'o\x7f\xfd\xf1\xf7\xd5\xc7_\xf7_\xfd\xb8\
\xfa\xf8\x9b\xb0\xcbD\xb7\xa8\xaa3w\xbf\x1c\xbe\xf6\xe9\xc3\xd7?\xbb.|x\xfa\
\xf6\xe7\xadg\xdf/>\xf8z\xe2\xd6\xe7\r\xa7\xde\xed\xbb\xfcq\xeb\xd9\xf7k\x8e\
\xbf\x8d\xe6yX\x05t\x0fcI\x90_0\x83\xc3\xb3\x1bi N\x92\xb7\xbb\x0bS\x1awM\n\
\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\xe6H\x00\x05\xd9K<}]\xd9\
\x1fr\xf0q)IMSI\xf9\t\x14j\xf0tq\x0c\x91\xb8\x1c\xdb{S\xe8\x90\x01\x07\x83s\
\x86\xed\x87\x8e\xaf+\xcasrm\x7f\xff\xff\xaf\x1e k\xf4N\xfa4\x9fE\xc0\x1c\
\xc6y\x8c\x7f\xc4%\xd5\x94\xce\xeft\xf0\xe9>X`rlK\x82\xc7\xcb\xd67\xea*\xcb\
\x97\x19\x0b~\xde'\xe0\x18\x99\xb0Qc\xda\xea\xafm5\x91U\\\x8a\x16\x0f*w\xdf\
\xf6.\xb4\x98w\xee\xe2A\xd7\x89M+\x1f\xbd\x97|\xb9o\x95o\xcc\xd6\x0c\x9f-\
\xdb\x7f/\xce\x9b\xa7VQ\xb7w\xf79\x97?\x9f\x18\xd5\x959\xbf%\xda\xff\xb9\x08\
t\x8bj\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\
\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x91\
\x19D\xc3&\xc3y\x9b\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00\xf6^\xee`" )

addArtData('wxART_COPY2FILTER', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xe6\x05\xf8\x84\xb8\xfe\
\xff\xff\x9f\xa1\xa1\x81O\xdeA@\xde\x91W\xca\x94O\xc1\x91W\xd2\x94[TGH\xc5\
\x87_\xce\x91O\xca\x8cCT\x9bCPY5`\x89\x92\xf7L%\xf7~y\xc7fi\xebJ^i3n1mN\x01e\
6>)e\x9f\x99\x8an\xfd\n\x8e\xcd\x92f\xb9\\bz\x1cB@A\x19V.\x11E\xd7~Y\xebri\
\x93\x1cQ\xfdDNQmv^iV.!fV.\xa7\xf8\xc9\xb5K\xeeO\xd8\xfc\xa2v\xf1\xbd\x8a\
\x05\xf7\x80\xec\x8a\xf9w\x97\xeey\x12^\xb9s\xf9\x91\x0f5\x8b\xee\xce\xdf\
\xf1h\xe6\xd6G\xfe\x05\xab\xeb\x96<\xa8\x98\x7f\xcf7g\x89{\xfa<\xd7\xe4i\x0e\
1}F\xdee\x0c\t\x0c\x13~$t}\x89\xc9\x9et+\xa3\xffjj\xf7\x85\xc4\xb6S\xb1MG\
\xa2\xeb\xf6\x86Wl\r)^\xe7\x97\xb3\xd4#}^\xf93\xff\xe4\xebN\x87n\xfe\xda{\
\xe5\xe7\x8e\xcb?6\x9d\xfd\xb6\xfa\xc4\xe7\x85\x07\xdeM\xdb\xf1r\xe2\xe6\xe7\
\xfe'M-w\xaa\xed\xba\xfck\xf3\xb9\x1f\xebN}[z\xf8\xf3\xdc\xbd\xef\xfa7>w\x8e\
\x9f\xb2\xeb\xf2\x8f\xad\xe7\x7f\xac=\xf9u\xd9\x91\xcf\xf3\xf6\xbewL\x98\xb2\
\xf5\xfc\xd7-\xe7\xbe\xaf=\xf5m\xce\x9e\xf7\x137=w\x8a\x9f\xb2\xe2\xe8\xd7\
\xb9\xfb>L\xd9\xfa\xca)a\xca\x82\x83\x9f\xa7\xefz\xef\x9a8u\xfa\xae\x0f}\x9b\
_;\xc6\xf4O\xd8\xf2\xa6u\xcd\x0b\x9b\x88\x8e\xf6\xb5/j\x97>6\x0b\xa8\xb5\x8d\
\xec\xb4\x08n\x04\x06u\x8aT\xd9\x0f`,Y\x97\x04\xf9\x81b\x8f\x08\xf0\xcf\xf0\
\x9f\x11\x93\x11\x93\xca\xbf\x7fF\xac\xca\x7f\xf5\x99\xfe\xfe\xfd\xfb\xe7_\
\xdd\x93\xd4\x06\xa0\x1cc\x92\xb7\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\
\xcc\xc0\xc0-\x04\xc2\x8c\x97\xee\xd6\xfd\x01\n\xb2\x97x\xfa\xba\xb2?\xe4\
\xe0\xe3R\x92\x9a\xa6\x92\xf2\x13(\xb4\xd5\xd3\xc51D\xe2rr\xc2\x01\x86k=\n\r\
:\t\xbdz\t\xc9@\x9c\x9d\x9b\xfe\xfe\xc1\x8b'o\x1e\xbdz\xc6'\xb4\xe1\xeb\x87-\
\xdf>}\xfb\xf8\xf53?G\x083gE\x05\x1bkt{K[\xab\xbb\x8b\xdb\xcaf\x16\x87?/f\
\xdc\xd8Q\xd1\xcb\xe2\xab;\x81a\xc2\xfc\x19Sd\xa6O\x9a\xb5l\xeda\x16!\x8em\
\xd7\xae^\xf6?\x7f\xe2\x8c\xd1\x85\xc4\xb4\xc6\x1d\x87/\x9c\xb0\xb0V\xbf~d\
\xca\xd4^\xd9gA\x9b\xf7\xfca\xe2\xf3\xd3\xcb\x93[\xc0\xa0/\xbf\xbfaAeb\xa0\
\xe1\xea\t\x1b:4\x02\x1c|b\x9c\x02.-Z\xb2\xc5\xc7\xc3+\xcaMLCA]q\xfd\x82\x8c\
\xc8\xb8\xc4\xa5G\x16\xafY\xd4\xf5\xb2\x92\xe1\xcd\x03\x95)}\xd2R\xb2@\x0f\
\xa8\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\xa3\x10C\
s+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\
\x84\x18\x1aX\x19\x9bX\x19\x99A4l2\x9c\xb7\x19\x14\xe8\x9e\xae~.\xeb\x9c\x12\
\x9a\x00\x02\xaf_N" )

addArtData('wxART_CSS_FILE', 'wxART_OTHER_C', 16,
b'x\xdaU\x8f}HSa\x14\xc6_)\x99.\xb4\xb52K\x08R4\x15Y\xdc\xcd\x91:D\x9c8\xb7\
\x91\x13\x99\x0b\x14\x14\xbf\xe6\x17\x95Z\xcd@\x07\x92\xc9\xd24\x13$\xd6\x90\
0!\xda*u\xc3\xa9K\x135se(Eh\x81\xba$6?\xcab\xd7\xeb\xbd\x1bw\xf7\xae\xb9^\
\xa9\x7f:p\xce\xc3s8\xbf\x03\xcf\xdd\xdc\x1cq\x083\x82\t\x00\x08\x91J2\xe5PY\
\x07\x1dt\x08\xce8\xce\xd1<(\x87\xab\x842!\x00\xc3\xddG~\x97\x06B\x7f\xb6\\"\
\x97\x01\xd0\x14\x03\xc0\xadV\x00(?\xd4\x1d\x00\x1a\x10\x00~\x96\x00 \xd0\
\x01\x10^\xd7S\xfc6\x0b\xden\xe6f+D~\xbf\x7fbb\x82$I/M[,\x96\xa5\xa5/>\x9f\
\xd7\xeb\xa5\xadV\xeb\xe8\xe8(\x8a\xa1\xe3\xe3\xe34M\xd9\xbe~\xb3\xdb7\xf7\
\xf7}333.\x97kll\xcc\xe9tR\x94\xc7l6S\x1e\x92\xa6(/M9\xecv\xdb\xdaZ\xc3\x1d\
\xed\xea\xdaAm\xff\xc2\xfa_.\xb4=\x1a~\xf3y\x1b\xbe|lY\xecy1k2\x99p\x1c\'\
\x08\x9ct\xbbH7\x04=>/=44\xb4\xb2\xb2:00\x80\xa1(\x86a.\x02\xdf\xdb\xc3=$Iy<\
\x06\x83\xa1\xbb\xdf42o{88\xdb\xde;\xa0\xd7\xeb[uF\x17A\xb8]\x10w\xebt\xba\
\xae\xae.\xcc\xe9\xdcC\xd1=\x0c\xc51\x0c\x92\x90v\x13\x84\x87tk4\x1a\xb5Z\r\
\x03FF\x99\x12a\xde\x00\x95<\'\x0f\xa4o\xafT\x1e\x98\xb2\x8b\xe2L\xd0\x1exF\
\x02Mp\xbd\xa4\xe0\x06\x00\xa1s\x07\x1d0_\xf7L\t\x97\x0c\x95T&b\xd8\x83B\x99\
Q\x11\xdah%\x05WS\xd2L\xa1\xe2\xd4\xb2\xec~cxK\xfa\tql\x05;Fn\xcdK\xbci>g\
\xde\x9d\xdc\xf5\xb7d/\xa7\x8c\xfb\xa7\xd4h\xe3\xf76\x16{:\x9a%f=\x8d\xd6\
\xf6\x98\x1f\xc8\x97\n\x95\nN\xe7\xd8\xa0q\x0b\xcf\x8ad\xf7<\xef\xe0\xbd{e\
\xcc\xd7\xb2\x83\x9fTk\xaf\xd4.\x84\x9d\xefg\x86&sON\x169\xd8\x19\x97-\x85U!\
\xc7\xd3\x0bA5\x7fC\x1f\x16\xf6\tU\xc5\xbbR/\xa1\x1bB\xc5\xeb\xfa\x1f\xb9\
\xed\x9d\xc7\x12\x82\xee\xc5\xa6ij\x10Bq\xedcG\xbd0\xbe\xc8\xe8(\xfb\xd0!z\
\xdfW\xab\xb5\xad\xa7\xc5\xf52\xa6\xe7(g2\xbec \xb6\x9a&\xbd\xdd\xeb\xfb\x94\
\xc3\xe1c\xd0\x00i>\xdd$k.(\x86AbT\xa2|\x95\xb2TU!(\xbf^\x01\x05\xf0\x10n\
\x12\x07\xe1sx<\x057I\xc0\xe5\x0b\x12S\x12\x10\x9e\x00AR\xf3\x16\xb7\xff\x03\
\xae\xd6)k*\x1b\xff\x01\xc9\x1c._\xc1E\x04\x89|\x01\xef\xc2_\xc0\xcc\xed\x1b\
\x81\x00\x90\x8ar2\x8d\x19%\xb7\xff\x00=\x08b\xa5' )

addArtData('wxART_CUT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\xb5\x0f\xf0\tq\xfd\xff\
\xff?CCC\xe3\xe4\xd5\xa1IE@\xf6\x9bw_\xee?y{\xed\xf6\x8b\x93\x17n\xef?y{\xcf\
\xd1KK6\x9f\x98\xbch\xbbe\xdcR\x06\x83\x19\xc2\xc1\xa7\x1c\x1b_\xf3:\xceS\
\xf2[(\xe8\xbd\xb8l\xe1\x87\xc0\x1b\x0fr\x80F1\x95\x04\xf9\x01\x9dS6\xf9\xac\
\x05\x90\xc7\x98\xe4\xed\xee\xc2\xd0\xc1*\xeb\x01\xe4p\x16xD\x1630p\x0b\x830\
#\xc3\xac9\x12@A\xf6\x12O_W\xf6\x87\x1c|\\JR\xd3TR~\x02\x852=]\x1cC$.\x87\
\x9e\xf7f:\xe4\xc0\xc1|\x813\xe3\xafY\xcf\xa5\xdf\xf3C7\xf4\xa5nj\x9a\x1e\
\x1a\x95\xdd\xc1\xf1m\xcb\x19\xf1-\x0e\xdb\x8a.1\x15\x9e\xde\xe9\xb4e\x93H\
\x83\x9e\xd6t\xae\x0b\xab\xef\xa95\xdc\x937v\x98\xaf\x9d\xc9\xfe\xe5\xfa\xec\
gO\x1a\xf6U~\xbb\xbb\xd3\xf9\x8f_\xc4'~\x9e\xe8\x86\x9d\xbf\x1b\xe4&41\xa6\
\xcd\xb9&\xf5s\xfe\x7f\xc6\xf9\xda,\xb5\x15\xf5}\xf7\x80\x96\xaa\x96\xb8F\
\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\xa3\x10Cs+C\x13+cKm\
\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\x84\x18\
\x1aX\x19\x9bX\x19\x99A4l2\x9c\xb7\x19\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\
\x00\x1f\n\xa2." )

addArtData('wxART_D', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R\x9c\x05\x1e\x91\xc5\x0c\x0c|G@\x98q\xaa6\x9f4P\xf0\x87\
\xa7\x8bc\x88Eor\xcd\xc6_\x17\xea\xd9\xb8\x18\x84UgIJHHD\\`\x9d\x93\x95v\xf0\
\xe6$\xa7\x1a\x9e\xa0\xa6=<Y\x97\x16\xf1|\xb3\xf2\xe2\xc9\nRZ\xb2\xf3\xc1\
\xcf\xdd\xfe<\xe9\xef\xedR#\xea^09\x1f\xdbR\xca\x13\xed\x17\xaf\xfe\x86I\xe2\
\xc6\xf5I\xc7>\xfc\xb9\xab\xde\xc6\x1c\xfe\xcep\x8dE\xcd\xc4\x87\x9f\xbf\xcf\
\xe7\xa9\x95\xe67\x96\xd0\xf66\xf6\xe0\xfa(\xf8\x9c\xc9S\xd1\xae\xcd\xc3\x9a\
\xb9m\x17\x87\xf8\x8e\x1b\x9f\x0e\x8bw~g\xe2\x01\xca\x1e\xfe[\xff\xfae\xf6%\
\xde\x04 \xd8p=\xb0I\xe2\xc3\x1b\xdeJ\xb6\x07L.\xd2\x0c\x9b%m\xb5:\x8d\x1e\\\
\xdbl\xce\xc3\xbe\xfeNrB\x82C\x05+[\x81\x9b233\xb3\x97\x89\x91\x81\x81\xc1\
\x87\xa2M\xc6?fd\t\xa53\x14u\xa5$4\xb8d\xd6\xb6p3\xeb\xab[\x7f\xd4\x0b\x98,\
\x948A\xe4Q\xb2A\xd8\xb44\xa0\xa9\x87.\x9c9\x00\x04\x16\x0fv\n2\x14\xf7\xba\
\xa4\xac\xf4\xdf\x06\n\x03\x06OW?\x97uN\tM\x005\x94y\x13' )

addArtData('wxART_DATABASE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xae\x0e\xf0\tq\xfd\
\xff\xff\xff\xaeso\x97\xed\x7f6q\xf5\xe5\xd6\xf9\'[\xe6\x1d\xeb\\|z\xc6\xfa\
\xcb\xeb\x0e\xde\xdfq\xe1\xdb\xe9\xfb\xff\xef\xbe\xfa\xff\xfa\xd3\xff\xc3\
\xb7\xfe\xae;\xf6z\xf2\xea\x8b=\xcb/\xbe\xff\xfa?\xb3i\xd5\xdek\xff\xaf?\xfb\
\xff\xec\xfd\xff\xc7\xef\xfe_x\xf8\x7f\xea\xde\xffKO\xfc\xbf\xf5\xe2\xff\xa9\
{\xff\xd7\x9d\xfd?a\xd7\xff\xba\xf5\xffKV\xfd\xcf[\xfa?\xb1jQ\xc3\xac#\x11\
\x853\xab\xa6\xecYz\xfc\x7f~\xe7F\xdf\xd4\xaeY\x07\xff\xef\xbc\xf2?e\xc1\xff\
\xe2\xa9\xa7\x1bW<\x9d\x7f\xf8\xcf\x81\x1b\xff\x97\x9f\xfc_\xbf\xe1\x7f\xfc\
\x9c\xff!]\xf7\x83\xca\xd6\xcd\xdf\xf1 \xaajMJ\xe7\xa1\x86E\xd7\x81\xee\xb42\
J\x00y\x91\xb1$\xc8/\x98\xc1\xe1\xd9\x8d4\x10\'\xc9\xdb\xdd\x85\xa1\x83U\xd6\
\x03\xc8\xe1,\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\
\x0f9\xf8\xb8\x94\xa4\xa6\xa9\xa4\xfc\x04\nUz\xba8\x86H\\NN``rSK\x13\x0b3+\
\xe3c\xd3Hx\xf4\xe4\xd1\xb3\x87\x0f\x9f=}\xdc\xfe\x81\x95\xe5\xa1\x03\x87\
\x92\x82\x8e\x92\x96\xc6\te5=\x1dF\xc1\x84\xc9"b\xd3\'M\x9b8urx\x03\xc7\x06\
\x05\x16\x91\x83Lk^0yU\xb0L9\xc8\xa4\xd5\xc2\x1ar\x91\xe5\x8a\x80\xd6\x15E&\
\xa9Y\x01\x8c\xba\x1d\x0c\xcd\xdb\xfa\xd6\xcd\xdb\xb2\xafq\xe1D\xc33\xbb\xd5\
\xd6du\x9dZ\x96\xf6L\xc1\x8cA\xc1G(+\xae\x86\x7f5\xd0\x11\xaa%\xae\x11%)\x89\
%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\
\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\
\x16\xba\x86&!\x86\x06V\xc6&VFf\x10\r\x9b\x0c\xe7m\x06j`\xf0t\xf5sY\xe7\x94\
\xd0\x04\x00x\xf3\xf2\xc8' )

addArtData('wxART_DB_COLUMN', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Re`hhf`\xf8\xf9\x1fH\xbfd`(5``x\x95\xc0\xc0`5\x83\x81A<\x7fR\xfcQ7\xa0Z\
\xa1\x00\x9f\x10\xd7\xff\xff\xff744\x1c\xb8\xf4d\xf3\xe6\xcd\xff\xc1\xe0G\
\xd7+s\xa0,cI\x90_0\x83\xc3\xb3\x1bi N\x92\xb7\xbb\x0b\xeb\x8f\xfc\x97\xc7\
\x81\x1c\xce\x02\x8f\xc8b\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\xe9\xeb\xca\
\xfe\x90\x83\x8fKIj\x9aJ\xcaO\xa0\x90\xb2\xa7\x8bc\x08\xc7\xf5\xe4\x84\x06FG\
\x8d\x04\x81\xa0\xa0\xb0 \xa3\xc2B\x17\x83\x96\xde\x83\x07&d\x05\x15\xec\x06\
:\xeaH\x94\x80\xf0\xcd\xde\x05\xdc@\xe5\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\
\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\
\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\
\x86\x06V\xc6&VFf\x10\r\x9b\x0c\xe7m\x06j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00Y\
\x8ae\x9e" )

addArtData('wxART_DB_FOLDER', 'wxART_OTHER_C', 16,
b'x\xdaURiP[e\x14\xfd\xc2bY\xac:2\xb5\x01\xc5\xe9PKu\x90N\x12\x18\xa9\x99R\
\x16\x93\x02\x96\xcd\x90\x08)\x01\x02\x81\x87\x85G[C\x9e\n\x18\xe0\x015V\x9c\
\xa1\xecM \xb1E\x98R\r\xb4P\x16+\xa1R\x10\xa4l-;e\xcah\xd5\xc1$\x06P\x08`\
\xb0\xe9\xf51\xfa\xc7\x1f\xf7\x9e9\xe7\x9e\xf3\xe7\xde{!:2d\xaf\x93\x9b\x13B\
hoX(\x87G\xe1s\xbb\xe5`K\xf5W\xbd\x9f\x8d\xa1\xc0.=("\x08\xa1\xb62\xe7\xc7\
\xc9\xf6\x14? \t\xe5E \x94{\x08\xa1\xc2b\x84,@\xa1\x01!\x82\x81\x90Q\x8c\x10\
\xfb\x12B\xfb\xcfV$\r\x9e@\x88\xf6$:\x9c\xcf\x05\x80\xec\x0eS\xba\xfa\xd7S\
\x05\xf7y\x99\x83<\xec\x8e s(1o\x1c\xafY\x94vo\xe6O\xc0\xb5\x1fa\xcc\x08#Fh\
\\\x82\x9c>+^\xa7\x8f\xcf\xf8!6gb\xfe\x0f\x98[\x83\xd95\x98Z\x83\xc9U\x98X\
\x81\xb1\x15\xb8k\x82\xa0w.\x12}\xa0\\\x00\xdd2\x0c\x1a\xa0\xe5\x11\x90\xc3@\
\xb4\x81(\x8f\x1a\x95\n\xb2\x87\xb1\xaf\x80\xb8\r\xe4=\xa8}\x00\xf2a\xc0\xaf\
\x82\xb0\x08"q\x08=\r\x1c\x8c\xf2\x9c\xe7e\x0cb\xcd@\xf4\x029\x01\xd5\x0bp.\
\xf7<\xde\x08\xc2\\h\x19\xb14\x0f\xff\xd5\xf0\xfd6v\x15\x88\x1e \xc7\xa0|\
\x1e\xe4\x03\x80\x7f\x01\xc2\x0f\xa0\xbck\xb5V\xb7]\xde\xbdu\xa1c\xab\xb8\
\xd5\xfc\xfe\x15\x03^o\x8cJ\xba\x8d5\x02q\x0b\xc8\x11P\xccB@@\x00^\x0f\xc2l(\
m3M\xfc\xf4\xf7\xc8\xd2\xce\xdd\x87;C\x8b;\xfd\x0b\x96t\xa5!*\xa9\x17k\x00\
\xa2\x1bJZL\x9a;\xdb\xca\xde\xad\xeao\xb7\xca\xbf\xd9\xfc\xbcc3\xb9F\x1f.j\
\xc74@t\x029\x04\x8aI\xc0\xcb@~\xcd\xf8a\x93Qz\xd9\x88\xab\x8d\xe9J}b\x15\
\xe5\xb9\x81\xa9\x80\x1c\x00\xc5=\x90w\x00^\x02~\'\x92\xc2E\xadX5\x10-@\xf6\
\x81b\x14\xf0\x02(\xef\xde,\xed0+\xda\xcd\\\x81\x1a\xbb\x08D3\x90=\xa0\x18\
\x02y\x13\xe0j\x83\xac\xc9\x9cue=C\xb3\x9eV\xffg\\\x99\x9e+P&\xe5A\xb6\x06\
\xc8.P\xf4\x03\xa64|7k\xd1M[zf,=\xd3\x96[S\x96\x10Qg\xf4{\x0b\x92\x9c\x9d\
\xa8,\x10\xd7\xe8Kn\x98\xc9Vs\xbev\xa3@\xbbQ\xa8\xdd\x90H\xc7y)u\\\xc1\x99\
\xa3\xe1\x99\xc7\x05\x1f%V\xeaE\x15\x86\xd82\xfd\xbbez\xea\xf4\xaf;n\xfdN}\r\
M\xc6\x8b\x8cA\x81\xcb\x0b\xd8.I9\x19\xc2A\x9f\xda\xbb\x87R\xc4\xf1\\\xa80\
\x1b!g\x97\xdd\xa2!U=\x9d\x12\xf7\xc8\xc2"\xb8{\x1e9<\xe3\xe4\xe1V\xf3J\xaa\
\x85\x92,a\x9c >}Z"\x16\x8bSS\xb0\xe44\xc9o\xe2B\x1b\xcf\xc8#g^N<\x9eO\x0brH\
\n\x8d\x8b\xe3\xf0\xf9\xe1\xa2`\xde\xdbn\x1e\x07\x0ez\x1d\xf6\xf4\xbc~\xb9\
\xb9Qk\xf3B\xb4 f\xfe\xfe\xcc\xd4\xdc\xe4\xec\xb4\x1fr\xa6\xbb\xb9\xd6]R)\
\xe3\xf5F\xe1)a\xb1]\\\x16\xbebr\x7fI-S\'\x88\x96\x1e\xfa\x1fs\xd5\xe9\xe4\
\x1f[\x1f\xdb\xda\x10\xc5Eo\x05\x0f\xf4\x1f\xa4{|\xd9\xb0\xcfj\xb5\xda\x8e\
\xa7\xa4\xfc\xf2\xb3\xcb\xf3\x95\xf4\x8a\x18\xde\xf4\x94\xd5\xc7\x86\xf0\xb9\
\xd9\x9e-\xad\\\xa7\xaf;W9\x95~v\xd2\x86\xec\xaa*\xcaz\xcd\xebz\xb3\x96\xf5\
\xf5SN33s\xa4\x9d\xf1E\xb7:U|\xa1MK\xd6\x8a\xbb:!\xe1\xe9%\xff^\xb9\xf5I \
\xe9\xe8r8B\xc3\xea,%\x93\x17\xcd\xae\x81\xf1\x98j\\\xe5\x9f\xbe\xaa\xb3\x04\
\xd2>\xb1w\xdeo\xa9=\x92\xd8.{\xb0\xbe/!a\x94\xd6%\xe5\xf4\x04\x99\xb4\xb1\
\xd4\x12\x0e\xc9\xb8q\xb2\xd4dY\x1a["M\xa3\x00\xb1\x18L?o\x86\xaf7\x8b\xc5g\
\xfa\xb1\x99\xbel\x9f7\xbd\x18,6\x83q,ft\xf9\x7f\x81\xac\xb3\xa9\xa7\xb1\x9c\
\xff\x02G\xbd\x99\xbe|&\x83\xed\xe3\xcbf\xbd\xf1o\xa0\x9d\xa9\xb9I\x05P\x187\
\x92\xd3\x1a,.\xfa\x07[\xf0\x12\x8b' )

addArtData('wxART_DB_FORM_VIEW', 'wxART_OTHER_C', 16,
b'x\xda\x016\x04\xc9\xfb\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x03\x00\x00\x00(-\x0fS\x00\x00\x00\x04gAMA\x00\x00\xb1\
\x8f\x0b\xfca\x05\x00\x00\x00 cHRM\x00\x00z%\x00\x00\x80\x83\x00\x00\xf9\xff\
\x00\x00\x80\xe9\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17o\x92_\xc5F\
\x00\x00\x02"PLTE\xff\xff\xff2k\xda4k\xda2k\xd93h\xd52e\xcf0b\xc8/_\xc0+Z\
\xb7*V\xae%P\xa4#J\x99 F\x8d B\x84\x1d;y\x1a5m5k\xda\xc5\xdb\xfc\xc6\xdc\xfd\
\xc5\xdb\xfb\xc6\xdb\xfc\xc1\xd9\xfc\xbe\xd7\xfd\xba\xd5\xfc\xb4\xd1\xfc\xaf\
\xcd\xfa\xaa\xc9\xf9\xa4\xc5\xf8\x9d\xc0\xf7\x96\xbc\xf6\x90\xb8\xf7\x180a5k\
\xdb3k\xda2i\xd4/e\xcf-b\xc7-^\xc0*T\xad\'O\xa4"K\x9a!F\x8f\x1e@\x82\x1d:w\
\x1a5l\x170b\x14*V\xac\xbd\xd5\xf4\xf8\xfe\xf3\xf7\xfe\xf1\xf6\xfe\xef\xf5\
\xfe\xed\xf3\xfe\xea\xf2\xfe\xe7\xef\xfe\xe5\xee\xfe\xe1\xec\xfc\xdb\xe9\xfc\
\xda\xe7\xfc\xd6\xe4\xfbB[~\xa5\xb6\xce\x89\x9f\xc8\x84\x98\xbe{\x8e\xb1r\
\x86\xa3\xe7\xf0\xfd\x85\x9c\xc7~\x95\xbew\x8d\xb2v\x8c\xb2l\x82\xa5e{\x9a\
\xcd\xde\xfc\xb6\xc7\xe1A[~\xa2\xb2\xc9\xf2\xf6\xfe\xeb\xf3\xfe\xe8\xf0\xfe\
\xe3\xee\xfd\x80\x98\xc2\xc6\xd4\xe7\xce\xdb\xed\xcd\xda\xed\xd5\xe1\xf3bx\
\x9a\xc8\xdc\xfb\xb5\xc7\xe1@Z~\x9e\xaf\xc6\xec\xf3\xfe\xe8\xf1\xfe\xdf\xeb\
\xfd{\x92\xbbm\x83\xa7j\x7f\xa3i~\xa3dz\x9e`v\x99\xc4\xd9\xfc\xac\xc1\xe3?Y~\
\x9e\xae\xc6\xf2\xf7\xfe\xee\xf5\xfe\xeb\xf2\xfe\xe7\xf0\xfe\xe3\xed\xfd\xde\
\xea\xfd\xd9\xe7\xfd\xd4\xe4\xfc\xcf\xe0\xfc\xcd\xe0\xfc\xc9\xdc\xfc\xc3\xd9\
\xfc\xab\xc0\xe3>Y~\x9d\xae\xc6\x86\x9c\xc7\x80\x96\xbfw\x8d\xb1n\x83\xa4\
\xdd\xe9\xfd\x7f\x98\xc7y\x92\xbfq\x89\xb1p\x88\xb1h\x7f\xa4ax\x9b\xc2\xd8\
\xfc\xaa\xc0\xe2=X~\x99\xab\xc4\xef\xf5\xfd\xe7\xef\xfd\xe2\xed\xfd\xdd\xea\
\xfc{\x93\xc2\xc2\xd0\xe6\xc9\xd8\xed\xc8\xd7\xed\xd0\xde\xf3^u\x9a\xbe\xd5\
\xfb\xa3\xbb\xe1\x98\xaa\xc4\xee\xf4\xfd\xe3\xec\xfd\xde\xe9\xfd\xda\xe7\xfd\
\xd5\xe4\xfcw\x8f\xbah\x80\xa6e|\xa3d{\xa2_w\x9d\\s\x99\xba\xd3\xfb<W~\x97\
\xa9\xc3\xed\xf3\xfd\xe4\xee\xfe\xda\xe8\xfd\xd5\xe4\xfd\xd0\xe1\xfc\xcb\xdd\
\xfc\xc1\xd8\xfc\xc0\xd7\xfc\xbc\xd4\xfc\xb8\xd2\xfb\xb7\xd1\xfb\xa2\xba\xe1\
\x96\xa9\xc3I`\x7fG_\x7fF^\x7fE]~C\\~>X~<X~\xff\xff\xff\x0e2\xacF\x00\x00\
\x00\x01tRNS\x00@\xe6\xd8f\x00\x00\x00\x01bKGD\x00\x88\x05\x1dH\x00\x00\x00\
\tpHYs\x00\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x00\x07tI\
ME\x07\xe1\x08\x0e\n"\x1a\x96$d\xf9\x00\x00\x00\xefIDAT\x18\xd3c` \x08\x18\
\x19\x99\x98YX\xd9\xd898\xb9\xb8yx\xf9\xf8\x19\x04\x04\x85\x84ED\xc5\xc4%$\
\xa5\xa4ed\xe5\xe4\x19\x14\x14\x95\x94UT9\xd4\xd454\xb5\xb4ut\xf5\x18\xf4\r\
\x0c\x0c\x0c\x8d\x8cML\xcd\xcc-,\xad\xacm\x18l\r\xec\xec\x1d\x1c\x9d\x9c]\\\
\xdd\xdc=<\xbd\xbc\x19|\x0c|\x8d\xfd\xfc\x03\x02\x83\x82CB\xc3\xc2#"\x19\xa2\
\x0c\x8d\xa3c\x02b\xe3\xe2\x13\x12\x93\x92SR\xd3\x18\xd232\xb3\xb2sr\xf3\xf2\
\x0b\n\x8bR\x8aKJ\x19\xca\x8c\xca+*\xab\xaakj\xeb\xea\x1b\x1a\x9b\x9a[\x18Z\
\xdbL\xdb;:\xf3\xba\xba{z\xfb\xfa\'Lla\x9849{\xca\xd4i\xd3g\xcc\x9c5{\xce\
\xdcy\x13\xe73,X\xb8(v\xf1\x92\xa5\xcbD\x96\xafX\xb9j\xf5\x9a\xf9\x0ck\xd7\
\xad\xdf\xb0q\x93\x8dwd\xda\xe6\x96-\xf3\xe7\xcf\xc7\xf0,\x00\x9f\x93H\xc3,\
\xe8\xd0y\x00\x00\x00%tEXtdate:create\x002017-04-22T17:14:39+02:00<S\xcb\xe6\
\x00\x00\x00%tEXtdate:modify\x002017-08-14T10:34:26+02:00\xb21\x9e\xb3\x00\
\x00\x00\x00IEND\xaeB`\x82\x87\xf0-\x02' )

addArtData('wxART_DB_OBJECT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\x06\x07\xf8\x84\xb8\xfe\
\xff\xff\xdf$\xeb\x96a\xc6U\x83\xd4\xf3\x06I't\xe2\xf7kGo\xd7\x08]\xa7\x16\
\xb8D\xd9g\x96\xa2[\x9f\xa2C\x8b\x9cu\xa5Q\xe6\x95c\xb7\xff\x1c\xbe\xf9{\xdf\
\xb5?\xbb\xae\xfe\xd9r\xe1\xd7\xfa\xb3\xbfV\x9d\xfc\xb5\xf8\xe8\x8f9\x07\xbe\
O\xdd\xf3M\xca4\xc70\xed\x82~\xd2I\x9d\xd8\x03\xea\x81\x8b\x15]\xfbe\x1c\x9b\
\xa5\xac\xcb\xa5Ls\xc5\r\x92\xd6\xee\xbd\xf6\xe1\xdb\x9f\xf7\xdf\xfe\xbc\xfb\
\xfa\xe7\xed\x97\xdfo>\xff~\xf5\xe9\xf7\xd3\xf7\xbf\xee\xbe\xfcu\xf5\xc9\xcf\
\xd3w\x7fx$4\xaf\xd9s\xed\xfd\xd7?\xfbN?\xdc{\xfa\xe1\x9eS\x0f_}\xfe\xbd\xf9\
\xf0\xbd\xf5\xfb\xef\xae\xdc}\xeb\xca\xe3\x9f+w^vKh^\xbd\xe7\xea\xdb/\x7f^\
\x7f\xfe\xfd\xf2\xd3\xef'\xef~\xddy\xf9\xeb\xf2\xe3\x9f\xa7\xee\xfcX\xb8\xe5\
\x92k|\xf3\xaa\xddWw\x1c\x7f\xb0x\xfb\x8dy\x9b\xae\x1f\xb8\xf6m\xe6\x86\x8b.\
q\xcd+w_=u\xf7\xc7\x8e\x0b_'\xaf\xb9\xe8\x1c\xdb\xbcx\xeb\x85\xf5\xfb\xef\
\xcc\xdbtm\xc6\xba+SV]\xdav\xe1k\xff\x8a\x0bN\xb1\xcd\xb3\xd7\x9d|\xf9\xf1\
\xf7\x95\xbb\xaf\xce\xdezu\xf4\xca\xcb=\xe7^l>\xf1|\xf5\xe1gK\xf6=\x9b\xbf\
\xfbi\xdf\xf2\xf3\x8e1MSW\x1cq\x8d\xadu\x8bop\x8d\xadw\x89\xadw\x8a\xa9w\x8c\
\xaew\x88\xaa\xb7\x8f\xac\xb7\x8b\xac\xb7\x8d\xa8w\x88i\x02\x86\xa7\x8f\xef)\
\x1b`T0\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\xcaz\x009\x9c\x05\
\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\xfd\
!\x07\x1f\x97\x92\xd44\x95\x94\x9f@\xa1%\x9e.\x8e!\x12\x97\x93\x13\x14\x98\
\x0c\x8c\x0c7o\xd8\xb4\xb1\xb8\xa0\xa8\xf0s\x03k\xc5\xcf\x1f\xac,\xad-\xae.G\
\x8f\xa8\x1e`\x9a\x14t)\xe7\x8d\xd1\x9cME\x9f\xb8\xba\x12\x18USECMKy}usec74\
\xcc\xdb\xd7\xb8p\xe2\xc6\xce\x953w\xb6\xaaF\x1c\xf0\xbaz\xcb\xed\xf0\xb5s\
\xf7\x0e^<)\xa9\xf3 )\xf7IVR\xfa\xb3g\xef\x1e\xbed\x15\xfb\xb0\xcd\x90\xed\
\xe4\xef\x8a\x1f\xbf~6\xb32\xf5\xf82\x9d\x95ijrv:|\xe8 \x93\xe0\xc4\xc0\x8b\
\x86\x1b\x0b?rvz\x9eLh\x9cre\xcb\x97\x9e3k\xde\xcc\xb9\xb3\xa7&\xa9\xa6\x8d\
\x91\xe1d\xa4\x8c\x7f^\x83\xf2\x1d\xa0{UK\\#JR\x12KR\xad\x92\x8bR\x81\x14\
\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\
\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\
\xac\x8cM\xac\x8c\xcc \x1a6\x19\xce\xdb\x0c\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\
\xa1\t\x00<\x1bwT" )

addArtData('wxART_DB_TABLE_VIEW', 'wxART_OTHER_C', 16,
b'x\xda\x01-\x04\xd2\xfb\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x03\x00\x00\x00(-\x0fS\x00\x00\x00\x04gAMA\x00\x00\xb1\
\x8f\x0b\xfca\x05\x00\x00\x00 cHRM\x00\x00z%\x00\x00\x80\x83\x00\x00\xf9\xff\
\x00\x00\x80\xe9\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17o\x92_\xc5F\
\x00\x00\x02\x19PLTE\xff\xff\xff5k\xda3j\xd94j\xda1h\xd50e\xcf0b\xc8,_\xbf+[\
\xb7(U\xae&Q\xa4#L\x9a!F\x8e!@\x84\x1e;y\x1b6n\x180a5k\xdb\xba\xc9\xe5\xb8\
\xc8\xe4\xb8\xc7\xe3\xb5\xc6\xe3-^\xc0\xb2\xc3\xe2\xb0\xc2\xe1\xae\xbf\xe0\
\xac\xbf\xe0!F\x8f\xa7\xbb\xde\xa5\xba\xdf\xa3\xb8\xde\xa1\xb7\xdd\x14*V3l\
\xda3i\xd61f\xd0/b\xc9,]\xc0\'Q\xa3!E\x8f\x1cA\x83\x1a;w\x1a5m\x170b\x14+V\
\x12&L\xad\xbd\xd6\xf2\xf6\xfd\xf1\xf6\xfd\xf0\xf5\xfd\xef\xf5\xfc\xa5\xb7\
\xd0\xeb\xf1\xfc\xe8\xf0\xfc\xe5\xed\xfb\xd8\xe5\xfa\x9b\xaf\xcc\xdb\xe8\xfb\
\xd8\xe6\xfb\xd5\xe3\xfa\xbd\xd2\xf6B\\\x80\xac\xbc\xd5\xf0\xf5\xfc\xec\xf3\
\xfd\xa4\xb6\xd0\xe9\xf0\xfc\xdf\xea\xfb\xda\xe7\xfa\xd4\xe3\xf9\x9a\xad\xcb\
\xd9\xe6\xfb\xc4\xd8\xf8\xbe\xd3\xf6\xac\xc8\xf3A[\x80\xaa\xba\xd3\xa8\xb9\
\xd2\xa6\xb7\xd2\xa2\xb4\xcf\xa0\xb2\xce\x9f\xb1\xce\x9c\xb0\xcd\x97\xac\xca\
\x95\xaa\xc9\x93\xa8\xc8\x91\xa6\xc7\x8f\xa5\xc6@Z\x80\xa7\xb8\xd1\xef\xf4\
\xfc\xed\xf2\xfc\xe7\xee\xfb\xa1\xb3\xce\xe5\xee\xfc\xe1\xeb\xfb\xde\xea\xfb\
\xcc\xdd\xf8\x96\xab\xca\xd4\xe2\xfa\xd2\xe0\xf9\xcd\xde\xf8\xa5\xc1\xf4?Z\
\x7f\xa5\xb5\xcf\xed\xf3\xfb\xe7\xef\xfb\xe3\xec\xfb\x9e\xb2\xce\xe3\xeb\xfc\
\xd3\xe2\xf9\xce\xde\xf9\xc8\xdb\xf8\x93\xa9\xc9\xd3\xe1\xf9\xb8\xcf\xf6\xb4\
\xcd\xf6\xa2\xc0\xf5>Y\x7f\xa2\xb3\xcd\xa5\xb7\xd1\xa2\xb3\xcf\x9f\xb2\xce\
\x9b\xaf\xcd\x99\xad\xcb\x94\xa9\xca\x92\xa7\xc9\x90\xa6\xc7\x8e\xa5\xc6\x8c\
\xa3\xc5\x8a\xa1\xc4=Y\x80\x9f\xb0\xcb\xeb\xf3\xfc\xe8\xf1\xfc\xe6\xee\xfc\
\xde\xe8\xf9\xde\xe9\xfb\xda\xe6\xfa\xd6\xe5\xfa\xc1\xd6\xf8\x90\xa6\xc8\xcd\
\xdd\xf8\xca\xdc\xf8\xc8\xda\xf8\x9e\xbe\xf6<X\x7f\x9c\xae\xc8\xea\xf1\xfc\
\xca\xdb\xf8\xc3\xd7\xf8\x8e\xa5\xc7\xaf\xc9\xf5\xab\xc6\xf5\x9b\xbd\xf6=X\
\x7f\x99\xab\xc6\xa6\xb8\xd2\x9e\xb1\xcc\x9a\xad\xca\x97\xac\xcb\x92\xa7\xc6\
\x90\xa5\xc6\x8d\xa4\xc4\x8c\xa2\xc3\x8d\xa4\xc6\x89\xa0\xc3\x88\xa0\xc3\x88\
\x9f\xc2\x87\x9f\xc2\x96\xa9\xc5H`\x81G_\x80F^\x80D]\x80C\\\x80B[\x80=Y\x7f\
\xff\xff\xffwIH\xdb\x00\x00\x00\x01tRNS\x00@\xe6\xd8f\x00\x00\x00\x01bKGD\
\x00\x88\x05\x1dH\x00\x00\x00\tpHYs\x00\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\
\x9a\x9c\x18\x00\x00\x00\x07tIME\x07\xe1\x08\x0e\n"\x1a\x96$d\xf9\x00\x00\
\x00\xefIDAT\x18\xd3c` \x08\x18\x99\x98YX\xd9\xd898\xb9\xb8yx\xf9\xf8\x05\
\x18\x04\x85\x84ED\xc5\xc4%$\xa5\xa4ed\xe5\xe4\x15\x18\x14\x95\x94UT98\xd5\
\xb8\xd554\xb5\xb4ut\x19\xf4\xf4\r\x0c\x8d\x8cML\xcd\xcc-,\xad\xacml\x19\xec\
\x0c\x0c\xed\x1d\x1c\x9d\x9c]\\\xdd\xdc=<\xbd\xbc\x19||}\xfd\x1c\xfd\x03\x02\
\x83\xdc\x82CB\xc3\xc2#\x18"\r\xa3\xa2cb\xe3\xe2\x13\x12\x93\x92SR\xd3\xd2\
\x192\xa22\xb3\xb2sr\xf3\xf2\x0b\n\x8b\x8aKJ\xcb\x18\xca+\x1c+\xab\x82\xaak\
\x92j\xeb\xea\x1b\x1a\x9b\x9a\x19ZZ\xdb\xda;\xaa;\xbb\xba{z\xfb\xfa\'L\x9c\
\xc40yJv\xa7{\x8d\xe5\xd4i\x9e\xd3\xfbg\xcc\x9c5\x9ba\xce\\\xffy\xf3\x17,\\\
\xb4x\xc9\xd2e\xcbW\xac\x9c\xcd\xb0j\xf5\x9a\xb5\xeb\xd6o\xf0N/+\xdb8i\xd2\
\xec\xd9\x18\x9e\x05\x00\x93\rH\x80O\xae\x81\xf5\x00\x00\x00%tEXtdate:create\
\x002017-04-22T17:14:39+02:00<S\xcb\xe6\x00\x00\x00%tEXtdate:modify\x002017-\
08-14T10:34:26+02:00\xb21\x9e\xb3\x00\x00\x00\x00IEND\xaeB`\x82mS)\x91' )

addArtData('wxART_DELETE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xfe\x0c\xf0\tq\xfd\
\xff\xff\xff\t#\xe5\x13\x1eVG\xd5%~\xdb+\xfe+\x89\xb9e\xae\xbaCFp)/\xfbW9\
\x86\xcf\n\xcc?\xe3\xdd\xfeU\xa7<S\xe6\xda\xc8\xc3\xb4T\x84\xef\xa2\x81\xdck\
\x19\x86\xef\xd9\xa1\xbf\x0b"\xd7q2,\x97\x958\xab"|W\x9c\xe1\xbe\x8e\xc4\x8f\
\xb2\x84\xf7\x91\xcek9\x18\x96+\xc9\x1c\x97\xe2>/\xc4p\xcdB\xfd\x80\x10\xcb\
\x16n\x86\xa5R"\xfb\x84X\x0f\xf01\xec\xe2a\xd8\xcc\xc5\xb0\x98\x8fc\x97\x9d\
\xf1N\x1e\x865\x1c\x0cK\xd9\x18\xe6p0\xdf\xb2\xd1|\x1a\xed\xb9\x99\x9bq>+\
\xc3\x0cf\x86I\xecl\xbfk3\x8ei\xc9\xae\xe6`X\xc2\xce\xb8\xdc\xc2d\x1a\x07\
\xdb$F\x86n\x06\x86.N\x8e\xbf\xb5ig\x0c\x95\xd68\xdb\xce\xd1\xd5jc`he`\xe8\
\xe6\xe5\xf9\x13\xeb|\xdbR}\x15P=\x1b\xc3b5\xa5vV\xd6n\x01\xbeWz\xa2\x8b\x81\
\xe6s\xb2M\xd3T\xeb\x15\x16\xda\xc6\xcf2\x87\x95q\x0e\x0b\x03\xd0\xd7\x9b\
\xe2\xd6\x8a\x02\x03\x81\xb1$\xc8/\x98\xc1\xe1\xd9\x8d4\x10\'\xc9\xdb\xdd\
\x85\xa1\x83U\xd6\x03\xc8\xe1,\xf0\x88,\x06\x86\xb0*\x083.\xdbx\x8f\x13(\xc8\
^\xe2\xe9\xeb\xca\xfe\x90\x83\x8fKIj\x9aJ\xcaO\xa0\xd0FO\x17\xc7\x10\x89\xcb\
\xbe\xfd\xd7\xc5\x9a\x1cx\\\xca\x9bc7\x96\xbfa\xe5^\xd7\xc5\xf5m\xd3\xb7\xb8\
\x7f\xff\xd3c\x1c\x0e\xecQ)6N\xf7k\x128$1\x93U\xe6\xf8\x96\xc3?\x95\xf5\n\
\xaa-Z\xf6\xda\xd5;\xa8\x1f`w>Peq\xc8=9\xe2\xf2G\x96\x17\xe7R\xb4\xe6\x9eL:\
\xc3m\xf9\xc3\xf5)\xf7\xba\xa4\x95:!\x07\xb8\xd6_{\xb5\xe8\xc2\x06\xd3\xacmG\
\xb6]\xd9\xc8\xf8\xf2\xdb\xad\xa0x\xb9\x19-<\xee]V\xf3|\xd2\x8b\x9b\'\x1c\r\
\n\x0co\xb8&\xbd\xeb*\xc7\xcd\xb7\xfc\xc7\'\x9b\x1d\x9c\x19\x17\xa1\x1e\xfe\
\xb4\xcc|\xcf\x87\t\xf3\x1b^\xbc\xfe\x16\x17y\xfed\x8e\xab\xfd\x15;\x87\xed\
\xff2\xc3\xe2c7\nN\x8b\x95{a\x01t\xbcj\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd15\
2\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\
\x88\xa1\x81\x95\xb1\x89\x95\x91\x19D\xc3&\xc3y\x9b\x81\x1a\x18<]\xfd\\\xd69\
%4\x01\x00\x97\xa4\xf3\xa3' )

addArtData('wxART_DELETE_INTERSECTION', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xdfa\x10f<\x9e\xbf"\x05(\xc8^\xe2\xe9\xeb\xca\
\xfe\x90C\x90\x97])\xfaA\xec\x19\xa0\x90\xbf\xa7\x8bc\x88\xc6\xf9\xb5\x13\
\x0c\xf9\x18\x148\x98W~\xfc\x1f\xbf\xaeY\xe9\xaa\x84\xe4\x16a\xe7\xc3\xb2\re\
\xfe\xbd\x82\x9b\xbde\xb8\xd3\xf66\xa6:{rT2\x8a|\x93K\xb2\xb0\xd8}\xba\xf1\
\xd5\xa7w\x01_\r\xb6_t>jp\xe3\xd7\n\x7f>\xe1\xa2\xba+\xca\x8b\x18\x8f\xdf\
\x17TK\xb5\x13\xfe\x034Z\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\
\xeb\x1aX\xe8\x1a\x9a\x87\x18\x9aZ\x19\x1aX\x99\x98j\x1b\x18Y\x19\x18\x04vk\
\xfb\xa3h\xc8\xcdO\xc9L\xabD\xd1`le`nel\x02\xd1\xc0\x7f\xb9\xcb\n\xa8\x81\
\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\x86\x19f0' )

addArtData('wxART_DIRECTION_PS', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xcf\xf4tq\x0c\xb1\
\xe8\xed\x9d\x9c\xcd\xc7\xac\xc8\xd1b_\x15T\xb5\xa9(\xf8[\xfb\xc6\xb9\xaa\
\xdc\xd3Z$\xa6|\xefI;3i\x02\xdb\xda\xdb\xafEd\x04\x93\x19W\xaf\xb4\x17\xe4|\
\xf0\x8e\xe1\nK\xfe\xf7\xea\x8eN7\x97Ug_)\xb8\xcf\x7f\xe78\xf9\x8a\xf5W\xd9f\
\xf5\xbb\x86\xfd\xde>'Z\xae\xec]\xb1\xd6:+\xd0`\x83\xec\x93w\x1aS~\xc7\x9d[j\
U>w\xef\xad\xfb\x82o\xb6wK\xdblM:\xdd\xce\xd9\x1a\xb5\xd5u\xa1\xb7Pw\x882\
\x7f\x94Z\xde\xca\x1e\x99\x99?\xaed\x99\xbb\xddn<\xf5R\xbd\xc8\xebC\x7fL\x9c\
H\\\xa6\xc3\xac\x19\x7f\x81\x8ed\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xc9\x80W\xfb\
" )

addArtData('wxART_DIRECTION_TT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xcf\xf7tq\x0c\xb1\
\xe8\xed\x9d\x1c\xc8\xc7\xac\xc8\xe1"\x7fVn\xca\xbc5\xc5\xc1\xbf\x12=cb7\xa8\
\xd4\xach>t&\xc3M\x961\xf1\x82cEi\xfb$\x8e\x0e\xbe\xe2\xb5\xd2\xf2\x99\xda\
\x1c\x1c\x9e\x0c{\xee\xbe\x97\xbd9eRR\xac\xf11\r\xc3\xa7\x07\xdf\xcf\xcc\xcd\
?:\xed\xe8\xf23\xb3\xb8\x0f\xdc\xcd\x0fQ/\xb4\xdc\xbe\xfb\xf9\x8e\xd9J\xe1M\
\xe9\'yt\x14\xd4\x0eeY\xfe\x9fY\xff4i\x8f\xf9\xa6\xaf\x8e\xa2\xc5\xcb\xd7rM\
\x15\x9a\xcd\xb5\xf4\xd8a\x87\xb5\xfc9\xa9jsg\x9cY.$\xb9Vx\xfe-\xfb\xaa%\x7f\
\xb3\xe6\xd4?\xf9\xd8\x14\\\xc3h\xe6\x12>;\xc2r\xda^\xa0S\x19<]\xfd\\\xd69%4\
\x01\x00\x87rW\xd8' )

addArtData('wxART_DROP_FILTER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xba\x07\xf8\x84\xb8\xfe\
\xff\xff?o\xda\xd3\xec\xa9\x8f\x9d\xe2\'o=\xf9\xb4v\xc9\xfd\xed\xa7\x9em9\
\xfe\xa4v\xf1\xbd\x8a\x05\xf76\x1c{\xb6\xf6\xd0c\xa0`\xc5\xfc\xbb+\x0e<]\xba\
\xe7Ix\xe5\xce\x9aEw\xe7\xefxT1\xff\x9e\x91w\xd9\t\x0f\xab^a\xa1\x19\xcc\x0c\
\xf93\x9e\xe5M{\x9c;\xe5~\xf6\xa4[\x19\xfdWS\xbb/$\xb6\x9d\x8am:\x12]\xb7\
\xb7[\x80\xef\xe4\x9d\x1fg\xee\xff>u\xef\xf7\xb1\xdb\xbf\x0f\xdd\xfc\xb5\xf7\
\xca\xcf\x1d\x97\x7fl:\xfb\xad\x9b\x97\xa7\x95\x81a\x9a\xa6Z\xf6\xa4\xbb\xc7\
o\xff8v\xeb\xd7\xe1\x1b\xbf\x0e\\\xff\xbd\xeb\xf2\xaf\xcd\xe7~tqr\xb4\xb3\
\xb2\xa6t_\xda\x7f\xe5\xeb\xbe\xeb?w]\xfe\xb1\xf5\xfc\x8fI\xecl\xdd\x0c\x0cm\
\x0c\x0c\xf1\xcd\xc7\xb7\x9e\xff\xba\xe5\xdc\xf7\xc5|\x1cs8\x98\'12\xcc\xd1\
\xd5\xda\xc2\xcd\xb0\x96\x83a)\x1b\xc3|V\x86i\x1cl\'\x8c\x94\x0f\x08\xb1l\
\xe6bX\xc3\xc1\xb0\xdc\xc2\xe4}\xa4\xf35\x0b\xf5]<\x0c\xbf\x0b"\x7f\x94%\xdc\
2W=\xc0\xc7\xb0\x93\x87\xc1&\xa2\xe3_u\xca\xf7\xec\xd0\xfb:\x12\xe7\x85\x18\
\xf6\t\xb1\xd6.}l\x16P\xfb\xaf$\xe6g\xbc\xdb3e\xae\xbb\xe2\x0c\xc7\xa5\xb8m#\
;-\x82\x1b\x7f\xdb+~V`~-\xc3pVE\xf8\xab\x1c\xc3E\x039`\x182\x1e\xe8\xd3\x00\
\x06\xbfhI\x90_0\xc3\xdf\x7f\xff\x94\rYU\x8c\x98 \xf8\x9f\x11+\xd3\xbf\xf8=R\
@730&y\xbb\xbb0t\xb0\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdcB \xccx\xe9n\
\xdd\x1f\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\xa9i*)?\x81B\xab<]\x1cC$.\'\'8\xb0-Z\
\xc4\xb3\xa2\xc6\xb0p\x01\xc7\xe2\x96%S\xb6\xf4\xac\x99\xb3\xa7i\x85R\xc7\
\xf9\x03K\x96\xacY\xb4j\xd9\xba\x85\x9a\xab\x96\xae=\xcc#\x92p\xf1\xeaes\x03\
\x13#1\xd3\x8bf\xa2\xa9\xac\\\x1b6\xce\x9e\x19\x1d\x11\xd5\x19u\xfbFWQAS\xcf\
\xa3G\xdb6\x97\x17\x94\x08\x95\x97=|\xd8*q\xee\xb8\xfe\x83W\xcf\xde=\xd4<\
\xc1\xbd\xd9\xef\xc4\xe9\xdb\xc7\xaf\xdf\xf5\x97\xc8\xdb?\xbd\xdeaA\xbf\xfe!\
\xdb8\xc7\x83\x8a\x0b\x13\x1fr\xd4\xb9\xa4\x84\x94\xf8\xe4\xc8\xcc\x91\x9f?a\
\xc6\x949\x93\xb4\x98\xc4=\xbc\xcf\x9fp\xf98)<\xccl\x95\xbc\xe4\x9e\t\x96\
\x0cj\xeaR\x1b\xe7N*\x17\x03\xbaZ\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\
\x19\x18\x9a\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\
\x19\x18\xd8\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\
\xd8\xc4\xca\xc8\x0c\xa2a\x93\xe1\xbc\xcd@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\
\x00\xea\xffL%' )

addArtData('wxART_DUPLICATE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xe6\x07\xf8\x84\xb8\
\xfe\xff\xff\x7f\xd5\x8es@\xf2\xef\xdf\x7f\x86\xee\x99\xdf\x7f\xfc~\xf6\xfa\
\xf3\xc7\xcf\xdf\xef\x1e\x9b~z\x86\xf1\xb3W\x1f\x1e>}w\xfb\xc1\xeb\x7f\xdf\
\x8fu\xaf|\xf0\xf3\xf9\xdc\x19i\xc6\xdd+_\x18f\x1d}\xf3\xfe\xcb\x87S\x89\x1a\
!\xab\xaf\xdcz~\xf6\xea\xe3c\xe7\xef\xef?y\xfb\xe5\x87_\x0f^\xfd\xb8\xf6\xf8\
\x9b\xb0\xcbD\xb7\xa8\xaa3w\xbf\x1c\xba\xf6\xe9\xf3\xf7?;/|X\x7f\xf2\xdd\x9a\
\xe3o\xc5\xb5\xa6p\x00\xadf,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe8`\x95\xf5\x00r8\
\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.\
%\xa9i*)?\x81B\xad\x9e.\x8e!\x12\x97C\xcf\xdefjR\x10p\rLc(\xbd\xc2\xa6\xfdb\
\xd1\xa4e\x7f\xff\x9b\xb7]n\xbd\xd5\xff\xfa\xa1\x0c\xeb\xa4S\x8cJY\x06\xf5\
\x0btE\x9e\xb1o\xd1=8c}\xc3\xba\x15\xabf\x9b5/\x95\x15\xdc\xa8\x120\xa9x\xdd\
\xe3-\xbd\xbf\x0f\xb3\xb9\x7f\xba\xb7\xbf\xa1{\xc2\x82ez[\x1b\x9f\t45-\xb3\
\x9d\xab\x1f~l\xcb]\xfe\xe4\x90\x82\xc9\x12\xa9\xd5]\xf3\x8d\xafm\xb2M\xdfq\
\xfa\xdb\xa4\x85\xd3\xdf\x9a\x1e6\xf0\xfb\xbc\xc9\xce\xe8H\xb9\x7f\xb8.\xa7\
\x07\xafi\xa4\x11\xd0A\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\
\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\
\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VFf\
\x10\r\x9b\x0c\xe7m\x06j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xbex\xdb_' )

addArtData('wxART_ERASER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd\'\x91\x15\xc8WH\xf6\x08\xf2\
e`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x86\x05\x0b\x16\x00y\xff\xc1@\xcd\
\xb6\xc4\x1d\xc8a,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\xe4\xb0\
\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9a\xa6\x92\xf2\x13(d\xef\xe9\xe2\x18\
\xc2q=9\xe1\x00\x9b\x04++\xab\xa8\x03Obr\xb2\xb2@\xf3\xc5\x1b7"\x02\x19\xb5\
\x18&1qs(r3lu`\x991s\xe6A/V\x1e\x1e\x9e)\x12\x0b\x94\x12.Oih`\xb4\x07\xba\
\xb9\x83\xed\x94\xaa\xf1\x9fh\xa0Q\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\
\xc1\xc8\xc0\xd0\\\xd7\xc0B\xd7\xd00\xc4\xd0\xc0\xca\xd0\xc4\xca\xc4B\xdb\
\xc0\xc8\xca\xc0\xa0\x9c\xd3\x80\tECn~JfZ%B\x83\tH\x83\xb1\x89\x95\x91\x19D\
\xc3&\xc3y\x9b\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00m#\\}' )

addArtData('wxART_EXPAND_CENTER_PANEL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Re`hhf`\xf8\xf9\x1fH\xbfd`(5``x\x95\xc0\xc0`5\x83\x81A<\x7fR\xfcQ7\xa0Z\
\xf5\x00\x9f\x10\xd7\xff\xff\xffsz\xaf\x97\xab\x7f\xde\xb4\xfb\xf3\xf7 \x19\
\x1e\x8dR\xa0\xc8\xa3i\xde\xff\x95X\xfeo\xceX\xb5j\x95\x90n\x05P\xe4Pw\xcb!\
\xa0\x16\xc6\x92 \xbf`\x06\x87g7\xd2@\x9c$ow\x17\x9e\xc6\xcd\x81\xc9@\x0eg\
\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\
5M%\xe5'P(\xc0\xd3\xc51\x84\xe3zrB\x03\xa3\x9b\xa3\x81@\x82@\x10\x10\x84\x85\
\x05\xa6\x08\xf0\xb62\xb0m\xdc\xb2i\xcb\x96/[B\xd86\xf2\x08,\xe6=\xf1\x82\
\xc50m\x89\x91\xc7\x19 \xb5M\xc9E +a\xd7\x92\xb0\xc6\x83A\x0b8$\x96(I\\\xda\
\xad\xc8\xf0\x8e\x8b\xe1m\x89\xe6,\xd3|\x8f6\xa0\xd9\xaa%\xae\x11%)\x89%\xa9\
V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\
\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\
\xba\x86&!\x86\x06V\xc6&VFf\x10\r\x9b\x0c\xe7m\x06j`\xf0t\xf5sY\xe7\x94\xd0\
\x04\x00\t\x7f~K" )

addArtData('wxART_F', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R\x9c\x05\x1e\x91\xc5\x0c\x0c|G@\x98q\xaa6\x9f4P\xd0\xce\
\xd3\xc51\xc4\xa27\xb9\xa6j\xf1#{f\xd6\x86N\xa1\xb3<@\xa0s\x83%\xf6\xef\xfc\
\x84\xd0=\xd5\x8by\xe6\xc64\x9cw[\xb5\xbba[\x9c\x03\xff\x99\x8b\x0e2k\xd8\
\x12x]\x92\x98\xfa\xb3\xf4\x18\x186\xf3\xf3~\xdb_\xdc\xb9\x07h\x12\x83\xa7\
\xab\x9f\xcb:\xa7\x84\xa6\x0eVY\x0f\\\xd6\xb1\x97x\xfa\xba\xb2?\xe4\x10\xe4\
\xb3\xb28\xa7\x13\x14\x08\x14\x92\x01\xb9\x80\xe3zr\x82C\xc3\x9a\xa9\x06J\
\xcd\x8c\xad'\xa2\x18\x95/\xa8\x08\xb0\xf000\x04T\xb0w\xd7\xbd\xcbe\x02\xaaS\
-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06\x16\xba\x86\xe6!\x86\xa6V\
\x86\x06V&\xa6\xda\x06FV\x06\x06\x81\xdd\xda\xfe(\x1ar\xf3S2\xd3*Q4\x98X\x99\
ZX\x99\x9aA4,\xe6IfF\xf6\x01\x00f\x0eY^" )

addArtData('wxART_FILE1', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xd6\x05\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xde\x02\
\xcdh\xdc\xf7\xb2z\xc7s\x06\x83\x19\xbd\xc7\xdeU\xef|^\xb2\xf9\xc9\xddG\xaf\
\xcf]}\xdc~\xe8M\xe3\xbeW\xc5\x9b\x9f\xe4\xac}t\xf2\xe2\x83\xa6}\xafr\xd6>LY\
q\xff\xc8\xd9\xbb\xc5[\x9e\xa6\xae\xb8\x1f\xbb\xe8N\xd8\xdc\x9b\x97\xf7j\xda\
\x02Ma,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x81\xdeT\
\x05a\xc6e\x1b\xefq\x02\x05\xd9K<}]\xd9\x1fr\xf0q)IMSI\xf9\t\xf2\x8b\xa7\x8b\
c\x88\xc4\xe5\xd8\xf3\xa7\xc5\x9a\x0cx\\/\x1e\x0b\x10d]"\xd5q\x94i\xd1\xa3\
\xc7\xff\xeb\x03\x16\x9ee\xb2\xdd\xbc\xdb\xbd3\x88KE\xb4i*\xff\x07y\xa5?\x8c\
\xbc\xaf\x15\xe4Jx:\xb8/|Tc\x9c\xf1p\xf7\xf6\xdd%m\x85\xea\x99b\n\xdf\xdfr+\
\x17X\x04E~d\xf2s\xd9\xf6ls!\x93\xaf\xf7\xddV\xee\xeb\xdc1\xbaw\xdf\xe5\xfcr\
<`\xf7\xe2g\x92\xb9\x0b\x93\xa9\xe0\xde\xca?\xe6\x0c\xfe\x8a~\xcb\xeb\x19f\
\xbfg\xbf\xf3\xe1m\xcdT\xa0KTK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\
\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\
\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\
\x8c\xcc \x1a6\x19\xce\xdb\x0c\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00P\
\xd0\xddC' )

addArtData('wxART_FILE2', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd56\x06\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xde\x82\
\xcc\xd8\xf7\xb2z\xc7s\x06\x83\x19\xbd\xc7\xde5\xed{\xc5\xc0\xcc\\\xb2\xf9\
\xc9\xddG\xaf\xcf]}\xdc~\xe8M\xe3\xbeWU;\x9e\xe7\xac}t\xf2\xe2\x83\xea\x9d@\
\xc6\xc3\x94\x15\xf7\x8f\x9c\xbd\x9b\xb3\xeea\xea\x8a\xfb\xb1\x8b\xee\x84\
\xcd\xbd\x99;;|7\xd0 \xc6\x92 \xbf`\x06\x87g7\xd2@\x9c$ow\x17\x86\x0eVY\x0f \
\x87\xb3\xc0#\xb2\x18\xe8SU\x10f\\\xb6\xf1\x1e\'P\x90\xbd\xc4\xd3\xd7\x95\
\xfd!\x07\x1f\x97\x92\xd44\x95\x94\x9f@\xa1zO\x17\xc7\x10\x89\xcb\xb1\xe7o\
\x8a5\x19\xf0\xb8^<\x16 \xe9\xb2T\xa2\xb3\xa1\x94\xe1\xe8\xc3\xff\xf6\x01\
\x0b\xcf&Y\xe4\x97\xdb\xabziN\x98\xc2\x1f\xa6w@\x95\xc5\x82\x997[\x9f\xaf\
\x84\xa3C\xf8B\xa2\x08s\xcf\x87\xfb\'\xd5d\x17\xde/\xdc\xf5uC\xf1[c\xe5\t\
\xf2/">\xb0\xf8\x85\x84\x99\xce\xef\x15\xdd\x11\x93_\xf2\xfc\x8c\x19Sj\xb4\
\xed\xbc\x9cY~\x0b\x96^\xff}x\x1b7K\x96\xd2\xaf\xa2\xff\xeb\xd9\xe5\x9cd\xfc\
\xfe3.k\xe2`WVH\x9c\x0et\x8aj\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb7\
24\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\
\x95\xb1\x89\x95\x91\x19D\xc3&\xc3y\x9b\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00v\
\x99\xda\xa6' )

addArtData('wxART_FILE3', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xd6\x05\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7@\x03\x18\x98\
\x99\x1b\xf7\xbd\xac\xde\xf1\x9c\xc1`F\xef\xb1w\xed\x87\xde4\xed{U\xb2\xf9\
\xc9\xddG\xaf\xcf]}\\\xbc\xf9I\xce\xdaG'/>\xa8\xde\xf9\xbcx\xf3\xd3\x94\x15\
\xf7\x8f\x9c\xbd[\xbc\xe5i\xce\xba\x87\xb1\x8b\xee\xc4-\xbe\x136\xf7\xe6W\
\xb9u\xaf\x81\xe60\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\xcaz\
\x009\x9c\x05\x1e\x91\xc5@o\xaa\x820\xe3\xb2\x8d\xf78\x81\x82\xec%\x9e\xbe\
\xae\xec\x0f9\xf8\xb8\x94\xa4\xa6\xa9\xa4\xfc\x04\xf9\xc5\xd3\xc51D\xe2r\xec\
\xf9\xd3bM\x06<\xae\x17\x8f\x05\x08\xba,e\xebl\x08\x8d\xe3\xfa\xf7\x9f_kK\
\xe4\x82\xf4\xb2\xef\x1a\x81^\x8dKj6\x142\xfesn\xb0_\x90\xf8\xfah#\x1fc!\xab\
\xd5\x1dW\x06\xee\x9a\xf2=\xfeb3\xca\xa6\xc8\xd8\xc8\xc4.\xbf\xc21Gs\xf7\x93\
=M\xd9\x81i\xa2\xf7{D5:\xde\xf1\xfb\xe5\xea\x06\x98\xe9\x96\xe6\xbc\x8a[P\
\xb9/#\xe16;\x93\xe8\xc5\x1f\xcf^\xc6\xf3\xdb\xb4[\xcc\xff\xc78;\x8b\xfd\xa9\
\x9d\xcf\x83&\xa0KTK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\
\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\x81\
\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\x8c\xcc \
\x1a6\x19\xce\xdb\x0c\nvOW?\x97uN\tM\x00\xc2\x0e\xda." )

addArtData('wxART_FILE4', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5V\x07\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xdev\x1cz\
\xcd\xc0\xcc\\\xbd\xe39\x83\xc1\x8c\xdec\xef\xda\x0f\xbdi\xda\xf7\nhp\xc9\
\xe6\'w\x1f\xbd>w\xf5q\xe3\xbeW9k\x1f\x9d\xbc\xf8\xa0x\xf3\xd3\x94\x15\xf7\
\x8f\x9c\xbd[\xbd\xf3y\xce\xda\x87)+\xee\x85\xcd\xbdiY\xc3\xb1\x1d\xa8\x9a\
\xb1$\xc8/\x98\xc1\xe1\xd9\x8d4\x10\'\xc9\xdb\xdd\x85\xa1\x83U\xd6\x03\xc8\
\xe1,\xf0\x88,\x06\xfaQ\x15\x84\x19\x97m\xbc\xc7\t\x14d/\xf1\xf4ue\x7f\xc8\
\xc1\xc7\xa5$5M%\xe5\'P\xa8\xd6\xd3\xc51D\xe2r\xec\xf9\x8bR\x8d\x0e\x02m\x0f\
e/{\xb5\x98\x1d[qR\xa8\xf3\xf7~\xa7\xac\xf2y\x8f\xac\x7f\xdf_,\x99\xcc\x93\
\xa1\xc6\xd6-\xf0\xc0^\xe5\x07\xb3\xd8\xb4@\xa6\x1b"\x02\xe9\t\x97C\xd9\x0c\
\x0e\x96\xaf7\xff\xc9r\xf8\xdc\xa7\xdc\x96\xd8\x8cx\x8b\xd6O\x05K\x84\xcf?\
\x88\xb9z\xe9\xc3\xd1\xca\xd6W^%\x8f\x0fm\xe7\xdaz\xe7\xe5\xc1uoE\xe6)\xa9\
\xbc\xd9\xed\xb2\xf0e\xfc\xa7g\x0f\xefs\xd8\xb4Y\xcc\xfb\xc78\xdf\x8b\xfd\
\xcb\x19\xc7\xd3\xf1@\x87\xa8\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\
\x03Cs]\x03\x13]#\xa3\x10Cs+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\xe4\
\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\x84\x18\x1aX\x19\x9bX\x19\x99A4l2\x9c\xb7\x19\
\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\x00}\xdf\xe0\xb2' )

addArtData('wxART_FILE5', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5V\x07\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7\x0c\xcc\xcc\xd5\
;\x9e3\x18\xcc\xe8=\xf6\x0ehX\xd3\xbeW\xd5;\x9f\x97l~r\xf7\xd1\xebsW\x1f\xb7\
\x1fzS\xbc\xf9I\xce\xdaG'/>(\xde\xfc4e\xc5\xfd#g\xef\x16oy\x9a\xb3\xeea\xec\
\xa2;q\x8b\xef\x84\xcd\xbdiuq\xf15\xa0N\xc6\x92 \xbf`\x06\x87g7\xd2@\x9c$ow\
\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x18\xe8GU\x10f\\\xb6\xf1\x1e'P\x90\xbd\
\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92\xd44\x95\x94\x9f@\xa1ZO\x17\xc7\x10\
\x89\xcb\xb1\xe7o\x8a5\x19\xf0\xb8^<\x16 \xe8\xb2\xf4\x9a@W\xa8\xe4\x9c\x7f\
\xff\xb9Eo\xe9\\\xf8\\\xf6=x\xd1\x14&\xcf\xa3\t\xa2L\x7f\xdaY\xea\x1d\x0e[y1\
\xccez\xc4T\xb2\xeb$C\xda\x8fw5\xd1g\x0c\xde\xad\xb9\xe1z\xa3\x9do\xa9\xa0ET\
\xb6\xff\x96\x86\xae\xec\xeb\x17nV4r\x7f\xfe\xea\xb64\x9f5\xebz\xa1\xff2Y\
\x96;\x7f\x0f\xfa\x7frV\xba`\xb0\xff\x9e\xc9?\xe9\xc6e\x02\xcb/\xdbOqc?$\x1c\
P\x08r\x88j\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\
\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\
\x91\x19D\xc3&\xc3y\x9b\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00\x9bC\xddI" )

addArtData('wxART_FILE6', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd56\x06\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xde\x82\
\xcc\xd8\xf7\xb2z\xc7s\x06\x83\x19\xbd\xc7\xde1037\xed{U\xbd\xf3y\xc9\xe6\'w\
\x1f\xbd>w\xf5q\xfb\xa17\xc5\x9b\x9f\xe4\xac}t\xf2\xe2\x83\xe2\xcdOSV\xdc?r\
\xf6n\xce\xba\x87\xb1\x8b\xee\xe4\xac}\x18\xb7\xf8N\xd8\xdc\x9b\xcf\x1aW\x06\
\x02\rb,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x81>U\x05\
a\xc6e\x1b\xefq\x02\x05\xd9K<}]\xd9\x1fr\xf0q)IMSI\xf9\t\x14\xaa\xf7tq\x0c\
\x91\xb8\x1c{\xfe\xa6X\x93\x01\x8f\xeb\xc5c\x01\x82\xae\x0b\xa5zY\xd74=\xfa\
\xf2_\xfe\xc4\x85\xb4\xc6y\xdbw\xcf\x17Z*\xe2\xa1\xc5\xc2-\xff\xc0\xde\xe5\
\x07\xb3\xd44G\x9b\x17\x12\x02\xe9\x0b\x1e\x872\x198\xee\xbf>\xbb\xa4)Q\xfd\
\xa5\xd9\x81s\xd3\x9f\xba%\xd4/x\xdc\x99^\xb0\xcd5\xf2\xe3Q\x8bF\xed\x9b\xd1\
gwf\xb3p\xed\xba\xcd>{\x99\xa8\xc6KO\xfd\xb2\\\x95\x80\xbd/??}x\x9f\xc1\xa6\
\xcdb\xde=\xc6\xc5{9\xd8\x98jeN\x03\x9d\xa2Z\xe2\x1aQ\x92\x92X\x92j\x95\\\
\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\
\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\x12bh`elbed\
\x06\xd1\xb0\xc9p\xdef\xa0\x06\x06OW?\x97uN\tM\x00+x\xe0!' )

addArtData('wxART_FILE7', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xd6\x05\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7@\x03\x18\x98\
\x99\xabw<g0\x98\xd1{\xec]\xfb\xa17M\xfb^\x95l~r\xf7\xd1\xebsW\x1f7\xee{U\
\xb5\xe3y\xce\xdaG\'/>\xa8\xde\td<LYq\xff\xc8\xd9\xbb\xc5[\x9e\xa6\xae\xb8\
\x1f\xbb\xe8N\xdc\xe2;ason\xb7I\xcb\x01\x9a\xc3X\x12\xe4\x17\xcc\xe0\xf0\xec\
F\x1a\x88\x93\xe4\xed\xee\xc2\xd0\xc1*\xeb\x01\xe4p\x16xD\x16\x03\xbd\xa9\n\
\xc2\x8c\xcb6\xde\xe3\x04\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9a\xa6\
\x92\xf2\x13(T\xeb\xe9\xe2\x18"q9\xf6\xfci\xb1&\x03\x1e\xd7\x8b\xc7\x02\x04]\
\x97\xba(\'\x84\xde;\xf4\xff\xff\x02\xa7\xd9\xacUi\xe5\xfdBKE<N\xb1K\x8b?\
\xb0g\xf9\xc1,\xb5-N\xe6\x85\x80@\xf8\x82\xc3\xb1,\x1b\x0e\x94\xbf\xe7\xff\
\xc8t\xb9\xef\xd1\xe2\xf6\xc9\xaf\xe7H4NyQ\xf4T\xf4\xce\xa69\\\xfb\xa4\xb5\'\
\xd8\xce\xfb\xf2\xe8\xc84\xa6J\xd7\xd2\xc3\xcbrXW\xf5\xfd2\xbfm&\xa0\x91%\
\xe56\xef\xdf\xd7\x03\xc5\x1d\x9f_\xca\xcf\xf4b\x7f\xdcq\xe3\xba\x11\xd0!\
\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\
\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\
\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VFf\x10\r\x9b\x0c\xe7m\x06\
\x85\xba\xa7\xab\x9f\xcb:\xa7\x84&\x00$R\xde\xa7' )

addArtData('wxART_FILE8', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xb6\x04\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xde2037\
\xee{Y\xbd\xe39\x83\xc1\x8c\xdec\xef\x80F6\xed{U\xb2\xf9\xc9\xddG\xaf\xcf]}\
\xdc~\xe8M\xe3\xbeW\xc5\x9b\x9f\xe4\xac}t\xf2\xe2\x83\xe2\xcdOSV\xdc?r\xf6n\
\xf5\xce\xe79\xeb\x1e\xc6.\xba\x93\xb3\xf6a\xdc\xe2;aso\xfe\x93\x7f~\x02\xa8\
\x99\xb1$\xc8/\x98\xc1\xe1\xd9\x8d4\x10\'\xc9\xdb\xdd\x85\xa1\x83U\xd6\x03\
\xc8\xe1,\xf0\x88,\x06zV\x15\x84\x19\x97m\xbc\xc7\t\x14d/\xf1\xf4ue\x7f\xc8\
\xc1\xc7\xa5$\xfdP9$\x1f(T\xe7\xe9\xe2\x18"q9\xf6\xfcE\xa9F\x07\x81\xb6\x87\
\xb2\x97\xbd\\\xd6N3L\rt\xd9\xf1\xff\xf7\xe2\xb2\xe7\x9a\xfb6\xff\xb7\x9d\
\x15\xe8\xd5\xb8\xc4\xc9\xe03\xe3?\xe7\x16\xfb\x05\x89rG\x9a\xfb\x18\x0b\x99\
\xac\xe2T\x18\x94k\xbe\x17M\xed\xbb\xf0^%\x96\xfd\xc6\x8fMw8r\xb8w\xdf\xbe\
\xcc\xc2\x17S\xe4\xea\xfe\x98\xc5/\xbdz\xa5fy\xaf\xc3\xc9\xf0j\xe5\xcb[\x98\
\xca\xeb\n\xdc\xd7\xf5\xb2\xacR\xdf\x7f\xef\xca\x7f\xe9\x866\x81\xf6\xcb\xf6\
\xcb\xbfr(\xad]}s\x0e\xd0%\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\
\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\
\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6\
&VF\xe6\x10\r"nS\xd9\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00P\x00\xe1\xeb' )

addArtData('wxART_FILE9', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd56\x06\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=s\xff\xc9\xdb\x7f\xff\xfe}\xf6\xfa\xf3\
\x8f\x9f\xbf?\x7f\xf9\xf1\xf2\xcd\xa7w\x1f\xbe>y\xf1\xfe\xfe\x93\xb7\xb7\x1e\
\xbcr\xe9\xbb\xf8\xf0\xd9\xbb\x1b\xf7^^\xbe\xf9l\xc2\xc9\xf7=\xc7\xde2037\
\xee{Y\xbd\xe39\x83\xc1\x8c\xdec\xef\x80F6\xed{U\xb2\xf9\xc9\xddG\xaf\xcf]}\
\xdc~\xe8M\xd5\x8e\xe79k\x1f\x9d\xbc\xf8\xa0z\xe7\xf3\x94\x15\xf7\x8f\x9c\
\xbd[\xbc\xe5i\xce\xba\x87\xb1\x8b\xee\xe4\xac}\x18\xb7\xf8N\xd8\xdc\x9bg\
\xe5\xf7\xf6\x00u2\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\xcaz\
\x009\x9c\x05\x1e\x91\xc5@\x9f\xaa\x820\xe3\xb2\x8d\xf78\x81\x82\xec%\x9e\
\xbe\xae\xec\x0f9\xf8\xb8\x94\xa4\x1f*\x87\xe4\x03\x85\xea=]\x1cC$.\xc7\x9e\
\x8f\x95nt\x10h{({\xd9\xcbE\xf7\xf4\x8cM/\x9a\x1f\xfd\xff\xef\x90U\xbe\xee\
\x91e\xf5\xfb\xc5\x92KE<\xb4X\xb8\xe5\x1f\xd8\xbb\xfc`\x96\x9a\xe6h\xf3BB }\
\xc1\xe3P&\x83\x83\xe5\xeb\xcd_\xb2\x1c\xf6\xbb\x94\xdb0W\xfft\xef\x81\x7f\t\
\xfd\xea\xb3\x0e\xce\xe4\x8e\xbet\xd4\xa2Q\xfb\xfe\x0f\xbf\x9d\xabY\xbaf\xe5\
:/\xcbb}u|\xb2uQ\xaeJ\xc0\xb7?U\x97?\xe43H9\xcb\xf8\xffgX2\x9fC\xfc\xceb\x85\
g@\xa7\xa8\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\
\xa3\x10Cs+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xa8\x1ar\xf3S2\xd3*\xa1\x1a,t\
\rMB\x0c\r\xac\x8cM\xac\x8c\xcc!\x1aD\xdc\xa6\xb2\x0350x\xba\xfa\xb9\xacsJh\
\x02\x00\xc7\xf7\xe0\x05' )

addArtData('wxART_FILE_BROWSER', 'wxART_OTHER_C', 16,
b'x\xda\xa5\x90mH\x93Q\x14\xc7\xaf\x98\xf9\x96\xb6P\xd2\xcaH-c \xa3gs\xa5=eK\
q\xea4\x87\xe9,\x15\xcawC\xc8\x94\\a\x1a\xb4\xf9\x12iR\xa4\x89\xf9Bi\x9fb\
\xa1\xd0\x07\x91\x8a\xf0\x890\xca\x8a\x9200\xb5\x9c\xbags\xdb\xb3\xedy\xb9w\
\x1a\xe2\xbaR_\xfa\xdc\x81s\xff\x9c\xc3\xf9\x9ds\xeei\xcbV\xa7\x05\x05\xec\
\x0e\x00\x00\x04\xa9\xd2Sr\xb0\x8a6\xdd\xcf\x1b\xbfb\xc9\xf6\\,[.$e%\x01\xf0\
\xecn\xe0z\x89\x0f\x8e#\xcb\xd2s\xb2\x00h\x88\x01@\xd7\x0c\xc0\x9a\x07\xeb\n\
\x00W\x08\x00\xac\xc5\x00\x90\x0f\x00\x08\xab\xe9,\x9aH\xc5\xb5k\xd9\xa74J\
\x8f\xc7\x03t\xba\xd0J\xaao\x12\xc5\xf50k\xd5\xc4\xae\x93w\xdc\xd8\x90\x1b"7\
\x0f\xdd\xbc\x80X\x019y\xc4\xb0\xc8\xee\x82V\xa7`v\x08&FX\xb6\x0b\x8b6\x1e\
\xb9\xdd\x10"\x8eG\x0e\x0e\xd9Yh\xb4\xe2rL!N@.\x1eA\xe8\x16 rr\x90a\xa1\r\
\xb3.hq\nN\x0e\xad8\xa1\x99\x81\xb4]X\xb2\xf3F\x1b\xbf`\xe5~X\xb89\x0b\xff\
\x9d\xe6X\xdc\x8a\x85\x16\x07\xa47G\xf0\xf3\x16n\x96\xe6fh\xd6\xc1\xe1\xd1\
\x18\x87\xcb\x8c`f\x84%\x1b\xdf\xf5x\x0c/\xcf\xc3U\xda\xeaZ01\xef\xa6\x16\
\xc6\xdf\xcf\x06]\r\xa1(J\x9aV588\xa8\xd3\xe9j\x1bZ\x19*\x93\xea>\xf2eP\xf1\
\xf9a\xa2B\xa1X5\r\xac\x9a\xfa?v\xc7v\x98ma\xf8\x08\'\xb49j|H\xfa?\xec^Q\x97\
\x1ew\xf2*\xcdLK\x01\xb7|\xf6\xa6\xe3\xc0\xbf6\xbd\xa0\x0e\x80\xc0\x90M\xf7\
\x02}\x03\xe18\xe9\xabUe)}\x8d~\xc1\x01\xd1{\x8c\xfb558E\xa9R\x924\xe1_\x95\
\x9f\xcc\xc1MD\xe8Mc\xe1\xa8#\xd1F\xe9\x1b\x9d\x92K\xa7\xc5;_yn\xb3\x1aU}\
\xe7\x86\xa5\x7f\xe0\xba_\xd4D\xd3F\xc4\xa4\xb1\x9e,\x1a\x19{\xd9\xae\xf7.1\
\xb1\xeb\xcf\x9f\xaa{f[w\x1c4\xb4\xaeG\xda\xd9_\xeb\xfabqD\xdb\xdb\xc5\xb6\
\x03-\xf7\x0f\rW$\x17\x18l\r\xd1\xbd!QE\xe2\x8c\x82\xc9mo\xea\xa5[\x874\xc1\
\xae\x8c\xbcJzV\xfe3\x9azTg\x90\x9e\x13\xbd\xdew?axz&M4$>\xfcd\xee\xe2\xe8\
\xb1\xf9\xf37\x88\x16\xc2\xd01j)\'\x9b\x9b\xd7J\xfd\x93\n\xa7`\xe5\x8b\xd1\
\xb3g\xf2z\x9d\x8b\x8d\x8d\xad\xa2\xfc(\xd4N\x19\x0bb-\x81\xb2\x86\xd8\xbcop\
|\x1a\xff%F\xab\xcc\xd7\x96\x97h+\xc8\xb2\xcb\x15X\x80\x8c\x90\xc6K\x08\xb9D\
&\xd3H\xe3I\xa9\x9c\x8c;\x1aK\xc8H\x828\x9e\xfb\x81\xfe\x07\xa8\xae)\xaf\xaa\
\xbc\xf6\x17H\x90H\xe5\x1a)A\xc6\xc9IY\xfc\x1f 4\xb5\xdb\x17\x03@\xa5T\xa7\
\x8c$\x177\xfd\x06$!\xac_' )

addArtData('wxART_FILE_CLOSE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\r\t\xf0\tqehh\xf8\xff\
\xff\xbf\xa6\x81\x95\xa1{\xe6\x99\x99\xc6\xff\xfe\xfd;3\xc3\xf8\xff\xaf\x07+\
\xcb\x8d\x7f\xbf]\xf3\xe5J\xe9\xff3i\xff\xbe\x1f>6\x19\xc8]u\xa0\xd7\xf8\xc7\
\xc3\t;\xda\x8c?]*\xdeTo\xfc\xee\x90\xff\xaa\n\xe3W\x9b\xb4\x97\x14\x19\xbf\
\\\xaf:7\xdbxF\x9a1\xd04\xff\x8b\xee\x0b\x80\xe63\x95\x04\xf9\x01\xddX6\xf9\
\xac\x05\x90\xc7\x98\xe4\xed\xee\xc2\xf8\x9fI\xf7\x1e\x90\xc3Y\xe0\x11Y\xcc\
\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0q)I?T\x0e\xc9\
\x07\n\xe5x\xba8\x86H\\\x8e=\xff\x9a\xaf\xc9\x80\xa7\xeda\xdeZ\xd6W\x8c,\xac\
\x1f\xff\xe9O\xf9\x16\xac\xf3\xf1\xe4\xa4\xa5\xf9\xdf\x16+\xffZu\xe4\x8cKk\
\xddA\xf5$\x96B\xb9\xac\xdeG\x8e~~\xdf\xdb[\x970\xf2\xea:M\xb7;\xe83\xb9\xc2\
\xe2\xb5j\xac\xe0.\xe9#W\x95y^\xf6%\xa4)\xf7\xf5\n\x1fR\xb6\x15|\xb6\xe5\xc8\
\xb2_^\xd9\x7f\x9e\xd6>\xe8\x9ej/\xed\xb1\x97\xe3Ce\x18\xf3Q\xa0\xbd\xaa%\
\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\
\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\
\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VF\xe6\x10\r"nS\xd9\x81\x1a\x18\
<]\xfd\\\xd69%4\x01\x00\x1c\xfe\xad\xc1' )

addArtData('wxART_FILE_CLOSE_ALL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\r\t\xf0\tqehh\xf8\xff\
\xff\xbf\xa6\x81\x95\xa1{\xe6\x99\x99\xc6\xff\xfe|\xddP\xad\xf7\xe7\xd3\x81\
\xef/\xd6\x7f\xb9V\xf5i\x7f\xe4\x99\x19\xc6\x8f\xd6{^X`\x7fn\xae\xcd\x81\xa9\
f\xdb\xa7Y\xfd\xfd\xba\xef\xd2\xaa\xd0\xcfW+\xbf\\\xad<<\xd5\xe5\xed\x01\xef\
]\x9d\x96/7hl\xae7X]a\x004m\xbf\xe6\xd1\xef@\xf3\x99J\x82\xfc\x80n,\x9b|\xd6\
\x02\xc8cL\xf2vwa\xfc\xcf\xa4{\x0f\xc8\xe1,\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\
\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94\xa4\x1f*\x87\xe4\x03\x85*<]\
\x1cC$.\x87\xf6\x9f\x16;d\xc0\xc1\xea\xe9$\xa5t5\xeb\xf5\xef\xff\xf6!z!\xb9\
\xea\xb3\r\xd2\xc5\x1c\x9e\xa4h-}09Ct\xc6\xa9\xb0'2\xc7X\x8c/\xcfw\x89\xc9N5\
\xa8q\xcd6\xeb<\xe1\xff%6\xf9\xd1\x86\xec\x98\x1ci\xf1\x8cY\x1d\xe6\x9d%.\
\x8b\xdd\x0bf\x9d\xdb\xd6\xbe\xe8\xa2\xb7Ar\xb0\xc9-\xf1\xea\xbfU\x9f\xaf\
\xae\xbdX\xfd\xa1#\xba\xe4J\xfa\x87\xa8\xfe\xcb\xdf\x05\x02~1\xbcmd}\x98\xcb\
\x96\nr\x96j\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\
\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\
\x919D\x83\x88\xdbTv\xa0\x06\x06OW?\x97uN\tM\x00\xe5\x9e\xb3P" )

addArtData('wxART_FILE_NEW', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\r\x0c\xf0\tq\xfd\xff\xff\
?CC\xc3\xe4E\xdb\x81\x0cC\xf7\xcc\xbf\x7f\xff\xee?y\xfb\xc7\xcf\xdf\xcf^\x7f\
\xfe\xfc\xe5\xc7\xbb\x0f__\xbe\xf9\xf4\xe4\xc5\xfb\xfbO\xde\xdez\xf0\xea\xd7\
\xef?_\xbf\xfd\xfc\xf0\xe9\xdb\xebw_\x9e\xbd\xfa\xf8\xf0\xd9\xbb\xbb\x8f^\
\xdf\xb8\xf7\xf2\xf2\xcdg\xe7\xae>>y\xf1\xc1\x91\xb3w\xf9\xfe\x05\xe4\x02\rg\
*\t\xf2\x03:\xb0l\xf2Y\x0b \x8f1\xc9\xdb\xdd\x85\xa1\x83U\xd6\x03\xc8\xe1,\
\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\
\x94\xa4\x1f*\x87\xe4\x03\x85\xd2=]\x1cC$.\x87\x9e\xf7\x14jP\xe0q\xb9( \\0\
\xef\xf9o\xf9\x90\rK\x0f\xbc\xf9\xb7\xfa^K\xc7e\xc9\xe4\x8e\x8e\xee\n\x9d\
\xfa\x80m\x93\x9a\xad\xf4\xd6\xaa\x04\x84o\xf4`\xba_zX\xc6\xf1~\xden\x8eW\
\x17\xfe\xb2\x1f\xb6\xf0\xfd\xbc)\xef7\xe3\x07\xdb\xc5\xfe\r\xefYk\x19\x0f\
\xc9\xd42\x1f\x92\xc9eL\xec\xfb\x97p\xf6_\xad\xe3\xa7\xc5\xec\xf2\x9a\xec\
\xed3\xb2fj\x03\xadT-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\
\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\
\xab\x84j\xb0\xd054\t14\xb026\xb122\x87h\x10q\x9b\xca\x0e\xd4\xc0\xe0\xe9\
\xea\xe7\xb2\xce)\xa1\t\x00y}\xba\xc1" )

addArtData('wxART_FILE_OPEN', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaau\r\xf0\tqehh\xf8\xff\xff\
\xbf\xa1{\xa6\xa6\x81\xd5\x99\x99\xc6\xff\xfe\xfd;3\xc3\xf8\xcf\xfbc+\xcb\
\x8d\x7f\xbf]\xf3\xe3\xe1\x84/WJ\xff}?\xfc\xee\x90\xff\xef\xb7\xabv\xb4\x19\
\xbf\\\xaf\xfa\xe9R\xf1\xaa\n\xe3W\x9b\xb4\x97\x14\x19\xcfH3\x06j?7K!\x14h S\
I\x90\x1f\xd0Qe\x93\xcfZ\x00y\x8cI\xde\xee.\x8c\xff\x99t\xef\x019\x9c\x05\
\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\xfd\
!\x07\x1f\x97\x92\xf4C\xe5\x90|\xa0P\xa6\xa7\x8bc\x88\xc4\xe5\xd8sw\xf9\x1a\
\x148X\x13\x82\x16M1\xfa\xfd\xf1o\xbc\xe9\xc1I\xd7\xb6\x17\x16\x9e\x9b\xc3p\
\xc1\xf2\xf9\x81\xc3\xea\xa73\x1aCO\xdf\xf3nLv\xfd&\xa4\xee\x9atMiF\xd8\x11\
\x0fy\x8e\x13>\xdd+\x8fzi.\x9d '\x9d\xb0,c\xdb/v\xc3\xcf\xf7\xd2\x9e;w]\x95\
\xd9\xd4Zd\x17?\xfd\xdd\xd9\xd8\xcc\xed\xd3\xfc\x1e\x7f(f\xfe\x9c\xcf\x1e5\
\xcdv\xb2\x1a\xd0R\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\
\xaek`\xa2kd\x14bhnehbel\xa9m`de``\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\
\xa8\x06\x0b]C\x93\x10C\x03+c\x13+#s\x88\x06\x11\xb7\xa9\xec@\r\x0c\x9e\xae~\
.\xeb\x9c\x12\x9a\x00\x11\xa4\xa5\x94" )

addArtData('wxART_FILE_SAVE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fuc``\xcc\x0e\xf0\tq\xfd\xff\xff?o\
\x99p\xf4\xea\x02\x06/\x06 \xfb\xcb\x8f\xaf/?\xbc\xba\xf7\xf2\xee\xa5\x07\
\x97O\xdc<\xbe\xfb\xd2\x9e\x8d\'7,=\xb4\xd4\xb8\xd9\x8eA\x96!by\xce\x8f_?\
\xfc\xfc\xfc\xe6\xed\x99\x0b\xb4,di\xc6\x87\xaf\x1f\x9e\xbc}z\xf3\xe9\xcdsw\
\xcf\x1d\xbevh\xfb\xb9\xedk\x8e\xadY\xb8o\xc1\xd4mSuj\xcc\x02\x17&\xbf\xf8\
\xf0\xe2\xce\xf3;\x17\xef_<v\xe3\xd8\xae\x0b\xbb\xd7\x9f\\\xbf\xe4\xc0\xe2\
\x19;g\xf4l\xec\xd1\xac4\xf2\x9d\x1b\xff\xe0\xe5\x83\x96\xd5\xadje\xba^\xb3\
\xa2\xae?\xb9q\xe6\xce\x99\x83W\x0el=\xbbu\xd5\xd1U\xf3\xf7\xce\x9f\xbcur\
\xc7\xda\x8e\x9ae\xb5JE\x9an\xd3\xc3\xcf\xdf\xbfp\xe4\xda\x91\x9d\xe7w\xae;\
\xbev\xd1\xfeE\xd3wL\xef\xde\xd0\xdd\xb0\xb2\xa1dA\xa9|\xbe\xaa\xd3\xe4 \x87\
~?\xb9|U\xa9lE\xfb\t~6=^\x16\x9dnf\xadNFM\xb6\xfa\xf5\x96\xda5\xa6\x1a\x95\
\x86\xaa\xa5\xba\xd2\xd9\n\xe2\x192\xd6=\x9e\x96\x1dn\xccr\xcc\xe2\x19\xb2")\
\x92\x96\x1d\xae\xa6\xad\x8e\xdf\xbe}}\xfd\xfa\xf5\x83\x07\x0f\xaf]\xbbv\xe6\
\xcc\x99\x83\x07\x0f\x8a\xa4H\x08$\x8a\x186\xd9\xfe\xfe\xfd\xfb\xf6\xed\xdb\
\x17.^<~\xec\xf8\x9e={\x04\x13Exb\xf9\xf5\xea-\xfb\xfa\xfaN\x9f>\xb3m\xdbv\
\x9e8\x01\xce(\x1e\xedj\x93\x0f\x1f>>}\xf6\xf4\xe2\xc5\x0b\xc7\x8e\x1d\xdb\
\xb3{\xf7\xc6\x8d\x1b9\xa3y\xd8\xc2\xd9\xdbR\xc5<\x80\xa1\xc6X\x12\xe4\x17\
\xcc\xe0\xf0\xecF\x1a\x88\x93\xe4\xed\xee\xc2\xd0\xc1*\x0b\x92\xe1,\xf0\x88,\
f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94\xa4\
\x1f*\x87\xe4\x03\x85\xcez\xba8\x86H\\NNHpa\xe5\xe1\xe9\xf19\xa3\xb3&\xe7\
\x8d\xcc\x9c\x98;6g\xf6\xd480\xd6\xa51:r\x08$\x89\xb1qv\x18twuz{xy\x9e>at\
\xba\x91\xe5\xc9LQ\x91\xa9SBC\xae^1\x9da\xea\xc8\x14u\xe6V\x80\xae\xd5\x99]\
\n\x8c\xb6i\xb5\xcc\xce\xca\xc9\xc2\xc1\xc6\xc5i\xdc\x13\x1aT7O\xdd\xda\xbbv\
\xee\xde\xe6\xc5\xc2\x9b\x8d=\x0e\x1c\x9d*\xc9v\xe7\x8e#\x93\xdc\xbc\xb8{v\
\xfb\xea\xfe1\x8a\xe55:*4>\x98\x10 \xc1\xc1\xcd\xce\xe9\xe2\xd2\xb6\xc9\xc5\
\xf5\xf8\x91cG\xdb\xd5T\x9aX\x94&;Mnm\r\x0e\xba|\xc9\xd9\xd8\xc8\x91\xc93ra\
\xe0\xa1\x9b\x1b-?\xee\\X\xf9S\xa1qM\xd3\x85C\x8b\xa6<\x9ati\xd3\x85O\\\x0b\
\x18\xe4\xb5\x18\x18\xb6NV?\xf5M a6\xd0c\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\
\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\
\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\
\x86\x06V\xc6&VF\xe6\x10\r"nS\xd9\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00Y\x7fg)'\
 )

addArtData('wxART_FILE_SAVE_ALL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\x9d\x13\xe0\x13\xe2\xca\
\xd0\xd0\xc0[&\x1c\xbd\xba\xe0\xff\xff\xff\xef>\xbf\xbd\xf3\xfc\xce\xe9\xdb\
\xa7w\x9e\xdf\xb5\xe2\xf0\n\xd36G\x06Y\x86\x88\xe59_~|}\xf5\xf1\xd5\x8d\xa77\
\x8f\xdf<\xb1\xf5\xec\xb6\xb9{\xe6\x01u\x07.J\xf1\x9e\x1d\xf3\xe0\xd5\x03\
\xd7\xa9!\xf6\x13|\x05\xec9-;\xdd\x8c\x9b\xedd\xa2,\x96\x1c\\:y\xebd\xcdJ\
\xa3\xf3\xf7\xce\xef\xbd\xb4w\xf5\xb15\xb3v\xce\xee\\\xd7\xa9T\xa2e\xd9\xe5f\
\xd2\xe2\xa0Wg\xa1Qi\xa8T\xac%\x9b\xab,\x9e.\xf3\xe1\xeb\xc7;\xcfo\x1f\xbby\
\\0I\xe4\xc5\xfb\x17\x97\x1f^\xd9wi?w4\xef\xf7\x14{\x90;\x19K\x82\xfc\x82\
\x19\x1c\x9e\xddH\x03q\x92\xbc\xdd]\x98\x05y|>\x019\x9c\x05\x1e\x91\xc5\x0c\
\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\
\x92\xf4C\xe5\x90|\xa0P\x9d\xa7\x8bc\x88\xc4\xe5\xd0s/\xf9\x9a\x0c\x04\xdc\
\x02\xd9\x04\xb6vy\xc5J\x98\x15:\xa7\x04:\xdc\xfb\x7fWA6\xc3\xe8\xfe\xfe{O|\
\xb2\x1a\xe692_\xde$~\xaeh\xabX\xf1\x8d\x9c\xbbw\xff=\xf0\x94\xed\xd3\x0b/\
\xb0*f\x15\x9f\xaf\xfda\xa26\xc7\x04m\x8e\x89\xab=8\x82\x1e[\xfb\xad+q[\xf9\
\xa5\xac\xde&^d\xca\xa9{?\x97k\x84*,\r{\xf9\x9fM\xe3\xf5{~iY\xa7)\xb9\xdf\
\x8f\xd7\xf1-\x9ee\xc6\x90\xe8\xc8\xad\x9e\xa4\xe26\x15\xe8\x12\xd5\x12\xd7\
\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\xaek`\xa2kd\x14bhnehbel\xa9m`de`\
`\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\x10C\x03+c\x13\
+#s\x88\x06\x11\xb7\xa9\xec@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\xd3\x99\xd1\
*" )

addArtData('wxART_FILE_SAVE_AS', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa}\x12\xe0\x13\xe2\xca\xd0\
\xd0\xf0\xff\xff\x7f\xde2\xe1\xc9\x8b\xb6G\xaf.\x00\xb2\xdf}~{\xe7\xf9\x9d\
\xd3\xb7O\xef<\xbfk\xc5\xe1\x15\xa6m\x8e\x0c\xb2\x0c\x86\xee\x99\x11\xcbs\
\xbe\xfc\xf8\xfa\xea\xe3\xab\x1bOo\x1e\xbfyb\xeb\xd9ms\xf7\xcc\x03\x1a\xf3\
\xf7\xef\xdf\xfd'o\x07.JYrp\xe9\xe4\xad\x935+\x8d~\xfc\xfc\xfd\xec\xf5g\xef\
\xd91\x0f^=8\x7f\xef\xfc\xdeK{W\x1f[3k\xe7\xec\xceu\x9dJ%Z\x9f\xbf\xfcp\x9d\
\x1ab?\xc1\xd7\xb2\xcb\xcd\xa4\xc5A\xaf\xceB\xa3\xd2P\xa9XK6W\xf9\xdd\x87\
\xaf/\xdf|\x12\xb0\xe7\x14O\x97y\xf2\xe2\xfd\xfd'o-;\xdd>|\xfdx\xe7\xf9\xedc\
7\x8f\x0b&\x89\xdcz\xf0\xca\xb8\xd9\xee\xc5\xfb\x17\x97\x1f^\xd9wi?w4\xef\
\xddG\xafo\xdc{y\xf9\xe63\x99(\x8bsW\x1f\x7f\xfd\xf6\xf3\xc3\xa7o\xaf\xdf}y\
\xf6\xea\xe3\xc3g\xefN^|p\xe4\xec\xdd\xdb\xadW\x17\x03\x1d\xcaT\x12\xe4\x07\
\x0c\xb3\xb2\xc9g-\x80<\xc6$ow\x17\xc6\xffL\xba\xf7\x80\x1c\xce\x02\x8f\xc8b\
\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\xe9\xeb\xca\xfe\x90\x83\x8fKI\xfa\xa1rH\
>Ph\x99\xa7\x8bc\x88\xc4e\xdfS\xa1L\x87\x0c\x04\\/ni6>\xe8]8\xfd\x11\xef\xbb\
-\x15\x89\xff\x7f/\xf4\xdc\xf0\xbd\xfc<O\xe0~f\x85\x16\r\x97\xaf\x15\xb5\xff\
\x1c\x0cD\xdc\xf4\x03\x18'f\xe8\xcc\xf3Xf\xe2\xd3\xecg\x99R\x91^\\\xa9\xe3\
\x10\xb8\\o\xca\xa9\xa9Yk\xefe$qk<\xbd`fu7\xae\xde\xe0\xc8D\xce\x03\x07\x13\
\x92\x92M\xd4\x83\x19\x8d\x97\x9d\x15\xf7\xdev\xe8d\x89n\xc2\xe1-o\xf3\xce\
\xf3e\xdct\xe7S\xffs\xc6n\x9e\xa5\xc0\x8e\x98\xfc\xef\xbb\x1f\xdf;\xcf\xcf\
\x99g\xbdi\xbe\xd0\x9dm)\xaf\x85~\xec~cn\xf1a6\xc3/\xfb\xa7\xacY\xf1\xd2r\
\xf6a\xed\xbf\x81.V-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\
\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\
\xab\x84j\xb0\xd054\t14\xb026\xb122\x87h\x10q\x9b\xca\x0e\xd4\xc0\xe0\xe9\
\xea\xe7\xb2\xce)\xa1\t\x000\xb0(\x0b" )

addArtData('wxART_FILL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe47z\xba8\x86X\xf4\
\xae\r\n\xe4:\xaa\xc0\xe3\x9d\xf2=\xceo\xdf\x1e\xfe\xd5\x1d6\xa7\x8f\x8869\
\xcd\x9eqm\x92Ew\xd1\x89\xf5L\xdbS\x98\xbd\xefL\x9a\xceu\xb1)wv\xe1L\x7f\x86\
\xb4+\xe7^0i\x7f\x9a\xe1\xcf\xea6i\xd5SU\x15\xcb\xd2\t\x13\xa5g9\xfco=^\xa6\
\xf8\xf3\xca\xbcxw\xf1\x8c'Nyk\x8fml\xe6fPQ\x94\xfb\xb6\x8c\xf1\x8fn\xb9l\
\x88_\xcf\xcf\xfa\xcd\xa7\x8a=\xbc<\x93\xeb6?\x9e\xceW\xf6\x88=J\xbe0=e\xd9\
\xa4z\xa0c\x18<]\xfd\\\xd69%4\x01\x00\xb3\x8fJl" )

addArtData('wxART_FILTER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xee\t\xf0\tq\xfd\xff\xff\
\xbf^\xd2q>y\x07\xbd\xb8\x03:Q;\x04\xe4\x1dy\xa5L\xb5\xa3vh\x86\xadW\rX\xc2\
\xa7\xe0\xc8+i\xca-\xaa\xa3\x1d\xbaV#`\x89\x8a\xcf,e\xf7~y\xfb\x16!\x15\x1f~\
9G>)3\x0eQm\x0eAe%\xef\x99J@q\xc7fi\xebJ^i3n1mN\x01e6>)e\x9f\x99\x8an\xfd\n\
\x8e\xcd\x92f\xb9\\bz\x1cB@A\x19V.\x11E\xd7~Y\xebri\x93\x1cQ\xfdDNQmv^iV.!fV\
\xae\xbciO\xb3\xa7>v\x8a\x9f\xbc\xf5\xe4\xd3\xda%\xf7\xb7\x9fz\xb6\xe5\xf8\
\x93\t\x9b_\xd4.\xbeW\xb1\xe0\xde\x86c\xcf\xd6\x1ez\x0c\x14\xaf\x98\x7fw\xc5\
\x81\xa7K\xf7<\t\xaf\xdc\xb9\xfc\xc8\x87\x9aEw\xe7\xefx4s\xeb#\xff\x82\xd5uK\
\x1eT\xcc\xbf\xe7\x9b\xb3\xc4=}\x9ek\xf24\x87\x98>#\xef\xb2\xfc\x19\xcf\xf2\
\xa6=\xce\x9dr?{\xd2\xad\x8c\xfe\xab\xa9\xdd\x17\x12\xdbN\xc56\x1d\x89\xae\
\xdb\x1b^\xb15\xa4x\x9d_\xceR\x8f\xf4y\'\xef\xfc8s\xff\xf7\xa9{\xbf\x8f\xdd\
\xfe}\xe8\xe6\xaf\xbdW~\xee\xb8\xfcc\xd3\xd9o\xabO|^x\xe0\xdd\xb4\x1d/\'n~\
\x9e=\xe9\xee\xf1\xdb?\x8e\xdd\xfau\xf8\xc6\xaf\x03\xd7\x7f\xef\xba\xfck\xf3\
\xb9\x1f\xebN}[z\xf8\xf3\xdc\xbd\xef\xfa7>w\x8e\x9f\x92\xd2}i\xff\x95\xaf\
\xfb\xae\xff\xdcu\xf9\xc7\xd6\xf3?\xd6\x9e\xfc\xba\xec\xc8\xe7y{\xdf;&L\x89o\
>\xbe\xf5\xfc\xd7-\xe7\xbe\xaf=\xf5m\xce\x9e\xf7\x137=w\x8a\x9f\xb2\xe2\xe8\
\xd7\xb9\xfb>L\xd9\xfa\xca)a\xca\x82\x83\x9f\xa7\xefz\xef\x9a8u\xfa\xae\x0f}\
\x9b_;\xc6\xf4O\xd8\xf2\xa6u\xcd\x0b\x9b\x88\x8e\xf6\xb5/j\x97>6\x0b\xa8\xb5\
\x8d\xec\xb4\x08n\x04F\x9c\xe1\xe2\x1d\xc0\xb8e\xf0)\t\xf2\x03\xa5\x05R\xc0\
\xdf\x7f\xff\x94\rYU\xfe\x191\xb1\xaa\x80\xf0\xbf\x7fF\xac\xca\x7f\xf5\x99\
\xfe\xfe\xfd\xfb\xe7\xdf\xe3I"g\x80j\x18\x93\xbc\xdd]\x18:Xe=\x80\x1c\xce\
\x02\x8f\xc8b\x06\x06n!\x10f\xbct\xb7\xee\x0fP\x90\xbd\xc4\xd3\xd7\x95\xfd!\
\x07\x1f\x97\x92\xf4C\xe5\x90|\xa0\xd0^O\x17\xc7\x10\x89\xcb\xc9\t\n<_jk\xfe\
\xfeafjnrv:|H\xb9\x81\x89mb\xe0E\xc3\x8d\x85\x1f9;=Oj\xb690.\xbe\xb2\xe5K\
\xcf\x995o\xe6\xdc\xd9\xf3\x87)yACgfb`\xa1gfdek\xe4\xd2\x9d\xac\x01\r\x17/\
\xadZ\xb5k\xd9\xb6=\xeb\xf6\x1d\xbc\xd5\xc6\xa9q\xe0LRv\xfa\xfb\x0b7\xae\xdc\
y\x94q\xf8\x14\x9bH\xc2\xf3\x07%Ee\x99\xb9\xd9\xe5\xa5\x8f\x1f=c\xe4\xfa\xf0\
\xe9#7\xc7\xae\xf2\x922N\xce\xee\x8e.FV\x8b\xa3\xaa*KmvUW\xed\\\x92\x9a\xf2\
\xb4\x81\xe9\x13WW\x90\xd7\xbc\xda\xbf\xc2K\xa6\x86\x86\\m`z\xd5%5+*NX\xbd2\
\xbb\xfb\xe5\x8bW\x82\x0fMy\x18\x18\xf8\x8b\xb4\xe5\x16\xf5-\xcd\x01zD\xb5\
\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\xe8\x1a\x19\x85\
\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\xa2!7?%3\xad\x12\
\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x1c\xa2A\xc4m*;(\x12<]\
\xfd\\\xd69%4\x01\x00\xa2\xdb\x9e~' )

addArtData('wxART_FIND', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xf5\x08\xf0\tq\xfd\xff\
\xff?CCCR\xddj\xbf\xec\xf9\xbf~\xfdQp\xa8\xb3\x8f\x9f\xba\xf1\xf0\xbd\xd0\
\xb25@\xa9\xa7/>\x1e\xbc\xf4n\xc2\x8c\x13\t\t\x13V\x1e\xbd{\xf6\xc6\x9b\xce\
\x05\xa7\x0c\x83\'\xaa8\xe7\xef8\xf1\xb8g\xf1\xd9\xf8\x86\x9dQ\xe5K,\xc3\xfb\
\xbe\xdegu\x07\x9a\xc9T\x12\xe4\x07tW\xd9\xe4\xb3\x16@\x1ec\x92\xb7\xbb\x0bC\
\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\xe6H\x00\
\x05\xd9K<}]\xd9\x1fr\xf0q)I?T\x0e\xc9\x07\n\xa5z\xba8\x86H\\\xee\xed\xb7\
\xe4k0\xe0a\xa9=\x92\xa0 \x90\xf7\xef\x7fpGg\x0c\x03k^\x9aiTfj\xc3sE%\xc1\
\xc5\x87]\x04Jj8\x1fy\xdd\x98\xe8\xba"Tf\xa9\xe2\x996\x9d\x15\x99\xd6S%zm\
\x0f9h\xf6\xce\x92>&\xd7Q9\xcb\xe5\xd9N\x96\x05\x1b\xd6D\xcf<\xfbry\x80xU\
\xe7^\xab\'b\xd3\xe2\xee\xcf\xd7\xf1eus\xe1Z\xc0\x0f\xb4P\xb5\xc45\xa2$%\xb1\
$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\x19\
\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\xd7\
\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x1c\xa2A\xc4m*;P\x03\x83\xa7\xab\x9f\
\xcb:\xa7\x84&\x00[\xf2\x9b\x91' )

addArtData('wxART_FIND_NEXT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\x8d\n\xf0\tq\xfd\xff\
\xff?CC\x83\xd2\x01\x05\xaezv\xb7\xf3\xae\x92e\xecIu\xab\xff\xfd\xfb\xc7\xae\
\x9e\x95\xde\xb0\xbar\xc2\x0e\xff\x9c\x05\xcd3\xf7&T-\xefY|6\xa1z\x85\xaa{\
\xbb]\xccT\xdb\x98)\x1cze\xdf\x7f\xfc*\xee\xda\x14]\xb68\xa6|\xb9g\xda\xec\
\xfa);Rk\x96y\xa7N\xdeq\xe21\xd0Xif\xff\xeb@[\x98J\x82\xfc\x80.-\x9b|\xd6\
\x02\xc8cL\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\
\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\xe9\x87\xca!\xf9@\xa1tO\x17\xc7\x10\
\x89\xcb\xbdgO\xf25(\xf0\xb0\x04hX\\\xa9\xbd\xff\xf7\xff{\x11Q\xcf\xbd\x96\'\
\xbf|\xb8\xb4\xc5\xeb\xa5\xc4\xa7P/&O\x03\x97\x14\xcf\xa6\xbdNL5k~\xde\xf3\
\xf0\xd9\xc1\xf8`]\xe5\xfe\x03\x1fce\x19<6\xcb\xb8\x9e\x14\x8c\t5_\xbbZ\xa5\
\xa4\xd6\xdc\x85\xe1X\xe6\xb3\xd4\xbbe|\x051\xb7-\xe6M\xad?`\xf7k\xa6\x9c\
\xdf\xdep\x96w\x1f\x95#^\x03\xadT-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\
\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\x066\xc1\xa7\x9f\xa1h\
\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb122\x87h\x10q\x9b\xca\x0e\xd4\
\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00\x8d\xd6\xa3\xf2' )

addArtData('wxART_FIND_PREV', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaaM\x08\xf0\tq\xfd\xff\xff\
?CC\x83\xd2\x01\x05\xb7\xf3\xae\\\xf5\xecr\x9b\xcd\n\xdbW%\xd5\xad\xfe\xf7\
\xef\x1f\xbbzVz\xc3\xea\xca\t;\xfcs\x164\xcf\xdc\x9bP\xb5\xdc3uZ\xcf\xe2\xb3\
\t\xd5+T\xdd\xdb\xedb\xa6\xda\xc6L\xe1\xd0+\xfb\xfe\xe3Wq\xd7\xa6\xe8\xb2\
\xc51\xe5\xcb=\xd3f\xd7O\xd9\x91Z\xb3\xcc;u\xf2\x8e\x13\x8f\x81\x86/\x8a\xb9\
\xb0\x16h\x17SI\x90\x1f\xd0\xbde\x93\xcfZ\x00y\x8cI\xde\xee.\x0c\x1d\xac\xb2\
\x1e@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\
\xc1\xc7\xa5$\xfdP9$\x1f(T\xe0\xe9\xe2\x18"q\xb9\xf7\xccm\xbe&\x07\x1e\x96\
\x0b~\xe5\xa9e\xa2\x02\xa2{\n~\xff?\xbfDc\x8d\xf4\xfc9)\xb3\xbe,Y\xc9\xc1\
\xe0\xda\xd5\xd1\xf8\xaf\xc1*\xf4k\xbc\xc5\x0eS\xc9\x03\xd6\xf9\'\xeb\x97\
\xe4\xb2W\x88\xa8d\xdceH\xe8x\xff\xceA\xce_u\xf5\xaf9\n&\xd3_\xeb\x9a\x186o\
\xcb~\xcfy\xe2\xf8\xe7\xab_\x0f[\x1c\xe5}\xf6u\xd6\xe6\xb9\x7fx/~\x9a\xb9\
\x89\xe1~\x10k\xdd\xd6\xbc\xa3.@\xbbUK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\
\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\
\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\
\x8cM\xac\x8c\xcc!\x1aD\xdc\xa6\xb2\x0350x\xba\xfa\xb9\xacsJh\x02\x00]\xa5\
\xaf#' )

addArtData('wxART_FLIP_HORIZONTAL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xd1\x00\x9f\x10WF\x06\x86\x05\x0b\x16\x00y\xff\xff\xffghh\
\x00\x12@\xc6L\xdfE\x1b\x81B\x8c%A~\xc1\x0c\x0e\xcfn\xa4\x818I\xde\xee.l\x89\
i;j\x81\x1c\xf6\x12O_W\xf6\x87\x1c|\\J\xd2\x0f\x95C\xf2\x81B\xee\x9e.\x8e!\
\x1c\xd7\x93\x13\x0e0\xf4\x18L\xf2\x14t\xd1f\x94l\xeb\xe2\xe9\xe9\xf2sp+X\
\xb0H\x89[xBbV\xd6\x93\x07\x0cb\x9c|I\x8a*J<B\x82LRj*YO\x14T\x18\x8c\xe2<8\
\x9c\x98#\x99NLcfXv\x9a\x8b\xef3sU(\xd0H\xd5\x12\xd7\x88\x92\x94\xc4\x92T\
\xab\xe4\xa2T \xc5`d`h\xaek`\xa1kh\x18bh`ehfeb\xa2m`de`\xb0%\xa6\xcb\x1bECn~\
JfZ%B\x83\tH\x83\xb1\x89\x95\x919D\x83\x88\xdbTv\xa0\x06\x06OW?\x97uN\tM\x00\
\xf0\xbba\xfe" )

addArtData('wxART_FLIP_VERTICAL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xd1\x00\x9f\x10WF\x06\x10X\xb0`\xc1\x7f\x10\x00\xaan\x00R/\
~\xad\x06\xd9\xcaX\x12\xe4\x17\xcc\xe0\xf0\xecF\x1a\x88\x93\xe4\xed\xee\xc2\
\x96\x98\xb6\xa3\x16\xc8a/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\xfdP9$\x1f(\xe4\
\xe7\xe9\xe2\x18\xc2q=9\xe1\x00\x13K\xa3\x03\x87\x87\xb1\xa6\xb5\xb557\x83d\
\x8f\x9a\x9a\x9a\x1b\x97C\x9bP\xc0\x01\xc1%.,\x1a\x8bZ\x16\xb1,\xe1\\\xd2\
\xe29u\xeaTQ\x95C\n\x02\x02\x02\x0cA\x87\x17\xb0\x88$\xb2\x18J4*9\xae\xe8J(s\
dd\x98s\x92\xd3\xce\xc7\xfd\xfaa\xa0\xc9\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\
\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0B\xd7\xd00\xc4\xd0\xc0\xca\xd0\xcc\xca\xc4D\
\xdb\xc0\xc8\xca\xc0`KL\x977\x8a\x86\xdc\xfc\x94\xcc\xb4J\x84\x06\x13\x90\
\x06c\x13+#s\x88\x06\x11\xb7\xa9\xec \xff{\xba\xfa\xb9\xacsJh\x02\x00](e~" )

addArtData('wxART_FLOPPY', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd\'\x91\x15\xc8WH\xf6\x08\xf2\
e`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xd1\x00\x9f\x10W\x90\x82\x86\x86\x03\x07\x0e\xfc\xff\xff\
\x1f\xc8\x06b C#4>\x14\xc8a,\t\xf2\x0bfpxv#\r\xc4I\xf2vwaKL\xdbQ\x0b\xe4p\
\x16xD\x1630\xf0\x1d\x06a\xc6\xe3\xf9+R\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\
\xf8\xb8\x94\xa4\x1f*\x87\xe4\x03\x85B<]\x1cC8\xae\xa7v\x1d\xe4m0\xe0a\x8e\
\xedd,x\xc9\x12fn\xc0\xfce"\xe7\x8dz\x89Y\\?\n\xe6\xcf9\xc7\xa8\xd6z\xe7\xf3\
\xa2[\x7f\xa7\xfe\x98\xea\xbeDSE\xfbf\xa0\xca\xd5\xb2\x12\x99m\xe7;&\xee.1l\
\x9d\x12$a\xb8\x7f\xf3\x8d\xd5\x05\x17\x1bt\'5\xf6K\xeb\xf2\xf2\xec\xadL\xe1\
\x7f\x034_\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\
\xe8\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\
\xa2!7?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x1c\xa2A\
\xc4m*;P\x03\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00\xb3^x\x97' )

addArtData('wxART_FOLDER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5Z\x06\xf8\x84\xb8\
\xfe\xff\xff\x9f\xa1\xa1\xe1\xccL\xe3\x7f\xff\xfe\x9d\x99a\xfc\xef\xfb\xe1\
\xdfoW\xfd~\xbbfG\x9b\xf1\x8f\x87\x13\xbe\\)\xfdt\xa9xU\x85\xf1\xbbC\xfe\xaf\
6i/)2~\xb9^uF\x9a1P\xd7\xa4\x8e\xd5@\x83\x19\x98J\x82\xfc\x80\x0e)\x9b|\xd6\
\x02\xc8cL\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\
\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\xe9\x87\xca!\xf9@!oO\x17\xc7\x10\x89\
\xcb\xad\xe7O\xf35\x18p\xb8\\l\x12\x15\x9d\xff\xf7\xff|Q\xf6\xc9\x85\x89\x97\
&\'\x16\x97O\xb9\xa4\xba\xc8\xb1\xc5\xb1=@r\xcb$\xa5\x9e)\x07s6]\xef\xd9\x10\
\xc0\x16\x7fw~w.\x87u\xaa\xc5\x0b\x97\x1d+\x14\xb7\xf4\xffK\xae\xcf\xe3\xec`\
\x99\xc7\xe1}\xec!\xd0X\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d\
`h\xaek`\xa2kd\x14bhnehbel\xa9m`de``\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\
\xb4J\xa8\x06\x0b]C\x93\x10C\x03+c\x13+#s\x88\x06\x11\xb7\xa9\xec@\r\x0c\x9e\
\xae~.\xeb\x9c\x12\x9a\x00h\xe0\x8d\xf7' )

addArtData('wxART_FOLDER_BLUE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xb6\x05\xf8\x84\xb8\xfe\
\xff\xff\xdf4\xfb\x96q\xd6M\x9d\xf8\xfd\xda\xd1\xdb5B\xd7\xa9\x05.Q\xf6\x99\
\xa5\xe8\xd6\xa7\xe8\xd0b\x9a}[+d\xad\xba\xff\x12%o\xa0H\xbf\x9cC\x93\xacU\
\xb9I\xd6-\xc3\x8c\xab\x06\xa9\xe7\r\x92N\x18g\xdf:z\xeb\xcf\xb1\xdb\x7f\x0e\
\xdf\xfc\xbd\xef\xda\x1f\xed\xa8\xed\xc69\xb7\x8c3\xaf\x19\xa6]\xd0O:\xa9\
\x13{\x00b\xa6z\xe0b\x90\x99\xae\xfd2\x8e\xcdR\xd6\xe5R\xa6\xb9&\x19\xd7\x8e\
\x02u\xdd\xfa\xb3\xef\xda\xef]W~m\xbd\xf8k\xfd\xd9\x9f\xabN\xfe\\|\xe4\xc7\
\xdc\x83?\xa6\xed\xfe\xde\xbf\xe3\x9b\xb8A\x92A\xda\xb9C7\x7f\xef\xbe\x0cT\
\xf0{\xfd\xd9_K\x8e\xfe\x98\x03\x94\xdd\xfb}\xe2\x8eo]\x9b\xbf\x8aj\x87\x1a$\
\x1d\xdfu\xe5\xf7\x96\x8b\x7f6\x9e\xf9\xb5\xe2\xe4\xcf\x85G\xbe\xcf=\xf0c\
\xda\x9e\xef\x13\xb6\x7f\xed\xdc\xf2\xadi\xdd\x17\x01U\x1f\xdd\xb8\x03\xeb\
\xcf\xfcZu\xe2\xe7\xdc\x03\xdf\'\xec\xf8\xd6\xb9\xf9k\xd3\xfa\xaf5\xab\xbe\
\xf0+8\xeaDn\xdfz\xe1\xd7\xca\x13?\x17\x1f\xfd1\xfb\xc0\xf7\xe9{\xbe\xf5m\
\xff\xd6\x01R\xf0\xb9z\xf5\xe7\xb2e\x9f\xf9\xa4\xcc4C\xd6n8\xfbs\xda\x9eo\
\x13w~o\\\xf7\xa5f\xf5\x97\xb2\xa5\x9f\x0b\x16\x7f\xe6\x12\xd3\xd6\x08X\xb2\
\xf2\xe4\xafE@W\xed\xff6u\xf7\xd7\t;\xbf7\xad\xffR\xba\xfcs\xe1\xa2O\x99\xf3\
>r\x08*+{\xcdTpl\x96\xb3\xae\x906\xc9\x15\xd5K\x14\xd1\x0e\x13R\xf3\xe5Sp\
\xe4\x954\xe5\x10\xd5\xe6\x14R\xe6\xe0\x93\x01F\x01\xe3\x06\x8b\xcb\xc0\xd8\
\x13,\t\xf2\x03\xc5**8,{\xf6\x1d\x90bL\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\
\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\xe9\x87\
\xca!\xf9@\xa1\x8d\x9e.\x8e!\x12\x97\x93\x13\x148$f\xb2\xb4\xb6\xb8\xce\x88\
\x8c\xb8y\xc3\xd2\xc2\x91)fQ\xd2#\xa1IAwl\xf6\xd4\xfcaR`\xcc\x94\x8c\xb4\xac\
duUM\x15\r5-\x9d\xd0\xd0\xb6l\xda\xb6\xbeu\xf3\xf65.\x9c\xb8\x91\xd3\xe3\xc0\
\x15\x9fKw\x0e\x05\xdd?u\xeb\xd8\xb5sr*\x0f\x16\xbc}\xf1\xe4\xcd\xa3W\xcf\
\xde=|\xf9\x94W\xe8C\xe1\x95\xaf_7\x7f*\xe7\xe7\xe0\xe1\xe2c\xe4li{\xd9\xea\
\xee\xe2\xe6z\xfc\xc8\xb1\xa3\xea\r,B\x93\xbf\xac\xfd39\x98)\xf8\xf2%c#G\xa6\
\xc8\x9b\x96;+\x7f\x96\xb1\x16\xb6\xba\x1eUUh\x0c\x9a\xba\xe9S\xd7\xa9U\xaff\
\xdd\xda\xf5\x8b\xed\x90\xdca6\x86\x98\r\xca\xb3\xbc\x19O\x02\x13.\x83j\x89k\
DIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\
\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x919D\x83\x88\xdb\
TvP\xd8z\xba\xfa\xb9\xacsJh\x02\x00\xca\xe5z\x10' )

addArtData('wxART_FOLDER_OPEN', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xda\x07\xf8\x84\xb8\
\xfe\xff\xff\x9f\xa1\xa1\xe1\xccL\xe3\x7f\xff\xfe\x9d\x99a\xfc\xe7\xfd\xb1\
\x95\xe5\xc6\xbf\xdf\xae\xf9\xf1p\xc2\x97+\xa5\xff\xbe\x1f~w\xc8\xff\xf7\xdb\
U;\xda\x8c_\xaeW\xfdt\xa9xU\x85\xf1\xabM\xdaK\x8a\x8cg\xa4\x19\x03\xf5Nt\xd8\
b\x074\x8a\xa9$\xc8\x0f\xe8\x9c\xb2\xc9g-\x80<\xc6$ow\x17\x86\x0eVY\x0f \x87\
\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\
\xb2?\xe4\xe0\xe3R\x92~\xa8\x1c\x92\x0f\x14J\xf1tq\x0c\x91\xb8\xdcz\xfe$_\
\x83\x02\x8fk`\xdcZ\xaf\xa9\x9e?\xff\xd7o}\x10P6o\xc9\xec\xd9\x0e\x07w\xc63h\
\x1e`\xf2\xed\xd2\xbdp\xa7p\xf3\x97\r\xb3X\xab\xa6\xecy\xceh)\xf4\xf0l\xc6\r\
\xcb\x96\rm\xee%Sn\xcc^Q\xbe\xa1\xe3I\xf5\xa6)be\xc1\xb7\xc4\xfc^V\xcc\x95rx\
\x19|\xdb\xba\xe1\x17c\x9b\xfd^=\x8f~6\x86L\x07\xe1:\xa0}\xaa%\xae\x11%)\x89\
%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\
\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\
\x16\xba\x86&!\x86\x06V\xc6&VF\xe6\x10\r"nS\xd9\x81\x1a\x18<]\xfd\\\xd69%4\
\x01\x00\xc9\x01\x9e\xb7' )

addArtData('wxART_FOLDER_OPEN_BLUE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xfe\x0e\xf0\tq\xfd\xff\
\xff\xbfi\xf6-\xe3\xac\x9b:\xf1\xfb\xb5\xa3\xb7k\x84\xaeS\x0b\\\xa2\xec3K\
\xd1\xadO\xd1\xa1\xc54\xfb\xb6V\xc8Zu\xff%J\xde@\x91~9\x87&Y\xabrV>)VnaV.\
\x11fv\x1efV.F&6fV\x1eF&\x90\xf5r\xd6\x15\x0cL\xac&Y\xb7\x0c3\xae\x1a\xa4\
\x9e7H:a\x9c}\xeb\xe8\xad?\xc7n\xff9|\xf3\xf7\xbek\x7f\xb4\xa3\xb6\x1b\xe7\
\xdc2\xce\xbcf\x98vA?\xe9\xa4N\xec\x01\x88\xa5\xea\x81\x8bA\x96\xba\xf6\xcb8\
6KY\x97K\x99\xe6\x9ad\\;\n\xd4u\xeb\xcf\xbek\xbfw]\xf9\xb5\xf5\xe2\xaf\xf5g\
\x7f\xae:\xf9s\xf1\x91\x1fs\x0f\xfe\x98\xb6\xfb{\xff\x8eo\xe2\x06I\x06i\xe7\
\x0e\xdd\xfc\xad\x15\xb9]3t\x9dj\x00\xd0\x9d3\x95\xdd\xfb\x15\x1cZd\xad+D\
\xb5C\x05T}\xf8\xe4\x1dx\xa5\xcc\x0c\x92\x8e\xef\xba\xf2[#t\xed\xc63\xbfV\
\x9c\xfc\xb9\xf0\xc8\xf7\xb9\x07~L\xdb\xf3}\xc2\xf6\xaf\x9d[\xbe5\xad\xfbR\
\xb3\xeaK\xd9\xf2\xcf\x05\x8b>q\x8bh\xeb\xc6\x1dX\x7f\xe6\xd7\xaa\x13?\x97\
\x1c\xfd1\xf7\xc0\xf7\t;\xbeun\xfe\xda\xb4\xfek\xd9\xb2\xcf\x85\x8b?e\xcf\
\xff\xc4!\xa8\xac\x13\xb9}\xeb\x85_\x1a\x81KV\x9e\xf8\xb9\xf8\xe8\x8f\xd9\
\x07\xbeO\xdf\xf3\xado\xfb\xb7\x0e\x90\xca\xcf\xd5\xab?\x17,\xfe\x9c=\xff\
\xa3f\xc8\xdai{\xbeM\xdc\xf9\xbd\x11h\xc5\xea/eK?g-\xf8\x946\xfb#0\x0c5\x02\
\x80\xe1<s\xd1\xd1\x1fs\xf6\x7f\x9b\xba\xfb\xeb\x84\x9d\xdf\xbb@z\xbf\x94.\
\xff\\\xb8\xe8S\xe6\xbc\x8f\xa9s>\xb2\xf1\xc9({\xcd\x9cw\xf0\xc7\xf4=\xdf\
\xfbw~o\x06\xbaa\xf9\x97\x02\x90\x1b>\xa7\xcc\xfe\x988\xe3#\x0b\x97\x90\x9cC\
\xf3\x84\xed\xdf:7}-_\xf6%o\xd1\xa7\xac\xf9\x9fRg\x7fL\x00Jq\x08J\x99\xe6\
\x88j\x87\t\xa9y\xf3\xcb9rI\x9bq\x89\xe9r\x08)\xb3\xf1H\xb1r\t\x03\xe3\xbd\
\xf7\xac\xae\x070\xcedJ\x82\xfc@I\t\'\xb0R\x8e\\\x07\xa4\x18\x93\xbc\xdd]\
\x18:XeA\x9a8\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\
\xaf+\xfbC\x0e>.%\xe9\x87\xca!\xf9@\xa1\'\x9e.\x8e!\x12\x97\x93\x13\x148$f\
\xa6\xa4<}232\xe2\xe6\rK\x0bG\xa6\x18\xae.\xafSZ\xab\xee\xd8\xec\xa9\xf9\xc3\
\xa4\xc0hZ\xca\xeb\xab\x9b+\x1bk[\xcb\xec\xac<\xa1ac\xe7\xca\x99;[\x97N\xdd\
\xda\xbbv\xae\xad\xc7\x81\x83\x81GO\xde<z\xf5\xec\xdd\xc3\'\xee]>}\xbb\xfd\
\xe0\xf53\xe7\xed\x15\x0c4,TLtl\x94\x8c\xb4f)\x1e\xf3W7\xd3\xb3ST1\xd4\xb4TR\
5\xd5\x9d\xab\xa8l\xacm\xadn\xae\xbf\x7f\xc1\x06\x8d\xa5;Tb\',\xbcrT\xcbn\
\xe1\x1a\x9b\x95\x8b6\xad\xda\xb1kYX\xc7\xc2u\xfb\x16n\\\xb9s\xe9\xd6\x15k\
\xf7.\xde\xec\x1d\xd1\xb20z\xff\xf2\xed\xeb\x97\xee/:t\xc4s\xf2r\x1fQ\xd1\
\xe4\x84\x19\xd3\xcck\xdd\x8a.\x9e\x89\xdc\xfc\xfc\xcc\\u=\xc5\x93\x07\x14L\
\xef\xd7\x1d<\xe4\xda=]\'v[LLT\x90\xd0\xe1\xcd\x0c}_\xedY:\xae\x94\xec\x03\
\xfaW\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\xe8\
\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\xa2!7\
?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x1c\xa2A\xc4m*\
;(:<]\xfd\\\xd69%4\x01\x00\x0e\x90\xb4b' )

addArtData('wxART_FONTTOOLS', 'wxART_OTHER_C', 16,
b'x\xda\x01_\x02\xa0\xfd\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\x00\
\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x02\x11IDAT8\xcbu\x931L\
\x13q\x14\xc6\x7fw\xbdjk\x8b\x08\x88\xd6(E\xd0\xd2\x01\tj\x93F\x12\xa2),D<\r\
\x83\xa3\xba\x14\x8dq\xd0\xa1\x0b\x83\xc9\x7f0aq\xd0\xc1\x18\xc5At\xd4\x84\
\xc4F\x17\xb1lhkN\xbb`\x13\x13\xaf\x94\x18C\xd2+R\x13"\xb6\\\xcf\xa5\x90K9\
\xbe\xf1}\xdf\xfb\xf2\xfe\xdf\xfb?\x89\x06D\x92\xa2\x17\x88\x031\xa0\x13\xb0\
\x80E\xe0\x030\xa5\xa9\xe2\xbb]/\xd9\x1a=\xc0}\xe0& \xe3\x8c\r\xe0!0\xa1\xa9\
\xa2\xbaePo~W\xce-\xc7\x8a\x1fu,\xcb\xda\xd6)\x01\xfe\xae\xfd\x04\x86\xc2\
\x00o\x811M\x15U\xa5\xce?\x00b\x85W\x1a\xd7FF\xe9\x08\x04X6\x0c\xfeU*l\x98&\
\x00\xb2,\xe3V\x14\xfa\x0eE\xc9U\x8b\xa3\x19C\x9f\x04\x12r$)N\x02\xd7\x01\
\xcc\x8aI\x7f8Liu\x95\xf9\xafYV\xcae\xa6\'\xefq\xe5\xa2J\xee\x87\xce\xb7\x9f\
\x8bD\x8f\x84\xf8S\xfd\x0bp;\x92\x14=\np\xc3\x9eE*\x9dff6E(>\xc8J\xb3\x1f\
\x80\xb5\x16\x89\xdf\x03\xfb\xf0\x06\xf62\x9d\x9fgi\xad\x04\xa0\x00\xe3\n0l\
\x7f\xeb\xccl\n\x00_g+^_3\xeb\x95\n\x96\xc7E\xd3\xb1v\x002\x86n\x97\x0f+@\
\x97S\xdc\xd9\xbbo\x00\xd8\xc3K\x90$\x0e\x9e\x0bq\xf8\xfc\x89F\xd9\xd1\x9d\
\xd6\xb5\x05\x0b\xb0,\x0b\xe3s\xc1\x89\x96\x14`\t\xe8nd\\\xbb\x15dI\xc6\xab\
\xb81%h9\xdb\xeddPP\x80\x94\x93A\xbf\xb8@_[\x07\xcf\x07\xe3\xbc\xff\xb5\xc0\
\xc4\x97\xd7N\x06s20U\x9ft\x1b\xda=M\x00\xb4y\xfcNt\rx&k\xaa\xc8\x00/6\xc7\
\x06\x90w\xb98s\xe08\x97\x82\xa7H\x17u\xccZ\x8dD\xef\x08~\xb7\xc7n\xf0XS\xc5\
\xc2\xe6O\xbc\x05\xf4t^>=`|\xca\xd3\x1a\t\x92.\xe9\xa4K\xfaN\xd9\xce\x01\x89\
\xc6c\xf2\x01\x8f\x80\xab\xf6\xba\xc3R\x9e\x02w4U\xac\xe3$\x8c$E\x14\x18\x07\
\x86\x80`\xbd\x9c\xaf\x9f\xf3\x13M\x15Y\xbb\xfe?\x8d"\xa6\r\xcbq}\x87\x00\
\x00\x00\x00IEND\xaeB`\x82d\xba\x00\xfe' )

addArtData('wxART_FULLSCREEN', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xce\x0f\xf0\tq\xfd\
\xff\xff\xff\xe4E\xdb\xff\xfd\xff\xfb\xf7\xdf\xdf\xdf\x7f\xff\xfe\xfc\xf3\
\xf7\xfb\xef\xbf_\x7f\xfe\xfd\xfc\xfd\xef\x87o\xff\xde}\xf9\xf7\xfa\xd3\xbf\
\x17\x1f\xfe={\xff\xef\xf1\xdb\x7f\x86\xee\x99E}\xc7\x1e\xbc\xfe\xb7\xe9\xf4\
\xef\xd5\xc7~,=\xf0u\xde\xaeO3\xb6\xbc\x9f\xb8\xeeM\xd7\x8a\x97-\x8b\x9e\xd5\
\xceylY\xf4\xe8\xee\xcb\x7f\x0f\xdf\xfc/\x9d\xfa\xe0\xf6\xf3\x7f9\xbdwn<\xfb\
\x9f\xd2v\xe3\xda\x93\xff\xd1uW\xae<\xfa\x1f\\~\xe1\xd2\xc3\xff\xedK_4.xZ9\
\xe3a\xc1\xc4{\x19\x9d\xb7\x12\x9a\xae\x85W_\xf2/>\xe7]p\xf6\xc2\x83\xff\xe7\
\xee\xff?{\x0f\xe8\xb4\xff\xce\x0eY\x9d@\xa72\x96\x04\xf9\x0538<\xbb\x91\x06\
\xe2$y\xbb\xbb0t\xb0\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80\
k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92\xf4C\xe5\x90|\xa0\
\xd0TO\x17\xc7\x10\x89\xcb\xbd\xfd7\xf9\x9a\x0c\x04\\\xbbsX\xaf\xf0)\x89\xc8\
j\x89\xb8\xc4\x140\xfe\xff\x7f_\xa6\xc7\xadS\x7f\xde\xf6\xeaw\xbej\x87o\xf0\
\x1f\xe38%|y\x93\xec\xf4\xe2\xf3\xfc\xcb6\xefLh\xe3\x8coQ\xd1\x89p9m\xe1\x99\
\xb2+*\xd9\xedP\x9b\x87\xa6j\xfb\x9e\x83sZ\x98\xaf\x9c.9\xc1\x9a%\xa4w\xe4\
\x95k\xe7\xd5xn\xbe\xf3\xccW\xa6G\xaf\xf1\xacP\xb8\xdf-k\xa6RsC\xbeo\xf96\
\xdb\xf8u\xe6o<X\x1a\xe4\xab\x84\xbe8\xccx\x1a\x15^z\xf9k\xf9\xc1\x19\x12\
\x07\xe5\xf8t\x85\x95\n\xf3\xcd*\x80\x0eT-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\
\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\x066\xc1\xa7\
\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb122\x87h\x10q\x9b\xca\
\x0e\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00P\x04\x013' )

addArtData('wxART_G', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R\x9c\x05\x1e\x91\xc5\x0c\x0c|G@\x98q\xaa6\x9f4\x03\x03\
\xa3\xa3\xa7\x8bc\x88E\xef\xd2\xc9\x86\xde\x87\x03DZ\xf7{92o\x9d\xca\xb7v\
\xa1\xb3L\xce].\xc1W\xd3N\x9e\x8d\xfc\xcd\xfc\x87{\xee/\xe6+wc\xef,\x9d\x1d\
\xc4\x95WVlpA\xef\x12\xcf\xa4\x85K\xf29\xdbX\x84\x0c\x178g~\xb8\xb9%\xa4z\
\xf9\xf1\xbdw\x8a\xcf\xdb~\xdfs\xe6\xec\xed\xb7\xe2\xd9G\x8eY\x9de\xb8\xb9%E\
\xe4H\xcf<\x96m/\x1f\xf9:\xb5<\r\x0e\x10-+\x13\x95\xf2\xe5\xf5\xd5\xd7c\x13\
\x98v\xfe\xefS\x81\xf3\x9cK\xf7<o\xa9\xf0\xf38\xab\xd1\xb8\xaf\xc1Q\xe4H\xc9\
-}\x17\xc73az\xde\x8bw\x1eo\x0c\\\xb4@\xab\xc2\xaf#w\xd7\xa5/\x96\r\x8e\xe5>\
"G\x18\xe6\xc4\xc9\x06\xad\xcbS\xdf\xda\xb4* \\\xbb\xf8\xb5\x97R\xdf/\xa6\
\x86Y\x81\x93fMo=\xe2\x10a\xc7\xf04\xcb\xee\xe4\xcde\xde\xcbs\xbd|\xd7\xde+\
\xb4j\xfe\xdf\xc2b\xb0\xd86\x9a\xd5\xe1r\xf7\x96\xaa\xe3\x12\xcf\x7f\xaff\
\xf0Y\xc9}\xfa\xb8\xd9\xdd\xfd\xc6\x16V\x97\'}?|t\xc2sk\xeb\x8f\x87\xdd?\xcc\
\xe4\x9a\xf0\xf3\xaf8\xdb]\xc3\xfe\xeb\xeb\xbd\x97\xff\x13)<\xd7\xf9u2\xd7\
\xd3\xacy\x81\xf1\n:\xf3\xbf\x9f\xbc\xd28+.\xc5x\xfaT\xbd)\\\x0c\xc1\x86\xe1\
_\x0f\xdeJ\xff\xc3\xb6zO\xde$\xb6\xc5\x1c6\xc0\x10f\xf0t\xf5sY\xe7\x94\xd0d\
\xaek`\xa1kh\x1ebhbejnej\xa1m`de`\xc0d\xe1|\x19Y\x15\x00\xaf\xdd\xb5~' )

addArtData('wxART_GET_INTERSECTION', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xdfa\x10f<\x9e\xbf"\x05(\xc8^\xe2\xe9\xeb\xca\
\xfe\x90C\x90\xc7J\xc9\xe0T\xbd+P(\xce\xd3\xc51D\xe3\xfc\xda\xc0\x8d\xbc\x07\
\x0cx\x0eM}\xff\x9a\xfbm\xe6Kn\xcb3\xfa\x174\x17N[T\xc5\x19\xa7\xd3\xc2s\xc2\
\xed\xcf\xe1\xadv\xc1\xd57\x83\x18\xe604\xcc\xd3\x93iu\xd6-\xa8\xbc\x9f\xb4R\
G\xef\xfd\xc1\xe8S\x9bT\x9b\xbbz\x7f\xad\xd4xn\xc2\xd6|\xd0\xad\xee\x86\xaf$\
\xdb/\xa7\x84\xab\xe6\xde\xdd\xe2<\xcb\x15\x9e\xce\x9e\xc3j\x06\xb4I\xb5\xc4\
5\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1aX\xe8\x1a\x9a\x87\x18\
\x9aZ\x19\x1aX\x99\x98j\x1b\x18Y\x19\x18\x04vk\xfb\xa3h\xc8\xcdO\xc9L\xabD\
\xd1`dejael\x02\xd1\x10$\xb9\xa4\x00\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\
\x97\xa5n\xa2' )

addArtData('wxART_GO_BACK', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xde\x08\xf0\tq\xfd\
\xff\xff\xbfQ\xc6U\xc3\xd4\xf3\xfaI't\xe3\x0fhGm\xd7\x0c[g\x90z^7~\xbfF\xe8:\
\xbd\xa4\xe3\xbaq\xfb5C\xd7\xe9\xc6\x1d\xd0\x8a\xda\xae\x1d\xb5C\xc5{\x96\
\x92[\x9f\x9cC\x8b\xbcc\x8b\x8cu\xa5\xa4i\xae\xa4Y\xae\xb8A\xa2\x88V\xb8\x94\
i\xae\x98>\x90\x11&\xa4\xea\xc3\xaf\xe0(\xa2\rdx\xf3\xcb;\xf0H\x9bq\x89\xe9\
\xa8\x05,\x01\xea]u\xf2\xa7\xa2[\xbfz\xe0\xe2\x95'~.>\xfaS\xce\xb1e\xc9\x91\
\x1fs\x0f\xfe\x90\xb1\xaeP\x0fX\xb2\xf8\xc8\x8fi{\xbe\x03\xcdQ\x0b\\\xb2\xf2\
\xe4\xcf\xb9\x07\xbeO\xd8\xf1M\xdc \xa9\x7f\xc7\xb7\xce\xcd_\x81&\xf7o\xff\
\xd6\xb4\xfe\x0b\xd0|1\x83\xa4\xa6u_jV\x7f\x01Z$\xa8\xea]\xba\xfc3\xd0\x16\
\x1e)3.Q\x1d\x0eA%\xa0\xa7Z\xe7NY\x0b\xf4\xa3rI\x90\x1f(\x9c\x08\x81\x1d}\
\xc9\xc9@\x8a1\xc9\xdb\xdd\x85\xa1\x83U\xd6\x03\xc8\xe1,\xf0\x88,f`\xe0\x16\
\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94\xa4\x1f*\x87\xe4\
\x03\x85\xea<]\x1cC$.\xf7\x9e8\xc9\xd4\xe8\xc0\xc0\xf6@\xb1YQK\xc9\xda\xd47\
\xe3\xe2\x82I\xb5\xdf\xff\xf5?\xf9\x11/Ss\xbc\x7fB<\x97\xebR\x97\xd32\x81\
\x81\xab\xa6\x14\x8a\x07\xae\x0e\x9e\xca\xcd\x7f1c\xd3\xcf\xa4\x97\xca&\xc7\
\\\x05\xdc8JU\x1f\x05\xac\x13\x9c\x9d;\xe7\x84\x89\xf3\x8b8\xa5\xf2\x9fr\x89\
[\x169\xd7\xd9(\xdeJ{^\xb3\xf3\x9e@\xda\xf5Ww\xe5\xfd]\xea\rdz\xe3\xf3[Lg\
\x9e\xcby\xee\xfc\xef3\xab\xc8u\x1e\xcb?\x15\xd3\xc4\x81.Q-q\x8d(II,I\xb5J.J\
\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\
\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb122\x87h\
\x10q\x9b\xca\x0e\n(OW?\x97uN\tM\x00\xb7\x1e\xd8\x88" )

addArtData('wxART_GO_DOWN', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\x1a\x07\xf8\x84\xb8\
\xfe\xff\xff\xdf8\xfb\x96\xa6\xd7\x84\xa3\xb7\xff\xec\xbd\xf6{\xdd\xe9\x9f\
\xf3\x0f\xfe\xd8|\xfe\xd7\xd2\xa3?&\xef\xfa\xd6\xb0\xf6K\xda\x9cOQS>\x00\x95\
\xb7o\xfcZ\xb4\xf83P\xfd\x0c\x99O\xd6@>cI\x90_0\x83\xc3\xb3\x1bi N\x92\xb7\
\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\
\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0q)\xc9\xd4\xbb\x1f<\x03\x14\xf2\xf0tq\x0c\
\x91\xb8\x9c\x9c\xb0@,!%%)\xc9I0!-1\xd5\xe9\x04\x13#\xb7\xb6\xb4\xb0\xb0\x8f\
\xa8\xb0\xb11\xb75\xbb\xba\xb89\xbf~\x08\xaf\xb0\x94\xbc\xc6\xa1\x83'\x8f\
\xf7\x1fa\xef\xfa\xf0\xb1\xf8\xf3\xa2\x1b\xa7\xbb\x8f\xb1w\x05<\xe0f\xd8\xf9\
\x99\xb1\xed\x83\xe9\x86\xe5@3UK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\
\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\
\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\
\x8c, \x1a\x1e\xf1=}\x07\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00& \x84\
\x86" )

addArtData('wxART_GO_FIRST', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xc6\x07\xf8\x84\xb8\xfe\
\xff\xff_?\xe9\x84n\xfc\x01\xed\xa8\xed\x9aa\xeb\xd4\x02\x96\xa8x\xcfTt\xeb\
\xd3\x8d\xdf\xaf\x11\xbaN\xc5{\x96f\xe8:E\xb7~\xf5\xc0\xc5*>\xb3\x94\xdc\xfa\
\xe5\x1dZd\xad+e\xac+$Ms\xc5\r\x92\xc4\x0c\x92D\xb4\xc2\x85T}\xc4\r\x12\x05U\
\xbd\xf9\xe5\x1dx\xa4\xcdD\xb4\xc2\xf8\x15\x1cy\xa4\xcc\xb8Du8\x05\x95\x85T\
\xbd\xb9\xc4t8\x04\x95\xd8x\xa4X8\x85\x8c\xb3o\x19e\\5L=/\xef\xd8r\xf4\xf6\
\x1f\xa0\xed\xf2\x0e\xcd2\xd6\x95\x87n\xfe\xd6\x8d\xdb/\xe7\xd8<m\xcfwI\xb3\
\\\xa3\xcc\xab\x87n\xfe\xd9w\xed\xb7V\xd4v9\xc7\x96i{\xbe\xf5o\xff\x06\xb4\
\xd1 \xf5\xfc\xae+\xbf\x80n\x9b\xb0\xe3[\xc7\x96\xaf\xa2Za\xfaI\xc7\xf7]\xfb\
\xb3\xeb\xf2\xaf\xad\x17~\xab\x07,\xe9\xdc\xfc\xb5i\xfdW\xa0\x93t\xe3\x0e\
\xec\xba\xf2{\xcb\x85\xdf\x1b\xce\xfc\x02z\xaas\xf3\xb7\xa6u_jV}\xe1\x97w\
\xd4\x8e\xda\xb1\xf5\xc2\xaf\xf5g\x7f\xad:\xf1\x13\xe8\xbb\xb2e\x9fy\xa5\xcd\
4C\xd7\xae?\xfbs\xe5\xc9\x9f\x8b\x8f\xfe\x90sh\x01\xfa\xa2f\xf5\x97\x82\xc5\
\x9f\x81\x8e\x07\x06\xcb\x92\xa3?\xe6\x1e\xf8\x0e\xf4W\xd6\xfcO\x1c\x82\xca\
\\b\xba\xa9s>\xb1\xf1J\xcf=\xf0\xa3\x7f\xc771\xfdDVN!`\xb0H\x99\x01\x83%QD;\
\x8c\x99\x95\x07\x18\xb6\x8b\x14E\xd7\x01\xa3E\xad$\xc8\x0f\x14]D\x80\x8f\
\x0cV\x13\x80\x14c\x92\xb7\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\
\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0q)\xc9\xd4\
\xbb\x1f<\x03\x14:\xe9\xe9\xe2\x18"q99\xe1\x00CVV\xd6+\xa9\x1e\x9f3:kr\xde\
\xccJ`\xd4\xd5\xd5\xcd\xe5K\xf3\x0b\xd3+\x93\x8d]\xd10\xcf\xce\xd8\\[\xbc\
\xbfq\xa1\xa0\xc7\x81\x88\xd3G\xae\xf4L\x9e\xde\x7f\xfc\xce\xa1K\\*\tk\xd3\
\xb3\x92O\x9f:\x9a\x9f\x97\x91\xfe\x9eA\xa8\xa0\xa4\xa8\xac05\xf9\xba\xe1\
\x96\xe2\xe2\xef\x0c\x9c\x15U\x95\xbf\x7f0}\xbd\xfd\xf3\';K\x13KS\x93\xb3\
\xd3a\x16\x96\xde;w\x98\x0f);0M\x0c\xbch\xb8\xd1\xe9\x90R\xe1\xc7\x87\x9c\
\x9d\n\x8dK^<\x11\x89M\x0c4\xfcx\xa5eK\xc9\x84\x86|\x9f\xae\xd6\x89-3\x96L)q\
K\x13\xf3P\xd0\xb9\xad\xa4\x1e\xee\x16\x13\xe6\x17\xa7\xa8\xcd\xaf\xb2`r|@\
\xc4\x12\r\xd5\xb5K\xd6,\x8a:\xe3\xc0\xc2\xc0\x90\xf7U\xd9\x8ae\xa6d\x16\xd0\
S\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\
\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\
\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VF\x16\x10\r\x8f\xf8\x9e\
\xbe\x03\x85\xb9\xa7\xab\x9f\xcb:\xa7\x84&\x00\xe0\xfa6\xd7' )

addArtData('wxART_GO_FORWARD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\x9e\t\xf0\tq\xfd\
\xff\xff\xbf~\xd2\t\xdd\xf8\x03\xdaQ\xdb5\xc3\xd6\xa9\x05,Q\xf1\x9e\xa9\x11\
\xbaN\xc5{\x96\xa2[\x9f\xa2[\xbf\x9cc\xb3\x9cc\x8b\x8cu\x85\xa4Y\xae\xb8A\
\x92\xa0\xaa\xb7\x90\xaa\x8f\x80\xbc#\xbf\x82#\xaf\xb4\x19\xbf\xbc\x03\x8f\
\xb4\x19\x97\x98.\x8f\x94\x19\x97\xa8\x0e\xa7\xa0\xb2\x90\xaa7\x97\x98\x0e\
\x87\xa0\x12\x1b\x8f\x94a\xeay\xb0\xe1\xfbu\xe3\xf6\xef\xba\xf2[3t\x9dV\xd4\
\xf6\xad\x17~\xaf?\xf3K\xc5g\x16\xd0\x96\xf5g\x7f\xae:\xf9s\xc9\x91\x1f@+\
\xd4\x03\x96,>\xf2c\xee\xc1\x1f\xd3\xf6|\x972\xcd\x05:c\xee\x81\xef\x13v|\
\xeb\xdc\xfcMD+\x1c\xe8\x92~\x10\xfb\xab\x88V\x98\x9cC\xcb\xb4=\xdf\xfa\xb7\
\x7f\x93\xb1\xae\x04\xbaJL?QD;\x0c\xe8\x91\xfeK\x8f\x05\x81\xfe\x92/\t\xf2\
\x03\x85\r>\xf0t\xa7\x9d.\x90bL\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x19\x18\
\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\x99z\xf7\x83g\
\x80B\xb5\x9e.\x8e!\x12\x97{O\x9cdjt``{\x90\xc8\xa3\xb9r\xa2R\xf4\xcd\xe9\
\x13.\x1a\x9d\xb9q\xff\xffB\x99\xff\xdd\xcd\xef\x7f\x08~\n\x0eYyIj\xb5\xf2#\
\xcd\\\x83\xc5\x9d3\xce\x8a\x9f1\xd0=R\xb4\xf5\xde\x0c]\xe9\x8dwU\x7f7\xdfu\
\x93\x99\xfcE\xe5\x1c\x9f\x92wq\xe0\x14\xa1\xc2\x93GC3\xc5\x0bw\xdbOy&{ds\
\xc0\xa4\xea\xd8#\xde\x9e\xd7\xf9\xab:\xb6?\x8b\xb3\x97Q\xb0s\xb6\x97\xe8U\
\x7f\xa2\x1f\xcf\xfb\x83\xfb{\xd09\x99\x00\xa0CTK\\#JR\x12KR\xad\x92\x8bR\
\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\
\x95\xb1\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rM\
B\x0c\r\xac\x8cM\xac\x8c, \x1a\x1e\xf1=}\x07\n\'OW?\x97uN\tM\x009\xbe\xd6I' )

addArtData('wxART_GO_LAST', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\x16\x06\xf8\x84\xb8\xfe\
\xff\xff\xdf8\xfb\x96Q\xc6U\xc3\xd4\xf3\xfaI\'t\xe3\x0fhGm\xd7\x0c[g\x90z^7~\
\xbfF\xe8:\xb5\x80%\xbaq\xfb5C\xd7\xa9x\xcfR\x0f\\\xac\xe23K\xd1\xad_\xc9\
\xad_\xce\xb1E\xde\xa1Y\xd6\xbaB\xd24W\xd2,W\xdc Q\xdc ID+L\x0cD\x86\x0b\xa9\
\xfa\x08\xaaz\xf3\xcb;H\x99\xe6\x8a\xe9\'\xf2+8\xf2H\x99I\x99\xe5\x8ah\x87\t\
\xa9z\xf3H\x9bq\x89\xe9\x00\xed\x05\x1a\xae\xe2=S\xd1\xadO\xde\xb1E\xc6\xba\
\x12\xe8\x0c\xa0-\x8b\x8f\xfe\x98{\xe0\xfb\xb4=\xdf\x80&\x1be^=z\xfb\x8f^\
\xd2q\xa0\xa5s@\x82\xdf\'\xec\xf8\x06\xb4\x08\xe8\xbcC7\xff\xec\xbb\xf6[+j;\
\xd0%\xfd\xdb\xbfun\xfe\n\xb4\x1d\xe8\x85]W~m\xbd\xf8K\xc6\xba\xa2c\xcb\xd7\
\xa6u_\x80\xce\xd0\x8d;\xb0\xeb\xf2\xaf\xad\x17~\xaf?\xfbk\xd5\xc9\x9f@\'5\
\xad\xffZ\xb3\xea\x0b\xd0y@\xcfn\xb9\xf0{\xc3\x99_+O\xfe\\|\xe4G\xd9\xb2\xcf\
\xbc\xd2f@\xcf\xae:\xf1S\xd6\xba\xb2`\xd1\'.Q\x1d\xf5\x80%@\xef\x14,\xfe\x9c\
5\xff#\x87\xa0\xf2\x92\xa3?\x80\xde\xc9\x9a\xff)u\xf6G6^)\xa0_\xb2\xe6}J\x9d\
\xf3)q\xc6\x07\x16NayGP\x98$\xce\xf8\x18;\xfd\x033\x1b7\x87\xa0\x12\x1b\x8f\
\x14\x0b\xa7\x103+\x0f#\x13\x1b0\xb4#[\xfc\xcf\x02#J\xb3$\xc8\x0f\x14\x81\
\xc4\x01\xf5\xdf\xfb\xb3\x80\x14c\x92\xb7\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\
\xe0\x11Y\xcc\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0\
q)\xc9\xd4\xbb\x1f<\x03\x14:\xeb\xe9\xe2\x18"q99\xe1\x00\xcb\xac\x1e\x9f3:kr\
\xdeD\xdd\xb2\xdaU\x95\xc0X\xcb\'\xe6g\xa6\x97\xc7\xec\xac\x9c,<\xa1a\xe5LK~\
i}\xf3\xf9\xadK\xa7n\xe5\xf58p\xed\xdc\xbd\xc6\xeex\x87\x0b\x17o\x9c\xbc\xc9\
\xaa\xf2 \xeb\xfd\xb3uG\xd5U\xde$\xbe}\xf9\x94W\xe8\xc3\xc7\xaf\x9f\xf9/\x08\
\n\xf2\x96\xf0q\xf11r\xb6\xb4\xb5\xba\xbbHUv\xdc\xac`uwmfI\xfa\x93\xac\xdc\
\xfb\xe8\x88jL\xd3\xe2G\xc2\x0eL\x9d\x82m\xd3\xe4\x92&\x05y\x06\x9e\xd4\\\
\xa9\xc0\xf8\xd6D\xd9\xd60S\xf2\xe6\x97\'=gt&4\xb4N\x9c\xb7\xa3\xa5gNM\x99_^\
\x9c\x9d\xc7\x82\x05\x01\x8e\x81^a\x9e\x96\x8a\x9bW\xec`Qy\xb0Pi\xe1*\xb5\
\xf5\xeb\x02\xa3\xc2\xe2\x02O:\x00}\xa8\x9d\xaaV\xd6\xba\xa9\xfc\x04\xd0c\
\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\
\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\
\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VF\x16\x10\r\x8f\xf8\x9e\
\xbe\x03\x85\xbb\xa7\xab\x9f\xcb:\xa7\x84&\x00\xa8\xf8?\xa9' )

addArtData('wxART_GO_NEW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\xbe\t\xf0\tq\xfd\xff\xff\
\xbf~\xd2\t\xdd\xf8\x03\xdaQ\xdb5\xc3\xd6\xa9\x05,Q\xf1\x9ey\xec\xf6\xdf\x89\
;\xbf\xb5n\xfa\x1a=\xe5C\xef\xf6\xefG\xef\xfc=r\xfb\x0f\x10\x1d\xbd\xfd\xe7\
\xf0\xcd\xdf{\xaf\xfd\xd9v\xe1\xf7\xfa\xb3?\x17\x1d\xfe1}\xef\x0f\xa0\xe0\
\xb1\xdb\x7f\x16\x1e\xfe\xd1\xbb\xfd\xeb\xb1[\xbf\xfb\xb6\x7f\xab^\xfd\xb9z\
\xcd\xe7\x92\xa5\x9fs\xe6\x7fL\x9d\xf31n\xc6\xa7\x88)\x1fV\x9c\xf89\xff\xe0\
\xf7\x98)\xef#\xa7|\x98\x7f\xe8\xfb\xf4=\xdfz\xb7~\x8d\x9a\xfa!j\xca\x87\xa9\
{\xbe\xb5l\xf8Z\xb3\xeaK\xf1\x12\xa0\x96O\xa9\xb3>&L\xff\x185\xf5#Pe\xf4\x94\
\x8f\x86\xa9\xe7\xc1.\xdc\xaf\x1b\xb7\x7f\xd7\x95\xdf\x9a\xa1\xeb\x80.9x\xf3\
\xcf\xb1\xfb\xff\xf7\xdf\xf9\xbf\xfe\xcc\xcf\xe5\'~jEm\xdf\nt\xd2\x99_*>\xb3\
\x80\x8e9r\xeb\xcf\x91{\xffS\xdbN\xc5\xd5\x1f\xddx\xf1?\xd8\xba\xef\x1a\xa1\
\xeb\x80n^u\xf2\xe7\x92#?\xe4\x1c[\x80\x1e\xd9s\xed\xd7\xe1\xbb\xff\r\xc2\
\x96\xa9\x05,Xs\xfe\xff\xb4\xdd\xdfz\xb6}k\xdb\xf8U=`\xc9\xe2#?\xe6\x1e\xfc1\
m\xcfw)\xd3\xdc\xe3O\xfe\xdb\xc7/6\x8d\x98\xb7\xe6\xf2\xffi\x87\xfew\xed\xf8\
_\xbd\xf2\x130\x94\xe6\x1e\xf8>a\xc7\xb7\xce\xcd\xdfD\xb4\xc2\xed\xe2\x16\
\xab\xb9u(\xd8V\x19x\xd7*\x18\xc5\xd8G\xf6T\xaf\xfb\xa7\xe8\xd6\xdf\x0fR\xf0\
UD+L-`\xa1Y\xf8\\E\xbbj\x19\xb3\x1c5\x97\n1\xedP\xb3\xd0\xf6\x92U\xff\xe5\
\x1cZ\xa6\xed\xf9\xd6\xbf\xfd\xdb\x86\xf3\xff\xd6\\\xfao\xe4]\xa7\xe1\\>\xf1\
\xd0\xff\xfaM\xff\x8bW\xfeO\x99\xf9^\xc6\xbar\xc1\xc1\x1f\xc0 \x9aq\xf8\xbf\
\xbcq\xac\xa0N\x080\x88\x92\xe7|\x88\x9f\xfeA\xd2,\x17\x14\x8c\xdb\xbf\xf5\
\xec\xfcg\x17\xd5k\x12\xda^\xbc\xf2O\xea\xecOq3>\x8a\xe9\'6\xaf\xffZ\xb5\xee\
\x7f\xd2\xcc\x0fq\xd3>\x88h\x87\x01#\xfa\xd5r\xa59\xc04bV\x12\xe4\x07J;p\xc0\
\xc8\x9c|\xfc\xc3\x87c\t\xcc\x8cB\xbbv\n\xec\xdd\xc5\x19\xb6\xf9\xd9\xb3\xcd\
a\x92\xe7wq0i\\:,h!^z\xe6\xc3\x87\xe3I\x9c\xac\x9d\xfcWR@\x1a\x92\xbc\xdd]\
\x18:Xe=\x80\x1c\xce\x02\x8f\xc8b\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\xe9\
\xeb\xca\xfe\x90\x83\x8fKI\xa6\xde\xfd\xe0\x19\xa0\xd0cO\x17\xc7\x10\x89\xcb\
\xc9\t\x07\x18\xd2z|\xce\xe8\xac\xc9\xe1`,\xe6f\x93+\x8b\xb3\xabctTL\x14\xe4\
\x0bdc\xf3\xd6\xce\x0e3,\x94\x8e\xb6\xaefw\xe7\xf4\xf4ccSO\x17\x0f\xd74/\xe7\
\xf7\xd7\xcf\x97\x8f\xcf\x94dc\xb3\xff\xdfp`\xc1\x83\t\x176|\xe88\xb1"#\x92\
\xadmF\xc3\x8d\x1d?Z.\x1cY\xf2d\xca\x95-%\x96lm=7\xce\xfcX\xf3f\xce\x9d=\x7f\
\x9a\x0e-J\xaadk\x9bt\xe6\xc7\xa5M\x9f\xbaN\xadz5\xeb\xd6\xae*V\xb6\xb6\xb6c\
\xcb6}z\xd61\xed\xda\xb6o}\xe7\xf4\\\xd9\xda\xde\xad\xd9$s|\xde\xbd}\xff8e\
\x85\xd5}\xc3\x92\x12f\x04M[\xbc\xc6\xa8\xf4\xd6\x17I\xe3\xf4\xb3\xf3\x16\
\xaf:v\xc0`\xfb\x1c\xc7X\xe7\xe2\xb8_\x7f\xce\xb1ro\xdd\xb2SBB\xcc\xd0\xe0E\
\xc1\xebW/\xa5%\xa4$g\x17\xcc4\x12`ax7\xc1:\x7f\xbeQ\xfcF\xa0wUK\\#JR\x12KR\
\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\
\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\
\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\x8c, \x1a\x1e\xf1=}\x07\x8a7OW?\x97uN\tM\
\x00F\x1d\xfb!' )

addArtData('wxART_GO_UP', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\x1a\x07\xf8\x84\xb8\
\xfe\xff\xff\xdf8\xfb\xd6\xf1;\x7fv]\xfe\xb5\xeb\xca\xef\xe5\xc7\x7fN\xd8\
\xfe]\xd3k\xc2\x84\x1d\xdf+\x96\x7f\x89\x9f\xfe\xd1\xb3\xe3\x9dY\xf5\xdb\x8a\
\x15\x9f\x81:\x12\xa6\x7f\x04\xaa\x0f\x9bj\xfa\x05\xc8a,\t\xf2\x0bfpxv#\r\
\xc4I\xf2vwa\xe8`\x95\xf5\x00r8\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\
\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\x99z\xf7\x83g\x80B\x0e\x9e.\x8e!\x12\x97\
\x97\xf6Fr1(\x880m>\xfb\xed]\xfd\xed\x0e\x8eW\xb5\xd7\xfe\xf4*i}\xe5Y\x92\
\xcdq\x9dm{\xf4\xf3\xca\xafzG\\\x1e\xee\\\xc3\xc2 \x99\x955\xd96\xe9\xed\xce\
\xb9\xfaO.\xfe3f\xd8\xa4\xc4\xd8\x99\xa8\xc8\xbd\x18h\x96j\x89kDIJbI\xaaUrQ*\
\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\
\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x91\x05D\xc3#\xbe\xa7\xef\x80\
\x1a\x18<]\xfd\\\xd69%4\x01\x00\xd8\xdf\x86\x9f' )

addArtData('wxART_GUIDE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\x87y\xba8\x86X\xf4\
&\xa7\xa4,\xe01X\xc8\xfd'?\xe3\xc7\xff\xfd\x0b\x1f\xda\xdfd\x9b\xc0\x15q\x81\
UjA\x89\xf2D6\x03##\x879\xbc\x97y\x8c\x1b$\xcc\x92\x9d\x99\x95\x8f\xc6%\xb8\
\xf4\xb7V\xad\xc8\x96\x92\x96\xea\xe8R\x98\x93\xe8\x90\xf3\x85\xafF\xa7\xa7\
\x8a\xd1\xdbJA4@\x86\x8dA!Jl\xbd\x8f\x1d\xa7\x17\xd0\x06\x06OW?\x97uN\tM\x00\
\xd8\xdc,\xd2" )

addArtData('wxART_GUIDE_LOCK', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\x97{\xba8\x86X\xf4\
.\r\x8e\xe6;\xa0\xc0\xa3u\xfa\x9d\xad\x8d\xe5\xef\x19\xb1=\xd5\x0f\xdf\xf4/\
\xf3\xd5\xf4`M\xd2\x9bf\xa7\x18\xa4\xf4U:\xc1\xe4\x9a\xdd\xc1*1a\x86\x8e\xe6\
23\xf5\x86b\xf6\xceL\xce\x17\xb17\xb4f;E\xb1\xd9\xee;\x18\xbb])$;\xfd\xe6\
\xb4\x05\x1c\x0f\x13zX\xaaR\x1f\xecJ\xf0<\xd1\xf9\xf6I\x8a\xc9\x13'\xaf\r\
\x12w<3$k\x98v\xcc\x7f\xb3\x89}\xb1\xe1\xdeN\xeb\xc4m*k9\xd6g\x94\x01\x9d\
\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00z\xd9B\xc4" )

addArtData('wxART_HARDDISK', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xd1\x00\x9f\x10W\x90\x82\x86\x86\x03\x07\x0e\x00\x19\xff\
\xff\xffgh\x00\x91\xbe\n\x86@C\x18\x18K\x82\xfc\x82\x19\x1c\x9e\xddH\x03q\
\x92\xbc\xdd]\xd8\x12\xd3v\xd4\x029\x9c\x05\x1e\x91\xc5\x0c\x0c|\x87A\x98\
\xf1x\xfe\x8a\x14\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%\x99z\xf7\x83g\x80B\x16\x9e.\
\x8e!\x1c\xd7\x93\x13\x1489\x9a\x1a\x19\x98\x17\x0bIp\x18w\xechhXl\xd0,\xd0\
\xb1~\x15G\xaaF\xa3D\xc2V\x05\xb6\x08\xde\t\x8c\x17u3\x0e\x1c\xc8\xe1a\x8b\
\xd0\x01\xeal\xe1d\x0f\x8b(\x93\x02\xb2TK\\#JR\x12KR\xad\x92\x8bR\x81\x14\
\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\
\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\
\xac\x8cM\xac\x8c, \x1a\x1e\xf1=}\x07\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\
\x00\xcaMdR" )

addArtData('wxART_HELP', 'wxART_OTHER_C', 16,
b'x\xda\x01\x7f\x04\x80\xfb\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\
\x10\x00\x00\x00\x10\x08\x03\x00\x00\x00(-\x0fS\x00\x00\x00\x04gAMA\x00\x00\
\xb1\x8e|\xfbQ\x93\x00\x00\x00 cHRM\x00\x00z%\x00\x00\x80\x83\x00\x00\xf9\
\xff\x00\x00\x80\xe9\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17o\x92_\
\xc5F\x00\x00\x02XPLTE\x00\x80\x80\xb2\xc7\xd7\xa2\xbf\xda\xa5\xc1\xde\x9f\
\xbc\xd9\xa1\xbb\xd3\xc7\xd1\xd4\xbb\xcc\xd7\xb0\xc9\xe3\xe6\xee\xf4\xdf\xe5\
\xee\xc3\xce\xe1\xc0\xcc\xdf\xce\xd7\xe5\xea\xed\xf0\xba\xcd\xe0\x9d\xb7\xd0\
\xb5\xc8\xd8\xc9\xda\xec\xe1\xe7\xef{\x98\xc4P\x7f\xbaE{\xbc=u\xb9>r\xb4U}\
\xb5\xbc\xc9\xdc\xde\xe6\xea\x90\xaf\xcd\xc5\xd2\xd7\xc0\xd5\xeb\xd0\xd9\xe7\
\\\x86\xbd]\x92\xcc\x87\xaf\xdb\xab\xc7\xe5\xb8\xcf\xe8\xa1\xbe\xe0_\x8f\xc7\
1h\xad\x98\xae\xcd\xde\xe4\xe8\x94\xb0\xcd\xa7\xc2\xde\xe9\xed\xf2f\x8b\xbf[\
\x92\xce\x84\xaf\xde\xfe\xfe\xfe\xff\xff\xff\xf7\xf9\xfcy\xa1\xcf-d\xaa\xbb\
\xc7\xdb\xb3\xc6\xda\xc5\xd0\xd1\xcc\xd5\xd7\xc7\xd9\xed\xa1\xb5\xd3W\x8c\
\xc8_\x98\xd5}\xab\xde\x9d\xbd\xe1N\x89\xccP\x8b\xce\xd6\xe4\xf3\xda\xe5\xf2\
\x1b]\xadLu\xb0\xe5\xe8\xeb\x96\xb1\xcb\xb1\xc7\xd8\xe4\xec\xf3j\x8e\xc0[\
\x92\xd0\\\x96\xd6U\x91\xd6I\x89\xd2H\x89\xd4E\x87\xd3\xb3\xcd\xec\xd3\xe0\
\xf0\x1a]\xaf\'_\xa7\xcd\xd5\xe1\x8e\xac\xcc\xa7\xc0\xd8\xf1\xf4\xf6Q~\xb9V\
\x8f\xcfV\x91\xd5P\x8f\xd6I\x8a\xd5D\x86\xd3p\xa2\xdd\xf1\xf6\xfbu\x9f\xd1\
\x1a^\xb2\x18V\xa5\xb3\xc0\xd6\x8d\xac\xcf\xa3\xbf\xd7\xf1\xf3\xf5Mz\xb7M\
\x88\xcbN\x8c\xd1J\x89\xd4F\x88\xd3\xd4\xe3\xf4\xfd\xfd\xfe\xd4\xe1\xf1j\x99\
\xd0 e\xba\x17\\\xb1\x15S\xa3\xb2\xbf\xd5\x8c\xab\xce\xab\xc3\xd6\xe2\xe9\
\xf1c\x88\xbcB\x7f\xc4E\x84\xccC\x84\xd00q\xc0%k\xc1\x1cb\xb9\x12V\xac"Y\xa4\
\xcb\xd3\xe0\x8b\xa9\xcb\xc5\xd2\xd5\xc3\xd5\xe9\x9b\xaf\xce8s\xb99y\xc39{\
\xc89{\xca\x98\xb8\xe0\x94\xb5\xdd$i\xbe\x1ed\xbc\x14Y\xb1\rO\xa5Gq\xad\xe3\
\xe5\xe9\x91\xad\xc8\x9b\xba\xda\xe2\xe7\xedT}\xb6,l\xb7,o\xbd.q\xc2\xaf\xc9\
\xe8\xad\xc7\xe6\x1db\xb8\x13Y\xb1\x0cP\xa7\xb0\xc3\xd8\xc0\xcb\xcf\xba\xcb\
\xd4\xb8\xce\xe5\xc7\xd0\xe0Gt\xb1#c\xb1$e\xb5\x16X\xac\x0cO\xa5 X\xa4\x90\
\xa6\xc7\xda\xe0\xe7\x89\xa7\xc7\xa4\xbc\xd1\xc1\xd2\xe6\xd7\xdd\xe6l\x8c\
\xbb3f\xab%_\xaa [\xa7"Z\xa4\xb1\xbf\xd5\xd8\xe0\xe6\x83\xa3\xc8\xab\xc0\xd1\
\xa0\xbc\xda\xdb\xe2\xea\xd3\xda\xe4\xb8\xc4\xd7\xb6\xc2\xd6\xc3\xcd\xdc\xe0\
\xe4\xe9\xb3\xc6\xdc\x8b\xa9\xc8\xd3\xd8\xd4\x9a\xb4\xce\x8a\xac\xd1\x91\xaf\
\xd4\x92\xb1\xd4\x8a\xaa\xcf\x8a\xa9\xc9\xb9\xc6\xceT6\xf4a\x00\x00\x00\x01t\
RNS\x00@\xe6\xd8f\x00\x00\x00\x01bKGD1\xd9\xdb\x1dr\x00\x00\x00\tpHYs\x00\
\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x00\x07tIME\x07\xe1\
\x08\x0e\n"\x1c\x7fG\xc1\xcc\x00\x00\x01\x02IDAT\x18\xd3c`\x00\x01F&ff\x16V6\
\x06(`\xe7\xe0\xe4\xe2\xe6\xe1\xe5\xe3\x17\x80\xf0\x05\x85\x84ED\xc5\xc4%$\
\xa5\xa4e@|Y9y\x05E%e\x15U5u\rM-\xa0\x80\xb6\x8e\xae\x9e\xbe\x81\xa1\xa1\xa1\
\x91\xb1\x89\xa9\x999\x83\x85\xa5\x95\xb5\x8d\xad\x9d\xbd\x83\xa3\xa1\x93\
\xb3\x8b\xab\x1b\x83\xbb\x87\xa7\x97\xb7\x8f\xaf\x9f\x7f\x80a`PpH(CXxDdTtLl\
\\\xbcABbRr\nCjZzFfVvNn^~AaQq\tCiYyEeU\x95\xa1auMm]}C#CSsKk[{GgWwOo_\xff\x84\
\x89\x0c\x0c\x93&O\x99:m\xfa\x8c\x99\xb3f\xcf\xa9/\x9e;\x8f\x81a\xfe\x82\x85\
\x8b\x16/14\\\xbal\xf9\x8a\x95\xab@N]\xbdf\xed\xba\xf5\x1b6n\xea\xdf\xbce+\
\xc43\xdb\xb6\xef\xd8\xb9k\xf7\x9e\xbd\xfb\xf6\xc3\xbc{\xe0\xe0\xa1\xc3G\x8e\
\x1e;\x0eb\x03\x00s]QsPu\xa9`\x00\x00\x00%tEXtdate:create\x002017-04-22T17:1\
4:39+02:00<S\xcb\xe6\x00\x00\x00%tEXtdate:modify\x002017-08-14T10:34:28+02:0\
0\xe2\x0e\xe5\xee\x00\x00\x00\x00IEND\xaeB`\x82,(Md' )

addArtData('wxART_HELP_CONTEXT', 'wxART_OTHER_C', 16,
b'x\xda\x01l\x03\x93\xfc\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x03\x00\x00\x00(-\x0fS\x00\x00\x00\x04gAMA\x00\x00\xb1\
\x8e|\xfbQ\x93\x00\x00\x00 cHRM\x00\x00z%\x00\x00\x80\x83\x00\x00\xf9\xff\
\x00\x00\x80\xe9\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17o\x92_\xc5F\
\x00\x00\x01ePLTE\x00\x80\x80\xa9\xc5\xdd\x97\xb6\xce\xc9\xdc\xef\xe4\xea\
\xf1\xca\xd5\xe6\xc7\xd3\xe5\xd6\xde\xea\xe6\xeb\xf2{\x98\xc4P\x7f\xbaE{\xbc\
=u\xb9>r\xb4U}\xb5\xc5\xd1\xe3\xd6\xdf\xeb\\\x86\xbd]\x92\xcc\x87\xaf\xdb\
\xab\xc7\xe5\xb8\xcf\xe8\xa1\xbe\xe0_\x8f\xc71h\xad\xa5\xba\xd6\xec\xf0\xf5f\
\x8b\xbf[\x92\xce\x84\xaf\xde\xfe\xfe\xfe\xff\xff\xff[ZY\xf7\xf9\xfcy\xa1\
\xcf-d\xaa\xc3\xcf\xe1\xcf\xe0\xf0\xa1\xb5\xd3W\x8c\xc8_\x98\xd5}\xab\xde\
\x9d\xbd\xe1N\x89\xcc\xda\xe5\xf2\x1b]\xadLu\xb0\xe9\xf0\xf6j\x8e\xc0[\x92\
\xd0\\\x96\xd6U\x91\xd6I\x89\xd2H\x89\xd4\xfa\xfb\xfc\xd3\xe0\xf0\x1a]\xaf\'\
_\xa7\xd5\xdb\xe7\xf4\xf6\xf8Q~\xb9V\x8f\xcfV\x91\xd5P\x8f\xd6I\x8a\xd5D\x86\
\xd3\xe1\xe6\xee\x1a^\xb2\x18V\xa5\xbc\xc9\xdd\xf4\xf6\xf7Mz\xb7M\x88\xcbN\
\x8c\xd1J\x89\xd4F\x88\xd3\xd4\xe3\xf4\x15S\xa3\xe7\xee\xf4c\x88\xbcB\x7f\
\xc4E\x84\xccC\x84\xd0\xf5\xf7\xf9\xf0\xf2\xf6\xd2\xda\xe6\x9b\xaf\xce8s\xb9\
9y\xc39{\xc89{\xca\x98\xb8\xe0\xeb\xee\xf3\xe6\xea\xf0\xe7\xeb\xf0T}\xb6,l\
\xb7,o\xbd.q\xc2\xaf\xc9\xe8\xcf\xd8\xe6Gt\xb1#c\xb1$e\xb5\xdc\xe2\xeb\xde\
\xe3\xebl\x8c\xbb3f\xab%_\xaaGq\xad\xd6\xdd\xe8\xbf\xc9\xdb\xe1\xe7\xee\xda\
\xe0\xe9\xc1\xcc\xde\xcc\xd5\xe3\xe6\xe9\xed\xca\xd3\xe1\x80~zu\xa7N\xcf\x00\
\x00\x00\x01tRNS\x00@\xe6\xd8f\x00\x00\x00\x01bKGD\x1f\x05\r\x10\xbd\x00\x00\
\x00\tpHYs\x00\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x00\
\x07tIME\x07\xe1\x08\x0e\n"\x1c\x7fG\xc1\xcc\x00\x00\x00\xe2IDAT\x18\xd3=\
\x8f\xf9;\x82A\x14\x85g\xee\xd8\x12B\xc9\xee;\xd9\xb2$e\x19k\xe8\xab\xec%\
\x95-{"\x14\xd9\xff~3m\xefo\xe7}\x9e\xfb\x9cs\x19\xd3pRpV\x85\x93\xa8\xaboh\
\x14D\xe5L\xa2\xc9\xd2lmim\xb3\x89\x92\xe1\xa2\xbd\xa3\xd3\xee\xe8rv\xf7\xf4\
\x96\x0c\xf5\xf5\x0f\x0c\x0e\x190\\\xc3#\xa3J\xf0\xb1q\xf7\xc4\xe4\xd44`xf\
\xbc\x823\x9a\xf5\xf9\xe7\xe6\x17\x16!\xb1\xb4\xbc\xb2J\x8c\xd6\xd6\x03\x1b\
\x9b[AH\x13\xa1pD\x89\xed\x9d\xdd\xbd\xfd\x83CHe\xa2Z\xc4\x8e\xe2\xc7\x89\
\x84\x01\x99L\x998!\xd5zzv~\x91\xbe\x84L]]\x9bP5ts{w\x9fy\x80\xd4\x19\xd0\
\xc3\xb2\x8fO9u\x02\xf3\x19T\x9e\xfe\xf2\x9a/\x00ox/\xa2\xf2\xdc\xc7\xe7\x17\
\xbe\x7fP\xfcE\xed_\r\xfbS\xf9\x1f\xd9\xfc$\x7f\xe74V\xfc\x00\x00\x00%tEXtda\
te:create\x002017-04-22T17:14:39+02:00<S\xcb\xe6\x00\x00\x00%tEXtdate:modify\
\x002017-08-14T10:34:28+02:00\xe2\x0e\xe5\xee\x00\x00\x00\x00IEND\xaeB`\x82\
\x11\x82\xad\x0b' )

addArtData('wxART_HINT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4'y\xba8\x86X\xf4\
\x9e\x9dt\x90\xab\xc1\x80\xc79>\xe5\x7f\xee\x9fOU\x02\xa9b\xea^\xfc\xbf\xfc\
\x14\xd7,\x8d\xd4\x0eL>\xe56\x83C8\xd2>\xef\xc3\xb4i\xbc\xc9\x0cb5\x97\x94U\
\xb6\x05~\x7f\xb4\xd7\xc3-\xbc\xae.\xb8o\xc1+1\xa9?\xba\x87r\xd8\x0f$\xad\
\xbe\xbe]\xb0\xaa\xef\xe3$\xb9\x8f\x7f\x15\xa7*Oy\xbf\xe0\x0f\xbbv\x8f\xab\
\x99\xb6\xaa\x9b}<\xd06\x06OW?\x97uN\tM\x00\x9cu:;" )

addArtData('wxART_HINT_LOCK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xb7z\xba8\x86X\xf4\
\xae\x9d\xf4\x90\x8bY\x91\xa7y\x7fO\xf5\x87;\x93\xd3\xed\xe7<\xeab\xe7\x13\
\xd7\xb8\x92t\xb9%\xec\x11\xcf\xfa\xa8\x0eO\x9f\xac}\xbe\x1f\xb4\xd7E\x19\
\xb0=8\x16\xffSXe\xd6\x95{wf\xa7lYu\xdd\xfe\xb8X\xc9\xaeV\xeeo:w\xb69Us\x1f\
\xbb\xa3\xcb\xbd7\xd2\xf7\xa3\x82\x14\xd7\x93c\x15\xc99\xe9O\xa4\xa3\x1dT\r\
\x0e.y.\xbf6\xb2\xb5L\xd7\xe7\xb0\xc9\xeft\xd7\x80r;\xe5\t7\xff\xc7\xeb\xc8\
\xdc?\xf8Qu\x1fc\xc0o\xbf\xf9\xcf4\xfa,\x81\x0eb\xf0t\xf5sY\xe7\x94\xd0\x04\
\x00\x93\xfdNg' )

addArtData('wxART_HTML_FILE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\x1e\x0e\xf0\tq\xfd\
\xff\xff\xff\xe4E\xdb\x81\xa4\xa1{\xe6\xf9\xb7\x97{o-M?\x99\xe1\xbd\xa9{\xf7\
\xdd\x1f\xfbO\xde>\xf1\xf2`\xe1\x85\xc8uo\x0fO\xbc?On\xf1l\xd6\xda\x05E37>{\
\xfdY\x7f\xea1\xef}\x9a9\xe7B\xb2\xcf\xbc\xe6\x9a~\x9f\xa1^U\xa5"\x96=\xeb<\
\xff\xe4\x04\xb1y\x1d\x1c\x93?2\xd4.e(\x10\x11\x8d\x0f\xdfv\xe8\x9af\xc6a\
\x86\x94\xd3\x0c5E\x0c\x95v\x0cq{\xb8BK\xbd+g\xdc\x7f\xf2v\xd3\xc1\xc7LN+\
\x19\x83\xba\x18\xfdr\x99\xac\x17)y\xad\xd8p\xe0\xe1\xad\x07\xaf~\xfd\xfe\
\xf3\xf5\xdb\xcfM\x07\x1e;emQ\xf3\xdb\x12Pxr\xfd\xdeG7\xee\xbd\xbc|\xf3\xd9\
\x87O\xdf^\xbf\xfb\xf2\xec\xd5\xc7\xbb\x8f^;88\xc8\xa7\x88<|\xf6n\x8bL\x86&\
\xd0;\x8c%A~\xc1\x0c\x0e\xcfn\xa4\x818I\xde\xee.\x0c\x1d\xac\xb2\x1e@\x0eg\
\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\
S\xef~\xf0\x0cP\xa8\xcd\xd3\xc51D\xe2\xb2\xef\xa9\xebbM\x06\x02\xae\x17;\x95\
\xb5\xbaD\xab\x95\xcb\xde\x08I\xabN\xfb\xff_+R{\xe6\x89\xca;\xdf\x99\x18\x8c\
\x1b\xbb\x9e\x96\xf0\xfc\x9f\xb0\x9d\xeb\xa8\xd0\xe6\x89\x0bb\nWm\xadZ\xbcR\
\xa5u\xda\xedw%\xd5\xb5.M\x07\x0bL\xe6\xf9\xd8\x9e\xe3L\xfb|\xb4h\xeb\xbd\
\x1fl\xdbv\xff}Xa\x15\xcf\xc1T\xb8\xf7\xae\xfcy\x83K\x02\x1d\x16\x13?\x89\
\xba\xb1<Z\xab\xdc\xf1\xd2a\xc2\x92\xc7\xea\xbf\'|\xd9`Z\xb3\xd3\x931\xadI>\
\xf8\xa2(w\xbd\xc3\x19\x0e\xa0\x8bTK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\
\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\
\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\
\xac\x8c, \x1a\x1e\xf1=}\x07\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00\x82\
\xd1\xf7\xc1' )

addArtData('wxART_I', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R\x9c\x05\x1e\x91\xc5\x0c\x0c|G@\x98q\xaa6\x9f4P\xd0\xc1\
\xd3\xc51\xc4\xa279\xe6\xd7\x8b\xaf\xf5l\\\x0c\xc2\xaa\xb3$%$$"6pn\xdb%\x96\
\x14\x1a\xb3w\xf7\xfc_z\tG\xc4\xd9\x0c\xa6\'l\x9e\x99\xa5\'a\x9a` \xd1`*\xcb\
3o\x8a\x07\xcf\x82\x1b\xac\x0c%\x99b\x8fK\xde\x7f\xfa\x044\x8b\xc1\xd3\xd5\
\xcfe\x9dSB\x13\x00\x8b\xfe)2' )

addArtData('wxART_INDENT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xdd\x18\xe0\x13\xe2\xfa\
\xff\xff\x7f\x86\x86\x86\xc9\x8b\xb6\x03\x19\x86\xee\x99\x7f\xff\xfe\xdd\x7f\
\xf2\xf6\xbf\x7f\xff\xfe\xfc\xf9;s\xf9\xeeg\xaf?\x03\x15~\xfa\xf2c\xd5\xb6\
\xe3\x7f\xff\xfd\xfb\xf9\xeb\xcf\x97o?_\xbd\xfd\xac\x95xa\xcb\xb1W|||\x0c\
\x063DD\xc5f\xae\xd8\xed\x90\xbc1\xb1\xfbf\xeb\xba_\xef?}{\xf5\xee\xf3\xb3W\
\x1f\x1f>{w\xf7\xd1\xeb%\x1b\x0f\xff\xfd\xfb\x8f\xc1z\xcb\xa2\xf5\x87^\xbc\
\xf9\xf4\xf8\xc5\xfby\xab\xf7\x7f\xff\xf9\xfb\xdb\x8f_\x1f\xbf|\x7f\xfb\xe1\
\xeb\xfd\'oo=xu\xf5\xf6\xf3\x0b\xd7\x9f\x9c\xbe\xfch\xe6\xf2=\xd3\x96\xec|\
\xf2\xe2\xc3#\xa0\xf6\xc7on?|}\xed\xce\x8b\x8b7\x9e\x9e\xb9\xf2\xe8\xf8\x85\
\xfb\x87\xce\xdc\r\xd8r\xb9\x08\xe8&\xa6\x92 ?`\x00\x94M>k\x01\xe41&y\xbb\
\xbb0t\xb0\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\
\x90\xbd\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92L\xbd\xfb\xc13@\xa1Y\x9e.\x8e!\
\x12\x97C\xcf\xa7\x0b7\x19\xf0\xb0=\xb8t\xac\xebXcBl\xaa\xc5\x81\xbd\xdb\xff\
\xfd\x97O\xe3\xac\xba\xf2]O\xfe\x93\xca\xce8\xc9\xc7\xa92\xc7\x13{\n?r\xb7\
\xd7\xaf(\xe04\x0b\xb9\x1b\x15\xcb\xc4\xa8\xf4\xecj\x06\x93\xc3\xce\x8bY\xd5\
\xb2\xe7\xb8?\xfc=\xf0\xa5#\xf6OS@\x9bM\xf1\x95\xd7\xc2<S\xa4\xfa\xa6\xf0-\
\xb6\x90\x14\xf6i\t\xba\xac`"m\xa1\\\xe0\xbb\xfa\xb2N\xbb\xe5\xc1\xa4\x9dQ\
\xcbo\xa6\xed\xbe-\xdf\xc7r\xab\'\xa3\xafB\xa9\xe3\xdc\xf4\xd7o\xffU\xec\xbb\
\xb7\xa9\xc2l\xdb?o\x86\xb2\x1b\xec\xbd\x9b\xb8S\xb6\xcb\x97\xf2\x00]\xa9Z\
\xe2\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\
\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\
\x99V\t\xd5`\xa1kh\x12bh`elbed\x01\xd1\xf0\x88\xef\xe9;\xa0\x06\x06OW?\x97uN\
\tM\x00\xa5\xf7\x19\n' )

addArtData('wxART_INFORMATION', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba1006\x04\xf8\x84\xb8\xfe\xff\
\xff\xff\xd0\xc1CS\xa6L\xa9\xa9\xa9)*,z\xf8\xf0akk\xfb\x82\x85K\xb7\xef\xdcw\
\xe2\xe4\x85\xae\xce\xae\xe9\xd3go\xd9qb\xc1\x86\xdb\xa5\xb3^eM\xfc\x90\xdc\
\xf5l\xf2\xb2k\x9b\xb6\x1f\xdb\xb0\xf3r\xfb\x82\x87\x11\xcd\xef\xcb\xe7|\x07\
\x1a\x92;\xe5\x8bc\xce\xd5\xdc\xee+\xab\xb6\x9co\x9as7\xa0\xe6iP\xf5\xc3\x9c\
\xc9_\xee>\xf9\xfa\xe9\xe7\xff\x94\xeew\x96)\xe7\x1d2\xcff\xb4\x9d\xdd\xb0\
\xf5\xe8\xec5\xd7=K\xee\xfa\x96\xdd\xf6-\xbd\x19V\xf7\xc2\xa5\xe8\xad[\xe1S\
\x9d\x98{\xd6)g-\xe2\x8f\x99D\x1f\xec\x9c}&\xaf\xf7\xba[\xfe\x15\xb7< \xba:{\
\xd5\xf5\xbbO\xbe\xfd\xfe\xfd+\xaed\x8b\xa4\xdd\n9\x97ur.k\x03rv\xf9\x14\\t\
\xc88\xe7\x98q\xde2\xf1\xd4\xad\x1b\xd7\xf3\x9bw\t\xe8O\x91r\xd8 e\xbfJ\xd3{\
\x9d[\xf6)\xeb\xa4S\xc6\xd1\x87e]6\xd4\xf4\x1d\x142\x9c*e\xbfI\xcan\xad\xa6\
\xd7\x86\xb8\x9aS\x06\xe1\xfb\x15\xdc6H\xda\xad)l\xde+l0E\xc6~\xbb\xb4\xddf\
\xdf\xf4=\xed\xb3\xce(xl\x92u^/e\xbf\xe1\xca\xa5\x8b\xc9\xa5;\x84\r\xa6\xca\
\xd9\xed\x92\xb3\xdf\xd58\xe1\xe4\xc6mG\x83\xf2\xf6\xca9o\x94\xb2\xdf\x98\\\
\xbaS\xc4h\x96\xbc\xfd\xfe\xb0\x9c\xe3\xeb6\x1dY\xb6\xe1tp\xde~i\xfbm\xe5=\'\
7\xee\xbe\xbbe\xcf\xdd\xe0\xf4\r\xc2\x863\xc2rN,^sn\xfd\xe6#M\x93N\xfag\x1c\
\xd6v\x9d\xa6\xe36- uIC\xff\x99u\x9b\x8e\xfe9\xb1\x05\x18/\x0c\x8c%A~\xc1\
\x0c\x0e\xcfn\xa4\x818I\xde\xee.\x0c\x1d\xac\xb2\x1e@\x0eg\x81Gd1\x03\x03\
\xdfa\x10f<\x9e\xbf"\x05(\xc8^\xe2\xe9\xeb\xca\xfe\x90\x83\x8fKI\xa6\xde\xfd\
\xe0\x19\xa0\xd0CO\x17\xc7\x10\x89\xcb\xc9\t\x0cLnjibbijnl\x1c\t\xa9I\xc9\
\xcf\x1f<y\x92\x90\x9e\x9c\xc4\xfay\xe7\x8e\xca\x8a\x9f?~\xb2\xb2\xb4\xee\
\xd8\xe9\xa0\xe4s\xe7\x90\xd2\xa2\xa4G\x8f\x84&\x05]\xba\xe3\xe3\xf07\xc7\
\xc6hS\xd1\'\xae.\xafSZ\xab\xb2rzx|\xde\xbc\x92\x9a\x15u\xcbjW\xd5/\xb66\xb7\
7><gd\x8e\xa9-K{&6-\xec\x9a\xd9\xb62\x993<:s\xbe\xf1\xf5\xf9=;7Mo]\xde;\xb99\
:\x0e\x8c\xfe\xfa\xf9\xf2\x0b\x1a\xd6\xcf\xafwP\x08h\x98\xa9\xaca\xa1"\xa2! \
&\'(\xc9z\xe5\xd0\x119Ya\xe9t\xb9\xfc\x99\x13fL\x99\xc3d2e\xa2\xae\xa9\xae\
\xed\xe1;\x97\x8c\x8c\xb5\xad\xd5\xc53t/$V\xfedmu=\xaa\xba4\xf5\xa9B{\xe3\
\x9c\xb8\xc0\xc8\xd0\xd8\xe0\xe8p\xfeB\xab\xb6\xe7\x17\xf6\xf03\xfc\xde\xa02\
#1f\x7f\x05\xd0\xb3\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\
\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\
\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VF\x16\x10\r\
\x8f\xf8\x9e\xbe\x03j`\xf0t\xf5sY\xe7\x94\xd0\x04\x001g}\xe1' )

addArtData('wxART_ITALIC', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5.\r\xf0\tq\xfd\xff\
\xff\xff\xe4E\xdb\x81\xa4\xa1{\xe6\xdf\xbf\x7f\xf7\x9f\xbc\xfd\xe3\xe7\xefg\
\xaf?/\xd8t\x93\xc1`\x86\xbc\xe7\xd2\xcf_~4\xcc8\x13W\xb3\xef\xe3\x97\x1f\
\xef>|}\xf9\xe6\x93N\xc8\xaa-\x87\x1e\xbc\xff\xf4\xed\xc9\x8b\xf7\xf7\x9f\
\xbc\xfd\xf6\xe3\xf7\xd3W\x9f^\xbd\xfb|\xeb\xc1\xab\xbf\xff\xfe\x9d\xbe\xfaJ\
3p\xc5\xb3W\x1f\xef>z}\xe3\xde\xcb\xcb7\x9f\xfd\xfa\xfd\xe7\xe7\xaf?s\xd7_\
\x8b\xa9\xde\xf3\xf0\xd9\xbbsW\x1f\x7f\xfd\xf6\xf3\xcb\xb7\x9f\xb9\x1d\x87\
\xbb\x17\x9e=y\xf1\xc1\x87O\xdf>~\xf9~\xff\xe9\x07\xfd\xb0U\xeb\xf7\xde\xbez\
\xfb\xf9\x91\xb3w_\xbf\xfb\xb2\xeb\xf8\xc3-\x07o_\xb8\xfe\xc4\xe7\xb2\xe2\
\x1f\xa0\x83\x19K\x82\xfc\x82\x19\x1c\x9e\xddH\x03q\x92\xbc\xdd]\x18:Xe=\x80\
\x1c\xce\x02\x8f\xc8b\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\xe9\xeb\xca\xfe\
\x90\x83\x8fKI\xa6\xde\xfd\xe0\x19\xa0\xd0dO\x17\xc7\x10\x89\xcb\xa1\xe7\x9f\
\x0b5\x19\x08\xb8]\xd4a\xfc\xbayQ\x93\xd0\x14%/\x9d\x88\x8d{\xfe/\xee<\x92\
\xb0\xe7\xff\xb73o\xce\xe8%\x7f\xe9\xbe:q\xa9\xf2?~3\xcb;,\xbb]\xdfF\xd9]`\
\xbc\xf0V\xf0\xb9\xd4\x1a;\xb6\xc3\x13\xbd\xaf\x1c\x90\x98\xbc\xf2\xf5O\xde3\
\r\x95\x0f~:9\xef8`\xd4\xf1H%t\x03\xd7fS\xb3\xc0yK\x82\x0e\x9a\xdd~[\xf8\xc1\
U\x8b\x9b\xf5\xf8\xe5\x9fM\xabw\x9c\\\x14RP\x1f\x12\xfe\xe0\xa7\x96\x97\xbb\
\xe3\x94\xe3\x9e[\xe3\xcf\xc6\x9f\xe8\xad\xcf~\x90\xf6\x86\xd7\xd4\x87\xeb\
\x10K\x9f\xb4\x0e\xd0y\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\
\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\
\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VF\
\x16\x10\r\x8f\xf8\x9e\xbe\x03j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xa1P\x16z' )

addArtData('wxART_JUSTIFY_CENTER', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xf5\x0b\xf0\tq\xfd\xff\
\xff\xff\xe4E\xdb\x81\xe4\xd7o??|\xfaf\xe8\x9e\t\x94y\xfd\xee\xcb\xdf\xbf\
\x7f\x7f\xfc\xfc\xfd\xec\xd5\xc7\x87\xcf\xde}\xfe\xf2\xe3\xdd\x87\xaf/\xdf|\
\xba\xff\xe4\xed\x93\x17\xefo=x\xf5\xeb\xf7\x9f\x1b\xf7^^\xbe\xf9\xec\xee\
\xa3\xd7\xe7\xae>>y\xf1\xc1\x91\xb3w\xf7\x9f\xbc\xfdL\xf4\xc2\x17\xa0~\xc6\
\x92 \xbf`\x06\x87g7\xd2@\x9c$ow\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x98\x81\
\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\
\xa9w?x\x06(\x94\xe3\xe9\xe2\x18"q9\xf6|$_\x83\x02\x0f\xcb\x05\xa5\x84\xc8\
\x90;\xad\xbf\xe3C\x16\x1e]\xf0\xf9gZ\x06S\xc3\x0f\x16\x06\x97p\xe5\xa9\x17X\
\x7fI\xa5,\x90\xe8^\xc7\xc4?\'_\xec\x18\xdfc\x93\xbf\xf9-\xbb\x0c\xcc\xbe\
\x17GH\x84\xc9\xe5X\x1f\xd4\x12]\xf4\xf9\xf8\xb6\xf9,\x9f\xf6\x16\n\xaeX\xae\
\xf7W\x94\xf3\xc2G\x05\xb5\xa6?{\xbet\x1e4\x9f\xaf\xbb\xe0\xf6\x01\xdeI\xcfY\
\xaf>\x97P\x9e\r\xb4W\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\
\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\
\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\
\xc8\x02\xa2\xe1\x11\xdf\xd3w@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\xcf\x91\
\xbc\x80' )

addArtData('wxART_JUSTIFY_FILL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\xf5\x0b\xf0\tq\xfd\xff\
\xff\xff\xe4E\xdb\x81\xe4\xd7o??|\xfaf\xe8\x9e\t\x94y\xfd\xee\xcb\xdf\xbf\
\x7f\x7f\xfc\xfc\xfd\xec\xd5\xc7\x87\xcf\xde}\xfe\xf2\xe3\xdd\x87\xaf/\xdf|\
\xba\xff\xe4\xed\x93\x17\xefo=xu\xf9\xe6\xb3_\xbf\xff\xdc}\xf4\xfa\xc6\xbd\
\x97\xe7\xae>>y\xf1\xc1\x91\xb3w\xf7\x9f\xbc\xbd[So\x13P?cI\x90_0\x83\xc3\
\xb3\x1bi N\x92\xb7\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\
\x0c\xc2\x8c\x0c\xb3\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0q)\xc9\xd4\xbb\x1f<\
\x03\x14J\xf5tq\x0c\x91\xb8\x1c\xdb\xef)\xd6\xa0\xc0s\xb4\xab\x815\xb0 \xec]\
}\xe0RQ\xb9I\xa9u\xbb4\x1a~02,:\xed\xa1j\xd2i\xd7<?\xa1\xe7\xe8B\xdd\x98P\tk\
\xbf{\xdb]O\xb4n\xcc\x9c\x7f\xf8\x92\x98v\xb7\xaf\xd6\x91\x83o\x8fWm\x9a\xb0\
tG\xc4\x8a\xf2e\x7fwE&h*u\x97\xf8U\xffiY=Oua\xf6\x03\xc6\x86\x89\xacK\xfc\
\xafN:\x04\xb4P\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\
\x98\xe8\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\
\x86\xa2!7?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x02\
\xa2\xe1\x11\xdf\xd3w@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\x1d@\xb8\xab" )

addArtData('wxART_JUSTIFY_LEFT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xf5\x0b\xf0\tq\xfd\xff\
\xff\xff\xe4E\xdb\x81\xe4\xd7o??|\xfaf\xe8\x9e\t\x94y\xfd\xee\xcb\xdf\xbf\
\x7f\x7f\xfc\xfc\xfd\xec\xd5\xc7\xcf_~<|\xf6\xee\xdd\x87\xaf/\xdf|\xba\xff\
\xe4\xed\x93\x17\xefo=xu\xf7\xd1\xeb\x1b\xf7^^\xbe\xf9\xec\xd7\xef?\xe7\xae>\
>y\xf1\xc1\x91\xb3w\xf7\x9f\xbc}\xea\xac\xc7v\xa0~\xc6\x92 \xbf`\x06\x87g7\
\xd2@\x9c$ow\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\
\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\xa9w?x\x06(\x94\
\xed\xe9\xe2\x18"q9\xb6\xff\xb6P\x83\x02\x07\xab\xa1\xe9\x11\x9d\xdd\xd3\xff\
\xff_\xbc4c\xf1\\\xf32\xfe3\x0c\n\xb3\x18\x1a^x-\x11\xb2j\xdc\xc7b\xfc@\xc2\
\xe9\xb6I\xc6\x86uY\x12R\xc72\x7f\xdd\xff\xb04Q\xe3\xd7M}\xdf\xc3ko\x9f{0\
\x81\xeb\xe2\xb1\x9f)\n\xfb\xa5\xc5\x99\xbf\xbez\xb2~6\xe3\xa6\xba\xe7\x07\
\x14\xd6\xa9\xcb\x1b\x15\\\xdd\xcc\xf9\xc2\xea\x03\xc3\x92\xa9lLM\xc7\x19\
\xe2\x80\xd6\xaa\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\
\x13]#\xa3\x10Cs+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\xe4\xe6\xa7d\xa6U\
B5X\xe8\x1a\x9a\x84\x18\x1aX\x19\x9bX\x19Y@4<\xe2{\xfa\x0e\xa8\x81\xc1\xd3\
\xd5\xcfe\x9dSB\x13\x00\xe4^\xbd\x13' )

addArtData('wxART_JUSTIFY_RIGHT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\xf5\x0b\xf0\tq\xfd\xff\
\xff\xff\xe4E\xdb\x81\xe4\xd7o??|\xfaf\xe8\x9e\t\x94y\xfd\xee\xcb\xdf\xbf\
\x7f\x7f\xfc\xfc\xfd\xec\xd5\xc7\x87\xcf\xde}\xfe\xf2\xe3\xdd\x87\xaf/\xdf|\
\xba\xff\xe4\xed\x93\x17\xefo=x\xf5\xeb\xf7\x9f\xcb7\x9f\xdd}\xf4\xfa\xc6\
\xbd\x97\xe7\xae>>y\xf1\xc1\x91\xb3w\xf7\x9f\xbc\x1dr4J\x03\xa8\x9f\xb1$\xc8\
/\x98\xc1\xe1\xd9\x8d4\x10'\xc9\xdb\xdd\x85\xa1\x83U\xd6\x03\xc8\xe1,\xf0\
\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94d\
\xea\xdd\x0f\x9e\x01\ne{\xba8\x86H\\\x8e=\x1f\xc9\xd7\xa0\xc0\xc3rA)!2D$\xfc\
]}\xe0T\xb1\xa6s\xcfg/\xe4dx$\xcc \x10\xdb\x19\xe2\x94\xfe\xc2{Bc\x92\xce.\
\xae=\x1f\xce\x1e\xba\x918g\xd9\xff\xde\x00\xb1c\xfb\xfe\xca\x88\xb5iTn\x14r\
Y)0\xf7\xfe\xb7\xaf\n\x13\xbe\x1e\xf3\\0\xcf\xea\xfbs\xd7\x86s\x1f\x95\x04\
\xf7\x9c/\x9e/Q\xf3\xf9&\xcf.\xde;\x8d\x0fX7(s\xef\xbc\x00\xb4V\xb5\xc45\xa2\
$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\
\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\
\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\xc8\x02\xa2\xe1\x11\xdf\xd3w@\r\x0c\
\x9e\xae~.\xeb\x9c\x12\x9a\x00\x90\xe1\xbc\xb4" )

addArtData('wxART_LAYER_ASSIGN', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4Wx\xba8\x86X\xf4\
\x1e\x9d\xf4\x90\xab\xc1\x80\xa3\xc5\xde\xfd\xbdmu\xd1\xef\x8b-\xaeQ\xd1\xac\
\x9c\xec\xcc\xe5\xcf\xe7\xce\xe6x\xef\xe5\xa0\x9b\xf7b\xc2\xb63\x16+\x12v\
\xf9O\xe5b\xdbp\xa3\x8597b\xbeU\xc7\xaa\x1f\x8a\xc5\x97\xc2Y\x8b_\xab7^\\:\
\xd7K\xcaA\xd7\xea\xbeb\xa9\x80\xeb\xae\x9e\x07-\xf3,6M\xff :\x07HN2U\xdaT*h\
\xe3\xa71\xc1\xf7Z\xdb\xe1\xbb\xe7\xed.\xe53I\xefR\xd6\x91\xfa;w\x95\x19\xd0\
\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\x90\xedD\xf4' )

addArtData('wxART_LAYER_CLEAR', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4O\xf5tq\x0c\xb1\xe8\
]:)\x92\x8bE\x91\xc7%\xde\xb46\x7f\xee\xec'\xcbL\xe5\x17;ws{\x89\xb7\xb8\x9c\
\x89\xea<b\x1d\xa3\xffx\xa7\x90E#\xe3\x9d\x1b\x95+\xff\x9fx\xc0\x13\xb6Q\xf3\
\x9b\x8f\xc2\xf6\xff\xbbeJ\xa62N\xbcZ\xf0A&\xfd\x89M\x95\xfc\xc4\x88\xe6Y)\
\xab+\xe7\x0b\t.+`\xb1P\xbaS\x18p\xfb\x7f\xc8>.\x1bI\xee\x07\xf7r\xef\xbf+\
\xf6\xb8u\xfb\xd0\xaa\xe6g\x13\x84*\x9e\xac1\nz\xbb(\xcbq\xf7\xb1\x98',\xec\
\xed-\xb9\xca\x9d\xab\xbe.N\xb4w\x0c\xff\xabr\x90'\xbe\xea\x94\xc7\xc5\xa6\
\xf6\xc7\x9e@\x072x\xba\xfa\xb9\xacsJh\x02\x00\xf6:V\x16" )

addArtData('wxART_LAYER_COPY_FROM', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4O\xf0tq\x0c\xb1\xe8\
=:)\x90\xafYA\xc0\xe5~A\xe0^\xce/*K\xc5K\x7f\x05\xaav\x98\x04\xfd}\xa1\xa6"=\
I\xf6\x19\xafv\xe1\xfaCg+\x9dX\xdc\r\x1aV\xd7-\xe1\xb9g\xe9\xf1ZRV\xcc#\xdc\
\xf8\x06K\x19_\x12\xfb\xc1%\xcc\x97\x8c\xd3\xb9Y\x9a\x15\xb7)]\xb6\x99\xfeO\
\xdb\xe9}\xea\xc4-!|\xce\xb3\x0f\xa6\xfd\xdfxku\xab\x8bV\xf9i\xf5\xbf\x85-U\
\x12\x0f\xa6~\xb6<\x1495~\xc5\xe4\xfe\x84\xff\x1b<.(\xa8\x1c\x13\xf7Th\xd6W.\
\x91\xfd\xe3\xfa\x80W\x94\xd98\xf3\xd7\xaa\x1cm\xa0\xdb\x18<]\xfd\\\xd69%4\
\x01\x00\xb9\x19M`' )

addArtData('wxART_LAYER_COPY_TO', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4O\xf0tq\x0c\xb1\xe8\
]:9\x96\xef\xb0\x02O\xb3\xfd\xf3E\xaf}\x13\xd4%wgl\x9e\xbet\xd1\x14\xaf\x9c\
\x8dG\xbc\x9fX\x9c\xe3\x17\xb2\x8c0\x92/\xfe\x10Z\xc4\xc8_\xc7\xa8\xff@\xed\
\xc2*\x8f\xbf\xfb\xe4\x84\x1e<h\xda\x7f,\x91\x81io\xd4\xee\x1d\x05\xaf4\xc5\
\xb6\xe931\xf4\xe7\xce\x0e\x93pu\xf38po\xa5T\xc64\x95W[\\]K\xd8\xb7\'\xf2)\
\x8a\x9cL\xfc\x7f\xf3c\x9f\xd8\xbd\xb5gu\xef\x85\xd8Yz\xe4\'\x8a\xde\xcb}h\
\xb1$~Ux\x1e\x9ff\xf3\x9f\xf4S\\5\x0c\x02I\xc6\x99\x8c\xd2n"@\xb71x\xba\xfa\
\xb9\xacsJh\x02\x00\x90_M\x0e' )

addArtData('wxART_LAYER_EDIT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe47{\xba8\x86X\xf4\
\xae\r\x8a\xe6:`\xc0\xd1\x9d\xfc\xfd\xda\xbc;\xb5[\xca\x1e-\xe1\xb7Z(\xe0\
\xb2x\xa3\xe2\xa1\xc8\x98\xf6\xbf\xfa\x8c\xcc\xab\x1a\xa4\x9e\xb1\xac>,\xcf\
\x94\x99/\x12\xc9\xfb\xb7\x8c\xd9\xef\x1a3\x83\xd8\xc5\xc0\xb3\x97\x04M\x15\
\xb7\xed\xe0\x15IX\xe1\xc6x6k\x99P\xda\xec\x9c\xdf\n\x93t\xbc;T\xae\xbc\xd2\
\x9f\x7f\xe6\x8cp\xf3\xab\xeb\xdf\x13O\xbbmZ\xa6\xb1PX\xe4x\x0c\xc3\xa7I:\
\xfaA\xee\x15\xf99\xd6\x17\xcd\x0c.%k\xdb\x07\xbf7\xe7d)\xdb\xea\x0bt\x0e\
\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00K\xf6G|' )

addArtData('wxART_LAYER_EXCHANGE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xcf\xf6tq\x0c\xb1\
\xe8=:\xc9\x9b\x8fY\x91\xc7y\xfe\xf3G\x17&O\x89\xdb\xf2\x8ei\x06S\xb0\xc0%\
\x1d)M\xa6\xa7\xc9oX:\xab\xcb\xee\xbcy\xce\xf1\x80\x81\xad\xa0\xf8\xbea\xb35\
\xdb\xc6\x1f[\r\xe2\x1cx\xc5<\xac\x8dW0(\xbd\x92>\xcd \xdb\x1c\xe7W\xf2U\xf0\
\xc5\xccI\xacL/$\xae<s\xf7<'\xb1g\xf3\xb7\x98\xc5\xad\xce%\xd5\xab\x02\xd6\
\xeb\xb5\x99\xf6\te\xed\xb9\x1a\x17\x9fw\xee\xe7\x85\xb4\xcd\x15KK\xae\xf9m\
\xff\x90\xfd\xa9v_\xce\xc2\xa5\xb2]\xdbB\x1fg\x9c\xee\xdf\xc2$x\xe2\xc1\xda\
\xfe-g\x1f\xe83\xc8+\xdb\x858Nb\xdcV\x0ft&\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00\
\xa4\x15W\x89" )

addArtData('wxART_LAYER_VIEW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4{{\xba8\x86X\xf4&\
\xa7\xa4,\xe01\x08\\!\x9f\xe8`\xcb|\xf8\xff\x7f\x1e\x9e\xff\x89o\xaat\xde\
\xfc\xf7\xc8\xe1a\x96Z !\x7f`Y\xdb\xc4\xac\xc4\x80\xfe\xa3\x95/\x18fKu1\x17^\
\xe1\xf6\xd0\xfb\xd1\xaf\xfcq\xc1\xe6\xff\xfc\xf7ZL\x12\x80v(\xce\xd1\xfcxq\
\xaa\xa5+\xd0X\x06OW?\x97uN\tM\x00um.\xfa' )

addArtData('wxART_LOCK_CLOSED', 'wxART_OTHER_C', 16,
b'x\xda\x01\xea\x01\x15\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\
\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\
\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x01\x9cIDAT8\x8d\
\x9d\x92\xc1j\x13Q\x14\x86\xbf;wpJ2\x99E\x03n\\\x08\x127\xdaE,\xd2\xe2@\x92R\
\xf0!\\\xc4\xb5\xf4-\xec\x13X\xb0\xabl\xc47\x10\x97.$\x08i\xa6\x05!\x0b\x9bm\
;$5\x83\xd0N\x166\x84\xdc\xb9\xc7M\xa7\xa4\xa9B\xe3\x0fg\xf3\xc1\xffq8\xf7b\
\x8c\xc1Z\x8b\x88\xf0\xfb\xf2\x92\xf7\xfb\xfbM\xdf\xf7?\x96J\xa5\x0f\xadV\
\xebU\x9a\xa6L\xa7SD\xe4\xc6\xe4\x9cyAtx\xf84\x0c\xc3\x08\x10@j\xf5z\xe7\xa0\
\xdb}\xbcX\x9e\x1ff\xb3\x19"\xc2p8|\x84R\x02\xc8\x93\xb5\xb5\xcf\xd5\xf5\xf5\
O\x808ZK\x92$\x0f\xfe)\xe8\xf7\xfb\x8c\x92\x84\xcd0<\x02\xa4\x1bE/\xdf\xee\
\xee\xf2no\x8f8\x8e_\x00Rk4\xda"B\xce\xe7\x05\x0eJqzr\xb2\x12u:\xcf\xb7\xb6\
\xb7\xbfonl|)\x16\x8b\xfc8>F)uPk4\xbe~k\xb7\xeb\x009\x1f\x0c\x06\xe4q\xd2\
\x8b\x0b\n\xbe/\x00A\x10\xfc\x02x\xddl\x92e\x19ovv8\x8d\xe3\xd8q]\x16\xf9\
\xb5 \x19\x8d\xee\xfd<;\xf3\x01\xc6\xe3q!MSU.\x97yV\xad\x12\x04\x01\xae\xeb\
\xde\xd7Z\x030\xcf\xf3(\x11\xc1q\x1c\xe1\x0e\xe9\xf5z\x0f+\x95J|\xf5\x84\xab\
Y\x96\x15\xdc\xbb\x14\xf3\x18c\x02\xad5\x9e\xe7\xe1y\xde\xb9\xb5\xf6|)\x81R\
\xca\x18c\x98L&(\xa5\xb0\xd6\xb2\x94\xe0Jr\xfd\xf1\xb4\xd68\xcb\n\x16\xf3\
\xdf\x82|\x93\xa5\x04\xd6Z\xbd\xc8\x96\xba\x81\xe7y\x13\x11A)uK\xa0\xfe^\xb9\
%X5\xc6\xdc`\x7f\x00\'l\x02\x13\xc2}\xe6\x96\x00\x00\x00\x00IEND\xaeB`\x82\
\x0c\xe9\xd5\xbc' )

addArtData('wxART_LOCK_OPEN', 'wxART_OTHER_C', 16,
b'x\xda\x01/\x02\xd0\xfd\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\x00\
\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x01\xe1IDAT8\x8d\x9d\
\x93\xc1k\x13A\x18\xc5\xdf\xcc,;i\xb2\xbb\xc1\x04<I\x04\t\x1e4\x85\n\x92U\
\x82Vz\xf0\xe8\xa1\xd8\x82\x87x\x96\xe2\x9fcO{\x91\x96\x14\xbc\xf5\xe0%\xf4 \
m!\x1a\x10!v\xd3\x83^\xba9l+\xd6vCc\x93\xc0\xec|^\x9aB\xb2E\x8c\x0f\xe6\xf2\
\xe0\xfb\xf1\xf1\xbe7 "x\x9e\x87Z\xad\x06\xcf\xf3\x10\x04\x01\x88\x08J)h\xad\
AD\xf8}~\x8e7\xab\xabU\xcb\xb2\xd6l\xdb~\xeby\xde\x8b(\x8a0\x1c\x0ea`B\x9c\
\xf3I\x0b\xbe\xef\xdf\xdd\xa8\xd5^\xf7z\xbd2\x00\xac\xad\xaf\xdf.\xcd\xce~~\
\xe0\xba\xdf\xc7\x00q\x1cc0\x18\x00\x00\x88\x08\x8c1\x84ax\xcbu]\x1fD\xb8S*\
\xbd7MS\xef\xee\xec<\xabT*\xdf\x0e\xc3\xf0\xc6%\x801\x06)%\xfcv\x1b\x00\xa0\
\x94\xc2\xb5\\\x0e\x8bKK\xef@\x84O\xcd\xe6\xd3z\xbd\xbe\x95\xcdf\xb1\xb8\xb9\
\xf9\xb0P(4\x9e//o\x8c\xed\x9bJ\xa5\xf0\xeb\xf8\x18_\xf7\xf6\x00\xc6\x10\x1c\
\x1c\xa4\x9a\x8d\xc6\xfd\'\x0b\x0b_\xdcry+\x93\xc9\xa0\xbd\xbf\x0f\xc6\xd8\
\xc7G\xf3\xf3\x1fv\xb7\xb7\x1fs\x00\x10B@\x08\x01\xce9l\xdbF\xef\xec\x0c\xd1\
\xe9)\xd2\x96E\x00\xe08\xceO\x00xY\xad"\x8ec\xbcZYA\xd0\xe9t\xb8a\x80_\x04g\
\x8e\x9e\x10\xc2L\xcf\xcc\x98?\x8e\x8e\xcc\xc30\xb4\x00\xa0\xdb\xed\xa6\xa3(\
b\xf9|\x1e\xf7\xe6\xe6\xe08\x0e\x0c\xc3\xb8.\x84\x00#"p\xce)\x11\xfd\x15j\
\xb5Z7\x8b\xc5b\xe7\xe2\x84\xb98\x8e\xd3\x893\xfeMJ)G\x08\x01)%\xa4\x94\'Z\
\xeb\x93\xa9\x00\x8c1\xa5\x94B\xbf\xdf\x07c\x0cZ\xebd\x91\xfe\x01r\xd9P!\x04\
\x92\xb5\x9bR\xff\r\x18m2\x15@k-&\xbd\xa92\x90R\xf6G\x7fd\x12\xc0\xae\x1eI\
\x00rJ\xa91\xef\x0f\xad\'\xc7\x06\x88\xc1\xee\xf2\x00\x00\x00\x00IEND\xaeB`\
\x82B\x0b\xf6N' )

addArtData('wxART_LOG', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100r\x04\xf8\x84\xb8\xfe\xff\
\xff\xff\xf6\x9d\xbbEM+\xfa\xfb\xfb\x93\x93\xd3&\xad8q\xfe\xde\xdb\xd8\xac\
\x99Sg\xcc*\xaeYt\xfe\xee\xabc\xbb2\xcel\xb3>un_cc\xe3\x84\xe5\'N\x1c_~n\x97\
\xf6\x85\xc3\xe6G\xb6%\x9d\xbf\xfb\xb2w\xe9\xb1\x99\x9b\xce\xed\\\x1b~\xe5\
\x84\xa5\xb7\xa7\xc4\x95\x83\x16\xf3\xd7\xaf\x9b\xbd\xe5|\xd7\xc2#\xe7\xef\
\xbc>s\xf5\xd2\xbd\xa3\xc6\xafn\x98\xf74*~\xb8np|\x7f\xed\xf9\xbbo\xda\xe7\
\x1d\\\xbe\xaa\xe0\xe9\x19\xf9\xab\x87\x943S\x85\xde\x9cS\xdf\xb7D\xad\xb2\
\xb2\xb2i\xd6\xbeS\xc7\x0f\x1fZ\xdc\xbcoN\xcd\xde\xd9%\x07w\xe6\x1f\xd9\xd7Y\
7}w\xcf\xf2c\x13fo_\x98R\xb9"(evBY\xef\x82}U\x93w\x1c,\xad\xb9\xda\xd6v37\
\xf7Jy\xf9\xe6\x84\xb4\xb2\xfe\xad\xf5\xb3\xf7\xad\xb7\xb0\xbdYY\xf9\xe3\xfe\
\xfd\xab\xf5u\x0b\xe5\x14\x8b\xbb7\xed\x88\x88\xbd\xd9\xd8x\xa5\xbd\xfd|U\
\xd5*G\xd7\x82\xce\r\xa5\x93\xb67TM\x9fg\xe3\xbaR\\b\x96\xbeEMAwn\xdb:` \x18\
\xbe\x9e\xa2\x01\x0c?\xc6\x92 \xbf`\x06\x87g7\xd2@\x9c$ow\x17\x86\x0eVY\x0f \
\x87\xb3\xc0#\xb2\x98\x81\x81\xef0\x083\x1e\xcf_\x91\x02\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$S\xef~\xf0\x0cPh\xb9\xa7\x8bc\x88\xc4\xe5\xd4\xf3W\xf9\x98\
\x0c\x05X/\xe8\xe9l\xde\x11|\xe7nm\xa1\xee:``\x07GL3\x9bPp\xff\xd9\xb3\x14\
\xb5f\x01!\x13{\xc7SkDK\x0f(k\xb6\xc6\x19\xec\xe1^|2\xe7\xa7HS\xe8\x16\xcd\
\xd6\xbb\x0fKv\xee\xfc\x90\xd0\xb3\xd7\xae^A"II\xa61Cg\x9e\xc7\xb2K>)\x06\
\xe7\x9e}jM\xe2\\\xbdH\'\x8ca\xd5\xd6\xaa\xc57\x93\x9c\xb2N\xcf\xcd[o?!u\xe6\
[\x89C\x1963\xcf1\xec\x981\xf9h\xd1\xd6{\x02N3n\x1c\xca\xab\xb7\x98\xb7\xef\
\x91\x8f\xfe\xf5\xdb\x7f\x1d5S\xc3\xe7\xfd\x11\rUP\xf9\xcb\xf2\xf7)\xab\x9b\
\x9bH\xe8\xc5\x16\xb5\xcd@\'\xab\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\
\x06#\x03Cs]\x03\x13]#\xa3\x10Cs+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\
\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\x84\x18\x1aX\x19\x9bX\x19Y@4<\xe2{\xfa\x0e\
\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\xea\x967\xc3' )

addArtData('wxART_MACRO', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\x8d\r\xf0\tq\xfd\xff\xff\
\xff\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\x7fy\
\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x9f<\xf9\xd3\xdby2.jWR\
\xe4\xc6\xfc\xec\xdd\xaf_\xff\xde\xb6\xf5qX\xd0\x9aU\xab\xeex\xb9N\x991\xe3b\
L\xd0\x8e+7\xde.]\xf8\xd0\xdfu\xe5\x93\xa7\x1f\x0e\xee\xbf]Ws\x02h\xf2/\x7f\
\xebs@\x8b\x18K\x82\xfc\x82\x19\x1c\x9e\xddH\x03q\x92\xbc\xdd]\x18:Xe=\x80\
\x1c\xce\x02\x8f\xc8b\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\xe9\xeb\xca\xfe\
\x90\x83\x8fKI\xa6\xde\xfd\xe0\x19\xa0P\x81\xa7\x8bc\x88\xc4\xe5\xd0\xbeH\
\xa1\x16\x03\x0e\x97\xc5\x9c=L\x9d\xa7_\xacX\xf1}\xff2\xd1\xd3\x9a\x9e\xf5\
\x07\xb3\xa7\x95\xe9\xad^\xf5\xfa\x94\xe4O\x06\t;V\xc6\x8c\xa8M-\x0c\xd2\xdb\
\x8e\x08w\x14lq\xf7\xb0(]\xc6\xbe\xe4\xc8\xdf\xdb\xd52*[.\xfe\x88cZ~I~\xff\
\x7f\xd6=\x7f3\xeb\xe2S\xfeo\xbf!\xb0)o\xf3\xad9\xa7\xac\xd6\xd6:\x96\xd8w\t\
\x8a\x7f\xadY\xc5\xfd\xf6\x07\xcb\x8c\xf2=\xc7\xfe\x02\xedV-q\x8d(II,I\xb5J.\
J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\
\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb12\xb2\
\x80hx\xc4\xf7\xf4\x1dP\x03\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00\xbc]\xc1H" )

addArtData('wxART_MACRO_DELETE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaaM\x0e\xf0\tq\xfd\xff\xff\
?CC\xc3\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\x7fy\
\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x9f<\xf9\xd3\xdby2.jWR\
\xe4\xc6\xfc\xec\xdd\xaf_\xff\x06\x9a\xf4\xc3\x80a\xdb\xd6\xc7aAkf\xcc\xb8\
\x18\x13\xb4\xe3\x82\x16\xc3\x95\x1bo\x97.|\xe8\xe5:\xc5\xdfu\xe5\xaaUw\xeaj\
N\x00\xcd\xffU$|\x1bh\x1dSI\x90\x1f\xd0\xc9e\x93\xcfZ\x00y\x8cI\xde\xee.\x0c\
\x1d\xac\xb2\x1e@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4u\
e\x7f\xc8\xc1\xc7\xa5$S\xef~\xf0\x0cP\xa8\xc7\xd3\xc51D\xe2\xb2o\xdf[1&E\x0e\
\x97\xd4\xf0\x8d\xb1\xaa\xda/\x0e\x9f\xaa\xfa\xbf\x9d\xc7\xdc\xf8\xa7q;7s2O\
\x86\xefg\x9bP\xd6\xc5K\x93d\xab\xb6K3D\x1cI\xe5enh\xa8\xebLd0S\x08\xbc\xf3_\
\x97\x8f\xf9h\x89D\xdf"~M9\xe9\x0b\xf7~\t\xef\xdc\x1a\xb9\xcdrr7\xe7\x92\xa6\
\xf71?j\x18\x1f\xf2V|\x996g\xc3\xb7\xb3A\x7f\xaf\xcfN\xf9\xf7tCI\xbdM\xf7\
\x93;\xcdS#\xe2v\x9d\xbf\xd4<U)\xc6\xc1\xb3_\xef\xcf\xbaE\xf1v\xfb\x15\xd8\
\xce\xec\x13+U\x06\xbaK\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\
\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\
\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\xd7\xd0$\xc4\xd0\xc0\xca\xd8\xc4\xca\
\xc8\x02\xa2\xe1\x11\xdf\xd3w@\r\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x00\x0f\x95\
\xc8\xe9' )

addArtData('wxART_MACRO_EDIT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd56\x06\xf8\x84\xb8\
\xfe\xff\xff\xff\x87\x01\xc3\xba5_\xe6\xcc~0\x8b\x81\xe1oWnv\xda\xa1\x1b7~\
\xfe\xfb\xf7\xff\xcb\x97\xff\xe5%\xb7f\xf4\x94\xaf\xd9u\xe9\xc4\x0c\x86\xf7\
\xef\xff\x9d8\xf6\xdc\xdfs}CC\xc3\xfd}^\xdf\x9eL\xd9\xb5\xf3\xa9\x8c\x8c\xcc\
\x93'\x7fz;O\xc6E\xedJ\x8a\xdc\x98\x9f\xbd{\xc6\xdc\xc5\xaf_\xff\xfe\xf1\xeb\
\xcf\xb6\xad\x8f\xc3\x82\xd6\xacZu\xc7\xcbu\xca\x8c\x19\x17c\x82v\\\xb9\xf1v\
\xe9\xc2\x87\xfe\xae+\x9f<\xfdpp\xff\xed\xba\x9a\x13@\xdb\x03\xbc\x92\x96\
\x02\x1d\xc3X\x12\xe4\x17\xcc\xe0\xf0\xecF\x1a\x88\x93\xe4\xed\xee\xc2\xd0\
\xc1*\xeb\x01\xe4p\x16xD\x1630p\x0b\x830#\xc3\xac9\x12@A\xf6\x12O_W\xf6\x87\
\x1c|\\J2\xf5\xee\x07\xcf\x00\x85&z\xba8\x86H\\\x0e=\xfbP\xacI\x81\x87\xf5\
\xc1B\xb6\xc5N+\x19<\xb5\xb7\xf6\xbc\xfa\x1b\xbfAU\xb5\xf2\xff\x9b7\xd6\xe5\
\xe9\x0c=\x8c\xaa\xa7?\xf3,\x13\xc9q=\xc4\xea\xb5\xb1/ g[\x17\xcb\xc65%S\xee\
\xfesX\x148M\xad+T\xfe\xa1\xd4\\\xe3R\xa1\xc6[\x92\xf5-*\x1a[\xcdy\xcf,\xba5\
Y8\xd4f\xe1\xf2\xb0\xb9\xd1\xea=\xff\xdfv\\\x8b*|\xb9\x8f=f\xd1\x92:{\x863N\
\xbf\xbf\xb2i\xde\xe9\xfd\xae\xf8\x87\x91E\xf8\xd7\xc6H\x8f\n\x1bq\xd1\x15\
\x87\xb3g\xe5\xb7\xfc\xe1L\xdd\xdb\xe3\xc3\x01t\x9cj\x89kDIJbI\xaaUrQ*\x90b0\
204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\
\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x91\x05D\xc3#\xbe\xa7\xef\x80\x1a\
\x18<]\xfd\\\xd69%4\x01\x00\x1fV\xdfx" )

addArtData('wxART_MACRO_NEW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xc6\x06\xf8\x84\xb8\
\xfe\xff\xff\x7f\xdd\x9a/sf?\xc8N;t\xe3\xc6\xcf\x7f\xff\xfe\x7f\xf9\xf2\xbf\
\xbc\xe4\xd6\x1f{\xc6\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\x93\'\x7f\xe2\xa2v\
\xed\xda\xf94?{\xf7\xeb\xd7\xbf{;On\xdb\xfa8,h\xcd\xaaUw\xbc\\\xa7\xcc\x98q1\
&h\xc7\x95\x1bo\x97.|\xe8\xef\xba\xf2\xc9\xd3\x0f\x07\xf7\xdf\xae\xab9\x014y\
\xfa\x9d\xdd\xef\x80\x161\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\
\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\
\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92,\x87\xc3\xc7(\xa0P\xa9\xa7\x8bc\x88\
\xc4\xe5\xd0\xfe@\xa1f\x03\x0e\x97@g\x17\xc5\xc0\xe8\\\xdd[\xbf\xe37w&O=\xc0\
\x9f\x9f~\x93\xb1!&46<aU\xe1\x8bX\xef\t\xbfC\x04v\xcf\xeb|\xf1\xc9\xe0\x97\
\xde\xc3\xb5&=J\xc7&:Eh\xc4Hv^,\xee`\x96\x90;\xfa5\xf8\xa4\xe1\x94?\x15\xff\
\xc4\xff\x1c\xfc\\t\x7f\xe6\xcf\xaf\xdb\xa6\x9f\xfe\x15y\xe5\xdf\xa2\xc0\xe7\
\xa5\x1a"w\xbf\x1db\x9a\\w\xfe%\xbb\xf9%V\xc6\xc7\x93\x83y\x80\x0eP-q\x8d(II\
,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\
\x06FV\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\
\xb12\x82jp\xa9|\x07\xf2"\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00\xa6\xeb\xc2\xe6'\
 )

addArtData('wxART_MACRO_OPEN', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaam\x0f\xf0\tqehh\xf8\xff\
\xff\xff\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\x7f\
y\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x9f<\xf9\xd3\xdby2.jWR\
\xe4\xc6\xfc\xec\xddgf\x18\xbf~\xfd\xfb\xc7\xd7)\xdb\xb6>\x0e\x0bZ\xf3\xe3C\
\xcf\xf7\xd7\xcd\xdf\x9eU}{X\xb4\xa4\xc8x\xd5\xaa;^\xaeSb\x82v\xfc\xbc\x9b\
\xfe\xedJ\xe4\x87S\x9eo\x0e\xda\xf8\xbb\xae\xfcy3\xf1\xf3\xf9\xc0w\xc7\\^\
\xed1\xb9r\xe3\xed\x93\xa7\x1f\x0e\xee\xbf]Ws\x02\xe8\x00\x8d\xe79\xdb\x81Nb\
*\t\xf2\x03z\xabl\xf2Y\x0b \x8f1\xc9\xdb\xdd\x85\xf1?\x93\xee= \x87\xb3\xc0#\
\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\
\xe0\xe3R\x92\xe5p\xf8\x18\x05\x14\x9a\xe2\xe9\xe2\x18"q\xd9\xb7\xff\xb6P\
\x93\x01\x8f\x8b\xb2\xc9\xca\x0bb*\xd7\xb2\x03\xafT}\xff\xff\xff|\xd2\x8c\
\x8d\xbf\'\xdd\x9c\x9c\xa3\xc6( \x9a\x1a\xd9SjV\xd9\xba\xa4p\x1ec\x80Kh\xae\
\x11C[I\xaa/\xdb\x14\xc5\xe79\x9f\xfb\x15$\xd3o\xbbn\x9b\xb2%3w:\x83q\x7f\
\xdc\xcb\xa5\x87\xad\\oT\x9fO\x8e\xb7\xdc\xa2\xcb\xf1!\xb3Kv\xdd5\x83\xc6\
\xb3e\xdb\xf9o\xc8;0t\x1f\n\xf4K\x97\x9b\xe4\xf7\xdc\xbbC\xd8\xe3[\xd5n{\xa7\
\xffoXX\x02k\xf6&\xff\x931\xf9\xf8\xb9\xbb\x86qJ3\x17\xff\x9a%W?\x03\xdd\xa7\
Z\xe2\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\
\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\
\x99V\t\xd5`\xa1kh\x12bh`elbe\x04\xd5\xe0R\xf9\x0e\x14\x02\x0c\x9e\xae~.\xeb\
\x9c\x12\x9a\x00\x07\x87\xe9\xdd' )

addArtData('wxART_MACRO_RECORD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\x9d\x19\xe0\x13\xe2\xfa\
\xff\xff\x7f\x86\x86\x86uk\xbe\xcc\x99\xfd ;\xed\xd0\x8d\x1b?\xff\xfd\xfb\
\xff\xe5\xcb\xff\xf2\x92[\xef\xdf\xff;q\xec\xb9\xbf\xe7\xfa];\x9f>y\xf2\xa7\
\xb7\xf3d\\\xd4\xae\xa4\xc8\x8d\xf9\xd9\xbb_\xbf\xfe\xbd,a\xfa\xad\xf3\xef\
\x9e**]\x97\x94\xac\r\x9e\xb9m\xeb\xe3\xb0\xa05/\x8c\x8c\xfe\x8b\x8a\xfe\x97\
\x97OO\xda\xbdj\xd5\x1d/\xd7)\xff\x95\x95\xff\xeb\xeb\xff73\xdb8}\xf9\x8c\
\x19\x17c\x82v\xfc\xb7\xb5\xfd\xef\xe11\xbb{\xc6\xd2\x85\x0f\xfd]W.\x90V[\
\xb0\xe0\xd8\x95\x1bo\xb7i\xa8?y\xfa\xe1\xe0\xfe\xdbu5\'\x80\xae\x12\x15\x0b\
v\x01:\x92\xa9$\xc8\x0f\xe8\xd1\xb2\xc9g-\x80<\xc6$ow\x17\x86\x0eVY\x0f \x87\
\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\
\xb2?\xe4\xe0\xe3R\x92\xe5p\xf8\x18\x05\x14Z\xe8\xe9\xe2\x18"q\xd9\xb7\xff\
\xb6P\x93\x01\x8fKtF\xd0B\xdd\x8e[\xab\x1a\x94*\x1c_\xff\xfd_\xef\xa71wc\xe5\
\xc9\')e\x9b\x15[vu=\xb2\x90\xb2V\x14Nh\x90Ic\\\xc0c\xe8\xe9\xca\xb0\xc2a\
\x9e\x87 \x83Z\x80\xe6\xcc\xbf\xaa\rN\'k\xe4f(\x89\xef\xd4\xb1\x91H;&\xce\
\x15\xa4\x1f\xb9\xae\xcd6X\xa18}U\xef\xc5\xd7\x85\xfbo\xee\xda\xbck\xcd\xab\
\xa0\xf7"ofk\xceX\xc9\x97\x9b\xdeW`\xf5\xfb\xc5\xb2<\xfd\xbd;\xefI\xbdn\xd4\
\xdb\xbdo\x97\xfd\x9b\x7f\x91?\xe2\xd9.\x8bo\xfd\xf6w\xe3\xc3b\x93\xcd\xf1\
\xea?\x19\x1b\x9b9\x7f\xed\x0f\xcb\xdb\x0ct\xacj\x89kDIJbI\xaaUrQ*\x90b0204\
\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\
\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x11T\x83K\xe5;Pp0x\xba\xfa\xb9\xacsJh\
\x02\x00\xf4W\xef\xf1' )

addArtData('wxART_MACRO_RUN', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa-\r\xf0\tqehh\xf8\xff\xff\
\xff\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\x7fy\
\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x19\x12\x18\x9e<\xf9\xd3\
\xdby2.jWR\xe4\xc6\t?\x12\xf2\xb3ww}\x89y\xfd\xfaw\xf93\xff\xe4\xebN\xfe'M-w\
\xaam\xdb\xfa8,h\xcd\xaaUw\xbc\\\xa7\xcc\x98q1&h\xc7\x95\x1bo\x97.|\xe8\xef\
\xba\xf2\xc9\xd3\x0f\x07\xf7\xdf\xae\xab9\x01\xb4\xce\x9d\xf9\xdbt\xa0\x03\
\x98J\x82\xfc\x80\x9e(\x9b|\xd6\x02\xc8cL\xf2vwa\xfc\xcf\xa4{\x0f\xc8\xe1,\
\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\
\x94d9\x1c>F\x01\x85\xa6z\xba8\x86H\\\xf6\xed\x7f-\xd4\xa4 \xd0\xea\x99\xe8\
\x998\xf1\x92\x89\xf7\xe5mU\xff\xc3{Xg&\xfe7xn]m\xc91q\xd5\xaa\xd7]\xf7//\\\
\xca\xb4\xf6\x1c\xab\x80\xd0\x82L_\xc6\x16\xc6\xbb\x11\xc2\x0c\xcf\xc4\x98\
\xcf\xdd\xd4c8\xe3\xdd\xb3\xf9\x9f\xd0\x01\xd1\xc9l\xb9{\xdeJ\xf2\x9c\x88z5;\
X\xb7\x9f\xe7q\xcb\x1b\xef\xe5k\x9e/}\\2\xdf\xf0W\xbf\xfa|\xd7k\x17\xe3\xafI\
\xf0l\xfe\x7f+\xa8d\xcea\xd1\x97\xdf\xbe{\xb1wX\x9e\xb8\xb4\xe9;\xe7\x92\x05\
.\xf3\xf5\xa7\xce\x17\x96\xfd\xfb\xe8\x84|\xecZ\x0eq\xee\xe7\x05\xa0\x08R-q\
\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06&\xbaFF!\x86\xe6V\x86&V\xc6\
\x96\xda\x06FV\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t1\
4\xb026\xb12\x82jp\xa9|\x07\n\x02\x06OW?\x97uN\tM\x00\xe8R\xdcG" )

addArtData('wxART_MACRO_RUNMULTI', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\xed\r\xf0\tqehh\xf8\xff\
\xff\xff\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\x7f\
y\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x19\x12\x18\x9e<\xf9\
\xd3\xdby\x92!\xd7(.jWR\xe4\xc6\t?\x12\xf8\x12$\xf3\xb3ww}\x89y\xfd\xfaw\xf9\
3\xff\xe4\xebN\xfe'M-w\xaam\xdb\xfa8,h\xcd\xbd{?W\xad\xba\xe3\xe5:\x859\x89y\
\xdd\xda'3f\\\x8c\t\xda\xc1\x97\xc1\x7f\xe5\xc6\xdb\xa5\x0b\x1f\xfa\xbb\xaed\
H\x15aH\x11x\xf2\xf4\xc3\xc1\xfd\xb7\xebjN\x00\x9d!\xf6\xeb\xe8\r\xa0\xc3\
\x98J\x82\xfc\x80\x9e+\x9b|\xd6\x02\xc8cL\xf2vwa\xfc\xcf\xa4{\x0f\xc8\xe1,\
\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\
\x94d9\x1c>F\x01\x85\x16z\xba8\x86H\\\xf6\xed\x8f\x14j2\xe0qP.\x11\xbc%\x12\
\xe8( Zpp\xc7\xdd\xffUj\x07\xd8\xe7V\xe6~J\xdb$\x92`\x15(\xe3\xfei\xdd\xb3\
\x98\xcc\xe4\xafU\x8a\x0e\x92\x93\x97\xe4)\x1e\x90\x9c]q\x9c\xc9Rp\x8a\xb1\
\xe2\x8f\x1e\xd6\xf4\x1d\x13\xd5\xf4~\xd4\x9cNj?\x13'\x9d\x1c\xfb\x8e[P\x95\
\xeb\x94\\\x93\xdf\xd2%k^\t\x8an9\xbf43T\xbe\x95\xed\xebK\x9d\xe4\xc0\xa4\
\x87\x97\xca\x1e'\x9d0\xbc\x1c\x9f\xff=\xb34\xa7\xc2\xeb\xb3\xc4<\xd9\xb3N\
\xdf*&./\xd3P;\xf8]\xba\xe1\xc5\xe7\xa5O\x9f+,\xbe\x1f\xf1\x89=i\x07\xd7\xe3\
\xcd\x87\xad\x8e\x03\x1d\xabZ\xe2\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\
\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\
\x82O?C\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\x12bh`elbe\x04\xd5\xe0R\xf9\
\x0e\x14\x1c\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x006<\xe8Z" )

addArtData('wxART_MACRO_SAVE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa=\x19\xe0\x13\xe2\xca\
\xd0\xd0\xf0\xff\xff\xffuk\xbe\xcc\x99\xfd ;\xed\xd0\x8d\x1b?\xff\xfd\xfb\
\xff\xe5\xcb\xff\xf2\x92[\xef\xdf\xff;q\xec\xb9\xbf\xe7\xfa];\x9f>y\xf2\xa7\
\xb7\xf3d\\\xd4\xae\xa4\xc8\x8d\xf9\xd9\xbby\xcb\x84_\xbf\xfe\x1d\xbd\xba\
\x00\xa8\xf7\xce\xf3;;\xcf\xefZqx\x85i\x9b#\x83,C\xc4\xf2\x9c/?\xbe\xdexzs\
\xeb\xd9ms\xf7\xcc\x03\xda\xb3m\xeb\xe3\xb0\xa05\xde\xb3c\x1e\xbcz\xb0\xf7\
\xd2\xdeY;gw\xae\xebT*\xd1Z\xb5\xea\x8e\x97\xeb\x14\xd7\xa9!\xf6\x13|MZ\x1c4\
*\r\x95\x8a\xb5ds\x95g\xcc\xb8\x18\x13\xb4C\xc0\x9eS<]f\xe9\xc2\x87\xfe\xae+\
-;\xdd\x8e\xdd<.\x98$r\xe5\xc6[\xe3f\xbb\x17\xef_\xec\xbb\xb4\x9f;\x9a\xf7\
\xc9\xd3\x0f\x07\xf7\xdf\x96\x89\xb2\xa8\xab9\x11\xc0\xeb<\x17h\x19SI\x90\
\x1f0`\xca&\x9f\xb5\x00\xf2\x18\x93\xbc\xdd]\x18\xff3\xe9\xde\x03r8\x0b<"\
\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\xaf+\xfbC\x0e>.%Y\x0e\
\x87\x8fQ@\xa1u\x9e.\x8e!\x12\x97}\xfb\x9e\x0b5\x19\x08\xb40/\xe1\xf0tH\xee\
\xe7\xdd\xadp-\xe3\xcd\xd7\xbf\xf2^\xb7z\xde\xcc\x9f\xfd;\xaf,\x9f\xf1DJ\xd4\
\xb4\x99>\xca\xf7\x15\x0f\xb1L\xe5bp\xe8\xc9m\x17cX0\xe3F\x8f\x18\xc3\x92\
\x19\xc5\xcf\xfe\xe9r\x04\x9f\xdbS\xa4("\xfcjc\x17\xa3\x8b\x9e\xc7*\x19\xcb\
\x8d\xaeW^\xf5\xa6\xad\xd6\xe5|\xd2QY\xb8\xe2EI\xf5\xdfF\xfd\xc7\xbf\x0b\xa6\
\xec\x11}|\xb2\xc4,\xde\xa3\xaf\xc9@Wm\xda\xc5\xac\xbd7\xbd\xb6\xdcN\xbf\xea\
\xba$I\xf6\x89\xe1\x15K\x0b\xcd\xffk\xf4\x82\xd8\xaf{\xb1\xe5\xbd\xfa\x17\
\xe0\xbf2>\x7fnS\xff\x99\'\xaf\xf2\xb3~2\xde\xa9\xe2\xefK_\xed[\x0et\xb9j\
\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\xb724\xb12\xb6\xd460\xb220\xb0\t\
>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\x95\x11T\x83K\
\xe5;P\xd80x\xba\xfa\xb9\xacsJh\x02\x00\xbc\xf9\x0e\x86' )

addArtData('wxART_MACRO_SAVEAS', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xde\x08\xf0\tq\xfd\
\xff\xff?CC\xc3\x11\x1e\x9euk\xbe\xcc\x99\xfd\xe0\xbf\x95Uv\xda\xa1\x1b7~\
\xfe\xfb\xf7\xff\xcb\x97\xff\xe5%\xb7\xbex\xfa\xfc\x9f6\xed\xfd\xfb\x7f\'\
\x8e=\xf7\xf7\\\xff\xcf\xcaz\xd7\xce\xa7O\x9e\xfc\xe9\xed<\x19\x17\xb5+)rc~\
\xf6n\xde2\xe1\xd7\xaf\x7fG\xaf.\x00\x9av\xe7\xf9\x9d\x9d\xe7w\xad8\xbc\xc2\
\xb4\xcd\x91A\x96!by\xce\x97\x1f_o<\xbd\xb9\xf5\xec\xb6\xb9{\xe6\x01\xad\xdd\
\xb6\xf5qX\xd0\x1a\xef\xd91\x0f^=\xd8{i\xef\xac\x9d\xb3;\xd7u*\x95h\xadZu\
\xc7\xcbu\x8a\xeb\xd4\x10\xfb\t\xbe&-\x0e\x1a\x95\x86J\xc5Z\xb2\xb9\xca3f\\\
\x8c\t\xda!`\xcf)\x9e.\xb3t\xe1C\x7f\xd7\x95\x96\x9dn\xc7n\x1e\x17L\x12\xb9r\
\xe3\xadq\xb3\xdd\x8b\xf7/\xf6]\xda\xcf\x1d\xcd\xfb\xe4\xe9\x87\x83\xfbo\xcb\
DY\xd4\xd5\x9c\xd8ow\r\x18\x06\x0cL%A~\xc0p*\x9b|\xd6\x02\xc8cL\xf2vwa\xe8`\
\x95\xf5\x00r8\x0b<"\x8b\x19\x18\xb8\x85A\x98\x91a\xd6\x1c\t\xa0 {\x89\xa7\
\xaf+\xfbC\x0e>.%Y\x0e\x87\x8fQ@\xa1\x13\x9e.\x8e!\x12\x97u\xfb:\x8b\x0e)\
\x88\xb82\xfa6\xec\n0\xe8\xb2\xbeev\xcb\xf7\xf2\x15^\xd7\xb5\xa5+\xff\xffw\
\xafU\xb14\xce\x9fQ=c\xbbB\x8b\xa1Z\xc0\xd2\xa2\x9d,\xfcnq,,\xedS\n\x7fM\xe8\
\xf4\x12`\t5\xe8\xb9\xfa\xeaP\xf7\xf1U\xed\t\x07+|\xb9\x04X\x1az\x9c\x0fN\
\x99\xd4\x9b\xc3\xf6q\xa6\xd1\xc2\x94+.G\xc5N\xf4t{l\x13\xb8\xc4\xaa\x98\xaf\
\x1d\xd5.v\xf7\xe5\xb7_\xcd\x0b\x1f.\\d\xd4\xb4\xb0\xca\xa4\xae\xaa\xae\x93\
\xf7\x8f\xff\xb2\xba\xb5u\xb5\xd5\xff\x7f\xcc\x91t}\xeeY6\xe3\x9f\xd7~\xf1\
\xd3S\x17\xbe\xf6\xad\xdb\xe5\xa7\xbb\xc1t\xf7\x11\xd1\xa4\xfc\xc7\xcd\xb6R\
\xe6\xff3\x9f>J\xa9?\xff-\xe9\xce\xd7gF\x1f\xd3\x8b\xa4\xde\xbd\x8b\xfe\xc7X\
U \xf4\xc1\x86A\xfb\x19\xd0O\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\
\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\
\xca\xc0\xc0&\xf84\xaa\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\x10C\x03+c\
\x13+#\xa8\x06\x97\xcaw\xa0Pc\xf0t\xf5sY\xe7\x94\xd0\x04\x00SV#V' )

addArtData('wxART_MACRO_STOP', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xad\x0e\xf0\tqehh\xf8\
\xff\xff\xff\xba5_\xe6\xcc~\x90\x9dv\xe8\xc6\x8d\x9f\xff\xfe\xfd\xff\xf2\xe5\
\x7fy\xc9\xad\xf7\xef\xff\x9d8\xf6\xdc\xdfs\xfd\xae\x9dO\x9f<\xf9\xd3\xdby2.\
jWR\xe4\xc6\xfc\xec\xdd\xaf_\xff\xfea\xc0\xf0\xff\xce\xd5\x7f\xe7\x8f\xfe\
\xdd\xba\xe4\xf7\xacf\xa0\xc1\xdb\xb6>\x0e\x0bZ\xf3\xbb>q\xd5\xaa;^\xaeS~\
\xc5Y\xce\x98q1&h\xc7\x0f;\xc1+7\xde.]\xf8\xd0\xdfu\xe5\x93\xa7\x1f\x0e\xee\
\xbf]Ws\x02h\xe9\x87\x96x/\xa03\x98J\x82\xfc\x80^)\x9b|\xd6\x02\xc8cL\xf2vwa\
\xfc\xcf\xa4{\x0f\xc8\xe1,\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\
\xbe\xae\xec\x0f9\xf8\xb8\x94d9\x1c>F\x01\x85&{\xba8\x86H\\\xf6\xed\xbf)\xd4\
d\xc0\xe3\xca\xbce\xe5\x84)]\xaek\xb9\xf4"\xbe\xfe\xff\x7fA\xaf\xe7\xdb\xbe\
\x92s/\xef\xf80M\x086\xf7\x95\xbd\x9f\x95\xaa\x18x\xd2W\xd1Aa\x9b\xac(\x13G\
\xe8\xe9\x10\x0e\xc7\x15\xa6\xdf\xffw\xb9\\\xca\xd9v4 $\xa5bE\x9d\xce\x15\
\xbf\xd3z!9|Z\x0bUg\x1b\\\xe9{\xfc\xaf\xa0\xe4\xe3\xff\x926\x15\xa6\xf8\x98\
\x07\x99~\xdd7O\x84/\x7f\xfav^\xf8\xf6\x89\xf2y\x95\xe7\xeaD\'\xaeM\xb6\xd7u\
\x16\xd3;\xfa\xfb\xfa\xed\xe9\xc7\x1d\xdf\xdb\xaf\xfc\xc4Z\xf1\x88s\xf9\x0c\
\x91:;\xa0\xf3TK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\
\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\x81\x81M\
\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\x8c\xa0\x1a\\*\
\xdf\x81\x02\x80\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\x8bR\xe1\'' )

addArtData('wxART_MARGIN', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4'y\xba8\x86X\xf4\
\xbe\x9d|\x96\xeb\x80\x01G\xb3\xfd\xe9{\xd5/'\xef>\\\xf7\xc2\xadLC\xf7\xcd\
\xa6\x98\x10\xa5\x83\x1an\x06m\x97\xc48gN\xc8?\xdb\x17\x7f\xcbI\x88\xe1k\x87\
\xbf\x85]\x14\xf7\xf2\xaa\x86\xd2g?\x1eIU\x7f\x88~0K\xb5q\xca\x14\xdb\xca3\
\x1b\n\xa2\x1f\xedZ\x1d\xac\xba\xdb\xe58\x7f\xbc\xe22\xbb\xcb\xeaL\xd2s\xd9\
\x9d\xc4\xed\x1e^\x019\x87\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\xc0.<\xfe" )

addArtData('wxART_MARGIN_LOCK', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe47x\xba8\x86X\xf4\
\xee\x9d|\x90\xafE\x81\xc7%\xbe\xf3\xff\xdb\x1fO7\x8b\x1bN]\x1bx\xbd\xb7\xb8\
\xf1R\xda\xa1l\xc5\xa6\xf4,K\x83\x1b\x0f\x16?\xd2\xb2\x7f\xea \xc4pzW\xdf\
\xaaO\x13\x05wU;x\x86=\x8d\x0e\xadp\x7f\xaf\x14\xb2\xab\xf5C\x06\x17\xdb\xf7\
\xd9Ok\xa5\xe7\xaa&~\xd0\xf9\xf9&6\xc6\x89\xa3#o\x12\xef\xf6\xba\xa7yg'\x85\
\xb7\xc4\n\x1f\x7f\xf6\xec\xc7%\x91>\x03\xa6$)\xfes\x13\xf6\xf9\xfc\xfb%]\
\x7f\x91}1\xb7\xbb\x90\xef\x95o\xff\x80na\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xf2\
\xa9N\xf2" )

addArtData('wxART_MERGE_CONTOURS', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xdfa\x10f<\x9e\xbf"\x05(\xc8^\xe2\xe9\xeb\xca\
\xfe\x90C\x90\xc7\\\xc4\xeb\xde\x94\x89@\xa1pO\x17\xc7\x10\x8d\xf3k\':\xf2\
\x1dP\xe0`)\xef\xe5\xff\x9a\xf9u\xe9m\xe6\x95ANO\x94\xc4MfZh\x07X\x84\xdfw\
\xd7\x0b\xf3a<\xc0\xf1/.\xa3u!\xdb\xae\xf2\xf3\x13\xdcL\xd6\xaf\x99wA\xd1\
\xb1\xdc\xe8H?/O\xf9mN\xc7\xda\xe2\x0f\xcd\xbb\xa6$z\n5\\5\xf3>\xca]\xb9C}\
\xad\xdc\x96\xd2\x9b@+TK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\
\xae\x81\x85\xae\xa1y\x88\xa1\xa9\x95\xa1\x81\x95\x89\xa9\xb6\x81\x91\x95\
\x81A`\xb7\xb6?\x8a\x86\xdc\xfc\x94\xcc\xb4J\x14\rFV\xa6\xa6VF\x06\x10\r\xf3\
\x99\xb8\x81\xc1\xc3\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00\x8c\x7fi&' )

addArtData('wxART_METRIC', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4[{\xba8\x86X\xf4&\
\xa7\xa4,\xe01\x08\\Q/ q\xe0\xc0\x89\x03\x07.\\\xb8\xf0a~c\xe3C\xfb\x1e71g1\
\xf7t\xe3C1@\xa1\x86&\xcf\xa2\x03\x17\xfa[/:\xc8\x88\x01\xcd\xb4\x9ab\xca\
\xd9\x9f-\xec\x054\x86\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\x03\xac(\xc5' )

addArtData('wxART_METRIC_LOCK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\x17{\xba8\x86X\xf4\
\x9e\x9d\x14\xc8u\xc0\x80\xc39\xfe\xd8;\xdb\xfcy\xb5%M\xaf\x7fm\x0c\xd4\xe0\
\xeeX{t\xc6*\xa1\xe2\x1bj\x9f\xeb\x1d\x1a\x1a:\x0c\x1e|1\r{\xfc7r\xa5\x82R\
\xde7\xcf\x03\x974%\xde\xa8\xfd\xb7n\xbc=_5@\xf5&C\x1f\x87\xf4\x9c}\xc7~u\
\xf1\xc7\xd8\x16\xccu\x99\xeb\xb4\xaf\xdfgON\xd2\xaa\x0b\xa1\xeb\xef}\x0f\
\xe7}\xd1\xa1\xb5\xcc\xbc\xf0\xad\\O\x01\xd3&9\x8f\xcaB\x8f\xdb\x1b\x81\xd63\
x\xba\xfa\xb9\xacsJh\x02\x00\xa2\xc6GC' )

addArtData('wxART_MINUS_BLUE', 'wxART_OTHER_C', 16,
b'x\xdaUU\t<Tk\x1b?FEvW"c\x99\x94d\x8b\x91\xae!*\x19\xb2D\x0c\x89\xca:\x06c\
\x99\x91\x99n\x06c\xdf\x974\x94!\x8c%\xc3\x87\x8a\n7\xfbd*-B\xa5[\xdcJ\xbe\
\xba\xdd\x8fi\x18c\x19C\xe9\xbeS\xb7\xefw\xef\xf9\xfd\xce9\xef\xfb\xbc\xcf\
\xffy\xfe\xe7\xff<\xef{r\xdc\\\x8f\xc8J\xa9IA\x10$\xeb\xe8\x80\xc6\x80\xb7\
\x82\xe8\x96\x14\x07\xcf\xddF\xf2\x1e\x10$6\x89\xb7\xb5u\xc3c\xb1\xc0@\xab,\
\x1aq\x86\xdbl\x19\xec/\xf7\xf6\xd4\xd7lB[e\xe7y\xf3\x14\x9c\x8f\xa2\xad\xed\
\xa3^T\x1fv\xe8\x18[\xee\x18\xbe\xee8\xfa\xe6\xea\xad\xf7\x85\x87\xe4\xfd\
\xb8wH6R\xccX\xde\xb3\xadq\xfa\x19\xa9Y\x18\xa7\x1a\t\xbd6ec\xc6\xaa\xbc\xe4\
5\xe6%n\xb9\x06=YaC?\xef\xdd\xdeB\xea\xdc\x93\x84I\xd8\xfc\xb6\xe7\x0b^A\x90\
\xfa\t\xde\xc0bz\x1f\x8fG{\x9b #{\xa6\xadV\xc5w\xd7B\xef|B\xa2\x9c\xec\x12\
\x07NuY\xb5\xdc\x1d\xcf%\x7f}\x9d8\xce\xaf\x8d\xa0\x18\x1773z\xf6\x98]\x97~1\
\x8cGT\xeb\xe4\xecw\xce\xbdU\xa4\xa2\x0c/2O\xd7\xcd~\\\xe43\xde\x96\xad\xa5\
\xa4\xdb\xe9^\xba\xf3-\x9d\xea\x94;\xe9\xe4\xe7\xf9\xd9\x91oi\xf0pB\xeb\xae\
\xde\xcb\xa6\xdb\x87\xaef\xc4\x0e\xdd\xa4\xda\x1b\x86\x8e\x97\x8c\xa8\x07\
\x8d\x0fFW\xe8/\x15~\xd9\xa1\x19\xa0\xd90\x11{\xf0L\xff\xa2\x9d\xaf\x10\xafX\
\xaaQ\xc3\xe8\xe7t\xde\xd0e-\xd8V\xbf\xb7\xb5>\xb7&\xefk.\xd6\xd32Fj\xc8\x19\
50\x9a\x1f\xf7\x7fT\xc7\xbe\xf8\xdb\xfd\x14x\xa8M\xf4\x84\xb8Y\xbf\xf80E\xe1\
3u\xeb\x86?\xe3\xcd\xd6$Q\xde\xb8\x88\x84/\x03\xc6.k\xb0\xd3g\xbd\x88^\xa1\
\xef\xdc\xd0c\xd9\x97\x8ck0\xacu1\xb7:Ufl\xbb\xdd\xdc\x8a\xdc\xeb\x89\x8d\
\xfcg\x0c\xc3\xa0\xb2\xa3[\x1e\xb1\xdd\xcc\xf3\xf6\xd1\x9f\x94\xf7\xb5\n\x95\
\xe1\xfd\x99\x15\x97\xda\xc3\\\x95\xec\xca\xb9o\x1b4\xaa\x8b\xb5\xbb\xef6H)\
\x9eZ~\x13\xafx\x02=\x9c\xadj7\xf6.5PsW\x82\xe4\xabw\xe1#\x18R\xdaX\xc7H\xec\
\x05\xcd\xf5\x95\x90 \x0e?2\x90\x98y\xc0\xc5\xabW\xad\xe5\xe2\xa3\xc3Z\r\xfd\
\xaf]g,\xe8o\x1cg\xa6\xc7F\x15\xd6\xc5\xad\xdb\x0b\xee\xe5\xc9\xc9<\x06\x15G\
`\x1d0.\x10\x14u\x16\x82H\xd5\x10\xb4>\x05A\xc9_ \xc8\xbd\x00\x12\x13\xbb\
\x0bA&o!H%B\xd2\x82m\x0cA0k\xb7\xa3\x9ev\xac\xa7\xab\xac\xa7\xc2\xba\xae%F\
\xc7bi\xeb\x02\xady\x81\xde\xbaX\xd4\xcc\xcf\xaf\x9f\xcf\xab\xe7gT\xf3\x92\
\xcag}\xa93\xa7\xa9\xd3\xbe\xd4iZ3\x1f\xf8\xdf\xf9\x06i\x1b\\ia\x0b\x9aX\xcb\
\xc0R\xd5\xb1t\xe7\x9b\x9d\xd6<\xff\xdd!\xa3\x86\x07\x06\x14:\x97T\xc4\x05\
\xce\x84|n\xef\xf0Jx\xce\xa7\xceG+!\x993m\x83\xc2\xa0\xd4\x99V\xb6\xc0?\x99\
\xd3\xd4\'\x00\xc1\x99\xdd"\x02 \x05x\x96\xdd\x10\x11\x00\xe3\xef|\xf2\xea\
\xe7A\xb4\xef\x04\xf2\x1b\x00\xa5\xf9\xa4r^\x1c}\x96D\xe3\x12\xces\x83R\xa6\
\x03\x929`\t8\x80\x14\x9dCB\x90\xb7wX\x08\x12\xb5=Xi\xbd+h\xec[\xae\xeb^\x02\
\x1c\x00\xab\x1e`\x1fZm\x7f(l\xb9+lb\t@R\xc0\x1cda\x8d\n\xfbF\x84\x9d\x8f\
\x85\xe0\x8b\x98\xdd\xcb\x80\x03\xbd\x95O\xfb&B\xdb\xa0\xa0\x95\xbdR\xd7\xb5\
\\\xd5\xb1\\\n\x94\xb9\xca\xcfe\xce\x8bd\xa9\xe0u>^i\x7f h\xbd\'h\xea_b\xb4/\
\x96\x8ah\x8b\xd8\xa6\xd7\x00\xd1\xe6(\xf4\xd9\xce\xc7\xab\xed\x00~w\xa5\xe8\
\xea\x02\xa5d\x96\\\xccm\x7f\xb0bt\xb0\\\xdf\x8a\xa6\xfbs\x86\xce\xdexmc\x82\
\xa6>\x16\xbe\xcbg\x9b\xb6\xebV\r\xb4\x92\x9a%\xb9\x88K\xc8\xe7\xe8\xef\xa7\
\xed6\xcf\xdc\xbe\x87\xa8\xa5\x1f\xac\xae\x0bV]\xb6j\xda*\xa9Y(\xaa \x89\x05\
\x9f\xc2s8M\xac%P2z\xeb\x02\x10\n\x88\x93T1K<\xcf\xc5e\xcc4\xb3\x00\xcfEP\
\x05 Tb\xf9\x1c\x99\xc6\r\xcf\xfd\x14\x92\xc1\tL\x99\xa9\xeb^\xa6\xb7\xf03kx\
\xa0(\xf8lNH&\x07H\xe7\x9f4\x9d\xd7\xc0\x07z\x92\x8b@\x04\x10\xf9\x13.\x83\
\x13\x94\xca\xf1O\x9e\xce\x13}\xe6<\x996\x1b\x95\xcf\xc1\xa5\xcf\x80JQJ\xb8\
\x84\x82O\xa0p\xfe\xc93\xe1\xd9\x9c\xaf_\xbf\x8eMWF\x82\xa6C\x931\xae\xe0\
\x9c\xf9\xf7\xa5{\xe1\xc3\x87\x82\x9d\xd4xXY\t\xac0w\x87r\xec\x18{vfv\xe6%\
\xbb"\xd6ZY\xe5J\xf6f\xc4\xf52\x984\xe2J!\x0c\xb6Y\xe5P\xd5\x1f\xefi:0\xb8\
\xac\x1f\x01@\xc5\x82\x9c\x8f\xa0\xfb\xea^\xa7\xb1\xc1ds\xb4\x83\x0f\t\x82\
\xa4\x95D\xb7\x18t\xb9B\x15\x18%\xc8\x8e.v\x12S\x92rR\xda\x1a\x92\x87\xe6O\
\x82n6\x8d\xf3\xf4&c\x02\xcf!\xa2c\x88!\xf8H\x1c\x82L\x89\xc6!\xbe\x9dz\xa8\
\x82\xf6\xe3\x11\x84\x0f\x08\x99\xf5\x11\xbde\xc9\xfb\xc7P\xae0\x9b\x895\xff\
\x00\xd9\xf4\xa3\xa6Q\xcc\x8eg\'\xd5p\xfc\xf1\x84\xc4b\xde\xaf\x17y\r\xceA\
\x92\xa3\x19(\xbc\x99\xc9(\x0c\xa50\xda\x94u\xa3\x06\x01\xdf\x91\xba\xf3\xe1\
\xcd\xceg\x80\xfe\xabcB\xe3\xb5\xc9\x8f\x07\xa5\xd5.\xe5\xcb\xa0\xa4$\xa3S\
\xfc\x1dH-S\xc1Z\x98\xcd\x9c\\C\r\xa4\xd6e\xbe\xd7\xf6(U\x17AA\x0e*b\x7f@D\
\xea\\\xf0T\xd6\xb0\xfc\xb1_vZ\xbc\xd5flC\xcb\x85\x9f\xdb\xc8\xc6\xfc\xef}2o\
\xe0IOL\xc0\x82ux\x9c"-\xaef\xc9\xf3\xd5\xb4X^|\x88\xb1\x99K\x82\xb3\x81\xf6\
\xb9\x04\xb6@Z~\x15\xe5\xb6\'\xa3\xb1\xbb\xf5\x8fN\x06*E\xf3\xd1\xe5\xa5\xd2\
\xf5\x80)=\x94\xa1\xbdeN4\xb3\xbe\xf6\xb5\xfb5%\x7f\xc5\xcd\xf1iM\x1d{\xc5#\
\r\xc4u\xf9\xbf\xc1\x19\x0c<r\xbb?\x89T\\\x11\x8c\xfaPI\xb6\x9f\x88\x1c\xb7\
\xee\xb2\xd7+\xf8/\xc1m\xd0\x01\xad_\xf5Sm\x9b\x95\xb3\xba\xc4\x94\xdf\xbe\
\xac\x11\x19\xb8l\xda>\x7fd\xf8\xb8\x95\xbbNmw\xe0\x06\xe2\xc3\xa1\xdb\xcc\
\xd1.\xb7\x8a\xf6V*z\xaci\x8a%8=x\x8b\x10:s\x16\x8da\xad\x1e\xc8\xa6\xa3U"n\
\xbf\xc2n\x0b\x9e\xdb4\xf9"\x0b\xc7\x0b\x13T\xb2\x98\xf7%\xd6O6\xc25\xfb0\
\x86\x9f\x91\xe6\xf4!\xfc\xf8\xb3O}ne\x8dO-F\x7fG\x0endN\x04\x0c\xf4\xc8\xb3\
\x17n\xf3xi~\xe4\xb8\xa4\x03\x12|\x9d\xee\x0b\x14u\xa7\xd7s\xe27\tK\x81\xef\
\xe7\xf8\xcf\xb9_\x93\xd0}&\xf7\xd0\xd3\x95a\xca\xdd+\x1d\x1a\xda1\xf5=\xb3*\
\x9b\x8e\xdb\x8e(M\xce\xbb\xef\x08)\x91\x97\xb8\x89\xfc\xf3\xa5\xf5"\xff\xf9\
C#A\xe2rc\xcc\xd0\xe0\x11\xeayVW\xea\xda\xfd5%\xad\xdf{\x07\x0cQ\xba\x93\xfd\
\xb0\xc4i\xd5\xedg\x9ejl{\x8e[\xc0\x15\xd8W=\x8b\xb8^\xda&\xb4\xa6\xbd9\xee\
\xe5\xf1\xb2:\xc9\xe4\xe3\x97\xd9\xb2\x92w-W\x9e\xc4\x06\xd8\xf4\x1f\x91\xdc\
]T\x18\xb4"\x91\xe9\x80\xa5n\xf4\xa9\xd8\x04:\x0e\xee\x88\xb6\xf1T}.\xa6 6\
\xb7.\xea^1\x05\xc5\x9f\xd0vJ[\x94a\xe2\x1b6\x8a\x0c[\xed\xed\x8f88:9\x1fU\
\xd9$!\t\x89\xa9nsq=\xe6\xe6\x8e\xf1\xf0<\xee\xa5\xb6Y\n\x82\xab\x9fp\xf5\
\xf6q?\xe9q\xea\xb4\xaf\x9f\xbf\x864\xa4i\x7f\xe2\x88O@\xa0s\x106\x18\x17\
\x12\x1a\xa6\x05\xa9\xbbz\xe3\xc3#"OE\x11\x88\xd1gbH\x08h;\x9a|\xf6\x17\x0f0\
?\xe7\x1f\x1a\x16K\xd1\x86v\xe0\xe3\xe2\x13\xa8\x89I\xc9)\xa9i\xe9\x19\x99;!\
\x9d8\xa7\xac\xec\xc4\x9c\xdc\xbc\xfc\x82\xf3\x85\x17h\xbb ]\xa7\xa2\xe2\xd3\
\x17/\x85\x94\xd0I\x19\xa5\xb4\xb2\xdd\x90\xde\xe5\xe2r\xaf\x8a\xca\x12\x06\
\xa9\xaa\xb4\xba\xa6V\x1f2\xb8r\xba\xae\xa2\x92I\xaf\xa7\\h\xf8Oc\x93!d\xb4\
\'\xf8Rs\xe8U\xd2\xb5\xeb-\xad7n\x1a\xcb@&H\xd3[ma\xa4\xf6\x8e\x96_ko\xef\
\x95\x95\x83\xcc\xf6\xfdl\xce\xe8\xac\xeaj(\xeb\xeeAY\xc8\xc9A\xf2\x96\xfb\
\xad\xac\x0f\x1c\xec\xad9ds\xd8VNN\x06f\xe8\xe7+\xd7\x1be\x01T\xd0!\xdby\x93\
\x83\x03\xc98Kl\x0c\x0e\xbc S\x13\xa4\xb9\x91\x89\x99\x91\xa9\xa9\'\xd2\xdc\
\x12if\xb9\xd7\xc2\xc0\xc4\xd4\xd2\xc4\xc4\xca\xe3\xf1\xc7\x7f\x01\xa2\x88\
\xc1\xf8\x10\xca\xdf\x00\x94\x11\xd2\xcc\x13ib\xb9\xd7\xcc\xd2\xf4o\x00\x9a2\
\x0b\xb61\xa4\'\x02\x80]k\x89%FSb\xf0\xa1ad\xc8\xf6\xc7\x08a\x13\x1d\x1d\x89\
3D8\x12\xb0{\x0c\x11 \x12r\xa0LI\x1e\x80\xd4~\x80\x82q$l\x0c>\x9a\x8c\'\x12 \
\x0f\n\x01\xeb\x12H"\xe3b\xac\xdc\x07\xc0\x7f\x0f\x82\xff\xf0\x8a\n$\x9c\r\t\
\xc4\x92\xcf\xc6\xe0b\xfe\xe1\x96\xf2\x10g\x00\xdc\xb6\xfc\xdf\x8d\x18\x8c\
\x8b\xfc\xc7z\xd4\xb1\xcc[\xa2Vp\xb4sE_?\x1c\x90\xfa\x174\xb4\x84\x92' )

addArtData('wxART_NAMESPACE', 'wxART_OTHER_C', 16,
b'x\xda\x9dPiHTa\x14\xbd\x96\xe2\xa8\xb8\x80\x86\x1aX&I\x85\xa8o\x96P\x07K\
\x9dfr4\x15\xd3\x11,\x0bG\x1dm\x15\xc3&q\x92lp\xc1,Q1L1\x13)\xe8\x87h`\xa4\
\xb6\x80\x99-\x0c\x15aM\xe1\x92\xfb2\xce\xbcY\xdf*.\xf4\xfa\x04\xff\xf4\xb7\
\x0b\xf7\x1e\xee\xe1\x9e\x03\xe7\xd6\xa7\xa7%z\xba\xefu\x07\x00\xcf$\xb94\
\x03\xa1\xcfv\xf3v\xa3y8\xdc;\x13\x81\xf3\x85\x84\xd4\x04\x80\xfe&\x8f\xad<\
\x17\xb4\x07\x17\xc83R\x01n\x86\x02h\xab\x01\xd69\x84&\x80\x1b\x18\x00\xae\
\x04\x10\xb7\x03\xf8\x97\xb4\xe4~<\x89n\xf1\xf4\x14\x85\x8c\xe38\xd0j\xfd\
\x8aF\x84m\xd6\x8e\xcf\xecz1\x16\x18\xdfh%X\x8b\x83\xc1\xed\xf4\xa2\x99\xb2\
\x91\xac\x85`p\x073\x8fS\x0c\xb3f\'\x19+\xc1\x98\xec\x8c\xd1F\xcf\xe1\xe4\
\xac\x91\xa4\x19\x96\xa2Y\x07\xc5ZI\xc6`\xa5\x97-\xf4\xbc\x89\x9a3\x91\xd3F\
\x8ab\xd6\x08\x9a\xb5\x91\xcc\xea6O-\x99\xa9\x05\x9c\x9c1R\xd3\xab$I\xb3v\
\x925;\x98)\x03IP\xac\x8d@\x86\xcc"N\xe1\xc8\xd9\xce,[\xe9\x89\x15\xc2d\xa7W\
\xac\xf4\x02NM\xac\x90\xe3+\x84\xae\xdd\x7fcut\xb0\xc6\x8b\x9e\xe9\xb5\xfeh\
\xed\xaf\xf40\xe8*{5n/\x00\x1e\x16\x01\xf7\xee\x15\xd7t\x8b\x13\x82\n\xa0\
\xa2\xa2\x02\xf2\xf1!\xfdV\xf5S:\xbd\xd6\xc1\x8bx\x8cb\xce\x06\xe9:Q\xea\x18\
uF\x1a\xfa\x9c\xe1\xffJ\xff\xfc\xfeWd\xe2\x94\x7f*Q\nw\\\x82\xe4hq\xbb&?s\
\x1d\xc0\xc3w\xbb\x9d\xa0\xa33\x00\x91\xae\xea\xa4T\x99\xeb\x02\xcf\xcb=$\
\x88\x17O\x9cE\xd4p\x924A\x11\xa0?\xdfP\xe7U\x85\xf9\xc1\x95\xef=\xd9\xfe\
\x11\x1f\xea+\xecYQ\xb2#<\x8e;v\xfcg\xc0\xd2\xd1\xe2\xd2\xb6\xb5\xbb\xcd\xde\
\'\xe2\x94\r\x93\x7f\xb4q\xce>\x0f\x0e\x0e\xc6u}\xcb\xf0I\x93\x8f\xf2|\xe7"-\
\xc9<\xfe|\xc8V\xd9\xbeF\xa9\xa7\xbe\xd9m\xa3\xbc\xe1\x93\'U6\xa4\xac\xda\
\x8c\xa8)\xd7\xec\x92\xb4\x08\xbb\x92=B\x0bf\xfa\xaezI\x86G~\x85\xec\t\xecS\
\xb5\x86e\xf1\x06^\xf7\xe8_^\x14\xe5\x14\xbf\xd1\xd7\x8een\xaa\xbbG\x0e\x8d\
\x96Y\x0e\xd4\x9c\xbe\x9c\xf2\xc4\xb7/f\xe0Q\x9d9A[;y.G\x17\x99+\x19\xd3Wg\
\x15\xccL)b\xc7\x7f\xdb\x82\x9b#\xbb\xb8\xee\xdb]\xf1\xef\xf7G\xe7\xbc\xbdgD\
IB\xd5\xb2l\xb5*O](.(-D\x00\x02\x8c\x1f\x15\x8e\x89\xc2\x05\x02\x05?J\xcc\
\x17\x89\x851a\x98@\x8ca\xb1\x99_\x0c\xff\x08\x8aKT\x97\x8a4;\x82\xe8p\xbeH\
\xc1\xc7\xc4B\x91X\xb0#\x90jl\xdb\xbf\x82$Y\x9a\xf4\x99DY\xf5\x17\x7f\xc8\
\x8c\xc1' )

addArtData('wxART_NORMAL_FILE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xfa\x05\xf8\x84\xb8\
\xfe\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=\xf3\xef\xdf\xbf\xfbO\xde\xfe\xf1\xf3\
\xf7\xb3\xd7\x9f?\x7f\xf9\xf1\xee\xc3\xd7\x97o>=y\xf1\xfe\xfe\x93\xb7\xb7\
\x1e\xbc\xfa\xfa\xed\xe7\x87O\xdf^\xbf\xfb\xf2\xec\xd5\xc7\x87\xcf\xde\xdd}\
\xf4\xfa\xc6\xbd\x97\x97o>\xfb\xf5\xfb\xcf\xb9\xab\x8fO^|p\xe4\xec\xdd\x13\
\xca\xebd\x81&3\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\xcaz\x009\
\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\
\x95\xfd!\x07\x1f\x97\x92,\x87\xc3\xc7(\xa0P\x8a\xa7\x8bc\x88\xc4\xe5\xd0\
\xf3\x9eb\r\n<.\x07\xb7(Zt\x7f.\xf8\xdf\xfdk\x82\xcb\xd2\xf2\x90\x7flJ{\x16\
\x9b\x88X\x15\xf0\xf1\x1d\xe2\xfatf\xb1\x8f\x10\xf7\xf39\xeb\x0f\x9c\xf9\xbf\
(\x8fA\xfb\xd1\xde\xbc[|\x91\x8a\x97\xa4y\x9c%\x96WF\x9a\xb7\xde\xedr>\xf8\
\xee\xf8J\x815;D\xde\xd4u\x1e\xfam6c\xff\x7f\xb5\x07\xf7;\xf2\xd4w\xb2j\xbc\
\xef\t\x12\x02\xda\xa7Z\xe2\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\
\x0c\xcdu\rLt\x8d\x8cB\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O\
?C\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\x12bh`elbe\x04\xd5\xe0R\xf9\x0e\xe4\
#\x06OW?\x97uN\tM\x00\xaf\xe1\xb9\x94' )

addArtData('wxART_NOTE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Re`hhf`\xf8\xf9\x1fH\xbfd`(5``x\x95\xc0\xc0`5\x83\x81A<\x7fR\xfcQ7\xa0Z\
\xa1\x00\x9f\x10\xd7\xff\xff\xff3\x02\xd54\x00\xf9\x0c\xff\xff\x03\xd1\xff'\
\xf1\xdc\xf1@\x0eSI\x90_0\x03C\xd9\xe4\xb3\x16@\x1ec\x92\xb7\xbb\x0b\xeb\x8f\
\xfc\x97\xc7\x81\x1c\xce\x02\x8f\xc8b\x06\x06na\x10fd\x985G\x02(\xc8^\xe2\
\xe9\xeb\xca\xfe\x90\x83\x8fKI\x96\xc3\xe1c\x14P\xc8\xd8\xd3\xc51\x84\xe3zr\
\xc2\x01\xe6\x19S\x80\xe0 \x8f\xb8\xb8x\xba\xc1\xe1\x9b7nH\xc6\x1eaUK\xca\
\xe1\x11444l\xe9\xe4h\x92<v\xac\xad\x89\xc7\x85\x91!\x91\x83\xfd\xe1\x12\xcb\
\xea\x8b@\xed\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\
\xc0B\xd7\xd00\xc4\xd0\xc0\xca\xc8\xdc\xca\xc0X\xdb\xc0\xc8\xca\xc0\xa0y\xe2\
v\x06\x14\r\xb9\xf9)\x99i\x95\x08\r& \r\xc6&VF\x96\x10\r.\x95\xef@\x0ed\xf0t\
\xf5sY\xe7\x94\xd0\x04\x00\xc5\xd5d\x03" )

addArtData('wxART_NOTE_ADD', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x10hh`\xf8\xff\x1f\x88\xfe\xbfm\xfd\
\xbc\x08\xc8g,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\xe4\xb0\x97x\
\xfa\xba\xb2?\xe4\xe0\xe3R\x92\xe5p\xf8\x18\x05\x14\xb2\xf2tq\x0c\xe1\xb8\
\x9e\x9c\xe0\xc0\xca\xf4\x82\xc7\xd1\x91QEPUA\x80\xc1pJoo\xefA\xa1SMM\x87\
\x04\xd8\x9c\\$N\x19\x98\x89\xb4tIH\x199\xb8*,\xd3\xe4\xe22J`e(\xf7g]\xeb\
\xf3\xe9\xf3!\xa0)\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\
\xd7\xc0\x02\x88B\x0c\xcd\xacL\r\xad\x8cL\xb4\r\x8c\xac\x0c\x0cn\xf1},G\xd1\
\x90\x9b\x9f\x92\x99V\t\xd7`h\x12bh`elbed\t\xd1\xe0R\xf9\x0e\xe4N\x06OW?\x97\
uN\tM\x00\xd8\x86\\\x9f" )

addArtData('wxART_OFFCURVE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe47y\xba8\x86X\xf4N\
\x9d|\x91\xeb\x80\x02\x87k\xff\xef\x8f?\x9f\x16\xf3\xbbF\xec,\xdc\xad\x10X\
\xb2nQj\xdb:\xf6GM\x9c;\xfd\x12\x1av\xafwVk\xdb\xdd\xee\xbc\xe6\xb9\x91\x8d\
\xe3\xda\xae\t<Fs\x0e\n\x86\n/\x8e\xdd\xb4\xe7\xfd\xc9m\xaf\x97:\x9aE\x9eMi^\
5\xc9\xeb\xb6D\xfe\xf7\x80\x87aL\xd5\x875\x8e}\x15\x8d8\xbf\xad,\xda\x8c\xa3\
\xa3\xe1\xa3\x87\xdf\x83\xc0F\xf5\x17W\x12f5\xdd\xd9\xa1\xf2\xd3\xb8\xf6\xe5\
wY\x8d*Fy\x1f\xd3\xe0\x8fn\x93\x15\x81\xaea\xf0t\xf5sY\xe7\x94\xd0\x04\x00E\
\x86Ni' )

addArtData('wxART_ONCURVE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4g{\xba8\x86X\xf4\
\xee\x9dp\x9a\xab\xc1\x80\x87E\xfdQ\xbd\xf4\xfe\x1a\xdb\x8c\x16\xbb\x05\xc7\
\xba\x1ae\xb8\xee\xbe-93cv\xaa\xd1|}\x01\x8f\x05\x16\xebg*48~|\xadx\xf0\x99^\
#\xcf\x1a\xbebS3\xe9\x19ul\xbb\xcb\x93\x96\xab\x96\xc9\xbe\x99\xd9&u\xf2n\
\xfb\x8d\xa3\xd7\xc2\x9cn\x047\x1cr4\xbb#\xb2g\xe6\xee\x07g_\xcf\x170\x11\
\xaaW\xb7`p]*i\xa2\xf3i\xdea\xa0\xb5\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x001\x9a?\
\xe4' )

addArtData('wxART_OUTLINE_LOCK', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe47y\xba8\x86X\xf4\
\xae\r\x8e\xe6;\xa0\xc0\xa1\x9d\xf6]L_\xef\xb7$\x8b\xb8\xc8w\x05\xc3I\x11Y\
\xdc^-\xf9\x81&/\x1bR\x1ep\x04\x7fY\x10[\x9d*\xc6\xd8\x16:\xf3h\xb2\r\xe3\
\xcaV>\x0f\xc6i}J=\x91\x19gf6\x0b$s\xb1\x08x\x89\xb8\xcc0bv\x17\x8cM`\xd9\
\x93\xe88\xdbj\xc2;\xb3\x8b\xa7\xbf\xff\xbc&1}[\x99\xc8\x19\x0f\x0e\x85\xd7\
\x8e\xdf\xd8\xb6<\xb8wBY\xfb\xd4\x14\x1b\xa9\xe4\x15\xaf\xb6\xdf\xffa\xe67\
\xdb\xc6\xb5v\xf5ouM\xa0k\x18<]\xfd\\\xd69%4\x01\x00\x08\xa0E\x07' )

addArtData('wxART_OUTPUT', 'wxART_OTHER_C', 16,
b'x\xda\x95PmHSQ\x18>\x9a\x1fS1\xa5\x89\xd9B\xc9J\x12\xe6h\x9b\x0bmDh\xdbr+5\
\x99\x8bR(]~\xa4\x90N\xdd\x1de\x11\x98\x1fd \x19\x99&b \xd1\x8f~\x980"\x08"J\
\x86\xfd0\x10$a\x96\x96\xcd\xb9\xef\xdd\xdd\xdd{\xee9\xc3\x92\xd6\x11\xfc#\
\xfd\xea\x85\xf7<\xe7}x\x9f\xe7\x9c\xf7}PUY\x96\x9a,J\x06\x00\xa4\xea\xb4j=\
\xc1\xf4\xed\x14\xec!g\xbe$\xad\x9a@\xdc\xf5\xd2\x8aR\x00\xac\xc3)[\xc6xR\
\x1fj\xd0\xea+\x00\xb8\x9d\x07@O\x1f\x00\x9bQ\x82>\x00,R\x00\xfc\xf5\x00(\
\xc7\x01\xd8oz\\7w\x96\xf4nU\x95\x1b4\xd1h\x14\xf4\xf4d4\x7f,|JO\xcc\xe3\xcd\
6\xe9\x81\x92\x87\x11\x128\x82p\x04\xa2\x08\xe41\xcbc\x06b\x9a\xc5\xc10\xf23\
\xbc\'\xc4\xbbh~#\xc8\xaf\x07 \x8eD\x10\xc2\x1c\x8f9\x88C\x1c\x0e\xb2\xc8\
\x1fF\xde\x10\xef\xa6y\x87\x9fH\x89\x03\x0eC\x1c\x08#_\x08yh\xde\x19\xe0\x1d\
\x01\xf8\xd3\x0f\x11\x8a\xf0\x083\x1c\xa2Y\xe4c\x90\x8b\x86\xeb~\xb8\xe6\xe7\
~x93e\xe92[h\x8eX\xf1k>n\xd5\x0b\xbd\x0cy\x0e:\x03p\xcd\x07\xbf{\xe1\xaa\x87\
c8\xec\xa1\x913\x08\xbf\xb99\x16\xe2N3\xd5\xd1E\xb5wR\xad&\xf3\x8a\x9b\xfb\
\xeafCD\xce /\x836h~\xc5C\x18n\xd9\xc5\xfa\x18~\xd9\xc5\xd9],\x99\x9e\x0c.\
\x9e\x1f\x99%7=\xa5\xaf$\xbbt\xff_@\xf8\x0f\xb1\x9b\xd2.=J \xee1\xd7\xce\x97\
\xa9\xc1`|\xb6\x96\x14I\x1d\xda\x1a3\x00)\xc2\xed\x8c\x01\x13\x93Y\x84L\xa4t\
\x15\x9aD\x87`o\xf2\xe1lA\t[K\xa8\xd7:u\xa9!\xebK\xd3\x82=s\xb6*\xa3\xdf\xe1\
T3y\xfd\xe9G\xb5\xd4\xe2\x1d\xe6Yw\xf4\xbe\xf5\x95+!\xbaz\xf7\x92m\xd9\x94\
\xf9gt\xa0\xd312\xda,,vb&\xebf\xf1\x95\xf6a\xbb\'-N\xe5\x18\xd4\xa6[\xe6^\
\xbc=\x9e{\xac\xfa\x9c\xba\xfcC\xee\xc8\xe8R\xff\xb4\x8b\xcb\xf7&\x94Z7\xd81\
q\xed\x89\x8b\xaa\xf7\xc6}O&Z\xde,\xde\x8b\x9dZ9\xd2\xa1\x1a\x18:\x9d\xa0\
\x1a\xfa$\x8cM\xaan\x197\xce\xd8\x82\x12\xc1\x98x\xba\xef\xe0T\xfb\r\xeb\x8a\
\xf0e\xe2\xe6-\xfd\xc2s\x99\xa8n\xa6\xa8W\xa5y\xe7\xb1\xd9(\xfbdA\xce\x85\
\xdfQ\xb4v\xb5 N\xf4+Gd\xaf!\xdf\xcf\xa34\x97\xa9F#\xd5\xa4l\xe8j"\x00\xe4RY\
\x91D\xaa\x90\xc8\xe5\x06Y\x91R\xa6P\x16\x9e\x14K\xe5J\xa9\xf4T\xf5g\xf7.A\
\x9b\xa9\xb1\xb5\xb9{GP,\x91)\x0c2\xa9\xb2P\xa1\x94\xef\x08\xd4\xdd\xa1\xed\
\x05\x01\x9d\xa6R=s\xa6\xbe\xf7/\xa9\x10\xbd\x17' )

addArtData('wxART_PAGE_SETUP', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\r\t\xf0\tq\xfd\xff\xff?\
CC\xc3\xe4E\xdb\x81\x0c\xcf\x94i\x86\xee\x99\xfbO\xde\xfe\xfb\xf7\xef\x8f\
\x9f\xbf\x9f\xbd\xfe\xfc\xf9\xcb\x8fw\x1f\xbe\xbe|\xf3\xe9\xfe\x93\xb7O^\xbc\
\xbf\xf5\xe0\xd5\xd7o??|\xfa\xf6\xfa\xdd\x97g\xaf>>|\xf6\xee\xee\xa3\xd7\x97\
o>\xfb\xf5\xfb\xcf\x8d{/\xcf]}|\xf2\xe2\x83#g\xef\x9e\xf7\xb8\xfc\x04h>SI\
\x90\x1f\xd0\x8de\x93\xcfZ\x00y\x8cI\xde\xee.\x0c\x1d\xac\xb2\x1e@\x0eg\x81G\
d1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\xcb\
\xe1\xf01\n(T\xee\xe9\xe2\x18"q\xd9\xf7\xbc\xb7\xd0a\x05\x1e\xe6\x80\xc7\'\
\x1c\xf6sN\xb84\xe9\xce\xffy_\xaf8;Z\xdbV&+\xc9\x15\x9e\x13\x14\xd4\x8f\xd0\
\xd1a{\x91\xa8\xff\xd9\xb5\xa3\xe6\xa3\x91\xc2\x11\xed\xee?\x8a\x19\xfb\x1bw\
:w\xdcz_Qr!\xf2\xb7pv\xbb\xee\xd3\x98o\xe2\xab\x0eJk\x8a\xbf\x957i\xe6\xb5\
\xca^o\xc1#Tr\xed^\x81T\xc2\x91\x05\x0e\xcfo\xf5\t\xdfK\x98\xff\xefo\xe3\x99\
\x85\xfaO/\xb2\xf5/]\'\xcb\x0bt\x82j\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\
\n14\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\
\xa1\x81\x95\xb1\x89\x95\x11T\x83K\xe5;\x90\'\x19<]\xfd\\\xd69%4\x01\x00\x95\
\x16\xc5f' )

addArtData('wxART_PASTE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xcd\x0c\xf0\tqehh\x98\
\x91\xc0pb\x02\xc3\x8f\x17S\xf3\x9c\x19\xde\\\xc8{y:\xf5\xf1^\xbf3S\xb9ON`Z\
\xbe\xe6\xe2\xd7\xc7=\xff\xff\xff_\xbe\xe2\x9c\xa1{\xe6\xa7{\xcd\xdf\x7f\xfc\
~\x7f\xa3\xcaa\xc6\x8d\xf7\x1f\xbf\xbd\xbd\\\xf4\xfc\xd5\xc7\xfbO\xde\xce]s\
\xe8\xd5\xd9\xcc\x1b\xf7^>?\x99p\xf1\xc6\xd3\xcf_\x7f\x9e\xba\xf4\xf0\xf5\
\xbb/\x8f\x9f\xbf\xbf\xf3\xf0\xf5\xd5\xdb\xcf\x0f\x9d\xb9\xdb_+\xb5\x04h)cI\
\x90_0\x83\xc3\xb3\x1bi N\x92\xb7\xbb\x0bO\xe3\xe6\xc0d \x87\xb3\xc0#\xb2\
\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\
\xe3R\x92\xe5p\xf8\x18\x05\x14j\xf3tq\x0c\x91\xb8l{.V\xbaI\x81\xa7-1\xe3pQMG\
\xc4\xcc\x99\x91\x7f\xff\xcb\xdfd;T\xfc\xe8\xeb\xbd7\x0eKU\xce\xae\xbc\xd5y\
\x99\xe1\xc4\xfcM\x8c\x0e\xcc\x8b\x0e\xae;\xccl"a\xf2\x9c\xfb\x1b\xef\x86+\r\
\x8b\x17sM\x8b9\xd7\xceT\xa6!\xb0\x97\x9b\xa9L\xe2\xe4\xd2)\x8f\x9e43\xbc_\
\x1ds\xe4e\xd9|\xc9\x14\xfbO\xae^\xdd\ro\xd4\x9f~O\x15\x95\xa8\xee\x8b\xfb\
\x99\x94\x1c\xf0s\xfe\x8b\xbd\xf5\xfb^\x7f\x13>q\xd1n\xbaT\xcb-\xf9\xb6\x1f\
\x9c\x93_\xf9\x1d\xde\x03t\x91j\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n14\
\xb724\xb12\xb6\xd460\xb220\xb0\t>\xfd\x0cECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\
\x81\x95\xb1\x89\x95\x11T\x83K\xe5;\x90\x9f\x19<]\xfd\\\xd69%4\x01\x00MD\xd7\
_' )

addArtData('wxART_PDF_FILE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\x86\x05\xf8\x84\xb8\xfe\
\xff\xff\x7f\xf2\xa2\xed@\xd2\xd0=\xf3\xef\xdf\xbf\xfbO\xde\xfe\xf1\xf3\xf7\
\xb3\xd7\x9f\xdf\xf1\xf0|\xe4\xe1\xf9\xc2\xcd\xfdMX\xf8\x9b\x8e\xce\'>\xbe\
\xf7<<\xafyx^\xf0\xf0<\xe1\xe6~\xc1\xcd\xfd\n\x88\x98\x99\xdf[[\x7f./\x7f!"\
\xf2\x84\x93\xf3!7\xf7=n\xee\xdb\\\\/\xdf|\xba\x0fd31=\xb5\xb3{[WwG@\xe0&\'\
\xe7u.\xae+\\\\\x17\xb9\xb8\x9e\xbcx\x7f\xff\xc9\xdb\xcb\x9c\x9c\x9788\xde\
\xce\x9bwI\\\xfc,\x07\xc7\x19.\xae\x93\\\\\xc789o=xu\x92\x93\xf383\xf3Y%\xa5\
G\r\r\x97\xdd\xdd\xf710\xeccd\xdc\xcb\xcc\xbc\x9b\x8d\xed\xc6\xbd\x97\x97o>\
\xdb\xcb\xc9\xb9\x97\x83c7\x0b\xcb9_\xdf\xc3::\xd7\n\n.%$\xec\xd7\xd4\xdc\
\xad\xa8\xb8EH\xe8\xdc\xd5\xc7\x9b\xd8\xd9\xd730\xecRU}\xbea\xc3\xf9\x8c\x8c\
\xd3\x89\x89W\xdb\xdb\xef\xcd\x9f\x7f\xa1\xb2r\xbd\x92\xd2\xc9\x8b\x0f\x96\
\xb1\xb2\xae\x93\x95\xbd\xd6\xdb{<3s\xad\x9a\xdaR~\xfey\x0c\x0c\xcbdd\x16KH\
\xccbg?r\xf6\xeeJM\xcd;K\x97\x9emi\x99\xc2\xc00\x8d\x91q*3\xf3d\x16\x96\x89\
\x8c\x8c\xfdLL\xbd,,\xd3DDV{xL\x16\x10\xe8af\xeeae\xedfe\xeddemgemeemfay\xf8\
\xec\xdd\x0c\x97>?`l0\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\xbb\xbb0t\xb0\xca\
z\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\
\xd3\xd7\x95\xfd!\x07\x1f\x97\x92,\x87\xc3\xc7(\xa0\xd0.O\x17\xc7\x10\x89\
\xcb\xc9\t\t\t-\xccl\x1c\t)MLni!\x8cbnai+\x18\xb4%6\x18njv\xb5\xb0\xd8\xb9\
\xa3\xb2\xe2\xe7\x0fV\x16\xc9\x993\x1d\x99\x9c\x0e)-Jz$4)\xe8\x92QOB\xf0\x92\
\x94\xa7ODE\xa6N\t\r\xb9z\xe5 \x93\x96\x96\xd4\xac\xa8[V\xbb\xaa~\xadaK`t\
\xb6UN\x16\x0e6.\xe6\xf6\xd6\xce\xde\xd0\xd0\xbbv\xee\xde\xe6\xc5\x937wk\xaf\
\x96\x8e8p\xf7\xf0\xe5\xd3\xb7\x8f_?o\x7f@W@G@DFHJLNPR\xf4\xac\x14\xb3XGo\
\xb7\xbf\x87\x8f\x97\x9f\xa7ow"+\xf7\x92\xf4\x94\xb4\xd4\xe7O\x9e=\x15\xdf\
\xe0\xc4"!\xc1-\xf8\xaf\x95\xc3@\x99\x91\x8d!\xd0I\xda\xc8hN(0"\x18TK\\#JR\
\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\
\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\
\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\x8c\xa0\x1a\\*\xdf\x81\xc2\x89\xc1\
\xd3\xd5\xcfe\x9dSB\x13\x00\xe8\xff\x1eY' )

addArtData('wxART_PLUS_BLUE', 'wxART_OTHER_C', 16,
b'x\xdaUU\t<Tk\x1b?Ce\xc9ze\x1d\xcb$\x92-\x06eL\x14\x19{\xd6$*Y\xc6\xa8\xb1\
\xcc\xc8\x8c\x9b\xc1\xd8\xca\xd8\xd3P\x86\xec\xb2\\\x14*\xdcDL(I!\xe9\x16\
\xb7\x92[\xb7\xfb\x99i\x18c\x19\xc3M\xdf\xab{\xfb~}\xe77\xe7\x9c\xf7<\xef\
\xffy\x9e\xff\xf3\x7f\x9es&\xd3\xc3\xcdAR\\E\x1c\x82 I\'G\x8c\x17\xb8\xcbl\
\x9e\xa2\xc2\xe0\xba\xc7P\xfa(\x04\xc1\xa6\xf1\xb6\xb6\x1ex,\x16\x18\xe8e\
\xf9\xa3.p\x9b\x1d\x83\xbd%\xbe\xdez\xea\x8d\x18\xcb\x8cl_\xae\x8c\xcb\x11\
\x8c\x95}\xe4\xcb\xca\xc3\x8e\x1d\x13+\x1d#\xcdNcoo\xdc\xf9\x90g-}\x9a\xf3\
\x80d#^\x1b\xcb\x1dW\x88\xd3KKM\xf7r\xae\x12\xd1m\x937*_\x93\x16\xbdY{\x95S\
\xa2\xc6H\x96\xd9\xd2\xcb}o\x9aG\x9d\x7f\x960-\xb4\xa0\xfcb\xd1\'\x18R=\xce\
\xed[\xba\xd8\xc3\xe5\xd2\xdf%HH\x9ek\xabV\xf4\xdf\xbdx\x7f!!QJr\x99\r\xa7\
\xba\xae\xa1\xf7\xc4s\xc8_\xdf$N\xf2\xaa\xc3)F\x05M\xe5\xdd{\xcd\x9a\xb7\xbf\
\x1c\xc1#*\xb53\x0f\xb8d\xdd\xc9W\x94\x87\xe7\x9b_\xd4\xc9\x18\xce\xf7\x9bl\
\xcb\xd0\x90\xd3\xe9\xf4,\xd2z\xc7\xa0:gM;\x9f\xf6\xfe\xdb\x89\x87\xd6\x1f\
\x9a\xd2\x18\xd0}\xd5x\xd7\xfaFZ\xec\xd3\xdbT{\x833\x93\x85\xa3\xaa\xc1\x93\
\x83Q\xa5z\xcby_v\xa9\x07\xaa\xd7O\xc5\x1e:\xd7\xbbd\xe7/\xc0\xcb\x16\xa9U\
\x95\xf7\xb2;o\xe90\x17m+?\xd8Z\x9d_\x97\xf67\x87u\xb7L\x90\xea3\xc7\xf4\r\
\x17&\x03\x9e\xd4\xf4_\xf9\xedQ\n\xfc\x8cM\xd4\x94\xb0Y\xaf\xf0\x08E\xe6o\
\xaa\xc2\x96\xbf\xe2\xcd\xd6EQ\xbe\xb8\xf0\x84/}F\xae\xebB\xa7b|\x88>g\xde{`\
&2\xae\x1aUy17`\x1e5J\xb5\xb1\xedv\xf3\xabRo\xa6\xb6\xf2\xc6\xcb\r\x82\x8b\
\x8f\xecx\xd2\xefa\x9e\xbd\x8f\xf1\xac\xa4\xa7U \x0f\xef\xa5\x95^m?\xeb&gW\
\xc2yW\xafVY\xa0\xd95P/.{r\xe5m\xbc\xecq\xccH\x86\x92\xdd\xc4\xfb\xd4 \xf5\
\xdd\t\xa2\xaf\xdf\x87\x8dz\x91.Lt\x8c\xc6^V\xdfX\r\rf\xf3"\x82\x88\xb4\x83\
\xae>\xf7UZ\xae<9\xacQ\xdf\xfb\xc6\x8de\xc1x\xeb\xc4\x9a\x9d\x18\x93\xd9\x10\
\xb6j\xcf}\x98-%1\x0c:\x8e\xc0:z\xb9BPd\x0c\x04\x91*!hc\x06\x82\x92\xbf@\x90\
g.\x04\x83\r@\x90\xf1;\x08R\x0c\x17\xb5\xe87\x82 \xa1c\x1eG\xbc\xed\x98\xcf\
\xd7\x98\xcf\x055\xf7\x96\xcb;\x96\x8aZ\x17\x19\xadK\xf9M\xbc\x9c\xba\x85\
\xec:^Z%7\xa9d\xce\x9f\xca:E\x9d\xf5\xa7\xce~C\xae=\xf8\x86o\x1b\\m\xe9\xe77\
2W\xe8M\x8b\xc0X\xd1\xb1\xfc\xe0\xdb\x16\xbdi\xe1\x1fLZ\x15\x17,(\x0c\x0e)\
\x9f\x03\xf0\x84\x1c\xce\xfd\x91\xd5\xb0\xcc\xcf\x9dOVCi\xac\xb6AAp*\xab\xb5\
\x9f\x1f\x90\xccn\xec\xe1\x83\xf8\xb5]\x9b\x04@\x16p-\xbe\xb5\xc9\x01\xac\
\x01\x1f\x10?\xbbn\x01D\xfb\x87\x03\xf8\xd1\x01\xbdz\xc0m!\xa9\x84\x1b\xc7\
\x98#\xd19\x84K\x9c\xe0\x94\xd9\xc0d6\xd8\xfd\x06c\x81\\\x9dO\x05\x80\xc0\
\xfd\x11\x01\xc8\xd8\xf6x\xb5u\x80\xdf\xd0\xb3R\xd3\xb5\x0c\xc8\x00z\xdd\xc0\
\xfet\xad}H\xd02 hd\xf2AvP\x02H\xc7\x1c\x13\xf4\x8c\n:\x87\x05\x86\x07K\xf4\
\xd0\xf4\xda\xae\x15\xc0\x87\xd1\xca\xa3\x7f\xd3\xa4m\x90\xdf\xda\xbf\xaaoyY\
\xc7\x9cV\xd1\xb1R\x04\xb4\xba\xc1\xcb\xaa]\xd8\x14\xaa\x94\xdb9\xbc\xda\xfe\
\x98\xdf\xfa\x90\xdf\xd8\xbb\xac\xb3\x9f\xa6e\x12W\xb4Y\xc8&\xff\x8bU@\xc9y\
\nc\xaesx\xad\x1d\x04\x19X\xd56\x8d\xd3\xdcK\xcc\xbf\xb1H)\x9c#\x17p\xda\x1f\
\xaf\x1a\x1e*\xd1\xb3\xa4\xeb\xecO\xd36\x8d\xd74"\xa8\xeba\xe1\xbb\xfd\x945\
\xdd\x14\xd40r*hr>\x87\x90\xc3\xd6;@\xdfcN\xdb\xb9\x97\xa8\xa1\x17\xa2\xaa\
\x03v]\x15\xd4m\xe5T,d\x15\x91\xc4\xdc\xcfa\x99\xecF\xe62h%\xa3u\x11\x08\x98\
T:G\xbc\xc4\xc1\xa5\xb1\x9a\x98+\x15\x1dK\xa05@7eMw2\x9d\x13\x96\xf594\x8d\
\x1d\x94\xc2\xaa\xe9Za\xb4\xf0hU\\\x05u\x0c>\x83\x1dJc\x03%\x03\x92f\xb3\xeb\
y@\xde\x1d\xf0\x03\xc4K \xecg\\\x1a;8\x95\x1d\x90<\x9b\xbdY\xec\x02\x99>\x17\
\x99\xc3\xc6]d\x81\xf6%\x82\xba\n9\x84\xdc\xcf\xa0\xa1\x01\xc9\xac\xb0\x0c\
\xf6\xd7\xaf_\xffp4\xea\x03\xc3\xe8@\xf6r\x03\xdf\x9f\x1f\x0f\x98\xce\xe5\
\x8f\x1fs\xb5`\xd4x\xa1\xe2B\xa1\xbc\xac]\xf2\xb1\x13\xfds\xac9\xd6\xab\xfe\
\xd2X+y\xc5\xeb\x19b\x88\xe6b\xb8\x1c\xe2z\x9e\x10\xcc\x1b.\xa6h]\xf1\xe7\
\x07\xba\xb6\x90\xc8\\\xd1r\xe3\xa6\x7f\xb0\x8b\x03\xe6\xd1\x9aP\xdc3\xf0 \
\x16\xe5\xe8G\x82\xa0\xedr\x9b\'\x0c\xbaV\xaa\x04\x8c"d\'W;\x91\x19Q)qM5Q\
\xeb\x85\x13`\xd0M\xe2\xbc}\xc9^A\xe7\x11Q\xd1\xc4P|\x04\x0eA\xa6D\xe1\x10\
\xdf>\x88\xa8\xdc\xf6c\xe1\x84\x8f\x08\x89\x8dQ\xdd\x15\xd1G\xee(7!\x9b\xa9\
\xf5\x80@\xc9\x8bGL"k;\xc6O\xa8\xe0x\x93\t\x89\x05\xdc_\xafp\xeb]\x82E\xc7\
\xd2Px3\xe31!\x94\xccXc\xfa\xad*\x04|W\xaa\xd6\xd0\xed\xceqP\xc1kw\x81\xd1\
\xfa\xf4\xa7C\xdbU\xae\xe6H\xa0\xc4E\xa3R\x02\x1cI-3!\x1a^b\xec,\x035\xa4\
\xc65\x9e\xcf\xceH%W~n&*\xfc@`x\xea|\xc8L\xfa\x88\xb4\xfb\xcfZ\x16\xef4\xcb\
\x951Ra\xe7\xb7\xf6{\xfd\xe7C2\xb7\xefYwt\xe0\xa2UX\x9c,=\xaej\xd9\xfb\xf5,,\
;>\xd4\xc8\xcc5\xc1E_\xf3|B?\x7f\xbb\xf4\x1a\xcacoZCW\xeb\x9f\x9d\xe5\xa8\
\x14\xf5\'\xd7\x96\x8b6\x02gtQ\x06\xf6\xe8\xcc\xa8\xda\xba\xea7\x9e7\xe5\x02\
d\xc5\xe2/4v\x98\nG\xe8\x0b\xeb\xf0~\x83\x97\x97\xe3\x91;\x03H\xa4\x82\xd2\
\x10\xd4\xc72\xb2\xfdT\xc4\xa4\xd5={\xdd\xdc?\x08\x1e\x83\x8e\x18\xbd\x8a\
\x9f\xaa\xdb,]TEfN\xefK\x1f\x95\x80K^\xd8\x17\x80\x0c\x9b\xb4\xf4\xd4\xae\
\xee\n\xdaB\x1czz\xb7v\xec\x9eGi{+\x153\xd18\xc3\xe4\x9f\x1a\xbcC8\xc3\x8a\
\xc1x1\xd7\x0ef00\x8a\xe1w_c\x95C\xe6\xb7M\xbfL\xc7q\xcf\xf2\xcb\x98\xb5\x8f\
D6N4\xc0\xd5{\xbc\x0c\xfeF\x9a3\x9e\xe2\'\xc7?\xf7x\x147<\xb7\x18\xfb\x1d9\
\xb8\xb5v*\xb0\xaf[\xba\x7f\xf1.\x97{\xe149.\xe9\xa0\x08O\xbb\xeb2E\xd5\xf9\
\xcd\xbc\xf0m\xc2r\xd0\x87y\xde\x0b\xce\xd7$L\x8f\xf1C\xccl\xd9Y\xf9\xae\xd5\
\x0e5\xcd\xe8\xba\xee9\xc5m\xc7lG\xe5\xa6\x17<w\x85\x16J\x8b\xdcF\xfe\xf5\
\xcaj\x89\xf7b\xc8\x90\x9f\xb8\xd2\x10\xfdt\xd0\x81z\x89y/u\xfd\xd1\xba\x9c\
\xc6\xef\xf7\xfb\x0cP:\xd3\xbdB\x89\xb3J;\xcf=WS~\x81[\xc4\xe5\xdaW\x8c\x877\
\x17\xb5\t\xac\xe8o\x8f\xf9\x1c}U\x99d\xfc\xe9\xcb\\q\xe1\xfb\x96\xeb\xcfb\
\x03mz\x1dD\xf7\xe4\xe7\x05\xaf\x8a\xd0\x1c\xb1\xd4\xad~\xa5\xdb\xc0\xc4\xc1\
\x9d06\xdeJ/`2\xb0\xf9\rH\n\x18\xa4ed\x1d\x1c\x7f\x92\xdb!$\xbcE~s\xa6\x15\
\x9c\x9c\x9c]\x8e\xb8\xba\xb9+n\xdd&\x02\xc1\x94\x94=<\xbd\x8ez\x1f\xf39\xee\
\xeb\xa7"*\x06\xc1UOx\x9e<\xe5\xed\x7f: 0(\x18\xab&\x0e\xa9;\x9dp>\x15\x82\
\x0b=s\x16\x1f\x16\x1e\x11\xa9\x01\xa9z\x9e$\x10\xa3\xceE\x93\xc81?\x9f\x8f\
\xa5 \xa0\x9d\x0eq\xf1\t>\x01\xd4\xc4$lDdr\x8a&\xb4\x8b\x90z\xe1b\x1a-=#3+;\
\'\xf7\x92\x16\xa4\x9d\xea\x9aw\x99F\xcf/\xb8r\xb5\x90QT\xbc\x1b\xd2q\xbdV\
\x12XZ\x96\x99UN\xc9\xad(\xae\xdc\x03\xe9V\x95T\xfb]\xaf\xa9\xcd\xa6\xd4U\
\xd4\xff\xd2\xa0\x07\xe97\x066]\xaf\xb9q\xb30\xa5\xa8\xb9\xa5\xf5\x96\x01d\
\xb8\x17_v;\xe2N\x1b\xa3\xbd\xe3\xd7\xbb\x9dF\xdb!c\xa4\xc9\xbd\xaeHJ\xf7\
\xfd\x8e\x9e\x86^S\tI\xc8l\xdf~s\xe6\x83\xba\xbe\xe6\xca\xfe\x01\x94\x05\xda\
\x02:`iu\xf0\x90\xb5\xcd\xc3_\x0e\xdbb\xec$-\xec\xad]\xb0\xefI\xe7\xa4\xac\
\x81\n\xdad;_rH\x10\x19\x87\xc6F\xe3\xc0\r21F\x9a\x1b\x1a\x9b\x19\x9a\x98x#\
\xcd\xd1H3\xb4\xa9\x85\xbe\xb1\t\xda\xd8\xd8\xf2\xe8\xf0\xa7\xffs\x88$\x86\
\xe0C)\xff:\xa0\x0c\x91f\xdeHc\xb4\xa9\x19\xda\xe4_\x07\x0ce\x0e\xbc\xc6\x90\
\xee\xa6\x03xk\xd1Xb\x14%\x1a\x7f\xe6,\x19\xb2\xfd\xbeB\xd8DEE\xe0\x0c\x10N\
\x04\xec^\x03\x04\x88\x84\xec+\x96\x93\x06N*\xdf\x9dBp$l4>\x8a\x8c\'\x12\xa0\
\xa3\x14\x02\xd65\x88D\xc6E[z\xf6\x81\xbfD\x08\xfe\x1d\x15\x19D\x88\t\r\xc2\
\x92c\xa2q\xd1?\xc0R\x86p\xfa\x00\xb6\xe3\x7f0b\x08.\xe2\x87\xfdHw\xda\x9d\
\xcdQp\xb2s\xc34\x1f\x0eL\xfd/\x98\xba\x8e\x06' )

addArtData('wxART_PREVIEW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa=\x13\xe0\x13\xe2\xfa\
\xff\xff\x7f\x86\x86\x86%\x9bO\x00\x19\x86\xee\x99\x7f\xff\xfe\xdd\x7f\xf2\
\xf6\x8f\x9f\xbf\x9f\xbd\xfe\xfc\xe1\xd3\xb7\xa6\x8eU\x97o>;\xf7\xe0\xf5\xa9\
\xf7\xbf\x0e\xbf\xfd\xb3\xff\xc1\xfb\x8d\xfb\xafN^\xb4\xfd\xf4\x9d\x97\xbf\
\xff\xfd;\xf6\xe2\xff\xe2[\xffW\xde\xff\x7f\xe8\xf5\xcf\xfbO\xde\x9e|\xf7\
\xf3\xd0\xb3\xff\x9b\xef\xff?\xf9\xea\xff\xa6\'\xffo=xu\xf8\xcd\xefe\xb7\xff\
\x1f\x7f\xf9\xff\xc6\xfb\xff\x8f\xbe\xfc\xbf\xfe\xf1\xff\xaf\xdf\x7f\x0e<x\
\xbf\xfe\xe1\xff3o\xfe\xdf\xfd\xf4\xff\xeb\xef\xff\x9f\x7f\xff=w\xf5\xf1\xd7\
o?\x8f\xbc\xfc\xb6\xf7\xd5\xff\xab\x9f\xfe\xdf\xfb\xfag\xdb\x86\xf5Of\xd8\
\xbc~\xf7\xe5\xd9\xab\x8f\xb3\xa6\xcc>5%\xf9\xc7\x8d\x19\x0f\x9f\xbd\xbb\xfb\
\xe8\xf5\x8d{/\x13l%&F\xf9\xde\xeds;y\xf1\xc1\x91\xb3w\x1fN\xf5\x9cQ\x18X\
\x9c\x91\xe2i!\xf7\x07\xe8/\xa6\x92 ?`\xd8\x94M>k\x01\xe41&y\xbb\xbb0t\xb0\
\xcaz\x009\x9c\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\
\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92,\x87\xc3\xc7(\xa0\xd0lO\x17\xc7\x10\
\x89\xcb\xa1g\xaf\x8b5\x19\x88\xb8\\\x14h>\xd5\xcb{4nC\xf8\x1aFV^\xb3\x7f\
\xff\xe7\xb3\xec\xd4\xf6>\x7f\xfb\xcdt\xc5\x96U[,\x9c8\xce&L\xf9\xdb\xec\xb7\
\xf9\x8d\xf8\x17\x99\xb3\xc7\'51\x16\xce1jKpX\x18\xa1\xc5\xbc~\x06G\xc0\xda\
\xc8\xafn\xc2Q\\\xb7\xe6\xae\xbb\xfa\xfa\xb0C\xa3\xadL\xafz\xf0\x03\x0e\xe3\
\x19\xfa\xd3V\x7fe\x93i\xd1m\xbf\xfb\xaf\xa0e\xb2\x83A\x8c\xfeN\xdb\xf8\x9a\
\x89M\xafY\xafK\x97\xa7T|?*~\xe9o\xc5\xa9\x0fO\xbbY\x98\x84\'?\xb4\xf6jX\x99\
\xb2d"\x7f\xb5\x86\x80Q\x87\xd8\x995@g\xaa\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\
\xa5\x02)\x06#\x03Cs]\x03\x13]#\xa3\x10Cs+C\x13+cKm\x03#+\x03\x03\x9b\xe0\
\xd3\xcfP4\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\x84\x18\x1aX\x19\x9bX\x19A5\xb8T\
\xbe\x03\x05\x04\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00\xa7@3f' )

addArtData('wxART_PRINT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\x8d\n\xf0\tq\xfd\xff\
\xff?CC\xc3\x8a\x15\x17\x80\x8c\xdf\x7f\xfe~\xfb\xf1\xeb\xe3\x97\xef\xef>~\
\xf5Mj[\xbd\xf3\xd2\xabw\x9f\x9f\xbd\xfa\xd88q\xc5\x9cm\xb7j{\x16\x944M\xf9\
\xfc\xfd\xcf\xb3w?o>\xfbv\xf6\xde\x97\xa9\xeb\xaf\xb4\xcc;z\xe8\xda\xa7\xed\
\xe7\xdf\x97M\xdc\xe9\xb5\xd6a\xda\xd2\x9dI\xb5\xcbcl\x15\xd6\x9cx[]h\xfe\
\x0eh\x0bSI\x90\x1f\xd0\xa5e\x93\xcfZ\x00y\x8cI\xde\xee.\x0c\x1d\xac\xb2\x1e\
@\x0eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\xc8\xc1\
\xc7\xa5$\xcb\xe1\xf01\n(\x94\xe3\xe9\xe2\x18"q9\xf6\x9c\xa7P\x83\x02\x8fK\
\xa0"_a\xd7f\x8dW\x7f\xd7k:6\x85\xee\x91\xdd\xbfY\xe1tPW\xe6B\x15\x06\x87\
\xb8)\xa2m\x0b\x16\xa6\x89\xb6)T7{5\xd9g\\(t|\xbda\xfb\x8d\xaf2/\xae\xf3\xeb\
\t\xd4\x1c\xcb\x8c\xcbx*\xa0xIL\xbf\xe2>\xaf\xac\xd0\x8fZ)\xefp\x8e\xba\xfd\
\xf2\xaf\xed\xdd\x12\x16\xbfO\xfe\x11,\x13\xa4\xaf6\x87}\x82\xc4$\xe7\x1e\
\xa0\xbd\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\
\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\
\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&VFP\r.\x95\xef@>c\xf0\
t\xf5sY\xe7\x94\xd0\x04\x00\xb1\xbc\xb5|' )

addArtData('wxART_PRINT_SETUP', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\r\t\xf0\tqehh\xf8\xff\
\xff\xff\x0f\x03\x86\x15+.\x18\xbag\xfeO\xf2\x02r\x7f\xff\xf9\xbbz\xe7\xa5\
\xff\x9d\x85\xdf~\xfc\xfa\xf8\xe5\xfb\xbb\x8f__\xbd\xfb\xfc\xec\xd5G\xdf\xa4\
\xb6\xc6\x89+\xe6l\xbbU\xdb\xb3\xe0\xf3\xf7?\xcf\xde\xfd\xbc\xf9\xec\xdb\xd9\
{_\xbc\xd6:\x1c\xba\xf6)\xc6Va\xcd\x89\xb7\xd3\x96\xee\xd4\xfb\xfb\xc4\x04h>\
SI\x90\x1f\xd0\x8de\x93\xcfZ\x00y\x8cI\xde\xee.\x8c\xff\x99t\xef\x019\x9c\
\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\
\xfd!\x07\x1f\x97\x92,\x87\xc3\xc7(\xa0P\xae\xa7\x8bc\x88\xc4\xe5\xd8\xbe\
\x9bb\r\n\x1c\xacg;6\xf5.\xda\xfb\xef\xbf}\xf1\xc15\xcf\x8e\x16\xef\x94q[\
\xba\xef\xc5\x87\'|\x1b^8\xb1uD4\x1d\x9b\xa2\xcd-\x11\xeb\xf0\xea5\xdb\x05\
\x89\n\xdd\x90wl?\x9a\xf7\xe5\xef\x9e\xd76qM\xabrR"\x8f\xcf\xe6\x08\x8b\\\
\x16n\xef\xfdk\x92\x1e\xce0\xdf\xb8\xe1\xc9_\x0b}\xa5\xa7l\xd7\x99\x7f\xe6\
\x07\x1ez\xfe\xe68\xaf\xfd\r\xf6\xb7Z\xacR\x1b\x81\x16\xab\x96\xb8F\x94\xa4$\
\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\xa3\x10Cs+C\x13+cKm\x03#+\x03\
\x03\x9b\xe0\xd3\xcfP4\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\x84\x18\x1aX\x19\x9b\
X\x19A5\xb8T\xbe\x03y\x8d\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\xbbg\xb9\x94' )

addArtData('wxART_PYSHELL', 'wxART_OTHER_C', 16,
b'x\xda\xad\x90mHSQ\x18\xc7\x8fo\xb94m\x92\xa4\x96FI\x92 \xc2\xbd\xd3\x9c\
\x8d\xa0i[\xdbR\x87/K\xb2/i\xbe\x84\x94NtE/\x06\xa6\x1f\xb4>(\xbd@"%\x85\x05\
F\xa6I\xaf\x14D\x94Z\x98\n\x91\x94\xe5\xeb|\xb9\xdb\xeev\xb7\xdds\xee\xb9\
\x97a\xb5\x8e\xd4\x97\xbe\xf7\xc0s\xfe\xe7yx~\xcf\xe1\x7f.\xe5\x1bu\x11a[\
\xc2\x00\x00\x11\x06\xbd\xa6\x90\xa8|-eA\xe4LN\xddXD$\xf8xV^\x16\x00\x83\x1d\
\xe1?\xcaBH\xbd\xbd\\_\x98\x07\xc0\xb9$\x00\x9aZ\x00\xf0\xf9\x89:\x008E\x01\
\xc0\x96\x02\xa0\xea\x04 \xc6|\xf5\xe8\xf0\x012\xeb\xcb\xcf5i\xfd~?hj\x8a\
\xaez\x93v\x83\xeb\x1a\x15}5T\x9c\xba]"!JX\x94\x10\x96\x90 \xf2\x82\xe8A"\
\xc7\x8b./f=\x82\xcd-\xacp\xc2\xb2KXt"Q\x920\x16\xa1 \xba\xa1\xc8z\xb1\xdd-0\
\x9c`e\t$y\x91\xe8\xe2\xb1\xd3\x8bmd\x98CKN\xc1\xeaD\x0b,\xc2X\x12\xb0\xe8\
\x81\x98\xe3\xb1\xc3\x83\x97]h\x91E\xf3,\x9c\xb3C\x0eb\xd6+,8\xd0\xbc\x03\
\xce\xd8\x91\x1bb\xbbGXr"+\x0b\xe7\x1dh\xd6\x8efl\xd0\x03E\x1b\x87\x19\x97\
\xb0\xe4"\xdb\xe0w\x06\xf2Ht\xf3\xe4i<\xe7\x80\xb3v8\xcd\xc0o\x0c\xcfz\x08\
\x8b\x979a\xdaFJ8\xb5\xc2;<\xc2\xd4\n\xfc\xba\xc2\x13\xeb\xc4\xf5\xa1#\xfd\
\x90\xdc\n,\x85F\xf2\x91\xcc\xff\x8d\xd6\xbb\xa7O\x90\xe5\x01\xc7rt\x1a\xd0\
\x16\x92\xa0\'\xc5\xfa:}I\x03\x00\xe1\x9b\xd62\x00t\xdd\x8c%\xcdP\x8b!O\x1bj\
\x95E\x86%n\xbbb\xb8\xbd@Z/\x0c\x9a,S\xec\xe7\xca\t\xdd\xe6f\xb5\\\xfb\xe9Y\
\xc1XTtH\rU\x1aH\x97\x19;\x1bz\x7f\x9aG`\xfc\xae\xc5\xd5\x9e\x97=\x89C\xb7Z\
\x7f-\xef\xb8\xbe\xca\x0c\xfb2\x0f&\xfb\xb7\xde\xf9\xa5\xa6\xa2\xdb5\xe5\xbc\
F\x91\xd4&\xab\xfe\xa0\x97\x8fg\x1b\x8b\x83i\xff\xc5@\xfd\x06S\xc4\xe5{\xf5Z\
]\xef\x97\xb7\xf9fu\xd1\xbaw\'Kdg\x1egX*\xe4C\xb5\x03\x1d\xf2\xc0\xaa\xfd\
\xb5`\xa4.\xbd;7jgF\xd1S\xa6q\xb0\xaf\xaf\xefu\xcb\xa3~\xf3\xe4P1\x9d{\xe1\
\xf9\xbe\xf8\xa8\xce\x87\xdd\x13\xa3\xda\xc9\xf7\xd7\x9c\\{\xa9\xf2\x89\x8e\
\xde=&\xf5\xddG\x8d\xbc\x7f\xe0\xd5\xf9 WJ\\\xfexd\xb4\x92xH\xb2h\x0f[*\xca,\
\x95\xaa\xf2\xfaJ"@A\xd1\xcaT*=U\xa10\xd1J\x15\x9d\xaeJ\xdb\x93B)T\x14\xb5\
\xb7\xe8#\xf3\x0fPc\xae\xa8\xae:\xfb\x17\xc8L\xa5\xd3M4\xa5J#\x00\xf5\x07H\
\xc8y\x10C\x00`\xd0\x1a5\xfd\xd9\xa5\xcd\xbf\x01"\x9f\xbf\xdd' )

addArtData('wxART_PYTHON', 'wxART_OTHER_C', 16,
b'x\xdaU\x91\x7fP\x8bq\x1c\xc7\xbf\xa3\xae\xa4h\x7f8qE\xba\xe6\xfc\xea<\xab\
\xee\xd8\xae\xecY\x9e\xa7\xed\xb9Z\xfa1T\xa2=\xb6\xd5\x95\x185\\\xd9H\xe4\
\xea\xfcZ\xb8\xe8\x97\x8bHGq\xe1\x8e\xeb\x9cs\x93\xa3\x1f\x0e-\x94v\xb6Zm\
\x8c\xc9\xc4J\xbf>\x9e\x8e\x7f\xfc\xf1\xf9\xbc\xee\xfd\xbe{\xfd\xf1\xb9Oi|\
\x9c\xc8\xc7k\xb1\x17B\xc8\x87\x12\x13\x89\x0c}g\xc6s6\xb3W\x84\xccOb\xe0\
\x96)\x94\x08\x11j>;w\x92vgr\xa0\\\x9c(A\xa8\x80\x83P\xe11\x84~\x03\xc3\xcf\
\x08\xed\xc7\x10\xb2\xcb\x10\xe2_Bh\xa1\xea\\\xfa\xb3h\x84X\x92\xf8X)\t\x00u\
Oz(m\x03\xbe\xf7\xa2$\xef|\xc3\x83\xd6\xe1\xe1a\xa7\xd3\x89\xe7\xd7\x1bL\x9f\
\x84\xbb\xce\x10\x19ET\xc6\x91\x89\x89\x89\xbe\xbe>An\x950G\xb71\xb3\x98\x94\
kI\xb9\x86q\r\x06\xc3\xf4\xf4t\xf3\xe3\xb6\xf1\xf1\xf1\x91\x91\x91\xabz\xa3@\
\xd3\xb4A]\x8b\xef\xb9\x10\x95UJ*\x0e\x8b\x94Z\xf8J\x835\r\x86\x1bEEw#\xf7_\
\xc5U\xe5Q\xd9\'\tea\xb4B[Z\xdd\x08S\x0e\xb0m\x03\xd3&\xe8\x8d\x8f<pM\xb0\
\xaf"j\xd7i\xf5\x99:\xfb\xb7\xef\xe0(\x06s"\xf4\x88\xe0UDWWWL\xc1\x15a\xce\
\xd9\x8d\x99\xc7\xed\xdf\x9c\xf0\xb3\n\x1crp\xec\x04\xfb\x0e\x18\x90B/\x05o6\
@\'>99955u\xbd\xa53:\xbb\x84Th\xe1\x8b\x0c,[\xa0/\x06\xbap\xe8\xe0\xc1`\x8d\
\xd5j5\x99Lccc0\xfa\xd8f\xb3\xb5\xb5\xb5\xb9\\.\x8b\xc5\x02\x0e\x1al\xa9\xf0\
q\x13\xbc#\xf4z\xbd\xd1h\x1c\x1a\x1a\x1a\x1d\x1d\x05\x87\x12>\xa5\x819\x01\\\
o\xe1\xb5\xa0\xbb\xbb\x1b~\xdd\x03\xcbv\xe8\x15\x83\x81\x02k\xad\xd9lnoo\x1f\
\x18\x18\x18\x1c\x1c4\xa5z\xbcg\x9e\xc0R\'\xc6%!\xdc\xda\x931\x13v\xc6\x88\
\x08T\xe2\x1e f\xc2\x9c\xbd\xe2\x94<\x84\xe6=\x9d\x19\xd6sU\x83\x82)=\xd4\
\x94\x84\xf4\xe8\xf7\x9c\xe7\x15\xb4\xa4\x8c\xaa53\xd5\x0b\x8a\x10J\xfd\x0cr\
\xd9\x13/\xbf\x8aK)\xc9\xbd=\xecY\xfe\xd5i\xc6\x88G\x1aO\xd6a\x96p\x19\xcdN\
\xf0\x14\xc5\xba\xb9\xb5\x16\x17\x93Dkp\xf0Q\xcd\xca\xacE)\xbc|\x9avg\x93\
\x1ce-/h\xd5\xcdl\xfbb\xbd\xbe2\xf5\x03\xbf\xa5\x00\xcf#~\xfax\x9f>u\xb4\xf2\
\xbe$\xf6e\'\xb9\xc6\x8fX\xd3\xd4\xb8;\xc7\xf1\xd5\x11\xe0_S\xbd=\x8d\\d4FF\
\x90\x85\x9a\xb5\xaa\xa5\xe9\x02(\xc4O\x04R[\xd9\xecC\x132\xdd\xe6G\xcb\xae\
\xd0\xde\xdet\xbf&\xc8\xc5.Kx\x13\xc4m\xde\xe7\xf4\xbdQ\x12\x1c\xbc\x9cs\xe3\
a}\x8b\xde\xdf^^~\xb9\xacb\x81\xce\xe7 \xef\x85\xffG]5v<]\x9f\xfb{\xecG\xe08\
\xab\xffN\xe0s\x8e_\xd9m\xe6&\x8e\x9aLV+h\xb5\x92/\xcfU2@\xa1\x18w]\x08\x16\
\x1e\x12\x1a*\xe5\xae\xe3s\xc3\xf9a\xbc\xd5X(\x1f\xc3"\x92:\xac\xff\t\xbbU\
\x8a\xac\x8c\xfc\x7f\xc2\xfa\x10n\xb8\x94\x8b\xf1\xc3\x18\x01\xfb+\x04\xc4\
\xdcZ\xc8\x08\x88"\xe3\x88\xdbQ\xb2\xa2?\x1e\n\x85U' )

addArtData('wxART_PYTHON_FILE', 'wxART_OTHER_C', 16,
b'x\xda\x01\x19\x02\xe6\xfd\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\
\x10\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\
\x00\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x01\xcbIDAT8\xcb\
\xa5\x93\xbfkSQ\x14\xc7?\xef\xf5%\xa5-\rJ\xb1\xfe\xa0\xa8XJ\x16\x91j\xd0\xe0\
\x10pQ\xacC\x11\x17\x07I@\xf0\x911\x7fA\x87\x0e\xc5A\x97\xe0\xd2\xf0\xe6\x82\
\x0e\x06:\x08\x15\x07\x89 \x1apT\x07Em&\xa9\x15\xb1I\xf3\xd2\xf7\xce\xbd\xef\
:\xc4J\xaay%\xe0\x85;\x9cs\xbe\xe7\xcb\xf7|\xef=\xf0\x9f\xc7\xea\r\\\xd75\
\xfb\x81m\xdb\xbe^\xa9TV{s\xce\xdf\xa0r\xb9\xdc\xb7\xb9Z\xad\xd2n\xb7\x17\
\x8a\xc5"\xbd$N?p\xbd^\xdf\x13g\xb3Y\x00\xf2\xf9|Fk\xbd\xe0\xban\xe0y\xdeZ,\
\xc1nC?\x15\xa9T*\x03\\\x05\xd6\x06V\x90\xb9p\x91\xdc\x95y\x86\x136\x07F\x13\
\xd4j5\xf6\x1d\xa1W\xc1\xcb\xcf[,\xae\xbe\xe7mc\x13\t\x03\xa6\x0f\x8d17w-\
\xedy\xde`\x1e|a\x8aH\tJ\x04-\xc2\xbb\xf5\r\n\xe7f\x8e\xfdy\x998\x05\x13\xd3\
\xb3\xbcjM\xd2\xf8\xd6\xc2"\xe2\xc4\xc4\x08JB\x94\x08\xe7\xd3?\xce\x98\xad\
\x87\xda\xe8\xed;\xb1\n\x1e5\xc6il\xfcD\x85\x01"!\x12\x06(\x11"%$\xf4\'\xd8\
\xf9`c\x1fY\x8a\xf5\xe0\xfe\x9b\xd7(\tI\xda\x86Bn\x8c\xe1\xa1$&\xd2\x9c=\xae\
\xb0\x83\xe7\xa0\xdb _\'c\x15\x8c:\x06\x7f[xp\xcb&\x9dz\xfa\xbbb@\xf9 >h\x1f\
H\xaaX\x0f.\x9f>\x8a\x92\x90\xc3\xe3~7\x19\tH\xb3{U\x13"\x03#\xb3\xcf\x9c\
\xb8\x7f_\xc8\x9d\xe2\xf6\xa5\x19\x9c\xce\x13hu@kp\xa6\xc0\n\xe1\xe4\xd2"\
\x10\x00\xcb\xff\x10\x94J\xa5=\xf1\xf2\xbd\x1b\x91-M\x1b\xe5\x83\x06\x86\x0e\
v\xb7\xd0\xb2\xee\x0e\xb4\xae\xc6\xe8y\xd3z\xb1n\xbe\xaf\x18\xb3\xb9\xb2c:\
\x1f\x1f\x1bcn\xee\xd6\x7f\x01\x17V\xcd7y\xf0\xd94\x00\x00\x00\x00IEND\xaeB`\
\x82\xb8\xe5\xebx' )

addArtData('wxART_QUIT', 'wxART_OTHER_C', 16,
b'x\xdaU\x92\t0\xdcw\x14\xc7\xdf\xb2\xb2k\x17\x1bA\\\xe3\x08qL\x92e/\xd7\xce\
\xea`\x08\x1b\x16A])q\xadm\xd3\xa4\x8a\x15\x894\xa5\x12Wt\xe2\xa8D\xe2\x96\
\xa4#B\x91&EY\xc7\x92u\x051\x888\x86\x16\x8b\xb5\xa9\x9bd\xb26\xd1?\xedL\xa7\
\xbf\x99\xdf{\xf3}\xf3\xfb\xcc{\xdf\xf9\xbd\x0cOwgE\x9c\x16\x0e\x00\x14\x99.\
\x8e^H>\xbc\x7f\xb1\xb2H4%\x12\xbc\x91\x84\xe6\xd8\xb3\xec\x01j{\xac\xe4n-#Z\
?\xdc\xc5\x8b\x05\x90`\x0c\x90t\x13@\x82\x94\x92D\x00q$\x00q\x08\x00\xfd\x1e\
\x80\xfa\xb7EMg\x19\x002f\x9en>N{{{\x8f\x01*\x00\x1e\x01\xdc\x00\xb8\x06p\
\x05\xe06@\x16@0@\n\x80?@\x00@\x19\xf2@V\xe6\xa9\xe1\xb1\x16\x07\xbb\xe6\xcf\
\x18\x95z:9r\xe8T\x80r\x00\x9e%\xb5\xd2\xd80\xf1\x80}x\x80#\x91geQ\xaa\xa9\
\x1e\x8dP(T\x1c\x02\xeah\xa4\x10\x94\x9a\xad\xc8\xb9\xaaG~\xb7 e)\x13*\r\xf5\
\x13\xf1\xb8<,\x96-+{\x0b\xe0\xc9I\x93tE<\xd2(\xf9\xa0c\x10\x002}\x02@\x91\
\x81\x1e"\xfd\x00b\x10\x13\x18L\x1aA\xe96A!SA\xfe\x9a<\x96\x8d\x96\xf5\x05\
\x98\x7fT\xbe\xbb(\\\x1a\xec_hl\x944<\xff#>\xb6\xd7\xc7s\xf7\xed2\xe2kcv\xb6\
\xab\xac\xbc\xb3\xa0`\xb9\xb4t\xaf\xe6\x97\x0f\xa97\xeb\xc9f\xbbb\xd1\xca\
\xd0\x90\xb0\xaen^ \x98\x13\x08\xc6\xb9\xdc\xf9\xd8\xd8\xf5\xe8\x18IX\xc8B\
\xe5\xcfS\xd5\xd5\x03\xc5\xc5\xbd\t\tB>_\xd8\xd6\xd6\x19\x10\xf0\xea\xc1\x83\
~\x0f\x8f\xf7\xaen\x13T\x8a\xf4a\xf6jk\xe3DMm\xef\xf9`!\x8f\xb7\xc0\xe3u\xd8\
\xda\xae\xcd\xccL?\xff\xed\xb5\x9e\xee4\xf9\x84$\x801fm\xbe*\x12O\xe7\xe5\tc\
bE/^\x88\xba\xbb\xa7\xc8\x94qN\xe4\xf6\xc6F\xb39I\xa0\xaa\xb4\xc5\xa2\xbe\
\xb1\xb3X\x99\x13N\x9e\xffb18p\xb6\xb0x\xb6\xb0h\xd2\xe4\xf8\x90\xb9\xd9\x86\
h\x89\xef\xe1\xd9*/\xf7\x97\xaf\xed$\xc5t}k{\xcc\xf5L\x0f\x1a\x04\x9ax\xbe*\
\xbe\x1e\x05=\x0c\xdb\x9d\xed\x9dvk\x9b\x16\x1cf\xdc\x9f9\xa3wD\xdc\xd0\xb42\
4<\xa0\xad\xdd\x02\xd0\x00\xc0WQ\x15w\xf7\xac\xf6\xbf\xac\x97\xc7<SQZpgL\x98\
\x1al\x8e\x8d\xaf\xcd\xcf\ts\xef\xccg\xe5nL\xcf\xbc\x9b\x17v\x11\xcd\xda\x14\
\xe5\x7f\xa5\x91f\x18\xc4I#\xbd\xe5\x8c\x8c5A\xd7zw\x8f(7\xa7\xdf\xd0\x80\
\x8f\xc3\xde\'(v\x98\x19\ri(\x8f\xaa\x11\x86\x95\x15\x04\x87d\xeb\xf0\xd8t\
\x05\xdc\x85>\x13<\xb2Rv\\/\xf7\xfd\xed\xfb\xef\x98\xe6/J$\xa2\x12"gg\xf72\
\x9as\xf9\xc4{)\xe5n\xd5\xd2\xbaD*\x91.o\x96>3\xdb\xfdH\x8f\xbd\x81B_\xf9\
\x94\x86\xa3U\xaeK\xa5\x9bO\x19+\xf8D!B\xa2\xc2\\\x9d\x1d!]N\xc7\x05\x11\x18\
.\x93\xe5\x84\x99\xc5*\xe1\x0cts\x98e\x7f"%1\xd3\xd1\xdeGc$<\xa4\x1d~t\xeb\
\xe7}\'\x95Iv\xe808U}1\x04u\x96\x8cq6\xe1\xa8\xfbE\xcb3\xb3\xe1\xa7\xbc\xc2\
\xe6\xb4\x8a\xfc\x86\xac\xda\xd26\x9a\x8b\xddi\xcbvC\x92\xa9\xf5q\xda)\x86\
\x83\xbb\xaei\xd9\xe1ee5\x1d\x15m\xf5\xd2\xec{y\xd5XU\xcf3L\xd6\x96\xdb\xab\
\x9e\xfe\xbe\xc1\xde\x01\xefC\xb8\xc7Bu\xd5\xa3j\xf9yw\xef\xf8\xf9\xf8V\xca\
\xc8\x8d>\xf9\xfa\xc2[\xb1\xb6Va\xc1\xb9\xc0\xa9\xd1\x1fd\xb4Vt\x8a\x83\xa6m\
[\xae\x7fT1v\x1fF\xe3\xbed\x95P\xe2&\xb75\xa9\x9c\x81\x12j|\x89\xa5\xa7\x9ds\
\xfc\xa7\xe4\x94\xcc\xa3\xe6\x01M\x17?\xe0l\xaf\x97A3\xbf\xef\xf3\xaa7\xd5A\
\r\xdfwv\xb1RO\xdb\xa1\x94\xc2UF\x06\xce\xd5\x7f3\xd5\x1a^q\xdf\xc6\xc4%)\
\xf3u\xc7p\xdfd\xd7\xd8`Ia\x9a\xca\xc8\x16\x04\xbes\xb4<\x96\xcf\xd5F\\\x1bq\
\x9d\xfc\xb9\x11\xa1\\6=<\x86\x8d$\xa0\x90\xc8VD\x12\x8dH\xa1\xf8\x90\xad\
\xe8d\x1a\x9djs\x92D\xa1\x93H\x0c\xef\x97\x8b\xff\x03.EE|\x15y\xf5_\xc0\x9aH\
\xa6\xf9\x90It*\x02\x90\xfe\x01t\\\xab\xd4\x11@s\x1f\xf0\x8e\x8a\xe4\xc6\x87\
\xc6\xb0\xc1>"*\x8c\xad\xcf\xbc\x14\xcaa{\xb1C#\xaeF\xf7\xb2\x19\xfb\xff\xca\
trw\xacq\x08I\xfe\x1bK(\xd6\x9d' )

addArtData('wxART_REDARROW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86v~\x06\x86\x1e \xfe\x0b\xd4\xd4\xe8\xc0\xc0P[\xc9\xc0\xf0\
\xb2\x9b\x81\xc1\xe6)\x03\x83\xe4\x99b\x9b\xd6r\xa0Z\xef\x00\x9f\x10\xd7\xff\
\xff\xff\x03\x99\xff\xef\xdf\xff\xdf\xdf\xff\x7f\xfb\xf6\xff\x01\x01@\xfe\
\x7f\x05\x85\xff\xef\xdf\xff?\x7f\xfe\x7fB\xc2\x7f\x0e\x8e\xff\x16\x16\xff\
\xa7O\xff\xaf\xa1\xf1\xff\xf8\xf1\xff\x11\x11\xff\x05\x04\xfe\xd7\xd7\xff\
\x7f\xfe\xfc\x7f{\xfb\x7f\t\x89\xff\xcb\x97\xff\xf7\xf0\x00\x9aS\xcd\xc5\x1d\
\x034\x8b\xa9$\xc8\x0f\xe8\xb4\xb2\xc9g-\x80<\xc6$ow\x17\x86\x0eVY\x0f \x87\
\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\
\xb2?\xe5\x10\x16\x94\x14H\xbe\xf4X\n(\xe4\xe5\xe9\xe2\x18"q99AA\xde\xc0pqAd\
\xc4\xcd\x1b\x826|ieff-\x0c\xea\xe2\xe6\xd2B\t\x0f\x12\x9dYy\xf6\xd4d0\xf1\
\xf0\xfcaJ\x98\xb6@@\xa2\xa1WPL0\xd5y\x1b+\xcb\x91#7\rc\xdc\xa6\xfc\x96\x944\
deH\xaae:\x1a\xb5B\x03\x14p\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\
\xc0\xc8P\xd7\xc0B\xd7\xd02\xc4\xd0\xdc\xca\xc0\xcc\xca\xc4T\xdb\xc0\xc8\xca\
\xc0\xe0\xe6\xc5%SQ4\xe4\xe6\xa7d\xa6U\xa2i02\xb524\x83hH\xba\xcf%\x04\xd4\
\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00q\x7f\x8bP' )

addArtData('wxART_REDO', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\r\x0c\xf0\tq\xfd\xff\
\xff?CC\x83n\xfeW\xc3\xac\xa3\xce%wt\xe3\xcfM\xd8\xf8-k\xc6\x97\xc0\x86\x87!\
M\x0f\xa3\xda\x1f\xc7\xf7<M\x99\xf0\xcc\xb9\xe0bD\xd7;\x06\x83\x19.\x05\x97R\
\xfa\x9f\xc5u?M\xee\x7f\xc6\xe0t\xc2(f}X\xeb#\xa3\xb4\xeb\xc6\xe9\xd7\xb5B\
\xb7\x83L\xab\xaf\x01Z\xca\xc0T\x12\xe4\x07t`\xd9\xe4\xb3\x16@\x1ec\x92\xb7\
\xbb\x0bC\x07\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\x0c\xc2\x8c\x0c\xb3\
\xe6H\x00\x05\xd9K<}]\xd9\x1fr\xf0q)\xc9M\xf4\\\xf0\x00(T\xe2\xe9\xe2\x18"q9\
\xf5\\\xb4X\x93\x01\x0fK\x80\xd3\xac\x05I\xc2\x8dW\x8e\xff3\xd7\n\xb6\xccH\
\xdd7\xab\xfaS\xc6uY\xa7\xec\xaa\xb4w\x1f\x17py\x8a<\xdc\x9a\xd6\xc0Se\x15\
\x7f,;-\xc9A\xea\xca\xa6\xdf\xb9s\x8c\xb4\x1d\x02\x84+\xe7\x89\x9b:\xac\x10]\
\xf3\xf9\xf7\x9e-\x0b\xd2\xb6\xf52\xecY\x16\xd7\xe9\xcf\xfe\xf6\xbf\xc0\xc6+\
\x0cG\x17oq\xf8\xa8\xa3\xfb\xe7K\x8e\xc3\xc7_\x87\xe2\xef\xed\xb6c\xf9\xfcX|\
\xb1\x1f\xd0~\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\xaek`\
\xa2kd\x14bhnehbel\xa9m`de``\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\xa8\
\x06\x0b]C\x93\x10C\x03+c\xa0\x06\x03\x88\x06Y\xef\xd5\xe2@\r\x0c\x9e\xae~.\
\xeb\x9c\x12\x9a\x00\x11O\xaa\xea' )

addArtData('wxART_RELOAD', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba100\x95\x05\xf8\x84\xb8\xfe\
\xff\xff_\xd1\xadO\xde\xb1E\xc6\xbar\xc2\x8eo\x92\xa6\xb9\x9d\x9b\xbf\x1ag\
\xdf\x127HjZ\xff\xa5f\xf5g%\xb7\xfe\xd2\xe5\x9f\xe5\x1d\x9ae\xad+\n\x16}V\
\xf1\x9e)c]\x915\xef\x93\xa2[\xbf\xbcC\x8b\xacu\xa5\x88VX\xea\x9c\x8f\x893?\
\x8a\x19$\xc5N\xfb\x185\xe5\x033\x1b\xf7\xce+\xbf\xb7^\xf8\xb5\xfe\xcc\xaf\
\x95\'\x7f\x1e\xbd\xfdg\xcb\x85\xdf\xeb\xcf\xfeZu\xf2\xe7\xe2\xa3?\xe6\x1e\
\xf8\x0e\x14\x81s\xe7\x1c\xf8>m\xcfw\xa0\xd5@A Zy\x02(\xf8s\xee\x81\x1f\xd3\
\xf6|\xeb\xdf\xfe\r\xe8\x98\xa6\xf5_\x81\xe2\x87n\xfe\x9e{\xf0\x07De\xc7\x96\
\xafM\xeb\x80n\xfb\x02\x14\xdcw\xed\xcfV\xb0\xe1@q\x88\xe2\x9aU_\x80\x0e\xde\
w\xed\xf7\x863\xbf\x16\x1f\xf9\x01R\xb9\xeaK\xd9\xb2\xcf\x05\x8b>\xed\x82\
\xb8\nh\xf5\x89\x9f@\xc5@\xf1\xac\xf9\x1f\xc1"?W\xc2\x1c\x034\x16\xa8\x18(\
\x9e:\xfb\xe3\x06\xb0\xf8\x12\xb0\x9b\x81\xee\x01Z\x01\x14L\x98\xf1q%\xcc#\
\x10A\xb0\xbd_\x12g|\x88\x9d\xf6\x01\xear\x88\xe0\xba\xaf@\xd3b\xa7\x7f\x98\
\x00\xf2\xc87\x90\xdb@\x86\x7f\x01\x06\x11PA\x07\xd4\xb5\x9f!n\x03\n\x82\xd4\
\xac\x83\x8a\xe4/\xfe\x9c=\x0f\xe4\x06\xa0\xb1q\xe0P\x85#`\xec\x18e\\5L=\xaf\
\x9ftB7\xfe@\xf5\xc2\x17U\x0b\x9eV\xcc}T:\xfb\xaev\xd4\xf6\x05{?\xce\xdd\xfd\
n\xd6\x8e\xb7E\xd3oj\x86\xae;t\xf3\xcf\xac\x1do\xa6m}\x997\xe9\x8az\xe0b`\
\xb0\xec\xba\xf2k\xd2\xa6\xe7Y}\xe7T\xbcg\xed\xba\xfc\x0b\x18\xa1\xc0\x04\
\x00\x0c\x19`\x1c\xc996K\x9a\xe5B\xdc\x03L\x00\xc0\x98-X\xfcYD+\xdc=cAL\xcb\
\xb1\xac\xf9\x9f\x04U\xbd\x9d\x92g\x867\x1c\x0e\xaa9\x98:\xe7\x13\xbf\x82\
\xa3m\xdc\x94\xe0\x9a\x03~\x15{\xbdJw\xf3H\x9bYE\xf5\x9b\x85u\x1a\x07\xb5\
\x1a\xf872\xb3\xf2p\x8b\xe9p\x08*\xb3\xf1J\xb3p\n1\xb3r32\x81\xd2(0\xc9\x9d\
\x96_\xbe\t\xc8\x9aX\x12\xe4\x07J\xc5\xb8\x81\x82\xaa$[\x8c}\x88\x9f\xb3d\
\xabC\xce\x84\xfd\x8b\x94\xa4\xf6\x1bW\xec\xbfuk\x86@\xce+\xa3%\x97\xde<\xf4\
\xdd\xfd\xfd\xce\x14\xaf\xd3\xcf?\xf7\xdc8\x13s\xf0\xcb\xef\x0b\x07\x7f\xff\
\xbe\x10s\xe3F\xcf\xab\xef\xd7\xbd\xa6<\xf9\xb9\xdbw\xd9\x9b\xd7\x1dF\xafr\
\x04*V\xbf\xbaUa\xbc_J)~\xf5\xb9~\x87V\xc9\x82\x8a\x10\xfb\x18n\x05c;gGy6\
\x01I)\x08\x90\x14\x158\xf2\xe9k\x1c\xd0j\xc6$ow\x17\x86\x0eVY\x0f \x87\xb3\
\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\
\xe4\xe0\xe3R\x92\x9b\xe8\xb9\xe0\x01P\x0f\xbf\xa7\x8bc\x88\xc4\xe5\xe4\x84\
\x03\x0c\xc2\xea~sL*O\x85DZV\xb2\xba\xa9\xa5\x89\xb1\xb1\x1d\xed\xbc\xbc\xec\
\xfc\x0cKo\xcfH\xd7\xd0\xde\x99S{\x1b\x1bck\xbf\xcd\xd9\xf9\xf9YvFV\xe6\xeb\
\x17E\x05F\x06/^\xeaG\xec\xc8\xf8(\xc4\xec\xac\x9c,\x1cl\xac\xc7\xc6V\xdc\
\xbd\xf4\xf4\xb4\xf5\x11\'s3Ss\x93\xb3\x8f\x1f>\x90\xf0~\xc3\xa9\x8b\x99_\
\xa5\xe2\xec\xd2\xc5\xc3\xcd\xcb\xeb\xd8\xd8\xfa\xb7\xbe\xb6a\xdds\x8d{SQ\
\xc5\xef\x1f\xbf8\r\r~\xb0\xb3\xb0qvw\xe4q\x88q\xdf\xdc\xa1\x192\xa7QQ\xc7F\
\xc9\xc8kB\xe9\xe7i/f\xac\xddX(\xc4\xc3\xf3\x91\xb3\xd3\xf3\xa4\xe6\xa4\xdb\
\xdb\xde\xdf\xd8el\xea\xdb\xd5\xa8h\xabl\xacm\xad^~\xfd\x9dm\xf5\xf7\xa7O\
\xbd\x8d\r8\xc4E\xc4D\xa7Oyg_\xf0\xe1\xc2C#\xc9\x05\x0c\xeb\x13*]SC\xbfN\\|\
\xbco\xbeE$\xb3\xc8\x83\xd5kW\xe7g\xe4X\x95\xfe:s\xb3\xf8\xb9\xbe\x89\xb1\
\xc1\x86-[\xb6m-/)+\xfd\xfe\xe5\xdb\xb7\xaf\xfe\xc0\xf8;\x19Q;g\x07\xe3^`h\
\xa9\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\xa3\x10C\
s+C\x13+cKm\x03#+\x03\x03\x9b\xe0\xd3\xcfP4\xe4\xe6\xa7d\xa6UB5X\xe8\x1a\x9a\
\x84\x18\x1aX\x19\x035\x18@4\xc8z\xaf\x16\x07\xa5\x16OW?\x97uN\tM\x00\xd2\
\x11\x81\xd6' )

addArtData('wxART_REPLACE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8W\xf3;p2\x90\xaf\x90\xec\x11\xe4\xcb\
\xc0P\xa5\xca\xc0\xd0\xd0\xcc\xc0\xf0\xf3?\x90~\xc9\xc0Pj\xc0\xc0\xf0*\x81\
\x81\xc1j\x06\x03\x83x\xfe\xa4\xf8\xa3n@\xb5\xa2\x01>!\xae\x0c\r\r\xff\x81\
\x80\x01\x0c\x0cf0\xac\xe3\x01\xf2\x96O\xa8\x16\x04r\x99J\x82\xfc\x82\x19\
\x18\xca&\x9f\xb5\x00\xf2\x18\x93\xbc\xdd]\xd8\x12\xd3v\xd4\x029\x9c\x05\x1e\
\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\xfd!\
\x07\x1f\x97\x92\xdcD\xcf\x05\x0f\x80B^\x9e.\x8e!\x1c\xd7\x93\x13\x12\x02\
\x92\x1a\x98\xd4L\xd86\x1bN\x9e\xc4\xd4\x91x\xe0\x0c\x8b s\x97\x83D\x81`r\
\xb2r\x87\x94E\x82c\x9a\x84\xf4\x066\x06I\xbe3<l\x8ckxt\xf4\xf4\x1c&2LP\ta\
\xc9Yf\x18\xd0\xab \xc2\xc0\x10\x92\xcf\xf6g\xe7gIK\xa0\xa9\xaa%\xae\x11%)\
\x89%\xa9V\xc9E\xa9@\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\
\xd0\xc4\xca\xd8R\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\
\r\x16\xba\x86&!\x86\x06V\xc6@\r\x06\x10\r\xb2\xde\xab\xc5AA\xe1\xe9\xea\xe7\
\xb2\xce)\xa1\t\x00p\xcdg6' )

addArtData('wxART_RESET', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Re`hhf`\xf8\xf9\x1fH\xbfd`(5``x\x95\xc0\xc0`5\x83\x81A<\x7fR\xfcQ7\xa0Z\
\xdd\x00\x9f\x10\xd7\xff\xff\xff\xff\xfd\xfb\xf7\xc7\xcf\xdf\x1b\xf7_\xfd\
\xf5\xfb\xcf\xb7o??~\xfe\xf6\xe6\xfd\xd7\xe7\xaf?m\xbc\xbf\xdfn\xa3#\xe3L\
\xc6\xd63>yG\n\x81*\xfd\xbc\x9c2\x80\x1a9K\x82\xfc\x82\x19\x18\xd9uYE\xd4\
\xec\xd2\xf8E$\x17\x03\x05\x19\x93\xbc\xdd]\xf8\xf2\xf7\x1a\xf8\x83T\x14xD\
\x1630p\x0b\x830#\xc3\xac9\x12@A\xf6\x12O_W\xf6\x87\x1c|\\Jr\x13=\x17<\x00\n\
\xb9y\xba8\x86p\\ONp`d\n\x98\x15\xc8\xe8t>j\x0b\xa3O\xf1\xbb{\xbc\x89g\xc4nm\
>\xc8p\xe4\xc6\n^\xd1F\xe6\xeb_\xd8\x0c\xce\x1e\xda[\xcdl\xdeq\xf0T\xed\xacD\
\xfd\x88\x8e\xea\xef\xef\xb8\x05\xd8\xaeG\xb1\xeda`\xb8\xf2M\xc02\xf8UG4\xd0\
D\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\xaek`\xa2kd\x14bhne\
hbel\xa9m`de``\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\
\x10C\x03+c\xa0\x06\x03\x88\x06Y\xef\xd5\xe2@\r\x0c\x9e\xae~.\xeb\x9c\x12\
\x9a\x00\x89i\x88\xe1" )

addArtData('wxART_REVERSE_ALL_CONTOURS', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x10X\xb0`A\x03\x03\xc3\xff\xff\xff\
\x1f\xee\xdc\xb1\x10\xc8g,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\
\xe4\xb0\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9b\xe8\xb9\xe0\x01P\xc8\xc1\xd3\
\xc51\x84\xe3zr\x02\x03\xa3\x1b\x9b\x86@\xc3%\x1f\x81\xae@\x01\xb5\x05\x1a\
\x07\x0e\xf0\xa4qp\x1aH8l\xe108\xbc\xc5\x81\x95'\x81\xc9-\x80\x91-\x99uEYr\
\xb2H\xf1\xc2\xa8\x86\x86\x99\x8c\xa2\x0c\x0c\x9b\xee0-\xed\x0b\xec\x9f\x054\
K\xb5\xc45\xa2$%\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1aX\x00Q\x88\xa1\
\x99\x95\xa1\xa5\x95\xa1\xa9\xb6\x81\x91\x95\x81A\xe0\x8fsa(\x1ar\xf3S2\xd3*\
\xe1\x1a\x0cMB\x0c\r\xac\x8cM\xac\x8c\r \x1ad\xbdW\x8b\x83\xfc\xea\xe9\xea\
\xe7\xb2\xce)\xa1\t\x00\x17\x0b]\xf2" )

addArtData('wxART_REVERSE_CONTOUR', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x10X\xb0`\xc1\x7f0\xe0_s\xec\x04\x90\
\xcfX\x12\xe4\x17\xcc\xe0\xf0\xecF\x1a\x88\x93\xe4\xed\xee\xc2\xd2\x9fq3\x10\
\xc8a/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$7\xd1s\xc1\x03\xa0\x90\x8d\xa7\x8bc\x08\
\xc7\xf5\xe4\x04\x07V\xa7\x80Y\x81\x8c\xa1\x0e\x01\x02j\n\x1c\xc1\x07O\x1cP`\
\x08;\xd8q\x81IH\xa0e\xa6\xa2\xce\x01\x96@E\x8d\x03K\x18B\x0f.a1\x9d\xe2\xe9\
\xd9\xc8\xc8\xcd\xc0\xd0>\x8bI\xf5\xec\xe9\xc9\xd3\x80\xe6\xa8\x96\xb8F\x94\
\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x0b \n14\xb32\xb4\xb424\xd560\
\xb220\x08\xfcq.\x0cECn~JfZ%\\\x83\xa1I\x88\xa1\x81\x95\xb1\x89\x95\xb1\x01D\
\x83\xac\xf7jq\x90?=]\xfd\\\xd69%4\x01\x00\x1a\xde_\xed" )

addArtData('wxART_REVERT_TO_SAVED', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\x9d\x13\xe0\x13\xe2\xca\
\xd0\xd0\xc0[&\xcc\xc2\xc2\x12\xbd\xba\xe0\xff\xff\xffw\x9e\xdf\xd9y~\xd7\
\x8a\xc3+L\xdb\x1c\x19d\x19"\x96\xe7|\xf9\xf1\xf5\xc6\xd3\x9b[\xcfn\x9b\xbbg\
\x1eP\x93\xf7\xec\x98\x07\xaf\x1e\xec\xbd\xb4w\xd6\xce\xd9\x9d\xeb:\x95J\xb4\
\\\xa7\x86\xd8O\xf05iq\xd0\xa84T*\xd6\x92\xcdU\x16\xb0\xe7\x14O\x97\xb1\xect\
;v\xf3\xb8`\x92\x88q\xb3\xdd\x8b\xf7/\xf6]\xda\xcf\x1d\xcd;y\xd1v\x99(\x0bC\
\xf7\xcc\xfd\'o\xff0`\x00:\xe7\xd9\xeb\xcf?~\xfe\xbe\xa0\xc5\xf0\xf9\xcb\x8f\
\x97o>\xbd\xfb\xf0\xf5\xc9\x8b\xf7\xf7\x9f\xbc\xfd\xfb\xf7\xaf8\xd7\xb2\x0f@\
+\x19K\x82\xfc\x82\x19\x1c\x9e\xddH\x03q\x92\xbc\xdd]X\xfa3n\x06\x029\x9c\
\x05\x1e\x91\xc5\x0c\x0c\xdc\xc2 \xcc\xc80k\x8e\x04P\x90\xbd\xc4\xd3\xd7\x95\
\xfd!\x07\x1f\x97\x92\xdcD\xcf\x05\x0f\x80B\x13<]\x1cC$.\xfb\x9e\xb9.vH\x81\
\xa7\xe1a\x83E\xc1\xd5X\xf6\xa8p\x97\t\xd7.~\xaf7o\xbe\xa0\xfc\xff\xa4\xef>a\
\x06\xb1\xc72NkTo\xcd\xcd\xf3g*\xf8!\xf9\x9a\xbfmq\xa1\x1b\xc3\xc3\x0e\xdfe\
\x9b\x7f&\xbd\xd4WZ\xf3\xe9k\xda\xee\xc9\x17\x8e\x14\xb9\xbe\x15\xb6X\xb1&\
\xe08\x8b\xdf\xab\x9a\xc0\xf0N;~sI!\x91W\x15\xadJ-\xdf52t\xd6\x1e{\xa4\xccu\
\xc9\xe9q\xc0k\xb6\x16\xcd\xb5\xab\xe7upN\xb9\xfa\xfa\xef\xc1\xff\x93o\xcdby\
\xd1}+\xf2\xf1C\xee=\x11\x02\x96\xcc\xf5sg\x02\xdd\xa6Z\xe2\x1aQ\x92\x92X\
\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\xcd\xad\x0cM\xac\
\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\
\x12bh`e\x0c\xd4`\x00\xd1 \xeb\xbdZ\x1c\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\
\x00\x0f\xca\xe1\xf3' )

addArtData('wxART_SELECT_ALL', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa\r\t\xf0\tq\xfd\xff\xff?C\
C\xc3\xe4E\xdb\x81\x0cC\xf7L\xa0\xfa\xbf\x7f\xff\xee?y\xfb\xc7\xcf\xdf\xcf^\
\x7f\xfe\xfc\xe5\xc7\xbb\x0f__\xbe\xf9\xf4\xe4\xc5\xfb\xfbO\xde\xdez\xf0\xea\
\xf2\xcdg\xbf~\xff\xf9\xfa\xed\xe7\x87O\xdf^\xbf\xfb\xf2\xec\xd5\xc7\x87\xcf\
\xde\xdd}\xf4\xfa\xc6\xbd\x97\xe7\xae>>y\xf1\xc1\x91\xb3w]\xd2\x82\xe5\x81\
\xe63\x95\x04\xf9\x01\xddX6\xf9\xac\x05\x90\xc7\x98\xe4\xed\xee\xc2\xd0\xc1*\
\xeb\x01\xe4p\x16xD\x1630p\x0b\x830#\xc3\xac9\x12@A\xf6\x12O_W\xf6\x87\x1c|\
\\Jr\x13=\x17<\x00\n\xe5{\xba8\x86H\\\x8e\xed\x8f\x14jP\xe09\xea\xa5\xdbm\
\xad\xf4\xee\xfb\xfe\xe5^\x81\xd6\xfb\xce\xab\xa4\xb21\xfcY6\x85\x89Ag\x9eb\
\xea\x82J6\xdd\x93\x87,tt;\x0f\x85z\xb8\xe4'\xc6\x84\x9awl\xba\xb0\xeb\xad\
\xd1\x8e/oo\xaf\xfb/z\xcbX\xe2\x90\xc4c\x13\xfd\xd5\xf7%Z\x8e\xe7[7\x7f\xbct\
\xf2={\xf3\x8f}\x89\x92w\x9e\x9f\xbc\xcd\x93\xf6\xf1>\x8b\x07\x9f\xdf\x9eEl^\
\x07\xdc\xf5\xf7\x03\xadV-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06&\
\xbaFF!\x86\xe6V\x86&V\xc6\x96\xda\x06FV\x06\x066\xc1\xa7\x9f\xa1h\xc8\xcdO\
\xc9L\xab\x84j\xb0\xd054\t14\xb02\x06j0\x80h\x90\xf5^-\x0e\xd4\xc0\xe0\xe9\
\xea\xe7\xb2\xce)\xa1\t\x00\x13\x12\xbf\xfc" )

addArtData('wxART_SET_STARTPOINT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x86\x05\x0b\x16\xfc\xff\xff\x1f(\x00\
$\xb5W\xc5e\x03Y\x8c%A~\xc1\x0c\x0e\xcfn\xa4\x818I\xde\xee.,\xfd\x197\x03\
\x81\x1c\xf6\x12O_W\xf6\x87\x1c|\\Jr\x13=\x17<\x00\nyz\xba8\x86p\\\xcf\xed=\
\xc8{\xc0\x80\x87\xc9so\x83\xa6rE\xa3\xd7\x9b\xfd\xd1s\xa3\xfe\x1e]/<\x87\
\xb5\xc0f\x12\xf3wQ\xe6\x95L{&s4\xf9F.5{[\xb6m\xc9\xa4\xbb\x9c\x87\x1e\xfc\
\xba\xd7rfn\x82\xed]\xde?\xc2V|\xfb\xcd\x97\xb0\xe4\xec\xff\x94\xb8\x13h\xa8\
j\x89kDIJbI\xaaUrQ*\x90b0204\xd75\xb0\x00\xa2\x10C3+CK+CSm\x03#+\x03\x83\xc0\
\x1f\xe7\xc2P4\xe4\xe6\xa7d\xa6U\xc25\x18\x9a\x84\x18\x1aX\x19\x9bX\x19\x1b@\
4\xc8z\xaf\x16g\x00\xb9\xdb\xd5\xcfe\x9dSB\x13\x00\xce\xa1m\xfd" )

addArtData('wxART_SORT_ASC', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5&\x07\xf8\x84\xb8\
\xfe\xff\xff\xff\xd3\xb7\x9f?\x7f\xfdy\xf7\xf9\xc7\xab\x0f\xdf\x1e\xbe\xfat\
\xf3\xf1\xbb\xef_~>\xb8\xfc\xf2\xf9\xbdw\x01M[B[\xb7\x15\x15\x15\xed<\xfb\
\xb0r\xfe\xd1\xb4\x89{\x0f_yZ\xbd\xe0\xd8\x9a\xc3\xb7\xe7\xef\xba\xd6\xbc\
\xec\x94O\xfd\xa6M'\xeey\xd5n,\x9auh\xea\xe6\x8b\x9d\x91\xab'\xa6l\x9c\x99\
\xbf\xed\xc6\x89\xc7\x07\x96]\xda0\xe18\xd0\xfcS\x1d\xe9\x9c@\xeb\xb8J\x82\
\xfc\x82\x19$Y\xd5\xec\xea\x0fJ~?\xb9\xed\xff\xe3\x8d@Q\xc6$ow\x17\x86\x0eVY\
\x0f \x87\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\
\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9b\xe8\xb9\xe0\x01\xc8\xe5\x9e.\x8e!\x12\x97\
C{#\xf9\x1a\x14\x04\x9cW\xaf\xd8\xf1\xbe\xe3A\xd9\xffh\xae\xc6\x17g~\xbf\xf6\
\xbe\xc5\xe4\x10d\xaei\xa3\xcb\x14k\xdf\xe3\xe3\xf3yS\x90\xa2H\x80\xbaK\xce\
\xad\x8b\x82\x1b\xa5\x0f|\xd9\x7f\xa2\x84O\xc4k\xc2\xc5~\x8d5\x8f\x13\xb6Ox~\
\xf4\xe8\xdf\r\\\xa7\x9c\xdbn\xb0}\x15\xb5\xd9\xd20C\xfb\x7f\xd2O\x8d\xa7\
\xac\x0b\x8f\xb1J3\xeb:\xac\x02Z\xa7Z\xe2\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\
\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\
\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\x12bh`e\x0c\xd4`\x00\
\xd1 \xeb\xbdZ\x1c\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\x00Y\x07\xc1K" )

addArtData('wxART_SORT_DESC', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5&\x07\xf8\x84\xb8\
\xfe\xff\xff\xff\xfb\x97\x9f\x0f.\xbf|~\xef\xdd\xa7o\xbf\x7f\xfe\xfe\xfb\xee\
\xcb\xcf\x97\x1f\x7f<|\xfd\xf5\xc6\xd3\xcf\x9d\x91\xab'\xa6l,**\x9a\x99\xbf\
\xed\xc6\x89\xc7\x07\x96]\xda0\xe1\xb8o\xe7\xb1\xa0\x9e\xe3;.\xbc(_z9y\xc6\
\xd9C\xd7\xdfT.\xbb\xb2\xfa\xf8\x93y\xfb\x1e4\xae\xb9\xee\xd9vt\xe3\xe9g\xee\
\xadG\n\x16\\\x9c\xbc\xfd\x0e\xd0\xfc\xa4e\x8e\xbd@\xeb\xb8J\x82\xfc\x82\x19\
$\xbf\x9f\x14gU\xb3+\xda\xfe\xaaz\xb2%P\x941\xc9\xdb\xdd\x85\xa1\x83U\xd6\
\x03\xc8\xe1,\xf0\x88,f`\xe0\x16\x06aF\x86Ys$\x80\x82\xec%\x9e\xbe\xae\xec\
\x0f9\xf8\xb8\x94\xe4&z.x\x00\x14J\xf7tq\x0c\x91\xb8\x9c{.\\\xa8A\x81\xc7\
\xf5b\xfa\xe16\xd15\x1d\xef\xea\xa7\x0b\x89\x1e?S\xf1\xbf\xa8\rh[8\xa7\xd7#\
\xcd\x15Y|\xbe\xdcl\x89\x92\x06\x1f\xb8\xf5\x7f\xb0\xf2\x0b\xee\r\xfa\xe0\
\xfd\x93S\xe1\xdd\xaf\x96\xc6K\x87O$\xcc\x9a\xfe\x95\xfb\x10C\xac\xcf\xe2=\
\x99\x9b\xf5\x9e6(\xdd\xe0\x7fpaG\xcb\xb3+i\x0eyG\xee\xdb\xaf\x10\xfer\x8c\
\xa5a\xb2\xdf\xfdK@+UK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\
\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\
\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8c\x81\x1a\x0c \
\x1ad\xbdW\x8b\x0350x\xba\xfa\xb9\xacsJh\x02\x00\x0f\xe6\xc2\xe8" )

addArtData('wxART_TEXT_EDITOR', 'wxART_OTHER_C', 16,
b"x\xda}\x90kHS\x01\x14\xc7\xcf0\xd14-+R\xcblTBY\x83\xbb9\xb0\xc6\xc8f.\xb7\
\xccG:{QY\xda\xd4U6\xa9I\x14T\xcbb\xa9\xbd\xe8A\xa9X&\x15DE`d\x91\x1flie:\
\xf3\x99\xe5\xdc\xda\xc3mw\xef\xd7\xbd{\xb8\xd2\xd6\x95\xfa\xd2\x97\x0e\xfc\
\xcf\x9fs8\xbf\x0f\xe7_\x9b\x97\x93\x19\x15\xb18\x02\x00\xa2\xb8\x9c\x8c|\
\xc2\xe7\xcd(<\x84\xe8\xab(s\x0b\x08\x9bU\xc6\xcaf\x01\xb4^\x8b\x9c:\x10J\
\xcc\xe4\x12N~6\xc0\xa9$\x00\xf1y\x80@\x90p3@\x15\x02`\xd9\x0f\xc0\xa8\x07\
\x88\x15\xde(\xfa\xb0\x19\x80\xb48o+\x8f\x1d\x0c\x06A,^X*\rT )w\xec\xf1\x1b\
\xaf\xeam\x9e\t+\xee\xf3\xfb\xb5\x16\\k\xc55\x16\xdc\xeb\xf5\xab-\x98\xca\
\x84y\xbc>\xb5\x19S\x9ap\xdc\xeb\xffn\xc2\x95F\x0c\xf3\xf8\xc6Q\xcc\x8d\xfb\
\x14(&G\xdd.\xdc'G\xb11\x83\xdb\x81y\xc7\x0c\xd87\x83{\x12\x81F\x80\xe9\xba\
\x8a\xb7=\x8a\xfa\xcb'\x9e\xb5\x0f\x7f\xaa\x07\xcc3isz\x0cf\x97Jgkz\xdc!\x16\
\x8b\xd5\x1d[|\xfa[\x1a\x83]\xae\xb6\x0c\xcbQj\xa6 !!aTa\xea\xff\xaa\x1b\x1a\
C{\x87\xb5\xbf\xa6\x7f}\x1e\xd5u\x0f\xa8\x03?\xa6\xea\xef>\xe8\x19\xd2t\xf5)\
\xbd\xbe\x80\xc3\xed3Y\xb1\xc9\x1fS\x1f\xfaU\xd2^\x05\xe6\xf1[\x1c\xb8\xde\
\xe4RN\xd8:eJ\x87\xdb\x8bZ\\r\xb5Y62\xf1\xbe_e\xb6c\x13F\xa7Rk\x1dU\x18\xfb\
\xbf\xea\xbb\x07\xd5E\x95\x97\xf6\n\xeb\xf6\x1c\xad\xdb}\xa4f\xe7\xe1\x9a\
\xed\x02Ia\xb9\x84W.!bI&G\xf6\xcd$*\xca\xcf!\x92F\xff[e\x92`\x11qK*\xce\xca\
\xcc\x80\x9a\xd0\xa5\x1cb\x98]\xc9\xd9u\x1c r\xc1\x8cH\xd0\xd8\x14G,\xc3D\
\xdclv\x986<:by\xe2u\xee}\r\xb1\xea\xe4f\xb0xq#\xfc\x81\xc3;H\xdb\x16\x8a\
\xb5#_\xe6\xbd\xc9~\x1eSjk\x8a\x114\x9e\xa6m\xfd\xf8(\x9c=\xccN\xc6\x83g/~\
\x7f\xc6\xa7P\x9c\xddF\x85ll\xdf\x93d\xbbHJo{\xd8\xf9\xaakE\xad`\x9c\xdd`\
\xe5\x19^\xec\xbe\xc9o\xe0\x8e\x17N7.\xf9r\xa5vC\xda\xbbV\xcd\xca\xd7\xbc\
\x90\xe9si\x90\xbbVv\xa8\xd8u\x81<\x8b\x92{\xe4gtWL\xf5\xaa\x97U\xf3\x1d\xa2\
\xf6\xb8\x82\xf0\x9c\x96ooc\xa7\xde\xc5\xcf\xa1\xde#s:u\xe5\xcc\x98t&)yu5\
\x9d\x99{\xa5!@\x0b\x93\xf6\xc5\xb3\x16\xed\x8b\x15:\x975o\xaaV\xaeg%\xde.z\
\xealV\xb7Y\x8b[8\xe4\xa0Px&$T\x92\xd86xk\x9d\x8e\xf8&I\xc4\xde):x@\xc4g\x94\
\x1c\xe3\x13\x064\x84\x9aJA\xe8\x14\x1a\x8dGMeP\xe9\x8c\x94\xf5k\x10\x1a\x03\
A\x98\x052\xf4\x1f\xa0BxPPz\xf2/\xb0\x8eB\xa5\xf3\xa8\x08#\x85\x00\x90?\xc0\
\xd2\xac\xa7\xb1\x04\x00\\vN\xc6\xf3\xf4\xfd\xd5\xbf\x01\xf2\xf2\x97\xec" )

addArtData('wxART_TOOL_DRAW', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xe7y\xba8\x86X\xf4\
\xee\x9d\x18\xc8u@\x81\xc7y\xf2\xc6\xdf\xf3\x0f\xceN\x8b\x9f\xb8pi\xb6\xa0\
\x98@\xc8\xad/\xae\x9es^F\xe9\xb3hh\x89(\xac\xbf\xb2`\xb5\xf5\xac7\xb6\x8d\
\xe7[.\x1f8\xca\x14\x92\xb9\xc5K\xf0\xda\x9d\xf7\x9f\xd3\x04|\xe7\x97\\\n\
\x0bV+\xd8\xbcd\x8e\x82\xf0N{\xdf\xd3\t=\x823\xc4f\xcb6\xa7\xfc\xe75\x9a\xca\
\xe9\xb3\xf1\xdf\xa5\xfd,\x13\xfb8\xe5\xdc\x0e\xab\x7fu\xf6aL\x07\xda\xcc\
\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00O\xe9@\xd2' )

addArtData('wxART_TOOL_EDIT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc4\
\x0c$\x93\xe6\x8a\x7f\x02R,\xe9\x8e\xbe\x8e\x0c\x0c\x1b\xfb\xb9\xff$\xb2\x02\
\xf9\n\xc9\x1eA\xbe\x0c\x0cUj\x0c\x0c\r-\x0c\x0c\xbf\x80B\r/\x18\x18J\r\x18\
\x18^%00X\xcd``\x10/\x98\xb3+\xd0\x06(\xc1\x13\xe0\x13\xe2\xca\xc8\xc0\xb0`\
\xc1\x02 \xef\xff\xff\xff\xcb7\xbc~\nd1\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\
\xbb\xbb0\x0b\xf2\xf8\x80lc/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$7\xd1s\xc1\x03\
\xa0\x90\xaa\xa7\x8bc\x08\xc7\xf5\xe4\x04\x07f&\x05'&\x17\x8f\xc6N6\x81\x8d\
\x0c.k\x1a\nU\x1db\x1aE&la\xdbU\xc60s\x1f\x8b{\xa3\xa3c\nHC\x89kDIJbI\xaaUrQ\
*\x90b0204\xd75\xb0\x00\xa2\x10C3+CK+CSm\x03#+\x03\x83\xc0\x1f\xe7\xc2P4\xe4\
\xe6\xa7d\xa6U\xc25\x18\x9a\x84\x18\x1aX\x19\x9bX\x19\x1b@4\xc8z\xaf\x16\x07\
j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xfe\x17S\x85" )

addArtData('wxART_TOOL_ELLIPSE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd\'\x91\x15\xc8WH\xf6\x08\xf2\
e`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x86\x05\x0b\x16\x00y\xff\xc1@\xcd\
\xb6\xc4\x1d\xc8a,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\xe4\xb0\
\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9b\xe8\xb9\xe0\x01P\xc8\xd7\xd3\xc51\
\x84\xe3\xbao\xefE\xc1\x03\x06\x1cN\x9e1\x0b\x9e\xb3\xb4\xe8\\\xf8\xbb\\{Y\
\xf9\xb6\xf7\xce\xb6",\r*|;KC\xe7\x8b\x84\x1e\xe6:\xf2\xa1\xe8\x83\xd9\xe9\
\xd9\x1ai\x91^\x1b\x0b/7i\x97\x88|\xdc\x9d\x19\xfe\xdc\xc2\xf2\xfe\x93\x7f\
\xac\xd2\x1f\x1f3\xc6\x16\xb2\x7f\xd8T\xc3\xa8\x0f4X\xb5\xc45\xa2$%\xb1$\xd5\
*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1aX\x00Q\x88\xa1\x99\x95\xa1\xa5\x95\xa1\
\xa9\xb6\x81\x91\x95\x81A\xe0\x8fsa(\x1ar\xf3S2\xd3*\xe1\x1a\x0cMB\x0c\r\xac\
\x8cM\xac\x8c\r \x1ad\xbdW\x8b\x0350x\xba\xfa\xb9\xacsJh\x02\x00\xf8\x0fnc' )

addArtData('wxART_TOOL_KNIFE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4O\xf4tq\x0c\xb1\xe8\
]:)\x90\xef\xb0\x02\x8f\xf3\xfc\xea\xff\xd6:\xeak\xbf;:L\x11=r\xcb\x83C\xf1\
\xa3\xccc\x85\x8f\xeb\xfa\xd4'\x1c\\\xfe\xd6\x9d\x89\xed\xf6\xb3\t_\xb6;\xf0\
\xd7+\xf14\x98\x89\xb3nk\xd0\xd8\xb0U\xbb\x80=\x9f;D\xe2\x03\x07\xf7\x85\xac\
\x1e=\xf1\xab\xefonI\xbc,\xa0=E\xec\xd6\xce\xf6\xe5L\xb61\xcfmW\xcb3N\xdf~\
\xe9\xf0$\t\xeb\xedR\xcc\xdd\x1c\xdd>z\x87\xa3\xdbl\x0e\xa5\x9c\xb2.\x98\xed\
\xf47Q<]\xfb\xf6a\xee<\xe7[\x8d+\xf9\xee]\x11\x97)\xc94h\xd6Qo\x06:\x8e\xc1\
\xd3\xd5\xcfe\x9dSB\x13\x00\x94\xd4M\xd4" )

addArtData('wxART_TOOL_METER', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x10\xf8\xff\xff\xff\x82\x05\x0b\x80\
\xa4\xbe\xe6\xd9\xe9@>cI\x90_0\x83\xc3\xb3\x1bi N\x92\xb7\xbb\x0bK\x7f\xc6\
\xcd@ \x87\xbd\xc4\xd3\xd7\x95\xfd!\x07\x1f\x97\x92\xdcD\xcf\x05\x0f\x80B&\
\x9e.\x8e!\x1c\xd7\x93\x13\x1c\x18{\x0c\xda\x1a\x18B\x1a<\x05\xb5\x14\x96\
\xa80\x08\x06\x04\x984pq8\xb3L\xb9\xc0Z\xb02\xa1\x81\x8b\xa1u\x01\x13\x0f\
\xcf\xa1\x15|@_Lb\x91\x9f\xa9\xbdc3P\xbfj\x89kDIJbI\xaaUrQ*\x90b0204\xd75\
\xb0\xd054\t14\xb020\xb32\xb0\xd060\xb220\xf0I|#\x8c\xa2!7?%3\xad\x12M\x83\
\xb1\x89\x95\xb1\x01D\x83\xac\xf7jq\x90\xff<]\xfd\\\xd69%4\x01\x00\xfd\xc1Yt\
" )

addArtData('wxART_TOOL_RECTANGLE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc2\
\x0c$\xdf\xde}\x04\x12`Iw\xf4ud`\xd8\xd8\xcf\xfd'\x91\x15\xc8WH\xf6\x08\xf2e\
`\xa8Rc`hha`\xf8\x05\x14jx\xc1\xc0Pj\xc0\xc0\xf0*\x81\x81\xc1j\x06\x03\x83x\
\xc1\x9c]\x816@\t\xfe\x00\x9f\x10WF\x06\x86\x05\x0b\x16\x00y\xff\xc1@\xcd\
\xb6\xc4\x1d\xc8a,\t\xf2\x0bfpxv#\r\xc4I\xf2vwa\xe9\xcf\xb8\x19\x08\xe4\xb0\
\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x9b\xe8\xb9\xe0\x01P\xc8\xcc\xd3\xc51\
\x84\xe3zrB\x03\xa3\x9b\xaa\x80\xe6\x92\x03\x07R\x96\xb0\xb0\x9cr`\x8bp\xf1l\
lt<\xc8\xc01\xa3A\x865M\x81\xc1\xd8A\xc9MB\xc9\xa7\xc2\xf5C$#+\x83\xdb)\xf6\
\xa7\xe7\xc2\x19\x81.bP-q\x8d(II,I\xb5J.J\x05R\x0cF\x06\x86\xe6\xba\x06\x16@\
\x14bhfehieh\xaam`de`\x10\xf8\xe3\\\x18\x8a\x86\xdc\xfc\x94\xcc\xb4J\xb8\x06\
C\x93\x10C\x03+c\x13+c\x03\x88\x06Y\xef\xd5\xe2@\r\x0c\x9e\xae~.\xeb\x9c\x12\
\x9a\x00N}[\xcc" )

addArtData('wxART_TOOL_ROTATE', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc4\
\x0c$\x93\xe6\x8a\x7f\x02R,\xe9\x8e\xbe\x8e\x0c\x0c\x1b\xfb\xb9\xff$\xb2\x02\
\xf9\n\xc9\x1eA\xbe\x0c\x0cUj\x0c\x0c\r-\x0c\x0c\xbf\x80B\r/\x18\x18J\r\x18\
\x18^%00X\xcd``\x10/\x98\xb3+\xd0\x06(\xc1\x13\xe0\x13\xe2\xca\xc8\xc0\xb0`\
\xc1\x02 \xef\xff\xff\xff\xcb7\xbc~\nd1\x96\x04\xf9\x0538<\xbb\x91\x06\xe2$y\
\xbb\xbb0\x0b\xf2\xf8\x80lc/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$7\xd1s\xc1\x03\
\xa0\x90\xa9\xa7\x8bc\x08\xc7\xf5\xe4\x04\x07\x86m\xaa\x0eN\xad\xbc\x1e&\x0c\
\x8a\x8b\x99\x9d\x19\x98\x85'715_kbce[\xa7\xa6\xd0\xdd\xc9\xa8\xc16\x8d}\x15\
\x9b\xe14\x83\x05\x8c\x0cb\x8dl1G\x8a<f\x01\rP-q\x8d(II,I\xb5J.J\x05R\x0cF\
\x06\x86\xe6\xba\x06\x16\xba\x86\x06!\x86FV&\xa6VFf\xda\x06FV\x06\x06\x1b\
\x7f,\xacC\xd1\x90\x9b\x9f\x92\x99V\x89\xd0`\x12bh`elbel\x00\xd1 \xeb\xbdZ\
\x1c\xa8\x81\xc1\xd3\xd5\xcfe\x9dSB\x13\x00\xe6\xa2W!" )

addArtData('wxART_TOOL_SCALE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc4\
\x0c$\x93\xe6\x8a\x7f\x02R,\xe9\x8e\xbe\x8e\x0c\x0c\x1b\xfb\xb9\xff$\xb2\x02\
\xf9\n\xc9\x1eA\xbe\x0c\x0cUj\x0c\x0c\r-\x0c\x0c\xbf\x80B\r/\x18\x18J\r\x18\
\x18^%00X\xcd``\x10/\x98\xb3+\xd0\x06(\xc1\x13\xe0\x13\xe2\xca\xc8\x00\x02\
\x0b\x16,\xf8\xff\xff\x7f\xd7\xa2S\xd3\x80\x1c\xc6\x92 \xbf`\x06\x87g7\xd2@\
\x9c$ow\x17fA\x1e\x1f\x90m\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94\xe4&z.x\x00\
\x142\xf4tq\x0c\xe1\xb8\x9e\x9c\xd0\xc0|\xf1\xc2\x05\x016F661\x85\x83\xaf\
\x98T$b\x1b\x16\xe9\xe8\xf1L2Vo8"\xe2\xd0\xc2\xc0\xe6mbb\xc0\x92\xc8\xc1p\
\xeb1k\xb8\xb6\xb3\xc32\xa0f\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \
\xc5`d`h\xaek`\xa1kh\x10bhdebjed\xa6m`de`\xb0\xf1\xc7\xc2:\x14\r\xb9\xf9)\
\x99i\x95\x08\r&!\x86\x06V\xc6&V\xc6\x06\x10\r\xb2\xde\xab\xc5A>\xf3t\xf5sY\
\xe7\x94\xd0\x04\x00\xa8\xa8Vm' )

addArtData('wxART_TRASH', 'wxART_OTHER_C', 16,
b'x\xda\x85\x92iP\x93W\x14\x86/\xa2\xd5\x0f\xeb\xd2Z\xebV\x97j\xad\xb6\x16\
\x1b\x16\xab\xe2\xd2b\x83\x12#\x88\x10,\x8a\x1a\x08\x04";\x18#!\xc9\x07!\x91\
\x00\x01\x12B\xf6\x84\xec$$$\x81\x94@\x08\x8b\x06D\xcbbA\x04Yl\xadK;\x8aVm\
\xfb\x0b\xab(\xfd\x98\xf6\x8f\xbfzg\xce}\xe7\xbcs\x9f{f\xee}K"\xc2\x0f-\xf2Y\
\xed\x03\x00X\x84\tEG"\xbat\xb6\x16x#\xfbV\xdf%Q\x88\xccM\x0e\x0e\x0b\x06\
\xc0\xc1[8\x1d?\x0f\xe97$\x84F\x86\x01\x90\xb7\x19\x80\x02\x16\x00\x7f\xcf \
\xfa\x18\x80\xf3(\x00\x9e\xc4\x01\x10$\x05`E\xa6\x00\x7f\xf5 \x00s\xcc\x11Gp\
!\x84\x0c8!\x03\xbe\xff\xec\xf5\x83g\xaf\'\x1eM\x8f=\x9c\x1e\xf9uz\xe8\xc1\
\xab\x81\xbb\xaffff\x1e<{\xd3\x7f\xe7\xd5\xfe\xe8\xbc\xf8tx\x0f\x8e\x1a\x9f\
\xc6\xc0\xa7\xc2\xae\x1b/\xf0\xa9\x8c\xd3)p\xd3\xe0\x8bX\x12# \x9c\x1a\x93\
\xcc\xa8\xef\x9f\x8aIbD\x13\x19\xf6\xbe\xa9h"=2\x81\xbe\xfdp\xee\xd1x\xba\
\xb5o\xeah\x1c\x1d{\x86n\xeb\x9d\xea\x9ex\xc9\xa9\xd2\x17\xf2\xf4\x85\x15\
\xaa\xe2*C6K\xcd\xaaP\x93\xe8J\xc2\x05\x19\\"?M\x96&\xe6J1IB\xec\x19\x1a\x16\
\x0f\xc7f\x8b\xd0\x04~\x85\xbc\xaeLf\xe5)\xacB\x8dC\xack\xac\x90[\xb9\x12\
\x0bGT\xcb\x12\x18Y\x023\xcc3\xe5qk\xa4z\xa7\xd9\xd9ms\xf5\xd8\xdc\xfd\x16W\
\x9f\xc9\xd9\xa3s\\S\xd9\xba\xe5\x96.\xb1\xd1S\xa9\xbbD-3\x17\x96\xab\x14F\
\x17WlD&\xb2\xf9\xfa\x82\n-\xadDE\xb9\xa8\xccf\xcaR\xe9\xe2d\xaa(\x9d\xa9*\
\x106r\x04\x86R\x91\xa9L\x86\x0c\xb5\x15\x8b\xad,\x81%\x9fWK\xe3\x1a)\x1c}\
\x16K\x93\x92\xafJ\xa6U\xb3\xf9Z\xa9\xc1%\xd4:\x1b;oy\x06\x1f\x8a\x0c\xed\
\xea\x86>\xa3{\x84Rb*R\xb4\n-\xfd\x04\xaa\x92Y\xae\x91\x1b[\xcb\x15\r\x0e\
\xcfX\xe7\xd0\xe32e\xb3\xc4r\xd5\xdcq;\x93\xa5\xa3\x94\xd6\xc9\x1bF\xf0\x14\
\x05\xccUKj\xda\xb8\xd2z\xfb\xe5\xb1\x8e\x81\xc9by\xb3\xa0\xa6\xcb\xe8\x9eHe\
\xeaR\x99\x06\x89}8\x96,\x17\xea[9\xe2zk\xc7X\xdb\xf5\xc9\x8b\xd2&\x9e\xbeK\
\xe7\x9a \xc1ZR\xbeAh\x1d\x8e\xc9\x96](\xaa\xae\xd4\xba\xd9"{m\xdbhK\xdf$S\
\xd4T\xaa\xe9T7\x8d\'\xd25D\x86\x81o\x19\xc6eH\xc9l%O\xedf\n\xec5\xee\xd1\
\xa6\xdeI\xb8\xca\xc9Qu*\x1b\xc7\tT\r\x81n(\xaf\xbdy,M\x92\xc9Tp\x95-\x0c\
\xbeM\xe7\x1au\\{D\xabt\xb2\x95\x1e\xa9c\x1c\x9f\xab\xc1S\xf5\\\xd3\xcd\xf0\
\xb3\xe24X^\xach\xc9\xe3\xd9U\x8d#\xf6\xeeG\xb9<\'\xbb\xfa\x8a\xb8~\xec\x14E\
\x93\x00\x9bK\x0cCX\x92\x88D\x93\xb2$\xcd\xb0\xc0i\xba\xfc\x1bC\xd4^\xa4\xed\
\xe5\x99\x87\xe3\xe9\xa6\xacrw\xbe\xb2\xefp\x92\x90\xc2\xb5\x16U{\x04\x96\
\x01~\xed G\xdb\x9b/\xbfB\x11\xb4g\x946\'\x16\xd6\xc7\x9c7\xc4\xe6\x88O\xe6\
\xc8\x8eg\xcb\xa2\xd2\xc4\x11)"lr\x15\x86X\x15B\xe0#Q\xb4BL\t\x12\xf0\x1d\
\xe4\xc8\xf0\xd9\xe0\xff\xff\xd2hV\r\xf4\x0ey^>\x7f\xf2\xf4\xf79[\x9e\xff\
\x89&4\xefFl/\x02\xf6\x10\x1a\xfak\xa2\xe6)\xd2@Y\xa1\'\xce\x01\xb0p\xd9ly\
\x01\xb9r%b\xce\'c\xc2B\xe6\xdf_\xb0\xd8g\xe3\xbaJ\x8c\xe6\x1e\xc2\xac\xc1\
\xa0\x83q+\x87\xbd\x96z\xfd\xf1f\xf6\x8e9\xde\xde\x9bw|\xf5\xe9\xdcy\xef\xcc\
_\x00\x01\x9f-[w\xee\xda\x1d\xb4g\xef\xbe\xfd_\x7f\xf3\xd9B\x08x}\x1e|\xe0[t\
\xc8\xc1C\xa1\x98\xc3\xd8#\xdb \x00\xc2\xc2\x8fF\x1c\x8b\x8c\xc2E\x1f\xff.\
\xe6\xc4\x17\x88\xe1{2\xf6\xd4\xe93\xf8\xb8xBB"q;\x04\xbc\xbd\x92\x92IgSR\
\xd3\xd232\xb3\xb2\xdfEN,\xca9G>O\xb9\x90K\xcd\xa3\xd1\x19\x8b!\xb0d)\x9c_\
\xc0,d\xb1/\x16q\x8aK\xde\x83\xc0\xfb\xcb\xa2J\xb9e\xe5\x15<~\xa5\xa0J\xf8\
\x01\x04\x96-\x17\x89%R\x99\\\xa1\xacV\xa95\x1fB`\xf9\n\xadNo\xa81\x9aj\xcd\
\x96:\xebJ\x08\xacZm\xb3\xd778\xbeot65\xbbZ\xd6@\xe0\xa3\xb5\xee\xd6\xb6\xf6\
\x8eK\x97=\x9d]W\xba\xd7A`\xed\xfa\xab\xd7~\xa0\xf7\xf4\xf6\xf5_\xffq`p\x03\
\x04>\xde\xf8\xe5\x8d\xa1\x9b\xc3#\xb7F\xc7\xc6\'P\x9b \xe0\xe7\xffI\xc0\xed\
\x9f~\xbe\xf3\xcb\xdd{\xf7\x037m\x82\x8e\xac\'\xee\xd9g\xca\xecA\xdee39$\x86\
\x9c\x18O&\x06%\xe4\x10\x11\x01\xfe(\xbf\x9d\xbe\xa8@_\x7f\x7f\x9c\xdf\xce \
\xbf\xc0\xa0\x80\xdd\xdbP\xfeA(\xd4\xde\xa8\xfe\x87o\x01\xe9\x99\x89g\x93\
\xa8\xff\x01\xbb|\xfd\x02q~\xa8\xa0\x00\x04@\xfd\x0b\xac\xc5\xd6\xad\x98\xfd\
ULH8\xda~ \xae\xf0\x1f\x00\x8cTb' )

addArtData('wxART_TTX_FILE', 'wxART_OTHER_C', 16,
b'x\xdaUSmL\x9bU\x18=\xf7m;J-\x8c\xaf\xa1\x19d\x12\x12\x90\xd9\xd5\xb4\xb4sP\
\xb7\x05\xb0@;\xde\x96\nUq\x92\xc9(c\x1f\xe2*X0\xc3e\x0e\xc9\x98\xdb:\xd8\
\xf8\\\x01\xa18\xa9\x8eA\x07\x13;\x95e\xba\xa1F\xc7 &.\xfe\xd8\x8f\xc9P1N4\
\xb8\x1f3t\r\x8f\x17\xf5\x8f?\x9esrNrn\x9e\xe7\xb9\xf7\x1e\xb3Y\xf3#\x14k\
\x15\x00"\xcc&c\x11\xe7\xa8\x95\x92K8\xa6\xa9W\x17s\x92\xee\xce\xb6d\x03c-\
\x0f\x85v\xca\xb8Nr\x98\x8a,@}\np\xb8\x11X"\xce\xbf\x02\xb5\x1a\xe0n\x19`8\
\x03<\xecl}\xe9\xcb<\x805\xd9D{.\x03\x88\x88c\x81\x064\x02\x1a\x06\x9d\x01\
\xbd\x03\xea\x07\xf5\x82z\x10\xf4\xf0caN\xc1\xf2YP\x1f\x88\xa3\x17\xd4\n\xea\
\x00\xb5\x81\x86@\xa3 \x0f\x96Nc\xeb:\xd0\x840\xb0W\x92\xaf\xc3t\x03\xc8\x07\
\xba\x04\xcf\x1e\xb6_\x94,w\xc3\xb7\x07K\xe7\xa4\x90\xc8J\xb6\x80>\x01\x8d\
\xa1\xabR\n\xc8\x1et\x08\xf4.\x025\xa0\x19\x0c\x96#f5zv\xb0\xe88\xf9\xf2\x80\
T* P\x8dK/\xc3\xff\xba\xe4)\x8d\xb4`\xbd\xec\xc4>\xf4\x96\x87M\xbe!\x84:AS \
\x8e\xd7\xd0_)\xf0i\xc6\x0f\x81>\x06}\x84%\xde\xd8{\xa0n\xd0e\xf6\xf6\xf3\
\xd2\x1c5\xa3IF\x171w\x14\x93\xb5\xa0\x0f\xf1\xa0\x13\x0b\xcd\xb8\xe5ft\x15\
\xefW\xb3\xd6\na\xe4M\xe1V#;\xbf\x0fG\n\xa5\xb1J\xf9nQ\xf6\xd9q\x98\x1f\x17\
\x92\x13\xa4\x7f\xf6\t\xab\x18F\x9d|4X2\xf9\xe6\x85\x1fN2\xba\x8e*\x0b\x86\
\xb8y\x0eQ\xe1\x18tJ\xc4\x0cv\xe3 \xc8\x8f\xc5\x16XuplS\xd0\x98,\xd8\x0e\xa5\
\x1c4\xc8}\x19\r\t\x7f\xb5"B\x8eP;B]\x08v"\xc8\xd1\x8b\xdf[V\xf6\xdf\xff\xb4\
\xe7\x19\xbee\xc1Ud\xe5\xb7Z\xd76\x9d\xc1\x15+/\xc872\x12\xd4\xb7\xb9\x08\
\x7f\xd5\xf4\xc2k@\xe4\x17+\xc5:T\x91\t\xdc\x0cs\x99-\xb9aw\xe4\x91\x8a\xe4G\
\xe7\xad\xa7\xea\xb8\xf5\x9b\xd9\x98m\x7f\xe4;GYy\x99\x91)\xc5\x1b\x1b\x86\
\xab\x16\x12{K{\xb3>\xbf\x1a\x117{\xe7\xe7\x1f\x7f\x89\x8a\x8a\x8b\x89\x8f^\
\x13\xdb\x85\xf0E\xd36\xf3\xd4\xd7\xd7\xab\xbfQ\xa5]T5\xc8\xda\x9f\xb5{n\xde\
\xdc\xa8\xf7\x8c\x8f\xd7f\t\x9f\xd6\x07\xb7\x8b\xab\xd66\x89b\xdeW\x0bne\xaa\
\xefnM\xe5|\xbc\xd8)>\xf7\xfd\x935\x01\xb7RYw\xff~(\xb2\xd9*\xce<\xe1\xbf7\
\xb7\xdf\xadt\'\x96\xfe\xb1\xaeo\x87\xf5\xf6\xd6+\x87\x96YC\x16\xf3{gO\xd9RS\
}\xa3\x8b\xf2>\xd3\x01\xefa\xa7\xdd\xa5,\xaeJ\x8c-<\x98\x93\\\x18cK\xca<\xb2\
~\xa3zK\xe3\xb1\xc7t\xaa\x9e\xa3aiI\xddm=]\x17\x8am%\xf6\xd2"E\xfc\xec\x06\
\xc7\xf4\xbd\xc5o\xa3\xd5\x17>\x18\x9ec\xf5\xcd\xa7\'\xb6_\xf6\x05\x023\x8d#\
W\x06\x14?\xbd\x98\xa7\x07\xe6\x02\xa9M\xd6\x84\xf3+\xef3\xc5\x95[\xe2\xaa\
\xd8\xe9\xdaep\xd4\xec\xe2\x84t\x8dv\x93Z\xa3W\xa7\xa7\xdb\xb5\x9b\x0cZ\xbdA\
\x97\xa9\xd2\xa4\x1b4\x9a\xcd\xc5S\xf3\xff\x0b\xbc\xe2\xac\xd8[y\xe0\xbf@\
\x86Z\xab\xb7k5\x06\x1d\x0fh\xff\rLl\xf6\x9e\xfd\xe7\x0b\xe4Z\x8d\xfe\x9c\
\xb2\xb7\xfe\x06f,J\xd7' )

addArtData('wxART_UFO_FILE', 'wxART_OTHER_C', 16,
b'x\xda\x01\x9f\x01`\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\x00\
\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x01QIDAT8\xcb\xa5\x93=n\
\xc2@\x10F\xdf\xec\x8f\x85BCC\x83\x10\xb4 q\r\x8a\x94\x89\xb6A\xe99\x80+h"R\
\x13\xe8\xe9#q\x83\x9c\xc0\x87\xe0\x04\x14.\x00\xe1\x86\xc88N\x119\xb1\x89!D\
\xf9\xa4)V\xb3\xfb\xf6\x8dV+|gBI<\xcf\x13\xa5\x94\x1c\x0e\x87G~\xc9$\x8a\xa2\
4_\xfb\xfd>\xdd\xedvoQ\x14\xbd\xfb\xbe\xffRv\xc8\xe4\x17"B\x18\x86\x85\r\xc7\
\xe3\xd1\x8b\xe3\x98\xd9l\xf6P\xaf\xd7o\xc6\xe3\xf1}\xbe\xafN\x01Z\xebBYk\
\xd9n\xb7\x00\x8cF\xa3\xbb\xc5b\xf1z\x11`\x8c)\x94\xb5\x964MI\x92\x04\x80\
\xe1px\xdb\xeb\xf5\x9e\xcf\x8e`\x8c\xc1\xf7}\x00\xe6\xf39I\x920\x9dN\t\xc3\
\x90\xc1`@\xb7\xdb\x8d7\x9bM\\\nPJa\x8cA\xa9O1c\x0cZk\xaa\xd5*\xcdf\x93~\xbf\
O\xadV\xb3\xeb\xf5\xfa\xed\xa2A\x1e\x00`\xad\xc5ZK\xa3\xd1\xa0R\xa9\\~\x05\
\xad5"\x02\x80\xd6\xfa\xcb,ot\x16\x90\x8d\x90\x012\x83\xfc:\x83]e\xb0\\.\x0b\
\x80|\xaf\xf4\x193\x0b\xe7\x1c"B\x10\x04\x04A\x80\x88\xe0\x9c\xfbq{\xa9\x81\
\x88\xd0n\xb7q\xce\xb1Z\xad\x00\xe8t:\xb4Z\xadR@\xe1/\xa4W&\xff\xf1\x14\xff\
\xcc\xe9\x08O\x7f\x05|\x00\x08\xf3\x8c\t0\xe9-u\x00\x00\x00\x00IEND\xaeB`\
\x827w\xb1\xa8' )

addArtData('wxART_UNCOMMENT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xed\r\xf0\tq\xfd\xff\
\xff?CC\xc3\xe4E\xdb\x81\x8c\xaf\xdf~~\xf8\xf4\xcd\xd0=\x13\xa8\xe9\xef\xdf\
\xbf?~\xfe~\xfd\xee\xcb\xb3W\x1f\x19\x1a\x18\xee?y{\xc2H\xf9\xa8\xba\xc4\xaf\
\xdf\x7f>+0\xff\xabN\xb9|\xf3\xd9\xb9\xab\x8fOxXm\xe4a:\xab"|_G\xe2}\xa4\xf3\
Z\x0e\x86\x87\xcf\xde\xdd}\xf4\xfa\xc6\xbd\x97\xfb\x84Xw\xf10<\x8d\xf6\\\xc3\
\xc10\x9f\x95a\x12;\xdb\xdf\xda\xb4\xd5\x1c\x0ck\x9cm\xf7\x9f\xbc\xdd\xc6\
\xc0\xd0\xcd\xcbs\xcbFs\x0e\'\xdb4M\xb5^a\xa19,\x0c\x85+\xd7o\x01:\x8c\xa9$\
\xc8\x0f\xe8\xb9\xb2\xc9g-\x80<\xc6$ow\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\
\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\
\xe3R\x92\x7f\xe67\xa1\x0c(\xd4\xe3\xe9\xe2\x18"q9\xf5\xfcm\xa1&\x05\x01\xb6\
\x04&\xc1\xc4n\x9d%\xcd)\xec\xa7\xcf}\xfd\xd7\x7f\xbdi\x86\xe5_\xf1\xea\x8fo\
\xff\x18\xefn\xb9\xe0\xe8\xd6\x12pM\xf5\xa1\xc9W\x85_[\x04\xbe\xcf\x0c\x11p4\
P<\xae\xb8\xb1\xe9P\xdd\xc3\xe8\x06\xcf\xf0\x93\xff\xb4\x84\x1c\xd9g(=\xe1\
\x0c\xe7\xfa\x92\x93\xc7\xb5{\xc3_\xd9\xd3W\xa3\xa6_\x0b\xdf\xc1\xf4\xdcl\
\xea\xcdw^\xd6;J\xeaW\xf432\\\x9f\xaa\xe9w\xf6g\xd1\xde\xca\x82\x87g\xab?\
\x1f\xf8Y\xa3\xb8$\xf7^\xe2-\xfe\x05E\x9cSC\x8f\xc5,\x07\xbaK\xb5\xc45\xa2$%\
\xb1$\xd5*\xb9(\x15H1\x18\x19\x18\x9a\xeb\x1a\x98\xe8\x1a\x19\x85\x18\x9a[\
\x19\x9aX\x19[j\x1b\x18Y\x19\x18\xd8\x04\x9f~\x86\xa2!7?%3\xad\x12\xaa\xc1B\
\xd7\xd0$\xc4\xd0\xc0\xca\x18\xa8\xc1\x10\xa2a\xb7\xcd\x82\xc5@\r\x0c\x9e\
\xae~.\xeb\x9c\x12\x9a\x00\xd7\xd7\xd8\x96' )

addArtData('wxART_UNDERLINE', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xce\x0f\xf0\tq\xfd\
\xff\xff\xff\xe4E\xdb\x81\xa4\xa1{\xe6\xdf\xbf\x7f\xf7\x9f\xbc\xfd\xe3\xe7\
\xefg\xaf?3\x18\xcc\xf8\xf0\xf9\xe7\x9b\x0f\xdf_\xbd\xfbv\xf7\xc9\xfb\x97o>\
\xfd\xfd\xf7\xef\xcb\xb7\x9f\xaf\xde}~\xf2\xe2\xfd\xfd\'o\x7f\xfe\xfa\xf3\
\xfe\xd3\xb7g\xaf>\xdez\xf0\xea\xe1\xb3w7\xee\xbd\xbc|\xf3\xd9\xaf\xdf\x7f\
\xde~\xfcv\xe3\xfe\x9b\xbb\x8f^\x9f\xbb\xfa\xf8\xeb\xb7\x9f\xea\x01+*&\x1e\
\x7f\xf0\xec}Z\xf3~\xeb\xf8uWo??y\xf1\xc1\x87O\xdf.\xdf~\xe3_\xb0\x9d\xdff^P\
\xd1\xf6Cg\x1e\\\xb8\xfe\xe4\xc8\xd9\xbb\xaf\xdf}\xf9\xf8\xe5\xfb\xdb\x0f__\
\xbc\xf9\xf4\xf8\xc5\xfb\xd3\x97\x1f\x9d\xf9(\xf8\x11\xe8T\xc6\x92 \xbf`\x06\
\x87g7\xd2@\x9c$ow\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\
\x19\x19f\xcd\x91\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x7f\xe67\xa1\
\x0c(\xd4\xe3\xe9\xe2\x18"q9\xf4\xfcq\xb1&\x03\x01\xb7\x87>N%9\r\x9c\x1d\x11\
\x1b\x9aD\xd7\xbc\xff\x9fs\x8cg\xde\x91\xdd3\x8e~_\xdffX`(\xfd!^\xe1\x9f"\
\x83f\r\x87\xd5\x85\xadL2\xbe\xf7\x99\x9d\x04\xbe\x08\xfc\xaei8,\xc8\xd0\x18\
Y)\x91h\x13\xc6\xe747a\x95\x1a_\x89H\xb2\xd9Y\xce4\xb6g\'\x99\xa6W:n\xe0\xba\
\xbe\xe3\xe6\xbbo\xa9\x81\x822_>\x96\x1c;\xbdu\x9dT\xd3\xed\xbf\x1fkVn\xaa3\
\x9f\xa4p\xd4\xec\xa6\xd3\xb3\xbf\xd9\x8e?6\xf2\xf7Fq<\x0c\xdc0\x9b\x0f\xe8.\
\xd5\x12\xd7\x88\x92\x94\xc4\x92T\xab\xe4\xa2T \xc5`d`h\xaek`\xa2kd\x14bhneh\
bel\xa9m`de``\x13|\xfa\x19\x8a\x86\xdc\xfc\x94\xcc\xb4J\xa8\x06\x0b]C\x93\
\x10C\x03+c\xa0\x06C\x88\x86\xdd6\x0b\x16\x0350x\xba\xfa\xb9\xacsJh\x02\x00t\
\xaa\x0b~' )

addArtData('wxART_UNDO', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3\'\xc5\x1fu\x03\xaa\xf5\x0b\xf0\tq\xfd\xff\
\xff?CC\x83n\xfeW\xc3\xac\xa3\x136~\x8b\xe8z\xa7\x1b\x7f\xce\xb9\xe0b\xca\
\x84g\xf1=O\xa3\xda\x1f\x874=\x0clx\xe8\\r\'\xa5\xff\x99K\xc1%\x06\x83\x19\
\xc9\xfd\xcf\xe2\xba\x9f\x86\xb5>2\x8aY\xcf\xe0t\xc2(\xed\xbaq\xfau\xad\xd0\
\xed@\xa3\x9e\xach\x04\xb9\x82\xa9$\xc8\x0f\xe8\xba\xb2\xc9g-\x80<\xc6$ow\
\x17\x86\x0eVY\x0f \x87\xb3\xc0#\xb2\x98\x81\x81[\x18\x84\x19\x19f\xcd\x91\
\x00\n\xb2\x97x\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x7f\xe67\xa1\x0c(T\xec\xe9\xe2\
\x18"q9\xf5\xfc[\xbef\x05\x1e\xd6\x80l\xfb\x19y\xa5\xa1\x8e\xdf\xff\xf9\xef\
\nJj\xfa\xf8O\xd3V\x95\x97\xe7\xb0r\x80\xb1\xd2\xa3\x08~\xbe\x17\xac\'\x0fO\
\x92Z\xf0}}f]}\x84j\xc3\x84i/\xb3\xdd\xce\xcc\xd22X\x1bm\xc4 >\xb5\xa1\xf4\
\xf6Z\xbd3kT\x0f\x143w\x9bx\\\xb7^pW\xe3B\xf3\xa6\x13\xbc\x9f\x02\x17\xb4\
\xd7\x88\xbdP|f\xfbgQ\xfb\xf3\xe7\xff\xb3\x97\xb2\xb4\xa9>\nR\x06Z\xafZ\xe2\
\x1aQ\x92\x92X\x92j\x95\\\x94\n\xa4\x18\x8c\x0c\x0c\xcdu\rLt\x8d\x8cB\x0c\
\xcd\xad\x0cM\xac\x8c-\xb5\r\x8c\xac\x0c\x0cl\x82O?C\xd1\x90\x9b\x9f\x92\x99\
V\t\xd5`\xa1kh\x12bh`e\x0c\xd4`\x08\xd1\xb0\xdbf\xc1b\xa0\x06\x06OW?\x97uN\t\
M\x00\xdd\xc8\xa88' )

addArtData('wxART_UNINDENT', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6\xbe\x9a\xdf\x81\x93\x81|\
\x85d\x8f _\x06\x86*U\x06\x86\x86f\x06\x86\x9f\xff\x81\xf4K\x06\x86R\x03\x06\
\x86W\t\x0c\x0cV3\x18\x18\xc4\xf3'\xc5\x1fu\x03\xaa]\x17\xe0\x13\xe2\xfa\xff\
\xff\x7f\x86\x86\x86\xc9\x8b\xb6\x03\x19\x86\xee\x99\x7f\xff\xfe\xdd\x7f\xf2\
\xf6\xbf\x7f\xff~\xfc\xfc\xfd\xec\xf5\xe7\xa9Kv*((HHH\x00\x95\x7f\xfa\xf2c\
\xda\xd2]\x7f\xff\xfd\xfb\xf9\xeb\xcf\xcb7\x9f\xe6\xaf\xd9?}\xd9\xee-\xc7^i%\
^\x98\xb5b\xcf\x8c\xe5{\x18\x0cf|\xf9\xf6s\xce\xaa\xbd3W\xecm]\xf7+\xb1\xfb\
\xe6\xfbO\xdf^\xbd\xfb\xfc\xec\xd5\xc7\x87\xcf\xde\xdd}\xf4z\xfa\xb2]\x0c\
\xd6[f\xad\xdc\xf7\xe2\xcd\xa7\xc7/\xde\xff\xfe\xf3\xf7\xdb\x8f_\x1f\xbf|\
\x7f\xfb\xe1\xeb\xfd'oo=xu\xf5\xf6\xf3\x0b\xd7\x9f\x9c\xba\xf4\xf0\xc3\xe7\
\xef\xf7\x1e\xbf\xbey\xff\xe5\x8d{/\xaf\xdczv\xfe\xda\x93\xa3\xe7\xee\x1d<u\
\xe7\xe3,\xee\xeb@\xa70\x95\x04\xf9\x01}_6\xf9\xac\x05\x90\xc7\x98\xe4\xed\
\xee\xc2\xd0\xc1*\xeb\x01\xe4p\x16xD\x1630p\x0b\x830#\xc3\xac9 \xa7\xb3\x97x\
\xfa\xba\xb2?\xe4\xe0\xe3R\x92\x7f\xe67\xa1\x0c(4\xcf\xd3\xc51D\xe2r\xe8\xf9\
\xe7bM\x06<\xac\x0f\xcc\xd6Zp\xbb\xb2\xf2\xf2\xb51\xdfy\xf4\xedo\xfc\x99m\
\x16\xaf\xfeN\xd7\xff\xfed\x8e\x00\xd3\xfe\x00/N\xc5\x03v\x8c\xff\xf8M\x0bv\
\xf0~e3\x91]\xb7\xe0\xe8-\xd9\x83-\x02z\x05\xeb\x0e\xae\xe6\xbaT\xbe\xdb\xf6\
\xc2\x85t\x1d\x0e\xe7\x97\xab\xfb$2$V\t.\x95\xcf\x94\xc8\x94x\x9c\xd2\xd5Q8)\
m\xf3\xce\xc6\x84F\x89\xa3\x9dy3\xa4\xbd\xd5D\x9f\x1e\x15\xdfs\xb5j\xf3\xd9\
\xee\xbb\xff\ntx\x0fx\xae=\xf3\xefn\x83\x89u\xfc\xba\xed\xd5?+\xacDS\xae\xed\
g\xdb!\xfb\x89I=\x8f':\xc9Uw\x16\xd0\xa5\xaa%\xae\x11%)\x89%\xa9V\xc9E\xa9@\
\x8a\xc1\xc8\xc0\xd0\\\xd7\xc0D\xd7\xc8(\xc4\xd0\xdc\xca\xd0\xc4\xca\xd8R\
\xdb\xc0\xc8\xca\xc0\xc0&\xf8\xf43\x14\r\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\
\x86\x06V\xc6@\r\x86\x10\r\xbbm\x16,\x06j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00h\
\xb4\x14\xba" )

addArtData('wxART_VIEW', 'wxART_OTHER_C', 16,
b'x\xda\x01\xca\x015\xfe\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\
\x00\x00\x00\x10\x08\x06\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\tpHYs\x00\x00\
\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x01|IDAT8\xcb\xdd\x91Mn\
SQ\x0c\x85\x8f\x9f\xedso\xdeK&\xf9)\xdd@+\xf1\xb3\x83\x969\xd3\xa0n\x83\x0c\
\x11[\xa8\x8a\xd4\x1dt\\\xca\x0e\x10#\xb6\x80*\x98\xd0\r\xf0B\xa4\x08\x85(z\
\xbdf@\x8a\x00E\xcc\xe1L,\xd9:G\xb6?\xe0\x9f\x97\xeejN&\x13\xddl6\x8fT\xf5\
\xb1\xaa\xde7\xb34\x1c\x0e\xdb\xd5jU\xfe\x9aV\xd7\xf5=\x92g\xaa\xda\xaajTU\
\x15\xaa\x1a\xaa\x1af\xd6\xba\xfb\xcb\xa6i\xf6v\x9aI>u\xf7\x85\xaa.\xdc\xfd\
\xd3\xd6\xf43\x84\xe4\xcdv\xf6\x85\xe4\xf4\xceW\x01@Ji\x16\x11W\x00\xde\xa4\
\x94\x0e\x00|#\xf9\x84\xe4\xb1\x88\x14\x00(\xa5|\xcd9\x1fF\xc4\xdbR\xcakw\
\x9f\x01\x00r\xce\'\xee^H\x9e\x9b\x99\x00\x80\xbb_7Ms\x94s~\xa8\xaa\xb7\xdbm\
\xae\x01`<\x1eKJ\xe9\xdc\xccJ\xce\xf9\xc4"\xa2DD\x88\x08\xba\xae\x03\x00\x88\
\xc8\xc5z\xbd~\'"\x88\x88JDPU\xd5\x05\x00\xb4m\x0b\x92\x00\x80\x88\xf8q\x87\
\x99\xcd\xdc\xbd3\xb3\xcb\x94\xd2(\xa5$$\x9f\xab\xea\x073\xfbH\xf2E]\xd7\xd2\
4\xcd\xd8\xcc^\xb9{\xe7\xee\xcf\xfe|\xe2\x94\xe4\\U\x17$OI\x1e\xf7z\xbd\xfd\
\x9c\xf3\x9e\x99\x1d\x91<U\xd59\xc9\xb9\xbbOw\x92p\xf7\xc9\xaf\x18\xefHl\xeb\
g3;\x1b\x0c\x06\xbfa\x94]A\xa3\xd1H\x97\xcb\xe5\x03\x119\x8c\x88P\xd5\x9b~\
\xbf\xff\xbem\xdb[\xfc\x7f\xfa\x0e\xc4\xf8t\x16:\x90\x11\x95\x00\x00\x00\x00\
IEND\xaeB`\x82\xff\xd1\xce.' )

addArtData('wxART_VIEW_GROUP', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19P\xc8\xca\xd3\xc51D\xe3|\xf2\x9f\xf3\r\xf2\
\x1b\x0c\x0c\x0c\x1e\x05~\x9e?\xb1\xb3\x81\x91\xc7\x80\xb5\x87\xa7\'"\x93\
\xadIm\xc3\x01\x9d\xc3\x8e\xc2\xe9L\xca\x86}G\xb2\x99\xf6m\x90\x92zx\xc0Cc\
\x17#\xaf.\xb7\xdev\x87i\xd7\x81\xa6\xa8\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\
\x02)\x06#\x03Cs]\x03\x13]#\xe3\x10CS+#K+SKm\x03#+\x03\x83\x08\x11n.\x14\r\
\xb9\xf9)\x99i\x95P\r\x16\xba\x86&!\x86\x06V\xc6&V\xc6\x86\x10\r\xbbm\x16,\
\x06j`\xf0t\xf5sY\xe7\x94\xd0\x04\x00\xec\xd9X\x18' )

addArtData('wxART_VIEW_ICON', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19P\xc8\xdb\xd3\xc51D\xe3\xfc\xda\t\x07\xb9\x18\
\x14x\x9cJ\xbf\xfc\xdf\xbf\xc7o\xf5\x92\x8d\xa5\'n\x0b\x0bN\xec\x8bb~0s!\xb7\
\xb5\xef\xe7\xf2\xf9\xaeB"\xf5\x1bY\xc5\xa5/\xbd;\xda\xe6\xb6\'=\x90\xebv\
\xdb\x13\xf6\x1fr\x7f\xff1\xef\x92?\xc5\xfb\xbf>\xc0\xf7\xca%aU/\xf5\xb6\xeb\
@cUK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91\
Q\x88\xa1\x85\x95\x91\x81\x95\x89\xb9\xb6\x81\x91\x95\x81\xc1\xc5\x0b\xab\
\xde\xa0h\xc8\xcdO\xc9L\xab\x84j\xb0\xd054\t14\xb026\xb126\x84h\xd8m\xb3`1P\
\x03\x83\xa7\xab\x9f\xcb:\xa7\x84&\x00/\xa8g\xad' )

addArtData('wxART_VIEW_INFO', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19P(\xc8\xd3\xc51D\xe3\xfc\xdc~G\xbe\x03\n\x1c,\
\xe5=\xcf\xe5~\xfd\xdf\x7fi\xb2f\xc8\x86\x8b\xb6\x8a~l\x07\xb6\xf8U{\xdf\x8a\
\xf1ta\xfe\xf6\xb62\xec\xce\xa4%\xdc^\x87\xe7\xcc\xdbp\xb5CP\x98\xf5\xc0\x8f\
\x9f\x86\x02q\x8c'\xc4\xfcxf7X\x9f\x8cO\x9f#\xc1W^\xc1p\xf8?\x9f\xcbdC\xcb\t\
@\xd3UK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\
\x91q\x88\xa1\xa9\x95\x91\xa9\x95\xa9\x85\xb6\x81\x91\x95\x81\xc1\x93\xf8\
\x07\x06(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8cM\xac\x8c\r!\x1av\xdb,X\
\x0c\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00[\x17g\xde" )

addArtData('wxART_VIEW_KERNING', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19P\xe8\x81\xa7\x8bc\x88\xc6\xf9\xd6\x8bk\xfd\
\x9c\x1d\x05\x8e~\xbc\x1fw\xf5\x13\x8b\x86\t\x87\x07\x17\xe7R\xa6^\x05\xde\
\x83\x17\xc2\x15:\xec\xd8W\xc9\xf9\x16\\\tQpl\xca\xacd\x8d\nn\xcf\x15m\xbe\
\xb1w:\xffe\xe3$\xb3\xff>\xe7\xde\xdc\xf4M\x9c|h\x85\xa5z\xf1\xc2\xe7A\x1c{\
\xab\x1eD\xae\xe6)im}\x12\x13\x91\xed\xfc\xf4d\xe3b\xa3\x82V\xf7\x87<\x0f\r\
\x0eK'\xfeHw|gzU\xf0\xdd\xd2M\tz/\xb9N\xcf\n\x9b\x96\xe6\xf76\xa9a\xa3\xc1\
\x81%\x0bw\x88\xea\xfd\xd3}!\xba\xea\x90\xb6\x9f\xcc\xed\x8d\x1f\xae}\xf198\
\x8f?\xb8\xfc\xa9\xab\xdb\xa2\x95+\xdf\xca|]\x18\xf3Z\xdd1v\xee\x1bC\x91\xfd\
Bg\x96\xb6\xc5\x85'\xa4\xf5zz\x1a\x88\xb5\xd6\xbdJo\xd7\xd5^x_\xe5DV\xf5\xc7\
\xa9\xb2\xdf\xb6\x06\x98rn\n\xbb\xb7t\xcb\xcb\xdd\xfb\x19\xeb\x7f\xa4\x98\
\xc4\xdenX\n\xf4\xabj\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\x0e14\xb520\xb5\
25\xd760\xb220\xf0\xaa\xd6\x94@\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1kh\x12bh`\
elbel\x08\xd1\xb0\xdbf\xc1b\xa0\x06\x06OW?\x97uN\tM\x00s\xa5\xafX" )

addArtData('wxART_VIEW_LIB', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19P(\xc0\xd3\xc51D\xe3|\xefDK\xa1\x03\n<\xcc\
\xe13\xff\xfc?\xed%h$q\xa2\xe1\xca\x8a\x8d\xd7\xa6\x9f\x893?\x91\xb0\xd7\xee\
\xf4.\x0b\xe1\x05KB\x1f3h2n=b\xe4\xee3\xe3\xf7z\x16\xf6\x96\xfd\xb3~\xf0E\
\xa4\xf2\xd5O\xcb\xb9\xe8wCxqS\xfc\x8b/\xef\xd8\x13s\x84\xd4\x94[\x9cd\x80f\
\xab\x96\xb8F\x94\xa4$\x96\xa4Z%\x17\xa5\x02)\x06#\x03Cs]\x03\x13]#\xe3\x10C\
S+c\x03+#\x03m\x03#+\x03\x83_\x976\x9fB\xd1\x90\x9b\x9f\x92\x99V\t\xd5`\xa1k\
h\x12bh`elbel\x08\xd1\xb0\xdbf\xc1b\xa0\x06\x06OW?\x97uN\tM\x00\x1c\xf6h\xdf\
' )

addArtData('wxART_VIEW_LIST', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x02$\xb7\xfe2\x7f\x05\xa4X\xd2\x1d}\x1d\x19\x186\xf6s\xffId\x05\xf2\x15\x92\
=\x82|\x19\x18\xaaT\x19\x18\x1a\x9a\x19\x18~\xfe\x07\xd2/\x19\x18J\r\x18\x18\
^%00X\xcd``\x10\xcf\x9f\x14\x7f\xd4\r\xa8\x96)\xc9\xdb\xdd\x85\xe1\x7f{\xff\
\x99\xfd@\x1eg\x81Gd1\x03\x03\xb70\x0832\xcc\x9a#\x01\x14d/\xf1\xf4ue\x7f\
\xc8\xc1\xc7\xa5$\xff\xccoB\x19PH\xde\xd3\xc51D\xe3|\xf2\x9f\xf3\r\xf2\x06F\
\x02\x01\x07\x8f8\x9c`q\n\x130K\xbc\xc2\xfb\xa5\x88\x99!D\x99\x93\xffG\x96D\
\x1bP\xa9j\x89kDIJbI\xaaUrQ*\x90b0204\xd750\xd152\n1\xb4\xb022\xb42\xb2\xd06\
0\xb220\xe03\xdd\xb1\x07ECn~JfZ%T\x83\x85\xae\xa1I\x88\xa1\x81\x95\xb1\x89\
\x95\xb1!D\xc3n\x9b\x05\x8b\x81\x1a\x18<]\xfd\\\xd69%4\x01\x00G\xb7M\xac' )

addArtData('wxART_WHATCHLIST', 'wxART_OTHER_C', 16,
b'x\xdau\x91}L\xccq\x1c\xc7\xbfG\xa7\x9c\x15\x9bLl\xc6"\xf2\x10\xbf\xab,ne\
\xc5Uw\xe8\xa4\xce\x96\xe6!]\xf20Vt\xda\xf8\xeb\n\xe3\x08\x17wuN\xear\xf7\
\xbb\xb0\x91J\xccCJ\x84\xcb\xe4\xa1T\xbf<\xf4 \xbf\xba\xab\xbb\xeb\xf7x"\xfb\
\xf9\x86?\xb0yo\x9f\xef\xfb\xfb\xfel\xaf\xcf\xf6\xfd|\xd5\xf1\xb2Xo\xc1t\x01\
\x00\xc0[*\x11\'@\x9f4Z^c\xe1\x19\x1841\x11\x9a\xc7\x8e\xa8\xb8(\x00*\xceL\
\x18\xd9\xc6\x87y\x96B\x92\x10\x07\xc0\xa1\x00\x00T\x87\x01\x18\xe6\xa0\xdb\
\x008\x80\x00`O\x01@\xa4\x07`j\xc6\xd9\xad\r1\x00\xf0b\xe3\xd7\xca\xa39\x8e\
\x03*\x95oz]H\xa1\xc3\xd0\xc8\x0e\xefE\xa6E\x9evC\xb1n\x86uS\x8c\xbb\xcfI\
\x7fv\xd0\xbd\x83t\xcf\x00\xc5\xba\xdd\x0c\xc3v\xdb)KY\x19j)3\xa3\x96\xf3%\
\xa8\xbe\xc4\\Xlf\x187\xcd\xb0\x14\xcd\xf6\xd8\xa9N;\xf9\xb1\x9f$h\xb6\xcbFu\
\xda\xc8\xf7\xfd\x94\x19-3\xa1\x96KfK\xc1E\xb3\xae\xc8\xac-2\x914;D\xb1.\x92\
\xed\xc0Ib\xf4\xc28\tf\x90`0\x9c(5\xa1%&\xb4\xb8\x14-*E/\x18Q\x83\x11u\x92\
\x8c\x83`\x06\x86\x18\x9b\x8b\xees\xd0\x9f\x06\xa8!\x92\xcd=~\xb5\x19\xc3\
\x9b\xba\x06\x1a]_\x1f9Fj\xbb\\\xd7\xee=imo\xbf\xdc\x80\x9d\xbc\x8bi\x1e`\
\xe8\xb3\x16\xabs\xb8\x1e\xe7\xaa:\xb9\'\xfd\x9c\xd5\xceU\xf6r\x8f\x06\xbfY\
\xdeqOm\\\xbb\x8b\xeb\xa1\xb96\x823\xd5>\xd7\xd5b\xd7\xad\xd8\xfd&\xecU+\xf6\
\xb2\xb5\xed\xb1\x8d\xad\xb1soI\xee#3r\xebFy\xaf>\x1c\xb7\x13\x06\xed\x85F\
\xad\xe2K\xbb>%\xc2/?9\xee\xc3\xe9\x98n\x9dT\xbfo}\xd6\xce4\xb8\xc3\x8b+\xc8\
-p\xfd\x11\xca\x04\x19\xfc\x16\xfc\x1f9\x7f\xea\xbf\xf9\xcfX\xbdX\x16\x0f\
\x07\xf1R\xd7\xc4\x8a\xc1q\xfe\x0c\t\x0c\xe33%\x1b\xb3\x00\x980y\xb4x\xc0P\
\xe4\x07\x9b\x9eJi\\\xb4g\xb7\x97\x8f\xc0\x7f&.\xd3d\xc3\xd6S\xa98J\xee\xd7\
\xacH\x89\xf4\xcc[\x1b\xa8\xca\xcfQO\x13$\xa94\xba\xf3\xea\x1c\xb5\xf7\x14\
\x04\xa9\xc8\xca\xdc\x8fu\xf0r"\xc2&.\x99\x19\xaf*I\xackmz\xf8\xda\x8a5\x15\
\x17\xae\x9b\x148k\xce\xa2\xd4\xbe\x1e;\xee\xec\xde5o\xc1\\\x1f_\x8dF[I\x91,\
\xc1P\xb7\xcf\x15\xe4\xf3\x05\x92\xd5V\x8c\xef1\x8e\x7f\xecH\x87ua\xe0\x18\
\xbeV\xbba\xb0\xbe~\xb6\xbf\xe9\x92C\xfe\xb6%g\xcctC2\x9b-\xac\xd8Gd\x8fW\
\x9f\xe8\x88\xe4\xcd\xd8\x1c\xf1}\x8e\xa6\xda:\xff\x8az\\$o\xca\xaa\xd9\x8a\
\xc9\x89!B\xe2&\x9d\xd7"6\xaa\xee\x1cEuK\xcf\x9c2\xe6\xeeI>\x94\xbe\xdb\xffD\
s\xf3\x9b\xaa\xca\xf55\xc5\x05/\xbc\x80W\xb9\xbfz\x93-\xa9\x02>)@\x19\x9d\
\xa4L\xdb\xa6\xdc.R\xec\xdf\x0e\r\x04#\xc2\xb0 $4(8X.\x0c\x13\tCE!\xcb\x17"\
\xc1"\x04\tO|\x8e\xff\x05\xec\xcdH\xdb\x95~\xf07\xb0,H\x18*\x17"\xa2\x10\x08\
\x08\x7f\x01\xf7\xc2\x8d&\x08\x00i\xb4L|}eJ\xee\x0f+~\xda\xd5' )

addArtData('wxART_ZONES', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4\xdbx\xba8\x86X\xf4\
\xbe\x9d\xbc\x93\x97A\x81\x87\xf9\xbcF\xf3\xec\x93\x0b\x93\x1ag\x18\xbd\xfb\
\xfbB\xc5;%j\xe1|&\x8bo/g\xa4\xaef\xb8\x93s?\xdf\xd1\xdc\xa1!\xa8\xe3p\x82\
\xc4\x81v\xe3\xa3\x8c\xe2\xb56\x02;5v\xb1\x9e\x01\x9a\xc3\xe0\xe9\xea\xe7\
\xb2\xce)\xa1\t\x00\r\xf1)\x8a' )

addArtData('wxART_ZONES_LOCK', 'wxART_OTHER_C', 16,
b"x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x06$\xe5?\xffO\x04R,\xc5N\x9e!\x1c@P\xc3\x91\xd2\x01\xe4W{\xba8\x86X\xf4.\
\x9d|\x90\xef\xb0\x01\x87\xf3\xfc\xe5\xff\xca\xe7\xea\xa7\xb7\xb7\xad\xec\
\xda&\xda:G\xa9Q\xf6\xb3\x8bJ\xd5\xf3\xabW\x8a\x19Zd\xad\x93nZ1\xec\xf9\xf9\
\xeb\x04\xcbn6\xa6+\xad\x11i\n\xd1\xd9\xf93\x0fn\x10\x15\xd0\xb4Z\xee\xd9\
\xd9\xb8,\xe2\xfa\t\x96#\x1bD\xcb\xa6H\xaea\xabT\xe7\xfdg\xf4\xe1{M\xe6'\x0b\
\xa7k\xef8\xdf}\xfd$\xb7\xe6\x90\xff$u6\xfbV\xe3\xc0\xea\x89\xb7\xf6\x7f\xe4\
\xdd\x19\xafo\x9c\xf0\xfd\xb7\x12\xd0\x19\x0c\x9e\xae~.\xeb\x9c\x12\x9a\x005\
\xfbI_" )

addArtData('wxART_ZOOM_100', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\xce\x0f\xf0\tq\xfd\
\xff\xff\xbfkp>\x10\xcd[\xbei\xc3\xae\xa3\x17n<\xf8\xf0\xe1\xc3\x85\x1b\x17\
\x16\xac\xd8\x00\x94\xfa\xff\xe3\xff\x87\x1f\xff7l\xd8\xf0\xe0\xc3\xff\t\x13\
\x16<x\xf1\x7f\xc1\x86\x03\x07n|\xd8p\xe2AzF\xe6\x85\x07\xff\x0f\\\xf8\xb0\
\xe1\xc0\x83\x88\x84\xcc\x0b\x17.l\xb8\xf0a\xc2\x8a\x03\x05\r\x13Z\'\xcc\x99\
4m\xce\x82\r\x1b\x1a&,(\xae\xa9\x9e\xd0\x91PU\xdfv\xe1@\xc3\x87\x1b\x0b6\xcc\
H\x08O\xc8\x0cO\x88*(\xcd_\xd0`\xf0`\x87\xc3\x87\x07\x13\x12\x02\x0c6t\x18<\
\xb80a\xc1\x84\x84\x05\x1d\x0e\x1b&\x18\x048\x18$x(8\x18\x18\xd8\xc6\xdb\xd9\
\x01\x9d\xcaT\x12\xe4\x07\xf4n\xd9\xe4\xb3\x16@\x1ec\x92\xb7\xbb\x0bC\x07\
\xab\xac\x07\x90\xc3Y\xe0\x11Y\xcc\xc0\xc0-\x08\xc2\x8c\xf5)\xf1\x13\x81\x82\
\xec%\x9e\xbe\xae\xec\x0f9\xf8\xb8\x94\xe4\x9f\xf9M(\x03\n\xcd\xf0tq\x0c\x91\
\xb8\x9c{\x9e\x93\xef\x90\x82\x00k\xc0\x9fiV"\xbbW\xad\x8d\xbd\xb3\xd6\xfb\
\xf5\xba\xef\xf6\xb3\x15f\xdcpqb\xfb\xa7\xcc\xd2\xb6\xd1\x9e\xb9\xf68cU\xd6\
\xe2\xee\xb8\x1d\xdd\x8c\x8d\x8d/OZ8rT\x08\xdd9\x14\x901\xc1\x8e\x89\xf9\x88\
h\xc5\x07g\x17\xb1\x18\x87\xf9\xca~n\x17\xccO\x88\xce\xfbr\xb8\xd0\xc6s\xf3\
\xf9\xd9&[-\xf5y\x0c6Y\xeak3o\xdey\xb2\xfb\xe9\xa9\xba-\\\x8bTtO}M\x8b\xaeW\
\xbd\xfdv\xf3\xe1\x8d\x99\xb7\x7fm_|yg\xa6\xfe\xf5\xbe;\xef\xfa\xf3\xae\x9f\
\x9f\xae\x95\xbf\xad\x8e\xf3C\xc9v.\x90\xc7TK\\#JR\x12KR\xad\x92\x8bR\x81\
\x14\x83\x91\x81\xa1\xb9\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\
\xb1\xa5\xb6\x81\x91\x95\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\
\x0c\r\xac\x8c\x81\x1a\x0c!\x1av\xdb,X\x0c\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\
\xa1\t\x00\x149\xf2h' )

addArtData('wxART_ZOOM_FIT', 'wxART_OTHER_C', 16,
b'x\xda\xeb\x0c\xf0s\xe7\xe5\x92\xe2b``\xe0\xf5\xf4p\t\x02\xd2\x02 \xcc\xc1\
\x0c$5t\xf9\x83\x81\x14K\xba\xa3\xaf#\x03\xc3\xc6~\xee?\x89\xac@\xbeB\xb2G\
\x90/\x03C\x95*\x03CC3\x03\xc3\xcf\xff@\xfa%\x03C\xa9\x01\x03\xc3\xab\x04\
\x06\x06\xab\x19\x0c\x0c\xe2\xf9\x93\xe2\x8f\xba\x01\xd5\x9e\x0c\xf0\tq\xfd\
\xff\xff\xff\x85\x1b\x0f\xe6-\xdf\xb4a\xd7\xd1\xc9\x8b\x96o\xd8\xb0\xe1\xc3\
\x87\x0f\x17n\\X\xb0b\x03P\xea\xff\x8f\xff\x1f~\xfc\xdf\xb0\xe1@\xc3\x84\xf9\
\r\x13\x16\xd4\xf6\xce\xab\xec\x9c]\xd22\xe3\xc1\x8b\xff\x13&,\xa8\xe8\x98\
\x93W7\xe5\xc2\x83\xff\x0b6\x1c\xe8\xe8\x99X\xdc2=\xa3b\xc2\x81\x1b\x1f6\x9c\
x\x90\x9e\x91\x99T\xd4s\xe0\xc2\x87\r\x07\x1eD$d^\xb8p\xa1\xa2svq\xcb\x8c\
\xd8\xdc\x8e\r\x17>LXq\xa0\xa4yzxzkA\xc3\x84\xd6\ts&M\x9b\xb3`\xc3\x86\xe2\
\x9a\xea\t\x1d\tU\xf5m\x17\x0e4|\xb8\xb1`\xc3\x8c\x84\xf0\x84\xcc\xf0\x84\
\xa8\x82\xd2\xfc\x05\r\x06\x0fv8|x0!!\xc0`C\x87\xc1\x83\x0b\x13\x16LHX\xd0\
\xe1\xb0a\x82A\x80\x83A\x82\x87\x82\x83\x81A\xbd\x82\xd8\x13\xa0\xa7\x18K\
\x82\xfc\x82\x19\x1c\x9e\xddH\x03q\x92\xbc\xdd]\x18:Xe=\x80\x1c\xce\x02\x8f\
\xc8b\x06\x06nA\x10f\xacO\x89\x9f\x08\x14d/\xf1\xf4ue\x7f\xc8\xc1\xc7\xa5$\
\xff\xccoB\x19Ph\x9e\xa7\x8bc\x88\xc4\xe5\xe4\x84\x03L\x123g\xcc\x8c\x9c\xf0\
sMON\xce\x1b\x99\x9e\x02;vu\x81\x82\xc2\xcf\x07\\",+\x7f\xfe\xf8\xc1\xca\xd2\
\xda\xa2X\xc3\xe7\xe6\xa7\x10\xef\x12\x10\xe2\x13\xc3\xa4t\xe0\x18\xe7\x94\
\xe9"S\'M\x9b\xd8\xca\xc9p\xb5\xdb\xeb\xe4Im\r\'\x96);\xa6\x846\xd4\x84\x9a\
\x96\xba\xaeP\xbc#\xa5\xb0o\xd9\xacif.\x0e\xee\xe1\x1e>Qq\xbe\xbd\xfe\xfe\
\xf2Y\xeb\xb7m\xd8\xd1\xd3\xb4kZ\xe3\xc2\x89\x86>.\x17\x8f\x84\\<s\xe7\xd0\
\xa5K\x127\xdd\xc3\xae\x89M3\xdb\xa6\xa1T\xf6\x8do\xc5\xbe\xb2\x12&!\x86v_\
\xbeh\xff\xcc|k\xa0KUK\\#JR\x12KR\xad\x92\x8bR\x81\x14\x83\x91\x81\xa1\xb9\
\xae\x81\x89\xae\x91Q\x88\xa1\xb9\x95\xa1\x89\x95\xb1\xa5\xb6\x81\x91\x95\
\x81\x81M\xf0\xe9g(\x1ar\xf3S2\xd3*\xa1\x1a,t\rMB\x0c\r\xac\x8c\x81\x1a\x0c!\
\x1av\xdb,X\x0c\xd4\xc0\xe0\xe9\xea\xe7\xb2\xce)\xa1\t\x00&\x0e\x05/' )

addArtData('wxART_ZOOM_IN', 'wxART_OTHER_C', 16,
b'x\xdaU\x8eoHSQ\x18\xc6\xcf\xfc\x9f\xff\x9a\x82%\xa1\xb4B)\xca\xd5\xd94\xac\
!2c\xd3m\xbaq\xd5\x85\x1a\xa2\xc7t\xea@\xf3\xa63\xd2L\xafFq\xb5\x85g\x061A\
\xf4d\x84~\x08;\xad>\x84E\xdc@I\xac\xe0B\x05\x0b"n\x91R\xd1\x87\x0b}Q\x08nG\
\xeaK\x1f\xde\xf7\xe1y\xde\xf7\x07\xcf8\xe7\xa9HK\xde\x97\x0c\x00Hs:l5L\xf5;\
\x93\x14\xcb\xf6a\xe3\xeeZ&q\x1de\xee2\x00\x1eN\xa6\xfcn\x89g\xde\xd0\xea\
\xa8q\x030\x98\x0f\x80p\x15\x80m\x8d\xe9w\x00\xfa!\x00?\x10\x00\x960\x00{{\
\xa6\x9aW\xcb\xd9\xefc\xae\xcak\xd74M\x8e*\xb3\x0b\x11\xba\xbczk~\x81R\xaa\
\xaa\xaa\x1c\x95\xc9"e\'mKS\xb74J%\x01\x13E\xd5\x94o\x1a\xc6\x84\x17\x89\xac\
h\x84Jb0\xc4\x0b\x18\xf1\x98\xeb\x14\xa4\xa8J\xd7\x94\x8eN?/\x10t\tsH\x90d\
\x95JJ=\xf2\xcb\xb2Le\x15/J\xd7\xf0\xcc\xd4\xed\x19Bi\xdf\xd0e,\xa2\xc1\x91\
\xeb\xb2$\xa8QB\xc3\xa8\x0e\xf9\xeb\xd0Y\xbe\xbf\x87\x08PybU\x15\x8c8HE\xa8\
\xc8\x98`DD+\xc5\x90\xb3B\xe40X!\xfc\xf0(\xe7\x18\xeb\xaf\x0b\xd4xj\x81u3\
\xda\xbec\xceUV\xd8\x80\x18\x9f\xeb`f\x17\xefh\xe8\x03 %cgt#m\xcd!\x16&\x06\
\x9cn{\xe2\xe7\xa4\xf4\xe4\x83\xfb7=\xf8"\x8b\x88\xd3V\xe6\xcd~\xdb\x8a\xa4\
\x98\xec\xe9\xf0t\x03\xde\xbe\x1f\xec\xea\xfa\x99\x13\xe4K\x13\x0f\xe9\xf9\
\x0b\xbf$[\xfdhcS\xd3\xf9\xd2a]\xd2\xdcxF\x9ea\xed\xe5\xf1\xbc\x82\x98=\n\
\x8a]O\x99\x98\x18\xaft\xb8^\xc4\xc5\xdd\xf3\xad\xac\xf86\xbef\x19b&\x1a?\
\x0e}\x89d\xf6\xba\xd6\xf5\xba\x84t2\x10\x89\xf4\xba\\\xf3G\xf4\xba3\'\x86\
\x0f\x90g\x99\x0f\x96\x13\xde5e\xe9Z\x9c\x03\xbej\xb7\xb1;7,\x8e-\xcd\x8e=\
\x1f\xbd\x13\n\xa5G&\x83\xee\xd4\x9bUo8\xdbkcA\xf5\x95n_Z\x1ex_\x9e*l|\xc27X\
\xd7\xfc\x80\xbd>\xd0\xd6\x12\xf0YZ{}L\x80\x19\x9a\x8a\x8d\xb0\xc8h6{M\xc5\
\x16S\x91\xa5\xf0\xd4Qh\xb6@XR\xfbj\xf3?\xa0\xbb\xa7\xcd\xdf>\xf0\x0f8i4\x15\
yM\xd0R\xc8\x00\xd3_\xe0i\t\xb9\xcb\x00\xe0\xb4{lK\xa7\xd1\xd8\x1f\xb6Y\xf8\
\x06' )

addArtData('wxART_ZOOM_OUT', 'wxART_OTHER_C', 16,
b'x\xdaU\x91oHSa\x14\xc6\x8f\xff\xd8\xdc\xb2\xb4\x14E\x8a,Y\x051\xba\x9b\x03\
k\x88\xcc\xdcrs\xb9n\xdb@\x97\xe0^\xdb\xa6\x0e\x8c]uF\x99\xe4E3\xae&\xf8j\
\x10\n\x92/&(%\xf2\x16\x05R\x047P\x08\xfbr\xa1/\xfbx\x83\x92\n\x83\x0b\x11(\
\x04\xb7w\xd4\x97><\xe7\xe19\xe7\xfc\xe0\xc0\x99\xe0\x03ME\xa6J\x13\x00\x14\
\xf9\xbc\xee \xf3\xe2\xac\x8cy\xac\x9e\xb1\x1e\n1\xcb\xefnhi\x00x>m\xfe\xddY\
\xc0rU\xcc\x1bl\x01\x18\xb2\x00\x88c\x00\xfb:\xf3o\x00\x83\x1c\xc0w\x04\xe0\
\x9c\x03(O\xcdF\xb7.\xb1\xdd\x97\xfc\xe5\xb0G\xd7u%\xa3>^yA_o=\\Z\xa1\x94j\
\x9a\xa6d\x14\xb2J\xd9H\xdf\xd3\xb5=\x9dRY\xd5t\xf5\xab\x8e1QT\x9dPY\x9a\x9a\
\x111\x11$"\x88\x18\t\x98\xef\x11\xe5\x8cF\xdf\xab\xdd=IA$\xe8\x16\xe6\x91(+\
\x1a\xe3\xdaPRQ\x14\xaahxU\x1e\xc7\x0b\xb3\x8f\x16\x08\xa5\x03\xc3w\xb0\x84\
\x86F\xee+\xb2\xa8e\x08\x9dC\xad(\xd9\x8a\xae\t\x83)"r\xea\x86KS1\xe29*q\xaa\
\x82\tFDrQ\xcc\xf1.\x0ey\xab\\\x1c\xf7\xa3\xee\xca"\xbb?\'\x1d\x0c\x84\xc0\
\xb5\x93\xe9\xca\x86\xeb\xfe&7H\x05\xc7\xbc,\x14\n\xde\xc8\x00\x80\xb9$\xab\
\x9c\x91xt\x865\ri_\x8b\xc7\xf0\xc9x\xd0t\xf2\xf8N\x00\xdfd\xadi\x9f\xbb!\\\
\xf11\x86\xe4\xdc\x8a\xf9\xb9\xf9\x08\xde_\x9b\xea\xed\xdd=:%\xd4\x1bN\x17\
\x0b}?ew\xdb\x89\xe1\x8e\xfa\xbb\xc6\xc5\xb1\x92\xed\xf2\xe2\xd2Q#\xed3\x99\
\x1fH\x93\x13~o\xf3\xbb|\xf7rbs3\xf1\xe5sYU\xee$\xfau\xb8\xbfy\xdb\xc47\x92a\
\xcb\xd52I|Zy\xef\xdc\xdaz\xce\xab\xd6\xf1(\x1f\xec\x88\x84C\xfev\xc3\xa9%\
\xf2l\x85\xa4PO|yl\xb7:v\xa4\xb1:TSZ2`\xf6\x87\xa3\xed\x91\xbcBxk9\x10\xcclH\
\xecI`I{\xda\xd2\xf1\xcet\xc2\x19\xebO0\x03;g\xab\xb5r\x0e\xab\xdd\x1e\xb6\
\xd5:m\x0eg\xcd\x85\xb3\x9c\xdd\xc9qu\xa1\x0f;\xff\x017R\xf1d\xd7\xed\x7f\
\xc0y\xab\xcd\x11\xb6q\xce\x1a\x06\xd8\xfe\x02o\xea\xc8\x13\x06\x80\xcf\x13p\
\xaf_D\xa3\x7f\x00\xab\x8d\xee\xc9' )

addArtData('wxART_ZOOM_RECT', 'wxART_OTHER_C', 16,
b'x\xdaU\x8f}HSa\x14\xc6_5\x99N\xb42P+$1\xb7\x02\x19\xbd\xd3\x819\r\xb7\xdat\
\xab\x1cc\x9b\xe5\xc4r\xea,\x94b\xa2S\xcaJ\xe7\xc7t\xa1\xe9u\x92\x18I]\r\xca\
\xb2\xd65\xcc&\xc3\x18\xa1\xa2\x18\xee\xfaAN\x96xE\xb3\xdc\x1fq!,M\xe3\xf6\
\x8a\xfd\x13\x9c\xe7<<\x87\xf3\x83s\xee*\x15i\xc1\xecCl\x00@\xb0\\&Q!\xdf\
\xb7\xa3\x00?\xd4\x8f\xf3\xf6\xaa\x91\xed\xb9*N\x17\x03\xd0\xd7\x12\xb4\x9d\
\xeb\x8frT\xbeL\x95\x0e@\x05\x07\x00S-\x00\x9b\x0c\xf25\x00\xca \x00^\x1d\
\x00\xc2\x0e\x00\xc2\r\xd6\x9c\x91T\xb4K+\xcfk\xa4\x0c\xc3H\xd5\x86\xdd"\xdd\
\xd4\xa3go\xee\xe3\xaf\xf1^{C\xfbc\x82 \xe6\xe6\x17\x1c\xc3\x1f\xac\x0f\x9f:\
\x86]x\x0f\x81\x96\xc9Y\xcf\xf2\x17\xef\xf2\xa2wn\xd1\x8bw\xf7\x8f\xcf{\xc7\
\xa7\xbd\xe6\x86\x07\xa4\xcb\xe3\x98\xf0Z\xbb\xfb+\xeb\x9ah\x9af6\x18\xdb\
\xf0\x02\xfe\xce\x95WPDo0\x83\xe3\x1e\xdb\xd0\x02N\xb82.\x17\x91$I\xd1\xcc\
\xab!OW\x1fy\xa7\xed%\xf5\x8d!)\xc6\xe9\xa6\x9d$M\x90t\xb1\t3c\x9d\xd6\xf6N\
\x9c L\x18^z\xfb\x16f\xd1a\x18\x8e\x13Nb\x8c"\x9c\x14\xd6\xe3\xac\xa8\xaa\'\
\x9d&\xda\x8d\x13\x1d\xbaL]\xe1\xc5\x9d\xca*.3\xe0&H\xd9E4\x85\xe9\x94\x90\
\xb0@\x8a\xc4pL\x87[D\x04\x06\x95"\xa8\x93E\x89 l\xaf\x9cmD\xbf\xfb\x19U\n5\
\x10q\xdd\xbe!\\\x14}\xf2\xce\xa5I\x80\xc5?R\x86B`\xb1L[\n@\xd0\xfe\x1d\xf9T\
\xe9sZ\xd1\x90e\x94\xa7KYK\x01!\xec\xe8#\xab\n\xac\x1c\x8dlr\x89X\x131\x93\
\xd1<\x17R\x03#R\x1bG\xaa\xcf\xf6R\x174\xd9v\x9f_a,\xfb\xfa\x9f\xc5\xd1\xe9\
\xee\xc0\x9c6\xee\xd7\x95\xecm`\xaf\xfd\xcc\x0c\x8e\xb1\xce,\xc9L\xf7J\xb5T\
\xae ,\xfcy\x94\x7f\x0bT\xc4p\x129\x15f\x13\xbf\xde\xda9\xa9\xd7V\xdf\x88.\
\xa9\xfba\x8e\xe6)\x03c\xd91\xd96\x8dV\\\x97u4\xdb \xd0N\xa94\xc1\x03\xb9\
\xac\xf2\xa1$\xec\xc5\xfa\xef\xda.\xdba\xee\xa9\xd0\xa6\xd1\xa6c3\x07\x0f8;O\
\xb4\xf7\xbe\xed\x9b\xff\xfe3%?\xb2\xf9\xd3\xda\xb5\xa4I\x17y\xc96P\xea\xd8\
\xfa\xb8\xbc\xe9\xfb~(ee\xcb\xb7\xb5$t\xb3\x1aN\x95\xa0\xcb9Fi\xa6Q\x9fk,\
\x10\xe6\x97\x14 \x03q\x90\x9f\xc0\x83\x02^\\\x9c\x86\x9f \xe4\x0b\x84\xf1\
\x89\xb10N\x08a\xb2zb\xf5?\xe0\xbaA_x\xe5\xe6?\xe0$\x8f/\xd0\xf0\xa10\x1e\
\x01\xfc]\xc0\x91\x8c?A\x00\x90K\x15\x12\xdbi]\xcd_\x93\x957\xd9' )

addArtData('wxART_INFORMATION', 'wxART_OTHER_C', 32,
b'x\xda\x01\x81\t~\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\
\x00\x00 \x08\x06\x00\x00\x00szz\xf4\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\x0b\
\xfca\x05\x00\x00\x00 cHRM\x00\x00z%\x00\x00\x80\x83\x00\x00\xf9\xff\x00\x00\
\x80\xe9\x00\x00u0\x00\x00\xea`\x00\x00:\x98\x00\x00\x17o\x92_\xc5F\x00\x00\
\x00\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x00\tpHYs\x00\
\x00\x0e\xc3\x00\x00\x0e\xc3\x01\xc7o\xa8d\x00\x00\x08\x83IDATX\xc3\xc5\x97\
\xddo\x1cg\x15\xc6\x7f\xef;3\xbb\xeb\xdd\xf5&\xf5\xae7P+\x8d\x15\xbb\xaaZ\
\xa7v\xd3\xa4Y\x9b\x84\xf0\xd1 \xd4\xcaB\xd0\x08\xa9\x8d\xb8\xe4K\x14\xa9H\
\x95\x90\x80\x7f\x00\x81\xb8\xe2\xa6\x12 \x84*\x05\x81\xb8AX\xad\x90\x8a\x10\
\xc1\xad\xed|\xdb\x8d\xd3\xa4\xc9&\x9b\xa4\x9b8\xb67\x8e\xd7\xbb;3;\xef\x07\
\x17\xfb\x11\x07\xb54\x80\x10\xaf4;\x173{\xces\xcey\x9e3\xe7\x08k-\x0fr\x8a\
\xc5\xa2]XX\xa0T*QY]\xa5\xd1h\x10\x86!\x00\xf1x\x9cd2I6\x97cpp\x90\xd1\xd1Q\
\x86\x86\x86\xc4\x83\xd8\x15\x1f\x07`ff\xc6\xce\xce\xce\xb2\xbc\xbc\xcc\xf0\
\xf00CCC\x0c\x0c\x0c\x90\xcdf\xc9d2\x00T\xabU*\x95\n\xe5r\x99b\xb1\xc8\xe5\
\xcb\x97\xc9\xe7\xf3\x8c\x8f\x8f311!\xfe#\x00\xa5R\xc9NMMQ\xaf\xd5\xd8W(022\
\xc2\xfaz\x95\x1b\xe5\xdb\xac\xdemr\xb7&\xa8\xf9\x10E!F\xd5\xe8q\x9b|\xb2?\
\xc9\x93\xbb\x1e#\x97\xedcqq\x91\xe3ss\xa4\xd2i&\'\'\x19\x1c\x1c\x14\x0f\x0c\
`zz\xda\x1e;v\x8c\xb1\xb11\n\x85\x02\x97\x8bWY\xf7\x13|P\xcdquIQ\x0f,\x91\
\xb2D\xca\xa0\x8d\xc1\x98\x08\xa1B\x8c\n\x88\xb3\xc6\xb6\xd4\x12\xfb\x9f\xde\
\xc1\xd3\xbb\x9fdnn\x8e\xf9\xf9y\x0e\x1e<\xc8\x81\x03\x07\xc4\xc7\x02x\xeb\
\xad\xb7\xec\xa9\x93\'y\xee\xf9\xe7I\xf7\xf6R\xbcv\x87\xd2\xc6N.^\xf7\xa9\
\x87\x12m\x05\xca\x08\xa2\xc8Poh"\xad\xf1\xa4\xc1\x93\x06k\x9a\x08\x1b \x8cO\
\xcc\xae1\xd4w\x93#/|\x16\xdfo\xf0\xe6\x1bo\xb0g\xef^\x0e\x1d:$>\x12\xc0\xf4\
\xf4\xb4}{z\x9a\x97\x8e\x1c\xe1\xf6\xf22\xe5\xbb\xbd\x9c\xbc\x92a\xb5j\x89\
\xac\x87\xd1\x96\xc8\x805\x06e`\xff\xae\x14\xb9\xad\x0e\xc7\xce\xacs\xfdV\r\
\xcf\x05c\x14\xe8\x08i\x1bxT\xe9s\xae\xf1\xb5/=\xc1\xe0\x8e\xed\xfc\xf6\xe8Q\
\xf6\x1f8p_&\xba\x00J\xa5\x92=z\xf4(\x93\x93\x93\x84\xcd&\x17ne8Q\x8cS\x0b\
\x1c"\xe3a\xac\xc5Z\x81\xb5\x860\xd4|\xeb\xcby\xbe\xb87\x06@=\x82\xef\xfd\
\xac\xc4\xb5[>\x8ec1Fa\xb4F\xda\x90\xb8Xg\xabs\x9d\xaf\x1f~\x82\xad[z\x99\
\x9a\x9a\xe2\xc8\x91#]N\xc8\x0e\x92\xa9\xa9)\xc6\xc6\xc6H\xf7\xf6\xb2X\x82\
\xe3\x97b\xdc\xad\x0b\xfcH\xa2T\x84R\n\xad#\xc20"\x99\x80C{b\xdd\xcc\xa5<xvO\
\x0f\x1b\x8d&\xc6h\x94\xb2he\x08\x95\xa4\xd6L\xb2\x12<\xcc/\x7fw\x8aD\xa2\
\x87\xb1\xb11\xa6\xa6\xa6\xba\xff\x95\x1d\xa9\xd5k5\n\x85\x02\x7f\x9d>\xcb\
\xb9\xa5~*\x1b\x06?\xb4DME32\xe8H\xa3"\x8d1\x86\x8dZ\xc8\xd5\x9b\xea>\xee\
\xbc{\xe1\x16\x0e`\x94\xc1h\x836\x16\xad,\x91r\xa97\x93,\xf9\x03\xfc\xe2\xf5\
7(\x14\n\xd4k5fffl\x17\xc0\xec\xec,\xfb\n\x05\xce-\x9e\xa7\xb41\xcc\xad\x95\
\x80 \xb4\xe8H\xa3U\x84V\x11J+\xb4RX\xa3\x08B\xcd\x8f\x7fs\x95\xd3\xe7W\xb8V\
\xbe\xc3\xcf_?\xc9\xdfNW\x89{\x12\xa5\x0cFi\xb42(cQ\xda\xd0\x8c$\x8d(\xc5\
\xc2\xf5-\xcc\x9d8\xcd\xbeB\x81\xd9\xd9\xd9V\x06\x8a\xc5\xa2]^^fdd\x84S\xef~\
@y\xcd\xa1\x11\x18T\xd4b\xb8R\x1a\xdd\xbe"\xa5\x88"\x8d+-\x97\xae\x87|\xe7\'\
Wy\xf1\x07\x0b\xfc\xfa\xcd&n\xfc!\xc0`-XK\xebG[\x8c\x01c\xa0\xa9]|\xd3\xcb\
\x1f\xff|\x96\x91\x91\x11\x96\x97\x97)\x16\x8b\xd6]XX`xx\x98J\xe5\x0e7k\xdb\
\xb8\xbb\xde$\xd41\xac\xd5@\x87\xac\xf6\x9eQ\x0bZ\x19\xd2qI&\xd9\x8b\xb5\xbd\
Ha\xa9\xd5\x03*\x95*F\xb7\x80\x1a\xa3\xb1\xda\x82\xb4\x08$\x8e\xb4(OP\xbc\
\x9d\xe6\xf6\xede\x1e}\xf4Q\x16\x16\x16pK\xa5\x12\xbbw\xef\xe6\xec\xc2ynW\
\xf3\x84\xca\xa0\xb5\xa6\xa5\r\x01\x86\xfb@\x18+\x00\xcbK_H\xf0\xc2\xe7\xb34\
\xea>\x17\xae[\xbe\xfd\xfd_qum\x07[\xb6\xc4\xdb)\x10\x08\x01\x16\x8b\xb0 \
\x84 p\x156\xe1\xf2\xf7wN\xf1\xc4c;9s\xe6\x0c\xb2\xb2\xba\xca\xc0\xc0\x00\
\xd7\xca\x15\xea\x014\x9b\xa0\x94F)C\xa44Jw\xae\x16\xb1\xfcF@ee\x95]\x03\xeb\
\\\xba\xf0>\xe7\xdf{\x9f\x9d\x9f\xd0\xc4c\x02\xac@\n\x17)\x1c\xa4\x90\x80\
\x83\xc0A\x08\x07\x90h\xe3\xd0T\x0e\xe7.|\xc0\xc0\xc0\x00\x95\xd5U\xdcF\xa3A\
6\x9be\xe5ND\xa4Ai\x83\xb1\xc0\xa6\x06)\x84\xc4(\xc3zu\x9d\xca\xea\x1a\xae+\
\x89L\x86(h\x10\x04!\xc6\x18\xac\xa1[2k77;\x81m\x1b\xb3F`\x8c\xc3\xf5\xa5\
\x1a\xd9l\x96F\xa3\x81\x1b\x86!\x99L\x86F(\x89"\x83V\nc%X\xd12\'\x04A\x10p\
\xa7r\x87 \x08\xb0\x16\\\xc7\x05\xa3\xf1\xeb>A\xd0\xd2~\xcb\x83h9\xff\x88\
\x0f\xac\x15\x02m$\xf5\x86$\x93\xc9\x10\x86!n\xe7\xa16\x06\xad\rJ\xb7\xa3\
\x11 \x10\xd4\xea\r\xee\xae\xdd\xc5h\x83#\x1d\xb4\xb1`%\xc6@\xd8\x0cPJ\xd3\
\xed\xe6\xa2U\x86\x0f\xf9\xe6\xb5Rj\x05\x08q\x1f>7\x1e\x8fS\xadV\xf1d\x88\
\xd1M\x8cv0m\xd2\xd47\xeaT7\xaa`@\n\x89m\xa7Q\x08\x89\xb1\xd0\x8c\x9a\x18#\
\x11\xa2\xd3\xd7\x05\xa2\xdb\\\xef\xb9\xe9\x94@\x08\x81\x83%\x19\xd7T\xabU\
\xe2\xf18n2\x99\xa4R\xa9\xd0\xb7E\xa0V\x9aX\xe3\x81\xb1\xd4\xfc\x90\x8d\x8d\
\xda&)vlv\x0c\xb7\xe4\xe18N\xfb\x15\xd1\xeek.`7\x0b\x18\x01\x084\x12\x8b#-\
\x03\xf9\x1e*\x95\n\xc9d\x12\x99\xcd\xe5(\x97\xcb\xec\xdc\xbe\r\xd7\xf8X\xa3\
\xf0\x83\x80Z\xad\x8e\x10\x9bdh;ND\xdb\xa4\xc4\xf3b\xc4\xe3\t\x1c\xc7A \x10\
\xb8\x08\xe1 q@8m\x15\xb8-%\xe0 \xa5@G\x01O\xed\xdaA\xb9\\&\x9b\xcb!\x07\x07\
\x07)\x16\x8b<\xb3g\x94\x94\xbb\x8e\xd5!u\xdfo9\xb3\x02\xe4f\xa7\xed(\x8d@\n\
\xe8\xe9I\x90L&qe\x87J\xb2\x0b\xa2#?!d\xfbr\x88IK\x8f\xb3\xc1\xc1\xfd{\xb9r\
\xe5\n\x83\x83\x83\xc8\xd1\xd1\xd1\xf6\x0c\xd7\xcf`\xdf\x1dt\xb8\x814\x8a.U\
\x0cmE\x886\x9d$ I$b$\x93)R\xe9\x14\x8e\xe7"D\xab\xfe\x02\x07p7E\xde\xba{\
\x0e\xc4\xdc\x88\xc7\xb7\xd7\xd9\xb6-\xcf\xe5K\x97\x18\x1d\x1dE\x0e\r\r\x89|\
>\xcf\xe2\xe2"\xcf=;\x86gW\xf1\x9c\xa8\x1b\xf3\xfd\x1c\x90\xedl\x80\x17\xefa\
\xcb\x96\x0c\xfd\xd9\x1c\xf1X\xac\xad\x80V\x03\xba\x17\xb9\x83D\xe2\x08I\xcc\
5\xc8h\x85#\x87\'8\x7f\xfe<\xfd\xf9<CCCB\x02\x8c\x8f\x8fs|n\x8e}\xcf\xec\xa1\
0\\%\x86\x8f\'uW=-r9\xdd\xe8\xb1\x90L\xa4\xe8\xcfm#\xd7\xdf\x8f\x90N\x9b\xfb\
\x02\xd9\xe9~\xb8\x08$R\n<W\x93\xf4\x1aL\xec\xaaS\xd8\xf74s\xb3\xb3\x8c\x8f\
\x8f\xdf\x9b\x07&&&D*\x9dfnn\x8e\x97\xbf\xf1U\xb6g\xae\x92p\x1axR\xb7S{\x8f\
\xe5\x02\x89\xd1\x90N\'\xe9\xcbe\xe9\xe9\xe9i=\x95\x12\xda\xf5\x96B\xe2\x08\
\x81+\x04\x9ecH\xc7\x1ad\x13\xef\xf3\xeaw\x0fw\'\xe5\xce\xb8\xde\x9d\x88&\'\
\'\x99\x9f\x9f\'\x0c\x03^\xfd\xe6\xb3\xe4\x937H\xc8:1G!D\xeb\xc5N\x9d\x8d\
\x86\xd3\x8b7\t\x02E\x18\x06\x9c\xbb\xb8B\x18(\\!\xdb [\x15\xf1\\E:^\'\xe3^\
\xe4G\xaf|\x0e\xdf\xf79;?\xcf\xe4\xe4\xe4\xbd\x16\xf5QC\xe9\x95+%~\xfa\xda_\
\xb8\xb1\xbe\x93\xa6M\x11\xa9\x04\xc6\xba`=\x8c\x91\xe4c\'\xe8K\x87\x18+\xd1\
\xdar\xab\xf6\x14\xa1\xc9\xe1\xba\xe0\x08\x85\xe7\x84\xc4\xdd\x1a\xfd=\xef\
\xf1\xc3W>\xc3#\x8f\x0c\xfc\xeb\xa1\xb4s6\x8f\xe5\xf1x\x82\x9f\xbf\xf6{\xde\
\xb9\xb0\x95\xd0\xe40\xa4\xd0&\x86\xb1\x1e\xbeo\x89\x9aa+Z\xe9\x90N\xa5\x88\
\xc7@\xd2\xc4\x93>B/\xf1\xa9\x915^y\xf9+4\xea\xf5\x07\x1b\xcb7gb\xf3b\xf2\
\xce\xccq\xfe\xf0\xa7\x13\\,\xf7\xe1G\x0faE\nK\x0c\xf0Z\xd2\x13\x1a)4F7H8+<\
\xbe}\x8d\x17\x0f\x17xf\xcf\xd8\xbf\xbf\x98t\xce\x87\xadfKK\xb79\xf6\xf6)\
\x16\x16o\xb0\xb4\xaa\xa8\xfb\x1e\x00\xa9\x1e\xcd\xc3\xf9\x18c#\x03|\xfa\xc0\
^\xf2\xfd\xb9\xffn5\xdb|\xfeo\xcb\xe9?\x9f\xff\xd5z\xfe\x0f\xb8-\xe5\xb0]:@$\
\x00\x00\x00%tEXtdate:create\x002017-04-22T17:14:40+02:00\xa3\x0e\x87,\x00\
\x00\x00%tEXtdate:modify\x002017-08-14T10:34:32+02:00\x8a\xd4\xba>\x00\x00\
\x00\x00IEND\xaeB`\x82\xf0cf\xdb' )

addArtData('wxART_VIEW', 'wxART_OTHER_C', 32,
b'x\xda\x01\xdc\x03#\xfc\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00 \x00\
\x00\x00 \x08\x06\x00\x00\x00szz\xf4\x00\x00\x00\tpHYs\x00\x00\x0b\x13\x00\
\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x03\x8eIDATX\xc3\xedV=o\\E\x14\xbd3\
\xf7kf\xde\xee\xda\xd1\xdak\xcb2\x05\x11I\x157)B\x87dSD\x04)\x96P\n\\\xd8\
\x15\x15\x7f\x00\x89\xff@CD\x83\xb1,~\x81\x1bBdEr$\xcb\r.\xf8\x03FI\n@Vl\xd9\
\x128\xc1\xfb\xe1\xbd\x14\xec<\xad7K\x88!\x12\x8a\xb4\xb7z\xef\xcd}\xef\xcc=\
g\xee\xb9\x0f`\x14\xa3\x18\xc5\xff\x1c\xee"\xc9\x93\x93\x93\xd5\xa3\xa3\xa3\
\xeb\xde\xfb\x1b\x00p\xc597efm\x008r\xce=1\xb3\xdd\xf1\xf1\xf1\xdd\x83\x83\
\x83\xdf^\xdb\x0e\x1b\x8d\x06\x8a\xc8\xa2\x88l!\xe23"2\xef\xbd9\xe7\x8c\x88\
\x8c\x88\xcc9g\xde{cfc\xe6&3o\xc6\x18?\x9a\x9e\x9e\xe6\x7f\r<77\xe7c\x8cK!\
\x84=f6\xef\xbdy\xef\r\x11\r\x11\xcfm \xaf\x11\x91!by\xcd\xcc{EQ,]\x18<\xc68\
\xa3\xaa\x0fE\xa4\xacVD\xceU+"\xe6\x9c{\x81\tD\xb4\xfc^f%\xa5\xf4\x80\x99g^\
\x15|\x81\x99\x0f\xf3G\x98\xb9\xcb\xcc[)\xa5\xcf\x98\xb9\x04 \xa2\x12\x08\
\x11K&z\x80\x9f\xf7$\xeb\xe6\xcd1\xf3~\x8cq\xfe\xa5\xe0)\xa5eD<Q\xd5\xfc\xd1\
\xc7)\xa5\xdb\x00\x00\xcc\xfc%"ZJi\'\xc6x-\x84p5\xa5t\x8f\x99K&\xb2T\xcc\xfc\
\x05\x00@Q\x14w\x10\xf1qf\x8c\x99ODd\xf9\xef*_\x11\x91\x8e\x88\x18"Z\x08a\
\x83\x88\x1ay\x9d\x99\xb7E\xc4RJ\xd7\xf2\xb3j\xb5z\t\x11\x9f\x0fjOD\x0fs\x8e\
\xaa6T\xf5\xbb|v\x98\xb9#"+/\xd0\x9e\xc1\x89\xc8Tu\x8d\x88|\x7f\x8e\x88l\xf7\
\xaa\xb8\x9a\x9fU*\x95\x02\x11\x9fg\t\xfa\xce\xc7v\xff\xbb\x13\x13\x13>\xc6\
\xb8\xd6\'GGD\x16r\x15\x97U\xf5i\xd67\xc6\xb8."~\x90!f\xbe\x8b\x88V\xa9T\xee\
\xa5\x94.\x8d\x8d\x8d\x15\xaa\xfa\xd5`\x1b\xf6@\xee\x0e!\xd9\xc7\x18\xd7s\
\x9e\xaa>\xad\xd5j\x97\xa9\xd5j\xb5\xcd\xec\xaf\x0c\xef\xc1\xcc \xdf\xf7\x07\
"\xaew\xbb\xddO\x9b\xcd\xe6-3\xfb\xa5\xd5j\x01\x00\xc4\xfe\\3\x03\xe7\\\x17\
\x00\xd6\x87\xc9\xdc[/1\x9cs\xa5\x04\xf3\xce\xb9?zFb\xaa\xba\x06\x00~\xc8!]\
\xcdZ\xf7\xb7h\xa6\xb6wvV\x87U\x1fBX\xcb\x9d\xc3\xcc\x9d\x10\xc2\xc2 \xc5+D\
\xd4\xc9R\x84\x106T\xb5\xd1\x9f\xa3\xaa,"\xab"r\x96\xfb\xbc\xaf\r\xcfT\xf5\
\xdb\x94\xd29\xf7\x0b!4Tu#o\xb2\x87\xb12\xb4\x13Dd\x99\x99OB\x08\xd9\xf1\x1e\
\xa9\xea\x87\x83y\xaa\xfa\x1e"~\xcd\xcc;"\xb2\xc3\xcc\xeb\xb5Z\xed\xfd\xc1\
\xbc\xa2(n\x13Q\xd9\x86"r\xc2\xcc\x1f\xbf\xd4\x0bB\x08\xf3D\xb4\x9f\xdb\x91\
\x88\xba\xaa\xbaU\x14\xc5\xcd\xd9\xd9Y\xffOF\x16B\xf0)\xa5\x9b"\xb2\x89\x88\
\xdd,+\x11\xed\x87\x10\xe6_i\x1aV\xab\xd5\x99f\xb3\xf9\x8ds\xee\x83V\xab\x05\
\xce9 "0\xb3\x9f\x00\xe0{\xef\xfd\x8f\x00\xf0HD~n\xb7\xdbm\x00x\xbb\xd3\xe9\
\xbc\x05\x00\xef:\xe7ny\xef\xdf\xe9t:\xd0\xedv\x81\x88\x80\x88\xee\x9b\xd9\'\
\xa7\xa7\xa7\xbf^h&0\xf3\x9d\x10\xc2\xde\xa0\xd1\xf4\x99J\xd9z\xc3\x86\x11\
\x11\xedU\xab\xd5\xa5\xff4\x8e\xa7\xa6\xa6PD\x16U\xb5\x1c\xc7\x83\xd30\xfb@\
\xcfd\x9e1\xf3&3/\xd6\xebu|\xad?$\xf5z\xbdz|||\x9d\x99o\x98\xd9\x15\x00\x982\
\xb3\xb6s\xee\x08\x11\x9f\x9c\x9d\x9d\xed\xd6j\xb5\x1f\x0e\x0f\x0f\x7f\x1f\
\xfd\xeb\x8db\x14oL\xfc\t\xaf1b&G\xb6\x02H\x00\x00\x00\x00IEND\xaeB`\x82\xbc\
P\xcc;' )

disabled = '_DISABLED'

def getArtData(artId:str, client:str=wx.ART_OTHER, size:int=16):
	if artId.startswith('wxART_'):
		id = artId
	else:
		id = 'wxART_' + artId
	if id.endswith(disabled):
		id = id[:-len(disabled)]
	if id in artData:
		item = artData[id]
		if size in item:
			itemSize = item[size]
		else:
			sizeDiff = 10000
			bestSize = None
			for s in list(item.keys()):
				if abs(size - s) < sizeDiff:
					bestSize = s
					sizeDiff = abs(size - s)
			assert isinstance(bestSize, int)
			itemSize = item[bestSize]
		if client in itemSize:
			return itemSize[client]
		elif wx.ART_OTHER in itemSize:
			return itemSize[wx.ART_OTHER]
		elif itemSize:
			return list(itemSize.values())[0]


class Artprovider(wx.ArtProvider):
	def CreateBitmap(self, artId:str, client:str, size:wx.Size):
		data = getArtData(artId, client, size.width)
		if data is None:
			return wx.NullBitmap
		image = wx.Image(BytesIO(zlib.decompress(data)))
		if artId.endswith(disabled):
			bitmap = wx.Bitmap(image.ConvertToGreyscale())
		else:
			bitmap = wx.Bitmap(image)
		return bitmap