/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.GZIPOpen;
import Trace.TraceFile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observer;

public class TraceServer {
    private boolean use_compression;
    public static final int TYPE_TRACE = 0;
    private static final String CGI_BASE = "http://lpgws.nci.nih.gov/perl/ts";

    public TraceServer() {
        this.setup();
    }

    private void setup() {
        this.use_compression = false;
    }

    public void set_compression(boolean compression) {
        this.use_compression = compression;
    }

    public TraceFile get_trace(int ti) {
        TraceFile result = null;
        try {
            DataInputStream dis = this.getStream(ti, 0);
            result = new TraceFile(Integer.toString(ti), dis);
        }
        catch (Exception e) {
            System.err.println("ERROR opening trace stream: " + e);
        }
        return result;
    }

    public TraceFile get_trace(int ti, Observer o) {
        TraceFile result = null;
        try {
            DataInputStream dis = this.getStream(ti, 0);
            result = new TraceFile(Integer.toString(ti), dis, o);
        }
        catch (Exception e) {
            System.err.println("ERROR opening trace stream: " + e);
        }
        return result;
    }

    public DataInputStream getStream(int ti, int type) throws IOException {
        DataInputStream result = null;
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("ti", Integer.toString(ti));
        if (this.use_compression) {
            params.put("compress", "yes");
        }
        result = this.open_url(CGI_BASE, params);
        if (this.use_compression) {
            result = GZIPOpen.open(result);
        }
        return result;
    }

    public DataInputStream open_url(String u, Hashtable params) throws IOException {
        URL url = new URL(u);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        System.err.println("POST: " + u + "?" + sb.toString());
        printout.writeBytes(sb.toString());
        printout.flush();
        printout.close();
        DataInputStream result = new DataInputStream(new BufferedInputStream(urlConn.getInputStream()));
        return result;
    }
}

