/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.BooleanComparator;
import TCGA.ByteComparator;
import TCGA.DoubleHashMap;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.SampleSortTools;
import java.util.ArrayList;

public class SubsetCombiner {
    private GenomicMeasurement gm;
    private GenomicMeasurement gm_combined;

    public SubsetCombiner(GenomicMeasurement gm, String subset_a, ByteComparator bc_a, String subset_b, ByteComparator bc_b, BooleanComparator bc_join) {
        ArrayList<GenomicSample> rows_raw = gm.get_rows_raw();
        ArrayList<String> patients = GenomicSample.get_patient_id_list(rows_raw);
        SampleSortTools sst = new SampleSortTools(rows_raw);
        DoubleHashMap ps_map = sst.build_patient_subset_map();
        String[] headers = gm.get_headers();
        ArrayList<GenomicSample> results = new ArrayList<GenomicSample>();
        for (String patient : patients) {
            GenomicSample gs_a = (GenomicSample)ps_map.get(patient, subset_a);
            GenomicSample gs_b = (GenomicSample)ps_map.get(patient, subset_b);
            if (gs_a == null || gs_b == null) continue;
            GenomicSample gs_new = new GenomicSample();
            gs_new.sample_id = "results for " + patient;
            gs_new.patient_id = patient;
            gs_new.copynum_data = new byte[gs_a.copynum_data.length];
            results.add(gs_new);
            for (int i = 0; i < gs_a.copynum_data.length; ++i) {
                byte dp_a = gs_a.copynum_data[i];
                byte dp_b = gs_b.copynum_data[i];
                boolean conditional_a = dp_a == -99 ? false : bc_a.compare(dp_a);
                boolean conditional_b = dp_b == -99 ? false : bc_b.compare(dp_b);
                byte dp_result = bc_join.compare(conditional_a, conditional_b) ? (byte)1 : 0;
                gs_new.copynum_data[i] = dp_result;
            }
        }
        System.err.println("src=" + rows_raw.size());
        System.err.println("rlen=" + results.size());
        this.gm_combined = new GenomicMeasurement(results, gm);
    }

    public GenomicMeasurement get_results() {
        return this.gm_combined;
    }
}

