/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.BinIndex;
import TCGA.CombineInfo;
import TCGA.CommentOptions;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.HelpLauncher;
import TCGA.JCheckBoxMap;
import TCGA.JComboBoxToolTipHelper;
import TCGA.Pathway;
import TCGA.PathwayGenes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import layout.SpringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationControl
extends Observable
implements ActionListener,
KeyListener {
    private static final String LABEL_OK = "OK";
    private static String LABEL_CANCEL = "Cancel";
    private static String LABEL_ZOOM = "Zoom";
    private static String LABEL_NEW_WINDOW = "New window";
    private static String LABEL_HELP = "Help";
    private JFrame jf;
    private JPanel panel;
    private JButton jb_ok_bin;
    private JButton jb_ok_loc;
    private JButton jb_cancel;
    private JButton jb_zoom_bin;
    private JButton jb_zoom_loc;
    private JButton jb_markers;
    private JButton jb_pathway;
    private JButton jb_help;
    private JButton jb_ok_sample;
    private JButton jb_zoom_sample;
    private JComboBox jc;
    private JComboBox jc_pathways;
    private JComboBox jc_samples;
    private JCheckBox cb_sort;
    private JTextField tf;
    private JTextArea jta;
    private JScrollPane jsp_genes;
    private boolean wants_zoom;
    private BinIndex bin_index;
    private GenomicMeasurement gm;
    private GenomicSet gs;
    private String selected_label;
    private Pathway selected_pathway;
    private PathwayGenes pathway_genes;
    private Integer wants_sort_bin = null;
    private JCheckBoxMap jcbm = null;

    public NavigationControl(GenomicMeasurement gm, GenomicSet gs) {
        this.gm = gm;
        this.gs = gs;
        this.setup();
    }

    private JPanel create_panel(String label, Component c, Component b) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabel jl = new JLabel(label);
        p.add("West", jl);
        p.add("Center", c);
        p.add("East", b);
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return p;
    }

    private JPanel panel_wrap(Component c) {
        JPanel p = new JPanel();
        p.add(c);
        return p;
    }

    private void setup() {
        this.pathway_genes = new PathwayGenes();
        this.pathway_genes.sleep_until_ready();
        this.bin_index = new BinIndex(this.gm);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        JPanel sub_p = this.get_buffer_titled_panel(this.panel, "Move to a location, region, or sample");
        sub_p.setLayout(new SpringLayout());
        int rows = 0;
        sub_p.add(new JLabel("Select a location:", 11));
        this.jc = new JComboBox<String>(new Vector<String>(this.bin_index.get_unique_list()));
        sub_p.add(this.jc);
        this.jb_ok_bin = new JButton(LABEL_OK);
        sub_p.add(this.jb_ok_bin);
        this.jb_zoom_bin = new JButton(LABEL_ZOOM);
        sub_p.add(this.jb_zoom_bin);
        this.cb_sort = new JCheckBox("Sort", false);
        sub_p.add(this.cb_sort);
        ++rows;
        if (this.gm.is_genome_formatted()) {
            sub_p.add(new JLabel("Genomic region:", 11));
            this.tf = new JTextField(20);
            sub_p.add(this.tf);
            this.jb_ok_loc = new JButton(LABEL_OK);
            sub_p.add(this.jb_ok_loc);
            this.jb_zoom_loc = new JButton(LABEL_ZOOM);
            sub_p.add(this.jb_zoom_loc);
            this.tf.setText("chr7:3000000-100000000");
            sub_p.add(new JLabel());
            ++rows;
        }
        Vector<String> labels = new Vector<String>(this.gm.get_visible_sample_ids());
        this.jc_samples = new JComboBox<String>(labels);
        sub_p.add(new JLabel("Sample ID:", 11));
        sub_p.add(this.jc_samples);
        this.jb_ok_sample = new JButton(LABEL_OK);
        sub_p.add(this.jb_ok_sample);
        this.jb_zoom_sample = new JButton(LABEL_ZOOM);
        sub_p.add(this.jb_zoom_sample);
        sub_p.add(new JLabel());
        SpringUtilities.makeCompactGrid((Container)sub_p, (int)(++rows), (int)5, (int)6, (int)6, (int)6, (int)6);
        this.panel.add(sub_p);
        sub_p = this.get_buffer_titled_panel(this.panel, "Drill down to a set of markers");
        sub_p.setLayout(new SpringLayout());
        sub_p.add(new JLabel("Pathway:", 11));
        labels = new Vector();
        for (String s : this.pathway_genes.get_pathway_names()) {
            labels.add(s);
        }
        this.jc_pathways = new JComboBox<String>(labels);
        this.jc_pathways.setPrototypeDisplayValue("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        new JComboBoxToolTipHelper(this.jc_pathways);
        sub_p.add(this.jc_pathways);
        boolean BUTTON_MESS = false;
        if (BUTTON_MESS) {
            this.jb_pathway = new JButton(LABEL_NEW_WINDOW);
            sub_p.add(this.jb_pathway);
        } else {
            this.jb_pathway = new JButton(LABEL_NEW_WINDOW);
            sub_p.add(this.panel_wrap(this.jb_pathway));
        }
        sub_p.add(new JLabel(""));
        sub_p.add(new JLabel("-or-   ", 11));
        sub_p.add(new JLabel(""));
        sub_p.add(new JLabel(""));
        sub_p.add(new JLabel(""));
        this.jta = new JTextArea(4, 25);
        this.jta.setText("(example: VSTM2A SEC61G EGFR LANCL2 GBAS)");
        this.jsp_genes = new JScrollPane(this.jta, 20, 30);
        sub_p.add(new JLabel("Enter marker list:", 11));
        sub_p.add(this.jsp_genes);
        if (BUTTON_MESS) {
            this.jb_markers = new JButton(LABEL_NEW_WINDOW);
            sub_p.add(this.jb_markers);
        } else {
            this.jb_markers = new JButton(LABEL_NEW_WINDOW);
            sub_p.add(this.panel_wrap(this.jb_markers));
        }
        sub_p.add(new JLabel(""));
        rows = 3;
        CommentOptions co = this.gm.get_options();
        if (co.has_combines()) {
            ArrayList<CombineInfo> combines = co.get_combines();
            sub_p.add(new JLabel("Import data from related heatmaps:", 11));
            JPanel pool_p = new JPanel();
            pool_p.setLayout(new BoxLayout(pool_p, 3));
            this.jcbm = new JCheckBoxMap();
            for (CombineInfo ci : combines) {
                JCheckBox jcb = new JCheckBox(ci.get_label(), false);
                this.jcbm.add_checkbox(jcb, ci);
                pool_p.add(jcb);
            }
            sub_p.add(pool_p);
            sub_p.add(new JLabel(""));
            sub_p.add(new JLabel(""));
            ++rows;
        }
        SpringUtilities.makeCompactGrid((Container)sub_p, (int)rows, (int)4, (int)6, (int)6, (int)6, (int)6);
        this.jb_cancel = new JButton(LABEL_CANCEL);
        sub_p = new JPanel();
        this.jb_help = new JButton(LABEL_HELP);
        sub_p.add(this.jb_help);
        sub_p.add(new JLabel("    "));
        sub_p.add(this.jb_cancel);
        this.panel.add(sub_p);
        this.jb_ok_bin.addActionListener(this);
        this.jb_ok_sample.addActionListener(this);
        this.jb_zoom_sample.addActionListener(this);
        this.jb_zoom_bin.addActionListener(this);
        this.jb_markers.addActionListener(this);
        this.jb_pathway.addActionListener(this);
        this.jb_cancel.addActionListener(this);
        this.jb_help.addActionListener(this);
        this.jc.addActionListener(this);
        this.jc_pathways.addActionListener(this);
        if (this.gm.is_genome_formatted()) {
            this.jb_ok_loc.addActionListener(this);
            this.jb_zoom_loc.addActionListener(this);
            this.tf.addActionListener(this);
        }
        this.jc.addKeyListener(this);
        this.jc_pathways.addKeyListener(this);
        this.jf = new JFrame("Navigation");
        this.jf.getContentPane().add(this.panel);
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public void setState(int state) {
        this.jf.setState(state);
    }

    private void jump_to(String target) {
        String[] pos;
        this.fire_clear();
        String[] f = target.split(":");
        boolean parse_error = true;
        int[] positions = new int[]{-1, -1};
        int ok = 0;
        if (f.length == 2 && (pos = f[1].split("-")).length == 2) {
            for (int i = 0; i < 2; ++i) {
                try {
                    positions[i] = Integer.parseInt(pos[i]);
                    ++ok;
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int chr = this.gs.chr2int(f[0]);
            if (ok == 2 && chr > 0) {
                int start_bin = this.gs.get_bin_for(chr, positions[0]);
                int end_bin = this.gs.get_bin_for(chr, positions[1]);
                Rectangle selection = this.gm.generate_selection(start_bin, end_bin - start_bin + 1);
                this.setChanged();
                this.notifyObservers(selection);
                parse_error = false;
            }
        }
        if (parse_error) {
            JOptionPane.showMessageDialog(this.jf, "please specify coordinates in format chrX:start-end, e.g. \"chr7:1-30000000\"", "Formatting error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextField) {
            this.jump_to(this.tf.getText());
        } else if (src.equals(this.jc_pathways)) {
            String pname = (String)this.jc_pathways.getSelectedItem();
            Pathway p = this.pathway_genes.get_pathway(pname);
            StringBuffer sb = new StringBuffer();
            for (String gene : p.genes) {
                sb.append(gene + "\n");
            }
            this.jta.setText(sb.toString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JScrollBar v = NavigationControl.this.jsp_genes.getVerticalScrollBar();
                    v.setValue(v.getMinimum());
                }
            });
        } else if (src instanceof JButton) {
            JButton jb = (JButton)src;
            String label = jb.getText();
            if (jb.equals(this.jb_markers)) {
                String[] markers = this.jta.getText().split("\\s+");
                ArrayList<String> m2 = new ArrayList<String>();
                for (int i = 0; i < markers.length; ++i) {
                    m2.add(markers[i]);
                }
                this.launch_markers(m2);
            } else if (jb.equals(this.jb_help)) {
                HelpLauncher hl = new HelpLauncher("navigation");
                hl.launch_url();
            } else if (jb.equals(this.jb_pathway)) {
                this.fire_pathway();
            } else if (label.equals(LABEL_CANCEL)) {
                this.jf.setVisible(false);
            } else {
                this.fire_single(jb);
            }
        }
    }

    private void fire_clear() {
        this.selected_label = null;
        this.selected_pathway = null;
        this.wants_sort_bin = null;
    }

    private void fire_single(JButton jb) {
        this.fire_clear();
        boolean bl = this.wants_zoom = jb.equals(this.jb_zoom_bin) || jb.equals(this.jb_zoom_loc) || jb.equals(this.jb_zoom_sample);
        if (jb.equals(this.jb_ok_bin) || jb.equals(this.jb_zoom_bin)) {
            String selected = (String)this.jc.getSelectedItem();
            int index = this.bin_index.find(selected);
            Rectangle selection = this.gm.generate_selection(index);
            if (this.cb_sort.isSelected()) {
                this.wants_sort_bin = new Integer(index);
            }
            this.selected_label = selected;
            this.setChanged();
            this.notifyObservers(selection);
        } else if (jb.equals(this.jb_ok_loc) || jb.equals(this.jb_zoom_loc)) {
            this.jump_to(this.tf.getText());
        } else if (jb.equals(this.jb_ok_sample) || jb.equals(this.jb_zoom_sample)) {
            Rectangle selection = this.gm.generate_selection((String)this.jc_samples.getSelectedItem());
            this.setChanged();
            this.notifyObservers(selection);
        }
    }

    public Pathway get_selected_pathway() {
        return this.selected_pathway;
    }

    public String get_selected_label() {
        return this.selected_label;
    }

    private void fire_pathway() {
        this.fire_clear();
        String pname = (String)this.jc_pathways.getSelectedItem();
        this.selected_pathway = this.pathway_genes.get_pathway(pname);
        this.launch_markers(this.selected_pathway.genes);
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            GenomicMeasurement gm = new GenomicMeasurement("combine\\Gene_CopyNumber_OV_Broad_Paired_Affymetrix.txt", false);
            GenomicSet gs = new GenomicSet(gm, 1, null);
            NavigationControl navigationControl = new NavigationControl(gm, gs);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public boolean wants_zoom() {
        return this.wants_zoom;
    }

    public Integer wants_sort_bin() {
        return this.wants_sort_bin;
    }

    private void launch_markers(ArrayList<String> markers) {
        ArrayList<Integer> wanted = new ArrayList<Integer>();
        ArrayList<String> missing = new ArrayList<String>();
        for (int i = 0; i < markers.size(); ++i) {
            String marker = markers.get(i);
            int index = this.bin_index.find(marker);
            if (index == -1) {
                missing.add(marker);
                continue;
            }
            wanted.add(new Integer(index));
        }
        if (missing.size() > 0) {
            System.err.println("MISSING:" + missing.toString());
            JOptionPane.showMessageDialog(this.jf, "Can't find markers " + missing.toString(), "Warning", 2);
        }
        if (wanted.size() > 0) {
            this.setChanged();
            this.notifyObservers(wanted);
        }
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        jp_buffer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Object src = ke.getSource();
        if (ke.getKeyCode() == 10) {
            if (src.equals(this.jc_pathways)) {
                this.fire_pathway();
            } else if (src.equals(this.jc)) {
                this.fire_single(this.jb_zoom_bin);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public ArrayList<CombineInfo> get_selected_combinations() {
        ArrayList<CombineInfo> results = new ArrayList<CombineInfo>();
        if (this.jcbm != null) {
            for (Object o : this.jcbm.get_selected()) {
                results.add((CombineInfo)o);
            }
        }
        return results;
    }

    public JFrame get_jframe() {
        return this.jf;
    }
}

