/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.Transcript;
import java.util.Comparator;

public class TranscriptComparatorBySimilarity
implements Comparator {
    static final int DISTANCE_RANGE = 100;
    static final int NT_MAX_DISTANCE = 100000;

    public int compare(Object o1, Object o2) {
        Transcript t1 = (Transcript)o1;
        Transcript t2 = (Transcript)o2;
        int t1_start = t1.get_first_exon_start();
        int t1_end = t1.get_last_exon_end();
        int t1_xcount = t1.get_exon_count();
        int t1_span = t1.span_size;
        int t1_product = t1.product_size;
        int t2_start = t2.get_first_exon_start();
        int t2_end = t2.get_last_exon_end();
        int t2_xcount = t2.get_exon_count();
        int t2_span = t2.span_size;
        int t2_product = t2.product_size;
        if (t1_start == t2_start && t1_end == t2_end && t1_xcount == t2_xcount && t1_span == t2_span && t1_product == t2_product) {
            return 0;
        }
        int dist_xcount = (t2_xcount - t1_xcount) * 10;
        System.err.print("start dist ");
        int dist_start = this.get_distance(t1_start, t2_start, 100000, 25);
        System.err.print("span dist ");
        int dist_span = this.get_distance(t1_span, t2_span, 1000, 25);
        return dist_xcount + dist_span;
    }

    private int get_distance(int pos1, int pos2, int max_raw_dist, int max_dist) {
        int raw_diff = pos2 - pos1;
        if (raw_diff > max_raw_dist) {
            raw_diff = max_raw_dist;
        } else if (raw_diff < -max_raw_dist) {
            raw_diff = -max_raw_dist;
        }
        int dist = raw_diff * max_dist / max_raw_dist;
        System.err.println("  raw=" + (pos2 - pos1) + " cooked=" + raw_diff + " dist=" + dist);
        return dist;
    }
}

