/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.BAMExcerpt;
import IsoView.ExonSpliceFilter;
import IsoView.IsoViewConfig;
import IsoView.RangeDigest;
import IsoView.RangeDigestSet;
import IsoView.SAMMateFinder;
import IsoView.Transcript;
import IsoView.TranscriptExon;
import IsoView.TranscriptIntron;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptBAMEvidence {
    private IsoViewConfig config;
    private BAMExcerpt be;
    private boolean contained_only;

    public TranscriptBAMEvidence(IsoViewConfig config) {
        this.config = config;
        this.setup();
    }

    private void setup() {
        this.contained_only = true;
        this.be = new BAMExcerpt();
    }

    public void set_contained_only(boolean contained_only) {
        this.contained_only = contained_only;
    }

    public void set_input_bam(String bam) {
        this.be.set_source_file(bam);
    }

    public void import_evidence(Transcript t) {
        if (t.is_translocation()) {
            System.err.println("FAIL: translocations unsupported!");
            return;
        }
        System.err.println("import_evidence: contained_only=" + this.contained_only);
        if (this.contained_only) {
            RangeDigestSet rds_all = this.get_transcript_rds(t);
            RangeDigestSet rds_first_last = this.get_first_last_rds(t);
            RangeDigestSet rds_introns = new RangeDigestSet();
            for (TranscriptIntron ti : t.introns) {
                rds_introns.add(new RangeDigest(ti.start, ti.end));
            }
            this.be.add_contained_records(t.exons.get((int)0).reference, rds_all, rds_all, this.config.EXON_INTRON_VIEW_CONTAINMENT_EDGE_FUZZY.booleanValue() ? rds_first_last : null, rds_introns, this.config.IGNORE_READS_WITH_UNKNOWN_JUNCTIONS.booleanValue());
        } else {
            for (TranscriptExon te : t.exons) {
                System.err.println("grabbing " + te.reference + " " + te.start + "-" + te.end);
                this.be.add_overlapping_records(te.reference, te.start, te.end, true);
            }
        }
    }

    public ArrayList<SAMRecord> get_matches() {
        ArrayList<SAMRecord> results = this.be.get_matches();
        if (this.config.REQUIRE_MATE_ALIGN.booleanValue()) {
            HashSet<SAMRecord> okey_dokey = new HashSet<SAMRecord>();
            for (SAMRecord sr : results) {
                okey_dokey.add(sr);
            }
            SAMMateFinder mf = new SAMMateFinder(results);
            SAMFileReader sfr = this.be.get_sfr();
            ArrayList<SAMRecord> filtered = new ArrayList<SAMRecord>();
            for (SAMRecord sr : results) {
                try {
                    SAMRecord sr_mate = mf.queryMate(sr);
                    if (sr_mate == null || !okey_dokey.contains(sr_mate)) continue;
                    filtered.add(sr);
                }
                catch (SAMFormatException e) {
                    System.err.println("queryMate() exception: " + (Object)((Object)e));
                }
            }
            System.err.println("before:" + results.size() + " filtered:" + filtered.size());
            results = filtered;
        }
        return results;
    }

    private void expand_check(Transcript t, TranscriptExon te, RangeDigest rd) {
        if (rd.get_size() < this.config.EXPAND_EXON_UTR_MINIMUM_SIZE) {
            if (te.equals(t.exons.get(0))) {
                System.err.println("hacktacular: expanding first exon upstream UTR");
                rd.add_start(rd.end - (this.config.EXPAND_EXON_UTR_MINIMUM_SIZE - 1));
                System.err.println("after: " + rd.get_size());
            } else if (te.equals(t.exons.get(t.exons.size() - 1))) {
                System.err.println("hacktacular: expanding last exon downstream UTR");
                rd.add_end(rd.start + (this.config.EXPAND_EXON_UTR_MINIMUM_SIZE - 1));
                System.err.println("after: " + rd.get_size());
            }
        }
    }

    public void import_evidence(Transcript t, TranscriptExon te) {
        if (t.is_translocation()) {
            System.err.println("FAIL: translocations unsupported!");
            return;
        }
        if (this.contained_only) {
            RangeDigestSet rds = new RangeDigestSet();
            RangeDigest rd = new RangeDigest(te.start, te.end);
            if (this.config.EXPAND_EXON_UTR) {
                this.expand_check(t, te, rd);
            }
            rds.add(rd);
            RangeDigestSet rds_introns = new RangeDigestSet();
            for (TranscriptIntron ti : t.introns) {
                rds_introns.add(new RangeDigest(ti.start, ti.end));
            }
            this.be.add_contained_records(te.reference, rds, this.get_transcript_rds(t), null, rds_introns, this.config.IGNORE_READS_WITH_UNKNOWN_JUNCTIONS.booleanValue());
        } else {
            System.err.println("grabbing " + te.reference + " " + te.start + "-" + te.end);
            this.be.add_overlapping_records(te.reference, te.start, te.end, true);
        }
    }

    public void import_evidence(Transcript t, TranscriptIntron ti) {
        if (t.is_translocation()) {
            System.err.println("FAIL: translocations unsupported!");
            return;
        }
        RangeDigestSet rds_introns = new RangeDigestSet();
        rds_introns.add(new RangeDigest(ti.start, ti.end));
        System.err.println("ref=" + ti.reference);
        this.be.add_intron_records(t.exons.get((int)0).reference, rds_introns);
    }

    private RangeDigestSet get_transcript_rds(Transcript t) {
        RangeDigestSet rds = new RangeDigestSet();
        for (TranscriptExon te : t.exons) {
            RangeDigest rd = new RangeDigest(te.start, te.end);
            if (this.config.EXPAND_EXON_UTR) {
                this.expand_check(t, te, rd);
            }
            rds.add(rd);
        }
        return rds;
    }

    private RangeDigestSet get_first_last_rds(Transcript t) {
        RangeDigestSet rds = new RangeDigestSet();
        rds.add(new RangeDigest(t.exons.get(0)));
        rds.add(new RangeDigest(t.exons.get(t.exons.size() - 1)));
        return rds;
    }

    public ArrayList<SAMRecord> postprocess_query_exon(ArrayList<SAMRecord> raw, TranscriptExon te, boolean include_mate_reads) {
        ArrayList<SAMRecord> results = new ArrayList<SAMRecord>();
        for (SAMRecord sr : raw) {
            boolean usable = false;
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                int block_start = ab.getReferenceStart();
                int block_end = block_start + ab.getLength() - 1;
                if (block_end < te.start || block_start > te.end) continue;
                usable = true;
                break;
            }
            if (!usable) continue;
            results.add(sr);
        }
        if (include_mate_reads) {
            results = this.postprocess_include_mates(raw, results);
        }
        return results;
    }

    public ArrayList<SAMRecord> postprocess_query_intron(ArrayList<SAMRecord> raw, TranscriptIntron ti, boolean include_mate_reads) {
        RangeDigestSet rds_introns = new RangeDigestSet();
        rds_introns.add(new RangeDigest(ti.start, ti.end));
        ExonSpliceFilter esf = new ExonSpliceFilter(rds_introns);
        ArrayList<SAMRecord> results = new ArrayList<SAMRecord>();
        for (SAMRecord sr : raw) {
            if (esf.check(sr, false)) {
                results.add(sr);
                continue;
            }
            System.err.println("tossing " + sr.getReadName());
        }
        if (include_mate_reads) {
            results = this.postprocess_include_mates(raw, results);
        }
        return results;
    }

    private ArrayList<SAMRecord> postprocess_include_mates(ArrayList<SAMRecord> raw, ArrayList<SAMRecord> wanted) {
        SAMMateFinder smf = new SAMMateFinder(raw);
        HashSet<SAMRecord> whitelist = new HashSet<SAMRecord>(wanted);
        for (SAMRecord sr : wanted) {
            SAMRecord mate;
            if (sr.getMateUnmappedFlag() || (mate = smf.queryMate(sr)) == null) continue;
            whitelist.add(mate);
        }
        ArrayList<SAMRecord> results = new ArrayList<SAMRecord>();
        for (SAMRecord sr : raw) {
            if (!whitelist.contains(sr)) continue;
            results.add(sr);
        }
        return results;
    }
}

