/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.ColorParser;
import Ace2.IntronCompressor;
import Ace2.TwoBitFile;
import Funk.LookAndFeeler;
import Funk.Str;
import IsoView.BAMExcerptRanges;
import IsoView.ButtonLabelCallback;
import IsoView.DatabaseAnnotationLoader;
import IsoView.DatabaseAnnotationLoaderDB;
import IsoView.DatabaseAnnotationLoaderFlatfile;
import IsoView.DatabaseAnnotationLoaderGTF;
import IsoView.DuplicateFeatureFilter;
import IsoView.FlatfileJunctionTranscriptLoader;
import IsoView.GTFReader;
import IsoView.GTFTranscriptLoader;
import IsoView.IsoCanvas;
import IsoView.IsoViewConfig;
import IsoView.JMenuHelper;
import IsoView.ManualJunctionTranscriptLoader;
import IsoView.RangeDigest;
import IsoView.Transcript;
import IsoView.TranscriptComparatorByFirstExon;
import IsoView.TranscriptComparatorByIntronSizes;
import IsoView.TranscriptComparatorByProductSize;
import IsoView.TranscriptComparatorBySample;
import IsoView.TranscriptComparatorBySimilarity;
import IsoView.TranscriptComparatorBySpanSize;
import IsoView.TranscriptCoordinateDigest;
import IsoView.TranscriptCoordinateDigestOptimizedScale;
import IsoView.TranscriptCoordinateDigestToScale;
import IsoView.TranscriptExon;
import IsoView.TranscriptIntron;
import IsoView.UCSCRefGene;
import TCGA.BooleanOption;
import TCGA.MouseDragScroller;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import net.sf.samtools.SAMFileReader;

public class IsoView
extends JFrame
implements Observer {
    private IsoViewConfig config;
    private IsoCanvas ic;
    private DatabaseAnnotationLoader dul;
    public static final String MATE_MAPPING_FILTER_LABEL = "Require read mates to also be mapped within transcript";
    public static final String LABEL_BAM_EXTRACT = "Prompt to extract viewed reads into excerpt BAM file";
    private static final String LABEL_GENE_SELECTION = "Gene...";
    private static final String LABEL_SAMPLE_SELECTION = "Sample...";
    private static final String LABEL_TRANSCRIPT_SELECTION = "Transcript...";
    private static final String LABEL_RENDER_TO_SCALE = "View to scale";
    private static final String LABEL_BAMVIEW_COMPRESS_INTRONS = "Compress introns";
    private static final String LABEL_SORT_RAW = "Sort by default ordering";
    private static final String LABEL_SORT_PRODUCT_SIZE = "Sort by product size";
    private static final String LABEL_MIN_JUNCTION_COVERAGE = "Set minimum exon junction read coverage for intron display...";

    public IsoView(IsoViewConfig config) throws FileNotFoundException, IOException {
        this.config = config;
        this.setup();
    }

    public void setup() throws FileNotFoundException, IOException {
        this.dul = this.config.refgene_flatfile != null ? new DatabaseAnnotationLoaderFlatfile(this.config, this) : (this.config.refgene_gtf != null ? new DatabaseAnnotationLoaderGTF(this.config, this) : new DatabaseAnnotationLoaderDB(this.config, this));
        System.err.println("reference sequence file=" + this.config.two_bit_file);
        File f = new File(this.config.two_bit_file);
        if (!f.exists()) {
            System.err.println("ERROR: invalid .2bit file " + this.config.two_bit_file + " (doesn't exist)");
            System.exit(1);
        }
        this.config.two_bit = new TwoBitFile(this.config.two_bit_file);
        this.init_working_transcripts();
        this.init_digest();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension pref = new Dimension((int)((double)screen.width * 0.95), (int)((double)screen.height * 0.9));
        this.menu_setup();
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BorderLayout());
        JScrollBar jsb_y = new JScrollBar(1, 0, 0, 0, screen.height);
        JScrollBar jsb_x = new JScrollBar(0, 0, 0, 0, screen.width);
        this.ic = new IsoCanvas(this.config, jsb_x, jsb_y);
        MouseDragScroller mds = new MouseDragScroller(this.ic, jsb_x, jsb_y);
        mds.set_drag_button_mask(16);
        this.ic.setPreferredSize(pref);
        jp_main.add("Center", this.ic);
        jp_main.add("East", jsb_y);
        Container c_main = this.getContentPane();
        c_main.setLayout(new BoxLayout(c_main, 3));
        c_main.add(jp_main);
        c_main.add(jsb_x);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] argv) {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        try {
            IsoViewConfig config = new IsoViewConfig();
            boolean build_excerpts = false;
            for (int i = 0; i < argv.length; ++i) {
                ColorParser cp;
                Color c;
                if (argv[i].equals("-scale")) {
                    config.RENDER_TO_SCALE.setValue(true);
                    continue;
                }
                if (argv[i].equals("-scale-fit")) {
                    config.RENDER_TO_SCALE.setValue(false);
                    continue;
                }
                if (argv[i].equals("-track")) {
                    config.track_files.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-junction-file")) {
                    config.FLATFILE_JUNCTION_MODE = true;
                    IsoView.bamview_map_profile_relaxed(config);
                    config.track_files.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-bamview-map-relaxed")) {
                    IsoView.bamview_map_profile_relaxed(config);
                    continue;
                }
                if (argv[i].equals("-bamview-map-strict")) {
                    IsoView.bamview_map_profile_strict(config);
                    continue;
                }
                if (argv[i].equals("-show-junction-counts")) {
                    config.SHOW_JUNCTION_COUNTS = true;
                    continue;
                }
                if (argv[i].equals("-jc-font-size")) {
                    config.JUNCTION_COUNT_FONT_SIZE = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-span-size")) {
                    IntronCompressor.KEEP_NT = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-jc-font-name")) {
                    config.JUNCTION_COUNT_FONT_NAME = argv[++i];
                    continue;
                }
                if (argv[i].equals("-jc-font-color")) {
                    if ((c = (cp = new ColorParser(argv[++i])).get_color()) == null) {
                        System.err.println("color parse error!");
                        System.exit(1);
                        continue;
                    }
                    config.JUNCTION_COUNT_COLOR = c;
                    continue;
                }
                if (argv[i].equals("-jc-font-color-known")) {
                    if ((c = (cp = new ColorParser(argv[++i])).get_color()) == null) {
                        System.err.println("color parse error!");
                        System.exit(1);
                        continue;
                    }
                    config.JUNCTION_COUNT_COLOR_KNOWN = c;
                    continue;
                }
                if (argv[i].equals("-jc-font-color-novel")) {
                    if ((c = (cp = new ColorParser(argv[++i])).get_color()) == null) {
                        System.err.println("color parse error!");
                        System.exit(1);
                        continue;
                    }
                    config.JUNCTION_COUNT_COLOR_NOVEL = c;
                    continue;
                }
                if (argv[i].equals("-junction-counts")) {
                    config.junction_count_files.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-min-junction-reads")) {
                    config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-min-novel-junction-reads")) {
                    config.MIN_NOVEL_JUNCTION_COVERAGE_FOR_DISPLAY = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-f-junction")) {
                    config.F_JUNCTION = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-f-gene")) {
                    config.F_GENE = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-f-count")) {
                    config.F_COUNT = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-f-transcript")) {
                    config.F_TRANSCRIPT = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-refgene-only")) {
                    config.LOAD_KNOWN_REFGENE_ONLY = true;
                    continue;
                }
                if (argv[i].equals("-f-type")) {
                    config.F_TYPE = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-novel-only")) {
                    config.LOAD_NOVEL_JUNCTIONS_ONLY = true;
                    continue;
                }
                if (argv[i].equals("-junction")) {
                    config.MANUAL_JUNCTION_MODE = true;
                    IsoView.bamview_map_profile_relaxed(config);
                    config.track_files.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-junction-gene")) {
                    config.MANUAL_JUNCTION_GENE = argv[++i];
                    continue;
                }
                if (argv[i].equals("-bam")) {
                    if (config.track_files.size() == 0) {
                        System.err.println("ERROR: -bam must be specifed AFTER -track or -junction");
                        System.exit(1);
                        continue;
                    }
                    config.add_bam(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-2bit")) {
                    config.two_bit_file = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-gene")) {
                    config.genes_to_view.add(new String(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-sample")) {
                    config.sample_to_view = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-transcript")) {
                    config.transcript_to_view = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-ref-transcript")) {
                    config.reference_transcript_to_view = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-zoom-y")) {
                    config.ENABLE_VERTICAL_ZOOM = true;
                    continue;
                }
                if (argv[i].equals("-no-zoom-y")) {
                    config.ENABLE_VERTICAL_ZOOM = false;
                    continue;
                }
                if (argv[i].equals("-build-excerpt-bams")) {
                    build_excerpts = true;
                    continue;
                }
                if (argv[i].equals("-color-background")) {
                    IsoView.color_setup(config, argv[i], argv[++i]);
                    continue;
                }
                if (argv[i].equals("-refgene-flatfile")) {
                    config.refgene_flatfile = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-refgene-gtf")) {
                    config.refgene_gtf = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-hide-duplicates")) {
                    config.HIDE_DUPLICATE_TRANSCRIPTS.setValue(true);
                    continue;
                }
                if (argv[i].equals("-refseq-event-group")) {
                    config.TOOLTIP_GROUP_REFSEQ_EVENTS_BY_EVENT.setValue(true);
                    continue;
                }
                if (argv[i].equals("-standardize-genes")) {
                    config.STANDARDIZE_GENE_SYMBOLS = true;
                    config.standardize_flatfile = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-t2g")) {
                    config.USE_TRANSCRIPT2GENE = true;
                    config.transcript2gene_file = new String(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-no-prune")) {
                    config.PRUNE_NULL_COUNT_JUNCTIONS = false;
                    continue;
                }
                if (argv[i].equals("-null-gene")) {
                    config.NULL_GENE_SYMBOL_OVERRIDE = new String(argv[++i]);
                    continue;
                }
                System.err.println("unknown param " + argv[i]);
                System.exit(1);
            }
            config.all_transcripts = new ArrayList();
            if (config.MANUAL_JUNCTION_MODE) {
                ManualJunctionTranscriptLoader mjtl = new ManualJunctionTranscriptLoader(config);
                for (String junction : config.track_files) {
                    mjtl.add_junction(junction);
                }
                config.all_transcripts.addAll(mjtl.get_transcripts());
            } else if (config.FLATFILE_JUNCTION_MODE) {
                FlatfileJunctionTranscriptLoader fjtl = new FlatfileJunctionTranscriptLoader(config);
                for (String fn : config.track_files) {
                    fjtl.parse(fn);
                }
                config.all_transcripts.addAll(fjtl.get_transcripts());
            } else {
                for (String fn : config.track_files) {
                    System.err.println("loading " + fn);
                    GTFReader gtf = new GTFReader(fn);
                    GTFTranscriptLoader tl = new GTFTranscriptLoader(gtf);
                    config.all_transcripts.addAll(tl.get_transcripts());
                }
            }
            HashSet<String> all_genes_set = new HashSet<String>();
            HashSet<String> all_transcripts_set = new HashSet<String>();
            for (Transcript t : config.all_transcripts) {
                all_transcripts_set.add(t.transcript_id);
                for (String gene : t.get_genes()) {
                    if (config.genes_to_view.size() == 0) {
                        config.genes_to_view.add(gene);
                    }
                    all_genes_set.add(gene);
                }
            }
            config.all_genes = new ArrayList(all_genes_set);
            config.all_transcript_ids = new ArrayList(all_transcripts_set);
            Collections.sort(config.all_genes);
            Collections.sort(config.all_transcript_ids);
            System.err.println("transcripts: " + config.all_transcripts.size());
            if (build_excerpts) {
                IsoView.build_excerpts(config);
            } else {
                LookAndFeeler.set_native_lookandfeel();
                IsoView iv = new IsoView(config);
                iv.setDefaultCloseOperation(3);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private void menu_setup() {
        JMenuHelper jmh = new JMenuHelper(this);
        JMenu jm = jmh.add_jmenu("File", true);
        jmh.add(this.generate_checkbox(LABEL_BAM_EXTRACT, this.config.EXTRACT_EXCERPT_BAM_MODE));
        jm = jmh.add_jmenu("View", true);
        ButtonLabelCallback blc = new ButtonLabelCallback(this);
        jmh.set_blc(blc);
        jmh.add_jmenuitem(LABEL_GENE_SELECTION, true);
        jmh.add_jmenuitem(LABEL_SAMPLE_SELECTION, true);
        jmh.add_jmenuitem(LABEL_TRANSCRIPT_SELECTION, true);
        jmh.enter_submenu("Sort...");
        ButtonGroup bg = new ButtonGroup();
        jmh.add_jradiobutton(this.config.SORT_UNSORTED, bg, this);
        jmh.add_jradiobutton(this.config.SORT_SAMPLE, bg, this);
        jmh.add_jradiobutton(this.config.SORT_INTRON_SIZES, bg, this);
        jmh.add_jradiobutton(this.config.SORT_SPAN_SIZE, bg, this);
        jmh.add_jradiobutton(this.config.SORT_FIRST_EXON, bg, this);
        jmh.add_jradiobutton(this.config.SORT_PRODUCT_SIZE, bg, this);
        jmh.pop_submenu();
        jmh.enter_submenu("BAM viewer...");
        jmh.add(this.generate_checkbox(this.config.EXON_INTRON_VIEW_REQUIRE_READ_CONTAINMENT));
        jmh.add(this.generate_checkbox(this.config.EXON_INTRON_VIEW_CONTAINMENT_EDGE_FUZZY));
        jmh.add(this.generate_checkbox(this.config.IGNORE_READS_WITH_UNKNOWN_JUNCTIONS));
        jmh.add(this.generate_checkbox(MATE_MAPPING_FILTER_LABEL, this.config.REQUIRE_MATE_ALIGN));
        jmh.add_separator();
        jmh.add(this.generate_checkbox(LABEL_BAMVIEW_COMPRESS_INTRONS, this.config.BAMVIEW_COMPRESS_INTRONS));
        jmh.pop_submenu();
        JCheckBoxMenuItem jcmi = new JCheckBoxMenuItem(LABEL_RENDER_TO_SCALE, this.config.RENDER_TO_SCALE.booleanValue());
        jcmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getItem();
                ((IsoView)IsoView.this).config.RENDER_TO_SCALE.setValue(i.isSelected());
                IsoView.this.screen_reset();
            }
        });
        jmh.add(jcmi);
        jmh.add_jcheckbox(this.config.HIDE_REFERENCE_ONLY_TRANSCRIPTS, this);
        jmh.add_jcheckbox(this.config.HIDE_REFERENCE_MATCH_FEATURES, this);
        jmh.add_jcheckbox(this.config.HIDE_EXON_SPANS, this);
        jmh.add_jcheckbox(this.config.DRAW_FEATURES_UNIQUELY_PER_SAMPLE, this);
        jmh.add_jcheckbox(this.config.ADJUST_TRANSCRIPT_ENDS_TO_REFERENCE, this);
        jmh.add_jcheckbox(this.config.TOOLTIP_GROUP_REFSEQ_EVENTS_BY_EVENT, this);
        jmh.add_jcheckbox(this.config.HIDE_DUPLICATE_TRANSCRIPTS, this);
        jmh.add_jmenuitem(LABEL_MIN_JUNCTION_COVERAGE, true);
    }

    private void screen_reset() {
        this.init_digest();
        if (this.ic != null) {
            this.ic.set_raw_size(this.config.get_raw_canvas_size());
            this.ic.reset_zoom();
        }
    }

    private void init_digest() {
        TranscriptCoordinateDigestToScale d = this.config.RENDER_TO_SCALE.booleanValue() ? new TranscriptCoordinateDigestToScale(this.config.working_transcripts) : new TranscriptCoordinateDigestOptimizedScale(this.config.working_transcripts);
        ((TranscriptCoordinateDigest)d).digest();
        this.config.scale_digest = d;
        String title = "IsoBar: " + Str.join(",", this.config.genes_to_view) + " " + (this.config.RENDER_TO_SCALE.booleanValue() ? "(to scale)" : "(compressed introns)");
        this.setTitle(title);
    }

    private void init_working_transcripts() {
        this.config.reference_transcripts = new ArrayList();
        this.config.all_reference_introns = null;
        String reference_filter = null;
        if (this.config.all_transcripts.size() == 1) {
            reference_filter = this.config.all_transcripts.get((int)0).exons.get((int)0).reference;
        }
        ArrayList<UCSCRefGene> refs = new ArrayList<UCSCRefGene>();
        for (String gene : this.config.genes_to_view) {
            ArrayList<UCSCRefGene> r = this.dul.get_refgenes_for_gene(gene);
            if (r == null || r.size() <= 0) continue;
            if (this.config.reference_transcript_to_view != null) {
                for (UCSCRefGene rg : r) {
                    if (!rg.name.equals(this.config.reference_transcript_to_view)) continue;
                    refs.add(rg);
                }
                continue;
            }
            refs.addAll(r);
        }
        if (refs.size() > 0) {
            for (UCSCRefGene rg : refs) {
                if (reference_filter != null && !rg.chrom.equals(reference_filter)) continue;
                Transcript t = new Transcript(rg, true);
                t.is_reference = true;
                this.config.reference_transcripts.add(t);
            }
            this.config.all_reference_introns = new HashSet();
            for (Transcript t : this.config.reference_transcripts) {
                for (TranscriptIntron ti : t.introns) {
                    this.config.all_reference_introns.add(ti.get_range_digest().toString());
                }
            }
        }
        ArrayList<Transcript> working = new ArrayList<Transcript>();
        for (Transcript t : this.config.all_transcripts) {
            boolean has_gene = false;
            for (String gene : this.config.genes_to_view) {
                if (!t.contains_gene(gene)) continue;
                has_gene = true;
            }
            if (!has_gene || this.config.sample_to_view != null && !this.config.sample_to_view.equals(t.sample_name) || this.config.transcript_to_view != null && !this.config.transcript_to_view.equals(t.transcript_id) || this.config.HIDE_DUPLICATE_TRANSCRIPTS.booleanValue() && t.duplicate != null) continue;
            if (this.config.reference_transcripts != null) {
                t.reset_exon_positions();
                if (this.config.ADJUST_TRANSCRIPT_ENDS_TO_REFERENCE.booleanValue()) {
                    t.remap_ends_to_reference(this.config.reference_transcripts);
                }
                if (this.config.HIDE_REFERENCE_ONLY_TRANSCRIPTS.booleanValue()) {
                    boolean all_ref = true;
                    for (TranscriptIntron ti : t.introns) {
                        if (this.config.all_reference_introns.contains(ti.get_range_digest().toString())) continue;
                        all_ref = false;
                        break;
                    }
                    if (all_ref) continue;
                }
                t.compare_with(this.config.reference_transcripts, this.config.all_reference_introns);
            }
            working.add(t);
        }
        if (this.config.SORT_PRODUCT_SIZE.booleanValue()) {
            Collections.sort(working, new TranscriptComparatorByProductSize());
            Collections.reverse(working);
        } else if (this.config.SORT_INTRON_SIZES.booleanValue()) {
            Collections.sort(working, new TranscriptComparatorByIntronSizes());
            Collections.reverse(working);
        } else if (this.config.SORT_SAMPLE.booleanValue()) {
            System.err.println("by sample!");
            Collections.sort(working, new TranscriptComparatorBySample());
        } else if (this.config.SORT_SPAN_SIZE.booleanValue()) {
            Collections.sort(working, new TranscriptComparatorBySpanSize());
            Collections.reverse(working);
        } else if (this.config.SORT_FIRST_EXON.booleanValue()) {
            Collections.sort(working, new TranscriptComparatorByFirstExon());
        } else if (this.config.SORT_SIMILARITY.booleanValue()) {
            Collections.sort(working, new TranscriptComparatorBySimilarity());
        }
        if (this.config.DRAW_FEATURES_UNIQUELY_PER_SAMPLE.booleanValue()) {
            ArrayList<Transcript> filtered = new ArrayList<Transcript>();
            DuplicateFeatureFilter dff = new DuplicateFeatureFilter();
            for (Transcript t : working) {
                if (dff.are_any_usable(t)) {
                    filtered.add(t);
                    continue;
                }
                System.err.println("filter flunk!!");
            }
            System.err.println("raw=" + working.size() + " filtered=" + filtered.size());
            working = filtered;
        }
        this.config.working_transcripts = new ArrayList();
        this.config.working_transcripts.addAll(this.config.reference_transcripts);
        this.config.working_transcripts.addAll(working);
        System.err.println("transcripts for " + Str.join(",", this.config.genes_to_view) + ": " + this.config.working_transcripts.size());
        if (this.config.working_transcripts.size() == 0) {
            System.err.println("ERROR: no transcript data found!");
            System.exit(1);
        }
        RangeDigest rd = new RangeDigest();
        for (Transcript t : this.config.working_transcripts) {
            rd.add(t.get_range_digest());
        }
        System.err.println("range=" + rd);
    }

    private static void build_excerpts(IsoViewConfig config) {
        HashMap<String, ArrayList<Transcript>> sample2transcript = new HashMap<String, ArrayList<Transcript>>();
        for (Transcript t : config.all_transcripts) {
            ArrayList<Transcript> set = (ArrayList<Transcript>)sample2transcript.get(t.sample_name);
            if (set == null) {
                set = new ArrayList<Transcript>();
                sample2transcript.put(t.sample_name, set);
            }
            set.add(t);
        }
        for (String sample_name : sample2transcript.keySet()) {
            File f = new File(sample_name);
            String basename = f.getName();
            System.err.println(basename);
            String outfile = basename + "_excerpt.bam";
            System.err.println("outfile=" + outfile);
            File outf = new File(outfile);
            if (outf.exists() && outf.length() > 0L) {
                System.err.println(outfile + " exists, skipping");
                continue;
            }
            BAMExcerptRanges ber = new BAMExcerptRanges();
            String bam = config.get_bam_filename(sample_name);
            if (bam == null) {
                System.err.println("ack: no bam for " + sample_name);
                continue;
            }
            File bamfile = new File(bam);
            if (!bamfile.exists()) {
                System.err.println("ERROR: " + bam + " doesn't exist");
                continue;
            }
            ber.set_source_file(bam);
            ArrayList set = (ArrayList)sample2transcript.get(sample_name);
            for (Transcript t : set) {
                for (TranscriptExon te : t.exons) {
                    System.err.println("adding: ref=" + te.reference + " " + te.start + "-" + te.end);
                    ber.add_range(te.reference, te.start, te.end);
                }
            }
            ber.extract_to(outf, false);
        }
    }

    public void update(Observable o, Object arg) {
        if (o instanceof DatabaseAnnotationLoader) {
            this.gene_patch_hack();
            this.init_working_transcripts();
            this.init_digest();
            this.screen_reset();
        } else if (o instanceof BooleanOption) {
            this.init_working_transcripts();
            this.screen_reset();
        } else if (o instanceof ButtonLabelCallback) {
            String label = (String)arg;
            if (label.equals(LABEL_GENE_SELECTION)) {
                this.select_gene();
            } else if (label.equals(LABEL_SAMPLE_SELECTION)) {
                this.select_sample();
            } else if (label.equals(LABEL_TRANSCRIPT_SELECTION)) {
                this.select_transcript();
            } else if (label.equals(LABEL_MIN_JUNCTION_COVERAGE)) {
                this.set_min_junction_coverage();
            }
        } else {
            System.err.println("ERROR: unhandled update() for " + o);
        }
    }

    private JCheckBoxMenuItem generate_checkbox(String label, BooleanOption state) {
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(label, state.booleanValue());
        state.set_button(cb);
        return cb;
    }

    private JCheckBoxMenuItem generate_checkbox(BooleanOption state) {
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(state.get_label(), state.booleanValue());
        state.set_button(cb);
        return cb;
    }

    private void select_gene() {
        String response;
        Object[] genes = new String[this.config.all_genes.size()];
        int i = 0;
        for (String gene : this.config.all_genes) {
            genes[i++] = gene;
        }
        String selected = null;
        if (this.config.genes_to_view.size() > 0) {
            Iterator<String> i$ = this.config.genes_to_view.iterator();
            while (i$.hasNext()) {
                String gene;
                selected = gene = i$.next();
            }
        }
        if ((response = (String)JOptionPane.showInputDialog(this, "Select gene to view transcripts for:", "Select gene", 3, null, genes, selected)) != null && !response.equals(selected)) {
            this.config.genes_to_view.clear();
            this.config.genes_to_view.add(response);
            this.init_working_transcripts();
            this.screen_reset();
        }
    }

    private void select_transcript() {
        String ALL_VALUE = "(all transcripts)";
        Object[] transcripts = new String[this.config.all_transcript_ids.size() + 1];
        transcripts[0] = ALL_VALUE;
        int i = 1;
        for (String id : this.config.all_transcript_ids) {
            transcripts[i++] = id;
        }
        String current = this.config.transcript_to_view == null ? ALL_VALUE : this.config.transcript_to_view;
        String response = (String)JOptionPane.showInputDialog(this, "Select transcript to view:", "Select transcript", 3, null, transcripts, current);
        if (response != null && !response.equals(this.config.transcript_to_view)) {
            this.config.transcript_to_view = response.equals(ALL_VALUE) ? null : response;
            this.init_working_transcripts();
            this.screen_reset();
        }
    }

    private void select_sample() {
        HashSet<String> all_samples_set = new HashSet<String>();
        for (Transcript t : this.config.all_transcripts) {
            all_samples_set.add(t.sample_name);
        }
        ArrayList all_sorted = new ArrayList(all_samples_set);
        Collections.sort(all_sorted);
        String ALL_VALUE = "(all samples)";
        Object[] samples = new String[all_sorted.size() + 1];
        int i = 1;
        samples[0] = ALL_VALUE;
        for (String sample : all_sorted) {
            samples[i++] = sample;
        }
        String current = this.config.sample_to_view == null ? ALL_VALUE : this.config.sample_to_view;
        String response = (String)JOptionPane.showInputDialog(this, "Select sample to view transcripts for:", "Select sample", 3, null, samples, current);
        if (response != null) {
            System.err.println("chose " + response);
            if (response.equals(ALL_VALUE)) {
                response = null;
            }
            this.config.sample_to_view = response;
            this.init_working_transcripts();
            this.screen_reset();
        }
    }

    private static void color_setup(IsoViewConfig config, String arg, String cspec) {
        ColorParser cp = new ColorParser(cspec);
        Color c = cp.get_color();
        if (c == null) {
            System.err.println("ERROR: unknown color " + cspec);
            System.exit(1);
        }
        if (c != null) {
            if (arg.equals("-color-background")) {
                config.BACKGROUND_COLOR = c;
            } else {
                System.err.println("ERROR: unhandled color type " + cspec);
            }
        }
    }

    private void set_min_junction_coverage() {
        String response = JOptionPane.showInputDialog(this, "Specify minimum exon junction read coverage to display introns:", this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY);
        if (response != null) {
            try {
                int jcov = Integer.parseInt(response);
                if (jcov > 0) {
                    boolean have_junction_coverage = false;
                    block2: for (Transcript t : this.config.all_transcripts) {
                        for (TranscriptIntron ti : t.introns) {
                            if (ti.junction_coverage <= 0) continue;
                            have_junction_coverage = true;
                            continue block2;
                        }
                    }
                    if (have_junction_coverage) {
                        this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY = jcov;
                        this.ic.repaint();
                    } else {
                        JOptionPane.showMessageDialog(this, "Sorry, this dataset does not appear to contain exon junction coverage information.", "Error", 0);
                    }
                } else {
                    this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY = 0;
                    this.ic.repaint();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Please enter an integer value.", "Error", 0);
            }
        }
    }

    private static void bamview_map_profile_relaxed(IsoViewConfig config) {
        config.REQUIRE_MATE_ALIGN.setValue(false);
        config.EXON_INTRON_VIEW_REQUIRE_READ_CONTAINMENT.setValue(false);
        config.IGNORE_READS_WITH_UNKNOWN_JUNCTIONS.setValue(false);
    }

    private static void bamview_map_profile_strict(IsoViewConfig config) {
        config.REQUIRE_MATE_ALIGN.setValue(false);
        config.EXON_INTRON_VIEW_REQUIRE_READ_CONTAINMENT.setValue(true);
        config.IGNORE_READS_WITH_UNKNOWN_JUNCTIONS.setValue(true);
    }

    private void gene_patch_hack() {
        for (Transcript t : this.config.all_transcripts) {
            if (!t.has_null_genes() && this.config.MANUAL_JUNCTION_GENE == null) continue;
            String reference = t.exons.get((int)0).reference;
            RangeDigest rd = t.get_range_digest();
            System.err.println("gene needed!");
            String best_gene = null;
            int best_overlap = 0;
            HashSet<String> all_genes = new HashSet<String>();
            System.err.println("mjg=" + this.config.MANUAL_JUNCTION_GENE);
            if (this.config.MANUAL_JUNCTION_GENE != null) {
                t.set_gene(this.config.MANUAL_JUNCTION_GENE);
                this.config.genes_to_view.clear();
                this.config.genes_to_view.add(this.config.MANUAL_JUNCTION_GENE);
                continue;
            }
            for (String gene : this.dul.get_genes()) {
                for (UCSCRefGene rg : this.dul.get_refgenes_for_gene(gene)) {
                    Transcript t_ref;
                    RangeDigest rd_ref;
                    if (!rg.chrom.equals(reference) || !rd.intersects(rd_ref = (t_ref = new Transcript(rg, true)).get_range_digest())) continue;
                    all_genes.add(gene);
                    int overlap = rd.get_overlap(rd_ref);
                    if (overlap <= best_overlap) continue;
                    best_overlap = overlap;
                    best_gene = gene;
                }
            }
            if (best_overlap <= 0) continue;
            ArrayList sorted = new ArrayList(all_genes);
            Collections.sort(sorted);
            System.err.println("assigning gene " + best_gene + " based on region overlap of " + best_overlap + "; all possibilities=" + Str.join(",", sorted));
            t.set_gene(best_gene);
            this.config.genes_to_view.clear();
            this.config.genes_to_view.add(best_gene);
        }
    }
}

