/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.RangeDigest;
import IsoView.RangeDigestSet;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;

public class ExonSpliceFilter {
    private RangeDigestSet intron_spans;
    private static final String CIGAR_SKIP = CigarOperator.SKIPPED_REGION.toString();
    private static boolean VERBOSE = true;

    public ExonSpliceFilter(RangeDigestSet rds) {
        this.intron_spans = rds;
    }

    public boolean check(SAMRecord sr, boolean default_value) {
        boolean result = default_value;
        Cigar cigar = sr.getCigar();
        if (cigar.toString().indexOf(CIGAR_SKIP) > -1) {
            int pos = sr.getUnclippedStart();
            for (CigarElement ce : cigar.getCigarElements()) {
                CigarOperator co = ce.getOperator();
                int len = ce.getLength();
                if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.HARD_CLIP)) {
                    pos += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.PADDING) || co.equals((Object)CigarOperator.INSERTION)) continue;
                if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                    int start = pos;
                    int end = start + len - 1;
                    pos += len;
                    if (VERBOSE) {
                        System.err.println("skip " + sr.getReadName() + " from " + start + "-" + end);
                    }
                    boolean known = false;
                    for (RangeDigest rd : this.intron_spans.get_ranges()) {
                        if (!rd.equals(start, end)) continue;
                        known = true;
                        break;
                    }
                    if (!known) {
                        if (VERBOSE) {
                            System.err.println("unknown splice for " + sr.getReadName());
                        }
                        if (!default_value) continue;
                        result = false;
                        break;
                    }
                    if (VERBOSE) {
                        System.err.println("splice OK for " + sr.getReadName());
                    }
                    if (default_value) continue;
                    result = true;
                    break;
                }
                System.err.println("ERROR: unhandled CIGAR operator in internal splice filter");
            }
        }
        return result;
    }
}

