/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.DatabaseAnnotationLoader;
import IsoView.GTFReader;
import IsoView.GTFTranscriptLoader;
import IsoView.IsoViewConfig;
import IsoView.Transcript;
import java.util.ArrayList;
import java.util.Observer;

public class DatabaseAnnotationLoaderGTF
extends DatabaseAnnotationLoader
implements Runnable {
    public DatabaseAnnotationLoaderGTF(IsoViewConfig config, Observer o) {
        super(config, o);
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            GTFTranscriptLoader gtl = new GTFTranscriptLoader(new GTFReader(this.config.refgene_gtf));
            ArrayList<Transcript> all_transcripts = gtl.get_transcripts();
            System.err.println("tcount=" + all_transcripts.size());
            System.err.println("GTF db load: " + (System.currentTimeMillis() - start) + " ms");
            this.setChanged();
            this.notifyObservers();
        }
        catch (Exception e) {
            System.err.println("parse error: " + e);
        }
    }

    public static void main(String[] argv) {
        IsoViewConfig config = new IsoViewConfig();
        config.refgene_gtf = "ref_myb.gtf";
        DatabaseAnnotationLoaderGTF dal = new DatabaseAnnotationLoaderGTF(config, null);
    }
}

