/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.ChromosomeDisambiguator;
import Ace2.SAMRegion;
import Ace2.SAMUtils;
import IsoView.BAMExcerpt;
import IsoView.BAMFixConsecutiveDuplicates;
import IsoView.RangeDigest;
import IsoView.RangeDigestSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMExcerptRanges {
    private File bam_source_file;
    private HashMap<String, RangeDigestSet> ref2ranges = new HashMap();
    private SAMFileReader sfr_src = null;
    private ChromosomeDisambiguator cd = null;

    public void set_source_file(String f) {
        this.bam_source_file = new File(f);
        this.sfr_src = new SAMFileReader(this.bam_source_file);
        this.cd = new ChromosomeDisambiguator(this.sfr_src);
    }

    public void add_range(String ref_name, int start, int end) {
        String ref_cooked = this.cd.find(ref_name);
        RangeDigestSet bucket = this.ref2ranges.get(ref_cooked);
        if (bucket == null) {
            bucket = new RangeDigestSet();
            this.ref2ranges.put(ref_cooked, bucket);
        }
        bucket.add(new RangeDigest(start, end));
    }

    public ArrayList<SAMRegion> get_sorted_ranges() {
        SAMFileHeader sfh = this.sfr_src.getFileHeader();
        SAMSequenceDictionary dict = sfh.getSequenceDictionary();
        ArrayList<SAMRegion> results = new ArrayList<SAMRegion>();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            String ref_name = ssr.getSequenceName();
            RangeDigestSet bucket = this.ref2ranges.get(ref_name);
            if (bucket == null) continue;
            ArrayList<RangeDigest> ranges = bucket.get_ranges();
            Collections.sort(ranges);
            for (RangeDigest rd : ranges) {
                results.add(new SAMRegion(ref_name, rd.start, rd.end));
            }
        }
        return results;
    }

    public void extract_to(File outfile, boolean presorted) {
        try {
            File outfile_tmp = new File(outfile.getCanonicalPath() + "_needs_dupfix.bam");
            BAMExcerpt be = new BAMExcerpt(outfile_tmp, presorted);
            be.set_source_file(this.bam_source_file);
            for (SAMRegion sr : this.get_sorted_ranges()) {
                System.err.println("extracting range=" + sr);
                be.add_overlapping_records(sr.tname, sr.range.start, sr.range.end, true);
            }
            be.close();
            int filtered = BAMFixConsecutiveDuplicates.fix_consecutive_duplicates(outfile_tmp, outfile);
            System.err.println("duplicates removed: " + filtered);
            SAMUtils.bam_index(outfile);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    public static void main(String[] argv) {
        BAMExcerptRanges ber = new BAMExcerptRanges();
        ber.set_source_file("excerpt_SJSUDEM001_G-FAN101.bam");
        ber.add_range("chr2", 3, 4);
        ber.add_range("chr2", 200, 300);
        ber.add_range("chr2", 10, 20);
        ber.add_range("1", 100, 1000);
        ber.add_range("chr1", 11000, 15000);
        ber.add_range("chr1", 3000, 8000);
    }
}

