/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.NIOUtils;
import Funk.Sys;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class WorkingDirectory {
    private File working_dir;
    private File final_dir;
    boolean created_working_dir;
    boolean use_mv;
    private static final long MAX_NIO_COPY_LENGTH = 2000000000L;

    public WorkingDirectory(File working_dir) throws IOException {
        this.working_dir = working_dir;
        this.setup(new File("."));
    }

    public WorkingDirectory(File working_dir, File final_dir) throws IOException {
        this.working_dir = working_dir;
        this.setup(final_dir);
    }

    private void setup(File final_dir) throws IOException {
        this.use_mv = false;
        this.final_dir = final_dir;
        if (this.working_dir.equals(final_dir)) {
            throw new IOException("working directory must be different from current directory");
        }
        this.dir_setup(final_dir);
        this.created_working_dir = this.dir_setup(this.working_dir);
    }

    private boolean dir_setup(File dir) throws IOException {
        boolean created_dir = false;
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException(dir + " exists but is not a directory!");
            }
        } else if (dir.mkdir()) {
            created_dir = true;
        } else {
            throw new IOException("directory " + dir + " doesn't exist and can't create");
        }
        return created_dir;
    }

    public void finish() throws IOException {
        File[] files = this.working_dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    throw new IOException("WorkingDirectory ERROR: subdirectories not supported: " + files[i]);
                }
                File f_final = new File(this.final_dir, files[i].getName());
                boolean used_mv = false;
                if (this.use_mv || files[i].length() > 2000000000L) {
                    String[] cmd = new String[]{"env", "mv", files[i].getCanonicalPath(), f_final.getCanonicalPath()};
                    int exit = Sys.exec_command(cmd, true);
                    used_mv = true;
                } else {
                    NIOUtils.copyFile(files[i], f_final);
                }
                if (!f_final.exists()) {
                    throw new IOException(f_final + " doesn't exist!");
                }
                if (used_mv) continue;
                if (f_final.length() != files[i].length()) {
                    throw new IOException("ERROR: output file size mismatch!!");
                }
                files[i].delete();
            }
        }
        if (this.created_working_dir) {
            this.working_dir.delete();
        }
    }

    public void set_use_mv(boolean v) {
        this.use_mv = v;
    }

    public File get_file(String bn) {
        return new File(this.working_dir, bn);
    }

    public static void main(String[] argv) {
        try {
            WorkingDirectory wd = new WorkingDirectory(new File("tmp"), new File("elsewhere"));
            wd.set_use_mv(true);
            File f1 = wd.get_file("file1");
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f1));
            PrintStream ps = new PrintStream(os);
            ps.println("f1 line1");
            ps.println("f1 line2");
            ps.close();
            File f2 = wd.get_file("file2");
            os = new BufferedOutputStream(new FileOutputStream(f2));
            ps = new PrintStream(os);
            ps.println("f2 line1");
            ps.println("f2 line2");
            ps.close();
            wd.finish();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

