/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ExonIntronCoverage;
import Ace2.Range;
import Ace2.Reporter;
import IsoView.UCSCRefGene;
import IsoView.UCSCRefGeneReader;
import java.io.File;
import java.util.ArrayList;

public class TranscriptExonIntronCoverage {
    private File bam;
    private ArrayList<File> refflats = new ArrayList();
    static boolean VERBOSE = false;

    public void add_refflat(File f) {
        this.refflats.add(f);
    }

    public void set_bam(File f) {
        this.bam = f;
    }

    public void find_coverage() throws Exception {
        if (this.refflats.size() == 0) {
            throw new Exception("specify -refflat");
        }
        if (this.bam == null) {
            throw new Exception("specify -bam");
        }
        String outfile = this.bam.getName() + ".exon_intron_coverage.tab";
        System.err.println(outfile);
        Reporter rpt = new Reporter();
        rpt.set_output_filename(outfile);
        rpt.add_header("gene");
        rpt.add_header("transcript");
        rpt.add_header("reference");
        rpt.add_header("strand");
        rpt.add_header("count_exons");
        rpt.add_header("start");
        rpt.add_header("end");
        rpt.add_header("count_exon_bases");
        rpt.add_header("count_intron_bases");
        rpt.add_header("count_reads_exon_exclusive");
        rpt.add_header("count_reads_intron_exclusive");
        rpt.add_header("count_reads_overlap");
        rpt.add_header("fraction_exclusive_reads_intron");
        rpt.add_header("count_reads_fuzzy_exonic");
        rpt.add_header("count_reads_fuzzy_intronic");
        rpt.add_header("count_reads_fuzzy_overlap");
        rpt.add_header("fraction_reads_fuzzy_intronic");
        ExonIntronCoverage eic = new ExonIntronCoverage();
        eic.set_bam(this.bam);
        for (File refflat : this.refflats) {
            UCSCRefGeneReader rgr = new UCSCRefGeneReader(refflat);
            while (rgr.hasNext()) {
                UCSCRefGene rg = rgr.next();
                ArrayList<Range> exons = new ArrayList<Range>();
                for (int i = 0; i < rg.exonStarts.length; ++i) {
                    Range r = new Range(rg.exonStarts[i] + 1, rg.exonEnds[i]);
                    exons.add(r);
                }
                rpt.set_value("gene", rg.name2);
                rpt.set_value("transcript", rg.name);
                rpt.set_value("strand", rg.strand);
                rpt.set_value("count_exons", Integer.toString(exons.size()));
                eic.find_coverage(rg.chrom, exons, rpt);
                rpt.end_row();
            }
        }
        rpt.close();
    }

    public static void main(String[] argv) {
        try {
            TranscriptExonIntronCoverage teic = new TranscriptExonIntronCoverage();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-refflat")) {
                    teic.add_refflat(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-bam")) {
                    teic.set_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-v")) {
                    VERBOSE = true;
                    continue;
                }
                System.err.println("ERROR: unknown parameter " + argv[i]);
                System.exit(1);
            }
            teic.find_coverage();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

