/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.PhredPolyFile;
import Ace2.PhredPolyFileEntry;
import Ace2.Reporter;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyReport {
    private static final String ALTERNATE_IGNORE_SUFFIX = "_alternate";
    private static int IGNORE_SUFFIX_LENGTH = "_alternate".length();
    private int target_basenum;
    private static final char NULL_CHAR = '0';
    private String poly_dir = null;
    private String out_file_name = "poly_report.tab";
    private HashMap<String, String> extra_info = null;

    public PolyReport(String poly_dir) {
        this.poly_dir = poly_dir;
    }

    public void report(File bam_file, String ref_name, int target_basenum) {
        this.target_basenum = target_basenum;
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_file);
        SAMRecordIterator iterator = reader.queryOverlapping(ref_name, target_basenum, target_basenum);
        this.get_some((CloseableIterator<SAMRecord>)iterator, ref_name + "." + target_basenum, '0', '0');
    }

    public void report(File bam_file, String ref_name, int target_basenum, char ref, char var) {
        this.target_basenum = target_basenum;
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam_file);
        SAMRecordIterator iterator = reader.queryOverlapping(ref_name, target_basenum, target_basenum);
        this.get_some((CloseableIterator<SAMRecord>)iterator, ref_name + "." + target_basenum, ref, var);
    }

    public void set_poly_dir(String poly_dir) {
    }

    public void set_outfile(String out_file) {
        this.out_file_name = out_file;
    }

    private void get_some(CloseableIterator<SAMRecord> iterator, String site_name, char reference_base, char variant_base) {
        boolean target_mode = reference_base != '0';
        Reporter rpt = new Reporter();
        if (this.extra_info != null && this.extra_info.size() > 0) {
            ArrayList<String> labels = new ArrayList<String>(this.extra_info.keySet());
            Collections.sort(labels);
            for (String label : labels) {
                rpt.add_header(label);
            }
        }
        rpt.add_header("site");
        rpt.add_header("read_name");
        rpt.add_header("strand");
        rpt.add_header("base_quality");
        if (target_mode) {
            rpt.add_header("reference_base");
            rpt.add_header("reference_base_amplitude");
            rpt.add_header("reference_base_phred_type");
            rpt.add_header("variant_base");
            rpt.add_header("variant_base_amplitude");
            rpt.add_header("variant_base_phred_type");
        } else {
            rpt.add_header("called_base");
            rpt.add_header("called_base_amplitude");
            rpt.add_header("alternate_base");
            rpt.add_header("alternate_base_amplitude");
        }
        try {
            rpt.set_output_filename(this.out_file_name);
            while (iterator.hasNext()) {
                SAMRecord sr = (SAMRecord)iterator.next();
                String trace_name = sr.getReadName();
                if (trace_name.indexOf(ALTERNATE_IGNORE_SUFFIX) == trace_name.length() - IGNORE_SUFFIX_LENGTH) continue;
                if (this.extra_info != null && this.extra_info.size() > 0) {
                    for (String label : this.extra_info.keySet()) {
                        rpt.set_value(label, this.extra_info.get(label));
                    }
                }
                rpt.set_value("site", site_name);
                rpt.set_value("read_name", trace_name);
                rpt.set_value("strand", sr.getReadNegativeStrandFlag() ? "-" : "+");
                byte[] bases = sr.getReadBases();
                byte[] quals = sr.getBaseQualities();
                boolean found = false;
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int len = ab.getLength();
                    int read_i = ab.getReadStart() - 1;
                    int reference_basenum = ab.getReferenceStart();
                    if (read_i < 0 || reference_basenum < 1) continue;
                    int end = read_i + len;
                    while (read_i < end) {
                        if (reference_basenum == this.target_basenum) {
                            File poly_file = new File(this.poly_dir + File.separator + trace_name + ".poly");
                            PhredPolyFile pf = new PhredPolyFile();
                            pf.parse(poly_file);
                            if (sr.getReadNegativeStrandFlag()) {
                                pf.reverse_complement();
                            }
                            PhredPolyFileEntry pfe = pf.get_entry_for_index(read_i);
                            char sam_base = (char)bases[read_i];
                            if (sam_base != pfe.called_base) {
                                System.err.println("BAM/.poly base mismatch!!");
                                System.exit(1);
                            }
                            rpt.set_value("base_quality", Integer.toString(quals[read_i]));
                            if (target_mode) {
                                this.populate_info(pfe, rpt, reference_base, "reference");
                                this.populate_info(pfe, rpt, variant_base, "variant");
                            } else {
                                rpt.set_value("called_base", Character.toString(sam_base));
                                rpt.set_value("alternate_base", Character.toString(pfe.uncalled_base));
                                rpt.set_value("called_base_amplitude", Float.toString(pfe.get_called_base_amplitude()));
                                rpt.set_value("alternate_base_amplitude", Float.toString(pfe.get_uncalled_base_amplitude()));
                            }
                            rpt.end_row();
                            found = true;
                            break;
                        }
                        ++read_i;
                        ++reference_basenum;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                System.err.println("note: no hit for " + trace_name + "; deletion?");
            }
            rpt.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        String tname = null;
        int basenum = -1;
        File bam = null;
        String poly_dir = null;
        String outfile = "poly_report.tab";
        char reference_base = '\u0000';
        char variant_base = '\u0000';
        HashMap<String, String> report = new HashMap<String, String>();
        for (int i = 0; i < argv.length; ++i) {
            String base;
            if (argv[i].equals("-ref")) {
                tname = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-base")) {
                basenum = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-outfile")) {
                outfile = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-bam")) {
                bam = new File(argv[++i]);
                continue;
            }
            if (argv[i].equals("-poly")) {
                poly_dir = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-ref-base")) {
                if ((base = argv[++i]).length() == 1) {
                    reference_base = base.charAt(0);
                    System.err.println("rb=" + reference_base);
                    continue;
                }
                System.err.println("-ref-base base is a char");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-var-base")) {
                if ((base = argv[++i]).length() == 1) {
                    variant_base = base.charAt(0);
                    System.err.println("vb=" + variant_base);
                    continue;
                }
                System.err.println("-var-base base is a char");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-report")) {
                String[] stuff;
                if ((stuff = argv[++i].split(",")).length == 2) {
                    report.put(stuff[0], stuff[1]);
                    continue;
                }
                System.err.println("ERROR: -report uses format column,label");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-demo")) {
                bam = new File("all.primary_phred_15_area_ratio_0.33_untrimmed.sam_diploid.sorted.bam");
                tname = "chr10";
                basenum = 13726648;
                poly_dir = "c:\\generatable\\max_poly\\";
                continue;
            }
            System.err.println("ERROR: unknown argument " + argv[i]);
            PolyReport.usage();
        }
        if (tname != null && basenum != -1 && poly_dir != null && bam != null) {
            PolyReport pr = new PolyReport(poly_dir);
            if (report.size() > 0) {
                pr.set_report_info(report);
            }
            pr.set_outfile(outfile);
            if (reference_base != '\u0000' || variant_base != '\u0000') {
                if (reference_base != '\u0000' && variant_base != '\u0000') {
                    pr.report(bam, tname, basenum, reference_base, variant_base);
                } else {
                    System.err.println("must specify both -ref-base and -var-base");
                    System.exit(1);
                }
            } else {
                pr.report(bam, tname, basenum);
            }
        } else {
            PolyReport.usage();
        }
    }

    private static void usage() {
        System.err.println("usage:");
        System.err.println("  input data:");
        System.err.println("    -poly [directory containing phred .poly files / poly_dir]");
        System.err.println("    -bam [bamfile]");
        System.err.println("  target site:");
        System.err.println("    -ref [reference sequence name (e.g. chr1)]");
        System.err.println("    -base [base number]");
        System.err.println("  target alleles mode (optional):");
        System.err.println("    -ref-base [reference allele to query]");
        System.err.println("    -var-base [variant allele to query]");
        System.err.println("  output:");
        System.err.println("    -outfile [output .tab report (default: poly_report.tab)]");
        System.exit(1);
    }

    private void populate_info(PhredPolyFileEntry pfe, Reporter rpt, char target_base, String label_root) {
        target_base = Character.toUpperCase(target_base);
        float amplitude = 0.0f;
        String phred_call_type = "?";
        if (pfe.called_base == target_base) {
            phred_call_type = "called_base";
            amplitude = pfe.get_called_base_amplitude();
        } else if (pfe.uncalled_base == target_base) {
            phred_call_type = "alternate_base";
            amplitude = pfe.get_uncalled_base_amplitude();
        } else {
            phred_call_type = "not_called";
            if (target_base == 'A') {
                amplitude = pfe.called_base_amp_a;
            } else if (target_base == 'C') {
                amplitude = pfe.called_base_amp_c;
            } else if (target_base == 'G') {
                amplitude = pfe.called_base_amp_g;
            } else if (target_base == 'T') {
                amplitude = pfe.called_base_amp_t;
            } else {
                System.err.println("WTF?");
                System.exit(1);
            }
        }
        String label_base = label_root + "_base";
        String label_amp = label_root + "_base_amplitude";
        String label_phred_type = label_root + "_base_phred_type";
        rpt.set_value(label_base, Character.toString(target_base));
        rpt.set_value(label_amp, Float.toString(amplitude));
        rpt.set_value(label_phred_type, phred_call_type);
    }

    public void set_report_info(HashMap<String, String> extra_info) {
        this.extra_info = extra_info;
    }
}

