/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASTASequenceReader
implements Runnable {
    private BufferedReader br;
    private boolean data_loaded = false;
    private HashMap<String, StringBuffer> seqs;
    private AceViewer av;

    public FASTASequenceReader(BufferedReader br, boolean async) {
        this.br = br;
        this.setup(async);
    }

    private void setup(boolean async) {
        if (async) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        String id = null;
        this.seqs = new HashMap();
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                if (line.indexOf(">") == 0) {
                    String[] stuff = line.substring(1).split("\\s+");
                    id = new String(stuff[0]);
                    continue;
                }
                StringBuffer sb = this.seqs.get(id);
                if (sb == null) {
                    sb = new StringBuffer();
                    this.seqs.put(id, sb);
                }
                sb.append(line);
            }
            this.data_loaded = true;
        }
        catch (Exception e) {
            System.err.println("FASTASequenceReader load error: " + e);
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        try {
            URL url = new URL(argv[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            FASTASequenceReader fa = new FASTASequenceReader(br, false);
            StringBuffer sb = fa.get_sequences().get("chr7");
            System.err.println(sb);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public HashMap<String, StringBuffer> get_sequences() {
        return this.seqs;
    }
}

