/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.FAIIndexRecord;
import Ace2.FASTAFileTools;
import Ace2.ReferenceSequence;
import Ace2.SAMUtils;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASTAIndexedFAI
implements ReferenceSequence {
    RandomAccessFile raf;
    HashMap<String, FAIIndexRecord> index;
    FASTAFileTools ffp = new FASTAFileTools();
    ReferenceSource rs = null;

    public FASTAIndexedFAI(String fn) throws FileNotFoundException, IOException {
        this.raf = new RandomAccessFile(fn, "r");
        this.rs = new ReferenceSource(new File(fn));
        this.load_index(fn + ".fai");
    }

    private void load_index(String fn) throws FileNotFoundException, IOException {
        File f = new File(fn);
        this.index = new HashMap();
        if (f.exists()) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = br.readLine()) != null) {
                FAIIndexRecord rec = new FAIIndexRecord(line);
                if (this.index.containsKey(rec.sequence_id)) {
                    System.err.println("WARNING; duplicate index entry for " + rec.sequence_id);
                }
                this.index.put(rec.sequence_id, rec);
            }
        } else {
            System.err.println("ERROR: no samtools FASTA index file " + fn + "; generate with \"samtools faidx file\"");
        }
    }

    @Override
    public byte[] get_region(String sequence_name, int start_base, int length) throws IOException {
        byte[] results = null;
        FAIIndexRecord ir = this.get_index_for(sequence_name);
        if (ir != null) {
            this.ffp.set_index(ir);
            results = this.ffp.get_region(this.raf, start_base, length);
        }
        return results;
    }

    @Override
    public byte[] get_all(String sequence_name) throws IOException {
        byte[] results = null;
        FAIIndexRecord ir = this.get_index_for(sequence_name);
        if (ir != null) {
            this.ffp.set_index(ir);
            results = this.ffp.get_all(this.raf);
        }
        return results;
    }

    private FAIIndexRecord get_index_for(String id) {
        ChromosomeDisambiguator cd;
        String key;
        FAIIndexRecord result = null;
        Iterator<String> i$ = SAMUtils.get_refname_alternates(id).iterator();
        while (i$.hasNext() && (result = this.index.get(key = i$.next())) == null) {
        }
        if (result == null && (key = (cd = new ChromosomeDisambiguator(this.index.keySet())).find(id)) != null) {
            result = this.index.get(key);
        }
        if (result == null) {
            System.err.println("WARNING: can't find .fai index entry for " + id);
        }
        return result;
    }

    @Override
    public int get_length(String sequence_name) throws IOException {
        int length = -1;
        FAIIndexRecord ir = this.get_index_for(sequence_name);
        if (ir != null) {
            length = ir.sequence_length;
        }
        return length;
    }

    public static void main(String[] argv) {
        try {
            FASTAIndexedFAI fai = new FASTAIndexedFAI("ecoli_out.padded.fasta");
            String id = "NC_000913_bb";
            System.err.println("len=" + fai.get_length(id));
            byte[] all = fai.get_all(id);
            System.err.println("all=" + new String(all));
            byte[] region = fai.get_region(id, 131, 10);
            System.err.println("region=" + new String(region));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    @Override
    public boolean supports_sequence_list() {
        return true;
    }

    @Override
    public ArrayList<String> get_sequence_names() {
        return new ArrayList<String>(this.index.keySet());
    }

    @Override
    public ReferenceSource getReferenceSource() {
        return this.rs;
    }
}

