/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Codon;
import Ace2.IntronCompressor;
import Ace2.PadMap;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exon {
    String id;
    int start;
    int end;
    ArrayList<Codon> codons;
    int consensus_start;
    int consensus_end;
    int frame_offset;
    boolean is_rc = false;

    public Exon(String id, int start, int end, int frame_offset) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.frame_offset = frame_offset;
        this.codons = new ArrayList();
    }

    public void add_codon(Codon c) {
        this.codons.add(c);
    }

    public int get_first_start() {
        int size = this.codons.size();
        int result = 0;
        for (int i = 0; i < size; ++i) {
            Codon c = this.codons.get(i);
            if (c.is_unmappable()) continue;
            result = c.c_start_offset();
            break;
        }
        return result;
    }

    public int get_last_end() {
        int size = this.codons.size();
        int result = 0;
        for (int i = size - 1; i >= 0; --i) {
            Codon c = this.codons.get(i);
            if (c.is_unmappable()) continue;
            result = c.c_last_offset();
            break;
        }
        return result;
    }

    public void build_consensus_ranges() {
        if (this.codons == null || this.codons.size() == 0) {
            this.consensus_end = 0;
            this.consensus_start = 0;
        } else if (this.is_rc) {
            this.consensus_start = this.get_last_end();
            this.consensus_end = this.get_first_start();
        } else {
            this.consensus_start = this.get_first_start();
            this.consensus_end = this.get_last_end();
        }
    }

    public boolean intersects(int csv, int cev) {
        return this.consensus_start <= cev && this.consensus_end >= csv;
    }

    public ArrayList<Codon> get_codons() {
        return this.codons;
    }

    public String get_id() {
        return this.id;
    }

    public void set_id(String id) {
        this.id = id;
    }

    public void set_rc(boolean is_rc) {
        this.is_rc = is_rc;
    }

    public String get_protein_sequence() {
        StringBuffer sb = new StringBuffer();
        for (Codon co : this.get_codons()) {
            if (co.is_unmappable()) continue;
            sb.append(co.to_code());
        }
        return sb.toString();
    }

    public String toString() {
        return "exon " + this.id + ": " + this.get_protein_sequence();
    }

    public void intron_splice_adjust(IntronCompressor ic, PadMap pm) {
        int offset = ic.get_start_shift(this.start, false);
        this.start -= offset;
        this.end -= offset;
        for (Codon c : this.codons) {
            c.intron_splice_adjust(ic, pm);
        }
    }
}

