# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

# pyre-unsafe

DEFAULT_TIMEOUT = object()

class BaseCache:
    def __init__(self, params): ...
    def get_backend_timeout(self, timeout=DEFAULT_TIMEOUT): ...
    def make_key(self, key, version=None): ...
    def add(self, key, value, timeout=DEFAULT_TIMEOUT, version=None): ...
    def get(self, key, default=None, version=None): ...
    def set(self, key, value, timeout=DEFAULT_TIMEOUT, version=None): ...
    def delete(self, key, version=None): ...
    def get_many(self, keys, version=None): ...
    def has_key(self, key, version=None): ...
    def incr(self, key, delta=1, version=None): ...
    def decr(self, key, delta=1, version=None): ...
    def __contains__(self, key): ...
    def set_many(self, data, timeout=DEFAULT_TIMEOUT, version=None): ...
    def delete_many(self, keys, version=None): ...
    def clear(self): ...
    def validate_key(self, key): ...
    def incr_version(self, key, delta=1, version=None): ...
    def decr_version(self, key, delta=1, version=None): ...
    def close(self, **kwargs): ...
