from starkware.crypto.signature.signature import FIELD_PRIME
from starkware.storage.storage import HASH_BYTES

STARKNET_LANG_DIRECTIVE = "starknet"

FIELD_SIZE = FIELD_PRIME
FIELD_SIZE_BITS = 251
CONTRACT_ADDRESS_BITS = FIELD_SIZE_BITS

FELT_LOWER_BOUND = 0
FELT_UPPER_BOUND = FIELD_SIZE
CALLER_ADDRESS_LOWER_BOUND = 0
CALLER_ADDRESS_UPPER_BOUND = 2 ** CONTRACT_ADDRESS_BITS
# Address 0 is reserved to distinguish an external transaction from an inner (L2<>L2) one.
CONTRACT_ADDRESS_LOWER_BOUND = 1
CONTRACT_ADDRESS_UPPER_BOUND = CALLER_ADDRESS_UPPER_BOUND
CONTRACT_ADDRESS_SALT_LOWER_BOUND = FELT_LOWER_BOUND
CONTRACT_ADDRESS_SALT_UPPER_BOUND = FELT_UPPER_BOUND
CONTRACT_HASH_BYTES = HASH_BYTES
CONTRACT_HASH_UPPER_BOUND = FIELD_SIZE
CONTRACT_STATES_MERKLE_TREE_HEIGHT = FIELD_SIZE_BITS
ENTRY_POINT_OFFSET_LOWER_BOUND = 0
ENTRY_POINT_OFFSET_UPPER_BOUND = FIELD_SIZE
ENTRY_POINT_SELECTOR_LOWER_BOUND = 0
ENTRY_POINT_SELECTOR_UPPER_BOUND = FIELD_SIZE
MAX_MESSAGE_TO_L1_LENGTH = 100
MAX_CALLDATA_LENGTH = 2 ** 30
SYSCALL_SELECTOR_UPPER_BOUND = FIELD_SIZE
TRANSACTION_HASH_LOWER_BOUND = 0
TRANSACTION_HASH_UPPER_BOUND = FIELD_SIZE
