# Generated by Django 2.2.13 on 2020-06-18 10:39

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ActionContentType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "content_type",
                    models.CharField(
                        choices=[("book", "book"), ("user", "user")],
                        db_index=True,
                        max_length=50,
                    ),
                ),
                ("table", models.CharField(max_length=100)),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EventJournal",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("create", "create"),
                            ("update", "update"),
                            ("delete", "delete"),
                        ],
                        db_index=True,
                        max_length=30,
                    ),
                ),
                ("object_id", models.CharField(db_index=True, max_length=100)),
                (
                    "content_type",
                    models.CharField(
                        choices=[("book", "book"), ("user", "user")],
                        db_index=True,
                        max_length=50,
                    ),
                ),
                (
                    "data",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True, null=True
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
    ]
