/*! 
* DevExtreme (Common Widgets)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_WIDGETS_BASE){if(!window.DevExpress)throw Error("Required module is not referenced: core");(function(n,t){var o=t.ui,f=o.events,r="dxScrollable",h="dxScrollableStrategy",c="dx-scrollable",l="dx-scrollable-disabled",a="dx-scrollable-container",v="dx-scrollable-content",u="vertical",e="horizontal",s="both";t.registerComponent(r,t.DOMComponent.inherit({NAMESPACE:o,_setDefaultOptions:function(){this.callBase(),this.option({disabled:!1,scrollAction:null,direction:u,showScrollbar:!0,useNative:!0,updateAction:null,useSimulatedScrollbar:!1,useKeyboard:!0,inertiaEnabled:!0,bounceEnabled:!0,scrollByContent:!0,scrollByThumb:!1,startAction:null,endAction:null,bounceAction:null,stopAction:null})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){return!t.support.nativeScrolling},options:{useNative:!1,useSimulatedScrollbar:!0}},{device:function(n){return!t.support.nativeScrolling&&!t.devices.isSimulator()&&t.devices.real().platform==="generic"&&n.platform==="generic"},options:{scrollByThumb:!0,scrollByContent:!1,showScrollbar:"onHover",bounceEnabled:!1}},{device:function(){return t.support.nativeScrolling&&t.devices.real().platform==="android"},options:{useSimulatedScrollbar:!0}}])},_init:function(){this.callBase(),this._initMarkup(),this._attachNativeScrollbarsCustomizationCss(),this._locked=!1},_visibilityChanged:function(n){n?(this.update(),this._savedScrollOffset&&this.scrollTo(this._savedScrollOffset)):this._savedScrollOffset=this.scrollOffset()},_initMarkup:function(){var t=this._element().addClass(c),i=this._$container=n("<div>").addClass(a),r=this._$content=n("<div>").addClass(v);r.append(t.contents()).appendTo(i),i.appendTo(t)},_dimensionChanged:function(){this.update()},_attachNativeScrollbarsCustomizationCss:function(){navigator.platform.indexOf("Mac")>-1&&DevExpress.browser.webkit||this._element().addClass("dx-scrollable-customizable-scrollbars")},_render:function(){this._renderDirection(),this._renderStrategy(),this._attachEventHandlers(),this._renderDisabledState(),this._createActions(),this.update(),this.callBase()},_toggleRTLDirection:function(n){this.callBase(n),n&&this.scrollTo({left:this.scrollWidth()-this.clientWidth()})},_attachEventHandlers:function(){var t=this._strategy,i={getDirection:n.proxy(t.getDirection,t),validate:n.proxy(this._validate,this)};this._$container.off("."+r).on(f.addNamespace("scroll",r),n.proxy(t.handleScroll,t)).on(f.addNamespace("dxscrollinit",r),i,n.proxy(this._handleInit,this)).on(f.addNamespace("dxscrollstart",r),n.proxy(t.handleStart,t)).on(f.addNamespace("dxscroll",r),n.proxy(t.handleMove,t)).on(f.addNamespace("dxscrollend",r),n.proxy(t.handleEnd,t)).on(f.addNamespace("dxscrollcancel",r),n.proxy(t.handleCancel,t)).on(f.addNamespace("dxscrollstop",r),n.proxy(t.handleStop,t))},_validate:function(n){return this.update(),this._strategy.validate(n)},_handleInit:function(){var n=this._strategy;n.handleInit.apply(n,arguments)},_renderDisabledState:function(){this._element().toggleClass(l,this.option("disabled")),this.option("disabled")?this._lock():this._unlock()},_renderDirection:function(){this._element().removeClass("dx-scrollable-"+e).removeClass("dx-scrollable-"+u).removeClass("dx-scrollable-"+s).addClass("dx-scrollable-"+this.option("direction"))},_renderStrategy:function(){this._createStrategy(),this._strategy.render(),this._element().data(h,this._strategy)},_createStrategy:function(){this._strategy=this.option("useNative")?new o.NativeScrollableStrategy(this):new o.SimulatedScrollableStrategy(this)},_createActions:function(){this._strategy.createActions()},_clean:function(){this._strategy.dispose()},_optionChanged:function(n){switch(n){case"startAction":case"endAction":case"stopAction":case"updateAction":case"scrollAction":case"bounceAction":this._createActions();break;case"direction":this._resetInactiveDirection(),this._invalidate();break;case"inertiaEnabled":case"bounceEnabled":case"scrollByContent":case"scrollByThumb":case"bounceEnabled":case"useNative":case"useKeyboard":case"showScrollbar":case"useSimulatedScrollbar":this._invalidate();break;case"disabled":this._renderDisabledState();break;default:this.callBase.apply(this,arguments)}},_resetInactiveDirection:function(){var t=this._getInactiveProp(),n;t&&(n=this.scrollOffset(),n[t]=0,this.scrollTo(n))},_getInactiveProp:function(){var n=this.option("direction");return n===u?"left":n===e?"top":void 0},_location:function(){return this._strategy.location()},_normalizeLocation:function(t){var i=this.option("direction");return{left:n.isPlainObject(t)?-(t.left||t.x||0):i!==u?-t:0,top:n.isPlainObject(t)?-(t.top||t.y||0):i!==e?-t:0}},_isLocked:function(){return this._locked},_lock:function(){this._locked=!0},_unlock:function(){this._locked=!1},_isDirection:function(n){var t=this.option("direction");return n===u?t!==e:n===e?t!==u:t===n},_updateAllowedDirection:function(){var n=this._strategy._allowedDirections();this._allowedDirectionValue=this._isDirection(s)&&n.vertical&&n.horizontal?s:this._isDirection(e)&&n.horizontal?e:this._isDirection(u)&&n.vertical?u:null},_allowedDirection:function(){return this._allowedDirectionValue},content:function(){return this._$content},scrollOffset:function(){var n=this._location();return{top:-n.top,left:-n.left}},scrollTop:function(){return this.scrollOffset().top},scrollLeft:function(){return this.scrollOffset().left},clientHeight:function(){return this._$container.height()},scrollHeight:function(){return this.content().height()},clientWidth:function(){return this._$container.width()},scrollWidth:function(){return this.content().width()},update:function(){return this._strategy.update(),this._updateAllowedDirection(),n.Deferred().resolve().promise()},scrollBy:function(n){n=this._normalizeLocation(n),this._strategy.scrollBy(n)},scrollTo:function(n){n=this._normalizeLocation(n);var t=this._location();this.scrollBy({left:t.left-n.left,top:t.top-n.top})}}))})(jQuery,DevExpress),function(n,t){var e=t.ui,o=e.events,f="dxScrollbar",s="dx-scrollable-scrollbar",h=s+"-active",l="dx-scrollable-scroll",y="dx-scrollable-scrollbars-hidden",a="dx-scrollbar-hoverable",p="vertical",c="horizontal",v=15,r={onScroll:"onScroll",onHover:"onHover",always:"always",never:"never"},u;t.registerComponent(f,e.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({direction:null,visible:!1,activeStateEnabled:!1,visibilityMode:r.onScroll,containerSize:0,contentSize:0})},_init:function(){this.callBase(),this._isHovered=!1},_render:function(){this._renderThumb(),this.callBase(),this._renderDirection(),this._update(),this._attachPointerDownHandler(),this.option("hoverStateEnabled",this._isHoverMode()),this._element().toggleClass(a,this.option("hoverStateEnabled"))},_renderThumb:function(){this._$thumb=n("<div>").addClass(l),this._element().addClass(s).append(this._$thumb)},isThumb:function(n){return!!this._element().find(n).length},_isHoverMode:function(){return this.option("visibilityMode")===r.onHover},_renderDirection:function(){var n=this.option("direction");this._element().addClass("dx-scrollbar-"+n),this._dimension=n===c?"width":"height",this._prop=n===c?"left":"top"},_attachPointerDownHandler:function(){this._$thumb.on(o.addNamespace("dxpointerdown",f),n.proxy(this.feedbackOn,this))},feedbackOn:function(){this._element().addClass(h),u=this},feedbackOff:function(){this._element().removeClass(h),u=null},cursorEnter:function(){this._isHovered=!0,this.option("visible",!0)},cursorLeave:function(){this._isHovered=!1,this.option("visible",!1)},_renderDimensions:function(){this._$thumb.height(this.option("height")),this._$thumb.width(this.option("width"))},_toggleVisibility:function(n){n=this._adjustVisibility(n),this.option().visible=n,this._$thumb.toggleClass("dx-state-invisible",!n)},_adjustVisibility:function(n){if(this.containerToContentRatio()&&!this._needScrollbar())return!1;switch(this.option("visibilityMode")){case r.onHover:n=n||!!this._isHovered;break;case r.never:n=!1;break;case r.always:n=!0}return n},moveTo:function(i){if(!this._isHidden()){n.isPlainObject(i)&&(i=i[this._prop]||0);var r={};r[this._prop]=this._calculateScrollBarPosition(i),t.translator.move(this._$thumb,r)}},_calculateScrollBarPosition:function(n){return-n*this._thumbRatio},_update:function(){var n=this.option("containerSize"),i=this.option("contentSize"),t;this._containerToContentRatio=n/i,t=Math.round(Math.max(Math.round(n*this._containerToContentRatio),v)),this._thumbRatio=(n-t)/(i-n),this.option(this._dimension,t),this._element().toggle(this._needScrollbar())},_isHidden:function(){return this.option("visibilityMode")===r.never},_needScrollbar:function(){return!this._isHidden()&&this._containerToContentRatio<1},containerToContentRatio:function(){return this._containerToContentRatio},_normalizeSize:function(t){return n.isPlainObject(t)?t[this._dimension]||0:t},_clean:function(){this.callBase(),this===u&&(u=null),this._$thumb.off("."+f)},_optionChanged:function(n,t){if(!this._isHidden())switch(n){case"containerSize":case"contentSize":this.option()[n]=this._normalizeSize(t),this._update();break;case"visibilityMode":case"direction":this._invalidate();break;default:this.callBase.apply(this,arguments)}}})),u=null;n(document).on(o.addNamespace("dxpointerup",f),function(){u&&u.feedbackOff()})}(jQuery,DevExpress),function(n,t,i){var e=t.ui,y=e.events,p=t.utils,h=t.devices,w=Math.abs,o="dxNativeScrollable",f="dx-scrollable-native",c="dx-scrollable-scrollbar-simulated",l="dx-scrollable-scrollbars-hidden",r="vertical",u="horizontal",s="dxGestureLock",a=400,v=500;e.NativeScrollableStrategy=t.Class.inherit({ctor:function(n){this._init(n)},_init:function(t){this._component=t,this._$element=t._element(),this._$container=t._$container,this._$content=t._$content,this._direction=t.option("direction"),this._useSimulatedScrollbar=t.option("useSimulatedScrollbar"),this._showScrollbar=t.option("showScrollbar"),this.option=n.proxy(t.option,t),this._createActionByOption=n.proxy(t._createActionByOption,t),this._isLocked=n.proxy(t._isLocked,t),this._isDirection=n.proxy(t._isDirection,t),this._allowedDirection=n.proxy(t._allowedDirection,t)},render:function(){this._$element.addClass(f).addClass(f+"-"+h.real().platform).toggleClass(l,!this._showScrollbar),this._showScrollbar&&this._useSimulatedScrollbar&&this._renderScrollbars()},_renderScrollbars:function(){this._scrollbars={},this._hideScrollbarTimeout=0,this._$element.addClass(c),this._renderScrollbar(r),this._renderScrollbar(u)},_renderScrollbar:function(t){if(this._isDirection(t)){var i=n("<div>").dxScrollbar({direction:t}).appendTo(this._$element);this._scrollbars[t]=i.dxScrollbar("instance")}},handleInit:n.noop,handleStart:n.noop,handleMove:function(n){if(this._isLocked()){n.cancel=!0;return}this._allowedDirection()&&(n.originalEvent.originalEvent.isScrollingEvent=!0)},handleEnd:n.noop,handleStop:n.noop,_eachScrollbar:function(t){t=n.proxy(t,this),n.each(this._scrollbars||{},function(n,i){t(i,n)})},createActions:function(){var n={excludeValidators:["gesture"]};this._scrollAction=this._createActionByOption("scrollAction",n),this._updateAction=this._createActionByOption("updateAction",n)},_createActionArgs:function(){var n=this.location();return{jQueryEvent:this._eventForUserAction,scrollOffset:{top:-n.top,left:-n.left},reachedLeft:this._isDirection(u)?n.left>=0:i,reachedRight:this._isDirection(u)?n.left<=this._containerSize.width-this._componentContentSize.width:i,reachedTop:this._isDirection(r)?n.top>=0:i,reachedBottom:this._isDirection(r)?n.top<=this._containerSize.height-this._componentContentSize.height:i}},handleScroll:function(n){if(!this._isScrollLocationChanged()){n.stopImmediatePropagation();return}this._eventForUserAction=n,this._moveScrollbars(),this._scrollAction(this._createActionArgs()),this._treatNativeGesture(),this._lastLocation=this.location()},_isScrollLocationChanged:function(){var n=this.location(),t=this._lastLocation||{},i=t.top!==n.top,r=t.left!==n.left;return i||r},_moveScrollbars:function(){this._eachScrollbar(function(n){n.moveTo(this.location()),n.option("visible",!0)}),this._hideScrollbars()},_hideScrollbars:function(){clearTimeout(this._hideScrollbarTimeout),this._hideScrollbarTimeout=setTimeout(n.proxy(function(){this._eachScrollbar(function(n){n.option("visible",!1)})},this),v)},_treatNativeGesture:function(){this._prepareGesture(),this._forgetGesture()},_prepareGesture:function(){this._gestureEndTimer?(clearTimeout(this._gestureEndTimer),this._gestureEndTimer=null):this._$element.data(s,!0)},_forgetGesture:function(){this._gestureEndTimer=setTimeout(n.proxy(function(){this._$element.data(s,!1),this._gestureEndTimer=null},this),a)},location:function(){return{left:-this._$container.scrollLeft(),top:-this._$container.scrollTop()}},disabledChanged:n.noop,update:function(){this._update(),this._updateAction(this._createActionArgs())},_update:function(){this._updateDimensions(),this._updateScrollbars()},_updateDimensions:function(){this._containerSize={height:this._$container.height(),width:this._$container.width()},this._componentContentSize={height:this._component.content().height(),width:this._component.content().width()},this._contentSize={height:this._$content.height(),width:this._$content.width()}},_updateScrollbars:function(){this._eachScrollbar(function(n,t){var i=t===r?"height":"width";n.option({containerSize:this._containerSize[i],contentSize:this._componentContentSize[i]})})},_allowedDirections:function(){return{vertical:this._isDirection(r)&&this._contentSize.height>this._containerSize.height,horizontal:this._isDirection(u)&&this._contentSize.width>this._containerSize.width}},dispose:function(){this._$element.removeClass(function(n,t){var i=new RegExp(f+"\\S*","g");if(i.test(t))return t.match(i).join(" ")}),this._$element.off("."+o),this._$container.off("."+o),this._removeScrollbars(),clearTimeout(this._gestureEndTimer)},_removeScrollbars:function(){this._eachScrollbar(function(n){n._element().remove()})},scrollBy:function(n){var t=this.location();this._$container.scrollTop(-t.top-n.top),this._$container.scrollLeft(-t.left-n.left)},validate:function(){return!this.option("disabled")&&this._allowedDirection()},getDirection:function(){return this._allowedDirection()}})}(jQuery,DevExpress),function(n,t,i){var a=t.ui,v=a.events,o=Math,w=t.devices.real,b=w.platform==="win8"||w.platform==="android",k="dxSimulatedScrollable",it="dxScrollableStrategy",h=k+"Cursor",y=k+"Keyboard",p="dx-scrollable-simulated",rt="dx-scrollable-scrollbars-hidden",u="vertical",r="horizontal",c=b?.95:.92,d=.5,g=1,ut=o.round(1e3/60),nt=20,ft=g/5,et=b?300:400,ot=et/ut,st=(1-o.pow(c,ot))/(1-c),e={PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40},tt=t.Animator.inherit({ctor:function(n){this.callBase(),this.scroller=n},VELOCITY_LIMIT:g,_isFinished:function(){return o.abs(this.scroller._velocity)<=this.VELOCITY_LIMIT},_step:function(){this.scroller._scrollStep(this.scroller._velocity),this.scroller._velocity*=this._acceleration()},_acceleration:function(){return this.scroller._inBounds()?c:d},_complete:function(){this.scroller._scrollComplete()},_stop:function(){this.scroller._stopComplete()}}),ht=tt.inherit({VELOCITY_LIMIT:ft,_isFinished:function(){return this.scroller._crossBoundOnNextStep()||this.callBase()},_acceleration:function(){return c},_complete:function(){this.scroller._move(this.scroller._bounceLocation),this.callBase()}}),l=function(n){return n.type==="dxmousewheel"},ct=a.Scroller=t.Class.inherit({ctor:function(n){this._initOptions(n),this._initAnimators(),this._initScrollbar()},_initOptions:function(t){this._location=0,this._topReached=!1,this._bottomReached=!1,this._axis=t.direction===r?"x":"y",this._prop=t.direction===r?"left":"top",this._dimension=t.direction===r?"width":"height",this._scrollProp=t.direction===r?"scrollLeft":"scrollTop",n.each(t,n.proxy(function(n,t){this["_"+n]=t},this))},_initAnimators:function(){this._inertiaAnimator=new tt(this),this._bounceAnimator=new ht(this)},_initScrollbar:function(){this._$scrollbar=n("<div>").dxScrollbar({direction:this._direction,visible:this._scrollByThumb,visibilityMode:this._visibilityModeNormalize(this._scrollbarVisible),containerSize:this._containerSize(),contentSize:this._contentSize()}).appendTo(this._$container),this._scrollbar=this._$scrollbar.dxScrollbar("instance")},_visibilityModeNormalize:function(n){return n===!0?"onScroll":n===!1?"never":n},_scrollStep:function(n){var t=this._location;this._location+=n,this._suppressBounce(),this._move(),t!==this._location&&(this._scrollAction(),this._$element.triggerHandler("scroll"))},_suppressBounce:function(){this._bounceEnabled||this._inBounds(this._location)||(this._velocity=0,this._location=this._boundLocation())},_boundLocation:function(){var n=o.min(this._location,this._maxOffset);return o.max(n,this._minOffset)},_move:function(n){this._location=n!==i?n:this._location,this._moveContent(),this._moveScrollbar()},_moveContent:function(){var n={};n[this._prop]=this._location,t.translator.move(this._$content,n)},_moveScrollbar:function(){this._scrollbar.moveTo(this._location)},_scrollComplete:function(){this._inBounds()&&(this._hideScrollbar(),this._correctLocation(),this._completeDeferred&&this._completeDeferred.resolve()),this._scrollToBounds()},_correctLocation:function(){this._location=o.round(this._location),this._move()},_scrollToBounds:function(){this._inBounds()||(this._bounceAction(),this._setupBounce(),this._bounceAnimator.start())},_setupBounce:function(){var n=this._bounceLocation=this._boundLocation(),t=n-this._location;this._velocity=t/st},_inBounds:function(n){return n=n!==i?n:this._location,n>=this._minOffset&&n<=this._maxOffset},_crossBoundOnNextStep:function(){var n=this._location,t=n+this._velocity;return n<this._minOffset&&t>=this._minOffset||n>this._maxOffset&&t<=this._maxOffset},_handleInit:function(t){return this._stopDeferred=n.Deferred(),this._stopScrolling(),this._prepareThumbScrolling(t),this._stopDeferred.promise()},_stopScrolling:function(){this._hideScrollbar(),this._inertiaAnimator.stop(),this._bounceAnimator.stop()},_prepareThumbScrolling:function(t){if(!l(t.originalEvent)){var i=n(t.originalEvent.target),r=this._isScrollbar(i);r&&this._moveToMouseLocation(t),this._thumbScrolling=r||this._isThumb(i),this._thumbScrolling&&this._scrollbar.feedbackOn()}},_moveToMouseLocation:function(n){var t=n["page"+this._axis.toUpperCase()]-this._$element.offset()[this._prop],i=this._location+t/this._containerToContentRatio()-this._$container.height()/2;this._scrollStep(-i)},_stopComplete:function(){this._stopDeferred&&this._stopDeferred.resolve()},_handleStart:function(){this._showScrollbar()},_handleMove:function(n){n=n[this._axis],this._thumbScrolling&&(n=-n/this._containerToContentRatio()),this._inBounds()||(n*=d),this._scrollStep(n)},_containerToContentRatio:function(){return this._scrollbar.containerToContentRatio()},_handleEnd:function(t){return this._completeDeferred=n.Deferred(),this._velocity=t[this._axis],this._handleInertia(),this._resetThumbScrolling(),this._completeDeferred.promise()},_handleInertia:function(){this._suppressIntertia(),this._inertiaAnimator.start()},_suppressIntertia:function(){(!this._inertiaEnabled||this._thumbScrolling)&&(this._velocity=0)},_resetThumbScrolling:function(){this._thumbScrolling=!1},_handleStop:function(){this._resetThumbScrolling(),this._scrollToBounds()},_handleDispose:function(){this._stopScrolling(),this._$scrollbar.remove()},_handleUpdate:function(){this._update(),this._moveToBounds()},_update:function(){this._stopScrolling(),this._updateLocation(),this._updateBounds(),this._updateScrollbar(),this._moveScrollbar(),this._updateScrollbarVisibility()},_updateLocation:function(){this._location=t.translator.locate(this._$content)[this._prop]},_updateBounds:function(){this._maxOffset=0,this._minOffset=o.min(this._containerSize()-this._contentSize(),0)},_updateScrollbar:function(){this._scrollbar.option({containerSize:this._containerSize(),contentSize:this._contentSize()})},_updateScrollbarVisibility:function(){this._showScrollbar(),this._hideScrollbar()},_moveToBounds:function(){this._location=this._boundLocation(),this._move()},_handleCreateActions:function(n){this._scrollAction=n.scrollAction,this._bounceAction=n.bounceAction},_showScrollbar:function(){this._scrollbar.option("visible",!0)},_hideScrollbar:function(){this._scrollbar.option("visible",!1)},_containerSize:function(){return this._$container[this._dimension]()},_contentSize:function(){return this._$content[this._dimension]()},_validateEvent:function(t){var i=n(t.originalEvent.target);return this._isThumb(i)||this._isScrollbar(i)?(t.preventDefault(),!0):this._isContent(i)},_isThumb:function(n){return this._scrollByThumb&&this._scrollbar.isThumb(n)},_isScrollbar:function(n){return this._scrollByThumb&&n&&n.is(this._$scrollbar)},_isContent:function(n){return this._scrollByContent&&!!n.closest(this._$element).length},_reachedMin:function(){return this._location<=this._minOffset},_reachedMax:function(){return this._location>=this._maxOffset},_handleCursorEnter:function(){this._scrollbar.cursorEnter()},_handleCursorLeave:function(){this._scrollbar.cursorLeave()}}),f,s;a.SimulatedScrollableStrategy=t.Class.inherit({ctor:function(n){this._init(n)},_init:function(t){this._component=t,this._$element=t._element(),this._$container=t._$container.prop("tabindex",0),this._$content=t._$content,this.option=n.proxy(t.option,t),this._createActionByOption=n.proxy(t._createActionByOption,t),this._isLocked=n.proxy(t._isLocked,t),this._isDirection=n.proxy(t._isDirection,t),this._allowedDirection=n.proxy(t._allowedDirection,t)},render:function(){this._$element.addClass(p),this._createScrollers(),this._attachKeyboardHandler(),this._attachCursorHandlers()},_createScrollers:function(){this._scrollers={},this._isDirection(r)&&this._createScroller(r),this._isDirection(u)&&this._createScroller(u),this._$element.toggleClass(rt,!this.option("showScrollbar"))},_createScroller:function(n){this._scrollers[n]=new ct(this._scrollerOptions(n))},_scrollerOptions:function(n){return{direction:n,$content:this._$content,$container:this._$container,$element:this._$element,scrollByContent:this.option("scrollByContent"),scrollByThumb:this.option("scrollByThumb"),scrollbarVisible:this.option("showScrollbar"),bounceEnabled:this.option("bounceEnabled"),inertiaEnabled:this.option("inertiaEnabled")}},handleInit:function(n){this._supressDirections(n),this._eventForUserAction=n,this._handleEvent("Init",n).done(this._stopAction)},_supressDirections:function(n){if(l(n.originalEvent)){this._prepareDirections(!0);return}this._prepareDirections(),this._eachScroller(function(t,i){var r=t._validateEvent(n);this._validDirections[i]=r})},_prepareDirections:function(n){n=n||!1,this._validDirections={},this._validDirections[r]=n,this._validDirections[u]=n},_eachScroller:function(t){t=n.proxy(t,this),n.each(this._scrollers,function(n,i){t(i,n)})},handleStart:function(){this._saveActive(),this._handleEvent("Start").done(this._startAction)},_saveActive:function(){s=this},_resetActive:function(){s=null},_validateDirection:function(n){var t=!1;return this._eachScroller(function(i){t=t||i._validateDirection(n)}),t},handleMove:function(n){if(this._isLocked()){n.cancel=!0,this._resetActive();return}n.preventDefault&&n.preventDefault(),this._adjustDistance(n.delta),this._eventForUserAction=n,this._handleEvent("Move",n.delta)},_adjustDistance:function(n){n.x*=this._validDirections[r],n.y*=this._validDirections[u]},handleEnd:function(n){return this._resetActive(),this._refreshCursorState(n.originalEvent&&n.originalEvent.target),this._adjustDistance(n.velocity),this._eventForUserAction=n,this._handleEvent("End",n.velocity).done(this._endAction)},handleCancel:function(n){return this._resetActive(),this._eventForUserAction=n,this._handleEvent("End",{x:0,y:0})},handleStop:function(){this._resetActive(),this._handleEvent("Stop")},handleScroll:function(){var n={left:this._$container.scrollLeft(),top:this._$container.scrollTop()};this._$container.scrollLeft(-n.left),this._$container.scrollTop(-n.top),this.scrollBy(n)},_attachKeyboardHandler:function(){if(this._$element.off("."+y),!this.option("disabled")&&this.option("useKeyboard"))this._$element.on(v.addNamespace("keydown",y),n.proxy(this._handleKeyDown,this))},_handleKeyDown:function(n){if(this._$container.is(document.activeElement)){var t=!0;switch(n.keyCode){case e.DOWN:this._scrollByLine({y:1});break;case e.UP:this._scrollByLine({y:-1});break;case e.RIGHT:this._scrollByLine({x:1});break;case e.LEFT:this._scrollByLine({x:-1});break;case e.PAGE_DOWN:this._scrollByPage(1);break;case e.PAGE_UP:this._scrollByPage(-1);break;case e.HOME:this._scrollToHome();break;case e.END:this._scrollToEnd();break;default:t=!1}t&&(n.stopPropagation(),n.preventDefault())}},_scrollByLine:function(n){this.scrollBy({top:(n.y||0)*-nt,left:(n.x||0)*-nt})},_scrollByPage:function(n){var t=this._wheelProp(),r=this._dimensionByProp(t),i={};i[t]=n*-this._$container[r](),this.scrollBy(i)},_dimensionByProp:function(n){return n==="left"?"width":"height"},_scrollToHome:function(){var t=this._wheelProp(),n={};n[t]=0,this._component.scrollTo(n)},_scrollToEnd:function(){var n=this._wheelProp(),t=this._dimensionByProp(n),i={};i[n]=this._$content[t]()-this._$container[t](),this._component.scrollTo(i)},createActions:function(){this._startAction=this._createActionHandler("startAction"),this._stopAction=this._createActionHandler("stopAction"),this._endAction=this._createActionHandler("endAction"),this._updateAction=this._createActionHandler("updateAction"),this._createScrollerActions()},_createScrollerActions:function(){this._handleEvent("CreateActions",{scrollAction:this._createActionHandler("scrollAction"),bounceAction:this._createActionHandler("bounceAction")})},_createActionHandler:function(t){var i=this,r=i._createActionByOption(t,{excludeValidators:["gesture"]});return function(){r(n.extend(i._createActionArgs(),arguments))}},_createActionArgs:function(){var n=this._scrollers[r],t=this._scrollers[u];return{jQueryEvent:this._eventForUserAction,scrollOffset:{top:t&&-t._location,left:n&&-n._location},reachedLeft:n&&n._reachedMax(),reachedRight:n&&n._reachedMin(),reachedTop:t&&t._reachedMax(),reachedBottom:t&&t._reachedMin()}},_handleEvent:function(t){var i=n.makeArray(arguments).slice(1),r=n.map(this._scrollers,function(n){return n["_handle"+t].apply(n,i)});return n.when.apply(n,r).promise()},location:function(){return t.translator.locate(this._$content)},disabledChanged:function(){this._attachCursorHandlers()},_attachCursorHandlers:function(){if(this._$element.off("."+h),!this.option("disabled")&&this._isHoverMode())this._$element.on(v.addNamespace("mouseenter",h),n.proxy(this._handleCursorEnter,this)).on(v.addNamespace("mouseleave",h),n.proxy(this._handleCursorLeave,this))},_isHoverMode:function(){return this.option("showScrollbar")==="onHover"},_handleCursorEnter:function(n){(n=n||{},n.originalEvent=n.originalEvent||{},s||n.originalEvent._hoverHandled)||(f&&f._handleCursorLeave(),f=this,this._handleEvent("CursorEnter"),n.originalEvent._hoverHandled=!0)},_handleCursorLeave:function(n){f===this&&s!==f&&(this._handleEvent("CursorLeave"),f=null,this._refreshCursorState(n&&n.relatedTarget))},_refreshCursorState:function(t){if(this._isHoverMode()||t&&!s){var u=n(t),r=u.closest("."+p+":not(.dx-state-disabled)"),i=r.length&&r.data(it);f&&f!==i&&f._handleCursorLeave(),i&&i._handleCursorEnter()}},update:function(){return this._handleEvent("Update").done(this._updateAction)},_allowedDirections:function(){var n=this.option("bounceEnabled");return{vertical:this._isDirection(u)&&(this._scrollers[u]._minOffset<0||n),horizontal:this._isDirection(r)&&(this._scrollers[r]._minOffset<0||n)}},scrollBy:function(n){this._prepareDirections(!0),this._handleEvent("Start").done(this._startAction),this._handleEvent("Move",{x:n.left,y:n.top}),this._handleEvent("End",{x:0,y:0}).done(this._endAction)},validate:function(n){return this.option("disabled")?!1:this.option("bounceEnabled")?!0:l(n)?this._validateWheel(n):this._validateMove()},_validateWheel:function(n){var r=this._scrollers[this._wheelDirection()],t=r._reachedMin(),i=r._reachedMax(),u=!t||!i,f=!t&&!i,e=t&&n.delta>0,o=i&&n.delta<0;return u&&(f||e||o)},_validateMove:function(){return this._allowedDirection()},getDirection:function(n){return l(n)?this._wheelDirection():this._allowedDirection()},_wheelProp:function(){return this._wheelDirection()===r?"left":"top"},_wheelDirection:function(){switch(this.option("direction")){case r:return r;case u:return u;default:return this._scrollers[u]._containerToContentRatio()>=1?r:u}},dispose:function(){s===this&&(s=null),f===this&&(f=null),this._handleEvent("Dispose"),this._detachEventHandlers(),this._$element.removeClass(p),this._eventForUserAction=null,clearTimeout(this._gestureEndTimer)},_detachEventHandlers:function(){this._$element.off("."+h),this._$container.off("."+y)}})}(jQuery,DevExpress),function(n,t,i){var f=t.ui,r="dx-scrollview",o=r+"-content",s=r+"-top-pocket",h=r+"-bottom-pocket",u=r+"-pull-down",v=u+"-image",y=u+"-indicator",p=u+"-text",e=r+"-scrollbottom",c=e+"-indicator",l=e+"-text",a=r+"-loadpanel";t.registerComponent("dxScrollView",f.dxScrollable.inherit({_setDefaultOptions:function(){this.callBase(),this.option({pullingDownText:Globalize.localize("dxScrollView-pullingDownText"),pulledDownText:Globalize.localize("dxScrollView-pulledDownText"),refreshingText:Globalize.localize("dxScrollView-refreshingText"),reachBottomText:Globalize.localize("dxScrollView-reachBottomText"),pullDownAction:null,reachBottomAction:null,refreshStrategy:"pullDown"})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){return DevExpress.devices.real().platform==="android"},options:{refreshStrategy:"swipeDown"}},{device:function(){return DevExpress.devices.real().platform==="win8"},options:{refreshStrategy:"slideDown"}}])},_init:function(){this.callBase(),this._loadingIndicatorEnabled=!0},_initMarkup:function(){this.callBase(),this._element().addClass(r),this._initContent(),this._initTopPocket(),this._initBottomPocket(),this._initLoadPanel()},_initContent:function(){var t=n("<div>").addClass(o);this._$content.wrapInner(t)},_initTopPocket:function(){var t=this._$topPocket=n("<div>").addClass(s),i=this._$pullDown=n("<div>").addClass(u);t.append(i),this._$content.prepend(t)},_initBottomPocket:function(){var t=this._$bottomPocket=n("<div>").addClass(h),i=this._$reachBottom=n("<div>").addClass(e),r=n("<div>").addClass(c),u=n("<div>").dxLoadIndicator(),f=this._$reachBottomText=n("<div>").addClass(l);this._updateReachBottomText(),i.append(r.append(u)).append(f),t.append(i),this._$content.append(t)},_initLoadPanel:function(){this._loadPanel=n("<div>").addClass(a).appendTo(this._element()).dxLoadPanel({shading:!1,delay:400,position:{of:this._element()}}).dxLoadPanel("instance")},_updateReachBottomText:function(){this._$reachBottomText.text(this.option("reachBottomText"))},_createStrategy:function(){var i=this.option("useNative")?this.option("refreshStrategy"):"simulated",t=f.scrollViewRefreshStrategies[i];if(!t)throw Error("Unknown dxScrollView refresh strategy "+this.option("refreshStrategy"));this._strategy=new t(this),this._strategy.pullDownCallbacks.add(n.proxy(this._handlePullDown,this)),this._strategy.releaseCallbacks.add(n.proxy(this._handleRelease,this)),this._strategy.reachBottomCallbacks.add(n.proxy(this._handleReachBottom,this))},_createActions:function(){this.callBase(),this._pullDownAction=this._createActionByOption("pullDownAction",{excludeValidators:["gesture"]}),this._reachBottomAction=this._createActionByOption("reachBottomAction",{excludeValidators:["gesture"]}),this._pullDownEnable(!!this.option("pullDownAction")&&!t.designMode),this._reachBottomEnable(!!this.option("reachBottomAction")&&!t.designMode)},_pullDownEnable:function(n){this._$pullDown.toggle(n),this._strategy.pullDownEnable(n)},_reachBottomEnable:function(n){this._$reachBottom.toggle(n),this._strategy.reachBottomEnable(n)},_handlePullDown:function(){this._loadingIndicator(!1),this._pullDownLoading()},_loadingIndicator:function(n){if(arguments.length<1)return this._loadingIndicatorEnabled;this._loadingIndicatorEnabled=n},_pullDownLoading:function(){this.startLoading(),this._pullDownAction()},_handleReachBottom:function(){this._loadingIndicator(!1),this._reachBottomLoading()},_reachBottomLoading:function(){this.startLoading(),this._reachBottomAction()},_handleRelease:function(){this.finishLoading(),this._loadingIndicator(!0)},_optionChanged:function(n){switch(n){case"pullDownAction":case"reachBottomAction":this._createActions();break;case"pullingDownText":case"pulledDownText":case"refreshingText":case"refreshStrategy":this._invalidate();break;case"reachBottomText":this._updateReachBottomText();break;default:this.callBase.apply(this,arguments)}},content:function(){return this._$content.children().eq(1)},release:function(n){return n!==i&&this.toggleLoading(!n),this._strategy.release()},toggleLoading:function(n){this._reachBottomEnable(n)},isFull:function(){return this.content().height()>=this._$container.height()},refresh:function(){this.option("pullDownAction")&&(this._strategy.pendingRelease(),this._pullDownLoading())},startLoading:function(){this._loadingIndicator()&&this._element().is(":visible")&&this._loadPanel.show(),this._lock()},finishLoading:function(){this._loadingIndicator()&&this._loadPanel.hide(),this._unlock()},_dispose:function(){this.callBase(),this._loadPanel&&this._loadPanel._element().remove()}})),f.scrollViewRefreshStrategies={}}(jQuery,DevExpress),function(n,t){var o=t.ui,y=Math,s="dx-scrollview-pull-down-loading",f="dx-scrollview-pull-down-ready",c="dx-scrollview-pull-down-image",l="dx-scrollview-pull-down-indicator",a="dx-scrollview-pull-down-text",e=0,r=1,u=2,h=3,v=o.NativeScrollableStrategy.inherit({_init:function(n){this.callBase(n),this._$topPocket=n._$topPocket,this._$pullDown=n._$pullDown,this._$bottomPocket=n._$bottomPocket,this._$refreshingText=n._$refreshingText,this._$scrollViewContent=n.content(),this._initCallbacks()},_initCallbacks:function(){this.pullDownCallbacks=n.Callbacks(),this.releaseCallbacks=n.Callbacks(),this.reachBottomCallbacks=n.Callbacks()},render:function(){this.callBase(),this._renderPullDown(),this._releaseState()},_renderPullDown:function(){var i=n("<div>").addClass(c),r=n("<div>").addClass(l),u=n("<div>").dxLoadIndicator(),t=this._$pullDownText=n("<div>").addClass(a);this._$pullingDownText=n("<div>").text(this.option("pullingDownText")).appendTo(t),this._$pulledDownText=n("<div>").text(this.option("pulledDownText")).appendTo(t),this._$refreshingText=n("<div>").text(this.option("refreshingText")).appendTo(t),this._$pullDown.empty().append(i).append(r.append(u)).append(t)},_releaseState:function(){this._state=e,this._refreshPullDownText()},_refreshPullDownText:function(){this._$pullingDownText.css("opacity",this._state===e?1:0),this._$pulledDownText.css("opacity",this._state===r?1:0),this._$refreshingText.css("opacity",this._state===u?1:0)},update:function(){this.callBase(),this._setTopPocketOffset()},_updateDimensions:function(){this.callBase(),this._topPocketSize=this._$topPocket.height(),this._bottomPocketSize=this._$bottomPocket.height(),this._scrollOffset=this._$container.height()-this._$content.height()},_allowedDirections:function(){var n=this.callBase();return n.vertical=n.vertical||this._pullDownEnabled,n},_setTopPocketOffset:function(){this._$topPocket.css({top:-this._topPocketSize})},handleEnd:function(){this._complete()},handleStop:function(){this._complete()},_complete:function(){this._state===r&&(this._setPullDownOffset(this._topPocketSize),clearTimeout(this._pullDownRefreshTimeout),this._pullDownRefreshTimeout=setTimeout(n.proxy(function(){this._pullDownRefreshing()},this),400))},_setPullDownOffset:function(n){t.translator.move(this._$topPocket,{top:n}),t.translator.move(this._$scrollViewContent,{top:n})},handleScroll:function(n){(this.callBase(n),this._state!==u)&&(this._location=this.location().top,this._isPullDown()?this._pullDownReady():this._isReachBottom()?this._reachBottom():this._stateReleased())},_isPullDown:function(){return this._pullDownEnabled&&this._location>=this._topPocketSize},_isReachBottom:function(){return this._reachBottomEnabled&&this._location<=this._scrollOffset+this._bottomPocketSize},_reachBottom:function(){this._state!==h&&(this._state=h,this.reachBottomCallbacks.fire())},_pullDownReady:function(){this._state!==r&&(this._state=r,this._$pullDown.addClass(f),this._refreshPullDownText())},_stateReleased:function(){this._state!==e&&(this._$pullDown.removeClass(s).removeClass(f),this._releaseState())},_pullDownRefreshing:function(){this._state!==u&&(this._state=u,this._$pullDown.addClass(s).removeClass(f),this._refreshPullDownText(),this.pullDownCallbacks.fire())},pullDownEnable:function(n){this._pullDownEnabled=n},reachBottomEnable:function(n){this._reachBottomEnabled=n},pendingRelease:function(){this._state=r},release:function(){var t=n.Deferred();return this._updateDimensions(),clearTimeout(this._releaseTimeout),this._releaseTimeout=setTimeout(n.proxy(function(){this._setPullDownOffset(0),this._stateReleased(),this.releaseCallbacks.fire(),this._updateAction(),t.resolve()},this),400),t.promise()},dispose:function(){clearTimeout(this._pullDownRefreshTimeout),clearTimeout(this._releaseTimeout),this.callBase()}});o.scrollViewRefreshStrategies.pullDown=v}(jQuery,DevExpress),function(n,t){var r=t.ui,s=r.events,h=Math,c="dx-scrollview-pull-down-loading",y="dx-scrollview-obsolete-android-browser",l=160,u=0,a=1,f=2,p=3,e=4,o=5,v=r.NativeScrollableStrategy.inherit({_init:function(n){this.callBase(n),this._$topPocket=n._$topPocket,this._$bottomPocket=n._$bottomPocket,this._$pullDown=n._$pullDown,this._$scrollViewContent=n.content(),this._initCallbacks(),this._releaseState(),this._location=0},_initCallbacks:function(){this.pullDownCallbacks=n.Callbacks(),this.releaseCallbacks=n.Callbacks(),this.reachBottomCallbacks=n.Callbacks()},render:function(){this.callBase(),this._renderPullDown()},_renderPullDown:function(){this._$pullDown.empty().append(n("<div class='dx-scrollview-pulldown-pointer1'>")).append(n("<div class='dx-scrollview-pulldown-pointer2'>")).append(n("<div class='dx-scrollview-pulldown-pointer3'>")).append(n("<div class='dx-scrollview-pulldown-pointer4'>"))},_releaseState:function(){this._state=u,this._$pullDown.css({width:"0%",opacity:0}),this._updateDimensions()},_updateDimensions:function(){this.callBase(),this._topPocketSize=this._$topPocket.height(),this._bottomPocketSize=this._$bottomPocket.height(),this._scrollOffset=this._$container.height()-this._$content.height()},_allowedDirections:function(){var n=this.callBase();return n.vertical=n.vertical||this._pullDownEnabled,n},handleInit:function(n){this.callBase(n),this._state===u&&this._location===0&&(this._startClientY=s.eventData(n.originalEvent).y,this._state=e)},handleMove:function(n){if(this.callBase(n),this._deltaY=s.eventData(n.originalEvent).y-this._startClientY,this._state===e&&(this._pullDownEnabled&&this._deltaY>0?(n.preventDefault(),this._state=o):this._complete()),this._state===o){if(this._deltaY<0){this._complete();return}this._$pullDown.css({opacity:1,width:h.min(h.abs(this._deltaY*100/l),100)+"%"}),this._isPullDown()&&this._pullDownRefreshing()}},_isPullDown:function(){return this._pullDownEnabled&&this._deltaY>=l},handleEnd:function(){this._complete()},handleStop:function(){this._complete()},_complete:function(){(this._state===e||this._state===o)&&this._releaseState()},handleScroll:function(n){if(this.callBase(n),this._state!==f){var t=this.location().top,i=this._location-t;this._location=t,i>0&&this._isReachBottom()?this._reachBottom():this._stateReleased()}},_isReachBottom:function(){return this._reachBottomEnabled&&this._location<=this._scrollOffset+this._bottomPocketSize},_reachBottom:function(){this.reachBottomCallbacks.fire()},_stateReleased:function(){this._state!==u&&(this._$pullDown.removeClass(c),this._releaseState())},_pullDownRefreshing:function(){this._state!==f&&(this._state=f,clearTimeout(this._pullDownRefreshTimeout),this._pullDownRefreshTimeout=setTimeout(n.proxy(function(){this._$pullDown.addClass(c),this.pullDownCallbacks.fire()},this),400))},pullDownEnable:function(n){this._$topPocket.toggle(n),this._pullDownEnabled=n},reachBottomEnable:function(n){this._reachBottomEnabled=n},pendingRelease:function(){this._state=a},release:function(){var t=n.Deferred();return this._updateDimensions(),clearTimeout(this._releaseTimeout),this._releaseTimeout=setTimeout(n.proxy(function(){this._stateReleased(),this.releaseCallbacks.fire(),this._updateAction(),t.resolve()},this),800),t.promise()},dispose:function(){clearTimeout(this._pullDownRefreshTimeout),clearTimeout(this._releaseTimeout),this.callBase()}});r.scrollViewRefreshStrategies.swipeDown=v}(jQuery,DevExpress),function(n,t){var u=t.ui,h="dxSlideDownNativeScrollViewStrategy",r=0,e=1,f=2,o=80,s=u.NativeScrollableStrategy.inherit({_init:function(n){this.callBase(n),this._$topPocket=n._$topPocket,this._$bottomPocket=n._$bottomPocket,this._initCallbacks()},_initCallbacks:function(){this.pullDownCallbacks=n.Callbacks(),this.releaseCallbacks=n.Callbacks(),this.reachBottomCallbacks=n.Callbacks()},render:function(){this.callBase(),this._renderPullDown(),this._renderBottom(),this._releaseState(),this._updateDimensions()},_renderPullDown:function(){this._$topPocket.empty()},_renderBottom:function(){this._$bottomPocket.empty().append("<progress>")},_releaseState:function(){this._state!==r&&(this._state=r)},_updateDimensions:function(){this._scrollOffset=this._$container.prop("scrollHeight")-this._$container.prop("clientHeight"),this._containerSize={height:this._$container.prop("clientHeight"),width:this._$container.prop("clientWidth")},this._contentSize=this._componentContentSize={height:this._$container.prop("scrollHeight"),width:this._$container.prop("scrollWidth")}},handleScroll:function(n){this.callBase(n),this._isReachBottom(this._lastLocation.top)&&this._reachBottom()},_isReachBottom:function(n){return this._scrollContent=this._$container.prop("scrollHeight")-this._$container.prop("clientHeight"),this._reachBottomEnabled&&n<-this._scrollContent+o},_reachBottom:function(){this._state!==f&&(this._state=f,this.reachBottomCallbacks.fire())},pullDownEnable:function(n){this._pullDownEnabled=n},reachBottomEnable:function(n){this._reachBottomEnabled=n,this._$bottomPocket.toggle(n)},pendingRelease:function(){this._state=e},release:function(){var t=n.Deferred();return this._state=r,this.releaseCallbacks.fire(),this.update(),t.resolve().promise()}});u.scrollViewRefreshStrategies.slideDown=s}(jQuery,DevExpress),function(n,t){var f=t.ui,h=Math,c="dx-scrollview-pull-down-loading",e="dx-scrollview-pull-down-ready",l="dx-scrollview-pull-down-image",a="dx-scrollview-pull-down-indicator",v="dx-scrollview-pull-down-text",r=0,u=1,o=2,s=3,y=f.ScrollViewScroller=f.Scroller.inherit({ctor:function(){this.callBase.apply(this,arguments),this._initCallbacks(),this._releaseState()},_releaseState:function(){this._state=r,this._refreshPullDownText()},_refreshPullDownText:function(){this._$pullingDownText.css("opacity",this._state===r?1:0),this._$pulledDownText.css("opacity",this._state===u?1:0),this._$refreshingText.css("opacity",this._state===o?1:0)},_initCallbacks:function(){this.pullDownCallbacks=n.Callbacks(),this.releaseCallbacks=n.Callbacks(),this.reachBottomCallbacks=n.Callbacks()},_updateBounds:function(){var n=this._direction!=="horizontal";this._topPocketSize=n?this._$topPocket[this._dimension]():0,this._bottomPocketSize=n?this._$bottomPocket[this._dimension]():0,this._updateOffsets()},_updateOffsets:function(){this._minOffset=h.min(this._containerSize()-this._contentSize()+this._bottomPocketSize,-this._topPocketSize),this._maxOffset=-this._topPocketSize,this._bottomBound=this._minOffset-this._bottomPocketSize},_updateScrollbar:function(){this._scrollbar.option({containerSize:this._containerSize(),contentSize:this._contentSize()-this._topPocketSize-this._bottomPocketSize})},_moveContent:function(){this.callBase(),this._isPullDown()?this._pullDownReady():this._isReachBottom()?this._reachBottomReady():this._state!==r&&this._stateReleased()},_moveScrollbar:function(){this._scrollbar.moveTo(this._topPocketSize+this._location)},_isPullDown:function(){return this._pullDownEnabled&&this._location>=0},_isReachBottom:function(){return this._reachBottomEnabled&&this._location<=this._bottomBound},_scrollComplete:function(){this._inBounds()&&this._state===u?this._pullDownRefreshing():this._inBounds()&&this._state===s?this._reachBottomLoading():this.callBase()},_reachBottomReady:function(){this._state!==s&&(this._state=s,this._minOffset=h.min(this._containerSize()-this._contentSize(),0))},_reachBottomLoading:function(){this.reachBottomCallbacks.fire()},_pullDownReady:function(){this._state!==u&&(this._state=u,this._maxOffset=0,this._$pullDown.addClass(e),this._refreshPullDownText())},_stateReleased:function(){this._state!==r&&(this._releaseState(),this._updateOffsets(),this._$pullDown.removeClass(c).removeClass(e),this.releaseCallbacks.fire())},_pullDownRefreshing:function(){this._state!==o&&(this._state=o,this._$pullDown.addClass(c).removeClass(e),this._refreshPullDownText(),this.pullDownCallbacks.fire())},_handleRelease:function(){return this._state===r&&this._moveToBounds(),this._update(),t.utils.executeAsync(n.proxy(this._release,this))},_release:function(){this._stateReleased(),this._scrollComplete()},_handleReachBottomEnabling:function(n){this._reachBottomEnabled!==n&&(this._reachBottomEnabled=n,this._updateBounds())},_handlePullDownEnabling:function(n){this._pullDownEnabled!==n&&(this._pullDownEnabled=n,this._considerTopPocketChange(),this._handleUpdate())},_considerTopPocketChange:function(){this._location-=this._$topPocket.height()||-this._topPocketSize,this._move()},_handlePendingRelease:function(){this._state=u}}),p=f.SimulatedScrollableStrategy.inherit({_init:function(n){this.callBase(n),this._$pullDown=n._$pullDown,this._$topPocket=n._$topPocket,this._$bottomPocket=n._$bottomPocket,this._initCallbacks()},_initCallbacks:function(){this.pullDownCallbacks=n.Callbacks(),this.releaseCallbacks=n.Callbacks(),this.reachBottomCallbacks=n.Callbacks()},render:function(){this._renderPullDown(),this.callBase()},_renderPullDown:function(){var i=n("<div>").addClass(l),r=n("<div>").addClass(a),u=n("<div>").dxLoadIndicator(),t=this._$pullDownText=n("<div>").addClass(v);this._$pullingDownText=n("<div>").text(this.option("pullingDownText")).appendTo(t),this._$pulledDownText=n("<div>").text(this.option("pulledDownText")).appendTo(t),this._$refreshingText=n("<div>").text(this.option("refreshingText")).appendTo(t),this._$pullDown.empty().append(i).append(r.append(u)).append(t)},pullDownEnable:function(n){this._handleEvent("PullDownEnabling",n)},reachBottomEnable:function(n){this._handleEvent("ReachBottomEnabling",n)},_createScroller:function(n){var t=this,i=t._scrollers[n]=new y(t._scrollerOptions(n));i.pullDownCallbacks.add(function(){t.pullDownCallbacks.fire()}),i.releaseCallbacks.add(function(){t.releaseCallbacks.fire()}),i.reachBottomCallbacks.add(function(){t.reachBottomCallbacks.fire()})},_scrollerOptions:function(t){return n.extend(this.callBase(t),{$topPocket:this._$topPocket,$bottomPocket:this._$bottomPocket,$pullDown:this._$pullDown,$pullDownText:this._$pullDownText,$pullingDownText:this._$pullingDownText,$pulledDownText:this._$pulledDownText,$refreshingText:this._$refreshingText})},pendingRelease:function(){this._handleEvent("PendingRelease")},release:function(){return this._handleEvent("Release").done(this._updateAction)}});f.scrollViewRefreshStrategies.simulated=p}(jQuery,DevExpress),function(n,t,i){var r=t.ui,o=r.events,f=t.utils,c=t.support.winJS,s=f.wrapToArray,u=f.removeDublicates,v=t.inflector.titleize,e;r.MapProvider=t.Class.inherit({_defaultRouteWeight:function(){return 5},_defaultRouteOpacity:function(){return.5},_defaultRouteColor:function(){return"#0000FF"},ctor:function(n,t){this._mapWidget=n,this._$container=t},load:n.noop,render:function(){var i=n.Deferred(),t=this;return this._renderImpl().done(function(){var r=t.addMarkers(t._option("markers")),u=t.addRoutes(t._option("routes"));n.when(r,u).done(function(){i.resolve(!0)})}),i.promise()},_renderImpl:t.abstract,updateDimensions:t.abstract,updateMapType:t.abstract,updateCenter:t.abstract,updateZoom:t.abstract,updateControls:t.abstract,updateMarkers:function(t,i){var r=n.Deferred(),u=this;return this.removeMarkers(t).done(function(){u.addMarkers(i).done(function(){r.resolve.apply(r,arguments)})}),r.promise()},addMarkers:t.abstract,removeMarkers:t.abstract,adjustViewport:t.abstract,updateRoutes:function(t,i){var r=n.Deferred(),u=this;return this.removeRoutes(t).done(function(){u.addRoutes(i).done(function(){r.resolve.apply(r,arguments)})}),r.promise()},addRoutes:t.abstract,removeRoutes:t.abstract,clean:t.abstract,cancelEvents:!1,map:function(){return this._map},mapRendered:function(){return!!this._map},_option:function(n,t){if(t===i)return this._mapWidget.option(n);this._mapWidget.setOptionSilent(n,t)},_keyOption:function(n){var t=this._option("key");return t[n]===i?t:t[n]},_parseTooltipOptions:function(n){return{text:n.text||n,visible:n.isShown||!1}},_addEventNamespace:function(n){return o.addNamespace(n,this._mapWidget.NAME)},_createAction:function(){var n=this._mapWidget;return n._createAction.apply(n,arguments)},_fireAction:function(n,t){var i=this._option(n);i&&this._createAction(i)(t)},_fireClickAction:function(n){this._fireAction("clickAction",n)},_fireMarkerAddedAction:function(n){this._fireAction("markerAddedAction",n)},_fireMarkerRemovedAction:function(n){this._fireAction("markerRemovedAction",n)},_fireRouteAddedAction:function(n){this._fireAction("routeAddedAction",n)},_fireRouteRemovedAction:function(n){this._fireAction("routeRemovedAction",n)}}),e={},r.registerMapProvider=function(n,t){e[n]=t};var l="dx-map",a="dx-map-container",h="dx-map-shield";t.registerComponent("dxMap",r.Widget.inherit({ctor:function(){this.callBase.apply(this,arguments),this.addMarker=n.proxy(this._addFunction,this,"markers"),this.removeMarker=n.proxy(this._removeFunction,this,"markers"),this.addRoute=n.proxy(this._addFunction,this,"routes"),this.removeRoute=n.proxy(this._removeFunction,this,"routes")},_addFunction:function(t,i){var u=n.Deferred(),e=this,f=n.Deferred(),r=this.option(t),o=s(i);return r.push.apply(r,o),this._notificationDeffered=f,this.option(t,r),f.done(function(n){u.resolveWith(e,n&&n.length>1?[n]:n)}),u.promise()},_removeFunction:function(t,i){var u=n.Deferred(),e=this,f=n.Deferred(),r=this.option(t),o=s(i);return n.each(o,function(t,i){var u=n.isNumeric(i)?i:n.inArray(i,r);u!==-1&&r.splice(u,1)}),this._notificationDeffered=f,this.option(t,r),f.done(function(){u.resolveWith(e)}),u.promise()},_deprecatedOptions:{location:{since:"14.1",message:"Use the 'center' option instead."}},_optionAliases:{center:"location"},_setDefaultOptions:function(){this.callBase(),this.option({center:{lat:0,lng:0},location:{lat:0,lng:0},width:300,height:300,zoom:1,type:"roadmap",provider:"google",autoAdjust:!0,markers:[],markerIconSrc:null,markerAddedAction:null,markerRemovedAction:null,routes:[],routeAddedAction:null,routeRemovedAction:null,key:{bing:"",google:"",googleStatic:""},controls:!1,readyAction:null,updateAction:null,clickAction:null})},_init:function(){this._checkMarkersOption(this.option("markers")),this._checkRoutesOption(this.option("routes")),this.callBase(),this._initContainer(),this._grabEvents(),this._initProvider(),this._cleanRenderedMarkers(),this._cleanRenderedRoutes()},_cleanRenderedMarkers:function(){this._renderedMarkers=[]},_cleanRenderedRoutes:function(){this._renderedRoutes=[]},_checkMarkersOption:function(t){if(!n.isArray(t))throw new Error("Markers option should be an array");},_checkRoutesOption:function(t){if(!n.isArray(t))throw new Error("Routes option should be an array");},_visibilityChanged:function(n){n&&this._dimensionChanged()},_dimensionChanged:function(){this._execAsyncProviderAction("updateDimensions")},_initContainer:function(){this._$container=n("<div />").addClass(a),this._element().append(this._$container)},_grabEvents:function(){var t=o.addNamespace("dxpointerdown",this.NAME);this._element().on(t,n.proxy(this._cancelEvent,this))},_cancelEvent:function(n){var i=this._provider.cancelEvents&&!this.option("disabled");!t.designMode&&i&&n.stopPropagation()},_initProvider:function(){var n=this.option("provider");if(c&&this.option("provider")==="google")throw new Error("Google provider cannot be used in winJS application");this._cleanProvider(),this._provider=new e[n](this,this._$container),this._mapLoader=this._provider.load()},_render:function(){this.callBase(),this._element().addClass(l),this._renderShield(),this._execAsyncProviderAction("render").done(n.proxy(function(){this._saveRenderedMarkers(),this._saveRenderedRoutes()},this))},_saveRenderedMarkers:function(n){n=n||this.option("markers"),this._renderedMarkers=n.slice()},_saveRenderedRoutes:function(n){n=n||this.option("routes"),this._renderedRoutes=n.slice()},_renderShield:function(){var i;t.designMode||this.option("disabled")?(i=n("<div/>").addClass(h),this._element().append(i)):(i=this._element().find("."+h),i.remove())},_clean:function(){this._cleanProvider(),this._cleanRenderedMarkers(),this._cleanRenderedRoutes()},_cleanProvider:function(){this._provider&&this._provider.clean()},_optionChanged:function(t,i,r){if(!this._cancelOptionChange){var e=this._notificationDeffered;delete this._notificationDeffered;switch(t){case"disabled":this._renderShield(),this.callBase.apply(this,arguments);break;case"width":case"height":this.callBase.apply(this,arguments),this._dimensionChanged();break;case"type":this._execAsyncProviderAction("updateMapType");break;case"center":this._execAsyncProviderAction("updateCenter");break;case"zoom":this._execAsyncProviderAction("updateZoom");break;case"controls":this._execAsyncProviderAction("updateControls");break;case"markers":this._checkMarkersOption(i),this._execAsyncProviderAction("updateMarkers",n.proxy(function(){return e?u(this._renderedMarkers,i):this._renderedMarkers},this),n.proxy(function(){return e?u(i,this._renderedMarkers):i},this)).done(n.proxy(function(){this._saveRenderedMarkers(i),e&&e.resolve.apply(e,arguments)},this));break;case"markerIconSrc":this._execAsyncProviderAction("updateMarkers",r,i);break;case"autoAdjust":this._execAsyncProviderAction("adjustViewport");break;case"routes":this._checkRoutesOption(i),this._execAsyncProviderAction("updateRoutes",n.proxy(function(){return e?u(this._renderedRoutes,i):this._renderedRoutes},this),n.proxy(function(){return e?u(i,this._renderedRoutes):i},this)).done(n.proxy(function(){this._saveRenderedRoutes(i),e&&e.resolve.apply(e,arguments)},this));break;case"key":f.logger.warn("Key option can not be modified after initialization");case"provider":this._initProvider(),this._invalidate();break;case"readyAction":case"updateAction":case"markerAddedAction":case"markerRemovedAction":case"routeAddedAction":case"routeRemovedAction":case"clickAction":break;default:this.callBase.apply(this,arguments)}}},_execAsyncProviderAction:function(t){if(!this._provider.mapRendered()&&!(t==="render"))return n.when(i).promise();var r=n.Deferred(),f=this,u=n.makeArray(arguments).slice(1);return n.when(this._mapLoader).done(function(){var i=f._provider;n.each(u,function(t,i){n.isFunction(i)&&(u[t]=i())}),i[t].apply(i,u).done(function(t){r.resolve.apply(r,n.makeArray(arguments).slice(1)),t&&f._triggerReadyAction()})}),r.promise()},_triggerReadyAction:function(){this._createActionByOption("readyAction")({originalMap:this._provider.map()})},_triggerUpdateAction:function(){this._createActionByOption("updateAction")()},setOptionSilent:function(n,t){this._cancelOptionChange=!0,this.option(n,t),this._cancelOptionChange=!1}}))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,o=t.support.winJS,r="_bingScriptReady",s="https://ecn.dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=7.0&s=1&onScriptLoad="+r,h="ms-appx:///Bing.Maps.JavaScript/js/veapicore.js",c="ms-appx:///Bing.Maps.JavaScript/js/veapiModules.js",l="AhuxC0dQ1DBTNo8L-H9ToVMQStmizZzBJdraTSgCzDSWPsA1Qd8uIvFSflzxdaLH",e=1e-16,u;f.registerMapProvider("bing",f.MapProvider.inherit({_mapType:function(n){var t={roadmap:Microsoft.Maps.MapTypeId.road,hybrid:Microsoft.Maps.MapTypeId.aerial};return t[n]||t.roadmap},_movementMode:function(n){var t={driving:Microsoft.Maps.Directions.RouteMode.driving,walking:Microsoft.Maps.Directions.RouteMode.walking};return t[n]||t.driving},_resolveLocation:function(t){var i=n.Deferred(),r,u;return typeof t=="string"?(r=new Microsoft.Maps.Search.SearchManager(this._map),u={where:t,count:1,callback:function(n){var t=n.results[0].location;i.resolve(new Microsoft.Maps.Location(t.latitude,t.longitude))}},r.geocode(u)):n.isPlainObject(t)&&n.isNumeric(t.lat)&&n.isNumeric(t.lng)?i.resolve(new Microsoft.Maps.Location(t.lat,t.lng)):n.isArray(t)&&i.resolve(new Microsoft.Maps.Location(t[0],t[1])),i.promise()},_normalizeLocation:function(n){return{lat:n.latitude,lng:n.longitude}},load:function(){return u||(u=n.Deferred(),window[r]=n.proxy(this._mapReady,this),o?n.when(n.getScript(h),n.getScript(c)).done(function(){Microsoft.Maps.loadModule("Microsoft.Maps.Map",{callback:window[r]})}):n.getScript(s)),this._markers=[],this._routes=[],u},_mapReady:function(){try{delete window[r]}catch(e){window[r]=i}var t=n.Deferred(),f=n.Deferred();Microsoft.Maps.loadModule("Microsoft.Maps.Search",{callback:n.proxy(t.resolve,t)}),Microsoft.Maps.loadModule("Microsoft.Maps.Directions",{callback:n.proxy(f.resolve,f)}),n.when(t,f).done(function(){u.resolve()})},_renderImpl:function(){var r=n.Deferred(),t=n.Deferred(),i=this._option("controls"),e={credentials:this._keyOption("bing")||l,mapTypeId:this._mapType(this._option("type")),zoom:this._option("zoom"),showDashboard:i,showMapTypeSelector:i,showScalebar:i},u,f;return this._map=new Microsoft.Maps.Map(this._$container[0],e),u=Microsoft.Maps.Events.addHandler(this._map,"tiledownloadcomplete",n.proxy(t.resolve,t)),this._viewChangeHandler=Microsoft.Maps.Events.addHandler(this._map,"viewchange",n.proxy(this._handleViewChange,this)),this._clickHandler=Microsoft.Maps.Events.addHandler(this._map,"click",n.proxy(this._handleClickAction,this)),f=this._renderCenter(),n.when(t,f).done(function(){Microsoft.Maps.Events.removeHandler(u),r.resolve()}),r.promise()},_handleViewChange:function(){var n=this._map.getCenter();this._option("center",this._normalizeLocation(n)),this._preventZoomChangeEvent||this._option("zoom",this._map.getZoom())},updateDimensions:function(){return this._map.setOptions({width:this._$container.width(),height:this._$container.height()}),n.Deferred().resolve().promise()},updateMapType:function(){return this._map.setView({mapTypeId:this._mapType(this._option("type"))}),n.Deferred().resolve().promise()},updateCenter:function(){return this._renderCenter()},_renderCenter:function(){var t=n.Deferred(),i=this;return this._resolveLocation(this._option("center")).done(function(n){i._map.setView({animate:!1,center:n}),t.resolve()}),t.promise()},updateZoom:function(){return this._map.setView({animate:!1,zoom:this._option("zoom")}),n.Deferred().resolve().promise()},updateControls:function(){return this.clean(),this.render()},addMarkers:function(t){var i=n.Deferred(),r=this,u=n.map(t,function(n){return r._addMarker(n)});return n.when.apply(n,u).done(function(){var t=n.map(n.makeArray(arguments),function(n){return n.pushpin});i.resolve(!1,t)}),i.promise()},_addMarker:function(t){var i=this;return this._renderMarker(t).done(function(r){i._markers.push(n.extend({options:t},r)),i._updateMarkersBounds(),i._fitBounds(),i._fireMarkerAddedAction({options:t,originalMarker:r.pushpin})})},_renderMarker:function(t){var r=n.Deferred(),i=this;return this._resolveLocation(t.location).done(function(u){var e=new Microsoft.Maps.Pushpin(u,{icon:t.iconSrc||i._option("markerIconSrc")}),f,o,s,h;i._map.entities.push(e),f=i._renderTooltip(u,t.tooltip),(t.clickAction||t.tooltip)&&(s=i._createAction(t.clickAction||n.noop),h=i._normalizeLocation(u),o=Microsoft.Maps.Events.addHandler(e,"click",function(){s({location:h}),f&&f.setOptions({visible:!0})})),r.resolve({location:u,pushpin:e,infobox:f,handler:o})}),r.promise()},_renderTooltip:function(n,t){if(t){t=this._parseTooltipOptions(t);var i=new Microsoft.Maps.Infobox(n,{description:t.text,offset:new Microsoft.Maps.Point(0,33),visible:t.visible});return this._map.entities.push(i,null),i}},removeMarkers:function(t){var i=this;return n.each(t,function(n,t){i._removeMarker(t)}),n.Deferred().resolve().promise()},_removeMarker:function(t){var i=this;n.each(this._markers,function(n,r){if(r.options!==t)return!0;var u=i._markers[n];return i._map.entities.remove(u.pushpin),u.infobox&&i._map.entities.remove(u.infobox),u.handler&&Microsoft.Maps.Events.removeHandler(u.handler),i._markers.splice(n,1),i._updateMarkersBounds(),i._fitBounds(),i._fireMarkerRemovedAction({options:t}),!1})},_updateMarkersBounds:function(){var t=this;this._clearBounds(),n.each(this._markers,function(n,i){t._extendBounds(i.location)})},_clearMarkers:function(){for(var n=0;this._markers.length>0;)this._removeMarker(this._markers[0].options)},adjustViewport:function(){return this._fitBounds()},_clearBounds:function(){this._bounds=null},_extendBounds:function(n){this._bounds=this._bounds?new Microsoft.Maps.LocationRect.fromLocations(this._bounds.getNorthwest(),this._bounds.getSoutheast(),n):new Microsoft.Maps.LocationRect(n,e,e)},_fitBounds:function(){var u=this._option("autoAdjust"),i,t,r;return this._bounds&&u&&(i=this._map.getZoom(),this._preventZoomChangeEvent=!0,t=this._bounds.clone(),t.height=t.height*1.1,t.width=t.width*1.1,this._map.setView({animate:!1,bounds:t}),r=this._map.getZoom(),i<r?this._map.setView({animate:!1,zoom:i}):this._option("zoom",r),delete this._preventZoomChangeEvent),n.Deferred().resolve().promise()},addRoutes:function(t){var i=n.Deferred(),r=this,u=n.map(t,function(n){return r._addRoute(n)});return n.when.apply(n,u).done(function(){i.resolve(!1,n.makeArray(arguments))}),i.promise()},_addRoute:function(n){var t=this;return this._renderRoute(n).done(function(i){t._routes.push({options:n,instance:i}),t._fireRouteAddedAction({options:n,originalRoute:i})})},_renderRoute:function(i){var u=n.Deferred(),r=this,f=n.map(i.locations,function(n){return r._resolveLocation(n)});return n.when.apply(n,f).done(function(){var s=n.makeArray(arguments),f=new Microsoft.Maps.Directions.DirectionsManager(r._map),h=new t.Color(i.color||r._defaultRouteColor()).toHex(),e=new Microsoft.Maps.Color.fromHex(h),o;e.a=(i.opacity||r._defaultRouteOpacity())*255,f.setRenderOptions({autoUpdateMapView:!1,displayRouteSelector:!1,waypointPushpinOptions:{visible:!1},drivingPolylineOptions:{strokeColor:e,strokeThickness:i.weight||r._defaultRouteWeight()},walkingPolylineOptions:{strokeColor:e,strokeThickness:i.weight||r._defaultRouteWeight()}}),f.setRequestOptions({routeMode:r._movementMode(i.mode),routeDraggable:!1}),n.each(s,function(n,t){var i=new Microsoft.Maps.Directions.Waypoint({location:t});f.addWaypoint(i)}),o=Microsoft.Maps.Events.addHandler(f,"directionsUpdated",function(){Microsoft.Maps.Events.removeHandler(o),u.resolve(f)}),f.calculateDirections()}),u.promise()},removeRoutes:function(t){var i=this;return n.each(t,function(n,t){i._removeRoute(t)}),n.Deferred().resolve().promise()},_removeRoute:function(t){var i=this;n.each(this._routes,function(n,r){return r.options!==t?!0:(i._routes[n].instance.dispose(),i._routes.splice(n,1),i._fireRouteRemovedAction({options:t}),!1)})},_clearRoutes:function(){for(var n=0;this._routes.length>0;)this._removeRoute(this._routes[0].options)},_handleClickAction:function(n){if(n.targetType=="map"){var t=new Microsoft.Maps.Point(n.getX(),n.getY()),i=n.target.tryPixelToLocation(t);this._fireClickAction({location:this._normalizeLocation(i)})}},clean:function(){this._map&&(Microsoft.Maps.Events.removeHandler(this._viewChangeHandler),Microsoft.Maps.Events.removeHandler(this._clickHandler),this._clearMarkers(),this._clearRoutes(),this._map.dispose())},cancelEvents:!0}))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,r="_googleScriptReady",e="https://maps.google.com/maps/api/js?v=3.9&sensor=false&callback="+r,u;f.registerMapProvider("google",f.MapProvider.inherit({_mapType:function(n){var t={hybrid:google.maps.MapTypeId.HYBRID,roadmap:google.maps.MapTypeId.ROADMAP};return t[n]||t.hybrid},_movementMode:function(n){var t={driving:google.maps.TravelMode.DRIVING,walking:google.maps.TravelMode.WALKING};return t[n]||t.driving},_resolveLocation:function(t){var i=n.Deferred(),r;return typeof t=="string"?(r=new google.maps.Geocoder,r.geocode({address:t},function(n,t){t===google.maps.GeocoderStatus.OK&&i.resolve(n[0].geometry.location)})):n.isArray(t)?i.resolve(new google.maps.LatLng(t[0],t[1])):n.isPlainObject(t)&&n.isNumeric(t.lat)&&n.isNumeric(t.lng)&&i.resolve(new google.maps.LatLng(t.lat,t.lng)),i.promise()},_normalizeLocation:function(n){return{lat:n.lat(),lng:n.lng()}},load:function(){if(!u){u=n.Deferred();var t=this._keyOption("google");window[r]=n.proxy(this._mapReady,this),n.getScript(e+(t?"&key="+t:""))}return this._markers=[],this._routes=[],u.promise()},_mapReady:function(){try{delete window[r]}catch(n){window[r]=i}u.resolve()},_renderImpl:function(){var r=n.Deferred(),i=n.Deferred(),t=this._option("controls"),e={zoom:this._option("zoom"),center:new google.maps.LatLng(0,0),mapTypeId:this._mapType(this._option("type")),panControl:t,zoomControl:t,mapTypeControl:t,streetViewControl:t},u,f;return this._map=new google.maps.Map(this._$container[0],e),u=google.maps.event.addListener(this._map,"idle",n.proxy(i.resolve,i)),this._zoomChangeListener=google.maps.event.addListener(this._map,"zoom_changed",n.proxy(this._handleZoomChange,this)),this._centerChangeListener=google.maps.event.addListener(this._map,"center_changed",n.proxy(this._handleCenterChange,this)),this._clickListener=google.maps.event.addListener(this._map,"click",n.proxy(this._handleClickAction,this)),f=this._renderCenter(),n.when(i,f).done(function(){google.maps.event.removeListener(u),r.resolve()}),r.promise()},updateDimensions:function(){return google.maps.event.trigger(this._map,"resize"),n.Deferred().resolve().promise()},updateMapType:function(){return this._map.setMapTypeId(this._mapType(this._option("type"))),n.Deferred().resolve().promise()},updateCenter:function(){return this._renderCenter()},_handleCenterChange:function(){var n=this._map.getCenter();this._option("center",this._normalizeLocation(n))},_renderCenter:function(){var t=n.Deferred(),i=this;return this._resolveLocation(this._option("center")).done(function(n){i._map.setCenter(n),t.resolve()}),t.promise()},_handleZoomChange:function(){this._preventZoomChangeEvent||this._option("zoom",this._map.getZoom())},updateZoom:function(){return this._map.setZoom(this._option("zoom")),n.Deferred().resolve().promise()},updateControls:function(){var t=this._option("controls");return this._map.setOptions({panControl:t,zoomControl:t,mapTypeControl:t,streetViewControl:t}),n.Deferred().resolve().promise()},addMarkers:function(t){var i=n.Deferred(),r=this,u=n.map(t,function(n){return r._addMarker(n)});return n.when.apply(n,u).done(function(){var t=n.map(n.makeArray(arguments),function(n){return n.marker});i.resolve(!1,t)}),i.promise()},_addMarker:function(t){var i=this;return this._renderMarker(t).done(function(r){i._markers.push(n.extend({options:t},r)),i._updateMarkersBounds(),i._fitBounds(),i._fireMarkerAddedAction({options:t,originalMarker:r.marker})})},_renderMarker:function(t){var r=n.Deferred(),i=this;return this._resolveLocation(t.location).done(function(u){var f=new google.maps.Marker({position:u,map:i._map,icon:t.iconSrc||i._option("markerIconSrc")}),e,o=i._renderTooltip(f,t.tooltip),s,h;(t.clickAction||t.tooltip)&&(s=i._createAction(t.clickAction||n.noop),h=i._normalizeLocation(u),e=google.maps.event.addListener(f,"click",function(){s({location:h}),o&&o.open(i._map,f)})),r.resolve({location:u,marker:f,listner:e})}),r.promise()},_renderTooltip:function(n,t){if(t){t=this._parseTooltipOptions(t);var i=new google.maps.InfoWindow({content:t.text});return t.visible&&i.open(this._map,n),i}},removeMarkers:function(t){var i=this;return n.each(t,function(n,t){i._removeMarker(t)}),n.Deferred().resolve().promise()},_removeMarker:function(t){var i=this;n.each(this._markers,function(n,r){if(r.options!==t)return!0;var u=i._markers[n];return u.marker.setMap(null),u.listner&&google.maps.event.removeListener(u.listner),i._markers.splice(n,1),i._updateMarkersBounds(),i._fitBounds(),i._fireMarkerRemovedAction({options:r.options}),!1})},_updateMarkersBounds:function(){var t=this;this._clearBounds(),n.each(this._markers,function(n,i){t._extendBounds(i.location)})},_clearMarkers:function(){for(var n=0;this._markers.length>0;)this._removeMarker(this._markers[0].options)},adjustViewport:function(){return this._fitBounds()},_extendBounds:function(n){this._bounds?this._bounds.extend(n):(this._bounds=new google.maps.LatLngBounds,this._bounds.extend(n))},_fitBounds:function(){var r=this._option("autoAdjust"),t,i;return this._bounds&&r&&(t=this._map.getZoom(),this._preventZoomChangeEvent=!0,this._map.fitBounds(this._bounds),i=this._map.getZoom(),t<i?this._map.setZoom(t):this._option("zoom",i),delete this._preventZoomChangeEvent),n.Deferred().resolve().promise()},_clearBounds:function(){this._bounds=null},addRoutes:function(t){var i=n.Deferred(),r=this,u=n.map(t,function(n){return r._addRoute(n)});return n.when.apply(n,u).done(function(){i.resolve(!1,n.makeArray(arguments))}),i.promise()},_addRoute:function(n){var t=this;return this._renderRoute(n).done(function(i){t._routes.push({options:n,instance:i}),t._fireRouteAddedAction({options:n,originalRoute:i})})},_renderRoute:function(i){var u=n.Deferred(),r=this,f=new google.maps.DirectionsService,e=n.map(i.locations,function(n){return r._resolveLocation(n)});return n.when.apply(n,e).done(function(){var e=n.makeArray(arguments),o=e.shift(),s=e.pop(),h=n.map(e,function(n){return{location:n,stopover:!0}}),c={origin:o,destination:s,waypoints:h,optimizeWaypoints:!0,travelMode:r._movementMode(i.mode)};f.route(c,function(n,f){if(f===google.maps.DirectionsStatus.OK){var e=new t.Color(i.color||r._defaultRouteColor()).toHex(),o={directions:n,map:r._map,suppressMarkers:!0,preserveViewport:!0,polylineOptions:{strokeWeight:i.weight||r._defaultRouteWeight(),strokeOpacity:i.opacity||r._defaultRouteOpacity(),strokeColor:e}},s=new google.maps.DirectionsRenderer(o);u.resolve(s)}})}),u.promise()},removeRoutes:function(t){var i=this;return n.each(t,function(n,t){i._removeRoute(t)}),n.Deferred().resolve().promise()},_removeRoute:function(t){var i=this;n.each(this._routes,function(n,r){return r.options!==t?!0:(i._routes[n].instance.setMap(null),i._routes.splice(n,1),i._fireRouteRemovedAction({options:t}),!1)})},_clearRoutes:function(){for(var n=0;this._routes.length>0;)this._removeRoute(this._routes[0].options)},_handleClickAction:function(n){this._fireClickAction({location:this._normalizeLocation(n.latLng)})},clean:function(){this._map&&(google.maps.event.removeListener(this._zoomChangeListener),google.maps.event.removeListener(this._centerChangeListener),google.maps.event.removeListener(this._clickListener),this._clearMarkers(),this._clearRoutes(),delete this._map,this._$container.empty())},cancelEvents:!0}))}(jQuery,DevExpress),function(n,t){var r=t.ui,u="https://maps.google.com/maps/api/staticmap?";r.registerMapProvider("googleStatic",r.MapProvider.inherit({_locationToString:function(t){return n.isPlainObject(t)?t.lat+","+t.lng:t.toString().replace(/ /g,"+")},_renderImpl:function(){return this._updateMap()},updateDimensions:function(){return this._updateMap()},updateMapType:function(){return this._updateMap()},updateCenter:function(){return this._updateMap()},updateZoom:function(){return this._updateMap()},updateControls:function(){return n.Deferred().resolve().promise()},addMarkers:function(t){var i=this;return this._updateMap().done(function(){n.each(t,function(n,t){i._fireMarkerAddedAction({options:t})})})},removeMarkers:function(t){var i=this;return this._updateMap().done(function(){n.each(t,function(n,t){i._fireMarkerRemovedAction({options:t})})})},adjustViewport:function(){return n.Deferred().resolve().promise()},addRoutes:function(t){var i=this;return this._updateMap().done(function(){n.each(t,function(n,t){i._fireRouteAddedAction({options:t})})})},removeRoutes:function(t){var i=this;return this._updateMap().done(function(){n.each(t,function(n,t){i._fireRouteRemovedAction({options:t})})})},clean:function(){this._$container.css("background-image","none"),this._$container.off(this._addEventNamespace("dxclick"))},mapRendered:function(){return!0},_updateMap:function(){var i=this._keyOption("googleStatic"),t=["sensor=false","size="+this._option("width")+"x"+this._option("height"),"maptype="+this._option("type"),"center="+this._locationToString(this._option("center")),"zoom="+this._option("zoom"),this._markersSubstring()],r;return t.push.apply(t,this._routeSubstrings()),i&&t.push("key="+i),r=u+t.join("&"),this._$container.css("background",'url("'+r+'") no-repeat 0 0'),this._attachClickEvent(),n.Deferred().resolve(!0).promise()},_markersSubstring:function(){var r=this,t=[],i=this._option("markerIconSrc");return i&&t.push("icon:"+i),n.each(this._option("markers"),function(n,i){t.push(r._locationToString(i.location))}),"markers="+t.join("|")},_routeSubstrings:function(){var i=this,r=[];return n.each(this._option("routes"),function(u,f){var o=new t.Color(f.color||i._defaultRouteColor()).toHex().replace("#","0x"),s=Math.round((f.opacity||i._defaultRouteOpacity())*255).toString(16),h=f.weight||i._defaultRouteWeight(),e=[];n.each(f.locations,function(n,t){e.push(i._locationToString(t))}),r.push("path=color:"+o+s+"|weight:"+h+"|"+e.join("|"))}),r},_attachClickEvent:function(){var t=this,n=this._addEventNamespace("dxclick");this._$container.off(n).on(n,function(n){t._fireClickAction({jQueryEvent:n})})}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,f=r.events,u="dxSwipeable",e="dx-swipeable",o={startAction:"dxswipestart",updateAction:"dxswipe",endAction:"dxswipeend",cancelAction:"dxswipecancel"};t.registerComponent(u,t.DOMComponent.inherit({NAMESPACE:r,_setDefaultOptions:function(){this.callBase(),this.option({elastic:!0,direction:"horizontal",itemSizeFunc:null,startAction:null,updateAction:null,endAction:null,cancelAction:null})},_render:function(){this.callBase(),this._element().addClass(e),this._attachEventHandlers()},_attachEventHandlers:function(){if(this._detachEventHanlers(),!this.option("disabled")){var t=this.NAME;this._createEventData(),n.each(o,n.proxy(function(n,i){var r=this._createActionByOption(n,{context:this,excludeValidators:["gesture"]});i=f.addNamespace(i,t);this._element().on(i,this._eventData,function(n){return r({jQueryEvent:n})})},this))}},_createEventData:function(){this._eventData={elastic:this.option("elastic"),itemSizeFunc:this.option("itemSizeFunc"),direction:this.option("direction")}},_detachEventHanlers:function(){this._element().off("."+u)},_optionChanged:function(n){switch(n){case"disabled":case"startAction":case"updateAction":case"endAction":case"cancelAction":case"elastic":case"itemSizeFunc":case"direction":this._detachEventHanlers(),this._attachEventHandlers();break;case"rtlEnabled":break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,f=r.events,e="dx-button",o="dx-button-content",u=".dx-button-content",s="dx-button-text",h="dx-button-has-text",c="dx-button-has-icon",l=".dx-button-text",a="dx-button-back-arrow",v="dx-icon",y=".dx-icon",p=100;t.registerComponent("dxButton",r.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({clickAction:null,type:"normal",text:"",icon:"",iconSrc:"",hoverStateEnabled:!0})},_init:function(){this.callBase(),this._feedbackHideTimeout=p},_render:function(){this.callBase(),this._element().addClass(e).append(n("<div />").addClass(o)),this._renderClick(),this._renderIcon(),this._renderType(),this._renderText()},_renderClick:function(){var t=this,n=f.addNamespace("dxclick",this.NAME);this._clickAction=this._createActionByOption("clickAction");this._element().off(n).on(n,function(n){t._clickAction({jQueryEvent:n})})},_removeTypesCss:function(){var n=this._element().attr("class");n=n.replace(/\bdx-button-[-a-z0-9]+\b/gi,""),this._element().attr("class",n)},_renderIcon:function(){var f=this._element().find(u),i=f.find(y),t=this.option("icon"),r=this.option("iconSrc");(i.remove(),this.option("type")!=="back"||t||(t="back"),t||r)&&(t?i=n("<span />").addClass("dx-icon-"+t):r&&(i=n("<img />").attr("src",r)),f.prepend(i.addClass(v)),this._element().addClass(c))},_renderType:function(){var t=this.option("type");t&&this._element().addClass("dx-button-"+t),t==="back"&&this._element().prepend(n("<span />").addClass(a))},_renderText:function(){var r=this.option("text"),f=this._element().find(u),e=this.option("type")==="back",i=f.find(l);if(!r&&!e){i.remove();return}i.length||(i=n("<span />").addClass(s).appendTo(f)),i.text(r||t.localization.localizeString("@Back")),this._element().addClass(h)},_clean:function(){this.callBase(),this._removeTypesCss()},_optionChanged:function(n){switch(n){case"clickAction":this._renderClick();break;case"icon":case"iconSrc":this._renderIcon();break;case"text":this._renderText();break;case"type":this._invalidate();break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var r=t.ui,f=r.events,e="dx-checkbox",o="dx-checkbox-icon",s="dx-checkbox-checked",h="dx-checkbox-indeterminate",c=100,u=f.addNamespace("dxclick","dxCheckBox");t.registerComponent("dxCheckBox",r.dxEditor.inherit({_deprecatedOptions:{checked:{since:"14.1",message:"Use the 'value' option instead."}},_optionAliases:{checked:"value"},_setDefaultOptions:function(){this.callBase(),this.option({value:i,valueChangeAction:null,hoverStateEnabled:!0})},_init:function(){this.callBase(),this._feedbackHideTimeout=c},_render:function(){this.callBase(),this._element().addClass(e),this._$iconContainer=n("<span />"),this._$iconContainer.addClass(o).appendTo(this._element()),this._renderValue(),this._renderClick(),this._updateContentSize()},_renderDimensions:function(){this.callBase(),this._updateContentSize()},_updateContentSize:function(){var r=this._element(),t=this.option("width"),i=this.option("height"),n;this._$iconContainer&&(t||i)&&(t=this._element().width(),i=this._element().height(),n=Math.min(i,t),this._$iconContainer.css({height:n,width:n,"margin-top":(i-n)/2,"margin-left":(t-n)/2}))},_renderClick:function(){var n=this._createAction(this._handleClick);this._element().off(u).on(u,function(t){n({jQueryEvent:t})})},_handleClick:function(n){var t=n.component;t._valueChangeEventInstance=n.jQueryEvent,t.option("value",!t.option("value"))},_renderValue:function(){var n=this._element(),t=this.option("value"),r=t===i;n.toggleClass(s,Boolean(t)),n.toggleClass(h,r)},_optionChanged:function(n){switch(n){case"value":this._renderValue();default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var e=t.ui,r=e.events,s="dx-texteditor",u="dx-texteditor-input",h="."+u,c="dx-texteditor-border",l="dx-placeholder",a="dx-show-clear-button",v="dx-icon-clear",y="dx-clear-button-area",p="dx-texteditor-empty",f="dx-state-focused",o=["focusIn","focusOut","keyDown","keyPress","keyUp","change","cut","copy","paste","input"],w=function(){return t.browser.msie&&t.browser.version>9||!t.browser.msie}();t.registerComponent("dxTextEditor",e.dxEditor.inherit({_deprecatedOptions:{valueUpdateEvent:{since:"14.1",message:"Use the 'valueChangeEvent' option instead."},valueUpdateAction:{since:"14.1",message:"Use the 'valueChangeAction' option instead."}},_optionAliases:{valueUpdateEvent:"valueChangeEvent"},_setDefaultOptions:function(){this.callBase(),this.option({value:"",showClearButton:!1,valueChangeEvent:"change",valueUpdateAction:null,placeholder:"",readOnly:!1,focusInAction:null,focusOutAction:null,keyDownAction:null,keyPressAction:null,keyUpAction:null,changeAction:null,inputAction:null,cutAction:null,copyAction:null,pasteAction:null,enterKeyAction:null,mode:"text",activeStateEnabled:!1,hoverStateEnabled:!0})},_input:function(){return this._element().find(h)},_render:function(){this._element().addClass(s),this._renderInput(),this._renderInputType(),this._renderValue(),this._renderProps(),this._renderPlaceholder(),this._renderEvents(),this._toggleClearButton(),this._renderEnterKeyAction(),this._renderEmptinessEvent(),this._renderFocusEvent(),this.callBase()},_renderInput:function(t){(t||this._element()).append(n("<div>").addClass(c).append(n("<input>").addClass(u)))},_renderValue:function(n){var t=n||this.option("value");this._input().val()!==t&&(this._input().val(t),this._toggleEmptinessEventHandler())},_isValueValid:function(){var n=this._input().get(0).validity;return n?n.valid:!0},_toggleEmptiness:function(n){this._element().toggleClass(p,n)},_togglePlaceholderVisibility:function(n){this._$placeholder&&(t.browser.msie?this._$placeholder.toggle(!this._input().is(":focus")&&n):this._$placeholder.toggle(n))},_renderProps:function(){this._input().prop({readOnly:this._readOnlyPropValue(),disabled:this.option("disabled")})},_readOnlyPropValue:function(){return this.option("readOnly")},_renderPlaceholder:function(){var i=this,u=i._input(),f=i.option("placeholder"),t=this._$placeholder=n("<div>").attr("data-dx_placeholder",f),e=r.addNamespace("dxclick",this.NAME);t.on(e,function(){u.focus()});t.appendTo(u.parent()),t.addClass(l)},_toggleClearButton:function(){if(w){var t=this._element(),n=this.option("showClearButton")&&!this.option("readOnly");t.toggleClass(a,n),n?this._renderClearButton():this._$clearButton&&this._$clearButton.remove()}},_renderClearButton:function(){var t=n("<span>").addClass(y).append(n("<span>").addClass(v)).on(r.addNamespace("dxpointerdown",this.NAME),function(){return!1}).on(r.addNamespace("dxpointerup",this.NAME),n.proxy(this._handleClearValue,this));this._element().append(t),this._$clearButton=t},_handleClearValue:function(){var n=this._input();this.option("value",""),n.is(":focus")?(n.val(""),this._toggleEmptinessEventHandler()):n.trigger("focus")},_renderEvents:function(){var t=this,i=t._input();t._renderValueUpdateEvent(),n.each(o,function(n,u){var f=r.addNamespace(u.toLowerCase(),t.NAME),e=t._createActionByOption(u+"Action");i.off(f).on(f,function(n){e({jQueryEvent:n})})})},_renderValueUpdateEvent:function(){var t=this.NAME+"ValueUpdate",i=r.addNamespace(this.option("valueChangeEvent"),t);this._input().off("."+t).on(i,n.proxy(this._handleValueChangeEvent,this));this._valueUpdateAction=this._createActionByOption("valueUpdateAction")},_renderFocusEvent:function(){var i=this._element();if(i.find("."+u).focusin(function(){i.addClass(f)}).focusout(function(){i.removeClass(f)}).filter(":focus").addClass(f),t.browser.msie)this._input().on("focus",n.proxy(function(){this._togglePlaceholderVisibility(!1)},this))},_renderEmptinessEvent:function(){var t=this._input();t.on("input blur",n.proxy(this._toggleEmptinessEventHandler,this));this._toggleEmptinessEventHandler()},_toggleEmptinessEventHandler:function(n){var n=this._input().val(),t=(n===""||n===null)&&this._isValueValid();this._toggleEmptiness(t),this._togglePlaceholderVisibility(t)},_handleValueChangeEvent:function(n,t){this._valueChangeEventInstance=n,this._suppressValueUpdateAction=!0,this.option("value",arguments.length>1?t:this._input().val()),this._suppressValueUpdateAction=!1,this._valueUpdateAction({value:this.option("value"),jQueryEvent:n})},_renderEnterKeyAction:function(){if(this.option("enterKeyAction")){this._enterKeyAction=this._createActionByOption("enterKeyAction");this._input().on("keyup.enterKey.dxTextEditor",n.proxy(this._handleEnterKeyUp,this))}else this._input().off("keyup.enterKey.dxTextEditor"),this._enterKeyAction=i},_handleEnterKeyUp:function(n){n.which===13&&this._enterKeyAction({jQueryEvent:n})},_toggleDisabledState:function(){this.callBase.apply(this,arguments),this._renderProps()},_updateValue:function(){this._renderValue(),this._suppressValueUpdateAction||this._valueUpdateAction({value:this.option("value")})},_suppressUpdateValue:function(){this._valueUpdateSuppressed=!0},_resumeUpdateValue:function(){this._valueUpdateSuppressed=!1},_optionChanged:function(t){if(n.inArray(t.replace("Action",""),o)>-1){this._renderEvents();return}switch(t){case"valueChangeEvent":case"valueUpdateAction":this._renderValueUpdateEvent();break;case"readOnly":this._renderProps(),this._toggleClearButton();break;case"mode":this._renderInputType();break;case"enterKeyAction":this._renderEnterKeyAction();break;case"placeholder":this._invalidate();break;case"showClearButton":this._toggleClearButton();break;case"value":this._valueUpdateSuppressed||this._updateValue();default:this.callBase.apply(this,arguments)}},_renderInputType:function(){this._setInputType(this.option("mode"))},_setInputType:function(n){var t=this._input();n==="search"&&(n="text");try{t.prop("type",n)}catch(i){t.prop("type","text")}},focus:function(){this._input().focus()},blur:function(){this._input().is(document.activeElement)&&t.utils.resetActiveElement()}}))}(jQuery,DevExpress),function(n,t,i){var r=t.ui,u=r.events,e=t.devices,o=window.navigator.userAgent,s=[8,9,13,33,34,35,36,37,38,39,40,46],h="dx-textbox",f="dx-searchbox",c="dx-icon-search";t.registerComponent("dxTextBox",r.dxTextEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({mode:"text",maxLength:null})},_render:function(){this.callBase(),this._element().addClass(h),this._renderMaxLengthHandlers(),this._renderSearchMode()},_renderMaxLengthHandlers:function(){if(this._isAndroid())this._input().on(u.addNamespace("keydown",this.NAME),n.proxy(this._onKeyDownAndroidHandler,this)).on(u.addNamespace("change",this.NAME),n.proxy(this._onChangeAndroidHandler,this))},_renderProps:function(){if(this.callBase(),!this._isAndroid()){var n=this.option("maxLength");n>0&&this._input().prop("maxLength",n)}},_renderSearchMode:function(){var n=this._$element;this.option("mode")==="search"&&(this._renderSearchIcon(),n.addClass(f),this._showClearButton=this.option("showClearButton"),this.option("showClearButton",!0)),this.option("mode")!=="search"&&(n.removeClass(f),this._$searchIcon&&this._$searchIcon.remove(),this.option("showClearButton",this._showClearButton===i?this.option("showClearButton"):this._showClearButton))},_renderSearchIcon:function(){var t=n("<div>").addClass(c);t.prependTo(this._input().parent()),this._$searchIcon=t},_optionChanged:function(n){switch(n){case"maxLength":this._renderProps(),this._renderMaxLengthHandlers();break;case"mode":this._renderSearchMode();default:this.callBase.apply(this,arguments)}},_onKeyDownAndroidHandler:function(t){var r=this.option("maxLength"),i,u;return r?(i=n(t.target),u=t.keyCode,this._cutOffExtraChar(i),i.val().length<r||n.inArray(u,s)!==-1||window.getSelection().toString()!==""):!0},_onChangeAndroidHandler:function(t){var i=n(t.target);this.option("maxLength")&&this._cutOffExtraChar(i)},_cutOffExtraChar:function(n){var t=this.option("maxLength"),i=n.val();i.length>t&&n.val(i.substr(0,t))},_isAndroid:function(){var n=e.real(),t=n.version.join(".");return n.platform==="android"&&t&&/^(2\.|4\.1)/.test(t)&&!/chrome/i.test(o)}}))}(jQuery,DevExpress),function(n,t,i){var e=t.ui,r=e.events,l="dx-dropdowneditor",o="dx-dropdowneditor-readonly",a="dx-dropdowneditor-input-wrapper",v="dx-dropdowneditor-button",y="dx-dropdowneditor-icon",p="dx-dropdowneditor-overlay",s="dx-dropdowneditor-active",h="dx-dropdowneditor-button-visible",u=r.addNamespace("dxclick","dxDropDownEditor"),f=r.addNamespace("mousedown","dxDropDownEditor"),c={upArrow:38,downArrow:40};t.registerComponent("dxDropDownEditor",e.dxTextBox.inherit({_setDefaultOptions:function(){this.callBase(),this.option({openAction:null,closeAction:null})},open:function(){this._showDropDown()},close:function(){this._hideDropDown()},_clean:function(){this.callBase(),this._dropDownContainer&&(this._dropDownContainer.remove(),this._dropDown=i)},_render:function(){this._dropDownContainerRendered=!1,this._element().addClass(l),this._renderButton(),this.callBase(),this._renderKeyboardEvents();var n=this;this._input().on("blur",function(){n._hideOnBlur()&&!n._needToPreventBlur&&n._hideDropDown(),n._needToPreventBlur=!1})},_renderInput:function(t){this._inputWrapper=t||n("<div>"),this._inputWrapper.addClass(a),this._element().prepend(this._inputWrapper),this.callBase(this._inputWrapper)},_renderButton:function(t){this._button=n("<div>").addClass(v),this._attachButtonEvents(),this._updateButtonReadonlyState(),this._buttonIcon=n("<div>").addClass(y).appendTo(this._button),this._button.appendTo(this._element()),t?(this._element().removeClass(h),this._button.hide()):this._element().addClass(h)},_attachButtonEvents:function(){var n=this,t,i;if(this._button.off(u).off(f),!this.option("readOnly")){t=this._createAction(function(){n._toggleDropDown(),n._dropDownClickHandler()}),i=this._createAction(function(t){n._mouseDownFocusKeeper(t.jQueryEvent)});this._button.on(u,function(){t()}).on(f,function(n){i({jQueryEvent:n})})}},_updateButtonReadonlyState:function(){this._button.removeClass(o),this.option("readOnly")&&this._button.addClass(o)},_renderKeyboardEvents:function(){this._input().off(r.addNamespace("keydown","dxDropDownEditor")).on(r.addNamespace("keydown","dxDropDownEditor"),n.proxy(this._onKeyDownHandler,this))},_dropDownClickHandler:function(){this._deviceHasTouchScreen()||this._input().is(":focus")||this.focus(),this._needToPreventBlur=!1},_mouseDownFocusKeeper:function(n){this._needToPreventBlur=!0,n&&n.preventDefault&&n.preventDefault()},_deviceHasTouchScreen:function(){var n=DevExpress.devices.real();return n.phone||n.tablet},_hideOnBlur:function(){return!0},_renderDropDownContent:function(){return[]},_dropDownVisible:function(){return this._dropDown&&this._dropDown.option("visible")},_toggleDropDown:function(){this._dropDownVisible()?this._hideDropDown():this._showDropDown()},_showDropDown:function(){this._dropDownVisible()||(this._renderDropDownContainer(),this._dropDown.show(),this._element().addClass(s))},_hideDropDown:function(){this._dropDownVisible()&&(this._element().removeClass(s),this._dropDown.hide())},_renderDropDownContainer:function(){var i=this,t;this._dropDownContainerRendered||(this._dropDownContainer=n("<div>").addClass(p).addClass(i.option("customOverlayCssClass")),this._element().append(this._dropDownContainer),this._createDropDown(),t=this._renderDropDownContent(),n.isArray(t)||(t=[t]),n.each(t,function(n,t){t.off(f).on(f,function(n){i._mouseDownFocusKeeper(n)}).off(u).on(u,function(){i._dropDownClickHandler()});i._dropDownContainer.append(t)}),this._dropDownContainerRendered=!0)},_createDropDown:function(t){this._dropDown=this._dropDownContainer.dxOverlay(n.extend(!0,{position:{offset:"0 -1",my:"left top",at:"left bottom",of:this._element(),collision:"flip flip"},showTitle:!1,width:"auto",height:"auto",shading:!1,rtlEnabled:this.option("rtlEnabled"),closeOnTargetScroll:n.proxy(this._closeOnScrollHandler,this),closeOnOutsideClick:n.proxy(this._closeOutsideDropDownHandler,this),animation:{show:!1,hide:!1},shownAction:this.option("openAction"),hiddenAction:this.option("closeAction")},t)).dxOverlay("instance")},_closeOnScrollHandler:function(){return this._hideDropDown(),!0},_closeOutsideDropDownHandler:function(t,i){return t.target===this._input()[0]||t.target===this._button[0]||this._button.find(n(t.target)).length||i&&this._dropDown._container().find(n(t.target)).length||this._hideDropDown(),!1},_onKeyDownHandler:function(n){n.altKey&&(n.which===c.downArrow&&this._showDropDown(),n.which===c.upArrow&&this._hideDropDown())},_optionChanged:function(n,t){switch(n){case"rtlEnabled":this.callBase.apply(this,arguments),this._dropDownContainerRendered&&this._dropDown.option(n,t);break;case"openAction":this._dropDownContainerRendered&&this._dropDown.option("shownAction",t);break;case"closeAction":this._dropDownContainerRendered&&this._dropDown.option("hiddenAction",t);break;case"readOnly":this._attachButtonEvents(),this._updateButtonReadonlyState();default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var u=t.ui,r=u.events,f="dx-textarea",e="dx-texteditor-input",o="dx-texteditor-border";t.registerComponent("dxTextArea",u.dxTextBox.inherit({_setDefaultOptions:function(){this.callBase(),this.option({})},_render:function(){this.callBase(),this._element().addClass(f)},_renderInput:function(){this._element().append(n("<div />").addClass(o).append(n("<textarea />").addClass(e))),this._renderScrollHandler()},_renderScrollHandler:function(){var n=this._input(),t=0;n.on(r.addNamespace("dxpointerdown",this.NAME),function(n){t=r.eventData(n).y});n.on(r.addNamespace("dxpointermove",this.NAME),function(i){var u=n.scrollTop(),f=n.prop("scrollHeight")-n.prop("clientHeight")-u;if(u!==0||f!==0){var e=r.eventData(i).y,o=u===0&&t>=e,s=f===0&&t<=e,h=u>0&&f>0;(o||s||h)&&(i.originalEvent.isScrollingEvent=!0),t=e}})},_renderInputType:n.noop}))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,e=Math,u=f.events,o="dx-numberbox",r=o+"-spin",s=r+"-container",h=r+"-up",c=r+"-down",l=r+"-button",y="."+h,p="."+c,a=150,v=["Del","Backspace","Left","Right","Home","End"];t.registerComponent("dxSpinButton",f.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({direction:"up",changeAction:null})},_render:function(){this.callBase();var e=this,f=this._element(),t=u.addNamespace("dxpointerdown",this.NAME),i=r+"-"+this.option("direction");f.addClass(l).addClass(i).off(t).on(t,n.proxy(this._handleSpinHold,this));this._spinIcon=n("<div>").addClass(i+"-icon").appendTo(this._element()),this._handleSpinChange=this._createActionByOption("changeAction")},_handleSpinHold:function(t){t.preventDefault();var i=u.addNamespace("dxpointerup",this.NAME),r=u.addNamespace("dxpointercancel",this.NAME);this._clearTimer();n(document).off(i).off(r).on(i,n.proxy(this._clearTimer,this)).on(r,n.proxy(this._clearTimer,this));this._handleSpinChange({jQueryEvent:t}),this._holdTimer=setInterval(this._handleSpinChange,a,{jQueryEvent:t})},_dispose:function(){this._clearTimer(),this.callBase()},_clearTimer:function(){this._holdTimer&&clearInterval(this._holdTimer)},_optionChanged:function(n,t,i){switch(n){case"changeAction":case"direction":this._invalidate();break;default:this.callBase(n,t,i)}}})),t.registerComponent("dxNumberBox",f.dxTextEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({value:0,min:i,max:i,mode:"number",showSpinButtons:!1,step:1})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){var i=t.devices.real(),f=i.platform,r=i.version,u=i.deviceType==="desktop",e=t.browser.msie&&t.browser.version.split(".")[0]>9&&u,o=t.browser.webkit&&u,s=t.browser.mozilla&&u,h=f==="android"&&r[0]>=4&&r[1]>=4,c=f==="ios"&&r[0]>6;return e||o||c||h||s},options:{mode:"number"}}])},_init:function(){this.callBase(),this._initSpinButtons()},_initSpinButtons:function(){var t=u.addNamespace("dxpointerdown",this.NAME);this._$spinContainer=n("<div>").addClass(s).off(t).on(t,n.proxy(this._handleSpinButtonsClick,this)),this._$spinUp=n("<div>").dxSpinButton({direction:"up",changeAction:n.proxy(this._handleSpinUpChange,this)}).appendTo(this._$spinContainer),this._$spinDown=n("<div>").dxSpinButton({direction:"down",changeAction:n.proxy(this._handleSpinDownChange,this)}).appendTo(this._$spinContainer)},_handleSpinButtonsClick:function(){var n=this._input();document.activeElement!==n[0]&&n.trigger("focus")},_render:function(){this.callBase(),this._element().addClass(o),this._renderSpinButtons(),this._handleKeyPressEvent()},_handleKeyPressEvent:function(){var t=this;this._input().keypress(function(i){var r=String.fromCharCode(i.which),u=/[\d.,eE\-+]/,f=u.test(r);if(!f&&!(i.key&&n.inArray(i.key,v)>=0))return i.preventDefault(),!1;t._isIncompleteValue=!1,t._isValueIncomplete(t._input().val()+r)&&(t._isIncompleteValue=!0)})},_isValueIncomplete:function(n){var t=/\d+e$/,i=/^-/;return t.test(n)||i.test(n)},_renderSpinButtons:function(){this._element().toggleClass(r,this.option("showSpinButtons")),this.option("showSpinButtons")?this._$spinContainer.appendTo(this._element()):this._$spinContainer.detach()},_handleSpinUpChange:function(){var n=parseFloat(this.option().value),t=parseFloat(this.option().step);this.option("value",n+t)},_handleSpinDownChange:function(){var n=parseFloat(this.option().value),t=parseFloat(this.option().step);this.option("value",n-t)},_renderValue:function(){var t=this.option("value")?this.option("value").toString():this.option("value"),n;this._input().val()!==t&&(n=this._input().attr("type"),this._setInputType("text"),this._input().val(this.option("value")),this._setInputType(n),this._toggleEmptinessEventHandler())},_renderProps:function(){this.callBase(),this._input().prop({min:this.option("min"),max:this.option("max"),step:this.option("step")})},_trimInputValue:function(){var i=this._input(),t=n.trim(i.val());t[t.length-1]==="."&&(t=t.slice(0,-1)),this._forceRefreshInputValue(t)},_inputInvalidHandler:function(){var n=this._input(),t=n.val();this._oldValue?(this.option("value",this._oldValue),n.val(this._oldValue),this._oldValue=null):(this.option("value",""),n.val(""))},_forceRefreshInputValue:function(n){var t=this._input();t.val("").val(n)},_renderValueUpdateEvent:function(){this.callBase(),this._input().focusout(n.proxy(this._trimInputValue,this))},_handleValueChangeEvent:function(t){var r=this._input(),i=n.trim(r.val()),u=r.get(0);if(i=i.replace(",","."),this._valueChangeEventInstance=t,!this._isIncompleteValue&&!this._validateValue(i)){this._inputInvalidHandler();return}if(i!==""){if(this._isIncompleteValue)return;if(i=this._parseValue(i),!i&&i!==0)return;this.callBase(t,i),r.val()!=i&&r.val(i)}else this.option("value","")},_validateValue:function(n){var t=this._isValueValid(),i,r;return!n&&t?(this.option("value",""),!0):(i=/^-?\d+\.?\d*$/.test(n),r=/^-?\d+e[-+]?\d+$/.test(n),this._oldValue=this.option("value"),!i&&!r&&!t)?!1:!0},_parseValue:function(n){var t=parseFloat(n);return this.option("min")!==i&&(t=e.max(t,this.option("min"))),this.option("max")!==i&&(t=e.min(t,this.option("max"))),t},_setValue:function(t,i){if(t!==i){if(!t&&t!==0){this.option("value","");return}if(n.type(t)==="string"&&(t=t.replace(",",".")),t=this._parseValue(t),!t&&t!==0){this.option("value",i);return}this.option("value",t)}},_invalidate:function(){this._$spinContainer.detach(),this.callBase()},_dispose:function(){this._$spinContainer.remove(),this.callBase()},_optionChanged:function(n,t,i){switch(n){case"value":this._setValue(t,i),this.callBase.apply(this,arguments);break;case"step":case"min":case"max":this._renderProps();break;case"showSpinButtons":this._renderSpinButtons();break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,e=r.events,u="dxRadioButton",o="dx-radio-button",s="dx-radio-button-icon",h="dx-radio-button-checked",f=e.addNamespace("dxclick",u);t.registerComponent(u,r.dxEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({value:!1,hoverStateEnabled:!0})},_init:function(){this.callBase(),this._element().addClass(o)},_render:function(){this.callBase(),this._renderIcon(),this._renderCheckedState(this.option("value")),this._renderClick()},_renderIcon:function(){var t=n("<div />").addClass(s);this._element().append(t)},_renderCheckedState:function(n){this._element().toggleClass(h,n)},_renderClick:function(){var t=this._createAction(n.proxy(function(n){this._handleClick(n.jQueryEvent)},this));this._element().off(f).on(f,function(n){t({jQueryEvent:n})})},_handleClick:function(n){this._valueChangeEventInstance=n,this.option("value",!0)},_optionChanged:function(n,t){switch(n){case"value":this._renderCheckedState(t),this.callBase.apply(this,arguments);break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var r=t.ui,v=r.events,e="dx-radio-group",o="dx-radio-group-vertical",s="dx-radio-group-horizontal",u="dx-radio-button",h="dx-radio-button-icon",c="dx-radio-value-container",f="dx-radio-button-checked",l="dxRadioButtonData",a=100;t.registerComponent("dxRadioGroup",r.CollectionContainerWidget.inherit({_activeStateUnit:"."+u,_setDefaultOptions:function(){this.callBase(),this.option({layout:"vertical",value:i,valueExpr:null,hoverStateEnabled:!0})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{tablet:!0},options:{layout:"horizontal"}}])},_optionsByReference:function(){return n.extend(this.callBase(),{value:!0})},_itemClass:function(){return u},_itemDataKey:function(){return l},_itemContainer:function(){return this._element()},_init:function(){this.callBase(),this._dataSource||this._itemsToDataSource(),this._feedbackHideTimeout=a},_itemsToDataSource:function(){this._dataSource=new DevExpress.data.DataSource(this.option("items"))},_render:function(){this._element().addClass(e),this._compileValueGetter(),this.callBase(),this._renderLayout(),this._renderValue(),this._updateContentSize()},_renderDimensions:function(){this.callBase(),this._updateContentSize()},_updateContentSize:function(){if(this.option("layout")==="horizontal")this._itemElements().css("height","auto");else{var n=this.option("items").length;this._itemElements().css("height",100/n+"%")}},_compileValueGetter:function(){this._valueGetter=t.data.utils.compileGetter(this._valueGetterExpr())},_valueGetterExpr:function(){return this.option("valueExpr")||this._dataSource&&this._dataSource._store._key||"this"},_renderLayout:function(){var n=this.option("layout");this._element().toggleClass(o,n==="vertical"),this._element().toggleClass(s,n==="horizontal")},_renderValue:function(){var n=this.option("value");n!=null&&n!==i?this._setIndexByValue():this._setValueByIndex()},_setIndexByValue:function(n){var t=this;n=n===i?t.option("value"):n,t._searchValue(n).done(function(n){t._dataSource.isLoaded()?t._setIndexByItem(n):t._dataSource.load().done(function(){t._setIndexByItem(n)})})},_setIndexByItem:function(t){var i=-1;n.each(this._dataSource.items(),n.proxy(function(n,r){if(this._valuesEqual(t,r))return i=n,!1},this)),this.option("selectedIndex",i)},_valuesEqual:function(n,i){var r=this._dataSource&&this._dataSource.key(),u=n===i,f,e;return r&&!u&&(f=t.utils.unwrapObservable(n[r]),e=t.utils.unwrapObservable(i[r]),u=f===e),u},_searchValue:function(i){var r=this,u=r._dataSource.store(),e=r._valueGetterExpr(),f=n.Deferred();return e===u.key()||u instanceof t.data.CustomStore?u.byKey(i).done(function(n){f.resolveWith(r,[n])}):u.load({filter:[e,i]}).done(function(n){f.resolveWith(r,n)}),f.promise()},_setValueByIndex:function(){var n=this.option("selectedIndex"),r=this._itemElements(),t,i;if(n<0||n>=r.length){this.option("value",null);return}t=this._selectedItemElement(n),i=this._getItemData(t),this.option("value",this._getItemValue(i))},_getItemValue:function(n){return!this._valueGetter?n.text:this._valueGetter(n)},_renderSelectedIndex:function(n){var t=this._itemElements();t.removeClass(f),n>=0&&n<t.length&&t.eq(n).addClass(f)},_createItemByRenderer:function(n,t){var i=this.callBase.apply(this,arguments);return this._renderInput(i,t.item),i},_createItemByTemplate:function(n,t){var i=this.callBase.apply(this,arguments);return this._renderInput(i,t.item),i},_renderInput:function(t,i){if(!i.html){var r=n("<div>").addClass(h),u=n("<div>").append(r).addClass(c);t.prepend(u)}},_optionChanged:function(n,t){switch(n){case"value":this._setIndexByValue(t);break;case"selectedIndex":this.callBase.apply(this,arguments),this._setValueByIndex();break;case"layout":this._renderLayout(),this._updateContentSize();break;case"valueExpr":this._compileValueGetter(),this._setValueByIndex();break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,y=r.events,o="dx-tabs",s="dx-indent-wrapper",h="dx-tab",c=".dx-tab",u="dx-tab-selected",l="dx-tab-text",f="dx-icon",a="dxTabData",v=100,e="dx-state-active";t.registerComponent("dxTabs",r.CollectionContainerWidget.inherit({_activeStateUnit:c,_setDefaultOptions:function(){this.callBase(),this.option({hoverStateEnabled:!0})},_init:function(){this.callBase(),this._feedbackHideTimeout=v},_itemClass:function(){return h},_itemDataKey:function(){return a},_itemRenderDefault:function(t,i,r){if(this.callBase(t,i,r),!t.html){var s=t.text,e=t.icon,o=t.iconSrc,u;s&&r.wrapInner(n("<span />").addClass(l)),e?u=n("<span />").addClass(f+"-"+e):o&&(u=n("<img />").attr("src",o)),u&&u.addClass(f).prependTo(r)}},_render:function(){this.callBase();var n=this._element();n.addClass(o),this._renderWrapper(),n.addClass(e).removeClass(e)},_renderWrapper:function(){this._element().wrapInner(n("<div />").addClass(s))},_renderSelectedIndex:function(n,t){var i=this._itemElements();t>=0&&i.eq(t).removeClass(u),n>=0&&i.eq(n).addClass(u)}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,u="dx-navbar",f="dx-nav-item",e="dx-nav-item-content",o="dx-navbar-item-badge";t.registerComponent("dxNavBar",r.dxTabs.inherit({_render:function(){this.callBase(),this._element().addClass(u)},_postprocessRenderItem:function(t){var i=t.itemElement,r=t.itemData,u=r.badge;u&&n("<div>").addClass(o).text(u).appendTo(i),i.addClass(f),i.wrapInner(n("<div>").addClass(e)),r.icon||r.iconSrc||i.addClass("dx-navbar-text-item")}}))}(jQuery,DevExpress),function(n,t){var o=t.ui,s=t.fx,r=t.utils,h=t.translator,c="dx-toolbar",l="dx-toolbar-bottom",a="dx-toolbar-mini",v="dx-toolbar-item",f="dx-toolbar-label",u="dx-toolbar-button",y="dx-toolbar-menu-container",p="dx-toolbar-menu-button",w="dx-toolbar-items-container",e="."+f,b="dxToolbarItemDataKey",k="easeOutCubic",d=200,g=400,nt=function(n,t,i){var r=i?g:d;s.animate(n,{type:"slide",to:{top:t},easing:k,duration:r})};t.registerComponent("dxToolbar",o.CollectionContainerWidget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({menuItemRender:null,menuItemTemplate:"item",submenuType:"dxDropDownMenu",renderAs:"topToolbar"})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:[{platform:"ios"},{platform:"ios7"}],options:{submenuType:"dxActionSheet"}},{device:{platform:"android"},options:{submenuType:"dxDropDownMenu"}},{device:{platform:"win8"},options:{submenuType:"dxList"}}])},_itemContainer:function(){return this._$toolbarItemsContainer.find(".dx-toolbar-before,.dx-toolbar-center,.dx-toolbar-after")},_itemClass:function(){return v},_itemDataKey:function(){return b},_itemRenderDefault:function(i,r,u){var f;if(this.callBase(i,r,u),f=i.widget,f){var e=n("<div>").appendTo(u),o=t.inflector.camelize("dx-"+f),s=i.options||{};e[o](s)}else i.text&&u.wrapInner("<div>")},_dimensionChanged:function(){this._menu&&this._toggleMenuVisibility(!1,!0),this._arrangeTitle()},_render:function(){this._renderToolbar(),this._renderSections(),this.callBase(),this._renderMenu(),this._arrangeTitle()},_renderToolbar:function(){this._element().addClass(c).toggleClass(l,this.option("renderAs")==="bottomToolbar"),this._$toolbarItemsContainer=n("<div>").appendTo(this._element()),this._$toolbarItemsContainer.addClass(w)},_renderSections:function(){var t=this._$toolbarItemsContainer,i=this;n.each(["before","center","after"],function(){var r="dx-toolbar-"+this,u=t.find("."+r);u.length||(i["_$"+this+"Section"]=u=n("<div>").addClass(r).appendTo(t))})},_arrangeTitle:function(){var r,u;if(this._$element.is(":hidden")){this._titleUpdateIsNeeded=!0;return}this._titleUpdateIsNeeded=!1;var h=this._$toolbarItemsContainer,t=this._$centerSection,i=t.children(e).eq(0);if(i.length!==0){var c=h.width(),f=this._$beforeSection.outerWidth(),o=this._$afterSection.outerWidth(),s=10;t.children().not(e).each(function(){s+=n(this).outerWidth()}),r=c-f-o-s,u=i.width()>r,t.css({marginLeft:u?f:"",marginRight:u?o:""}),i.css("max-width",r)}},_renderItem:function(n,t){var i,o,e;return t.align&&r.logger.warn("dxToolbar.items.align is deprecated. Please use dxToolbar.items.location instead."),i=t.location||t.align||"center",i==="left"?(i="before",r.logger.warn("dxToolbar.items.location: value 'left' is deprecated. Please use 'before' instead.")):i==="right"&&(i="after",r.logger.warn("dxToolbar.items.location: value 'right' is deprecated. Please use 'after' instead.")),o=this._$toolbarItemsContainer.find(".dx-toolbar-"+i),e=this.callBase(n,t,o),e.addClass(u),t.text&&e.addClass(f).removeClass(u),e},_hasVisibleMenuItems:function(){var i=this._getMenuItems(),t=!1,r=DevExpress.data.utils.compileGetter("visible");return n.each(i,function(n,i){var u=r(i,{functionsAsIs:!0});u!==!1&&(t=!0)}),t},_getToolbarItems:function(){return n.grep(this.option("items")||[],function(n){return n.location!=="menu"})},_getMenuItems:function(){return n.grep(this.option("items")||[],function(n){return n.location==="menu"})},_renderContentImpl:function(){var n=this._getToolbarItems();this._element().toggleClass(a,n.length===0),this._renderedItemsCount?this._renderItems(n.slice(this._renderedItemsCount)):this._renderItems(n)},_renderMenu:function(){var t=this,i=this._createActionByOption("itemClickAction"),n={itemRender:this.option("menuItemRender"),itemTemplate:this.option("menuItemTemplate"),itemClickAction:function(n){t._toggleMenuVisibility(!1,!0),i(n)},rtlEnabled:this.option("rtlEnabled")};this._menuType=this.option("submenuType"),this._menuType==="dxList"&&this.option("renderAs")==="topToolbar"&&(this._menuType="dxDropDownMenu");switch(this._menuType){case"dxActionSheet":this._renderActionSheet(n);break;case"dxDropDownMenu":this._renderDropDown(n);break;case"dxList":this._renderList(n)}},_renderMenuButton:function(t){var i=n.extend({clickAction:n.proxy(this._handleMenuButtonClick,this)},t);this._renderMenuButtonContainer(),this._$button=n("<div>").appendTo(this._$menuButtonContainer).addClass(p).dxButton(i)},_renderMenuButtonContainer:function(){var t=this._$afterSection;this._$menuButtonContainer=n("<div>").appendTo(t).addClass(u).addClass(y)},_renderDropDown:function(t){this._hasVisibleMenuItems()&&(this._renderMenuButtonContainer(),this._menu=n("<div>").appendTo(this._$menuButtonContainer).dxDropDownMenu(t).dxDropDownMenu("instance"),this._renderMenuItems())},_renderActionSheet:function(t){if(this._hasVisibleMenuItems()){this._renderMenuButton({icon:"overflow"});var i=n.extend({target:this._$button,showTitle:!1},t);this._menu=n("<div>").appendTo(this._element()).dxActionSheet(i).dxActionSheet("instance"),this._renderMenuItems()}},_renderList:function(t){this._renderMenuButton({activeStateEnabled:!1,text:"..."});var i=n.extend({width:"100%",indicateLoading:!1},t);this._renderListOverlay(),this._renderContainerSwipe(),this._hasVisibleMenuItems()&&(this._menu=n("<div>").appendTo(this._listOverlay.content()).dxList(i).dxList("instance"),this._renderMenuItems()),this._changeListVisible(this.option("visible"))},_renderMenuItems:function(){this._menu.option("items",this._getMenuItems())},_getListHeight:function(){var n=this._listOverlay.content().find(".dx-list").height(),t=this._$toolbarItemsContainer.height()-this._element().height();return n+t},_renderListOverlay:function(){var t=this._element();this._listOverlay=n("<div>").appendTo(t).dxOverlay({targetContainer:!1,deferRendering:!1,shading:!1,height:"auto",width:"100%",showTitle:!1,closeOnOutsideClick:n.proxy(this._handleListOutsideClick,this),position:null,animation:null,hideTopOverlayHandler:null}).dxOverlay("instance")},_hideTopOverlayHandler:function(){this._toggleMenuVisibility(!1,!0)},_toggleHideTopOverlayCallback:function(){this._closeCallback&&t.hideTopOverlayCallback.remove(this._closeCallback),this._menuShown&&(this._closeCallback=n.proxy(this._hideTopOverlayHandler,this),t.hideTopOverlayCallback.add(this._closeCallback))},_renderContainerSwipe:function(){this._$toolbarItemsContainer.appendTo(this._listOverlay.content()).dxSwipeable({elastic:!1,startAction:n.proxy(this._handleSwipeStart,this),updateAction:n.proxy(this._handleSwipeUpdate,this),endAction:n.proxy(this._handleSwipeEnd,this),itemSizeFunc:n.proxy(this._getListHeight,this),direction:"vertical"})},_handleListOutsideClick:function(t){n(t.target).closest(this._listOverlay.content()).length||this._toggleMenuVisibility(!1,!0)},_calculatePixelOffset:function(n){n=(n||0)-1;var t=this._getListHeight();return n*t},_handleSwipeStart:function(n){n.jQueryEvent.maxTopOffset=this._menuShown?0:1,n.jQueryEvent.maxBottomOffset=this._menuShown?1:0},_handleSwipeUpdate:function(n){var t=this._menuShown?n.jQueryEvent.offset:1+n.jQueryEvent.offset;this._renderMenuPosition(t,!1)},_handleSwipeEnd:function(n){var t=n.jQueryEvent.targetOffset;t-=this._menuShown-1,this._toggleMenuVisibility(t===0,!0)},_renderMenuPosition:function(n,t){var i=this._calculatePixelOffset(n),r=this._listOverlay.content();t?nt(r,i,this._menuShown):h.move(r,{top:i})},_handleMenuButtonClick:function(){this._toggleMenuVisibility(!this._menuShown,!0)},_toggleMenuVisibility:function(n,t){this._menuShown=n;switch(this._menuType){case"dxList":this._toggleHideTopOverlayCallback(),this._renderMenuPosition(this._menuShown?0:1,t);break;case"dxActionSheet":this._menu.toggle(this._menuShown),this._menuShown=!1}},_renderEmptyMessage:n.noop,_clean:function(){this._$toolbarItemsContainer.children().empty(),this._element().empty()},_changeMenuOption:function(n,t){this._menu&&this._menu.option(n,t)},_changeListVisible:function(n){this._listOverlay&&(this._listOverlay.option("visible",n),this._toggleMenuVisibility(!1,!1))},_visibilityChanged:function(n){n&&this._titleUpdateIsNeeded&&this._arrangeTitle()},_optionChanged:function(n,t){switch(n){case"renderAs":case"submenuType":this._invalidate();break;case"visible":this._changeListVisible(t),this.callBase.apply(this,arguments);break;case"menuItemRender":this._changeMenuOption("itemRender",t);break;case"menuItemTemplate":this._changeMenuOption("itemTemplate",t);break;case"itemClickAction":this._changeMenuOption(n,t),this.callBase.apply(this,arguments);break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,e=r.events,u=t.utils,o="dx-list",f="dx-list-item",s="."+f,h="dx-list-group",c="dx-list-group-header",l="dx-has-next",a="dx-list-next-button",v="dxListItemData",y=70;t.registerComponent("dxList",r.CollectionContainerWidget.inherit({_activeStateUnit:s,_setDefaultOptions:function(){this.callBase(),this.option({pullRefreshEnabled:!1,autoPagingEnabled:!0,scrollingEnabled:!0,showScrollbar:!0,useNativeScrolling:!0,pullingDownText:Globalize.localize("dxList-pullingDownText"),pulledDownText:Globalize.localize("dxList-pulledDownText"),refreshingText:Globalize.localize("dxList-refreshingText"),pageLoadingText:Globalize.localize("dxList-pageLoadingText"),scrollAction:null,pullRefreshAction:null,pageLoadingAction:null,showNextButton:!1,nextButtonText:Globalize.localize("dxList-nextButtonText"),itemSwipeAction:null,grouped:!1,groupTemplate:"group",groupRender:null,indicateLoading:!0,hoverStateEnabled:!0})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){return!t.support.nativeScrolling},options:{useNativeScrolling:!1}},{device:function(n){return!t.support.nativeScrolling&&!t.devices.isSimulator()&&t.devices.real().platform==="generic"&&n.platform==="generic"},options:{showScrollbar:"onHover",showNextButton:!0,autoPagingEnabled:!1}}])},_itemClass:function(){return f},_itemDataKey:function(){return v},_itemContainer:function(){return this._$container},_allowDinamicItemsAppend:function(){return!0},_init:function(){this.callBase(),this._$container=this._element(),this._initScrollView(),this._feedbackShowTimeout=y},_dataSourceOptions:function(){return n.extend(this.callBase(),{paginate:!0})},_initScrollView:function(){var t=this.option("scrollingEnabled"),r=t&&this.option("pullRefreshEnabled"),i=t&&this.option("autoPagingEnabled")&&!!this._dataSource,u=this._element().dxScrollView({rtlEnabled:this.option("rtlEnabled"),disabled:this.option("disabled")||!t,scrollAction:n.proxy(this._handleScroll,this),pullDownAction:r?n.proxy(this._handlePullDown,this):null,reachBottomAction:i?n.proxy(this._handleScrollBottom,this):null,showScrollbar:this.option("showScrollbar"),useNative:this.option("useNativeScrolling"),pullingDownText:this.option("pullingDownText"),pulledDownText:this.option("pulledDownText"),refreshingText:this.option("refreshingText"),reachBottomText:this.option("pageLoadingText")});this._scrollView=u.dxScrollView("instance"),this._scrollView.toggleLoading(i),this._$container=this._scrollView.content(),this._createScrollViewActions(),this._afterItemsRendered()},_createScrollViewActions:function(){this._scrollAction=this._createActionByOption("scrollAction",{excludeValidators:["gesture"]}),this._pullRefreshAction=this._createActionByOption("pullRefreshAction",{excludeValidators:["gesture"]}),this._pageLoadingAction=this._createActionByOption("pageLoadingAction",{excludeValidators:["gesture"]})},_handleScroll:function(n){this._scrollAction(n)},_afterItemsRendered:function(n){var r=this._isLastPage(),t=!n||r,u=this.option("autoPagingEnabled"),i=!u||t,f=this._scrollViewIsFull();i||f?(this._scrollView.release(i),this._loadIndicationSuppressed=!1,this._shouldRenderNextButton()&&this._dataSource.isLoaded()&&this._toggleNextButton(!t)):this._infiniteDataLoading()},_shouldRenderNextButton:function(){return this.option("showNextButton")&&this._dataSource},_handleDataSourceLoadingChanged:function(t){this._loadIndicationSuppressed||(t&&this.option("indicateLoading")?this._showLoadingIndicatorTimer=setTimeout(n.proxy(function(){this._scrollView&&this._scrollView.startLoading()},this)):(clearTimeout(this._showLoadingIndicatorTimer),this._scrollView&&this._scrollView.finishLoading()))},_hideLoadingIfLoadIndicationOff:function(){this.option("indicateLoading")||this._handleDataSourceLoadingChanged(!1)},_suppressLoadingIndication:function(){this._loadIndicationSuppressed=!0},_isLastPage:function(){return!this._dataSource||this._dataSource.isLastPage()},_scrollViewIsFull:function(){return!this._scrollView||this._scrollView.isFull()},_handlePullDown:function(n){this._pullRefreshAction(n),this._dataSource&&!this._dataSource.isLoading()?(this._dataSource.pageIndex(0),this._dataSource.load()):this._afterItemsRendered()},_infiniteDataLoading:function(){var t=this._dataSource;this._scrollViewIsFull()||!t||t.isLoading()||this._isLastPage()||(this._loadNextPageTimer=setTimeout(n.proxy(this._loadNextPage,this)))},_handleScrollBottom:function(n){this._pageLoadingAction(n);var t=this._dataSource;t&&!t.isLoading()?this._loadNextPage():this._afterItemsRendered()},_loadNextPage:function(){var n=this._dataSource;return this._expectNextPageLoading(),n.pageIndex(1+n.pageIndex()),n.load()},_renderItems:function(t){this.option("grouped")?(n.each(t,n.proxy(this._renderGroup,this)),this._renderEmptyMessage()):this.callBase.apply(this,arguments),this._afterItemsRendered(!0)},_handleDataSourceLoadError:function(){this.callBase.apply(this,arguments),this._initialized&&this._afterItemsRendered()},_render:function(){this._element().addClass(o),this.callBase()},_postprocessRenderItem:function(t){this.option("itemSwipeAction")&&this._attachSwipeEvent(n(t.itemElement))},_attachSwipeEvent:function(t){var i=e.addNamespace("dxswipeend",this.NAME);t.on(i,n.proxy(this._handleItemSwipeEnd,this))},_handleItemSwipeEnd:function(n){this._handleItemJQueryEvent(n,"itemSwipeAction",{direction:n.offset<0?"left":"right"},{excludeValidators:["gesture"]})},_handleNextButton:function(){var n=this._dataSource;n&&!n.isLoading()&&(this._scrollView.toggleLoading(!0),this._$nextButton.detach(),this._suppressLoadingIndication(),this._loadNextPage())},_groupRenderDefault:function(n){return String(n.key||n)},_renderGroup:function(t,i){var r=this,e=n("<div>").addClass(h).appendTo(r._itemContainer()),o=r.option("groupRender"),l=r.option("groupTemplate"),s=r._getTemplate(i.template||l,t,i),u,f={index:t,group:i,container:e};u=o?r._createGroupByRenderer(o,f):s?r._createGroupByTemplate(s,f):r._createGroupByRenderer(r._groupRenderDefault,f),u.addClass(c),this._renderingGroupIndex=t,n.each(i.items||[],function(n,t){r._renderItem(n,t,e)})},_createGroupByRenderer:function(t,i){var r=n("<div>").appendTo(i.container),u=t(i.group,i.index,r);return u&&r[0]!==u[0]&&r.append(u),r},_createGroupByTemplate:function(n,t){return n.render(t.container,t.group)},_clean:function(){this._$nextButton&&(this._$nextButton.remove(),this._$nextButton=null),this.callBase.apply(this,arguments)},_dispose:function(){clearTimeout(this._holdTimer),clearTimeout(this._loadNextPageTimer),clearTimeout(this._showLoadingIndicatorTimer),this.callBase()},_toggleDisabledState:function(n){this.callBase(n),this._scrollView.option("disabled",n||!this.option("scrollingEnabled"))},_toggleNextButton:function(n){var t=this._dataSource,i=this._getNextButton();this._element().toggleClass(l,n),n&&t&&t.isLoaded()&&i.appendTo(this._itemContainer()),n||i.detach()},_getNextButton:function(){return this._$nextButton||(this._$nextButton=this._createNextButton()),this._$nextButton},_createNextButton:function(){var t=n("<div>").addClass(a);return t.append(n("<div>").dxButton({text:this.option("nextButtonText"),clickAction:n.proxy(this._handleNextButton,this)})),t},_optionChanged:function(n,t){switch(n){case"showNextButton":this._toggleNextButton(t);break;case"dataSource":this.callBase.apply(this,arguments),this._initScrollView();break;case"pullingDownText":case"pulledDownText":case"refreshingText":case"pageLoadingText":case"useNativeScrolling":case"showScrollbar":case"scrollingEnabled":case"pullRefreshEnabled":case"autoPagingEnabled":this._initScrollView();break;case"nextButtonText":case"itemSwipeAction":this._invalidate();break;case"scrollAction":case"pullRefreshAction":case"pageLoadingAction":this._createScrollViewActions(),this._invalidate();break;case"grouped":case"groupTemplate":case"groupRender":this._invalidate();break;case"items":this._invalidate();break;case"width":case"height":this.callBase.apply(this,arguments),this._scrollView.update();break;case"indicateLoading":this._hideLoadingIfLoadIndicationOff();break;case"visible":this.callBase.apply(this,arguments),this._scrollView.update();break;case"rtlEnabled":this._initScrollView(),this.callBase.apply(this,arguments);break;default:this.callBase.apply(this,arguments)}},update:function(){return u.logger.warn("'update' method is deprecated since 14.1. Use the 'updateDimensions' method instead."),this.updateDimensions.apply(this,arguments)},updateDimensions:function(){var t=this,i=n.Deferred();return t._scrollView?t._scrollView.update().done(function(){i.resolveWith(t)}):i.resolveWith(t),i.promise()},refresh:function(){return u.logger.warn("'refresh' method is deprecated since 14.1. Use the 'reload' method instead."),this.reload.apply(this,arguments)},reload:function(){this._scrollView.refresh()},scrollTop:function(){return this._scrollView.scrollOffset().top},clientHeight:function(){return this._scrollView.clientHeight()},scrollHeight:function(){return this._scrollView.scrollHeight()},scrollBy:function(n){this._scrollView.scrollBy(n)},scrollTo:function(n){this._scrollView.scrollTo(n)},scrollToItem:function(t){var r=n(t);if(r.length){var i=r.position().top,f=r.outerHeight(),o=i+f,u=this.scrollTop(),e=this.clientHeight();u<=i&&o<=u+e||(u>i?this.scrollTo(i):this.scrollTo(i+f-e))}}}))}(jQuery,DevExpress),function(n,t){var f=t.ui,e=t.Class.inherit({ctor:function(n){this._list=n},getNormalizedIndex:function(n){return this._isNormalisedItemIndex(n)?n:this._isItemIndex(n)?this._normalizeItemIndex(n):this._getNormalizedItemIndex(n)},getIndex:function(n){return this._isNormalisedItemIndex(n)?this._denormalizeItemIndex(n):this._isItemIndex(n)?n:this._denormalizeItemIndex(this._getNormalizedItemIndex(n))},getItemElement:function(t){return this._isNormalisedItemIndex(t)?this._getItemByNormalizedIndex(t):this._isItemIndex(t)?this._getItemByNormalizedIndex(this._normalizeItemIndex(t)):n(t)},deleteItemAtIndex:t.abstract,updateSelectionAfterDelete:t.abstract,fetchSelectedItems:t.abstract,selectedItemIndecies:t.abstract,itemPlacementFunc:function(n,t){return this._itemsFromSameParent(n,t)&&n<t?"after":"before"},moveItemAtIndexToIndex:t.abstract,getSelectedItemsAfterReorderItem:function(){return this._list.option("selectedItems")},_isNormalisedItemIndex:function(t){return n.isNumeric(t)},_isItemIndex:t.abstract,_getNormalizedItemIndex:t.abstract,_normalizeItemIndex:t.abstract,_denormalizeItemIndex:t.abstract,_getItemByNormalizedIndex:t.abstract,_itemsFromSameParent:t.abstract});f.PlainListEditStrategy=e.inherit({deleteItemAtIndex:function(n){this._list.option("items").splice(n,1)},updateSelectionAfterDelete:function(t){var i=this._list._selectedItemIndices;n.each(i,function(n,r){r>t&&(i[n]-=1)})},fetchSelectedItems:function(t){t=t||this._list._selectedItemIndices;var r=this._list.option("items"),i=[];return n.each(t,function(n,t){i.push(r[t])}),i},selectedItemIndecies:function(){var t=[],i=this._list.option("items"),r=this._list.option("selectedItems");return n.each(r,function(r,u){var f=n.inArray(u,i);f!==-1&&t.push(f)}),t},moveItemAtIndexToIndex:function(n,t){var i=this._list.option("items"),r=i[n];i.splice(n,1),i.splice(t,0,r)},_isItemIndex:function(t){return n.isNumeric(t)},_getNormalizedItemIndex:function(n){return this._list._itemElements().index(n)},_normalizeItemIndex:function(n){return n},_denormalizeItemIndex:function(n){return n},_getItemByNormalizedIndex:function(n){return this._list._itemElements().eq(n)},_itemsFromSameParent:function(){return!0}});var c="dx-list-item",o="dx-list-group",s=20,l=2303,u=function(n){return(n.group<<s)+n.item},r=function(n){return{group:n>>s,item:n&l}},h=function(t,i){var u=t.items,r={key:t.key,items:[]};return n.each(i,function(n,t){r.items.push(u[t])}),r},a=function(n,t){for(var r=n.length,i=0;i<r;i++)if(n[i].key===t)return n[i]};f.GroupedListEditStrategy=e.inherit({_groupElements:function(){return this._list._itemContainer().find("."+o)},_groupItemElements:function(n){return n.find("."+c)},deleteItemAtIndex:function(n){var t=r(n),i=this._list.option("items")[t.group].items;i.splice(t.item,1)},updateSelectionAfterDelete:function(t){var i=r(t),u=this._list._selectedItemIndices;n.each(u,function(n,t){var f=r(t);f.group===i.group&&f.item>i.item&&(u[n]-=1)})},fetchSelectedItems:function(t){var e,f,u,i;return t=t||this._list._selectedItemIndices,e=this._list.option("items"),f=[],t.sort(function(n,t){return n-t}),u=0,i=[],n.each(t,function(n,t){var o=r(t);o.group!==u&&i.length&&(f.push(h(e[u],i)),i.length=0),u=o.group,i.push(o.item)}),i.length&&f.push(h(e[u],i)),f},selectedItemIndecies:function(){var t=[],i=this._list.option("items"),r=this._list.option("selectedItems");return n.each(r,function(r,f){var e=a(i,f.key),o=n.inArray(e,i);n.each(f.items,function(i,r){var f=n.inArray(r,e.items);f!==-1&&t.push(u({group:o,item:f}))})}),t},moveItemAtIndexToIndex:function(n,t){var u=this._list.option("items"),i=r(n),f=r(t),e=u[i.group].items,o=u[f.group].items,s=e[i.item];e.splice(i.item,1),o.splice(f.item,0,s)},getSelectedItemsAfterReorderItem:function(t,i){if(this._itemsFromSameParent(t,i)||n.inArray(t,this._list._selectedItemIndices))return this.callBase();var s=this._list.option("items"),u=this._list.option("selectedItems"),f=r(t),h=r(i),e=u[f.group].items,c=u[h.group].items,o=s[f.group].items[f.item],l=n.inArray(o,e);return e.splice(l,1),c.push(o),u},_isItemIndex:function(t){return n.isNumeric(t.group)&&n.isNumeric(t.item)},_getNormalizedItemIndex:function(t){var i=n(t),r=i.closest("."+o);return u({group:this._groupElements().index(r),item:this._groupItemElements(r).index(i)})},_normalizeItemIndex:function(n){return u(n)},_denormalizeItemIndex:function(n){return r(n)},_getItemByNormalizedIndex:function(n){var t=r(n),i=this._groupElements().eq(t.group);return this._groupItemElements(i).eq(t.item)},_itemsFromSameParent:function(n,t){return r(n).group===r(t).group}})}(jQuery,DevExpress),function(n,t,i){var s=t.ui,u=s.events,o=t.translator,r=t.fx,ot=t.support,v=t.utils,a,rt;s.ListEditDecoratorsRegistry={};var f=function(t,i,r){var u=s.ListEditDecoratorsRegistry,f={};f[t]=u[t]?u[t]:{},f[t][i]=r,u=n.extend(u,f)},st="dx-list-item-content",y="dx-list-item-bag-container",e="dxListEditDecorator",ht=u.addNamespace("dxswipestart",e),ct=u.addNamespace("dxswipe",e),lt=u.addNamespace("dxswipeend",e),at=u.addNamespace("dxdragstart",e),vt=u.addNamespace("dxdrag",e),yt=u.addNamespace("dxdragend",e),p=u.addNamespace("dxpointerdown",e),w=u.addNamespace("dxclick",e),h=t.Class.inherit({ctor:function(n){this._list=n,this._init()},_init:n.noop,_shouldHandleSwipe:!1,_attachSwipeEvent:function(t){var i={itemSizeFunc:n.proxy(function(){return this._clearSwipeCache&&(this._itemWidthCache=this._list._element().width(),this._clearSwipeCache=!1),this._itemWidthCache},this)};t.$itemElement.on(ht,i,n.proxy(this._handleItemSwipeStart,this)).on(ct,n.proxy(this._handleItemSwipeUpdate,this)).on(lt,n.proxy(this._handleItemSwipeEnd,this))},_handleItemSwipeStart:function(t){var i=n(t.currentTarget);if(i.is(".dx-state-disabled, .dx-state-disabled *")){t.cancel=!0;return}this._handleSwipeStart(i,t)},_handleItemSwipeUpdate:function(t){var i=n(t.currentTarget);this._handleSwipeUpdate(i,t)},_handleItemSwipeEnd:function(t){var i=n(t.currentTarget);this._handleSwipeEnd(i,t),this._clearSwipeCache=!0},beforeBag:n.noop,afterBag:n.noop,modifyElement:function(n){this._shouldHandleSwipe&&(this._attachSwipeEvent(n),this._clearSwipeCache=!0)},handleClick:n.noop,handleHold:n.noop,_handleSwipeStart:n.noop,_handleSwipeUpdate:n.noop,_handleSwipeEnd:n.noop,dispose:n.noop}),b="dx-list-menu-positioning",k=h.inherit({_menuEnabled:function(){return!!this._menuItems().length},_menuItems:function(){return this._list.option("editConfig.menuItems")},_deleteEnabled:function(){return this._list.option("editConfig.deleteEnabled")},_fireMenuAction:function(n,t){this._list._handleItemEventByHandler(n,t)}}),c="dx-list-switchable-delete-ready",pt="dx-list-switchable-delete-top-shield",wt="dx-list-switchable-delete-bottom-shield",bt="dx-list-switchable-delete-item-content-shield",d=k.inherit({_init:function(){this._$topShield=n("<div />").addClass(pt),this._$bottomShield=n("<div />").addClass(wt),this._$itemContentShield=n("<div />").addClass(bt);this._$topShield.on(p,n.proxy(this._cancelDeleteReadyItem,this));this._$bottomShield.on(p,n.proxy(this._cancelDeleteReadyItem,this));this._list._element().append(this._$topShield.toggle(!1)).append(this._$bottomShield.toggle(!1))},handleClick:function(){return this._cancelDeleteReadyItem()},_cancelDeleteReadyItem:function(){return this._$readyToDeleteItem?(this._cancelDelete(this._$readyToDeleteItem),!0):!1},_cancelDelete:function(n){this._toggleDeleteReady(n,!1)},_toggleDeleteReady:function(n,t){t===i&&(t=!this._isReadyToDelete(n)),this._toggleShields(n,t),this._toggleScrolling(t),this._cacheReadyToDeleteItem(n,t),this._animateToggleDelete(n,t)},_isReadyToDelete:function(n){return n.hasClass(c)},_toggleShields:function(n,t){this._$topShield.toggle(t),this._$bottomShield.toggle(t),t&&this._updateShieldsHeight(n),this._toggleContentShield(n,t)},_updateShieldsHeight:function(n){var t=this._list._element(),r=t.offset().top,u=t.outerHeight(),f=n.offset().top,e=n.outerHeight(),i=f-r,o=u-e-i;this._$topShield.height(Math.max(i,0)),this._$bottomShield.height(Math.max(o,0))},_toggleContentShield:function(n,t){t?n.find("."+st).append(this._$itemContentShield):this._$itemContentShield.detach()},_toggleScrolling:function(n){var t=this._list._element().dxScrollView("instance");n?(this._scrollViewDisabled=t.option("disabled"),t.option("disabled",!0)):t.option("disabled",this._scrollViewDisabled)},_cacheReadyToDeleteItem:function(n,t){t?this._$readyToDeleteItem=n:delete this._$readyToDeleteItem},_animateToggleDelete:function(t,i){i?(this._enablePositioning(t),this._prepareDeleteReady(t),this._animatePrepareDeleteReady(t)):(this._forgetDeleteReady(t),this._animateForgetDeleteReady(t).done(n.proxy(this._disablePositioning,this,t)))},_enablePositioning:function(n){n.addClass(b)},_disablePositioning:function(n){n.removeClass(b)},_prepareDeleteReady:function(n){n.addClass(c)},_forgetDeleteReady:function(n){n.removeClass(c)},_animatePrepareDeleteReady:t.abstract,_animateForgetDeleteReady:t.abstract,_deleteItem:function(n){(n=n||this._$readyToDeleteItem,n.is(".dx-state-disabled, .dx-state-disabled *"))||(this._cancelDelete(n),this._list.deleteItem(n))},_isRtlEnabled:function(){return this._list.option("rtlEnabled")},dispose:function(){this._$topShield&&this._$topShield.remove(),this._$bottomShield&&this._$bottomShield.remove(),this.callBase.apply(this,arguments)}}),kt="dx-list-switchable-delete-button-container",dt="dx-list-switchable-delete-button-wrapper",gt="dx-list-switchable-delete-button-inner-wrapper",ni="dx-list-switchable-delete-button",ki="dx-list-switchable-delete-menu",g=200,nt=d.inherit({_init:function(){this.callBase.apply(this,arguments);var t=n("<div >").addClass(kt),i=n("<div />").addClass(dt),r=n("<div />").addClass(gt),u=n("<div />").addClass(ni);u.dxButton({text:Globalize.localize("dxListEditDecorator-delete"),type:"danger",clickAction:n.proxy(function(n){this._deleteItem(),n.jQueryEvent.stopPropagation()},this)}),t.append(i),i.append(r),r.append(u),this._$buttonContainer=t},_enablePositioning:function(n){this.callBase.apply(this,arguments),r.stop(this._$buttonContainer,!0),this._$buttonContainer.appendTo(n)},_disablePositioning:function(){this.callBase.apply(this,arguments),this._$buttonContainer.detach()},_animatePrepareDeleteReady:function(){var n=this._isRtlEnabled(),t=this._list._element().width(),i=this._buttonWidth(),u=n?t:-i,f=n?t-i:0;return r.animate(this._$buttonContainer,{type:"custom",duration:g,from:{right:u},to:{right:f}})},_animateForgetDeleteReady:function(){var n=this._isRtlEnabled(),t=this._list._element().width(),i=this._buttonWidth(),u=n?t-i:0,f=n?t:-i;return r.animate(this._$buttonContainer,{type:"custom",duration:g,from:{right:u},to:{right:f}})},_buttonWidth:function(){return this._buttonContainerWidth||(this._buttonContainerWidth=this._$buttonContainer.outerWidth()),this._buttonContainerWidth},dispose:function(){this._$buttonContainer&&this._$buttonContainer.remove(),this.callBase.apply(this,arguments)}}),ti="dx-list-toggle-delete-switch-container",ii="dx-list-toggle-delete-switch";f("delete","toggle",nt.inherit({beforeBag:function(t){var r=t.$itemElement,i=t.$container,u=n("<div />").dxButton({icon:"toggle-delete",clickAction:n.proxy(function(n){this._toggleDeleteReady(r),n.jQueryEvent.stopPropagation()},this)}).addClass(ii);i.addClass(ti),i.append(u)}})),f("delete","slideButton",nt.inherit({_shouldHandleSwipe:!0,_handleSwipeEnd:function(n,t){return t.targetOffset!==0&&this._toggleDeleteReady(n),!0}}));var ri="dx-list-slide-menu-wrapper",l="dx-list-slide-menu-content",ui="dx-list-slide-menu-buttons-container",tt="dx-list-slide-menu-buttons",it="dx-list-slide-menu-button",fi="dx-list-slide-menu-button-menu",ei="dx-list-slide-menu-button-delete",oi="dx-list-slide-menu";f("menu","slide",d.inherit({_shouldHandleSwipe:!0,_init:function(){this.callBase.apply(this,arguments),this._$buttonsContainer=n("<div/>").addClass(ui),this._$buttons=n("<div/>").addClass(tt).appendTo(this._$buttonsContainer),this._renderMenu(),this._renderDeleteButton()},_renderMenu:function(){var t,r,i,u;this._menuEnabled()&&(t=this._menuItems(),t.length===1?(r=t[0],this._renderMenuButton(r.text,n.proxy(function(){this._fireAction(r)},this))):(i=n("<div />").addClass(oi),i.dxActionSheet({showTitle:!1,items:t,itemClickAction:n.proxy(function(n){this._fireAction(n.itemData)},this)}),i.appendTo(this._list._element()),this._menu=i.dxActionSheet("instance"),u=this._renderMenuButton(Globalize.localize("dxListEditDecorator-more"),n.proxy(this._menu.show,this._menu)),this._menu.option("target",u)))},_renderMenuButton:function(t,i){var r=n("<div/>").addClass(it).addClass(fi).text(t);this._$buttons.append(r);r.on(w,i);return r},_renderDeleteButton:function(){if(this._deleteEnabled()){var t=n("<div/>").addClass(it).addClass(ei).text(Globalize.localize("dxListEditDecorator-delete"));t.on(w,n.proxy(function(){this._deleteItem()},this));this._$buttons.append(t)}},_fireAction:function(t){this._fireMenuAction(n(this._cachedNode),t.action),this._cancelDeleteReadyItem()},modifyElement:function(t){var i,r;this.callBase.apply(this,arguments),i=t.$itemElement,i.addClass(ri).removeClass(y),r=n("<div/>").addClass(l).addClass(y),i.wrapInner(r)},handleClick:function(t,i){return n(i.target).closest("."+l).length?this.callBase.apply(this,arguments):!0},_handleSwipeStart:function(n){this._enablePositioning(n),this._cacheItemData(n)},_handleSwipeUpdate:function(n,t){var r=this._isRtlEnabled(),u=r?-1:1,f=this._cachedItemWidth*t.offset,e=this._isReadyToDelete(n)?-this._cachedButtonWidth*u:0,i=(f+e)*u,s=i<0?f+e:0,h=i<0?i:0;return o.move(this._$cachedContent,{left:s}),this._$buttonsContainer.css(r?"right":"left",Math.max(this._cachedItemWidth+h,this._minButtonContainerLeftOffset())),!0},_cacheItemData:function(n){n[0]!==this._cachedNode&&(this._$cachedContent=n.find("."+l),this._cachedItemWidth=n.outerWidth(),this._cachedButtonWidth=this._cachedButtonWidth||n.find("."+tt).outerWidth(),this._$cachedContent.length&&(this._cachedNode=n[0]))},_minButtonContainerLeftOffset:function(){return this._cachedItemWidth-this._cachedButtonWidth},_handleSwipeEnd:function(n,t){this._cacheItemData(n);var i=this._isRtlEnabled()?1:-1,r=this._cachedItemWidth*t.offset,u=!this._isReadyToDelete(n)&&r*i>this._cachedButtonWidth*.2,f=t.targetOffset===i||u;return this._toggleDeleteReady(n,f),!0},_enablePositioning:function(n){this.callBase.apply(this,arguments),this._$buttonsContainer.appendTo(n)},_disablePositioning:function(){this.callBase.apply(this,arguments),this._$buttonsContainer.detach()},_animatePrepareDeleteReady:function(){var t=this._isRtlEnabled(),f=t?1:-1,u;this._$buttonsContainer.css(t?"left":"right","0");var e=r.animate(this._$cachedContent,{to:{left:this._cachedButtonWidth*f},type:"slide",duration:200}),o=t?"right":"left",i={};return i[o]=this._minButtonContainerLeftOffset(),u=r.animate(this._$buttonsContainer,{to:i,duration:200}),n.when(e,u).promise()},_animateForgetDeleteReady:function(t){var i,e;this._cacheItemData(t),i=this._isRtlEnabled(),this._$buttonsContainer.css(i?"left":"right","0");var o=r.animate(this._$cachedContent,{to:{left:0},type:"slide",duration:200}),u=i?"right":"left",f={};return f[u]=this._cachedItemWidth,e=r.animate(this._$buttonsContainer,{to:f,duration:200,complete:n.proxy(function(){this._$buttonsContainer.css(u,"100%")},this)}),n.when(o,e).promise()},dispose:function(){this._menu&&this._menu._element().remove(),this._$buttonsContainer&&this._$buttonsContainer.remove(),this.callBase.apply(this,arguments)}})),f("delete","swipe",h.inherit({_shouldHandleSwipe:!0,_renderItemPosition:function(t,i,u){var f=n.Deferred(),e=i*this._itemElementWidth;return u?r.animate(t,{to:{left:e},type:"slide",complete:function(){f.resolve(t,i)}}):(o.move(t,{left:e}),f.resolve()),f.promise()},_handleSwipeStart:function(n){return this._itemElementWidth=n.width(),!0},_handleSwipeUpdate:function(n,t){return this._renderItemPosition(n,t.offset),!0},_handleSwipeEnd:function(t,i){var r=i.targetOffset;return this._renderItemPosition(t,r,!0).done(n.proxy(function(n,t){Math.abs(t)&&this._list.deleteItem(n)},this)),!0}})),a="dx-list-holddelete-menu",rt="dx-list-holddelete-menucontent",f("menu","hold",k.inherit({_init:function(){var t=n("<div/>").addClass(a);this._list._element().append(t),this._menu=this._renderOverlay(t)},_renderOverlay:function(t){return t.dxOverlay({shading:!1,deferRendering:!0,closeOnTargetScroll:!0,closeOnOutsideClick:function(t){return!n(t.target).closest("."+a).length},animation:{show:{type:"slide",duration:300,from:{height:0,opacity:1},to:{height:n.proxy(function(){return this._$menuList.outerHeight()},this),opacity:1}},hide:{type:"slide",duration:0,from:{opacity:1},to:{opacity:0}}},height:n.proxy(function(){return this._$menuList?this._$menuList.outerHeight():0},this),width:n.proxy(function(){return this._list._element().outerWidth()},this),contentReadyAction:n.proxy(this._renderMenuContent,this)}).dxOverlay("instance")},_renderMenuContent:function(t){var i=t.component.content(),r=this._menuItems().slice();this._deleteEnabled()&&r.push({text:Globalize.localize("dxListEditDecorator-delete"),action:n.proxy(this._deleteItem,this)}),this._$menuList=n("<div>").dxList({items:r,itemClickAction:n.proxy(this._handleMenuItemClick,this),height:"auto"}),i.addClass(rt),i.append(this._$menuList)},_handleMenuItemClick:function(n){this._menu.hide(),this._fireMenuAction(this._$itemWithMenu,n.itemData.action)},_deleteItem:function(){this._list.deleteItem(this._$itemWithMenu)},handleHold:function(n){return this._$itemWithMenu=n,this._menu.option({position:{my:"top",at:"bottom",of:n,collision:"flip"}}),this._menu.show(),!0},dispose:function(){this._menu&&this._menu._element().remove(),this.callBase.apply(this,arguments)}}));var si="dx-list-item-selected",ut="dx-list-select-decorator-enabled",hi="dx-list-select-checkbox-container",ci="dx-list-select-checkbox",li="dx-list-select-radio-button-container",ai="dx-list-select-radio-button";f("selection","control",h.inherit({_init:function(){this.callBase.apply(this,arguments);var n=this._list.option("selectionMode");this._singleStrategy=n==="single",this._containerClass=this._singleStrategy?li:hi,this._controlClass=this._singleStrategy?ai:ci,this._controlWidget=this._singleStrategy?"dxRadioButton":"dxCheckBox",this._list._element().addClass(ut)},beforeBag:function(t){var i=t.$itemElement,r=t.$container,u=n("<div />").addClass(this._controlClass);u[this._controlWidget]({value:this._isSelected(i),valueChangeAction:n.proxy(function(n){this._processCheckedState(i,n.value),n.jQueryEvent&&n.jQueryEvent.stopPropagation()},this)}),r.addClass(this._containerClass),r.append(u)},modifyElement:function(t){this.callBase.apply(this,arguments);var i=t.$itemElement,r=i.find("."+this._controlClass)[this._controlWidget]("instance");i.on("stateChanged",n.proxy(function(){r.option("value",this._isSelected(i))},this))},_isSelected:function(n){return n.hasClass(si)},_processCheckedState:function(n,t){t?this._list.selectItem(n):this._list.unselectItem(n)},dispose:function(){this._list._element().removeClass(ut),this.callBase.apply(this,arguments)}})),f("selection","item",s.ListEditDecoratorsRegistry.selection.control.inherit({handleClick:function(n){var t=!this._isSelected(n)||this._singleStrategy;return this._processCheckedState(n,t),!0}}));var vi="dx-list-reorder-handle-container",yi="dx-list-reorder-handle",ft="dx-list-item-reordering",pi="dx-list-item-ghost-reordering",wi="dx-list-reorder-compatibility-mode",et=function(n,t,i){return Math.min(Math.max(n,t),i)},bi=t.Animator.inherit({ctor:function(n){this.callBase(),this._strategy=n},_isFinished:function(){return this._strategy.scrollFinished()},_step:function(){this._strategy.scrollByStep()}});f("reorder","default",h.inherit({_init:function(){this._groupedEnabled=this._list.option("grouped"),this._initAnimator()},_initAnimator:function(){this._scrollAnimator=new bi(this)},_startAnimator:function(){this._scrollAnimator.inProgress()||this._scrollAnimator.start()},_stopAnimator:function(){this._scrollAnimator.stop()},afterBag:function(t){var r=t.$itemElement,u=t.$container,i=n("<div>").addClass(yi);i.on(at,{direction:"vertical"},n.proxy(this._handleDragStart,this,r));i.on(vt,n.proxy(this._handleDrag,this,r));i.on(yt,n.proxy(this._handleDragEnd,this,r));u.addClass(vi),u.append(i)},_handleDragStart:function(n,t){this._stopPreviousAnimation(),t.targetElements=[],this._cacheItemsPositions(),this._startPointerOffset=t.pageY-n.offset().top,this._elementHeight=n.outerHeight();var i=this._list.getFlatIndexByItemElement(n);this._startIndex=i,this._lastIndex=i,this._cacheScrollData(),this._createGhost(n),n.addClass(ft),this._toggleCompatibilityMode(!0)},_stopPreviousAnimation:function(){r.stop(this._$ghostItem,!0)},_toggleCompatibilityMode:function(n){this._list._element().toggleClass(wi,!ot.transform3d&&n)},_cacheItemsPositions:function(){this._itemPositions=[],n.each(this._list.itemElements(),n.proxy(function(t,i){this._itemPositions.push(n(i).position().top)},this))},_getDraggingElementPosition:function(){return this._itemPositions[this._startIndex]},_getLastElementPosition:function(){return this._itemPositions[this._lastIndex]},_cacheScrollData:function(){this._list.updateDimensions(),this._startScrollTop=this._list.scrollTop(),this._scrollOffset=0,this._scrollHeight=this._list.scrollHeight(),this._clientHeight=this._list.clientHeight()},_scrollTop:function(){return this._startScrollTop+this._scrollOffset},_createGhost:function(n){this._$ghostItem=n.clone(),this._$ghostItem.addClass(pi).appendTo(this._list.itemsContainer()),this._startGhostPosition=this._getDraggingElementPosition()-this._$ghostItem.position().top,o.move(this._$ghostItem,{top:this._startGhostPosition})},_handleDrag:function(n,t){this._topOffset=t.offset.y,this._updateItemPositions();var i=this._getPonterPosition();this._toggleScroll(i)},_getPonterPosition:function(){return this._getDraggingElementPosition()+this._startPointerOffset+this._scrollOffset+this._topOffset},_toggleScroll:function(n){if(!(this._scrollHeight<=this._clientHeight)){var t=this._elementHeight*.7,u=this._clientHeight-(n-this._scrollTop()),i=u/t,f=n-this._scrollTop(),r=f/t;i<1?(this._stepSize=this._adjustRationIntoRange(i),this._startAnimator()):r<1?(this._stepSize=-this._adjustRationIntoRange(r),this._startAnimator()):this._stopAnimator()}},_adjustRationIntoRange:function(n){return et(Math.round(Math.abs(n-1)*7),1,7)},_updateItemPositions:function(){this._updateGhostPosition(),this._updateOthersPositions()},_updateGhostPosition:function(){o.move(this._$ghostItem,{top:this._startGhostPosition+this._scrollOffset+this._topOffset})},_updateOthersPositions:function(){var n=this._findItemIndexByPosition(this._getPonterPosition()),t;if(this._lastIndex!==n&&(!this._groupedEnabled||this._sameParent(n))){var u=n-this._startIndex,f=v.sign(u),h=Math.min(n,this._lastIndex),c=Math.max(n,this._lastIndex);for(t=h;t<=c;t++)if(t!==this._startIndex){var i=this._list.getItemElementByFlatIndex(t),e=t-this._startIndex,l=v.sign(e),o=Math.abs(e)<=Math.abs(u),s=f===l,a=o&&s,y=!o||!s;r.stop(i),a&&r.animate(i,{type:"slide",to:{top:this._elementHeight*-f},duration:300}),y&&r.animate(i,{type:"slide",to:{top:0},duration:300})}this._lastIndex=n}},_sameParent:function(n){var t=this._list.getItemElementByFlatIndex(this._startIndex),i=this._list.getItemElementByFlatIndex(n);return i.parent().get(0)===t.parent().get(0)},scrollByStep:function(){this._scrollOffset+=this._stepSize,this._list.scrollBy(this._stepSize),this._updateItemPositions()},scrollFinished:function(){var n=this._scrollTop(),t=n<=0&&this._stepSize<0,i=n>=this._scrollHeight-this._clientHeight&&this._stepSize>0;return t||i},_handleDragEnd:function(t){this._scrollAnimator.stop(),r.animate(this._$ghostItem,{type:"slide",to:{top:this._startGhostPosition+this._getLastElementPosition()-this._getDraggingElementPosition()},duration:300}).done(n.proxy(function(){t.removeClass(ft),this._resetPositions(),this._list.reorderItem(t,this._list.getItemElementByFlatIndex(this._lastIndex)),this._deleteGhost(),this._toggleCompatibilityMode(!1)},this))},_deleteGhost:function(){this._$ghostItem.remove()},_resetPositions:function(){for(var i=Math.min(this._startIndex,this._lastIndex),r=Math.max(this._startIndex,this._lastIndex),t,n=i;n<=r;n++)t=this._list.getItemElementByFlatIndex(n),o.resetPosition(t)},_findItemIndexByPosition:function(n){for(var i=0,r=this._itemPositions.length-1,t,u;i<=r;)if(t=(i+r)/2|0,u=this._itemPositions[t],u<n)i=t+1;else if(u>n)r=t-1;else return t;return et(i,0,Math.max(r,0))}}))}(jQuery,DevExpress),function(n,t){var u=t.ui,v=u.events,y=t.utils,f=[],r=function(n,t,i){f.push({enabled:n,decoratorType:t,decoratorSubType:i})};r(function(n){return n.menuItems.length},function(){return"menu"},function(n){return n.menuType}),r(function(n){return!n.menuItems.length&&n.deleteEnabled},function(n,t){var i=n.deleteMode!==t.deleteMode?n.deleteMode:n.deleteType;return i==="toggle"||i==="slideButton"||i==="swipe"?"delete":"menu"},function(n,t){var i;return i=n.deleteMode!==t.deleteMode?n.deleteMode:n.deleteType,i==="slideItem"&&(i="slide"),i}),r(function(n){return n.selectionEnabled},function(){return"selection"},function(n,t){var i;return i=n.selectionMode!==t.selectionMode?n.selectionMode:n.selectionType}),r(function(n){return n.reorderEnabled},function(){return"reorder"},function(){return"default"});var e="dx-list-item-bag-container",o="dx-list-item-content",s="dx-list-item-before-bag",h="dx-list-item-after-bag",c="beforeBag",l="afterBag",a="modifyElement";u.ListEditProvider=t.Class.inherit({ctor:function(n,t,i){this._list=n,this._config=t,this._defaultConfig=i,this.isModifyingByDecorators()&&this._fetchRequiredDecorators()},dispose:function(){this._decorators&&this._decorators.length&&n.each(this._decorators,function(n,t){t.dispose()})},isModifyingByDecorators:function(n){return!(this.isRenderingByRenderer()||this.isRenderingByTemplate(n))},isRenderingByRenderer:function(){return!!this.getItemRenderer()},getItemRenderer:function(){return this._config.itemRender},isRenderingByTemplate:function(n){return!!this.getItemTemplateName(n)},getItemTemplateName:function(n){return n&&n.editTemplate||this._config.itemTemplate},_fetchRequiredDecorators:function(){this._decorators=[];var t=this._config,i=this._defaultConfig;n.each(f,n.proxy(function(n,r){var u=r.enabled(t,i);if(u){var f=r.decoratorType(t,i),e=r.decoratorSubType(t,i),o=this._createDecorator(f,e);this._decorators.push(o)}},this))},_createDecorator:function(n,t){var i=this._findDecorator(n,t);return new i(this._list)},_findDecorator:function(n,t){return u.ListEditDecoratorsRegistry[n][t]},modifyItemElement:function(t){var i=n(t.itemElement),r;i.addClass(e),this._wrapContent(i),r={$itemElement:i},this._prependBeforeBags(i,r),this._appendAfterBags(i,r),this._applyDecorators(a,r)},_wrapContent:function(t){var i=n("<div />").addClass(o);t.wrapInner(i)},_prependBeforeBags:function(n,t){var i=this._collectDecoratorsMarkup(c,t,s);n.prepend(i)},_appendAfterBags:function(n,t){var i=this._collectDecoratorsMarkup(l,t,h);n.append(i)},_collectDecoratorsMarkup:function(t,i,r){var u=n("<div />");return n.each(this._decorators,function(){var f=n("<div />").addClass(r);this[t](n.extend({$container:f},i)),f.children().length&&u.append(f)}),u.children()},_applyDecorators:function(t,i){n.each(this._decorators,function(){this[t](i)})},_handlerExists:function(t){var r,u,i;if(!this._decorators)return!1;for(r=this._decorators,u=r.length,i=0;i<u;i++)if(r[i][t]!==n.noop)return!0;return!1},_handleEvent:function(n,t,i){var r;if(!this._decorators)return!1;var u=!1,f=this._decorators,e=f.length;for(r=0;r<e;r++)if(u=f[r][n](t,i),u)break;return u},handleClick:function(n,t){return this._handleEvent("handleClick",n,t)},holdHandlerExists:function(){return this._handlerExists("handleHold")},handleHold:function(n,t){return this._handleEvent("handleHold",n,t)}})}(jQuery,DevExpress),function(n,t,i){var r=t.ui,o=t.utils,f=o.removeDublicates,s="dx-list-editing",u="dx-list-item-selected",e="dx-list-item-response-wait";t.registerComponent("dxList",r.dxList.inherit({_setDefaultOptions:function(){this.callBase(),this.option({editEnabled:!1,editConfig:{itemTemplate:null,itemRender:null,menuType:"hold",menuItems:[],deleteEnabled:!1,deleteMode:"toggle",deleteType:"toggle",selectionEnabled:!1,selectionMode:"item",selectionType:"item",reorderEnabled:!1},itemDeleteAction:null,selectionMode:"multi",selectedItems:[],itemSelectAction:null,itemUnselectAction:null,itemReorderAction:null})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{platform:"ios"},options:{editConfig:{deleteType:"slideButton",deleteMode:"slideButton"}}},{device:{platform:"ios7"},options:{editConfig:{menuType:"slide",deleteType:"slideItem",deleteMode:"slideItem"}}},{device:{platform:"android"},options:{editConfig:{deleteType:"swipe",deleteMode:"swipe"}}},{device:{platform:"win8"},options:{editConfig:{deleteType:"hold",deleteMode:"hold"}}},{device:{platform:"generic"},options:{editConfig:{deleteType:"slideItem",deleteMode:"slideItem"}}}])},_init:function(){this.callBase(),this._initEditProvider(),this._initEditStrategy(this.option("grouped")),this._initSelectedItems()},_initEditProvider:function(){var n=this.initialOption("editConfig");this._editProvider=new r.ListEditProvider(this,this.option("editConfig"),n)},_disposeEditProvider:function(){this._editProvider&&this._editProvider.dispose()},_refreshEditProvider:function(){this._disposeEditProvider(),this._initEditProvider()},_initEditStrategy:function(n){var t=n?r.GroupedListEditStrategy:r.PlainListEditStrategy;this._editStrategy=new t(this)},_initSelectedItems:function(){this._selectedItemIndices=this._editStrategy.selectedItemIndecies(this.option("selectedItems"))},_clearSelectedItems:function(){this._selectedItemIndices=[],this.option("selectedItems",[])},_render:function(){this._renderEditing(),this.callBase(),this._normalizeSelectedItems()},_renderEditing:function(){this._element().toggleClass(s,this.option("editEnabled"))},_handleItemClick:function(t){var i=n(t.currentTarget),r;i.is(".dx-state-disabled, .dx-state-disabled *")||(r=this.option("editEnabled")&&this._editProvider.handleClick(i,t),r)||this.callBase.apply(this,arguments)},_shouldAttachHoldEvent:function(){return this.callBase.apply(this,arguments)||this._editProvider.holdHandlerExists()},_handleItemHold:function(t){var i=n(t.currentTarget),r;i.is(".dx-state-disabled, .dx-state-disabled *")||(r=this.option("editEnabled")&&this._editProvider.handleHold(i,t),r)||this.callBase.apply(this,arguments)},_getItemRenderer:function(){return this.option("editEnabled")&&this._editProvider.isRenderingByRenderer()?this._editProvider.getItemRenderer():this.callBase.apply(this,arguments)},_getItemTemplateName:function(n){return this.option("editEnabled")&&this._editProvider.isRenderingByTemplate(n)?this._editProvider.getItemTemplateName(n):this.callBase.apply(this,arguments)},_postprocessRenderItem:function(t){this.callBase.apply(this,arguments);var i=n(t.itemElement);this._isItemSelected(this._editStrategy.getNormalizedIndex(i))&&i.addClass(u),this.option("editEnabled")&&this._editProvider.isModifyingByDecorators(t.itemData)&&this._editProvider.modifyItemElement(t)},_dispose:function(){this._disposeEditProvider(),this.callBase.apply(this,arguments)},_optionChanged:function(n,t){switch(n){case"rtlEnabled":this._refreshEditProvider(),this.callBase.apply(this,arguments);break;case"items":this._clearSelectedItems(),this.callBase.apply(this,arguments);break;case"grouped":this._clearSelectedItems(),delete this._renderingGroupIndex,this._initEditStrategy(t),this.callBase.apply(this,arguments);break;case"editEnabled":this._clearSelectedItems(),this._refreshEditProvider(),this._invalidate();break;case"editConfig":this._refreshEditProvider(),this._invalidate();break;case"selectionMode":this._refreshEditProvider(),this._invalidate();break;case"selectedItems":this._normalizeSelectedItems();break;case"itemDeleteAction":case"itemSelectAction":case"itemUnselectAction":case"itemReorderAction":break;default:this.callBase.apply(this,arguments)}},_isItemSelected:function(t){return n.inArray(t,this._selectedItemIndices)>-1},_normalizeSelectedItems:function(){var n,t;this.option("selectionMode")==="single"?(n=this._editStrategy.selectedItemIndecies(this.option("selectedItems")),n.length>1?(t=[n[0]],this.option("selectedItems",this._editStrategy.fetchSelectedItems(t))):this._updateSelectedItems()):this._updateSelectedItems()},_updateSelectedItems:function(){var t=this,i=this._editStrategy.selectedItemIndecies(),u=f(this._selectedItemIndices,i),r;n.each(u,function(n,i){t._unselectItem(i)}),r=f(i,this._selectedItemIndices),n.each(r,function(n,i){t._selectItem(i)})},_updateSelectionAfterDelete:function(t){var r=this,i=n.inArray(t,this._selectedItemIndices);i>-1&&this._selectedItemIndices.splice(i,1),this._editStrategy.updateSelectionAfterDelete(t),this.option("selectedItems",this._editStrategy.fetchSelectedItems())},_selectItem:function(n){var t=this._editStrategy.getItemElement(n);this.option("editEnabled")&&n>-1&&!this._isItemSelected(n)&&(t.addClass(u),this._selectedItemIndices.push(n),t.trigger("stateChanged"),this._handleItemEvent(t,"itemSelectAction",{},{excludeValidators:["gesture","disabled"]}))},_unselectItem:function(t){var i=this._editStrategy.getItemElement(t),r=n.inArray(t,this._selectedItemIndices);this.option("editEnabled")&&r>-1&&(i.removeClass(u),this._selectedItemIndices.splice(r,1),i.trigger("stateChanged"),this._handleItemEvent(i,"itemUnselectAction",{},{excludeValidators:["gesture","disabled"]}))},_deleteItemFromDS:function(t){var u=this,r=n.Deferred(),e=this.option("disabled"),f=this._dataSource.store();if(this.option("disabled",!0),!f.remove)throw new Error("You have to implement 'remove' method in dataStore used by dxList to be able to delete items");return f.remove(f.keyOf(this._getItemData(t))).done(function(n){n!==i?r.resolveWith(u):r.rejectWith(u)}).fail(function(){r.rejectWith(u)}),r.always(function(){u.option("disabled",e)}),r},_refreshLastPage:function(){return this._expectLastItemLoading(),this._dataSource.load()},getFlatIndexByItemElement:function(n){return this._itemElements().index(n)},getItemElementByFlatIndex:function(t){var i=this._itemElements();return t<0||t>=i.length?n():i.eq(t)},getItemByIndex:function(n){return this._getItemData(this._itemElements().eq(n))},deleteItem:function(t){var i=this,r=n.Deferred(),u=this._editStrategy.getItemElement(t),s=this._editStrategy.getNormalizedIndex(t),f,o;return(this.option("editEnabled")&&s>-1?(u.addClass(e),this._dataSource?(f="dataSource",r=this._deleteItemFromDS(u)):(f="items",r.resolveWith(this))):r.rejectWith(this),r.done(function(){u.detach(),i._editStrategy.deleteItemAtIndex(s),i.optionChanged.fireWith(i,[f,i.option(f)]),i._updateSelectionAfterDelete(s),i._handleItemEvent(u,"itemDeleteAction",{},{excludeValidators:["gesture","disabled"]}),i._renderEmptyMessage()}).fail(function(){u.removeClass(e)}),this._isLastPage()||this.option("grouped"))?r.promise():(o=n.Deferred(),r.done(function(){i._refreshLastPage().done(function(){o.resolveWith(i)})}).fail(function(){o.rejectWith(i)}),o.promise())},isItemSelected:function(n){return this._isItemSelected(this._editStrategy.getNormalizedIndex(n))},selectItem:function(t){var i,u,r;this.option("editEnabled")&&(i=this._editStrategy.getNormalizedIndex(t),i!==-1)&&(u=n.inArray(i,this._selectedItemIndices),u===-1)&&(this.option("selectionMode")==="single"?this.option("selectedItems",this._editStrategy.fetchSelectedItems([i])):(r=this._selectedItemIndices.slice(),r.push(i),this.option("selectedItems",this._editStrategy.fetchSelectedItems(r))))},unselectItem:function(t){var i,r,u;this.option("editEnabled")&&(i=this._editStrategy.getNormalizedIndex(t),i!==-1)&&(r=n.inArray(i,this._selectedItemIndices),r!==-1)&&(u=this._selectedItemIndices.slice(),u.splice(r,1),this.option("selectedItems",this._editStrategy.fetchSelectedItems(u)))},reorderItem:function(t,i){var o=n.Deferred(),u=this,r=this._editStrategy,h=r.getItemElement(t),c=r.getItemElement(i),f=r.getNormalizedIndex(t),e=r.getNormalizedIndex(i),s,l=f>-1&&e>-1&&f!==e;return this.option("editEnabled")&&l?this._dataSource?(s="dataSource",o.resolveWith(this)):(s="items",o.resolveWith(this)):o.rejectWith(this),o.promise().done(function(){c[r.itemPlacementFunc(f,e)](h);var n=r.getSelectedItemsAfterReorderItem(f,e);r.moveItemAtIndexToIndex(f,e),u._selectedItemIndices=r.selectedItemIndecies(n),u.option("selectedItems",r.fetchSelectedItems()),u.optionChanged.fireWith(u,[s,u.option(s)]),u._handleItemEvent(h,"itemReorderAction",{fromIndex:r.getIndex(f),toIndex:r.getIndex(e)},{excludeValidators:["gesture","disabled"]})})}}))}(jQuery,DevExpress),function(n,t){var o=t.ui,nt=t.utils,u=o.events,s=t.fx,c=t.translator,r="dx-gallery",b=r+"-wrapper",l="dx-gallery-loop",k=r+"-container",a=r+"-active",f=r+"-item",e=f+"-loop",d="."+f,v=f+"-selected",y=r+"-indicator",h=y+"-item",p="."+h,w=h+"-selected",g="dxGalleryItemData";t.registerComponent("dxGalleryNavButton",o.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({direction:"next",clickAction:null,hoverStateEnabled:!0})},_render:function(){this.callBase();var t=this,i=this._element(),n=u.addNamespace("dxclick",this.NAME);i.addClass(r+"-nav-button-"+this.option("direction")).off(n).on(n,function(n){t._createActionByOption("clickAction")({jQueryEvent:n})})},_optionChanged:function(n,t,i){switch(n){case"clickAction":case"direction":this._invalidate();break;default:this.callBase(n,t,i)}}})),t.registerComponent("dxGallery",o.CollectionContainerWidget.inherit({_activeStateUnit:d,_setDefaultOptions:function(){this.callBase(),this.option({activeStateEnabled:!1,animationDuration:400,loop:!1,swipeEnabled:!0,indicatorEnabled:!0,showIndicator:!0,selectedIndex:0,slideshowDelay:0,showNavButtons:!1})},_dataSourceOptions:function(){return{paginate:!1}},_itemContainer:function(){return this._$container},_itemClass:function(){return f},_itemDataKey:function(){return g},_itemWidth:function(){return this._itemWidthCache||(this._itemWidthCache=this._itemElements().first().outerWidth()),this._itemWidthCache},_clearItemWidthCache:function(){delete this._itemWidthCache},_itemsCount:function(){return(this.option("items")||[]).length},_offsetDirection:function(){return this.option("rtlEnabled")?-1:1},_itemRenderDefault:function(t,i,r){r.append(n("<img />").attr("src",String(t)))},_renderSelectedIndex:n.noop,_render:function(){this._element().addClass(r),this._element().toggleClass(l,this.option("loop")),this._renderDragHandler(),this._renderWrapper(),this._renderItemContainer(),this.callBase(),this._renderContainerPosition(),this._renderItemPositions(),this._renderIndicator(),this._renderSelectedIndicatorItem(),this._renderUserInteraction(),this._renderNavButtons(),this._setupSlideShow(),this._reviseDimensions()},_dimensionChanged:function(){this._clearItemWidthCache(),this._renderDuplicateItems(),this._renderItemPositions(),this._renderContainerPosition()},_renderDragHandler:function(){var n=u.addNamespace("dragstart",this.NAME);this._element().off(n).on(n,"img",function(){return!1})},_renderWrapper:function(){this._$wrapper||(this._$wrapper=n("<div />").addClass(b).appendTo(this._element()))},_renderItems:function(n){this.callBase(n),this._renderDuplicateItems()},_renderItemContainer:function(){this._$container||(this._$container=n("<div>").addClass(k).appendTo(this._$wrapper))},_renderDuplicateItems:function(){var t=this.option("items")||[],i=t.length,r,u,n;if(i){for(this._element().find("."+e).remove(),r=this._element().width()/this._itemWidth(),u=Math.min(r,i),n=0;n<u;n++)this._renderItem(0,t[n]).addClass(e);this._renderItem(0,t[this._itemsCount()-1]).addClass(e)}},_renderItemPositions:function(){var t=this._itemWidth(),i=this._element().find("."+e).length,r=this._itemsCount()+i-1,u=this._offsetDirection();this._itemElements().each(function(i){var f=i;i===r&&(f=-1),c.move(n(this),{left:u*f*t})})},_renderContainerPosition:function(t,i){t=t||0;var r=this,e=this._itemWidth(),o=this.option("selectedIndex"),s=t-o,f=this._offsetDirection()*s*e,u;return i?(r._startSwipe(),u=r._animate(f).done(n.proxy(r._endSwipe,r))):(c.move(this._$container,{left:f}),u=n.Deferred().resolveWith(r)),u.promise()},_startSwipe:function(){this._element().addClass(a)},_endSwipe:function(){this._element().removeClass(a)},_animate:function(t,i){var r=this,u=n.Deferred();return s.animate(this._$container,n.extend({type:"slide",to:{left:t},duration:r.option("animationDuration"),complete:function(){u.resolveWith(r)}},i||{})),u},_reviseDimensions:function(){var n=this,t=n._itemElements().first();t&&(n.option("height")||n.option("height",t.outerHeight()),n.option("width")||n.option("width",t.outerWidth()),this._dimensionChanged())},_renderIndicator:function(){if(!this.option("showIndicator")){this._cleanIndicators();return}var t=this._$indicator=n("<div>").addClass(y).appendTo(this._$wrapper);n.each(this.option("items")||[],function(){n("<div>").addClass(h).appendTo(t)})},_cleanIndicators:function(){this._$indicator&&this._$indicator.remove()},_renderSelectedIndicatorItem:function(){var n=this.option("selectedIndex");this._itemElements().removeClass(v).eq(n).addClass(v),this._element().find(p).removeClass(w).eq(n).addClass(w)},_renderUserInteraction:function(){var t=this,i=t._element(),r=t.option("swipeEnabled")&&this._itemsCount()>1,e=r?"pointer":"default",f;i.dxSwipeable({disabled:this.option("disabled")||!r,startAction:n.proxy(t._handleSwipeStart,t),updateAction:n.proxy(t._handleSwipeUpdate,t),endAction:n.proxy(t._handleSwipeEnd,t),itemSizeFunc:n.proxy(t._itemWidth,t)}),f=this._createAction(this._handleIndicatorSelect);i.find(p).off(u.addNamespace("dxclick",this.NAME)).on(u.addNamespace("dxclick",this.NAME),function(n){f({jQueryEvent:n})})},_handleIndicatorSelect:function(t){var f=t.jQueryEvent,i=t.component,r;u.needSkipEvent(f)||i.option("indicatorEnabled")&&(r=n(f.target).index(),i._renderContainerPosition(i.option("selectedIndex")-r,!0).done(function(){this._suppressRenderItemPositions=!0,i.option("selectedIndex",r)}))},_renderNavButtons:function(){var t=this;if(!t.option("showNavButtons")){t._cleanNavButtons();return}t._prevNavButton=n("<div />").dxGalleryNavButton({direction:"prev",clickAction:function(){t.prevItem(!0)}}).appendTo(this._$wrapper),t._nextNavButton=n("<div />").dxGalleryNavButton({direction:"next",clickAction:function(){t.nextItem(!0)}}).appendTo(this._$wrapper),this._renderNavButtonsVisibility()},_cleanNavButtons:function(){this._prevNavButton&&this._prevNavButton.remove(),this._prevNavButton&&this._nextNavButton.remove()},_renderNavButtonsVisibility:function(){var i,r;if(this.option("showNavButtons")){var t=this.option("selectedIndex"),u=this.option("loop"),n=this._itemsCount();(this._prevNavButton.show(),this._nextNavButton.show(),u)||(i=n<2||t===n-1,r=n<2||t===0,r&&this._prevNavButton.hide(),i&&this._nextNavButton.hide())}},_setupSlideShow:function(){var n=this,t=n.option("slideshowDelay");t&&(clearTimeout(n._slideshowTimer),n._slideshowTimer=setTimeout(function(){if(n._userInteraction){n._setupSlideShow();return}n.nextItem(!0).done(n._setupSlideShow)},t))},_handleSwipeStart:function(n){var t=this._itemsCount();if(!t){n.jQueryEvent.cancel=!0;return}if(this._stopItemAnimations(),this._startSwipe(),this._userInteraction=!0,!this.option("loop")){var i=this.option("selectedIndex"),r=t-i-1,u=i,f=this.option("rtlEnabled");n.jQueryEvent.maxLeftOffset=f?u:r,n.jQueryEvent.maxRightOffset=f?r:u}},_stopItemAnimations:function(){s.isAnimating(this._$container)&&s.stop(this._$container,!0)},_handleSwipeUpdate:function(n){this._renderContainerPosition(this._offsetDirection()*n.jQueryEvent.offset)},_handleSwipeEnd:function(n){var t=n.jQueryEvent.targetOffset*this._offsetDirection();this._renderContainerPosition(t,!0).done(function(){var n=this.option("selectedIndex"),i=this._fitIndex(n-t);this._suppressRenderItemPositions=!0,this.option("selectedIndex",i),this._renderContainerPosition(),this._userInteraction=!1,this._setupSlideShow()})},_flipIndex:function(n){if(!this.option("loop"))return n;var t=this._itemsCount();return n=n%t,n>(t+1)/2&&(n-=t),n<-(t-1)/2&&(n+=t),n},_fitIndex:function(n){if(!this.option("loop"))return n;var t=this._itemsCount();return n=n%t,n<0&&(n+=t),n},_clean:function(){this.callBase(),this._cleanIndicators(),this._cleanNavButtons()},_dispose:function(){clearTimeout(this._slideshowTimer),this.callBase()},_handleSelectedIndexChanged:function(){this._suppressRenderItemPositions||this._renderContainerPosition(),this._suppressRenderItemPositions=!1,this._renderSelectedIndicatorItem(),this._renderNavButtonsVisibility()},_visibilityChanged:function(n){n&&this._dimensionChanged()},_optionChanged:function(n,t){switch(n){case"width":this.callBase.apply(this,arguments),this._dimensionChanged();break;case"animationDuration":this._renderNavButtonsVisibility();break;case"loop":this._element().toggleClass(l,t),this._renderNavButtonsVisibility();return;case"selectedIndex":this._handleSelectedIndexChanged(),this.callBase.apply(this,arguments);return;case"showIndicator":this._renderIndicator();return;case"showNavButtons":this._renderNavButtons();return;case"slideshowDelay":this._setupSlideShow();return;case"swipeEnabled":case"indicatorEnabled":this._renderUserInteraction();return;default:this.callBase.apply(this,arguments)}},goToItem:function(t,i){var r=new n.Deferred,u=this.option("selectedIndex"),f=this._itemsCount();return(t=this._fitIndex(t),t>f-1||t<0)?r.resolveWith(this).promise():(this._renderContainerPosition(u-t,i).done(function(){this._suppressRenderItemPositions=!0,this.option("selectedIndex",t),r.resolveWith(this)}),r.promise())},prevItem:function(n){return this.goToItem(this.option("selectedIndex")-1,n)},nextItem:function(n){return this.goToItem(this.option("selectedIndex")+1,n)}}))}(jQuery,DevExpress),function(n,t,i){var u=t.ui,f=t.utils,e=u.events,o=t.fx,l=t.translator,a="dx-overlay",v="dx-overlay-wrapper",y="dx-overlay-content",p="dx-overlay-shader",w="dx-overlay-modal",b="dx-rtl",s=["showingAction","shownAction","hidingAction","hiddenAction","positioningAction","positionedAction"],k=1e3,r=[],d="dx-state-disabled",h=t.devices.real(),g=h.platform==="android"&&/^4\.0(\.\d)?/.test(h.version.join("."))&&navigator.userAgent.indexOf("Chrome")===-1,nt=function(n){if(n.width(),g){var t=n.parents(),i=t.is(".dx-scrollable-native");i||(t.css("backface-visibility","hidden"),t.css("backface-visibility"),t.css("backface-visibility","visible"))}},c=function(t){return n(t instanceof n.Event?t.target:t)};t.registerComponent("dxOverlay",u.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({activeStateEnabled:!1,visible:!1,deferRendering:!0,shading:!0,shadingColor:"",position:{my:"center",at:"center",of:window},width:function(){return n(window).width()*.8},height:function(){return n(window).height()*.8},animation:{show:{type:"pop",duration:400},hide:{type:"pop",duration:400,to:{opacity:0,scale:0},from:{opacity:1,scale:1}}},closeOnOutsideClick:!1,showingAction:null,shownAction:null,hidingAction:null,hiddenAction:null,contentTemplate:"template",targetContainer:i,hideTopOverlayHandler:i,closeOnTargetScroll:!1,positioningAction:null,positionedAction:null})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){var r=t.devices.real(),u=r.platform,i=r.version;return u==="android"&&(i[0]<4||i[0]==4&&i[1]<=1)},options:{animation:{show:{type:"fade",duration:400},hide:{type:"fade",duration:400,to:{opacity:0},from:{opacity:1}}}}}])},_optionsByReference:function(){return n.extend(this.callBase(),{animation:!0})},_wrapper:function(){return this._$wrapper},_container:function(){return this._$container},_init:function(){this.callBase(),this._initActions(),this._initCloseOnOutsideClickHandler(),this._$wrapper=n("<div>").addClass(v),this._$container=n("<div>").addClass(y);var t=this._element();this._$wrapper.addClass(t.attr("class")),t.addClass(a);this._$wrapper.on("MSPointerDown",n.noop)},_clean:n.noop,_initOptions:function(n){this._initTargetContainer(n.targetContainer),this._initHideTopOverlayHandler(n.hideTopOverlayHandler),this.callBase(n)},_initTargetContainer:function(r){r=r===i?t.overlayTargetContainer():r;var f=this._element(),u=f.closest(r);u.length||(u=n(r).first()),this._$targetContainer=u.length?u:f.parent()},_targetContainer:function(){return this._$targetContainer},_initHideTopOverlayHandler:function(t){this._hideTopOverlayHandler=t!==i?t:n.proxy(this._defaultHideTopOverlayHandler,this)},_defaultHideTopOverlayHandler:function(){this.hide()},_initActions:function(){this._actions={},n.each(s,n.proxy(function(t,i){this._actions[i]=this._createActionByOption(i)||n.noop},this))},_visibilityChanged:function(n){n&&this._dimensionChanged()},_dimensionChanged:function(){this._renderGeometry()},_initCloseOnOutsideClickHandler:function(){this._documentDownHandler=n.proxy(function(){this._handleDocumentDown.apply(this,arguments)},this)},_handleDocumentDown:function(t){var i,u,f;r[r.length-1]===this._zIndex&&(i=this.option("closeOnOutsideClick"),n.isFunction(i)&&(i=i(t)),i&&(u=this._$container,f=!u.is(t.target)&&!n.contains(u.get(0),t.target),f&&(t.preventDefault(),this.hide())))},_renderVisibilityAnimate:function(t){return t&&(this._showTimestamp=n.now()),this._stopAnimation(),t?this._makeVisible():this._makeHidden()},_updateRegistration:function(t){var i,u;t?this._zIndex||(i=r.length,this._zIndex=(i?r[i-1]:k)+1,r.push(this._zIndex)):this._zIndex&&(u=n.inArray(this._zIndex,r),r.splice(u,1),delete this._zIndex)},_normalizePosition:function(){this._position=this.option("position")},_makeVisible:function(){this._normalizePosition();var r=this,i=n.Deferred(),u=r.option("animation")||{},t=u.show,f=t&&t.complete||n.noop;return this._updateRegistration(!0),t&&t.to&&(t=n.extend({type:"slide"},t),n.extend(t.to,{position:this._position})),this._isHidingActionCancelled?(delete this._isHidingActionCancelled,i.resolve()):(this._actions.showingAction(),this._$wrapper.css("z-index",this._zIndex),this._$container.css("z-index",this._zIndex),this._toggleVisibility(!0),this._animate(t,function(){f.apply(this,arguments),r._actions.shownAction(),i.resolve()})),i.promise()},_makeHidden:function(){var t=this,i=n.Deferred(),f=this.option("animation")||{},r=f.hide,e=r&&r.complete||n.noop,u={cancel:!1};return this._actions.hidingAction(u),u.cancel?(this._isHidingActionCancelled=!0,this.option("visible",!0),i.resolve()):(this._toggleShading(!1),this._animate(r,function(){t._toggleVisibility(!1),e.apply(this,arguments),t._updateRegistration(!1),t._actions.hiddenAction(),i.resolve()})),i.promise()},_animate:function(t,i){t?o.animate(this._$container,n.extend({},t,{complete:i})):i()},_stopAnimation:function(){o.stop(this._$container,!0)},_toggleVisibility:function(n){this._stopAnimation(),n||f.triggerHidingEvent(this.content()),this.callBase.apply(this,arguments),this._$container.toggle(n),this._toggleShading(n),n?(this._renderContent(),this._moveToTargetContainer(),this._renderGeometry(),f.triggerShownEvent(this.content())):this._moveFromTargetContainer(),this._toggleSubscriptions(n),this._updateRegistration(n)},_toggleShading:function(n){this._$wrapper.toggleClass(w,this.option("shading")&&!this.option("targetContainer")),this._$wrapper.toggleClass(p,n&&this.option("shading")),this._$wrapper.css("background-color",this.option("shading")?this.option("shadingColor"):"")},_toggleSubscriptions:function(n){this._toggleHideTopOverlayCallback(n),this._toggleDocumentDownHandler(n),this._toggleParentsScrollSubscription(n)},_toggleHideTopOverlayCallback:function(n){this._hideTopOverlayHandler&&(n?t.hideTopOverlayCallback.add(this._hideTopOverlayHandler):t.hideTopOverlayCallback.remove(this._hideTopOverlayHandler))},_toggleDocumentDownHandler:function(t){var r=this,i=e.addNamespace("dxpointerdown",r.NAME);if(t)n(document).on(i,this._documentDownHandler);else n(document).off(i,this._documentDownHandler)},_toggleParentsScrollSubscription:function(n){var i=this._position;if(i&&i.of){var t=this,r=t.option("closeOnTargetScroll"),u=e.addNamespace("scroll",t.NAME),f=c(i.of).parents().add(window);t._proxiedTargetScrollHandler=t._proxiedTargetScrollHandler||function(){return t._targetScrollHandler.apply(t,arguments)},f[n&&r?"on":"off"](u,t._proxiedTargetScrollHandler)}},_targetScrollHandler:function(t){var i=this.option("closeOnTargetScroll"),r=!1;n.isFunction(i)&&(r=i(t)),r||this.hide()},_renderContent:function(){this._contentAlreadyRendered||!this.option("visible")&&this.option("deferRendering")||(this._contentAlreadyRendered=!0,this.callBase())},_renderContentImpl:function(n){var t=this._element(),i=n||this._getTemplate(this.option("contentTemplate"));this._$container.append(t.contents()).appendTo(t),i&&i.render(this.content())},_fireContentReadyAction:function(){this.option("visible")&&this._moveToTargetContainer(),this.callBase.apply(this,arguments)},_moveFromTargetContainer:function(){this._$container.appendTo(this._element()),this._detachWrapperToTargetContainer()},_detachWrapperToTargetContainer:function(){this._$wrapper.detach()},_moveToTargetContainer:function(){this._attachWrapperToTargetContainer(),this._$container.appendTo(this._$wrapper)},_attachWrapperToTargetContainer:function(){var n=this._element();!this._$targetContainer||this._$targetContainer[0]===n.parent()[0]?this._$wrapper.appendTo(n):this._$wrapper.appendTo(this._$targetContainer)},_renderGeometry:function(){this.option("visible")&&this._renderGeometryImpl()},_renderGeometryImpl:function(){this._stopAnimation(),this._normalizePosition(),this._renderShading(),this._renderDimensions(),this._renderPosition()},_renderShading:function(){var n=this._$wrapper,t=this._getTargetContainer();n.css("position",t.get(0)===window?"fixed":"absolute"),this.option("shading")&&n.show(),this._renderShadingDimensions(),this._renderShadingPosition()},_renderShadingPosition:function(){if(this.option("shading")){var n=this._getTargetContainer();t.position(this._$wrapper,{my:"top left",at:"top left",of:n})}},_renderShadingDimensions:function(){if(this.option("shading")){var n=this._getTargetContainer();this._$wrapper.css({width:n.outerWidth(),height:n.outerHeight()})}},_getTargetContainer:function(){var n=this._position,t=this.option("targetContainer"),i=n?n.of:null;return c(t||i)},_renderDimensions:function(){this._$container.outerWidth(this.option("width")).outerHeight(this.option("height"))},_renderPosition:function(){var i,n,r;l.resetPosition(this._$container),i=this._position,n=t.calculatePosition(this._$container,i),this._actions.positioningAction({position:n}),r=t.position(this._$container,n),this._actions.positionedAction({position:r}),nt(this._$container)},_dispose:function(){this._stopAnimation(),this._toggleSubscriptions(!1),this._updateRegistration(!1),this._actions=null,this.callBase(),this._$wrapper.remove(),this._$container.remove()},_toggleDisabledState:function(n){this.callBase.apply(this,arguments),this._$container.toggleClass(d,n)},_toggleRTLDirection:function(n){this._$container.toggleClass(b,n)},_optionChanged:function(t,i){if(n.inArray(t,s)>-1){this._initActions();return}switch(t){case"shading":case"shadingColor":this._toggleShading(this.option("visible"));break;case"width":case"height":case"position":this._renderGeometry();break;case"visible":this._renderVisibilityAnimate(i).done(n.proxy(function(){this._animateDeferred&&(this._animateDeferred.resolveWith(this),delete this._animateDeferred)},this));break;case"targetContainer":this._initTargetContainer(i),this._invalidate();break;case"deferRendering":case"contentTemplate":this._invalidate();break;case"closeOnOutsideClick":this._toggleDocumentDownHandler(this.option("visible"));break;case"closeOnTargetScroll":this._toggleParentsScrollSubscription(this.option("visible"));break;case"animation":break;case"rtlEnabled":this._toggleRTLDirection(i);break;default:this.callBase.apply(this,arguments)}},toggle:function(t){if(t=t===i?!this.option("visible"):t,t===this.option("visible"))return n.Deferred().resolve().promise();var r=n.Deferred();return this._animateDeferred=r,this.option("visible",t),r.promise()},show:function(){return this.toggle(!0)},hide:function(){return this.toggle(!1)},content:function(){return this._$container},repaint:function(){this._renderGeometry()}}))}(jQuery,DevExpress),function(n,t){var f=t.ui,u="dx-toast",r=u+"-",e=r+"wrapper",o=r+"content",s=r+"message",h=r+"icon",c="dxToast",l=["info","warning","error","success"];t.registerComponent(c,f.dxOverlay.inherit({_setDefaultOptions:function(){this.callBase(),this.option({message:"",type:"info",displayTime:2e3,position:{my:"bottom center",at:"bottom center",of:window,offset:"0 -20"},animation:{show:{type:"fade",duration:400,from:0,to:1},hide:{type:"fade",duration:400,to:0}},shading:!1,height:"auto"})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{platform:"win8"},options:{position:{my:"top center",at:"top center",of:window,offset:"0 0"},width:function(){return n(window).width()}}}])},_renderContentImpl:function(){this.option("message")&&(this._message=n("<div>").addClass(s).text(this.option("message")).appendTo(this.content())),n.inArray(this.option("type").toLowerCase(),l)>-1&&this.content().prepend(n("<div>").addClass(h)),this.callBase()},_render:function(){this.callBase(),this._element().addClass(u),this._wrapper().addClass(e),this._$container.addClass(r+String(this.option("type")).toLowerCase()),this.content().addClass(o)},_makeVisible:function(){return this.callBase.apply(this,arguments).done(n.proxy(function(){clearTimeout(this._hideTimeout),this._hideTimeout=setTimeout(n.proxy(function(){this.hide()},this),this.option("displayTime"))},this))},_dispose:function(){clearTimeout(this._hideTimeout),this.callBase()},_optionChanged:function(n,t,i){switch(n){case"type":this._$container.removeClass(r+i),this._$container.addClass(r+String(t).toLowerCase());break;case"message":this._message&&this._message.text(t);break;case"displayTime":break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var f=t.ui,o=f.events,r=t.translator,s="dx-popup",a="dx-popup-wrapper",h="dx-popup-fullscreen",v="dx-popup-content",y="dx-popup-draggable",c="dx-popup-title",l="."+c,p="dx-closebutton",w="dx-popup-title-has-button",u="dx-popup-bottom",b="dx-toolbar-before",k="dx-toolbar-after",g=".dx-overlay-content",e=40,d=function(i){var f=t.devices.current(i),r={cancel:{subclass:"dx-popup-cancel"},clear:{subclass:"dx-popup-clear"},done:{subclass:"dx-popup-done"}};return f.ios&&(n.extend(r.cancel,{parent:l,wraperClass:b}),n.extend(r.clear,{parent:l,wraperClass:k}),n.extend(r.done,{wraperClass:u})),(f.android||f.platform==="desktop"||f.win8||f.tizen||f.generic)&&(n.extend(r.cancel,{wraperClass:u}),n.extend(r.clear,{wraperClass:u}),n.extend(r.done,{wraperClass:u})),r};t.registerComponent("dxPopup",f.dxOverlay.inherit({_setDefaultOptions:function(){this.callBase(),this.option({title:"",showTitle:!0,fullScreen:!1,titleTemplate:"title",dragEnabled:!1,cancelButton:null,doneButton:null,clearButton:null,closeButton:null})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{platform:"win8"},options:{width:function(){return n(window).width()}}},{device:{platform:"win8",phone:!0},options:{position:{my:"top center",at:"top center",of:window,offset:"0 0"}}},{device:[{platform:"ios"},{platform:"ios7"}],options:{animation:this._iosAnimation}},{device:function(n){return t.devices.real().platform==="generic"&&n.platform==="generic"},options:{dragEnabled:!0}}])},_iosAnimation:{show:{type:"slide",duration:400,from:{position:{my:"top",at:"bottom",of:window}},to:{position:{my:"center",at:"center",of:window}}},hide:{type:"slide",duration:400,from:{opacity:1,position:{my:"center",at:"center",of:window}},to:{opacity:1,position:{my:"top",at:"bottom",of:window}}}},_init:function(){this.callBase(),this._$content=this._container().wrapInner(n("<div />").addClass(v)).children().eq(0)},_render:function(){this._element().addClass(s),this._wrapper().addClass(a),this._container().toggleClass(y,this.option("dragEnabled")).toggleClass(h,this.option("fullScreen")),this.callBase()},_renderContentImpl:function(){this.callBase(this.option("_templates").content),this._renderTitle(),this._renderDrag(),this._renderButtons()},_renderTitle:function(){if(this.option("showTitle")){if(this._$title=this._$title||n("<div />").addClass(c),this._$title.empty(),this._element().append(this._$title),this.option("title"))this._defaultTitleRender();else{var t=this._getTemplateByOption("titleTemplate");t&&t.render(this._$title)}this._$title.prependTo(this._container())}else this._$title&&this._$title.detach()},_renderDrag:function(){if(this._$title){var t=o.addNamespace("dxdragstart",this.NAME),i=o.addNamespace("dxdrag",this.NAME);if(this._$title.off(t).off(i),this.option("dragEnabled"))this._$title.on(t,n.proxy(this._handleTitleDragStart,this)).on(i,n.proxy(this._handleTitleDragUpdate,this))}},_handleTitleDragStart:function(n){n.targetElements=[],this._prevOffset={x:0,y:0},this._dragHandled=!0;var t=r.locate(this._container()),i=this._allowedOffsets();n.maxLeftOffset=t.left+i.left,n.maxRightOffset=-t.left+i.right,n.maxTopOffset=t.top+i.top,n.maxBottomOffset=-t.top+i.bottom},_handleTitleDragUpdate:function(n){var i=r.locate(this._container()),t=n.offset,u=this._prevOffset;r.move(this._container(),{left:i.left+(t.x-u.x),top:i.top+(t.y-u.y)}),this._prevOffset=t},_allowedOffsets:function(){var t=this._container(),n=this._targetContainer(),i=t.outerWidth(),r=n.width(),u=n.height();return{top:0,bottom:u-e,left:i-e,right:r-e}},_renderButtons:function(){var n=t.devices.current().win8?["Close","Done","Clear","Cancel"]:["Close","Cancel","Clear","Done"],i;for(n.extractButtonName=this.option("rtlEnabled")?n.pop:n.shift;!!n.length;)i=n.extractButtonName(),this["_render"+i+"Button"]()},_defaultTitleRender:function(){this._$title.text(this.option("title"))},_renderCloseButton:function(){var t=!this.option("_templates").title&&!!this.option("closeButton")&&this.option("showTitle"),i;this._$title&&this._$title.toggleClass(w,t),t&&(i=this._createButtonAction(),n("<div/>").addClass(p).on(f.events.addNamespace("dxclick",this.NAME+"TitleCloseButton"),function(n){i({jQueryEvent:n})}).appendTo(this._$title))},_renderCancelButton:function(){this._renderSpecificButton(this.option("cancelButton"),{type:"cancel",text:Globalize.localize("Cancel")})},_renderClearButton:function(){this._renderSpecificButton(this.option("clearButton"),{type:"clear",text:Globalize.localize("Clear")})},_renderDoneButton:function(){this._renderSpecificButton(this.option("doneButton"),{type:"done",text:Globalize.localize("Done")})},_renderSpecificButton:function(n,t){var r=this._getRenderButtonParams(t.type),i;(this._removeButton(r),this._wrapper().toggleClass(s+"-"+t.type+"-visible",!!n),n)&&(i=this.option(t.type+"Button"),this._renderButton({text:i.text||t.text,clickAction:this._createButtonAction(i.clickAction)},r))},_createButtonAction:function(n){return this._createAction(n,{afterExecute:function(n){n.component.hide()}})},_getRenderButtonParams:function(t){return n.extend({},d()[t])},_renderButton:function(t,i){var f=n("<div/>").addClass(i.subclass).dxButton(t),e=i.parent?this._container().find(i.parent):this._container(),r=this._container().find("."+i.wraperClass);r.length||(r=n("<div/>").addClass(i.wraperClass).appendTo(e)),f.appendTo(r),this._container().find("."+u).addClass(i.subclass)},_removeButton:function(n){var t="."+(n.subclass||n.wraperClass);this.content()&&this.content().removeClass(n.subclass),this._container().find(t).remove()},_renderGeometryImpl:function(){this.callBase.apply(this,arguments),this._setContentHeight()},_renderDimensions:function(){this.option("fullScreen")?this._container().css({width:"100%",height:"100%"}):this.callBase.apply(this,arguments)},_renderShadingDimensions:function(){this.option("fullScreen")?this._wrapper().css({width:"100%",height:"100%"}):this.callBase.apply(this,arguments)},_renderPosition:function(){if(this.option("fullScreen"))r.move(this._container(),{top:0,left:0});else if(this._dragHandled){var t=this._container(),i=r.locate(t),n=this._allowedOffsets();r.move(t,{top:Math.min(Math.max(-n.top,i.top),n.bottom),left:Math.min(Math.max(-n.left,i.left),n.right)})}else this.callBase.apply(this,arguments)},_setContentHeight:function(){var t;if(this._$content){var n=this._$container.height(),i=this.option("cancelButton")||this.option("doneButton")||this.option("clearButton"),r=this._$wrapper.find(".dx-popup-bottom");this._$title&&(n-=this._$title.outerHeight(!0)||0),i&&(t=r.outerHeight(!0)||0,n-=t,this._$content.css("margin-bottom",t)),this.option("height")==="auto"?this._$content.css("height","auto"):n>0&&this._$content.css("height",n)}},_optionChanged:function(n,t){switch(n){case"visible":delete this._dragHandled,this.callBase.apply(this,arguments);break;case"showTitle":case"title":case"titleTemplate":this._renderTitle(),this._renderCloseButton(),this._setContentHeight();break;case"dragEnabled":this._renderDrag();break;case"cancelButton":this._renderCancelButton();break;case"clearButton":this._renderClearButton();break;case"doneButton":this._renderDoneButton();break;case"closeButton":this._renderCloseButton();break;case"height":this.callBase.apply(this,arguments),this._setContentHeight();break;case"fullScreen":this._container().toggleClass(h,t),this._refresh();break;default:this.callBase.apply(this,arguments)}},content:function(){return this._$content},container:function(){return this._$container}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,u=t.fx,f="dx-popover",e="dx-popover-wrapper",o="dx-popover-arrow",s="dx-popover-without-title",h={left:"right",top:"bottom",right:"left",bottom:"top"},c={top:{my:"bottom center",at:"top center"},bottom:{my:"top center",at:"bottom center"},right:{my:"left center",at:"right center"},left:{my:"right center",at:"left center"},topNone:{my:"bottom center",at:"top center",collision:"none"},bottomNone:{my:"top center",at:"bottom center",collision:"none"},rightNone:{my:"left center",at:"right center",collision:"none"},leftNone:{my:"right center",at:"left center",collision:"none"}},l="10 10";t.registerComponent("dxPopover",r.dxPopup.inherit({_setDefaultOptions:function(){this.callBase(),this.option({target:window,shading:!1,position:"bottom",closeOnOutsideClick:n.proxy(this._isOutsideClick,this),animation:{show:{type:"fade",from:0,to:1},hide:{type:"fade",to:0}},showTitle:!1,width:"auto",height:"auto",dragEnabled:!1,fullScreen:!1,closeOnTargetScroll:!0})},_defaultOptionsRules:function(){return[]},_render:function(){this._element().addClass(f),this._wrapper().addClass(e),this._renderArrow(),this.callBase()},_renderArrow:function(){this._$arrow=n("<div>").addClass(o).appendTo(this._wrapper())},_setContentHeight:function(n){n&&this.callBase()},_updateContentSize:function(n){var t,r,u,i;this._$content&&(t=this._position.at.split(" ")[0],n.h.oversize>0&&(t==="left"||t==="right")&&(r=this._$container.width()-n.h.oversize,this._$container.width(r)),n.v.oversize>0&&(t==="top"||t==="bottom")&&(u=this._$title?this._$title.outerHeight():0,i=this._$container.height()-n.v.oversize,this._$container.height(i),this._$content.outerHeight(i-u)))},_isOutsideClick:function(t){return!n(t.target).closest(this.option("target")).length},_animate:function(i){i&&t.fx.animate(this._$arrow,n.extend({},i,{complete:n.noop})),i&&i.to&&n.extend(i.to,{position:this._contentPosition}),this.callBase.apply(this,arguments)},_stopAnimation:function(){this.callBase.apply(this,arguments),u.stop(this._$arrow)},_renderTitle:function(){this._wrapper().toggleClass(s,!this.option("showTitle")),this.callBase()},_isPopoverLargerThanTarget:function(){var u=this._position.at.split(" ")[0],r=n(this._position.of),t,i;switch(u){case"top":case"bottom":t=this._$container.width(),i=r.outerWidth()+this._$arrow.width();break;case"left":case"right":t=this._$container.height(),i=r.outerHeight()+this._$arrow.height()}return t>i/2},_renderPosition:function(){this.callBase(),this._renderOverlayPosition(),this._renderArrowPosition()},_renderOverlayPosition:function(){var e;this._setContentHeight(!0),this._togglePositionClass("dx-position-"+this._positionAlias),t.translator.move(this._$arrow,{left:0,top:0}),t.translator.move(this._$container,{left:0,top:0});var i=n.extend({},this._position),o=n.extend({},i,{offset:this._$arrow.width()+" "+this._$arrow.height()}),r=t.calculatePosition(this._$container,o),u=r.v.flip,f=r.h.flip;this._updateContentSize(r),this._position.collision==="flip"&&(i.collision="fit"),e="dx-position-"+(u||f?h[this._positionAlias]:this._positionAlias),this._togglePositionClass(e),(u||f)&&n.extend(i,{my:i.at,at:i.my}),i.offset=this._updateContentOffset(u,f,i.offset),t.position(this._$container,i),this._contentPosition=i},_renderArrowPosition:function(){var f=this._isPopoverLargerThanTarget(),u=this._contentPosition.my.split(" ")[0],r=this._contentPosition.at.split(" ")[0],i;f?i={my:u,at:r,of:n(this.option("target"))}:(i=r,i={my:r,at:u,of:this._$container,offset:this._updateArrowOffset(i)}),i.my+=" center",i.at+=" center",t.position(this._$arrow,i)},_renderShadingPosition:function(){this.option("shading")&&this._$wrapper.css({top:0,left:0})},_renderShadingDimensions:function(){this.option("shading")&&this._$wrapper.css({width:"100%",height:"100%"})},_togglePositionClass:function(n){this._$wrapper.removeClass("dx-position-left dx-position-right dx-position-top dx-position-bottom"),this._$wrapper.addClass(n)},_normalizePosition:function(){var i=this.option("position");t.utils.isString(i)&&(i=n.extend({},c[i])),i.of||(i.of=this.option("target")),i.collision||(i.collision="flip"),i.boundaryOffset||(i.boundaryOffset=l),this._positionAlias=i.at.split(" ")[0],this._position=i},_getOffsetObject:function(n){var i=t.utils.stringPairToObject(n);return{h:i.x,v:i.y}},_updateContentOffset:function(n,t,i){var r=this._positionAlias,u=this._getOffsetObject(i),f=r==="top"&&!n||r==="bottom"&&n,e=r==="bottom"&&!n||r==="top"&&n,o=r==="left"&&!t||r==="right"&&t,s=r==="right"&&!t||r==="left"&&t;return f?u.h+" "+(u.v-(this._$arrow.height()-1)):e?u.h+" "+(u.v+(this._$arrow.height()-1)):o?u.h-(this._$arrow.width()-1)+" "+u.v:s?u.h+(this._$arrow.width()-1)+" "+u.v:void 0},_updateArrowOffset:function(n){switch(n){case"top":return"0 -1";case"bottom":return"0 1";case"left":return"-1 0";case"right":return"1 0"}},_optionChanged:function(n,t){switch(n){case"showTitle":case"title":case"titleTemplate":this.callBase.apply(this,arguments),this._normalizePosition(),this._renderPosition();break;case"target":this._normalizePosition(),this._renderPosition();break;case"fullScreen":t&&this.option("fullScreen",!1);break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var u=t.ui,r="dx-tooltip",f=r+"-wrapper";t.registerComponent("dxTooltip",u.dxPopover.inherit({_setDefaultOptions:function(){this.callBase(),this.option({showTitle:!1,title:i,titleTemplate:i})},_render:function(){this._element().addClass(r),this._wrapper().addClass(f),this.callBase()}}))}(jQuery,DevExpress),function(n,t,i){var u=t.ui,s=u.events,f=t.fx,g=t.utils,y=t.translator,h=t.support.transitionEndEventName,r="dx-slider",p=r+"-wrapper",c=r+"-handle",w="."+c,b=r+"-bar",l=r+"-range",k=l+"-visible",e=r+"-label",o=e+"-position-",a=r+"-tooltip",v=a+"-position-",d=a+"-on-hover-enabled";t.registerComponent("dxSliderHandle",u.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({activeStateEnabled:!1,hoverStateEnabled:!1,value:50,tooltipEnabled:!1,tooltipFormat:function(n){return n},tooltipPosition:"top",tooltipShowMode:"onHover",tooltipFitIn:null})},_render:function(){this.callBase(),this._element().addClass(c),this._renderTooltip()},_renderTooltip:function(){this.option("tooltipEnabled")?(this._$tooltip||(this._$tooltip=n("<div>").appendTo(this._element()).dxTooltip({visible:!0,height:i,target:this._element(),closeOnOutsideClick:!1,closeOnTargetScroll:!1,targetContainer:this._element(),hideTopOverlayHandler:null}),this._tooltip=this._$tooltip.dxTooltip("instance")),this._renderTooltipPosition(),this._renderTooltipShowMode(),this._renderValue()):this._removeTooltip()},_visibilityChanged:function(){this._dimensionChanged()},_dimensionChanged:function(){this._repaintTooltip()},_removeTooltip:function(){this._$tooltip&&(this._$tooltip.remove(),delete this._$tooltip,delete this._tooltip)},_renderTooltipPosition:function(){if(this._tooltip){var t=this.option("tooltipPosition");n.type(t)==="string"&&(t=t+"None"),this._tooltip.option("position",t)}},_repaintTooltip:function(){this._tooltip&&this._tooltip.repaint()},_renderValue:function(){if(this._tooltip){var n=this.option("tooltipFormat"),t=n(this.option("value"));this._tooltip.content().html(t),this._fitTooltipPosition()}},_renderTooltipShowMode:function(){this._element().toggleClass("dx-slider-tooltip-on-hover",/^onhover$/i.test(this.option("tooltipShowMode")))},_fitTooltipPosition:function(){if(this._$tooltip){var n=this._tooltip.content().parent(),o=n.outerWidth(),t=this.option("tooltipFitIn"),s=t.outerWidth(),i=t.offset().left,h=i+s,r=this._element(),u=r.outerWidth(),f=r.offset().left,c=f+u,e=Math.round(u/2-o/2),l=Math.ceil(i-f),a=Math.floor(h-c)+e*2,v=Math.min(Math.max(l,e),a);y.move(n,{left:v})}},_optionChanged:function(n){switch(n){case"tooltipFormat":this._renderValue();break;case"value":this._renderValue();break;case"tooltipEnabled":this._renderTooltip();break;case"tooltipPosition":this._renderTooltipPosition();break;case"tooltipShowMode":this._renderTooltipShowMode();break;case"tooltipFitIn":this._fitTooltipPosition();break;default:this.callBase.apply(this,arguments)}},fitTooltipPosition:function(){this._fitTooltipPosition()},repaint:function(){this._repaintTooltip(),this._renderTooltipPosition(),this._fitTooltipPosition()}})),t.registerComponent("dxSlider",u.dxEditor.inherit({_activeStateUnit:w,_setDefaultOptions:function(){this.callBase(),this.option({min:0,max:100,step:1,value:50,showRange:!0,tooltip:{enabled:!1,format:function(n){return n},position:"top",showMode:"onHover"},label:{visible:!1,position:"bottom",format:function(n){return n}}})},_render:function(){this._element().addClass(r),this._renderBar(),this._renderRange(),this._renderWrapper(),this._$wrapper.dxSwipeable({elastic:!1,startAction:n.proxy(this._handleSwipeStart,this),updateAction:n.proxy(this._handleSwipeUpdate,this),endAction:n.proxy(this._handleSwipeEnd,this),itemSizeFunc:n.proxy(this._itemWidthFunc,this)}),this._renderHandle(),this.callBase(),this._renderValue(),this._renderLabels(),this._renderStartHandler()},_visibilityChanged:function(){this.repaint()},_renderWrapper:function(){this._$wrapper=n("<div>").addClass(p).append(this._$bar).appendTo(this._element())},_renderBar:function(){this._$bar=n("<div>").addClass(b);this._$bar.off(h+"."+this.NAME).on(h,n.proxy(this._fitHandleTooltipPosition,this))},_renderRange:function(){this._$selectedRange=n("<div>").addClass(l).appendTo(this._$bar),this._renderRangeVisibility()},_renderRangeVisibility:function(){this._$selectedRange.toggleClass(k,Boolean(this.option("showRange")))},_renderHandle:function(){this._$handle=this._renderHandleImpl(this.option("value"),this._$handle)},_renderHandleImpl:function(i,r){var e=r||n("<div>").appendTo(this._$selectedRange),o=this._normalizeFormat(this.option("tooltip.format")),u=this.option("tooltip.enabled"),f=this.option("tooltip.position");return this._element().toggleClass(d,u&&t.devices.real().platform!=="ios").toggleClass(v+"bottom",u&&f==="bottom").toggleClass(v+"top",u&&f==="top"),e.dxSliderHandle({value:i,tooltipEnabled:u,tooltipPosition:f,tooltipFormat:o,tooltipShowMode:this.option("tooltip.showMode"),tooltipFitIn:this._element()})},_renderLabels:function(){if(this._element().removeClass(o+"bottom").removeClass(o+"top"),this.option("label.visible")){var i=this.option("min"),r=this.option("max"),u=this.option("label.position"),t=this._normalizeFormat(this.option("label.format"));this._$minLabel||(this._$minLabel=n("<div>").addClass(e).appendTo(this._$wrapper)),this._$minLabel.html(t(i)),this._$maxLabel||(this._$maxLabel=n("<div>").addClass(e).appendTo(this._$wrapper)),this._$maxLabel.html(t(r)),this._element().addClass(o+u)}else this._$minLabel&&(this._$minLabel.remove(),delete this._$minLabel),this._$maxLabel&&(this._$maxLabel.remove(),delete this._$maxLabel)},_normalizeFormat:function(t){var i=t;return i=typeof t=="string"?function(n){return Globalize.format(n,t)}:n.isFunction(t)?n.proxy(i,this):function(n){return n}},_renderDimensions:function(){if(this.callBase(),this._$bar){var n=this._$bar.outerWidth(!0)-this._$bar.outerWidth();this._$bar.width(this.option("width")-n)}},_renderStartHandler:function(){var t=s.addNamespace("dxpointerdown",this.NAME),i=this._createAction(n.proxy(this._handleStart,this),{excludeValidators:["gesture"]});this._element().off(t).on(t,function(n){n.preventDefault(),i({jQueryEvent:n})})},_itemWidthFunc:function(){return this._element().width()/this._swipePixelRatio()},_handleSwipeStart:function(n){var r=this.option("rtlEnabled"),t,i;this._startOffset=this._currentRatio,t=this._startOffset*this._swipePixelRatio(),i=(1-this._startOffset)*this._swipePixelRatio(),n.jQueryEvent.maxLeftOffset=r?i:t,n.jQueryEvent.maxRightOffset=r?t:i,this._swipeHandled=!0},_handleSwipeEnd:function(n){var t=this.option("rtlEnabled")?-1:1;delete this._swipeHandled,this._changeValueOnSwipe(this._startOffset+t*n.jQueryEvent.targetOffset/this._swipePixelRatio()),delete this._startOffset,this._renderValue()},_activeHandle:function(){return this._$handle},_handleSwipeUpdate:function(n){this._valueChangeEventInstance=n,this._updateHandlePosition(n)},_updateHandlePosition:function(n){var i=this.option("rtlEnabled")?-1:1,t=this._startOffset+i*n.jQueryEvent.offset/this._swipePixelRatio();this._$selectedRange.width(t*100+"%"),this._changeValueOnSwipe(t)},_swipePixelRatio:function(){var n=this.option("min"),t=this.option("max"),i=this._valueStep();return(t-n)/i},_valueStep:function(){var n=this.option("step");return(!n||isNaN(n))&&(n=1),n=parseFloat(n.toFixed(5)),n===0&&(n=1e-5),n},_changeValueOnSwipe:function(n){var t=this.option("min"),u=this.option("max"),r=this._valueStep(),o=n*(u-t),i=t+o,f,e;r<0||(i===u||i===t?this.option("value",i):(f=(r+"").split("."),e=f.length>1?f[1].length:e,i=Number((Math.round(o/r)*r+t).toFixed(e)),this.option("value",Math.max(Math.min(i,u),t))))},_handleStart:function(n){var t=n.jQueryEvent;s.needSkipEvent(t)||(this._feedbackOn(this._activeHandle(),!0),this._currentRatio=(u.events.eventData(t).x-this._$bar.offset().left)/this._$bar.width(),this.option("rtlEnabled")&&(this._currentRatio=1-this._currentRatio),this._valueChangeEventInstance=t,this._changeValueOnSwipe(this._currentRatio))},_renderValue:function(){var i=this.option("value"),n=this.option("min"),t=this.option("max"),r;if(!(n>t)){if(i<n){this.option("value",n),this._currentRatio=0;return}if(i>t){this.option("value",t),this._currentRatio=1;return}r=n===t?0:(i-n)/(t-n),this._animateRange({width:r*100+"%"}),this._currentRatio=r,this._activeHandle().dxSliderHandle("option","value",this.option("value"))}},_animateRange:function(t){f.stop(this._$selectedRange),this._swipeHandled||f.animate(this._$selectedRange,{type:"custom",duration:100,to:t,complete:n.proxy(this._fitHandleTooltipPosition,this)})},_fitHandleTooltipPosition:function(){this._activeHandle()&&this._activeHandle().dxSliderHandle("fitTooltipPosition")},_repaintHandle:function(){this._$handle.dxSliderHandle("repaint")},_optionChanged:function(n){switch(n){case"visible":this.callBase.apply(this,arguments),this._renderHandle(),this._repaintHandle();break;case"min":case"max":this._renderValue(),this._renderLabels();break;case"step":this._renderValue();break;case"value":this._renderValue(),this.callBase.apply(this,arguments);break;case"showRange":this._renderRangeVisibility();break;case"tooltip":this._renderHandle();break;case"label":this._renderLabels();break;case"rtlEnabled":this._toggleRTLDirection(),this._renderValue();break;default:this.callBase.apply(this,arguments)}},_dispose:function(){f.stop(this._$selectedRange),this.callBase.apply(this,arguments)},_refresh:function(){this._renderDimensions(),this._renderValue(),this._renderHandle()},_feedbackOff:function(n,t){(!n||t)&&this.callBase.apply(this,arguments)}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,f=r.events,o="dx-slider-handle",u="dx-range-slider",e=u+"-start-handle";t.registerComponent("dxRangeSlider",r.dxSlider.inherit({_setDefaultOptions:function(){this.callBase(),this.option({start:40,end:60,value:50})},_render:function(){this.callBase(),this._element().addClass(u)},_renderHandle:function(){this._$handleStart=this._renderHandleImpl(this.option("start"),this._$handleStart).addClass(e),this._$handleEnd=this._renderHandleImpl(this.option("end"),this._$handleEnd)},_handleStart:function(n){var i=n.jQueryEvent,t=this._$selectedRange,r=t.width(),u=f.eventData(i).x-this._$bar.offset().left,e=t.position().left,o=t.position().left+r,s=this.option("rtlEnabled"),h=(s?-1:1)*((e+o)/2-u)>0;this._feedbackOff(!0,!0),this._capturedHandle=h?this._$handleStart:this._$handleEnd,this.callBase(n)},_activeHandle:function(){return this._capturedHandle},_updateHandlePosition:function(n){var o=this.option("rtlEnabled"),s=o?-1:1,f=this.option("max"),i=this.option("min"),t=this._startOffset+s*n.jQueryEvent.offset/this._swipePixelRatio(),t=t.toPrecision(12),h=t*(f-i)+i,u,e,r;this._updateSelectedRangePosition(t,t),this._changeValueOnSwipe(t),u=this.option("start"),e=this.option("end"),u===e&&(r=h<u?this._$handleStart:this._$handleEnd,r&&r!==this._capturedHandle&&(this._updateSelectedRangePosition((u-i)/(f-i),(e-i)/(f-i)),this._feedbackOff(!0,!0),this._feedbackOn(r,!0),this._capturedHandle=r),this._updateSelectedRangePosition(t,t),this._changeValueOnSwipe(t))},_updateSelectedRangePosition:function(n,t){var i=this.option("rtlEnabled"),r=this._capturedHandle===this._$handleStart&&i||this._capturedHandle===this._$handleEnd&&!i,u=r?"right":"left";i^r?this._$selectedRange.css(u,100-t*100+"%"):this._$selectedRange.css(u,n*100+"%")},_changeValueOnSwipe:function(n){this._suppressValueChangeAction(),this.callBase(n),this._resumeValueChangeAction();var f=this._capturedHandle===this._$handleStart?"start":"end",t=this.option("start"),u=this.option("end"),r=this.option("value"),i=this.option("max"),e=this.option("min");t>i&&(t=i,this.option("start",i)),t<e&&(t=e,this.option("start",e)),u>i&&(u=i,this.option("end",i)),r>u&&f==="start"&&(r=u),r<t&&f==="end"&&(r=t),this.option(f,r)},_renderValue:function(){var i=this.option("start"),r=this.option("end"),n=this.option("min"),t=this.option("max"),u=this.option("rtlEnabled");i=Math.max(n,Math.min(i,t)),r=Math.max(i,Math.min(r,t)),this.option("start",i),this.option("end",r);var o=t===n?0:(i-n)/(t-n),s=t===n?0:(r-n)/(t-n),f=parseFloat((o*100).toPrecision(12))+"%",e=parseFloat(((1-s)*100).toPrecision(12))+"%";this._animateRange({right:u?f:e,left:u?e:f}),this._renderHandle()},_repaintHandle:function(){this._$handleStart.dxSliderHandle("repaint"),this._$handleEnd.dxSliderHandle("repaint")},_optionChanged:function(n){switch(n){case"start":case"end":this._renderValue(),this._createActionByOption("valueChangeAction")({start:this.option("start"),end:this.option("end")});break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,e=t.fx,h=t.support,c=f.events,r=t.utils,y="dx-calendar",p="dx-calendar-body",w="dx-calendar-navigator",b="dx-calendar-other-month",k="dx-calendar-empty-cell",l="dx-calendar-disabled-navigator-link",d="dx-calendar-today",a="dx-calendar-selected-date",v="dx-calendar-contoured-date",g="dx-calendar-navigator-previous-year",nt="dx-calendar-navigator-previous-month",tt="dx-calendar-navigator-next-month",it="dx-calendar-navigator-next-year",o="dxCalendar.MonthView.ValueChanged",s="dxCalendar.MonthView.ContouredDateChanged",u=c.addNamespace("dxclick","dxCalendar"),rt=c.addNamespace("blur","dxCalendar"),ut=t.Class.inherit({ctor:function(n){this.date=n.date||new Date,this.rtl=n.rtl},render:function(n){this.rootElement=n,this.renderCore()},renderCore:n.noop}),ft={MonthView:ut.inherit({ctor:function(n){n=n||{},this.callBase(n),this.firstDayOfWeek=n.firstDayOfWeek||0,n.keyDownProcessor&&!n.disabled&&(this.keyDownProcessor=n.keyDownProcessor.reinitialize(this.keyDownHandler,this)),n.contouredDate&&(this.contouredDate=this.calculateContouredDate(n.contouredDate,n.value)),this.weeks=6,this.days=7,this.initialValue=n.value,this.keyboardNavigationUsed=n.keyboardNavigationUsed,this.min=n.min,this.max=n.max,this.disabled=n.disabled},dispose:function(){this.keyDownProcessor&&this.keyDownProcessor.dispose(),n(this.table).remove()},detachKeyDownProcessor:function(){var n=this.keyDownProcessor;return this.keyDownProcessor=i,n},renderCore:function(){var t=this;if(this.table=document.createElement("table"),this.renderHeader(),this.renderBody(),this.setValue(this.initialValue),!this.disabled)n(this.table).off(u).on(u,"td",function(n){t.cellClickHandler(n)});this.keyDownProcessor||this.disabled||(this.table.setAttribute("tabindex",-1),this.keyDownProcessor=new f.HierarchicalKeyDownProcessor({element:this.table,handler:this.keyDownHandler,context:this})),this.setContouredDate(this.contouredDate,!0),this.rootElement.appendChild(this.table)},renderHeader:function(){var t=this,r=this.table.createTHead(),u=r.insertRow(-1),n,i;this.iterateDays(function(r){n=document.createElement("th"),i=document.createTextNode(t.getDayCaption(t.firstDayOfWeek+r)),n.appendChild(i),u.appendChild(n)})},renderBody:function(){var i=this,f=document.createElement("tbody"),u,e,t,n,o,s=new Date;for(this.table.appendChild(f),u=0;u<this.weeks;++u)e=f.insertRow(-1),this.iterateDays(function(f){t=e.insertCell(-1),n=i.getDate(u,f),r.sameMonthAndYear(n,s)&&n.getDate()===s.getDate()&&t.setAttribute("class",d),r.dateInRange(n,i.min,i.max)?n.getMonth()!==i.date.getMonth()&&t.setAttribute("class",b):t.setAttribute("class",k),t.setAttribute("data-value",i.getShortDate(n)),o=document.createTextNode(n.getDate()),t.appendChild(o)})},getDayCaption:function(n){return n=n<7?n:Math.abs(n%7),Globalize.culture().calendar.days.namesShort[n]},getNavigatorCaption:function(){var n=Globalize.culture().calendar.months.names[this.date.getMonth()],t=this.date.getFullYear();return this.rtl?t+" "+n:n+" "+t},getDate:function(n,t){var i=r.getFirstMonthDate(this.date),f=i.getDay()-this.firstDayOfWeek,u=7*n-f;return u=f<0?u-7:u,i.setDate(i.getDate()+u+t),i},getShortDate:function(n){return n.getFullYear()+"/"+n.getMonth()+"/"+n.getDate()},getDateFromShortDate:function(n){var t=n.split("/");return new Date(t[0],t[1],t[2])},iterateDays:function(n){for(var t=this.rtl?this.days-1:0;this.rtl?t>=0:t<this.days;)n(t),this.rtl?--t:++t},cellClickHandler:function(t){var i=this.getDateFromShortDate(t.target.getAttribute("data-value"));r.dateInRange(i,this.min,this.max)&&(this.table.getAttribute("tabindex")&&this.table!==document.activeElement&&n(this.table).focus(),this.setValue(i,t.target))},keyDownHandler:function(n){var t,i;switch(n.key){case"leftArrow":this.keyboardNavigationUsed=!0,t=this.rtl?1:-1;break;case"rightArrow":this.keyboardNavigationUsed=!0,t=this.rtl?-1:1;break;case"upArrow":this.keyboardNavigationUsed=!0,t=-7;break;case"downArrow":this.keyboardNavigationUsed=!0,t=7;break;case"enter":this.keyboardNavigationUsed=!0,this.contouredDate&&this.setValue(this.contouredDate,this.tryGetCell(this.contouredDate));return;default:return}n.originalEvent.stopPropagation(),n.originalEvent.preventDefault(),i=this.calculateContouredDate(this.contouredDate,this.value),this.setContouredDate(new Date(i.getFullYear(),i.getMonth(),i.getDate()+t))},calculateContouredDate:function(n,t){var i;return r.sameMonthAndYear(n,this.date)&&(i=n),!i&&r.sameMonthAndYear(t,this.date)&&(i=t),i||r.getFirstMonthDate(this.date)},setContouredDate:function(t,i){if(this.keyboardNavigationUsed){t=r.normalizeDate(t,this.min,this.max);var u;this.contouredDate&&(u=this.tryGetCell(this.contouredDate),u&&u.removeClass(v)),this.contouredDate=t,u=this.tryGetCell(this.contouredDate),u&&u.addClass(v),i||n(this.table).trigger(s,t)}},setValue:function(n,t){if(this.value!==n){this.value=n;this.onValueChanged(n,t)}},tryGetCell:function(t){var r=t?n(this.table).find("td[data-value='"+this.getShortDate(t)+"']"):[];return r.length>0?r:i},onValueChanged:function(t,i){n(this.selectedCell).removeClass(a),this.selectedCell=i||this.tryGetCell(t),n(this.selectedCell).addClass(a),i&&(this.setContouredDate(t),n(this.rootElement).trigger(o,t))}})};t.registerComponent("dxCalendar",f.dxEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({monthViewType:ft.MonthView,firstDayOfWeek:1,min:i,max:i})},_initOptions:function(n){n.currentDate=r.normalizeDate(n.currentDate||n.value||new Date,n.min,n.max),this.callBase(n)},_clean:function(){!this.option("keyDownProcessor")&&this._keyDownProcessor&&this._keyDownProcessor.dispose(),this._view&&this._view.dispose(),this.callBase()},_refresh:function(){this._render()},_render:function(){var t=this,i;this.callBase(),this._element().addClass(y),this._initializeKeyDownProcessor(),this._oldView=this._view,i=this._oldView?this._oldView.detachKeyDownProcessor():this._keyDownProcessor.attachChildProcessor(),this._view=this._initializeMonthView(i),this._renderNavigator(),this._body||(this._body=n("<div />").addClass(p),this._element().append(this._body)),this._renderMonthView(),this._swipeable||(this._swipeable=this._element().dxSwipeable({elastic:!1,startAction:function(n){t._handleSwipeStart(n)},updateAction:n.noop,endAction:function(n){t._handleSwipeEnd(n)},itemWidthFunc:function(){return this._element().width()}}).dxSwipeable("instance"))},_initializeKeyDownProcessor:function(){var n=this;if(this._keyDownProcessor=this._keyDownProcessor||this.option("keyDownProcessor"),!this._keyDownProcessor){this._element().attr("tabindex",-1).on(u,function(){n._element().focus()}).on(rt,function(){n._view.setContouredDate(i)});this._keyDownProcessor=new f.HierarchicalKeyDownProcessor({element:this._element()})}this._keyDownProcessor.reinitialize(this._keyDownHandler,this)},_keyDownHandler:function(n){var t;switch(n.key){case"leftArrow":n.ctrl&&(t=this.option("rtlEnabled")?1:-1);break;case"rightArrow":n.ctrl&&(t=this.option("rtlEnabled")?-1:1);break;case"pageUp":t=-1;break;case"pageDown":t=1}if(t)n.originalEvent.stopPropagation(),n.originalEvent.preventDefault(),this._navigate(t);else return!0},_handleSwipeStart:function(){this._swipeInProgress=!0},_handleSwipeEnd:function(n){this._swipeInProgress&&(this._swipeInProgress=!1,n.jQueryEvent.targetOffset!==0&&this._navigate(this.option("rtlEnabled")?n.jQueryEvent.targetOffset:-n.jQueryEvent.targetOffset))},_initializeMonthView:function(n){var t=this.option("monthViewType");return new t({date:this.option("currentDate"),min:this.option("min"),max:this.option("max"),firstDayOfWeek:this.option("firstDayOfWeek"),value:this.option("value"),rtl:this.option("rtlEnabled"),disabled:this.option("disabled")||DevExpress.designMode,keyDownProcessor:n,contouredDate:this._oldView?this._oldView.contouredDate:i,keyboardNavigationUsed:this._oldView?this._oldView.keyboardNavigationUsed:i})},_renderNavigator:function(){var t=this,i=this.option("rtlEnabled")?12:-12,r=this.option("rtlEnabled")?1:-1,f=this.option("rtlEnabled")?-1:1,e=this.option("rtlEnabled")?-12:12;if(this._navigator)this._navigatorCaption.html(this._view.getNavigatorCaption());else{if(this._previousYearLink=n("<a href='javascript:void(0)'><\/a>").addClass(g),this._previousMonthLink=n("<a href='javascript:void(0)'><\/a>").addClass(nt),this._navigatorCaption=n("<span />").html(this._view.getNavigatorCaption()),this._nextMonthLink=n("<a href='javascript:void(0)'><\/a>").addClass(tt),this._nextYearLink=n("<a href='javascript:void(0)'><\/a>").addClass(it),!(this.option("disabled")||DevExpress.designMode)){this._previousYearLink.off(u).on(u,function(){t._navigate(i)});this._previousMonthLink.off(u).on(u,function(){t._navigate(r)});this._nextMonthLink.off(u).on(u,function(){t._navigate(f)});this._nextYearLink.off(u).on(u,function(){t._navigate(e)})}this._navigator=n("<div />").addClass(w).append(this._previousYearLink).append(this._previousMonthLink).append(this._navigatorCaption).append(this._nextMonthLink).append(this._nextYearLink),this._element().append(this._navigator)}this._applyNavigatorLinkVisibility(this._previousYearLink,i),this._applyNavigatorLinkVisibility(this._previousMonthLink,r),this._applyNavigatorLinkVisibility(this._nextMonthLink,f),this._applyNavigatorLinkVisibility(this._nextYearLink,e)},_applyNavigatorLinkVisibility:function(n,t){this._canNavigate(t)?n.removeClass(l):n.addClass(l)},_renderMonthView:function(){var t=this,i;this._view.render(this._body[0]);this._element().off(o).on(o,function(n,i){t.option("value",i)});this._element().off(s).on(s,function(n,i){i&&(r.sameMonthAndYear(t.option("currentDate"),i)||t.option("currentDate",r.getFirstMonthDate(i)))});this._oldView&&(this._initalizeViewDimensions(),this.animating=!0,i=this._getViewChangeAnimation(this._oldView,this._view,this._viewWidth,this.option("rtlEnabled")),i.oldView.then(i.newView).then(n.proxy(this._stopAnimationCallback,this)))},_initalizeViewDimensions:function(){this._viewWidth=this._viewWidth||this._body.width(),this._viewHeight=this._viewHeight||this._body.height()},_canNavigate:function(n){var t=this.option("currentDate"),i=n<0?new Date(t.getFullYear(),t.getMonth()+n+1,0):new Date(t.getFullYear(),t.getMonth()+n,1);return r.dateInRange(i,this.option("min"),this.option("max"))},_navigate:function(n){this._canNavigate(n)&&this.option("currentDate",new Date(this.option("currentDate").getFullYear(),this.option("currentDate").getMonth()+n,1))},_stopAnimationCallback:function(){this._forceStopAnimation(),this._oldView.dispose(),this._oldView=i},_forceStopAnimation:function(){this.animating&&(e.stop(n(this._oldView.table),!0),e.stop(n(this._view.table),!0),this.animating=!1)},_getViewChangeAnimation:function(t,i,r,u){var f=this._getViewChangeAnimationProperties(t,i,r,u);return{oldView:e.animate(n(t.table),f.oldViewAnimation),newView:e.animate(n(i.table),f.newViewAnimation)}},_getViewChangeAnimationProperties:function(n,t,r,u){var o="slide",s=n.date===t.date?0:300,c="cubic-bezier(.40, .80, .60, 1)",f={type:o,duration:s,easing:h.transition?c:i},e={type:o,duration:s,easing:h.transition?c:i};return t.date>n.date&&!u||t.date<n.date&&u?(f.from={left:0},f.to={left:-r},e.from={left:r},e.to={left:0}):(f.from={left:0},f.to={left:r},e.from={left:-r},e.to={left:0}),{oldViewAnimation:f,newViewAnimation:e}},_invalidate:function(){this._forceStopAnimation(),this.callBase()},_optionChanged:function(n,t){var u;switch(n){case"monthViewType":case"keyDownProcessor":break;case"currentDate":this._forceStopAnimation(),u=r.normalizeDate(t,this.option("min"),this.option("max")),this.option("currentDate",new Date(u.getFullYear(),u.getMonth(),1));case"min":case"max":case"firstDayOfWeek":case"rtlEnabled":this._invalidate();break;case"value":!t||r.sameMonthAndYear(this._view.date,t)?(u=r.normalizeDate(t,this.option("min"),this.option("max")),this._view.setValue(u),this.option("value",u)):this.option("currentDate",r.getFirstMonthDate(t));default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var r=t.ui,h=t.utils,c=r.events,u="dx-calendar-picker",l=u+"-calendar-container",a=u+"-overlay",b=u+"-input-wrapper",e=u+"-input-wider-than-calendar-container",f=u+"-",v=c.addNamespace("dxpointerup","dxCalendarPicker"),o=function(n){for(var i=0,r=0,t=0;t<n.length;++t)n[t].length>r&&(i=t,r=n[t].length);return i},s=function(n){return n.length===1?Globalize.culture().calendar.patterns[n]:n},y=function(n){return s(n).indexOf("MMMM")!==-1},p=function(n){return s(n).indexOf("dddd")!==-1},w=function(n,t,i){var r=new Date(1888,y(n)?o(t):9,21,23,59,59,999);return p(n)&&r.setDate(r.getDate()-r.getDay()+o(i)),r};r.calculateMaximumDateFormatWidth=function(t,i,r){if(!r||n(r).is(":visible")){var f,e=2,u=n("<div>"+Globalize.format(w(t,Globalize.culture().calendar.months.names,Globalize.culture().calendar.days.names),t)+"<\/div>").css({visibility:"hidden","white-space":"nowrap",position:"absolute",float:"left"});return i&&u.css(i),u.appendTo(r?n(r):n("body")),f=u.width()+e,u.remove(),f}},r.dxCalendarPicker=r.dxDropDownEditor.inherit({NAME:"dxDateBox",_setDefaultOptions:function(){this.callBase(),this.option({valueChangeEvent:"keyup keydown keypress",formatString:Globalize.culture().calendar.patterns.d,formatWidthCalculator:r.calculateMaximumDateFormatWidth,closeOnValueChange:!0})},_formatWidthCalculator:function(){var n=this._element().find(".dx-texteditor-input"),r=this._button.outerWidth(),u=n.innerWidth()-n.width(),t=this.option("formatWidthCalculator"),i;return t&&(i=u+r+t(this.option("formatString"),{"font-style":n.css("font-style"),"font-variant":n.css("font-variant"),"font-weight":n.css("font-weight"),"font-size":n.css("font-size"),"font-family":n.css("font-family"),"letter-spacing":n.css("letter-spacing")},this._element())),i},_clean:function(){this._keyDownProcessor&&this._keyDownProcessor.dispose(),this._calendarKeyDownProcessor&&this._calendarKeyDownProcessor.dispose(),this._calendarContainer&&this._calendarContainer.remove(),this.callBase()},_render:function(){this.callBase(),this._element().addClass(u),this._keyDownProcessor=new r.HierarchicalKeyDownProcessor({element:this._input(),handler:this._keyDownHandler,context:this}),this._calendarKeyDownProcessor=this._keyDownProcessor.attachChildProcessor()},_calculateWidth:function(){return this.callBase()||this._formatWidthCalculator()},_keyDownHandler:function(t){switch(t.key){case"escape":t.originalEvent.preventDefault(),this._blur();return;default:return this._calendarContainer&&n(this._calendarContainer).is(":visible")?!0:void 0}},_applyDropDownDirectionClasses:function(n,t){this._element().width()>t?this._dropDown._wrapper().addClass(e):this._dropDown._wrapper().removeClass(e),this._cleanDirections(this._dropDown._wrapper()).addClass(n.horizontalClass+" "+n.verticalClass)},_cleanDirections:function(n){return n.removeClass(f+"left "+f+"right "+f+"top "+f+"bottom")},_createDropDown:function(){var r=this,n=this.option("rtlEnabled")?"right":"left",i="bottom";this.callBase({position:{my:n+" "+t.inverseAlign(i),at:n+" "+i},positioningAction:function(u){r._calendarContainer&&r._applyDropDownDirectionClasses({horizontalClass:f+(u.position.h.flip?n:t.inverseAlign(n)),verticalClass:f+(u.position.v.flip?t.inverseAlign(i):i)},r._calendarContainer.innerWidth())}})},_closeOutsideDropDownHandler:function(n){this.callBase(n,!0)},_renderDropDownContent:function(){var t=this;this._calendarContainer=n("<div />").addClass(l),this._calendar=this._calendarContainer.dxCalendar(n.extend(this.option("calendarOptions"),{value:this.option("value"),rtlEnabled:this.option("rtlEnabled"),keyDownProcessor:this._calendarKeyDownProcessor,min:this.option("min"),max:this.option("max")})).dxCalendar("instance");this._calendarContainer.on(v,function(n){t._calendarContainerPointerUpHandler(n)});return[this._calendarContainer]},_showDropDown:function(){if(!this._dropDownVisible()){var t=this._dropDownContainerRendered;this.callBase(),t||(this._calendar.optionChanged.add(n.proxy(this._calendarOptionChangedCallback,this)),this._dropDown._wrapper().addClass(a))}},_calendarContainerPointerUpHandler:function(n){n.dxPreventBlur=!0},_calendarOptionChangedCallback:function(n,t){switch(n){case"value":this.option("value",t)}},_optionValuesEqual:function(n,t,i){return n==="value"&&i===null?!1:this.callBase.apply(this,arguments)},_renderValue:function(){this.callBase(Globalize.format(this.option("value"),this.option("formatString")))},_handleValueChangeEvent:function(n){this._suppressUpdateValue();var i=Globalize.parseDate(this._input().val(),this.option("formatString"));this.callBase(n,i),this._resumeUpdateValue()},_blur:function(){this._input().blur()},_visibilityChanged:function(n){n&&this._renderDimensions()},_optionChanged:function(t,i){var u=this,f;switch(t){case"min":case"max":case"formatString":case"calendarOptions":this._invalidate();break;case"type":case"formatWidthCalculator":case"closeOnValueChange":break;case"value":i&&(f=h.normalizeDate(i,this.option("min"),this.option("max")),this.option("value",f),this._calendar&&this._calendar.option("value",i),this._dropDownVisible()&&this.option("closeOnValueChange")&&setTimeout(n.proxy(u._hideDropDown,u),50));default:this.callBase.apply(this,arguments)}}})}(jQuery,DevExpress),function(n,t,i){var r=t.ui,f=r.events,e="dx-calendar-picker-time-box",o="dx-texteditor-input-wrapper",u=f.addNamespace("dxclick","dxCalendarPickerTimeBox");t.registerComponent("dxCalendarPickerTimeBox",r.dxTextEditor.inherit({_processingKeyPress:i,_setDefaultOptions:function(){this.callBase(),this.option({valueChangeEvent:"keyup keydown keypress",formatString:Globalize.culture().calendar.patterns.t,formatWidthCalculator:r.calculateMaximumDateFormatWidth})},_formatWidthCalculator:function(){var t=this._element(),n=t.find(".dx-texteditor-input"),u=t.innerWidth()-t.width(),i=this.option("formatWidthCalculator"),r;return i&&(r=u+i(this.option("formatString"),{"font-style":n.css("font-style"),"font-variant":n.css("font-variant"),"font-weight":n.css("font-weight"),"font-size":n.css("font-size"),"font-family":n.css("font-family"),"letter-spacing":n.css("letter-spacing")})),r},_render:function(){var t=this,n=this._element();n.addClass(e),this.callBase();n.off(u).on(u,function(){t.focus()});this._repositionIcon(n.width())},_calculateWidth:function(){var t=this.callBase();return t||(t=this._formatWidthCalculator()),t},_renderValue:function(){this.callBase(Globalize.format(this.option("value"),this.option("formatString")))},_renderInput:function(){this.callBase(),this._element().addClass(o)},_repositionIcon:function(n){if(!this.option("rtlEnabled")){var r=t.browser.msie&&t.browser.version<9,i=r?[this._element().css("backgroundPositionX"),this._element().css("backgroundPositionY")]:this._element().css("background-position").split(" ");this._iconWidth=this._iconWidth||parseInt(i[0],10),r?(this._element().css("backgroundPositionX",n+this._iconWidth+"px"),this._element().css("backgroundPositionY",i[1])):this._element().css("background-position",n+this._iconWidth+"px "+i[1])}},_handleValueChangeEvent:function(n){this._suppressUpdateValue();var i=Globalize.parseDate(this._input().val(),this.option("formatString"));this.callBase(n,i),this._resumeUpdateValue()},_optionChanged:function(n){switch(n){case"formatWidthCalculator":break;case"formatString":this._invalidate();break;case"width":this.callBase.apply(this,arguments),this._repositionIcon(this._element().width());break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t,i){var h=t.ui,p=h.events,w=t.support,tt=t.devices,o=Globalize,it="dx-datebox",rt="dx-datepicker",ut="dx-datepicker-wrapper",ft="dx-datepicker-rollers",b="dx-datepicker-roller",et="dx-state-active",ot="dx-datepicker-roller-current",a="dx-datepicker-item",st="dx-datepicker-item-selected",ht="dx-datepicker-item-selected-frame",ct="dx-datepicker-item-selected-border",lt="dx-datepicker-button-up",at="dx-datepicker-button-down",vt="dx-datepicker-formatter-container",yt="dx-datepicker-value-formatter",pt="dx-datepicker-name-formatter",wt=["date","time","datetime"],bt=function(n){return n},k=function(t,i){var r=n("<div>").addClass(vt);return n("<span>").text(t).addClass(yt).appendTo(r),n("<span>").text(i).addClass(pt).appendTo(r),r},s="year",u="month",f="day",c="hours",l="minutes",v="seconds",d="milliseconds",g=31536e7,r={};r[s]={getter:"getFullYear",setter:"setFullYear",possibleFormats:["yy","yyyy"],formatter:bt,startValue:i,endValue:i},r[f]={getter:"getDate",setter:"setDate",possibleFormats:["d","dd"],formatter:function(n,t,i){if(!t)return n;var r=new Date(i.getTime());return r.setDate(n),k(n,o.culture().calendar.days.names[r.getDay()])},startValue:1,endValue:i},r[u]={getter:"getMonth",setter:"setMonth",possibleFormats:["M","MM","MMM","MMMM"],formatter:function(n,t){var i=o.culture().calendar.months.names[n];return t?k(n+1,i):i},startValue:0,endValue:11},r[c]={getter:"getHours",setter:"setHours",possibleFormats:["H","HH","h","hh"],formatter:function(n){return o.format(new Date(0,0,0,n),"HH")},startValue:0,endValue:23},r[l]={getter:"getMinutes",setter:"setMinutes",possibleFormats:["m","mm"],formatter:function(n){return o.format(new Date(0,0,0,0,n),"mm")},startValue:0,endValue:59},r[v]={getter:"getSeconds",setter:"setSeconds",possibleFormats:["s","ss"],formatter:function(n){return o.format(new Date(0,0,0,0,0,n),"ss")},startValue:0,endValue:59},r[d]={getter:"getMilliseconds",setter:"setMilliseconds",possibleFormats:["f","ff","fff"],formatter:function(n){return o.format(new Date(0,0,0,0,0,0,n),"fff")},startValue:0,endValue:999};var e={date:{standardPattern:"yyyy-MM-dd",components:[s,f,u]},time:{standardPattern:"HH:mm",components:[c,l]},datetime:{standardPattern:"yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'",components:[s,f,u,c,l,v,d]},"datetime-local":{standardPattern:"yyyy'-'MM'-'dd'T'HH':'mm",components:[s,u,f,c,l,v]}},kt={date:"d",time:"t",datetime:"S","datetime-local":"f"},nt=function(n,t,i){i=i||e[t].standardPattern;var r=e[t].standardPattern;return Globalize.format(n,i)};(function(){var t="yyyy'-'MM'-'dd'T'HH':'mm'Z'",i=n("<input>").attr("type","datetime");i.val(nt(new Date,"datetime",t)),i.val()||(e.datetime.standardPattern=t)})();var dt=function(n){return Globalize.parseDate(n,e.datetime.standardPattern)||Globalize.parseDate(n,e["datetime-local"].standardPattern)||Globalize.parseDate(n,e.time.standardPattern)||Globalize.parseDate(n,e.date.standardPattern)||Date.parse&&Date.parse(n)&&new Date(Date.parse(n))},y=function(n,t){return new Date(n,t+1,0).getDate()},gt=function(t,u,f){if(!u)return i;isNaN(t.getTime())&&(t=new Date(0,0,0,0,0,0));var o=e[f];return n.each(o.components,function(){var n=r[this];t[n.setter](u[n.getter]())}),t};t.registerComponent("dxDatePickerRoller",h.dxScrollable.inherit({_setDefaultOptions:function(){this.callBase(),this.option({clickableItems:!1,showScrollbar:!1,useNative:!1,selectedIndex:0,items:[]})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{platform:"win8"},options:{clickableItems:!0}},{device:{platform:"generic"},options:{scrollByContent:!0}}])},_init:function(){this.callBase(),this._renderSelectedItemFrame(),this._renderControlButtons()},_render:function(){this.callBase(),n.each(this._strategy._scrollers,function(t,i){i._correctLocation=n.noop}),this._element().addClass(b),this._renderItems(),this._renderSelectedValue(),this._renderItemsClick(),this._wrapAction("_endAction",n.proxy(this._handleEndAction,this))},_wrapAction:function(n,t){var i=this._strategy,r=i[n];i[n]=function(){return t.apply(this,arguments),r.apply(this,arguments)}},_renderItems:function(){var i=this.option("items")||[],t=n();this._$content.empty(),n.each(i,function(){t=t.add(n("<div>").addClass(a).append(this))}),this._$content.append(t),this._$items=t,this.update()},_renderSelectedItemFrame:function(){n("<div>").addClass(ht).append(n("<div>").addClass(ct)).appendTo(this._$container)},_renderControlButtons:function(){n("<div>").addClass(lt).insertAfter(this._$container).dxButton({clickAction:n.proxy(this._handleUpButtonClick,this)}),n("<div>").addClass(at).insertAfter(this._$container).dxButton({clickAction:n.proxy(this._handleDownButtonClick,this)})},_renderSelectedValue:function(n){n===i&&(n=this.option("selectedIndex")),n=this._fitIndex(n);var t=this._getItemPosition(n);this.option().selectedIndex=n,this._moveTo({top:t}),this._renderActiveStateItem()},_fitIndex:function(n){var i=this.option("items")||[],t=i.length;return n>=t?t-1:n<0?0:n},_renderItemsClick:function(){var t="."+a,i=p.addNamespace("dxclick",this.NAME);if(this._element().off(i,t),this.option("clickableItems"))this._element().on(i,t,n.proxy(this._handleItemClick,this))},_handleItemClick:function(n){this._renderSelectedValue(this._itemElementIndex(this._closestItemElement(n)))},_itemElementIndex:function(n){return this._itemElements().index(n)},_closestItemElement:function(n){return n.currentTarget},_itemElements:function(){return this._element().find("."+a)},_renderActiveStateItem:function(){var t=this.option("selectedIndex");n.each(this._$items,function(i){n(this).toggleClass(st,t===i)})},_handleUpButtonClick:function(){this._animation=!0,this.option("selectedIndex",this.option("selectedIndex")-1)},_handleDownButtonClick:function(){this._animation=!0,this.option("selectedIndex",this.option("selectedIndex")+1)},_getItemPosition:function(n){return Math.round(this._itemHeight()*n)},_moveTo:function(n){n=this._normalizeLocation(n);var r=this._location(),i={x:-(r.left-n.left),y:-(r.top-n.top)};this._isVisible()&&(i.x||i.y)&&(this._strategy._prepareDirections(!0),this._animation?(t.fx.animate(this._$content,{duration:200,type:"slide",to:{top:n.top}}),delete this._animation):this._strategy.handleMove({delta:i}))},_handleEndAction:function(){if(this._changedByIndex){this._changedByIndex=!1,this._renderSelectedValue();return}var n=-this._location().top/this._itemHeight(),t=Math.round(n);this._animation=!0,this._renderSelectedValue(t)},_itemHeight:function(){var n=this._$items.first();return n.outerHeight()+parseFloat(n.css("margin-top")||0)},_toggleActive:function(n){this._element().toggleClass(et,n)},_isVisible:function(){return this._$container.is(":visible")},_optionChanged:function(n){switch(n){case"selectedIndex":this._renderSelectedValue(),this._changedByIndex=!0,this._strategy.update(),this._strategy.handleEnd({velocity:{x:0,y:0}});break;case"items":this._renderItems(),this._renderSelectedValue();break;case"clickableItems":this._renderItemsClick();break;default:this.callBase.apply(this,arguments)}}})),t.registerComponent("dxDatePicker",h.dxPopup.inherit({_valueOption:function(){return new Date(this.option("value"))=="Invalid Date"?new Date:new Date(this.option("value"))},_setDefaultOptions:function(){this.callBase(),this.option({minDate:new Date(1),maxDate:new Date(n.now()+g),format:"date",value:new Date,culture:Globalize.culture().name,showNames:!1,cancelButton:{icon:"close",clickAction:n.proxy(function(){this._value=this._valueOption()},this)},doneButton:{icon:"save",clickAction:n.proxy(function(){this.option("value",new Date(this._value)),this.hide()},this)}})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:{platform:"win8"},options:{showNames:!0}},{device:{platform:"win8",phone:!0},options:{fullScreen:!0}},{device:function(n){return n.platform!=="win8"},options:{width:333,height:331}},{device:function(n){return n.platform==="generic"},options:{width:"auto",height:"auto"}}])},_render:function(){this._value=this._valueOption(),this.callBase(),this._element().addClass(rt),this._wrapper().addClass(ut)},_renderContentImpl:function(){this.callBase(),this._renderRollers()},_renderRollers:function(){var t=this;t._$rollersContainer||(t._$rollersContainer=n("<div>").appendTo(t.content()).addClass(ft)),t._$rollersContainer.empty(),t._createRollerConfigs(),t._rollers={},n.each(t._rollerConfigs,function(i){var r=n("<div>").appendTo(t._$rollersContainer).addClass(b+"-"+t._rollerConfigs[i].type).dxDatePickerRoller({items:t._rollerConfigs[i].displayItems,selectedIndex:t._rollerConfigs[i].selectedIndex,showScrollbar:!1,startAction:function(n){var r=n.component;r._toggleActive(!0),t._setActiveRoller(t._rollerConfigs[i],r.option("selectedIndex"))},endAction:function(n){var r=n.component;t._setRollerState(t._rollerConfigs[i],r.option("selectedIndex")),r._toggleActive(!1)}});t._rollers[t._rollerConfigs[i].type]=r.dxDatePickerRoller("instance")})},_setActiveRoller:function(t){var i=this._rollers[t.type];n.each(this._rollers,function(){this._$element.toggleClass(ot,this===i)})},_refreshRollers:function(){var t=this;n.each(this._rollers,function(n){var i=t._rollerConfigs[n].getIndex(t._value);this.update(),this._renderSelectedValue(i)})},_setRollerState:function(n,t){if(t!==n.selectedIndex){var r=n.valueItems[t],f=n.setValue,i=this._value.getDate();n.type===u?(i=Math.min(i,y(this._value.getFullYear(),r)),this._value.setDate(i)):n.type===s&&(i=Math.min(i,y(r,this._value.getMonth())),this._value.setDate(i)),this._value[f](r),n.selectedIndex=t}n.type===s&&(this._refreshMonthRoller(),this._refreshDayRoller()),n.type===u&&this._refreshDayRoller()},_refreshMonthRoller:function(){var t=this._rollers[u],n;t&&(this._createRollerConfig(u),n=this._rollerConfigs[u],this._deferredRenderMonthTimeout=window.setTimeout(function(){n.displayItems.length!==t.option("items").length&&t.option({items:n.displayItems,selectedIndex:n.selectedIndex})},100))},_refreshDayRoller:function(){var t=this._rollers[f],n;t&&(this._createRollerConfig(f),n=this._rollerConfigs[f],this._deferredRenderDayTimeout=window.setTimeout(function(){n.displayItems.length!==t.option("items").length&&t.option({items:n.displayItems,selectedIndex:n.selectedIndex})},100))},_createRollerConfigs:function(t){var i=this;t=t||i.option("format"),i._rollerConfigs={},n.each(i._getFormatPattern(t).split(/\W+/),function(t,u){n.each(r,function(t,r){n.inArray(u,r.possibleFormats)>-1&&i._createRollerConfig(t)})})},_getFormatPattern:function(n){var t=Globalize.culture(this.option("culture")),i="";return n==="date"?i=t.calendar.patterns.d:n==="time"?i=t.calendar.patterns.t:n==="datetime"&&(i=[t.calendar.patterns.d,t.calendar.patterns.t].join(" ")),i},_createRollerConfig:function(n){for(var u=r[n],f=this._calculateRollerConfigValueRange(n),e=f.startValue,o=f.endValue,s=u.formatter,h=this.option("showNames"),c=this._value,t={type:n,setValue:u.setter,valueItems:[],displayItems:[],getIndex:function(n){return n[u.getter]()-e}},i=e;i<=o;i++)t.valueItems.push(i),t.displayItems.push(s(i,h,c));t.selectedIndex=t.getIndex(this._value),this._rollerConfigs[n]=t},_calculateRollerConfigValueRange:function(n){var t=this._value,i=this.option("minDate"),e=this.option("maxDate"),l=t.getFullYear()===i.getFullYear(),v=l&&t.getMonth()===i.getMonth(),c=t.getFullYear()===e.getFullYear(),p=c&&t.getMonth()===e.getMonth(),a=r[n],h=a.startValue,o=a.endValue;return n===s&&(h=i.getFullYear(),o=e.getFullYear()),n===u&&(l&&(h=i.getMonth()),c&&(o=e.getMonth())),n===f&&(o=y(t.getFullYear(),t.getMonth()),v&&(h=i.getDate()),c&&(o=e.getDate())),{startValue:h,endValue:o}},_optionChanged:function(n,t,i){switch(n){case"showNames":case"minDate":case"maxDate":case"culture":case"format":this._renderRollers();break;case"visible":this.callBase(n,t,i),t&&this._refreshRollers();break;case"value":this._value=this._valueOption(),this._renderRollers();break;default:this.callBase(n,t,i)}},_dispose:function(){clearTimeout(this._deferredRenderDayTimeout),clearTimeout(this._deferredRenderMonthTimeout),this.callBase()}})),t.registerComponent("dxDateBox",h.dxTextEditor.inherit({ctor:function(n,t){t=t||{};var u=tt.current().platform==="generic"&&(t.format==="date"||!t.format),r=t&&t.useCalendar;r===i&&(r=u),r?new h.dxCalendarPicker(n,t):this.callBase(n,t)},_setDefaultOptions:function(){this.callBase(),this.option({format:"date",value:new Date,min:new Date(1),max:new Date(n.now()+g),useCalendar:!1,useNativePicker:!0})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(n){return n.win8||n.android&&(n.version[0]<4||n.version[0]==4&&n.version[1]<4)},options:{useNativePicker:!1}}])},_init:function(){this.callBase(),this._initFormat()},_render:function(){this.callBase(),this._element().addClass(it),this._renderDatePicker()},_renderDatePicker:function(){var t,i;if(this._usingNativeDatePicker()||this.option("readOnly")){this._datePicker&&(this._datePicker._element().remove(),this._datePicker=null);return}if(t={value:this.option("value"),format:this.option("format"),title:this._getDataPickerTitle(),minDate:this.option("min"),maxDate:this.option("max")},this._datePicker)this._datePicker.option(t);else{this._datePicker=n("<div>").appendTo(this._element()).dxDatePicker(n.extend(t,{hidingAction:n.proxy(function(n){this.option("value",n.component.option("value"))},this)})).dxDatePicker("instance"),i=this._createAction(function(n){n.component._datePicker.show()});this._input().on(p.addNamespace("dxclick",this.NAME),function(n){return i({jQuery:n})})}},_renderFocusEvent:function(){this.callBase();this._input().on("focus",n.proxy(function(){this._togglePlaceholderVisibility(!1)},this))},_initFormat:function(){var t=this.option("format");n.inArray(t,wt)===-1?(t="date",this.option("format",t)):t!=="datetime"||w.inputType(t)||(t="datetime-local"),this.option("mode",t)},_usingNativeDatePicker:function(){return this.option("useNativePicker")},_readOnlyPropValue:function(){return this._usingNativeDatePicker()?this.callBase():!0},_handleValueChangeEvent:function(){var i=dt(this._input().val()),n=new Date(this.option("value")&&this.option("value").valueOf()),t=gt(n,i,this.option("mode"));this.option({value:t}),t!==n&&this._renderValue()},_renderValue:function(){var n=this.option("mode"),i=kt[n],r=w.inputType(n)?!1:o.culture().calendar.patterns[i],t=nt(this.option("value"),n,r);this._input().val(t),this._togglePlaceholderVisibility(t===""||t===null)},_renderProps:function(){this.callBase(),this._input().attr("autocomplete","off")},_getDataPickerTitle:function(){var n=this.option("placeholder"),t;return n||(t=this.option("format"),t==="time"?n=Globalize.localize("dxDateBox-simulatedDataPickerTitleTime"):t==="date"?n=Globalize.localize("dxDateBox-simulatedDataPickerTitleDate"):t==="datetime"&&(n=Globalize.localize("dxDateBox-simulatedDataPickerTitleDateTime"))),n},_optionChanged:function(n,t,i){switch(n){case"useCalendar":break;case"format":this._initFormat(),this._renderValue(),this._renderDatePicker();break;case"readOnly":this._invalidate();break;case"useNativePicker":this._renderDatePicker(),this._renderProps();break;case"placeholder":this._datePicker&&this._datePicker.option("title",this._getDataPickerTitle());break;case"type":throw new Error("type cannot be changed after instantiation");break;case"min":case"max":this._datePicker&&this._datePicker.option(n+"Date",t);break;case"value":this._renderValue(),this._renderDatePicker();default:this.callBase(n,t,i)}}}))}(jQuery,DevExpress),function(n,t){var u=t.ui,f="dx-loadindicator",e="dx-loadindicator-wrapper",o="dx-loadindicator-icon",r="dx-loadindicator-segment",s="dx-loadindicator-segment",h="dx-loadindicator-win8-segment",c="dx-loadindicator-win8-segment",l="dx-loadindicator-win8-inner-segment",a="dx-loadindicator-image";t.registerComponent("dxLoadIndicator",u.Widget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({indicatorSrc:"",hoverStateEnabled:!1})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){var n=DevExpress.devices.real(),t=n.platform==="android"&&!/chrome/i.test(navigator.userAgent);return DevExpress.browser.msie&&DevExpress.browser.version<10||t},options:{viaImage:!0}}])},_init:function(){this.callBase(),this._element().addClass(f)},_render:function(){this._renderWrapper(),this._renderMarkup(),this.callBase()},_renderWrapper:function(){this._$wrapper=n("<div>").addClass(e),this._element().append(this._$wrapper)},_renderMarkup:function(){!t.support.animation||this.option("viaImage")||this.option("indicatorSrc")?this._renderMarkupForImage():this._renderMarkupForAnimation()},_renderMarkupForAnimation:function(){var t,u,i;for(this._$indicator=n("<div>").addClass(o),t=15;t>=0;--t)i=n("<div>").addClass(r).addClass(s+t),this._$indicator.append(i);for(t=1;t<=5;++t)u=n("<div>").addClass(l),i=n("<div>").addClass(h).addClass(c+t),i.append(u),this._$indicator.append(i);this._$wrapper.append(this._$indicator)},_renderMarkupForImage:function(){var n=this.option("indicatorSrc");this._$wrapper.addClass(a),n&&this._$wrapper.css("background-image","url("+n+")")},_renderDimensions:function(){this.callBase(),this._updateContentSize()},_updateContentSize:function(){var u=this._element(),t=this.option("width"),i=this.option("height"),n;(t||i)&&(t=this._element().width(),i=this._element().height(),n=Math.min(i,t),this._$wrapper.css({height:n,width:n,"margin-top":(i-n)/2,"margin-left":(t-n)/2}),this._$indicator&&this._$indicator.find("."+r).css("border-width",.125*n))},_clean:function(){this.callBase(),this._removeMarkupForAnimation(),this._removeMarkupForImage()},_removeMarkupForAnimation:function(){this._$indicator&&this._$indicator.remove()},_removeMarkupForImage:function(){this._$wrapper.css("background-image","none")},_optionChanged:function(n){switch(n){case"indicatorSrc":this._invalidate();break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var f=t.ui,e="dx-loadpanel",o="dx-loadpanel-wrapper",r="dx-loadpanel-indicator",u="dx-loadpanel-message",s="dx-loadpanel-content",h="dx-loadpanel-content-wrapper",c="dx-loadpanel-pane-hidden";t.registerComponent("dxLoadPanel",f.dxOverlay.inherit({_setDefaultOptions:function(){this.callBase(),this.option({message:Globalize.localize("Loading"),width:222,height:90,animation:null,showIndicator:!0,indicatorSrc:"",showPane:!0,delay:0})},_init:function(){this.callBase.apply(this,arguments),this._$contentWrapper=n("<div>").addClass(h),this._$contentWrapper.appendTo(this._container())},_render:function(){this.callBase(),this._element().addClass(e),this._wrapper().addClass(o)},_renderContentImpl:function(){this.callBase(),this.content().addClass(s),this._togglePaneVisible(),this._cleanPreviousContent(),this._renderLoadIndicator(),this._renderMessage()},_makeVisible:function(){var i=this.option("delay"),t,r;return i?(t=n.Deferred(),r=n.proxy(this.callBase,this),this._clearShowTimeout(),this._showTimeout=setTimeout(function(){r().done(function(){t.resolve()})},i),t.promise()):this.callBase()},_makeHidden:function(){return this._clearShowTimeout(),this.callBase()},_clearShowTimeout:function(){clearTimeout(this._showTimeout)},_renderMessage:function(){var t=this.option("message"),i;t&&(i=n("<div>").addClass(u).text(t),this._$contentWrapper.append(i))},_renderLoadIndicator:function(){this.option("showIndicator")&&(this._$indicator=n("<div>").addClass(r).dxLoadIndicator({indicatorSrc:this.option("indicatorSrc")}).appendTo(this._$contentWrapper))},_cleanPreviousContent:function(){this.content().find("."+u).remove(),this.content().find("."+r).remove()},_togglePaneVisible:function(){this.content().toggleClass(c,!this.option("showPane"))},_optionChanged:function(n){switch(n){case"delay":break;case"message":case"showIndicator":this._cleanPreviousContent(),this._renderLoadIndicator(),this._renderMessage();break;case"showPane":this._togglePaneVisible();break;case"indicatorSrc":this._$indicator&&this._$indicator.dxLoadIndicator({indicatorSrc:this.option("indicatorSrc")});break;default:this.callBase.apply(this,arguments)}},_dispose:function(){this._clearShowTimeout(),this.callBase()},_defaultHideTopOverlayHandler:n.noop}))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,e=t.utils,s=t.data.utils,h=f.events,r="dx-lookup",u=r+"-selected",v=r+"-search",y=r+"-search-wrapper",c=r+"-field",p=c+"-wrapper",o=r+"-popup",w=o+"-wrapper",l=o+"-search",b=r+"-popover-mode",k=r+"-empty",a=".dx-list-item",d="dxListItemData",g=200;t.registerComponent("dxLookup",f.dxEditor.inherit({_deprecatedOptions:{shownAction:{since:"14.1",message:"Use the 'openAction' option instead."},hiddenAction:{since:"14.1",message:"Use the 'closeAction' option instead."}},_optionAliases:{openAction:"shownAction",closeAction:"hiddenAction"},_setDefaultOptions:function(){this.callBase(),this.option({items:[],dataSource:null,value:i,displayValue:i,title:"",titleTemplate:"title",valueExpr:null,displayExpr:"this",placeholder:Globalize.localize("Select"),searchPlaceholder:Globalize.localize("Search"),searchEnabled:!0,noDataText:Globalize.localize("dxCollectionContainerWidget-noDataText"),searchTimeout:1e3,minFilterLength:0,fullScreen:!1,valueChangeAction:null,itemTemplate:"item",itemRender:null,showCancelButton:!0,cancelButtonText:Globalize.localize("Cancel"),showClearButton:!1,clearButtonText:Globalize.localize("Clear"),showDoneButton:!1,doneButtonText:Globalize.localize("Done"),contentReadyAction:null,shownAction:null,openAction:null,hiddenAction:null,closeAction:null,popupWidth:function(){return n(window).width()*.8},popupHeight:function(){return n(window).height()*.8},shading:!0,closeOnOutsideClick:!1,position:i,animation:i,pullRefreshEnabled:!1,autoPagingEnabled:!0,useNativeScrolling:!0,pullingDownText:Globalize.localize("dxList-pullingDownText"),pulledDownText:Globalize.localize("dxList-pulledDownText"),refreshingText:Globalize.localize("dxList-refreshingText"),pageLoadingText:Globalize.localize("dxList-pageLoadingText"),scrollAction:null,pullRefreshAction:null,pageLoadingAction:null,showNextButton:!1,nextButtonText:Globalize.localize("dxList-nextButtonText"),grouped:!1,groupTemplate:"group",groupRender:null,usePopover:!1})},_defaultOptionsRules:function(){return this.callBase().slice(0).concat([{device:function(){return!t.support.nativeScrolling},options:{useNativeScrolling:!1}},{device:function(n){return!t.support.nativeScrolling&&!t.devices.isSimulator()&&t.devices.real().platform==="generic"&&n.platform==="generic"},options:{showNextButton:!0,autoPagingEnabled:!1}},{device:{platform:"win8",phone:!0},options:{showCancelButton:!1,fullScreen:!0}},{device:{platform:"win8",phone:!1},options:{popupWidth:function(){return n(window).width()}}},{device:[{platform:"ios",phone:!0},{platform:"ios7",phone:!0}],options:{fullScreen:!0}},{device:[{platform:"ios",tablet:!0},{platform:"ios7",tablet:!0}],options:{popupWidth:function(){return Math.min(n(window).width(),n(window).height())*.4},popupHeight:function(){return Math.min(n(window).width(),n(window).height())*.4},usePopover:!0}}])},_optionsByReference:function(){return n.extend(this.callBase(),{value:!0})},_init:function(){this.callBase(),this._initDataSource(),this._searchTimer=null,this._compileValueGetter(),this._compileDisplayGetter(),this._suppressValueChangeAction(),this._dataSource||this._itemsToDataSource()},_compileValueGetter:function(){this._valueGetter=s.compileGetter(this._valueGetterExpr())},_valueGetterExpr:function(){return this.option("valueExpr")||"this"},_compileDisplayGetter:function(){this._displayGetter=s.compileGetter(this.option("displayExpr"))},_itemsToDataSource:function(){this._dataSource=new DevExpress.data.DataSource(this.option("items"))},_render:function(){this.callBase(),this._element().addClass(r).toggleClass(b,this.option("usePopover")),this._renderField(),this._needRenderContent=!0,this._calcSelectedItem(n.proxy(this._setFieldText,this))},_renderContent:n.noop,_renderContentImpl:n.noop,_renderField:function(){var t=this._createAction(this._handleFieldClick);this._$fieldWrapper=n("<div>").addClass(p),this._$field=n("<div>").addClass(c).appendTo(this._$fieldWrapper).on(h.addNamespace("dxclick",this.NAME),function(n){t({jQueryEvent:n})}),this._$fieldWrapper.appendTo(this._element())},_handleFieldClick:function(n){var t=n.component;t._renderContentIfNeed(),t._setListDataSource(),t._refreshSelected(),t._popup.show(),t._lastSelectedItem=t._selectedItem},_renderContentIfNeed:function(){this._needRenderContent&&(this._renderPopup(),this._needRenderContent=!1)},_renderPopup:function(){var t=n("<div>").addClass(o).appendTo(this._element()),i={rtlEnabled:this.option("rtlEnabled"),showTitle:!0,title:this.option("title"),titleTemplate:this._getTemplateByOption("titleTemplate"),contentReadyAction:n.proxy(this._popupContentReadyAction,this),cancelButton:this._getCancelButtonConfig(),doneButton:this._getDoneButtonConfig(),clearButton:this._getClearButtonConfig(),shownAction:this._createActionByOption("shownAction"),hiddenAction:this._createActionByOption("hiddenAction")};this._popup=this.option("usePopover")&&!this.option("fullScreen")?this._createPopover(t,i):this._createPopup(t,i),this._setPopupOption("position","position"),this._setPopupOption("animation","animation"),this._setPopupOption("popupWidth","width"),this._setPopupOption("popupHeight","height"),this._popup._wrapper().addClass(w).toggleClass(l,this.option("searchEnabled"))},_setPopupOption:function(n,t){var n=this.option(n);n=n===i?this._popup.initialOption(t):n,this._popup.option(t,n)},_createPopover:function(t,i){return t.dxPopover(n.extend(i,{target:this._element()})).dxPopover("instance")},_createPopup:function(t,i){return t.dxPopup(n.extend(i,{fullScreen:this.option("fullScreen"),shading:this.option("shading"),closeOnOutsideClick:this.option("closeOnOutsideClick")})).dxPopup("instance")},_getCancelButtonConfig:function(){return this.option("showCancelButton")?{text:this.option("cancelButtonText")}:null},_getDoneButtonConfig:function(){return this.option("showDoneButton")?{text:this.option("doneButtonText"),clickAction:n.proxy(function(){this.option("value",this._valueGetter(this._lastSelectedItem))},this)}:null},_getClearButtonConfig:function(){return this.option("showClearButton")?{text:this.option("clearButtonText"),clickAction:n.proxy(function(){this.option("value","")},this)}:null},_renderCancelButton:function(){this._popup&&this._popup.option("cancelButton",this._getCancelButtonConfig())},_renderDoneButton:function(){this._popup&&this._popup.option("doneButton",this._getDoneButtonConfig())},_renderClearButton:function(){this._popup&&this._popup.option("clearButton",this._getClearButtonConfig())},_popupContentReadyAction:function(){this._renderSearch(),this._renderList()},_renderSearch:function(){this._$search=n("<div>").addClass(v).dxTextBox({mode:"search",placeholder:this._getSearchPlaceholder(),valueChangeEvent:"change input",valueChangeAction:n.proxy(this._searchChangedHandler,this),rtlEnabled:this.option("rtlEnabled")}).appendTo(this._popup.content()).wrap(n("<div>").addClass(y).toggle(this.option("searchEnabled"))),this._search=this._$search.dxTextBox("instance")},_getSearchPlaceholder:function(){var n=this.option("minFilterLength"),t=this.option("searchPlaceholder");return n&&t===Globalize.localize("Search")?e.stringFormat(Globalize.localize("dxLookup-searchPlaceholder"),n):t},_renderList:function(){this._list=n("<div>").appendTo(this._popup.content()).dxList({_templates:this.option("_templates"),dataSource:null,itemClickAction:n.proxy(function(n){this._toggleSelectedClass(n.jQueryEvent),this._updateOptions(n)},this),itemRenderedAction:n.proxy(function(n){this._setSelectedClass(n.itemElement,n.itemData)},this),itemRender:this._getItemRender(),itemTemplate:this._getTemplateByOption("itemTemplate"),noDataText:this.option("noDataText"),pullRefreshEnabled:this.option("pullRefreshEnabled"),autoPagingEnabled:this.option("autoPagingEnabled"),useNativeScrolling:this.option("useNativeScrolling"),pullingDownText:this.option("pullingDownText"),pulledDownText:this.option("pulledDownText"),refreshingText:this.option("refreshingText"),pageLoadingText:this.option("pageLoadingText"),scrollAction:this.option("scrollAction"),pullRefreshAction:this.option("pullRefreshAction"),pageLoadingAction:this.option("pageLoadingAction"),showNextButton:this.option("showNextButton"),nextButtonText:this.option("nextButtonText"),grouped:this.option("grouped"),groupTemplate:this._getTemplateByOption("groupTemplate"),groupRender:this.option("groupRender"),rtlEnabled:this.option("rtlEnabled")}).data("dxList"),this._needSetItemRenderToList&&(this._updateListItemRender(),this._needSetItemRenderToList=!1),this._setListDataSource(),this._list.option("contentReadyAction",this.option("contentReadyAction")),this._list._fireContentReadyAction()},_setListDataSource:function(n){if(this._list){var t=this._search.option("value").length>=this.option("minFilterLength"),r=!!this._list.option("dataSource"),u=t===r;(n||!u)&&(this._list.option("dataSource",t?this._dataSource:null),t||this._list.option("items",i))}},_refreshSelected:function(){var t=this;t._list&&n.each(this._list._element().find(a),function(){var i=n(this);t._setSelectedClass(i,i.data(d))})},_calcSelectedItem:function(n){function o(t){e._selectedItem=t,n()}var t=this._dataSource,f,r,e=this,u=this._unwrapedValue();if(!t||u===i){this._selectedItem=i,n();return}f=t.store(),r=this._valueGetterExpr(),this._loadSingle(r,u).done(function(n){o(n)})},_unwrapedValue:function(){var t=this.option("value"),r=this._valueGetterExpr(),i;return!this._dataSource&&r!=="this"?t:(i=this._dataSource.store().key(),i&&typeof t=="object"&&(t=t[i]),n.isFunction(t)?t():t)},_setFieldText:function(n){arguments.length||(n=this._getDisplayText()),this._$field.text(n),this.option("displayValue",n),this._toggleEmptyClass()},_getDisplayText:function(){return this.option("value")===i||!this._dataSource?this.option("placeholder"):this._displayGetter(this._selectedItem)||this.option("placeholder")},_searchChangedHandler:function(){if(this._search){var t=this._search.option("value"),i=t.length>=this.option("minFilterLength");if(clearTimeout(this._searchTimer),this._search.option("placeholder",this._getSearchPlaceholder()),!i){this._setListDataSource();return}this.option("searchTimeout")?this._searchTimer=setTimeout(n.proxy(this._doSearch,this,t),this.option("searchTimeout")):this._doSearch(t)}},_doSearch:function(t){this._dataSource&&(arguments.length||(t=this.option("searchEnabled")?this._search.option("value"):""),this._filterStore(t).done(n.proxy(function(){this._dataSource.items().length&&this._setListDataSource()},this)))},_filterStore:function(n){return this._dataSource.searchExpr()||this._dataSource.searchExpr(this.option("displayExpr")),this._dataSource.searchValue(n),this._dataSource.pageIndex(0),this._dataSource.load()},_updateOptions:function(n){this._lastSelectedItem===n.itemData&&this._updateAndHidePopup(),this._lastSelectedItem=n.itemData,this.option("showDoneButton")||this._updateAndHidePopup()},_setSelectedClass:function(n,t){var o,s;t=this._valueGetter(t);var i=this.option("value"),r=this._dataSource&&this._dataSource.key(),f=this._optionValuesEqual("value",t,i);r&&!f&&i&&(o=e.unwrapObservable(i[r]),s=e.unwrapObservable(t[r])||t,f=o===s),n.toggleClass(u,f)},_getItemRender:function(){var t=this.option("itemTemplate");if(!t||!(t in this.option("_templates")))return this.option("itemRender")||n.proxy(this._displayGetter,this)},_toggleSelectedClass:function(t){var i=this._list._element().find("."+u);i.length&&i.removeClass(u),n(t.target).closest(a).addClass(u)},_toggleEmptyClass:function(){var n=!this._selectedItem;this._element().toggleClass(k,n)},_hidePopup:function(){this._popup.hide()},_updateAndHidePopup:function(){this.option("value",this._valueGetter(this._lastSelectedItem)),clearTimeout(this._hidePopupTimer),this._hidePopupTimer=setTimeout(n.proxy(this._hidePopup,this),g),this._setFieldText(this._displayGetter(this._lastSelectedItem))},_updateListItemRender:function(){this._list?this._list.option("itemRender",this._getItemRender()):this._needSetItemRenderToList=!0},_updateListItemTemplate:function(){this._list&&this._list.option("itemTemplate",this.option("itemTemplate"))},_clean:function(){this._popup&&this._popup._element().remove(),this._$field&&this._$field.remove(),this._$fieldWrapper&&this._$fieldWrapper.remove()},_dispose:function(){clearTimeout(this._searchTimer),clearTimeout(this._hidePopupTimer),n(window).off(h.addNamespace("popstate",this.NAME)),this.callBase()},_changeListOption:function(n,t){this._list&&this._list.option(n,t)},_changePopupOption:function(n,t){this._popup&&this._popup.option(n,t)},_optionChanged:function(t,i,r){switch(t){case"valueExpr":case"value":this._calcSelectedItem(n.proxy(function(){t==="value"&&this._raiseValueChangeAction(i,r,{selectedItem:this._selectedItem}),this._compileValueGetter(),this._compileDisplayGetter(),this._refreshSelected(),this._setFieldText()},this));break;case"displayExpr":this._compileDisplayGetter(),this._updateListItemRender(),this._refreshSelected(),this._setFieldText();break;case"displayValue":break;case"itemRender":this._updateListItemRender();case"itemTemplate":this._updateListItemTemplate();break;case"items":case"dataSource":t==="items"?this._itemsToDataSource():this._initDataSource(),this._setListDataSource(!0),this._compileValueGetter(),this._calcSelectedItem(n.proxy(this._setFieldText,this));break;case"searchEnabled":this._$search&&this._$search.toggle(i),this._popup&&this._popup._wrapper().toggleClass(l,i);break;case"minFilterLength":this._setListDataSource(),this._setFieldText(),this._searchChangedHandler();break;case"placeholder":this._setFieldText();break;case"searchPlaceholder":this._$search&&this._$search.dxTextBox("instance").option("placeholder",i);break;case"shownAction":case"hiddenAction":case"openAction":case"closeAction":case"animation":this._renderPopup();break;case"title":case"titleTemplate":this._changePopupOption(t,i);break;case"position":case"shading":case"closeOnOutsideClick":this.option("usePopover")||this._changePopupOption(t,i);break;case"fullScreen":this._popup&&(this.option("usePopover")?this._renderPopup():this._popup.option(t,i));break;case"clearButtonText":case"showClearButton":this._renderClearButton();break;case"cancelButtonText":case"showCancelButton":this._renderCancelButton();break;case"doneButtonText":case"showDoneButton":this._renderDoneButton();break;case"popupWidth":this._changePopupOption("width",i==="auto"?this.initialOption("popupWidth"):i);break;case"popupHeight":this._changePopupOption("height",i==="auto"?this.initialOption("popupHeight"):i);break;case"usePopover":this._invalidate();break;case"pullRefreshEnabled":case"autoPagingEnabled":case"useNativeScrolling":case"pullingDownText":case"pulledDownText":case"refreshingText":case"pageLoadingText":case"scrollAction":case"pullRefreshAction":case"pageLoadingAction":case"showNextButton":case"nextButtonText":case"grouped":case"groupRender":case"noDataText":case"contentReadyAction":this._changeListOption(t,i);break;case"groupTemplate":this._changeListOption(t,this._getTemplateByOption(t));case"searchTimeout":break;default:this.callBase.apply(this,arguments)}},open:function(){this._renderContentIfNeed(),this._popup.show()},close:function(){this._renderContentIfNeed(),this._popup.hide()}}).include(f.DataHelperMixin))}(jQuery,DevExpress),function(n,t){var u=t.ui,r=u.events,it=t.utils,f=40,e=38,o=13,c=27,l=39,s=9,a="dx-autocomplete",v="dx-autocomplete-popup-wrapper",h="dx-autocomplete-selected",y="."+h,p=".dx-list",w=".dx-list-item",b="dxListItemData",k=["startswith","contains","endwith","notcontains"],d=r.addNamespace("keydown","dxAutocomplete"),g=r.addNamespace("keyup","dxAutocomplete"),nt=r.addNamespace("focusin","dxAutocomplete"),tt=r.addNamespace("focusout","dxAutocomplete");t.registerComponent("dxAutocomplete",u.dxDropDownEditor.inherit({_setDefaultOptions:function(){this.callBase(),this.option({value:"",items:[],dataSource:null,itemTemplate:"item",itemRender:null,minSearchLength:1,searchTimeout:0,searchMode:"contains",displayExpr:"this",valueChangeEvent:"change keyup",shouldActivateFocusOut:!0,maxLength:null})},_listElement:function(){return this._dropDown.content().find(p)},_listItemElement:function(){return this._dropDown.content().find(w)},_listSelectedItemElement:function(){return this._dropDown.content().find(this._getSelectedItemSelector())},_init:function(){this.callBase(),this._validateSearchMode(),this._compileDisplayGetter(),this._initDataSource(),this._fillDataSourceFromItemsIfNeeded()},_fillDataSourceFromItemsIfNeeded:function(){!this.option("dataSource")&&this.option("items")&&this._itemsToDataSource()},_validateSearchMode:function(){var i=this.option("searchMode"),r=i.toLowerCase();if(!(n.inArray(r,k)>-1))throw Error(t.utils.stringFormat('Search mode "{0}" is unavailable',i));},_compileDisplayGetter:function(){this._displayGetter=t.data.utils.compileGetter(this.option("displayExpr"))},_render:function(){this.callBase(),this._element().addClass(a),this._renderInputEvents()},_renderDimensions:function(){this.callBase(),this._dropDown&&this._dropDown.option("width",this.option("width"))},_renderContentImpl:function(){this._caretPosition={start:0,end:0},this._renderDropDownContainer()},_renderButton:function(n){this.callBase(n===!1?!1:!0)},_renderInputEvents:function(){this._input().on(d,n.proxy(this._handleInputKeyDown,this)).on(g,n.proxy(this._handleInputKeyUp,this)).on(nt,n.proxy(function(){this._setFocusSelection()},this)).on(tt,n.proxy(function(){this.option("shouldActivateFocusOut")&&this._hideDropDown(),this._toggleElementSelectedClass(!1)},this))},_setFocusSelection:function(){this._toggleElementSelectedClass(!0)},_hasUpdateEvent:function(n){return n&&this.option("valueUpdateEvent").indexOf(n)!==-1},_handleInputKeyDown:function(t){var r=this._listElement(),u=[s,e,f],i=t.which;r.is(":hidden")||(n.inArray(i,u)>-1?t.preventDefault():i!==o&&this._toggleElementSelectedClass(!0))},_handleInputKeyUp:function(n){var t=n.which;this._caretPosition={start:this._input().prop("selectionStart"),end:this._input().prop("selectionEnd")};switch(t){case f:this._handleInputDownKey();break;case e:this._handleInputUpKey();break;case o:this._handleInputEnterKey();break;case l:case s:this._handleInputCompleteKeys();break;case c:this._hideDropDown();break;default:return}},_handleInputDownKey:function(){var t=this._listSelectedItemElement(),n;t.length?(n=t.next(),n.length?n.addClass(this._getSelectedItemClass()):this._toggleElementSelectedClass(!0),t.removeClass(this._getSelectedItemClass()),this._list.scrollToItem(n)):(this._listItemElement().first().addClass(this._getSelectedItemClass()),this._list.scrollToItem(this._listItemElement().first()),this._toggleElementSelectedClass(!1))},_handleInputUpKey:function(){var t=this._listSelectedItemElement(),n,i=this._listElement();if(!i.is(":hidden")){if(!t.length){this._listItemElement().last().addClass(this._getSelectedItemClass()),this._list.scrollToItem(this._listItemElement().last()),this._toggleElementSelectedClass(!1);return}t.removeClass(this._getSelectedItemClass()),n=t.prev(),n.length?(n.addClass(this._getSelectedItemClass()),this._list.scrollToItem(n)):this._toggleElementSelectedClass(!0)}},_handleInputEnterKey:function(){var t=this._listSelectedItemElement(),n;if(!t.length){this._hideDropDown();return}n=this._selectedItemDataGetter(),this._caretPosition={start:n.length,end:n.length},this.option("value",n),this._hideDropDown(),this._input().blur()},_handleInputCompleteKeys:function(){var i=this._listElement(),n,t;i.is(":hidden")||(t=this._selectedItemDataGetter(),n=t.length?t:this._dataSource.items()[0],this._caretPosition={start:n.length,end:n.length},n=this._displayGetter(n),this.option("value",n),this._hideDropDown())},_toggleElementSelectedClass:function(n){this._element().toggleClass(this._getSelectedItemClass(),n)},_selectedItemDataGetter:function(){var n=this._listSelectedItemElement();return n.length?this._displayGetter(n.data(b)):[]},_createDropDown:function(){var r=this.option("width"),i=0,u=0;t.devices.current().win8?i=-6:(t.devices.current().platform==="generic"||t.devices.current().tizen)&&(i=-1),this._dropDown=n("<div>").appendTo(this._element()).dxPopup({rtlEnabled:this.option("rtlEnabled"),shading:!1,closeOnOutsideClick:!1,closeOnTargetScroll:!0,showTitle:!1,width:r,showingAction:n.proxy(this._dimensionChanged,this),deferRendering:!1,shownAction:this.option("openAction"),hiddenAction:this.option("closeAction"),position:{my:"left top",at:"left bottom",of:this._$element,offset:{h:u,v:i},collision:"flip"},animation:{show:{type:"pop",duration:400,from:{opacity:0,scale:1},to:{opacity:1,scale:1}},hide:{type:"fade",duration:400,from:1,to:0}}}).dxPopup("instance"),this._dropDown._wrapper().addClass(v),this._renderList()},_dimensionChanged:function(){this._calculatePopupDimensions()},_calculatePopupDimensions:function(){this._calculatePopupHeight(),this._calculatePopupWidth()},_calculatePopupHeight:function(){var t=this._dropDown,i;t.option("height","auto"),i=this._list,this._heightApplyingTimer=setTimeout(function(){var r=t.container().outerHeight(),u=n(window).height()*.5;t.option("height",Math.min(r,u)),i.updateDimensions()})},_calculatePopupWidth:function(){var n=this._element().outerWidth();this._dropDown.option("width",n)},_getSelectedItemClass:function(){return h},_getSelectedItemSelector:function(){return y},_renderList:function(){this._list=n("<div>").appendTo(this._dropDown.content()).dxList({_templates:this.option("_templates"),itemClickAction:n.proxy(this._handleListItemClick,this),itemTemplate:this._getTemplateByOption("itemTemplate"),itemRender:this._getItemRender(),noDataText:"",showNextButton:!1,autoPagingEnabled:!1,dataSource:this._dataSource,indicateLoading:!1}).dxList("instance")},_getItemRender:function(){var t=this.option("itemTemplate");if(!t||!(t in this.option("_templates")))return this.option("itemRender")||n.proxy(this._displayGetter,this)},_handleListItemClick:function(n){var t=this._displayGetter(n.itemData);this._caretPosition={start:t.length,end:t.length},this.option("value",t),this._hideDropDown(),this._input().blur()},_itemsToDataSource:function(){return this._dataSource=new DevExpress.data.DataSource(this.option("items"))},_filterDataSource:function(){this._reloadDataSource(this.option("value")),this._clearSearchTimer()},_reloadDataSource:function(n,t){var i=this,r=i._dataSource;r.searchExpr(i.option("displayExpr")),r.searchOperation(t||i.option("searchMode")),r.searchValue(n),i._dataSource.pageIndex(0),i._dataSource.load().done(function(){i._refreshVisibility()})},_refreshVisibility:function(){var i=this.option("value").length>=this.option("minSearchLength"),t=this._dataSource,n=t&&t.items(),r=n.length;i&&r?n.length===1&&this._displayGetter(n[0])===this.option("value")?this._hideDropDown():this._displayGetter(n[0]).length<this.option("value").length?this._hideDropDown():(this._dropDown._refresh(),this._dropDown.show(),this._calculatePopupHeight()):this._hideDropDown()},_closeOutsideDropDownHandler:function(n){this.callBase(n,!0)},_clean:function(){this.callBase(),delete this._dropDown},_dispose:function(){clearTimeout(this._heightApplyingTimer),this._clearSearchTimer(),this.callBase()},_optionChanged:function(n,t){switch(n){case"items":case"dataSource":n==="items"?this._itemsToDataSource():this._initDataSource();case"itemTemplate":case"itemRender":this._list.option(n,t);break;case"searchMode":this._validateSearchMode();break;case"displayExpr":this._compileDisplayGetter(),this._list.option("itemRender",this._getItemRender());break;case"minSearchLength":case"searchTimeout":break;case"shouldActivateFocusOut":this._invalidate();break;default:this.callBase.apply(this,arguments)}},_handleValueChangeEvent:function(){var n=this.option("value");this.callBase.apply(this,arguments),n!==this.option("value")&&this._applyFilter()},_applyFilter:function(){var t=this.option("value").length>=this.option("minSearchLength");if(!t){this._clearSearchTimer(),this._hideDropDown();return}this.option("searchTimeout")>0?this._searchTimer||(this._searchTimer=setTimeout(n.proxy(this._filterDataSource,this),this.option("searchTimeout"))):this._filterDataSource()},_clearSearchTimer:function(){clearTimeout(this._searchTimer),delete this._searchTimer}}).include(u.DataHelperMixin))}(jQuery,DevExpress),function(n,t,i){var f=t.ui,u=f.events,e="dx-selectbox",o="dx-selectbox-popup",r="dx-selectbox-selected",s="dx-selectbox-multiselect",h="dx-selectbox-container",b="dx-selectbox-arrow",k="dx-selectbox-arrow-container",c="dx-selectbox-tag-container",l="dx-selectbox-tag-item",a="dx-selectbox-tag-item-container",v="dx-selectbox-tag-item-close-button",y="dx-texteditor-empty",p="dxListItemData",w=".dx-list-item",d=".dx-texteditor-border";t.registerComponent("dxSelectBox",f.dxAutocomplete.inherit({_setDefaultOptions:function(){this.callBase(),this.option({items:[],value:i,valueChangeAction:null,placeholder:Globalize.localize("Select"),valueExpr:null,multiSelectEnabled:!1,values:[],valueChangeEvent:"",fieldTemplate:null,displayValue:i,tooltipEnabled:!1,shouldActivateFocusOut:!1})},_optionsByReference:function(){return n.extend(this.callBase(),{value:!0})},_init:function(){this.callBase(),this._dataSource||this._itemsToDataSource(),this._selectedItems=[]},_itemsToDataSource:function(){this._dataSource=new DevExpress.data.DataSource(this.option("items"))},_getValueWidth:function(t){var i=n("<div>").html(t).css({width:"auto",position:"fixed",top:"-3000px",left:"-3000px"}).appendTo("body");return i.width()},_setTooltip:function(n){this.option("tooltipEnabled")&&(this._$element.context.title=this._$element.context.scrollWidth<=this._getValueWidth(n)?n:"")},_render:function(){var t,i;this._compileValueGetter(),this.callBase(),t=this.option("value"),t?this._searchValue(t).done(n.proxy(this._updateTextBox,this)):this._updateTextBox(),i=this.option("multiSelectEnabled"),this._element().toggleClass(s,i),this._$placeholder=this._$container.find(".dx-placeholder").eq(0),i&&this._renderTags(),this._setWidgetClasses(),this._setTooltip(this.option("value")),this._shouldHide=!1},_renderTags:function(){var t=this;t._$tagContainer&&t._$tagContainer.remove(),t._$tagContainer=n("<div>").addClass(c);var i=t.option("values")||[],r=u.addNamespace("dxclick",t.NAME),f=[];t._selectedItems=[],n.each(i,function(i,u){var o,e=n("<div>").addClass(a),s=n("<div>").addClass(l).appendTo(e),h=n("<div>").addClass(v).appendTo(e);f.push(t._searchValue(u).done(function(n){o=t._displayGetter(n),s.append(o),t._selectedItems.push(n)}));h.off(r).on(r,n.proxy(t._deleteTag,t));e.appendTo(t._$tagContainer)}),t._$tagContainer.appendTo(t._$container),t._element().toggleClass(y,!i.length),t._input().val(i.length?" ":null),n.when.apply(n,f).done(function(){t._renderInputTemplate()}),i.length>0?t._$placeholder.hide():t._$placeholder.show()},_deleteTag:function(t){t.stopPropagation();var u=n(t.currentTarget.parentElement),i=u.index(),r=this.option("values");this.option().value=this.option("values")[i],r.splice(i,1),this.option("values",r)},_renderInput:function(t){this._$container=t||n("<div>"),this._$container.addClass(h),this._element().append(this._$container),this.callBase(this._$container)},_renderInputTemplate:function(){var n=this._getTemplateByOption("fieldTemplate"),i;this.option("fieldTemplate")&&n&&(this._$container.empty(),i=this.option("multiSelectEnabled")?this._selectedItems:this._selectedItem,n.render(this._$container,i),this._input().length||t.utils.logger.warn("A template should contain dxTextBox widget"))},_handleValueChangeEvent:function(n){var t=[n];this._input().val()||t.push(i),this.callBase.apply(this,t)},_renderButton:function(){this.callBase(!1)},_renderValue:function(){if(this.option("value")!==i){var r=n.proxy(this.callBase,this);this._searchValue(this.option("value")).done(n.proxy(function(n){n===i&&(n=this.option("value")),this._selectedItem=n,this.option("displayValue",this._displayGetter(n)),this._setTooltip(n),r(this._displayGetter(n))},this))}else this._selectedItem=null,this.option("displayValue",null),this._setTooltip(null),this.callBase(null)},_readOnlyPropValue:function(){return!0},_createDropDown:function(){var r=this,i;this.callBase(),this._dropDown.beginUpdate(),t.devices.current().win8&&(i=this._dropDown.option("position"),n.extend(i,{at:"left top",offset:{h:0,v:0}}),this._dropDown.option("position",i)),this._dropDown.option("closeOnOutsideClick",n.proxy(this._closeOutsideDropDownHandler,this)),this._dropDown.endUpdate()},_setWidgetClasses:function(){var n=this._element(),t=this._dropDown._element();n.addClass(e),t.addClass(o)},_pointerDownHandler:function(){this._dropDown.option("visible")&&(this._shouldHide=!0)},_clickHandler:function(){this._dropDown.option("visible")||this._shouldHide?this._shouldHide=!1:this._showDropDown()},_applyFilter:n.noop,_updateTextBox:function(t){var i=this,r=u.addNamespace("dxclick",this.NAME),f=u.addNamespace("dxpointerdown",this.NAME);this._clickAction=this._createAction(function(){i._clickHandler()}),this._selectedItem=t,this._renderInputTemplate();this._$container.off(r).off(f).on(r,function(){i._clickAction()}).on(f,n.proxy(this._pointerDownHandler,this))},_compileValueGetter:function(){this._valueGetter=t.data.utils.compileGetter(this._valueGetterExpr())},_valueGetterExpr:function(){return this.option("valueExpr")||this._dataSource&&this._dataSource._store._key||"this"},_setSelectedClass:function(t,u){if(u=u,this.option("multiSelectEnabled"))n.each(this._getSelected(),function(){n(this).addClass(r)});else{if(t=t||this._getSelected(),t===null)return;var f=u!==i?this._optionValuesEqual("value",this._valueGetter(u),this.option("value")):!0;t.toggleClass(r,f)}},_getSelected:function(){var t=[],i=this._list._element(),r=this.option("multiSelectEnabled")?this.option("values"):[this.option("value")],u=this._valueGetter;return(n.each(this._list.option("items"),function(f,e){n.inArray(u(e),r)!==-1&&t.push(i.find(w).eq(f))}),!this.option("multiSelectEnabled"))?t[0]||null:t},_removeSelectedClass:function(){this._list._element().find("."+r).removeClass(r)},_updateSelectedItems:function(n,t){this._removeSelectedClass(),this._setSelectedClass(n,t)},_handleListItemClick:function(n){this._hideDropDown(),this._shouldHide=!1,this.option("multiSelectEnabled")?(this.option().value=this._valueGetter(n.itemData),this._addTagValue(this.option("value"))):this.option("value",this._valueGetter(n.itemData))},_handleInputEnterKey:function(){this.callBase(),this.option("multiSelectEnabled")&&this.option("value")&&this._addTagValue(this.option("value"))},_selectedItemDataGetter:function(){var n=this._listSelectedItemElement();return n.length?this._valueGetter(n.data(p)):[]},_addTagValue:function(t){var r=this.option("values")||[],i=[];n.inArray(t,r)===-1&&(i.push.apply(i,r),i.push(t),this.option("values",i))},_searchValue:function(n){var t=this._valueGetterExpr();return this._loadSingle(t,n)},_changeValueExpr:function(){this._compileValueGetter(),this.option("value",this._valueGetter(this._selectedItem))},_getSelectedItemClass:function(){return r},_getSelectedItemSelector:function(){return"."+r},_renderList:function(){this.callBase(),this._list.option({autoPagingEnabled:!0,itemRenderedAction:n.proxy(function(n){this._setSelectedClass(n.itemElement,n.itemData)},this)})},_hideOnBlur:function(){return!1},_handleClearValue:function(){this.option("multiSelectEnabled")&&this.option("values",[]),this.option("value",null)},_optionChanged:function(n,t,i){switch(n){case"value":this.callBase.apply(this,arguments),this._updateSelectedItems(),this._renderInputTemplate();break;case"displayValue":break;case"tooltipEnabled":this._setTooltip(this.option("value"));break;case"valueExpr":this._changeValueExpr();break;case"displayExpr":this._compileDisplayGetter(),this._refresh();break;case"fieldTemplate":this._renderInputTemplate();break;case"values":this.option("multiSelectEnabled")&&(this._renderTags(),this._updateSelectedItems(),this._raiseValueChangeAction(this.option("value"),i,{values:t}));break;case"multiSelectEnabled":this._refresh();break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),function(n,t){var f=t.ui,w=f.events,e=t.utils,o=t.fx,s=t.translator,h="dx-multiview",c="dx-multiview-wrapper",l="dx-multiview-item-container",a="dx-multiview-item",v="dx-multiview-item-hidden",y="dxMultiViewItemData",p=function(n){return s.locate(n).left},r=function(n,t){s.move(n,{left:t})},u={moveTo:function(n,t,i){o.animate(n,{type:"slide",to:{left:t},duration:200,complete:i})},complete:function(n){o.stop(n,!0)}};t.registerComponent("dxMultiView",f.CollectionContainerWidget.inherit({_setDefaultOptions:function(){this.callBase(),this.option({selectedIndex:0,swipeEnabled:!0,animationEnabled:!0,loop:!1})},_itemClass:function(){return a},_itemDataKey:function(){return y},_itemContainer:function(){return this._$itemContainer},_selectionByClickEnabled:function(){return!1},_itemWidth:function(){return this._itemWidthValue||(this._itemWidthValue=this._$wrapper.width()),this._itemWidthValue},_clearItemWidthCache:function(){delete this._itemWidthValue},_itemsCount:function(){return this.option("items").length},_normalizeIndex:function(n){var t=this._itemsCount();return n<0&&(n=n+t),n>=t&&(n=n-t),n},_init:function(){this.callBase.apply(this,arguments);var t=this._element();t.addClass(h),this._$wrapper=n("<div>").addClass(c),this._$wrapper.appendTo(t),this._$itemContainer=n("<div>").addClass(l),this._$itemContainer.appendTo(this._$wrapper),this._initSwipeable()},_dimensionChanged:function(){this._clearItemWidthCache()},_renderSelectedIndex:function(n){this._updateItems(n)},_updateItems:function(n,t){this._updateItemsPosition(n,t),this._updateItemsVisibility(n,t)},_updateItemsVisibility:function(t,i){var r=this._itemElements();r.each(function(r,u){var f=n(u),e=r!==t&&r!==i;f.toggleClass(v,e)})},_updateItemsPosition:function(n,t){var i=this._itemElements(),u=-this._animationDirection(t,n);r(i.eq(n),0),r(i.eq(t),u*100+"%")},_updateSelectedIndex:function(t,i){u.complete(this._$itemContainter),this._updateItems(i,t);var f=this._animationDirection(t,i);this._animateItemContainer(f*this._itemWidth(),n.proxy(function(){r(this._$itemContainer,0),this._updateItems(t),this._$itemContainer.width()},this))},_animateItemContainer:function(n,t){this.option("animationEnabled")?u.moveTo(this._$itemContainer,n,t):t()},_animationDirection:function(n,t){var i=p(this._$itemContainer),r=(t-n)*this._getRTLSignCorrection(),u=i!==0,f=u?i:r;return e.sign(f)},_initSwipeable:function(){this._element().dxSwipeable({disabled:!this.option("swipeEnabled"),elastic:!1,itemSizeFunc:n.proxy(this._itemWidth,this),startAction:n.proxy(function(n){this._handleSwipeStart(n.jQueryEvent)},this),updateAction:n.proxy(function(n){this._handleSwipeUpdate(n.jQueryEvent)},this),endAction:n.proxy(function(n){this._handleSwipeEnd(n.jQueryEvent)},this)})},_handleSwipeStart:function(n){u.complete(this._$itemContainer);var t=this.option("selectedIndex"),i=this.option("loop"),r=this._itemsCount()-1,f=this.option("rtlEnabled");n.maxLeftOffset=i||(f?t>0:t<r),n.maxRightOffset=i||(f?t<r:t>0)},_handleSwipeUpdate:function(n){var u=n.offset,t=e.sign(u)*this._getRTLSignCorrection(),i,f;r(this._$itemContainer,u*100+"%"),t!==this._swipeDirection&&(this._swipeDirection=t,i=this.option("selectedIndex"),f=this._normalizeIndex(i-t),this._updateItems(i,f))},_handleSwipeEnd:function(t){var i=t.targetOffset*this._getRTLSignCorrection();i?this.option("selectedIndex",this._normalizeIndex(this.option("selectedIndex")-i)):this._animateItemContainer(0,n.noop),delete this._swipeDirection},_getRTLSignCorrection:function(){return this.option("rtlEnabled")?-1:1},_visibilityChanged:function(n){n&&this._clearItemWidthCache()},_optionChanged:function(n,t){switch(n){case"loop":case"animationEnabled":break;case"swipeEnabled":this._element().dxSwipeable("option","disabled",!t);break;default:this.callBase.apply(this,arguments)}}}))}(jQuery,DevExpress),DevExpress.MOD_WIDGETS_BASE=!0}