# Generated by Django 3.2.16 on 2022-11-05 04:42

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.models.mixins
import nautobot.extras.utils
import taggit.managers
import uuid


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0048_alter_objectchange_change_context_detail"),
        ("nautobot_data_validation_engine", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="minmaxvalidationrule",
            name="_custom_field_data",
            field=models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
        ),
        migrations.AddField(
            model_name="minmaxvalidationrule",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="regularexpressionvalidationrule",
            name="_custom_field_data",
            field=models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
        ),
        migrations.AddField(
            model_name="regularexpressionvalidationrule",
            name="context_processing",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="regularexpressionvalidationrule",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AlterField(
            model_name="regularexpressionvalidationrule",
            name="regular_expression",
            field=models.TextField(),
        ),
        migrations.CreateModel(
            name="UniqueValidationRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("slug", models.SlugField(max_length=100, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                ("error_message", models.CharField(blank=True, max_length=255, null=True)),
                ("field", models.CharField(max_length=50)),
                (
                    "max_instances",
                    models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)]),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=nautobot.extras.utils.FeatureQuery("custom_validators"),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "ordering": ("name",),
                "unique_together": {("content_type", "field")},
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
        migrations.CreateModel(
            name="RequiredValidationRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("slug", models.SlugField(max_length=100, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                ("error_message", models.CharField(blank=True, max_length=255, null=True)),
                ("field", models.CharField(max_length=50)),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=nautobot.extras.utils.FeatureQuery("custom_validators"),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "ordering": ("name",),
                "unique_together": {("content_type", "field")},
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
