def get_colnames(score: str):

    colnames = {
        "charlson": {
            "aids": "AIDS or HIV",
            "ami": "acute myocardial infarction",
            "canc": "cancer any malignancy",
            "cevd": "cerebrovascular disease",
            "chf": "congestive heart failure",
            "copd": "chronic obstructive pulmonary disease",
            "dementia": "dementia",
            "diab": "diabetes without complications",
            "diabwc": "diabetes with complications",
            "hp": "hemiplegia or paraplegia",
            "metacanc": "metastatic solid tumour",
            "mld": "mild liver disease",
            "msld": "moderate or severe liver disease",
            "pud": "peptic ulcer disease",
            "pvd": "peripheral vascular disease",
            "rend": "renal disease",
            "rheumd": "rheumatoid disease",
        },
        "elixhauser": {
            "aids": " AIDS/HIV",
            "alcohol": " alcohol abuse",
            "blane": " blood loss anaemia",
            "carit": " cardiac arrhythmias",
            "chf": " congestive heart failure",
            "coag": " coagulopathy",
            "cpd": " chronic pulmonary disease",
            "dane": " deficiency anaemia",
            "depre": " depression",
            "diabc": " diabetes complicated",
            "diabunc": " diabetes uncomplicated",
            "drug": " drug abuse",
            "fed": " fluid and electrolyte disorders",
            "hypc": " hypertension complicated",
            "hypothy": " hypothyroidism",
            "hypunc": " hypertension uncomplicated",
            "ld": " liver disease",
            "lymph": " lymphoma",
            "metacanc": " metastatic cancer",
            "obes": " obesity",
            "ond": " other neurological disorders",
            "para": " paralysis",
            "pcd": " pulmonary circulation disorders",
            "psycho": " psychoses",
            "pud": " peptic ulcer disease excluding bleeding",
            "pvd": " peripheral vascular disorders",
            "rf": " renal failure",
            "rheumd": " rheumatoid arthritis/collaged vascular disease",
            "solidtum": " solid tumour without metastasis",
            "valv": " valvular disease",
            "wloss": " weight loss",
        },
    }

    return colnames[score]
