import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { Route, RouteBaseProps } from './route';
import { PortMapping } from './shared-interfaces';
/**
 * (experimental) Interface which all VirtualRouter based classes MUST implement.
 *
 * @experimental
 */
export interface IVirtualRouter extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualRouterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualRouterArn: string;
    /**
     * (experimental) The  service mesh that the virtual router resides in.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * (experimental) Add a single route to the router.
     *
     * @experimental
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * (experimental) Interface with base properties all routers willl inherit.
 *
 * @experimental
 */
export interface VirtualRouterBaseProps {
    /**
     * (experimental) Listener specification for the virtual router.
     *
     * @default - A listener on HTTP port 8080
     * @experimental
     */
    readonly listener?: Listener;
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @default - A name is automatically determined
     * @experimental
     */
    readonly virtualRouterName?: string;
}
/**
 * (experimental) A single listener for.
 *
 * @experimental
 */
export interface Listener {
    /**
     * (experimental) Listener port for the virtual router.
     *
     * @experimental
     */
    readonly portMapping: PortMapping;
}
declare abstract class VirtualRouterBase extends cdk.Resource implements IVirtualRouter {
    /**
     * The name of the VirtualRouter
     */
    abstract readonly virtualRouterName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter
     */
    abstract readonly virtualRouterArn: string;
    /**
     * The AppMesh mesh the VirtualRouter belongs to
     */
    abstract readonly mesh: IMesh;
    /**
     * (experimental) Add a single route to the router.
     *
     * @experimental
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * (experimental) The properties used when creating a new VritualRouter.
 *
 * @experimental
 */
export interface VirtualRouterProps extends VirtualRouterBaseProps {
    /**
     * (experimental) The AppMesh mesh the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
/**
 * @experimental
 */
export declare class VirtualRouter extends VirtualRouterBase {
    /**
     * (experimental) Import an existing VirtualRouter given an ARN.
     *
     * @experimental
     */
    static fromVirtualRouterArn(scope: Construct, id: string, virtualRouterArn: string): IVirtualRouter;
    /**
     * (experimental) Import an existing VirtualRouter given names.
     *
     * @experimental
     */
    static fromVirtualRouterName(scope: Construct, id: string, meshName: string, virtualRouterName: string): IVirtualRouter;
    /**
     * (experimental) Import an existing virtual router given attributes.
     *
     * @experimental
     */
    static fromVirtualRouterAttributes(scope: Construct, id: string, attrs: VirtualRouterAttributes): IVirtualRouter;
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterArn: string;
    /**
     * (experimental) The AppMesh mesh the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    private readonly listeners;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualRouterProps);
    /**
     * Add port mappings to the router
     */
    private addListener;
}
/**
 * (experimental) Interface with properties ncecessary to import a reusable VirtualRouter.
 *
 * @experimental
 */
export interface VirtualRouterAttributes {
    /**
     * (experimental) The name of the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterName?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @experimental
     */
    readonly virtualRouterArn?: string;
    /**
     * (experimental) The AppMesh mesh the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly mesh?: IMesh;
    /**
     * (experimental) The name of the AppMesh mesh the VirtualRouter belongs to.
     *
     * @experimental
     */
    readonly meshName?: string;
}
export {};
