# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['seqal']

package_data = \
{'': ['*']}

install_requires = \
['flair==0.8', 'torch==1.7.1']

setup_kwargs = {
    'name': 'seqal',
    'version': '0.2.0',
    'description': 'Sequence labeling active learning framework for Python',
    'long_description': '# SeqAL\n\n<!-- <p align="center">\n  <a href="https://github.com/BrambleXu/seqal/actions?query=workflow%3ACI">\n    <img src="https://img.shields.io/github/workflow/status/BrambleXu/seqal/CI/main?label=CI&logo=github&style=flat-square" alt="CI Status" >\n  </a>\n  <a href="https://seqal.readthedocs.io">\n    <img src="https://img.shields.io/readthedocs/seqal.svg?logo=read-the-docs&logoColor=fff&style=flat-square" alt="Documentation Status">\n  </a>\n  <a href="https://codecov.io/gh/BrambleXu/seqal">\n    <img src="https://img.shields.io/codecov/c/github/BrambleXu/seqal.svg?logo=codecov&logoColor=fff&style=flat-square" alt="Test coverage percentage">\n  </a>\n</p> -->\n<p align="center">\n  <a href="https://github.com/BrambleXu/seqal/actions?query=workflow%3ACI">\n    <img src="https://img.shields.io/github/workflow/status/BrambleXu/seqal/CI/main?label=CI&logo=github&style=flat-square" alt="CI Status" >\n  </a>\n  <a href="https://python-poetry.org/">\n    <img src="https://img.shields.io/badge/packaging-poetry-299bd7?style=flat-square&logo=data:image/png" alt="Poetry">\n  </a>\n  <a href="https://github.com/ambv/black">\n    <img src="https://img.shields.io/badge/code%20style-black-000000.svg?style=flat-square" alt="black">\n  </a>\n  <a href="https://github.com/pre-commit/pre-commit">\n    <img src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=flat-square" alt="pre-commit">\n  </a>\n</p>\n<p align="center">\n  <a href="https://pypi.org/project/seqal/">\n    <img src="https://img.shields.io/pypi/v/seqal.svg?logo=python&logoColor=fff&style=flat-square" alt="PyPI Version">\n  </a>\n  <img src="https://img.shields.io/pypi/pyversions/seqal.svg?style=flat-square&logo=python&amp;logoColor=fff" alt="Supported Python versions">\n  <img src="https://img.shields.io/pypi/l/seqal.svg?style=flat-square" alt="License">\n</p>\n\nSequence labeling active learning framework for Python\n\n## Installation\n\nInstall this via pip (or your favourite package manager):\n\n`pip install seqal`\n\n\n## Usage\n\n### Prepare data\n\nThe tagging scheme is the IOB scheme.\n\n```\n    U.N. NNP I-ORG\nofficial NN  O\n   Ekeus NNP I-PER\n   heads VBZ O\n     for IN  O\n Baghdad NNP I-LOC\n       . .   O\n```\n\nEach line contains four fields: the word, its partof-speech tag and its named entity tag. Words tagged with O are outside of named entities. \n\n### Examples\n\n```python\nfrom flair.embeddings import WordEmbeddings, StackedEmbeddings\nfrom flair.models import SequenceTagger\nfrom seqal.active_learner import ActiveLearner\nfrom seqal.query_strategies import mnlp_sampling\n\n# 1. get the corpus\ncorpus = Corpus(train="train.data", dev="dev.data", test="dev.data")\n\n# 2. what tag do we want to predict?\ntag_type = "ner"\n\n# 3. make the tag dictionary from the corpus\ntag_dictionary = corpus.make_tag_dictionary(tag_type=tag_type)\n\n# 4. initialize embeddings\nembedding_types = [WordEmbeddings("glove")]\nembeddings = StackedEmbeddings(embeddings=embedding_types)\n\n# 5. initialize sequence tagger\ntagger = SequenceTagger(hidden_size=256, embeddings=embeddings, tag_dictionary=tag_dictionary, tag_type=tag_type)\n\n# 6. initialize learner\nparams = {}\nparams["max_epochs"] = 1\nparams["learning_rate"] = 0.1\nparams["train_with_dev"] = True\n\nlearner = ActiveLearner(tagger, mnlp_sampling, corpus, **params)\n\n# 7. initial training\nlearner.fit(save_path="output/init_train")\n\n# 8. query for labels\nsents, query_samples = learner.query(sents, percent_count)\n\n# ...obtaining new labels for "query_samples" from the Oracle...\n\n# 9. retrain model with new labeled data\nlearner.teach(query_samples, save_path=f"output/retrain")\n```\n\n## Construct envirement locally\n\nIf you want to make a PR or implement something locally, you can follow bellow instruction to construct the development envirement locally.\n\nFirst we create a environment "seqal" based on the `environment.yml` file.\n\nWe use conda as envirement management tool, so install it first.\n\n```\nconda env create -f environment.yml\n```\n\nThen we activate the environment.\n\n```\nconda activate seqal\n```\n\nInstall poetry for dependency management.\n\n```\ncurl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python -\n```\n\nAdd poetry path in your shell configure file (`bashrc`, `zshrc`, etc.)\n```\nexport PATH="$HOME/.poetry/bin:$PATH"\n```\n\nInstalling dependencies from `pyproject.toml`.\n\n```\npoetry install\n```\n\nYou can make development locally now.\n\nIf you want to delete the local envirement, run below command.\n```\nconda remove --name seqal --all\n```\n\n## Performance\n\nSee [performance.md](./docs/source/performance.md) for detail.\n\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<!-- markdownlint-enable -->\n<!-- prettier-ignore-end -->\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n\n## Credits\n\n- [Cookiecutter](https://github.com/audreyr/cookiecutter)\n- [browniebroke/cookiecutter-pypackage](https://github.com/browniebroke/cookiecutter-pypackage)\n- [flairNLP/flair](https://github.com/flairNLP/flair)\n- [modal](https://github.com/modAL-python/modAL)\n',
    'author': 'Xu Liang',
    'author_email': 'liangxu006@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/BrambleXu/seqal',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
