# `gppt`: get-pixivpy-token

![PyPI](https://img.shields.io/pypi/v/gppt?color=blue) [![Maintainability]](https://codeclimate.com/github/eggplants/get-pixiv-token/maintainability)

- Get your Pixiv token (for running [upbit/pixivpy](https://github.com/upbit/pixivpy))
- Refine [pixiv_auth.py](https://gist.github.com/ZipFile/c9ebedb224406f4f11845ab700124362)

## Install

```bash
❭ pip install gppt
```

## Run

- Note: _In advance, please setup google-chrome-stable + selenium + webdriver_
- On Ubuntu, my setup script is available

```bash
❭ ./setup.sh
```

- Then

```bash
❭ gppt login
[!]: The browser will start. Please login.
(Log in to Pixiv from the login screen that starts up.)
[+]: Success!
access_token: ***
refresh_token: ***
expires_in: 3600
```

## Help

```bash
❭ gppt -h
usage: gppt [-h] {login,l,login-headless,lh,refresh,r} ...

Get your Pixiv token (for running upbit/pixivpy)

positional arguments:
  {login,l,login-headless,lh,refresh,r}
    login (l)           retrieving auth token
    login-headless (lh)
                        `login` in headless mode
    refresh (r)         refresh tokens

optional arguments:
  -h, --help            show this help message and exit
```

```bash
❭ gppt login -h
usage: gppt l [-h] [-u USERNAME] [-p PASSWORD]

optional arguments:
  -h, --help            show this help message and exit
  -u USERNAME, --username USERNAME
                        your E-mail address / pixiv ID
  -p PASSWORD, --password PASSWORD
                        your current pixiv password
```

```bash
❭ gppt lh -h
usage: gppt login-headless [-h] -u USERNAME -p PASSWORD

optional arguments:
  -h, --help            show this help message and exit
  -u USERNAME, --username USERNAME
                        your E-mail address / pixiv ID
  -p PASSWORD, --password PASSWORD
                        your current pixiv password
```

```bash
❭ gppt r -h
usage: gppt refresh [-h] refresh_token

positional arguments:
  refresh_token

optional arguments:
  -h, --help     show this help message and exit
```

[maintainability]: https://api.codeclimate.com/v1/badges/b40b8fa2c9d71f869b9c/maintainability
