# OSCR-django-client
OSCR API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 2025.3.29.0
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import OSCR_django_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import OSCR_django_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import OSCR_django_client
from OSCR_django_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://127.0.0.1
# See configuration.py for a list of all supported configuration parameters.
configuration = OSCR_django_client.Configuration(
    host = "http://127.0.0.1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: Basic
configuration = OSCR_django_client.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)


# Enter a context with an instance of the API client
with OSCR_django_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = OSCR_django_client.CombatlogApi(api_client)
    id = 56 # int | A unique integer value identifying this combat log.

    try:
        # Combat Log Download
        api_response = api_instance.combatlog_download(id)
        print("The response of CombatlogApi->combatlog_download:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CombatlogApi->combatlog_download: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://127.0.0.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CombatlogApi* | [**combatlog_download**](docs/CombatlogApi.md#combatlog_download) | **GET** /combatlog/{id}/download/ | Combat Log Download
*CombatlogApi* | [**combatlog_download_raw**](docs/CombatlogApi.md#combatlog_download_raw) | **GET** /combatlog/{id}/download_raw/ | Combat Log Download
*CombatlogApi* | [**combatlog_list**](docs/CombatlogApi.md#combatlog_list) | **GET** /combatlog/ | 
*CombatlogApi* | [**combatlog_read**](docs/CombatlogApi.md#combatlog_read) | **GET** /combatlog/{id}/ | 
*CombatlogApi* | [**combatlog_upload**](docs/CombatlogApi.md#combatlog_upload) | **POST** /combatlog/upload/ | Combat Log Upload
*CombatlogApi* | [**combatlog_uploadv2**](docs/CombatlogApi.md#combatlog_uploadv2) | **POST** /combatlog/uploadv2/ | Combat Log Upload
*LadderApi* | [**ladder_list**](docs/LadderApi.md#ladder_list) | **GET** /ladder/ | 
*LadderApi* | [**ladder_read**](docs/LadderApi.md#ladder_read) | **GET** /ladder/{id}/ | 
*LadderEntriesApi* | [**ladder_entries_list**](docs/LadderEntriesApi.md#ladder_entries_list) | **GET** /ladder-entries/ | 
*LadderEntriesApi* | [**ladder_entries_read**](docs/LadderEntriesApi.md#ladder_entries_read) | **GET** /ladder-entries/{id}/ | 
*SystemApi* | [**system_latest**](docs/SystemApi.md#system_latest) | **GET** /system/latest/ | 
*VariantApi* | [**variant_list**](docs/VariantApi.md#variant_list) | **GET** /variant/ | 
*VariantApi* | [**variant_read**](docs/VariantApi.md#variant_read) | **GET** /variant/{name}/ | 


## Documentation For Models

 - [CombatLog](docs/CombatLog.md)
 - [CombatLogUploadResponse](docs/CombatLogUploadResponse.md)
 - [CombatLogUploadV2Response](docs/CombatLogUploadV2Response.md)
 - [CombatlogList200Response](docs/CombatlogList200Response.md)
 - [Ladder](docs/Ladder.md)
 - [LadderEntriesList200Response](docs/LadderEntriesList200Response.md)
 - [LadderEntry](docs/LadderEntry.md)
 - [LadderList200Response](docs/LadderList200Response.md)
 - [Metadata](docs/Metadata.md)
 - [Update](docs/Update.md)
 - [Variant](docs/Variant.md)
 - [VariantList200Response](docs/VariantList200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Basic"></a>
### Basic

- **Type**: HTTP basic authentication


## Author




