# coding: utf-8

"""
    OSCR API

    OSCR API

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Variant(BaseModel):
    """
    Variant
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    start_date: datetime
    end_date: datetime
    is_ground_variant: Optional[StrictBool] = None
    is_space_variant: Optional[StrictBool] = None
    combat_time_source: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None
    combat_time_threshold: Optional[Union[StrictFloat, StrictInt]] = None
    exclude_space: Optional[List[StrictStr]] = None
    exclude_ground: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["name", "start_date", "end_date", "is_ground_variant", "is_space_variant", "combat_time_source", "combat_time_threshold", "exclude_space", "exclude_ground"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Variant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Variant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "is_ground_variant": obj.get("is_ground_variant"),
            "is_space_variant": obj.get("is_space_variant"),
            "combat_time_source": obj.get("combat_time_source"),
            "combat_time_threshold": obj.get("combat_time_threshold"),
            "exclude_space": obj.get("exclude_space"),
            "exclude_ground": obj.get("exclude_ground")
        })
        return _obj


