# coding: utf-8

"""
    OSCR API

    OSCR API

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Ladder(BaseModel):
    """
    Ladder
    """ # noqa: E501
    id: Optional[StrictInt] = None
    variant_name: Optional[StrictStr] = None
    name: Annotated[str, Field(min_length=1, strict=True)]
    difficulty: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None
    is_solo: Optional[StrictBool] = None
    is_space: Optional[StrictBool] = None
    metric: Annotated[str, Field(min_length=1, strict=True)]
    variant: StrictStr
    __properties: ClassVar[List[str]] = ["id", "variant_name", "name", "difficulty", "is_solo", "is_space", "metric", "variant"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ladder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "variant_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if difficulty (nullable) is None
        # and model_fields_set contains the field
        if self.difficulty is None and "difficulty" in self.model_fields_set:
            _dict['difficulty'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ladder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "variant_name": obj.get("variant_name"),
            "name": obj.get("name"),
            "difficulty": obj.get("difficulty"),
            "is_solo": obj.get("is_solo"),
            "is_space": obj.get("is_space"),
            "metric": obj.get("metric"),
            "variant": obj.get("variant")
        })
        return _obj


