# cdk-toolkit

AWS CDK Toolkit


## Getting Started

### Install AWS CDK
```bash
npm install -g aws-cdk
```

### Create CDK Project Directory
```bash
mkdir cdk-proj
cd cdk-proj
```

### Create CDK Project Environment
```bash
cdk init app --language python
python3 -m venv .venv
source .venv/bin/activate
python3 -m pip install -r requirements.txt
```

### Add Stacks to CDK Project

```python
from aws_cdk import ( 
    Stack, 
)
from constructs import Construct

from cdk_toolkit import storage

class CdkProjStack(Stack): 
    def __init__(self, scope: Construct, construct_id: str, **kwargs) -> None:
        super().__init__(scope, construct_id, **kwargs)
        bucket_name = "cdk-proj-bucket-name-test"
        s3_bucket = storage.createS3Bucket(self, bucket_name, versioned=False)
```

### Update CDK Project App
```python
# Sample App
import aws_cdk as cdk
from aws_cdk import Aws, Stack, Tags

from cdk_proj.cdk_proj_stack import CdkProjStack

# AWS CDK App
app = cdk.App()

# AWS CDK Environment
AWS_ACCOUNT_NUMBER="111111111"
AWS_ACCOUNT_REGION="us-west-2"
cdk_environment = cdk.Environment(account=AWS_ACCOUNT_NUMBER, region=AWS_ACCOUNT_REGION)

# Project Stack
CdkProjStack(app, "CdkProjStack", env=cdk_environment)

app.synth()

```

### Create CDK Bootstrap
```
echo AWS_ACCOUNT_NUMBER=111111111
echo AWS_ACCOUNT_REGION=us-west-2
cdk bootstrap aws://$AWS_ACCOUNT_NUMBER/$AWS_ACCOUNT_REGION ---toolkit-stack-name CDK-TOOLKIT --qualifier cdktoolkit
```

### Deply CDK Project
```
# Preview CDK Project Stack Deployment
cdk diff

# Deploy CDK Project Stack(s)
cdk deploy

# Destroy CDK Project Stack(s)
cdk destroy
```

