/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsimple.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.IndexManager;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.NodeMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMemberMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.TagMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.UserDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayGeometryBuilder;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayNodeMapper;
import org.postgis.Geometry;

public class PostgreSqlWriter
implements Sink,
EntityProcessor {
    private static final Logger LOG = Logger.getLogger(PostgreSqlWriter.class.getName());
    private static final int INSERT_BULK_ROW_COUNT_NODE = 1000;
    private static final int INSERT_BULK_ROW_COUNT_NODE_TAG = 1000;
    private static final int INSERT_BULK_ROW_COUNT_WAY = 1000;
    private static final int INSERT_BULK_ROW_COUNT_WAY_TAG = 1000;
    private static final int INSERT_BULK_ROW_COUNT_WAY_NODE = 1000;
    private static final int INSERT_BULK_ROW_COUNT_RELATION = 1000;
    private static final int INSERT_BULK_ROW_COUNT_RELATION_TAG = 1000;
    private static final int INSERT_BULK_ROW_COUNT_RELATION_MEMBER = 1000;
    private DatabaseContext dbCtx;
    private boolean enableBboxBuilder;
    private boolean enableLinestringBuilder;
    private SchemaVersionValidator schemaVersionValidator;
    private IndexManager indexManager;
    private List<Node> nodeBuffer;
    private List<DbFeature<Tag>> nodeTagBuffer;
    private List<Way> wayBuffer;
    private List<DbFeature<Tag>> wayTagBuffer;
    private List<DbOrderedFeature<WayNode>> wayNodeBuffer;
    private List<Relation> relationBuffer;
    private List<DbFeature<Tag>> relationTagBuffer;
    private List<DbOrderedFeature<RelationMember>> relationMemberBuffer;
    private boolean initialized;
    private HashSet<Integer> userSet;
    private ActionDao actionDao;
    private UserDao userDao;
    private ReleasableStatementContainer statementContainer;
    private PreparedStatement singleNodeStatement;
    private PreparedStatement bulkNodeStatement;
    private PreparedStatement singleNodeTagStatement;
    private PreparedStatement bulkNodeTagStatement;
    private PreparedStatement singleWayStatement;
    private PreparedStatement bulkWayStatement;
    private PreparedStatement singleWayTagStatement;
    private PreparedStatement bulkWayTagStatement;
    private PreparedStatement singleWayNodeStatement;
    private PreparedStatement bulkWayNodeStatement;
    private PreparedStatement singleRelationStatement;
    private PreparedStatement bulkRelationStatement;
    private PreparedStatement singleRelationTagStatement;
    private PreparedStatement bulkRelationTagStatement;
    private PreparedStatement singleRelationMemberStatement;
    private PreparedStatement bulkRelationMemberStatement;
    private NodeMapper nodeBuilder;
    private WayMapper wayBuilder;
    private RelationMapper relationBuilder;
    private TagMapper nodeTagBuilder;
    private TagMapper wayTagBuilder;
    private TagMapper relationTagBuilder;
    private WayNodeMapper wayNodeBuilder;
    private RelationMemberMapper relationMemberBuilder;
    private WayGeometryBuilder wayGeometryBuilder;

    public PostgreSqlWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean enableBboxBuilder, boolean enableLinestringBuilder, NodeLocationStoreType storeType) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.enableBboxBuilder = enableBboxBuilder;
        this.enableLinestringBuilder = enableLinestringBuilder;
        this.schemaVersionValidator = new SchemaVersionValidator(this.dbCtx, preferences);
        this.indexManager = new IndexManager(this.dbCtx, !enableBboxBuilder, !enableLinestringBuilder);
        this.nodeBuffer = new ArrayList<Node>();
        this.nodeTagBuffer = new ArrayList<DbFeature<Tag>>();
        this.wayBuffer = new ArrayList<Way>();
        this.wayTagBuffer = new ArrayList<DbFeature<Tag>>();
        this.wayNodeBuffer = new ArrayList<DbOrderedFeature<WayNode>>();
        this.relationBuffer = new ArrayList<Relation>();
        this.relationTagBuffer = new ArrayList<DbFeature<Tag>>();
        this.relationMemberBuffer = new ArrayList<DbOrderedFeature<RelationMember>>();
        this.actionDao = new ActionDao(this.dbCtx, false);
        this.userSet = new HashSet();
        this.userDao = new UserDao(this.dbCtx, this.actionDao);
        this.nodeBuilder = new NodeMapper();
        this.wayBuilder = new WayMapper(enableBboxBuilder, enableLinestringBuilder);
        this.relationBuilder = new RelationMapper();
        this.nodeTagBuilder = new TagMapper(this.nodeBuilder.getEntityName());
        this.wayTagBuilder = new TagMapper(this.wayBuilder.getEntityName());
        this.relationTagBuilder = new TagMapper(this.relationBuilder.getEntityName());
        this.wayNodeBuilder = new WayNodeMapper();
        this.relationMemberBuilder = new RelationMemberMapper();
        this.wayGeometryBuilder = new WayGeometryBuilder(storeType);
        this.statementContainer = new ReleasableStatementContainer();
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            this.schemaVersionValidator.validateVersion(5);
            this.bulkNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.nodeBuilder.getSqlInsert(1000)));
            this.singleNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.nodeBuilder.getSqlInsert(1)));
            this.bulkNodeTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.nodeTagBuilder.getSqlInsert(1000)));
            this.singleNodeTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.nodeTagBuilder.getSqlInsert(1)));
            this.bulkWayStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayBuilder.getSqlInsert(1000)));
            this.singleWayStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayBuilder.getSqlInsert(1)));
            this.bulkWayTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayTagBuilder.getSqlInsert(1000)));
            this.singleWayTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayTagBuilder.getSqlInsert(1)));
            this.bulkWayNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayNodeBuilder.getSqlInsert(1000)));
            this.singleWayNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.wayNodeBuilder.getSqlInsert(1)));
            this.bulkRelationStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationBuilder.getSqlInsert(1000)));
            this.singleRelationStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationBuilder.getSqlInsert(1)));
            this.bulkRelationTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationTagBuilder.getSqlInsert(1000)));
            this.singleRelationTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationTagBuilder.getSqlInsert(1)));
            this.bulkRelationMemberStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationMemberBuilder.getSqlInsert(1000)));
            this.singleRelationMemberStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(this.relationMemberBuilder.getSqlInsert(1)));
            this.indexManager.prepareForLoad();
            LOG.fine("Loading data.");
            this.initialized = true;
        }
    }

    private void writeUser(OsmUser user) {
        if (!user.equals((Object)OsmUser.NONE) && !this.userSet.contains(user.getId())) {
            this.userDao.addUser(user);
            this.userSet.add(user.getId());
        }
    }

    private void flushNodes(boolean complete) {
        while (this.nodeBuffer.size() >= 1000) {
            ArrayList<Node> processedNodes = new ArrayList<Node>(1000);
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                Node node = this.nodeBuffer.remove(0);
                processedNodes.add(node);
                prmIndex = this.nodeBuilder.populateEntityParameters(this.bulkNodeStatement, prmIndex, node);
            }
            try {
                this.bulkNodeStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert nodes into the database.", (Throwable)e);
            }
            for (Node node : processedNodes) {
                this.addNodeTags(node);
            }
        }
        if (complete) {
            while (this.nodeBuffer.size() > 0) {
                Node node = this.nodeBuffer.remove(0);
                this.nodeBuilder.populateEntityParameters(this.singleNodeStatement, 1, node);
                try {
                    this.singleNodeStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a node into the database.", (Throwable)e);
                }
                this.addNodeTags(node);
            }
        }
    }

    private void addNodeTags(Node node) {
        for (Tag tag : node.getTags()) {
            this.nodeTagBuffer.add((DbFeature<Tag>)new DbFeature(node.getId(), (Storeable)tag));
        }
        this.flushNodeTags(false);
    }

    private void flushNodeTags(boolean complete) {
        while (this.nodeTagBuffer.size() >= 1000) {
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                prmIndex = this.nodeTagBuilder.populateEntityParameters(this.bulkNodeTagStatement, prmIndex, this.nodeTagBuffer.remove(0));
            }
            try {
                this.bulkNodeTagStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert node tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.nodeTagBuffer.size() > 0) {
                this.nodeTagBuilder.populateEntityParameters(this.singleNodeTagStatement, 1, this.nodeTagBuffer.remove(0));
                try {
                    this.singleNodeTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a node tag into the database.", (Throwable)e);
                }
            }
        }
    }

    private void flushWays(boolean complete) {
        while (this.wayBuffer.size() >= 1000) {
            ArrayList<Way> processedWays = new ArrayList<Way>(1000);
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                Way way = this.wayBuffer.remove(0);
                processedWays.add(way);
                ArrayList<Geometry> geometries = new ArrayList<Geometry>();
                if (this.enableBboxBuilder) {
                    geometries.add((Geometry)this.wayGeometryBuilder.createWayBbox(way));
                }
                if (this.enableLinestringBuilder) {
                    geometries.add((Geometry)this.wayGeometryBuilder.createWayLinestring(way));
                }
                prmIndex = this.wayBuilder.populateEntityParameters(this.bulkWayStatement, prmIndex, way, geometries);
            }
            try {
                this.bulkWayStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert ways into the database.", (Throwable)e);
            }
            for (Way way : processedWays) {
                this.addWayTags(way);
                this.addWayNodes(way);
            }
        }
        if (complete) {
            while (this.wayBuffer.size() > 0) {
                Way way = this.wayBuffer.remove(0);
                ArrayList<Geometry> geometries = new ArrayList<Geometry>();
                if (this.enableBboxBuilder) {
                    geometries.add((Geometry)this.wayGeometryBuilder.createWayBbox(way));
                }
                if (this.enableLinestringBuilder) {
                    geometries.add((Geometry)this.wayGeometryBuilder.createWayLinestring(way));
                }
                this.wayBuilder.populateEntityParameters(this.singleWayStatement, 1, way, geometries);
                try {
                    this.singleWayStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way into the database.", (Throwable)e);
                }
                this.addWayTags(way);
                this.addWayNodes(way);
            }
        }
    }

    private void addWayTags(Way way) {
        for (Tag tag : way.getTags()) {
            this.wayTagBuffer.add((DbFeature<Tag>)new DbFeature(way.getId(), (Storeable)tag));
        }
        this.flushWayTags(false);
    }

    private void addWayNodes(Way way) {
        int sequenceId = 0;
        for (WayNode wayNode : way.getWayNodes()) {
            this.wayNodeBuffer.add((DbOrderedFeature<WayNode>)new DbOrderedFeature(way.getId(), (Storeable)wayNode, sequenceId++));
        }
        this.flushWayNodes(false);
    }

    private void flushWayTags(boolean complete) {
        while (this.wayTagBuffer.size() >= 1000) {
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                prmIndex = this.wayTagBuilder.populateEntityParameters(this.bulkWayTagStatement, prmIndex, this.wayTagBuffer.remove(0));
            }
            try {
                this.bulkWayTagStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert way tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.wayTagBuffer.size() > 0) {
                this.wayTagBuilder.populateEntityParameters(this.singleWayTagStatement, 1, this.wayTagBuffer.remove(0));
                try {
                    this.singleWayTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way tag into the database.", (Throwable)e);
                }
            }
        }
    }

    private void flushWayNodes(boolean complete) {
        while (this.wayNodeBuffer.size() >= 1000) {
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                prmIndex = this.wayNodeBuilder.populateEntityParameters(this.bulkWayNodeStatement, prmIndex, this.wayNodeBuffer.remove(0));
            }
            try {
                this.bulkWayNodeStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert way nodes into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.wayNodeBuffer.size() > 0) {
                this.wayNodeBuilder.populateEntityParameters(this.singleWayNodeStatement, 1, this.wayNodeBuffer.remove(0));
                try {
                    this.singleWayNodeStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way node into the database.", (Throwable)e);
                }
            }
        }
    }

    private void flushRelations(boolean complete) {
        while (this.relationBuffer.size() >= 1000) {
            ArrayList<Relation> processedRelations = new ArrayList<Relation>(1000);
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                Relation relation = this.relationBuffer.remove(0);
                processedRelations.add(relation);
                prmIndex = this.relationBuilder.populateEntityParameters(this.bulkRelationStatement, prmIndex, relation);
            }
            try {
                this.bulkRelationStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relations into the database.", (Throwable)e);
            }
            for (Relation relation : processedRelations) {
                this.addRelationTags(relation);
                this.addRelationMembers(relation);
            }
        }
        if (complete) {
            while (this.relationBuffer.size() > 0) {
                Relation relation = this.relationBuffer.remove(0);
                this.relationBuilder.populateEntityParameters(this.singleRelationStatement, 1, relation);
                try {
                    this.singleRelationStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation into the database.", (Throwable)e);
                }
                this.addRelationTags(relation);
                this.addRelationMembers(relation);
            }
        }
    }

    private void addRelationTags(Relation relation) {
        for (Tag tag : relation.getTags()) {
            this.relationTagBuffer.add((DbFeature<Tag>)new DbFeature(relation.getId(), (Storeable)tag));
        }
        this.flushRelationTags(false);
    }

    private void addRelationMembers(Relation relation) {
        int sequenceId = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            this.relationMemberBuffer.add((DbOrderedFeature<RelationMember>)new DbOrderedFeature(relation.getId(), (Storeable)relationMember, sequenceId++));
        }
        this.flushRelationMembers(false);
    }

    private void flushRelationTags(boolean complete) {
        while (this.relationTagBuffer.size() >= 1000) {
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                prmIndex = this.relationTagBuilder.populateEntityParameters(this.bulkRelationTagStatement, prmIndex, this.relationTagBuffer.remove(0));
            }
            try {
                this.bulkRelationTagStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relation tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.relationTagBuffer.size() > 0) {
                this.relationTagBuilder.populateEntityParameters(this.singleRelationTagStatement, 1, this.relationTagBuffer.remove(0));
                try {
                    this.singleRelationTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation tag into the database.", (Throwable)e);
                }
            }
        }
    }

    private void flushRelationMembers(boolean complete) {
        while (this.relationMemberBuffer.size() >= 1000) {
            int prmIndex = 1;
            for (int i = 0; i < 1000; ++i) {
                prmIndex = this.relationMemberBuilder.populateEntityParameters(this.bulkRelationMemberStatement, prmIndex, this.relationMemberBuffer.remove(0));
            }
            try {
                this.bulkRelationMemberStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relation members into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.relationMemberBuffer.size() > 0) {
                this.relationMemberBuilder.populateEntityParameters(this.singleRelationMemberStatement, 1, this.relationMemberBuffer.remove(0));
                try {
                    this.singleRelationMemberStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation member into the database.", (Throwable)e);
                }
            }
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void complete() {
        this.initialize();
        LOG.fine("Flushing buffers.");
        this.flushNodes(true);
        this.flushNodeTags(true);
        this.flushWays(true);
        this.flushWayTags(true);
        this.flushWayNodes(true);
        this.flushRelations(true);
        this.flushRelationTags(true);
        this.flushRelationMembers(true);
        LOG.fine("Data load complete.");
        this.indexManager.completeAfterLoad();
        LOG.fine("Committing changes.");
        this.dbCtx.commit();
        LOG.fine("Vacuuming database.");
        this.dbCtx.setAutoCommit(true);
        this.dbCtx.executeStatement("VACUUM ANALYZE");
        LOG.fine("Complete.");
    }

    public void process(EntityContainer entityContainer) {
        this.initialize();
        this.writeUser(entityContainer.getEntity().getUser());
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer bound) {
    }

    public void process(NodeContainer nodeContainer) {
        if (this.enableBboxBuilder || this.enableLinestringBuilder) {
            this.wayGeometryBuilder.addNodeLocation(nodeContainer.getEntity());
        }
        this.nodeBuffer.add(nodeContainer.getEntity());
        this.flushNodes(false);
    }

    public void process(WayContainer wayContainer) {
        if (wayContainer.getEntity().getWayNodes().size() > 1) {
            this.wayBuffer.add(wayContainer.getEntity());
        }
        this.flushWays(false);
    }

    public void process(RelationContainer relationContainer) {
        this.relationBuffer.add(relationContainer.getEntity());
        this.flushRelations(false);
    }

    public void close() {
        this.statementContainer.close();
        this.wayGeometryBuilder.close();
        this.dbCtx.close();
    }
}

