/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class EntityReader<T extends Entity>
implements ReleasableIterator<T> {
    private boolean nextValueLoaded;
    private ReleasableContainer releasableContainer = new ReleasableContainer();
    private ReleasableIterator<T> entityIterator;
    private List<FeaturePopulator<T>> featurePopulators;
    private T nextValue;

    public EntityReader(ReleasableIterator<T> entityIterator, List<FeaturePopulator<T>> featurePopulators) {
        this.entityIterator = (ReleasableIterator)this.releasableContainer.add(entityIterator);
        for (FeaturePopulator<T> featurePopulator : featurePopulators) {
            this.releasableContainer.add(featurePopulator);
        }
        this.featurePopulators = featurePopulators;
    }

    private T readNextEntity() {
        Entity entity = (Entity)this.entityIterator.next();
        for (FeaturePopulator<T> populator : this.featurePopulators) {
            populator.populateFeatures((Object)entity);
        }
        return (T)entity;
    }

    public boolean hasNext() {
        if (!this.nextValueLoaded && this.entityIterator.hasNext()) {
            this.nextValue = this.readNextEntity();
            this.nextValueLoaded = true;
        }
        return this.nextValueLoaded;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextValue;
        this.nextValueLoaded = false;
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.releasableContainer.close();
    }
}

