/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistory;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainerFactory;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;

public class ChangeReader<T extends Entity>
implements ReleasableIterator<ChangeContainer> {
    private ReleasableIterator<EntityHistory<T>> source;
    private EntityContainerFactory<T> containerFactory;

    public ChangeReader(ReleasableIterator<EntityHistory<T>> source, EntityContainerFactory<T> containerFactory) {
        this.source = source;
        this.containerFactory = containerFactory;
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public ChangeContainer next() {
        boolean createdPreviously;
        EntityHistory entityHistory = (EntityHistory)this.source.next();
        Entity entity = (Entity)entityHistory.getEntity();
        EntityContainer entityContainer = this.containerFactory.createContainer((Object)entity);
        boolean bl = createdPreviously = ((Entity)entityHistory.getEntity()).getVersion() > 1;
        if (entityHistory.isVisible() && createdPreviously) {
            return new ChangeContainer(entityContainer, ChangeAction.Modify);
        }
        if (entityHistory.isVisible() && !createdPreviously) {
            return new ChangeContainer(entityContainer, ChangeAction.Create);
        }
        if (!entityHistory.isVisible() && createdPreviously) {
            return new ChangeContainer(entityContainer, ChangeAction.Delete);
        }
        return new ChangeContainer(entityContainer, ChangeAction.Delete);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.source.close();
    }
}

