/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.osmbinary.Osmformat;

public class HeaderMetadataReader
implements Function<Osmformat.HeaderBlock, Map<String, Object>> {
    private static final List<String> SUPPORTED_FEATURES = Collections.unmodifiableList(Arrays.asList("OsmSchema-V0.6", "DenseNodes"));

    @Override
    public Map<String, Object> apply(Osmformat.HeaderBlock header) {
        ArrayList<String> unsupportedFeatures = new ArrayList<String>();
        for (String feature : header.getRequiredFeaturesList()) {
            if (SUPPORTED_FEATURES.contains(feature)) continue;
            unsupportedFeatures.add(feature);
        }
        if (unsupportedFeatures.size() > 0) {
            throw new OsmosisRuntimeException("PBF file contains unsupported features " + unsupportedFeatures);
        }
        HashMap<String, Object> osmosisMetadata = new HashMap<String, Object>();
        if (header.getOptionalFeaturesList().contains((Object)"LocationsOnWays")) {
            osmosisMetadata.put("way_node.location_included", true);
        } else {
            osmosisMetadata.put("way_node.location_included", false);
        }
        return osmosisMetadata;
    }
}

