/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.model.SpecialTagExtractionResult;
import org.mapsforge.map.writer.util.OSMUtils;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class TDNode {
    private static final byte ZOOM_HOUSENUMBER = 17;
    private final short elevation;
    private final String houseNumber;
    private final long id;
    private final int latitude;
    private final byte layer;
    private final int longitude;
    private final String name;
    private Map<Short, Object> tags;

    public static TDNode fromNode(Node node, List<String> preferredLanguages) {
        SpecialTagExtractionResult ster = OSMUtils.extractSpecialFields((Entity)node, preferredLanguages);
        Map<Short, Object> knownWayTags = OSMUtils.extractKnownPOITags((Entity)node);
        return new TDNode(node.getId(), LatLongUtils.degreesToMicrodegrees(node.getLatitude()), LatLongUtils.degreesToMicrodegrees(node.getLongitude()), ster.getElevation(), ster.getLayer(), ster.getHousenumber(), ster.getName(), knownWayTags);
    }

    public TDNode(long id, int latitude, int longitude, short elevation, byte layer, String houseNumber, String name) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
        this.houseNumber = houseNumber;
        this.layer = layer;
        this.name = name;
    }

    public TDNode(long id, int latitude, int longitude, short elevation, byte layer, String houseNumber, String name, Map<Short, Object> tags) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
        this.houseNumber = houseNumber;
        this.layer = layer;
        this.name = name;
        this.tags = tags;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDNode other = (TDNode)obj;
        return this.id == other.id;
    }

    public short getElevation() {
        return this.elevation;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public long getId() {
        return this.id;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public byte getLayer() {
        return this.layer;
    }

    public int getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.name;
    }

    public Map<Short, Object> getTags() {
        return this.tags;
    }

    public byte getZoomAppear() {
        if (this.tags == null || this.tags.size() == 0) {
            if (this.houseNumber != null) {
                return 17;
            }
            return 127;
        }
        return OSMTagMapping.getInstance().getZoomAppearPOI(this.tags.keySet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean isPOI() {
        return this.houseNumber != null || this.elevation != 0 || this.tags.size() > 0;
    }

    public void setTags(Map<Short, Object> tags) {
        this.tags = tags;
    }

    public final String toString() {
        return "TDNode [id=" + this.id + ", latitude=" + LatLongUtils.microdegreesToDegrees(this.latitude) + ", longitude=" + LatLongUtils.microdegreesToDegrees(this.longitude) + ", name=" + this.name + ", tags=" + Arrays.toString(this.tags.keySet().toArray()) + "]";
    }

    public String toStringDetailed() {
        return "TDNode [id=" + this.id + ", latitude=" + LatLongUtils.microdegreesToDegrees(this.latitude) + ", longitude=" + LatLongUtils.microdegreesToDegrees(this.longitude) + ", name=" + this.name + ", tags=" + OSMUtils.tagsToString(this.tags, false) + "]";
    }
}

