/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TShortIntHashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.WayPolygonizer;
import org.mapsforge.map.writer.model.MapWriterConfiguration;
import org.mapsforge.map.writer.model.NodeResolver;
import org.mapsforge.map.writer.model.OSMTag;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDRelation;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.model.TileBasedDataProcessor;
import org.mapsforge.map.writer.model.TileCoordinate;
import org.mapsforge.map.writer.model.TileData;
import org.mapsforge.map.writer.model.TileGridLayout;
import org.mapsforge.map.writer.model.WayResolver;
import org.mapsforge.map.writer.model.ZoomIntervalConfiguration;
import org.mapsforge.map.writer.util.GeoUtils;
import org.mapsforge.map.writer.util.OSMUtils;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;

abstract class BaseTileBasedDataProcessor
implements TileBasedDataProcessor,
NodeResolver,
WayResolver {
    protected static final Logger LOGGER = Logger.getLogger(BaseTileBasedDataProcessor.class.getName());
    protected final int bboxEnlargement;
    protected final BoundingBox boundingbox;
    protected float[] countWays;
    protected float[] countWayTileFactor;
    protected final TShortIntHashMap histogramPoiTags;
    protected final TShortIntHashMap histogramWayTags;
    protected final TLongSet innerWaysWithoutAdditionalTags;
    protected long maxWayID = Long.MIN_VALUE;
    protected final TLongObjectHashMap<TLongArrayList> outerToInnerMapping;
    protected final List<String> preferredLanguages;
    protected final boolean progressLogs;
    protected final boolean skipInvalidRelations;
    protected final boolean tagValues;
    protected TileGridLayout[] tileGridLayouts;
    protected final Map<TileCoordinate, TLongHashSet> tilesToCoastlines;
    protected final Map<TileCoordinate, TLongHashSet> tilesToPartElements;
    protected final Map<TileCoordinate, TLongHashSet> tilesToRootElements;
    protected final Map<Long, Long> partRootRelations;
    private long amountOfNodesProcessed = 0L;
    private long amountOfRelationsProcessed = 0L;
    private long amountOfWaysProcessed = 0L;
    protected final NumberFormat nfCounts = NumberFormat.getInstance();
    protected final ZoomIntervalConfiguration zoomIntervalConfiguration;

    public BaseTileBasedDataProcessor(MapWriterConfiguration configuration) {
        this.boundingbox = configuration.getBboxConfiguration();
        this.zoomIntervalConfiguration = configuration.getZoomIntervalConfiguration();
        this.tileGridLayouts = new TileGridLayout[this.zoomIntervalConfiguration.getNumberOfZoomIntervals()];
        this.bboxEnlargement = configuration.getBboxEnlargement();
        this.preferredLanguages = configuration.getPreferredLanguages();
        this.progressLogs = configuration.isProgressLogs();
        this.skipInvalidRelations = configuration.isSkipInvalidRelations();
        this.tagValues = configuration.isTagValues();
        this.outerToInnerMapping = new TLongObjectHashMap();
        this.innerWaysWithoutAdditionalTags = new TLongHashSet();
        this.tilesToCoastlines = new HashMap<TileCoordinate, TLongHashSet>();
        this.tilesToPartElements = new HashMap<TileCoordinate, TLongHashSet>();
        this.tilesToRootElements = new HashMap<TileCoordinate, TLongHashSet>();
        this.partRootRelations = new HashMap<Long, Long>();
        this.nfCounts.setGroupingUsed(true);
        this.countWays = new float[this.zoomIntervalConfiguration.getNumberOfZoomIntervals()];
        this.countWayTileFactor = new float[this.zoomIntervalConfiguration.getNumberOfZoomIntervals()];
        this.histogramPoiTags = new TShortIntHashMap();
        this.histogramWayTags = new TShortIntHashMap();
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            TileCoordinate upperLeft = new TileCoordinate(MercatorProjection.longitudeToTileX(this.boundingbox.minLongitude, this.zoomIntervalConfiguration.getBaseZoom(i)), MercatorProjection.latitudeToTileY(this.boundingbox.maxLatitude, this.zoomIntervalConfiguration.getBaseZoom(i)), this.zoomIntervalConfiguration.getBaseZoom(i));
            this.tileGridLayouts[i] = new TileGridLayout(upperLeft, this.computeNumberOfHorizontalTiles(i), this.computeNumberOfVerticalTiles(i));
        }
    }

    @Override
    public long cumulatedNumberOfTiles() {
        long cumulated = 0L;
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            cumulated += (long)(this.tileGridLayouts[i].getAmountTilesHorizontal() * this.tileGridLayouts[i].getAmountTilesVertical());
        }
        return cumulated;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingbox;
    }

    @Override
    public TileGridLayout getTileGridLayout(int zoomIntervalIndex) {
        return this.tileGridLayouts[zoomIntervalIndex];
    }

    @Override
    public ZoomIntervalConfiguration getZoomIntervalConfiguration() {
        return this.zoomIntervalConfiguration;
    }

    @Override
    public void addNode(Node node) {
        if (++this.amountOfNodesProcessed % 1000000L == 0L && this.progressLogs) {
            System.out.print("\u001b[2KAdd nodes: " + this.nfCounts.format(this.amountOfNodesProcessed) + "\r");
        }
    }

    @Override
    public void addRelation(Relation relation) {
        if (++this.amountOfRelationsProcessed % 10000L == 0L && this.progressLogs) {
            System.out.print("\u001b[2KAdd relations: " + this.nfCounts.format(this.amountOfRelationsProcessed) + "\r");
        }
    }

    @Override
    public void addWay(Way way) {
        if (++this.amountOfWaysProcessed % 50000L == 0L && this.progressLogs) {
            System.out.print("\u001b[2KAdd ways: " + this.nfCounts.format(this.amountOfWaysProcessed) + "\r");
        }
    }

    @Override
    public long getNodesNumber() {
        return this.amountOfNodesProcessed;
    }

    @Override
    public long getRelationsNumber() {
        return this.amountOfRelationsProcessed;
    }

    @Override
    public long getWaysNumber() {
        return this.amountOfWaysProcessed;
    }

    protected void addImplicitRelationInformation(TDWay tdWay) {
        if (!this.tagValues) {
            return;
        }
        if (!this.partRootRelations.containsKey(tdWay.getId())) {
            return;
        }
        Long rootId = this.partRootRelations.get(tdWay.getId());
        if (rootId == null) {
            OSMTagMapping mapping = OSMTagMapping.getInstance();
            for (Short aShort : tdWay.getTags().keySet()) {
                if (!mapping.getWayTag(aShort).getKey().equals("id")) continue;
                tdWay.getTags().remove(aShort);
                break;
            }
            OSMTag idTag = mapping.getWayTag("id", String.valueOf(tdWay.getId()));
            assert (idTag != null);
            tdWay.getTags().put(idTag.getId(), OSMUtils.getObjectFromWildcardAndValue(idTag.getValue(), String.valueOf(tdWay.getId())));
        } else {
            tdWay.setRef(String.valueOf(rootId));
        }
    }

    protected void addPOI(TDNode poi) {
        if (!poi.isPOI()) {
            return;
        }
        byte minZoomLevel = poi.getZoomAppear();
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            long tileCoordinateY;
            long tileCoordinateX;
            TileData tileData;
            if (minZoomLevel > this.zoomIntervalConfiguration.getMaxZoom(i) || (tileData = this.getTileImpl(i, (int)(tileCoordinateX = (long)MercatorProjection.longitudeToTileX(LatLongUtils.microdegreesToDegrees(poi.getLongitude()), this.zoomIntervalConfiguration.getBaseZoom(i))), (int)(tileCoordinateY = (long)MercatorProjection.latitudeToTileY(LatLongUtils.microdegreesToDegrees(poi.getLatitude()), this.zoomIntervalConfiguration.getBaseZoom(i))))) == null) continue;
            tileData.addPOI(poi);
            this.countPoiTags(poi);
        }
    }

    protected void addWayToTiles(TDWay way, int enlargement) {
        int bboxEnlargementLocal = enlargement;
        byte minZoomLevel = way.getMinimumZoomLevel();
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            if (minZoomLevel > this.zoomIntervalConfiguration.getMaxZoom(i)) continue;
            Set<TileCoordinate> matchedTiles = GeoUtils.mapWayToTiles(way, this.zoomIntervalConfiguration.getBaseZoom(i), bboxEnlargementLocal);
            boolean added = false;
            for (TileCoordinate matchedTile : matchedTiles) {
                TileData td = this.getTileImpl(i, matchedTile.getX(), matchedTile.getY());
                if (td == null) continue;
                this.countWayTags(way);
                int n = i;
                this.countWayTileFactor[n] = this.countWayTileFactor[n] + 1.0f;
                added = true;
                td.addWay(way);
            }
            if (!added) continue;
            int n = i;
            this.countWays[n] = this.countWays[n] + 1.0f;
        }
    }

    protected void countPoiTags(TDNode poi) {
        if (poi == null || poi.getTags() == null) {
            return;
        }
        for (short tag : poi.getTags().keySet()) {
            this.histogramPoiTags.adjustOrPutValue(tag, 1, 1);
        }
    }

    protected void countWayTags(Set<Short> tags) {
        if (tags != null) {
            for (short tag : tags) {
                this.histogramWayTags.adjustOrPutValue(tag, 1, 1);
            }
        }
    }

    protected void countWayTags(TDWay way) {
        if (way != null) {
            this.countWayTags(way.getTags().keySet());
        }
    }

    protected abstract TileData getTileImpl(int var1, int var2, int var3);

    protected abstract void handleAdditionalRelationTags(TDWay var1, TDRelation var2);

    protected void handleImplicitWayRelations() {
        if (!this.tagValues) {
            return;
        }
        for (Map.Entry<TileCoordinate, TLongHashSet> tilePartElementEntry : this.tilesToPartElements.entrySet()) {
            TLongHashSet tileRootElementSet = this.tilesToRootElements.get(tilePartElementEntry.getKey());
            if (tileRootElementSet == null || tileRootElementSet.isEmpty() || tilePartElementEntry.getValue().isEmpty()) continue;
            ArrayList<TDWay> pElems = new ArrayList<TDWay>();
            TLongIterator tilePartElementIterator = tilePartElementEntry.getValue().iterator();
            while (tilePartElementIterator.hasNext()) {
                TDWay pElem = this.getWay(tilePartElementIterator.next());
                pElems.add(pElem);
            }
            TLongIterator tileRootElementIterator = tileRootElementSet.iterator();
            while (tileRootElementIterator.hasNext()) {
                TDWay rElem = this.getWay(tileRootElementIterator.next());
                BoundingBox rBox = GeoUtils.mapWayToBoundingBox(rElem);
                if (rBox == null) continue;
                Polygon rPolygon = null;
                for (int i = pElems.size() - 1; i >= 0; --i) {
                    Polygon pPolygon;
                    TDWay pElem = (TDWay)pElems.get(i);
                    if (pElem.getWayNodes().length < 3 || !rBox.contains(LatLongUtils.microdegreesToDegrees(pElem.getWayNodes()[0].getLatitude()), LatLongUtils.microdegreesToDegrees(pElem.getWayNodes()[0].getLongitude())) || (pPolygon = GeoUtils.mapWayToPolygon(pElem)) == null || rPolygon == null && (rPolygon = GeoUtils.mapWayToPolygon(rElem)) == null || !rPolygon.covers(pPolygon.getInteriorPoint())) continue;
                    if (!this.partRootRelations.containsKey(rElem.getId())) {
                        this.partRootRelations.put(rElem.getId(), null);
                    }
                    this.partRootRelations.put(pElem.getId(), rElem.getId());
                    pElems.remove(pElem);
                    tilePartElementEntry.getValue().remove(pElem.getId());
                }
            }
        }
        LOGGER.info("calculated " + this.nfCounts.format(this.partRootRelations.size()) + " implicit relations");
    }

    protected abstract void handleVirtualInnerWay(TDWay var1);

    protected abstract void handleVirtualOuterWay(TDWay var1);

    private int computeNumberOfHorizontalTiles(int zoomIntervalIndex) {
        long tileCoordinateLeft = MercatorProjection.longitudeToTileX(this.boundingbox.minLongitude, this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex));
        long tileCoordinateRight = MercatorProjection.longitudeToTileX(this.boundingbox.maxLongitude, this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex));
        assert (tileCoordinateLeft <= tileCoordinateRight);
        assert (tileCoordinateLeft - tileCoordinateRight + 1L < Integer.MAX_VALUE);
        LOGGER.finer("basezoom: " + this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex) + "\t+n_horizontal: " + (tileCoordinateRight - tileCoordinateLeft + 1L));
        return (int)(tileCoordinateRight - tileCoordinateLeft + 1L);
    }

    private int computeNumberOfVerticalTiles(int zoomIntervalIndex) {
        long tileCoordinateBottom = MercatorProjection.latitudeToTileY(this.boundingbox.minLatitude, this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex));
        long tileCoordinateTop = MercatorProjection.latitudeToTileY(this.boundingbox.maxLatitude, this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex));
        assert (tileCoordinateBottom >= tileCoordinateTop);
        assert (tileCoordinateBottom - tileCoordinateTop + 1L <= Integer.MAX_VALUE);
        LOGGER.finer("basezoom: " + this.zoomIntervalConfiguration.getBaseZoom(zoomIntervalIndex) + "\t+n_vertical: " + (tileCoordinateBottom - tileCoordinateTop + 1L));
        return (int)(tileCoordinateBottom - tileCoordinateTop + 1L);
    }

    protected void prepareImplicitWayRelations(TDWay tdWay) {
        block7: {
            block8: {
                block6: {
                    if (!tdWay.isCoastline()) break block6;
                    Set<TileCoordinate> coastLineTiles = GeoUtils.mapWayToTiles(tdWay, (byte)12, 0);
                    for (TileCoordinate tileCoordinate : coastLineTiles) {
                        TLongHashSet coastlines = this.tilesToCoastlines.get(tileCoordinate);
                        if (coastlines == null) {
                            coastlines = new TLongHashSet();
                            this.tilesToCoastlines.put(tileCoordinate, coastlines);
                        }
                        coastlines.add(tdWay.getId());
                    }
                    break block7;
                }
                if (!this.tagValues) break block7;
                if (!tdWay.isRootElement()) break block8;
                Set<TileCoordinate> rootTiles = GeoUtils.mapWayToTiles(tdWay, (byte)12, 0);
                for (TileCoordinate tileCoordinate : rootTiles) {
                    TLongHashSet roots = this.tilesToRootElements.get(tileCoordinate);
                    if (roots == null) {
                        roots = new TLongHashSet();
                        this.tilesToRootElements.put(tileCoordinate, roots);
                    }
                    roots.add(tdWay.getId());
                }
                break block7;
            }
            if (!tdWay.isPartElement()) break block7;
            Set<TileCoordinate> partTiles = GeoUtils.mapWayToTiles(tdWay, (byte)12, 0);
            for (TileCoordinate tileCoordinate : partTiles) {
                TLongHashSet parts = this.tilesToPartElements.get(tileCoordinate);
                if (parts == null) {
                    parts = new TLongHashSet();
                    this.tilesToPartElements.put(tileCoordinate, parts);
                }
                parts.add(tdWay.getId());
            }
        }
    }

    protected class WayHandler
    implements TObjectProcedure<TDWay> {
        private long nWays = 0L;

        protected WayHandler() {
        }

        @Override
        public boolean execute(TDWay way) {
            if (way == null) {
                return true;
            }
            if (++this.nWays % 10000L == 0L && BaseTileBasedDataProcessor.this.progressLogs) {
                System.out.print("Progress: Ways " + BaseTileBasedDataProcessor.this.nfCounts.format(this.nWays) + " / " + BaseTileBasedDataProcessor.this.nfCounts.format(BaseTileBasedDataProcessor.this.getWaysNumber()) + "\r");
            }
            if (way.isRenderRelevant() && !BaseTileBasedDataProcessor.this.outerToInnerMapping.contains(way.getId()) && !BaseTileBasedDataProcessor.this.innerWaysWithoutAdditionalTags.contains(way.getId())) {
                BaseTileBasedDataProcessor.this.addImplicitRelationInformation(way);
                BaseTileBasedDataProcessor.this.addWayToTiles(way, BaseTileBasedDataProcessor.this.bboxEnlargement);
            }
            return true;
        }
    }

    protected class RelationHandler
    implements TObjectProcedure<TDRelation> {
        private List<Deque<TDWay>> extractedPolygons;
        private List<Integer> inner;
        private Map<Integer, List<Integer>> outerToInner;
        private final WayPolygonizer polygonizer = new WayPolygonizer();
        private long nRelations = 0L;

        protected RelationHandler() {
        }

        @Override
        public boolean execute(TDRelation relation) {
            if (relation == null) {
                return false;
            }
            if (++this.nRelations % 100L == 0L && BaseTileBasedDataProcessor.this.progressLogs) {
                System.out.print("Progress: Relations " + BaseTileBasedDataProcessor.this.nfCounts.format(this.nRelations) + " / " + BaseTileBasedDataProcessor.this.nfCounts.format(BaseTileBasedDataProcessor.this.getRelationsNumber()) + "\r");
            }
            this.extractedPolygons = null;
            this.outerToInner = null;
            TDWay[] members = relation.getMemberWays();
            try {
                this.polygonizer.polygonizeAndRelate(members);
            }
            catch (TopologyException e) {
                LOGGER.log(Level.FINE, "cannot relate extracted polygons to each other for relation: " + relation.getId(), e);
            }
            if (!this.polygonizer.getDangling().isEmpty()) {
                if (BaseTileBasedDataProcessor.this.skipInvalidRelations) {
                    LOGGER.fine("skipping relation that contains dangling ways which could not be merged to polygons: " + relation.getId());
                    return true;
                }
                LOGGER.fine("relation contains dangling ways which could not be merged to polygons: " + relation.getId());
            } else if (!this.polygonizer.getIllegal().isEmpty()) {
                if (BaseTileBasedDataProcessor.this.skipInvalidRelations) {
                    LOGGER.fine("skipping relation contains illegal closed ways with fewer than 4 nodes: " + relation.getId());
                    return true;
                }
                LOGGER.fine("relation contains illegal closed ways with fewer than 4 nodes: " + relation.getId());
            }
            this.extractedPolygons = this.polygonizer.getPolygons();
            this.outerToInner = this.polygonizer.getOuterToInner();
            for (Map.Entry<Integer, List<Integer>> entry : this.outerToInner.entrySet()) {
                Deque<TDWay> outerPolygon = this.extractedPolygons.get(entry.getKey());
                this.inner = null;
                this.inner = entry.getValue();
                byte shape = 1;
                if (this.inner != null && !this.inner.isEmpty()) {
                    shape = 2;
                }
                TDWay outerWay = null;
                if (outerPolygon.size() > 1) {
                    if (!relation.isRenderRelevant()) {
                        LOGGER.fine("constructed outer polygon in relation has no known tags: " + relation.getId());
                        continue;
                    }
                    ArrayList<TDNode> waynodeList = new ArrayList<TDNode>();
                    for (TDWay outerSegment : outerPolygon) {
                        if (outerSegment.isReversedInRelation()) {
                            for (int i = outerSegment.getWayNodes().length - 1; i >= 0; --i) {
                                waynodeList.add(outerSegment.getWayNodes()[i]);
                            }
                            continue;
                        }
                        for (TDNode tdNode : outerSegment.getWayNodes()) {
                            waynodeList.add(tdNode);
                        }
                    }
                    TDNode[] waynodes = waynodeList.toArray(new TDNode[waynodeList.size()]);
                    outerWay = new TDWay(++BaseTileBasedDataProcessor.this.maxWayID, relation.getLayer(), relation.getName(), relation.getHouseNumber(), relation.getRef(), relation.getTags(), shape, waynodes);
                    BaseTileBasedDataProcessor.this.addWayToTiles(outerWay, BaseTileBasedDataProcessor.this.bboxEnlargement);
                    BaseTileBasedDataProcessor.this.handleVirtualOuterWay(outerWay);
                    BaseTileBasedDataProcessor.this.countWayTags(relation.getTags().keySet());
                } else {
                    outerWay = outerPolygon.getFirst();
                    if (BaseTileBasedDataProcessor.this.outerToInnerMapping.contains(outerWay.getId())) {
                        shape = 2;
                    }
                    outerWay.setShape(shape);
                    outerWay.mergeRelationInformation(relation);
                    if (outerWay.isRenderRelevant()) {
                        BaseTileBasedDataProcessor.this.handleAdditionalRelationTags(outerWay, relation);
                        BaseTileBasedDataProcessor.this.addWayToTiles(outerWay, BaseTileBasedDataProcessor.this.bboxEnlargement);
                        BaseTileBasedDataProcessor.this.countWayTags(outerWay.getTags().keySet());
                    }
                }
                this.addInnerWays(outerWay);
            }
            return true;
        }

        private void addInnerWays(TDWay outer) {
            if (this.inner != null && !this.inner.isEmpty()) {
                TLongArrayList innerList = BaseTileBasedDataProcessor.this.outerToInnerMapping.get(outer.getId());
                if (innerList == null) {
                    innerList = new TLongArrayList();
                    BaseTileBasedDataProcessor.this.outerToInnerMapping.put(outer.getId(), innerList);
                }
                for (Integer innerIndex : this.inner) {
                    Deque<TDWay> innerSegments = this.extractedPolygons.get(innerIndex);
                    TDWay innerWay = null;
                    if (innerSegments.size() == 1) {
                        innerWay = innerSegments.getFirst();
                        if (innerWay.hasTags() && outer.hasTags()) {
                            int contained = 0;
                            for (Map.Entry entry : innerWay.getTags().entrySet()) {
                                for (Map.Entry<Short, Object> outerTag : outer.getTags().entrySet()) {
                                    if (!((Short)entry.getKey()).equals(outerTag.getKey())) continue;
                                    Object innerValue = entry.getValue();
                                    Object outerValue = outerTag.getValue();
                                    if (innerValue != null) {
                                        if (outerValue == null || !(innerValue instanceof Byte && outerValue instanceof Byte && innerValue.equals(outerValue) || innerValue instanceof Integer && outerValue instanceof Integer && innerValue.equals(outerValue) || innerValue instanceof Float && outerValue instanceof Float && innerValue.equals(outerValue) || innerValue instanceof Short && outerValue instanceof Short && innerValue.equals(outerValue)) && (!(innerValue instanceof String) || !(outerValue instanceof String) || !innerValue.equals(outerValue))) continue;
                                        ++contained;
                                        continue;
                                    }
                                    if (outerValue != null) continue;
                                    ++contained;
                                }
                            }
                            if (contained == innerWay.getTags().size()) {
                                BaseTileBasedDataProcessor.this.innerWaysWithoutAdditionalTags.add(innerWay.getId());
                            }
                        }
                    } else {
                        ArrayList<TDNode> waynodeList = new ArrayList<TDNode>();
                        for (TDWay tDWay : innerSegments) {
                            if (tDWay.isReversedInRelation()) {
                                for (int i = tDWay.getWayNodes().length - 1; i >= 0; --i) {
                                    waynodeList.add(tDWay.getWayNodes()[i]);
                                }
                                continue;
                            }
                            for (TDNode tdNode : tDWay.getWayNodes()) {
                                waynodeList.add(tdNode);
                            }
                        }
                        TDNode[] waynodes = waynodeList.toArray(new TDNode[waynodeList.size()]);
                        innerWay = new TDWay(++BaseTileBasedDataProcessor.this.maxWayID, 0, null, null, null, waynodes);
                        BaseTileBasedDataProcessor.this.handleVirtualInnerWay(innerWay);
                    }
                    innerList.add(innerWay.getId());
                }
            }
        }
    }
}

