from typing import Any, List, Literal, TypedDict

from .FHIR_Annotation import FHIR_Annotation
from .FHIR_boolean import FHIR_boolean
from .FHIR_canonical import FHIR_canonical
from .FHIR_code import FHIR_code
from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_dateTime import FHIR_dateTime
from .FHIR_Element import FHIR_Element
from .FHIR_id import FHIR_id
from .FHIR_Identifier import FHIR_Identifier
from .FHIR_Meta import FHIR_Meta
from .FHIR_Narrative import FHIR_Narrative
from .FHIR_Period import FHIR_Period
from .FHIR_Quantity import FHIR_Quantity
from .FHIR_Range import FHIR_Range
from .FHIR_Ratio import FHIR_Ratio
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string
from .FHIR_Timing import FHIR_Timing
from .FHIR_uri import FHIR_uri

# A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.
FHIR_ServiceRequest = TypedDict(
    "FHIR_ServiceRequest",
    {
        # This is a ServiceRequest resource
        "resourceType": Literal["ServiceRequest"],
        # The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
        "id": FHIR_id,
        # The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
        "meta": FHIR_Meta,
        # A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
        "implicitRules": FHIR_uri,
        # Extensions for implicitRules
        "_implicitRules": FHIR_Element,
        # The base language in which the resource is written.
        "language": FHIR_code,
        # Extensions for language
        "_language": FHIR_Element,
        # A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.
        "text": FHIR_Narrative,
        # These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.
        "contained": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Identifiers assigned to this order instance by the orderer and/or the receiver and/or order fulfiller.
        "identifier": List[FHIR_Identifier],
        # The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this ServiceRequest.
        "instantiatesCanonical": List[FHIR_canonical],
        # The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this ServiceRequest.
        "instantiatesUri": List[FHIR_uri],
        # Extensions for instantiatesUri
        "_instantiatesUri": List[FHIR_Element],
        # Plan/proposal/order fulfilled by this request.
        "basedOn": List[FHIR_Reference],
        # The request takes the place of the referenced completed or terminated request(s).
        "replaces": List[FHIR_Reference],
        # A shared identifier common to all service requests that were authorized more or less simultaneously by a single author, representing the composite or group identifier.
        "requisition": FHIR_Identifier,
        # The status of the order.
        "status": FHIR_code,
        # Extensions for status
        "_status": FHIR_Element,
        # Whether the request is a proposal, plan, an original order or a reflex order.
        "intent": FHIR_code,
        # Extensions for intent
        "_intent": FHIR_Element,
        # A code that classifies the service for searching, sorting and display purposes (e.g. "Surgical Procedure").
        "category": List[FHIR_CodeableConcept],
        # Indicates how quickly the ServiceRequest should be addressed with respect to other requests.
        "priority": FHIR_code,
        # Extensions for priority
        "_priority": FHIR_Element,
        # Set this to true if the record is saying that the service/procedure should NOT be performed.
        "doNotPerform": FHIR_boolean,
        # Extensions for doNotPerform
        "_doNotPerform": FHIR_Element,
        # A code that identifies a particular service (i.e., procedure, diagnostic investigation, or panel of investigations) that have been requested.
        "code": FHIR_CodeableConcept,
        # Additional details and instructions about the how the services are to be delivered.   For example, and order for a urinary catheter may have an order detail for an external or indwelling catheter, or an order for a bandage may require additional instructions specifying how the bandage should be applied.
        "orderDetail": List[FHIR_CodeableConcept],
        # An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
        "quantityQuantity": FHIR_Quantity,
        # An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
        "quantityRatio": FHIR_Ratio,
        # An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
        "quantityRange": FHIR_Range,
        # On whom or what the service is to be performed. This is usually a human patient, but can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).
        "subject": FHIR_Reference,
        # An encounter that provides additional information about the healthcare context in which this request is made.
        "encounter": FHIR_Reference,
        # The date/time at which the requested service should occur.
        "occurrenceDateTime": str,
        # Extensions for occurrenceDateTime
        "_occurrenceDateTime": FHIR_Element,
        # The date/time at which the requested service should occur.
        "occurrencePeriod": FHIR_Period,
        # The date/time at which the requested service should occur.
        "occurrenceTiming": FHIR_Timing,
        # If a CodeableConcept is present, it indicates the pre-condition for performing the service.  For example "pain", "on flare-up", etc.
        "asNeededBoolean": bool,
        # Extensions for asNeededBoolean
        "_asNeededBoolean": FHIR_Element,
        # If a CodeableConcept is present, it indicates the pre-condition for performing the service.  For example "pain", "on flare-up", etc.
        "asNeededCodeableConcept": FHIR_CodeableConcept,
        # When the request transitioned to being actionable.
        "authoredOn": FHIR_dateTime,
        # Extensions for authoredOn
        "_authoredOn": FHIR_Element,
        # The individual who initiated the request and has responsibility for its activation.
        "requester": FHIR_Reference,
        # Desired type of performer for doing the requested service.
        "performerType": FHIR_CodeableConcept,
        # The desired performer for doing the requested service.  For example, the surgeon, dermatopathologist, endoscopist, etc.
        "performer": List[FHIR_Reference],
        # The preferred location(s) where the procedure should actually happen in coded or free text form. E.g. at home or nursing day care center.
        "locationCode": List[FHIR_CodeableConcept],
        # A reference to the the preferred location(s) where the procedure should actually happen. E.g. at home or nursing day care center.
        "locationReference": List[FHIR_Reference],
        # An explanation or justification for why this service is being requested in coded or textual form.   This is often for billing purposes.  May relate to the resources referred to in `supportingInfo`.
        "reasonCode": List[FHIR_CodeableConcept],
        # Indicates another resource that provides a justification for why this service is being requested.   May relate to the resources referred to in `supportingInfo`.
        "reasonReference": List[FHIR_Reference],
        # Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be needed for delivering the requested service.
        "insurance": List[FHIR_Reference],
        # Additional clinical information about the patient or specimen that may influence the services or their interpretations.     This information includes diagnosis, clinical findings and other observations.  In laboratory ordering these are typically referred to as "ask at order entry questions (AOEs)".  This includes observations explicitly requested by the producer (filler) to provide context or supporting information needed to complete the order. For example,  reporting the amount of inspired oxygen for blood gas measurements.
        "supportingInfo": List[FHIR_Reference],
        # One or more specimens that the laboratory procedure will use.
        "specimen": List[FHIR_Reference],
        # Anatomic location where the procedure should be performed. This is the target site.
        "bodySite": List[FHIR_CodeableConcept],
        # Any other notes and comments made about the service request. For example, internal billing notes.
        "note": List[FHIR_Annotation],
        # Instructions in terms that are understood by the patient or consumer.
        "patientInstruction": FHIR_string,
        # Extensions for patientInstruction
        "_patientInstruction": FHIR_Element,
        # Key events in the history of the request.
        "relevantHistory": List[FHIR_Reference],
    },
    total=False,
)
