from typing import Any, List, Literal, TypedDict

from .FHIR_code import FHIR_code
from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_Element import FHIR_Element
from .FHIR_id import FHIR_id
from .FHIR_Identifier import FHIR_Identifier
from .FHIR_InsurancePlan_Contact import FHIR_InsurancePlan_Contact
from .FHIR_InsurancePlan_Coverage import FHIR_InsurancePlan_Coverage
from .FHIR_InsurancePlan_Plan import FHIR_InsurancePlan_Plan
from .FHIR_Meta import FHIR_Meta
from .FHIR_Narrative import FHIR_Narrative
from .FHIR_Period import FHIR_Period
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string
from .FHIR_uri import FHIR_uri

# Details of a Health Insurance product/plan provided by an organization.
FHIR_InsurancePlan = TypedDict(
    "FHIR_InsurancePlan",
    {
        # This is a InsurancePlan resource
        "resourceType": Literal["InsurancePlan"],
        # The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
        "id": FHIR_id,
        # The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
        "meta": FHIR_Meta,
        # A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
        "implicitRules": FHIR_uri,
        # Extensions for implicitRules
        "_implicitRules": FHIR_Element,
        # The base language in which the resource is written.
        "language": FHIR_code,
        # Extensions for language
        "_language": FHIR_Element,
        # A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.
        "text": FHIR_Narrative,
        # These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.
        "contained": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.
        "identifier": List[FHIR_Identifier],
        # The current state of the health insurance product.
        "status": Literal["draft", "active", "retired", "unknown"],
        # Extensions for status
        "_status": FHIR_Element,
        # The kind of health insurance product.
        "type": List[FHIR_CodeableConcept],
        # Official name of the health insurance product as designated by the owner.
        "name": FHIR_string,
        # Extensions for name
        "_name": FHIR_Element,
        # A list of alternate names that the product is known as, or was known as in the past.
        "alias": List[FHIR_string],
        # Extensions for alias
        "_alias": List[FHIR_Element],
        # The period of time that the health insurance product is available.
        "period": FHIR_Period,
        # The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.
        "ownedBy": FHIR_Reference,
        # An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.
        "administeredBy": FHIR_Reference,
        # The geographic region in which a health insurance product's benefits apply.
        "coverageArea": List[FHIR_Reference],
        # The contact for the health insurance product for a certain purpose.
        "contact": List[FHIR_InsurancePlan_Contact],
        # The technical endpoints providing access to services operated for the health insurance product.
        "endpoint": List[FHIR_Reference],
        # Reference to the network included in the health insurance product.
        "network": List[FHIR_Reference],
        # Details about the coverage offered by the insurance product.
        "coverage": List[FHIR_InsurancePlan_Coverage],
        # Details about an insurance plan.
        "plan": List[FHIR_InsurancePlan_Plan],
    },
    total=False,
)
