# Foundational Model of Anatomy release version 5.0.0
# Created on Wed Apr 24 10:25:20 PDT 2019

# The FMA is licensed under the Creative Commons 3.0 Unported license.

# FMA description content downloaded from
# http://sig.biostr.washington.edu/share/downloads/fma/release/latest/fma.zip

# CSV version of the FMA able to be downloaded from
# https://bioportal.bioontology.org/ontologies/FMA

# A pruned version of the CSV file with just codes and descriptions is
# saved to
# https://github.com/RadiotherapyAI/FMA/raw/367d57c04521f1c50f633b82d9827ee025cf5402/FMA.csv

# TG263 to FMA code conversion extracted from
# https://www.aapm.org/pubs/reports/rpt_263_supplemental/TG263_Nomenclature_Worksheet_20170815.xls

from raicontours import TG263

FMA_NAMES = {
    3862: "Anterior interventricular branch of left coronary artery",
    5906: "Brachial nerve plexus",
    7088: "Heart",
    7131: "Esophagus",
    7148: "Stomach",
    7196: "Spleen",
    7197: "Liver",
    7198: "Pancreas",
    7200: "Small intestine",
    7201: "Large intestine",
    7202: "Gallbladder",
    7204: "Right kidney",
    7205: "Left kidney",
    7206: "Duodenum",
    7309: "Right lung",
    7310: "Left lung",
    7394: "Trachea",
    7465: "Carina of trachea",
    7486: "Manubrium",
    7647: "Spinal cord",
    9600: "Prostate",
    9680: "Vertebral canal",
    12514: "Right eyeball",
    12515: "Left eyeball",
    13889: "Pituitary gland",
    14544: "Rectum",
    15629: "Right adrenal gland",
    15630: "Left adrenal gland",
    15900: "Urinary bladder",
    16580: "Bony pelvis",
    19386: "Seminal vesicle",
    20292: "Cavity of mouth",
    45244: "Right brachial nerve plexus",
    45245: "Left brachial nerve plexus",
    45643: "External genitalia",
    46620: "Constrictor muscle of pharynx",
    50060: "Chest wall",
    50801: "Brain",
    50875: "Right optic nerve",
    50878: "Left optic nerve",
    52590: "Cauda equina",
    52748: "Mandible",
    54640: "Tongue",
    54832: "Temporomandibular joint",
    54833: "Right temporomandibular joint",
    54834: "Left temporomandibular joint",
    54966: "Set of constrictor muscles of pharynx",
    55011: "Head of right femur",
    55012: "Head of left femur",
    55097: "Larynx",
    55414: "Glottis",
    58242: "Right lens",
    58243: "Left lens",
    59102: "Right lacrimal gland",
    59103: "Left lacrimal gland",
    59797: "Right parotid gland",
    59798: "Left parotid gland",
    59802: "Right submandibular gland",
    59803: "Left submandibular gland",
    60202: "Right cochlea",
    60203: "Left cochlea",
    61825: "Temporal lobe",
    62045: "Optic chiasm",
    67944: "Cerebellum",
    71331: "Set of ribs",
    79876: "Brainstem",
    223695: "Left nipple",
    235068: "Parasternal lymphatic chain",
    256135: "Body",
    275022: "Right hippocampus",
    275024: "Left hippocampus",
}


DEFAULT_FMA_CODES = {
    TG263.A_Aorta: 3734,
    TG263.A_Aorta_Asc: 3736,
    TG263.A_Brachiocephls: 3932,
    TG263.A_Carotid: 3939,
    TG263.A_Carotid_L: 4058,
    TG263.A_Carotid_R: 3941,
    TG263.A_Celiac: 50737,
    TG263.A_Coronary: 49893,
    TG263.A_Coronary_L: 50040,
    TG263.A_Coronary_R: 50039,
    TG263.A_Femoral_L: 70250,
    TG263.A_Femoral_R: 70249,
    TG263.A_Hypophyseal_I: 49846,
    TG263.A_Hypophyseal_S: 49849,
    TG263.A_Iliac_Ext_L: 18807,
    TG263.A_Iliac_Ext_R: 18806,
    TG263.A_Iliac_Int_L: 18810,
    TG263.A_Iliac_Int_R: 18809,
    TG263.A_Iliac_L: 14766,
    TG263.A_Iliac_R: 14765,
    TG263.A_LAD: 3862,
    TG263.A_Mesenteric_I: 14750,
    TG263.A_Mesenteric_S: 14749,
    TG263.A_Pulmonary: 66326,
    TG263.A_Subclavian: 3951,
    TG263.A_Subclavian_L: 4694,
    TG263.A_Subclavian_R: 3953,
    TG263.A_Vertebral: 3956,
    TG263.A_Vertebral_L: 4066,
    TG263.A_Vertebral_R: 3958,
    TG263.Acetabulum_L: 16599,
    TG263.Acetabulum_R: 16598,
    TG263.Acetabulums: 16579,
    TG263.Anus: 15711,
    TG263.Appendix: 14542,
    TG263.Arytenoid: 55109,
    TG263.Arytenoid_L: 55114,
    TG263.Arytenoid_R: 55113,
    TG263.Atrium: 7099,
    TG263.Atrium_L: 7097,
    TG263.Atrium_R: 7096,
    TG263.BileDuct_Common: 14667,
    TG263.Bladder: 15900,
    TG263.Bladder_Wall: 15902,
    TG263.Body: 256135,
    TG263.Bone: 30317,
    TG263.BoneMarrow: 9608,
    TG263.Bone_Ethmoid: 52740,
    TG263.Bone_Frontal: 52734,
    TG263.Bone_Hyoid: 52749,
    TG263.Bone_Ilium: 42832,
    TG263.Bone_Ilium_L: 16591,
    TG263.Bone_Ilium_R: 16590,
    TG263.Bone_Incus: 52752,
    TG263.Bone_Incus_L: 74051,
    TG263.Bone_Incus_R: 74050,
    TG263.Bone_Ischium_L: 16594,
    TG263.Bone_Ischium_R: 16593,
    TG263.Bone_Lacrimal: 52741,
    TG263.Bone_Lacrimal_L: 53646,
    TG263.Bone_Lacrimal_R: 53645,
    TG263.Bone_Mandible: 52748,
    TG263.Bone_Mastoid: 52872,
    TG263.Bone_Mastoid_L: 52874,
    TG263.Bone_Mastoid_R: 52873,
    TG263.Bone_Nasal: 52745,
    TG263.Bone_Nasal_L: 53648,
    TG263.Bone_Nasal_R: 53647,
    TG263.Bone_Occipital: 52735,
    TG263.Bone_Palatine: 52746,
    TG263.Bone_Palatine_L: 53656,
    TG263.Bone_Palatine_R: 53655,
    TG263.Bone_Parietal: 9613,
    TG263.Bone_Parietal_L: 52789,
    TG263.Bone_Parietal_R: 52788,
    TG263.Bone_Pelvic: 16580,
    TG263.Bone_Pelvic_L: 20227,
    TG263.Bone_Pelvic_R: 20226,
    TG263.Bone_Sphenoid: 52736,
    TG263.Bone_Temporal: 52737,
    TG263.Bone_Temporal_L: 52739,
    TG263.Bone_Temporal_R: 52738,
    TG263.Bone_Zygomatic_L: 52893,
    TG263.Bone_Zygomatic_R: 52892,
    TG263.Bone_Zygomatics: 52747,
    TG263.Bowel: 7199,
    TG263.Bowel_Large: 7201,
    TG263.Bowel_Small: 7200,
    TG263.BrachialPlex_L: 45245,
    TG263.BrachialPlex_R: 45244,
    TG263.BrachialPlexs: 5906,
    TG263.Brain: 50801,
    TG263.Brainstem: 79876,
    TG263.Breast_L: 321497,
    TG263.Breast_R: 321496,
    TG263.Breasts: 268893,
    TG263.Bronchus: 26660,
    TG263.Bronchus_L: 26662,
    TG263.Bronchus_Main: 7405,
    TG263.Bronchus_Main_L: 7396,
    TG263.Bronchus_Main_R: 7395,
    TG263.Bronchus_R: 26661,
    TG263.CN_III: 50864,
    TG263.CN_III_L: 50880,
    TG263.CN_III_R: 50879,
    TG263.CN_IX: 50870,
    TG263.CN_IX_L: 50892,
    TG263.CN_IX_R: 50870,
    TG263.CN_V: 50866,
    TG263.CN_VI: 50867,
    TG263.CN_VII: 50868,
    TG263.CN_VIII: 50869,
    TG263.CN_VIII_L: 50891,
    TG263.CN_VIII_R: 50890,
    TG263.CN_VII_L: 50889,
    TG263.CN_VII_R: 50888,
    TG263.CN_VI_L: 50887,
    TG263.CN_VI_R: 50886,
    TG263.CN_V_L: 50885,
    TG263.CN_V_R: 50884,
    TG263.CN_XI: 6720,
    TG263.CN_XII: 50871,
    TG263.CN_XII_L: 50903,
    TG263.CN_XII_R: 50901,
    TG263.CN_XI_L: 50899,
    TG263.CN_XI_R: 50897,
    TG263.Canal_Anal: 15703,
    TG263.Carina: 7465,
    TG263.Cartlg_Thyroid: 55099,
    TG263.CaudaEquina: 52590,
    TG263.Cavernosum: 75189,
    TG263.Cavity_Nasal: 54378,
    TG263.Cavity_Oral: 20292,
    TG263.Cecum: 14541,
    TG263.Cerebellum: 67944,
    TG263.Cerebrum: 62000,
    TG263.Cerebrum_L: 61819,
    TG263.Cerebrum_R: 67292,
    TG263.Cervix: 17740,
    TG263.Chestwall: 50060,
    TG263.Chestwall_L: 25559,
    TG263.Chestwall_R: 25558,
    TG263.Cist_Pontine: 83719,
    TG263.Clavicle_L: 13323,
    TG263.Clavicle_R: 13322,
    TG263.Cochlea: 60201,
    TG263.Cochlea_L: 60203,
    TG263.Cochlea_R: 60202,
    TG263.Colon: 14543,
    TG263.Colon_Ascending: 14545,
    TG263.Colon_Decending: 14547,
    TG263.Colon_Sigmoid: 14548,
    TG263.Colon_Transverse: 14546,
    TG263.Cornea: 58238,
    TG263.Cornea_L: 58240,
    TG263.Cornea_R: 58239,
    TG263.CribriformPlate: 52890,
    TG263.Cricoid: 9615,
    TG263.Cricopharyngeus: 46661,
    TG263.Dens: 24043,
    TG263.Diaphragm: 13295,
    TG263.Duodenum: 7206,
    TG263.Ear_External_L: 53644,
    TG263.Ear_External_R: 53643,
    TG263.Ear_Externals: 52781,
    TG263.Ear_Internal_L: 61021,
    TG263.Ear_Internal_R: 61020,
    TG263.Ear_Internals: 60909,
    TG263.Ear_Middle: 56513,
    TG263.Ear_Middle_L: 56515,
    TG263.Ear_Middle_R: 56514,
    TG263.Elbow: 24901,
    TG263.Elbow_L: 24903,
    TG263.Elbow_R: 24902,
    TG263.Esophagus: 7131,
    TG263.Esophagus_I: 9397,
    TG263.Esophagus_M: 9396,
    TG263.Eye_L: 12515,
    TG263.Eye_R: 12514,
    TG263.Eyes: 268861,
    TG263.Femur_Base_L: 32846,
    TG263.Femur_Base_R: 32845,
    TG263.Femur_Head_L: 32843,
    TG263.Femur_Head_R: 32842,
    TG263.Femur_Joint_L: 35180,
    TG263.Femur_Joint_R: 35179,
    TG263.Femur_L: 24475,
    TG263.Femur_Neck_L: 42386,
    TG263.Femur_Neck_R: 42387,
    TG263.Femur_R: 24474,
    TG263.Femur_Shaft_L: 32849,
    TG263.Femur_Shaft_R: 32848,
    TG263.Femurs: 9611,
    TG263.Fibula: 24479,
    TG263.Fibula_L: 24481,
    TG263.Fibula_R: 24480,
    TG263.Fossa_Jugular: 56429,
    TG263.Fossa_Posterior: 54368,
    TG263.Gallbladder: 7202,
    TG263.Genitals: 45643,
    TG263.Glnd_Adrenal_L: 15629,
    TG263.Glnd_Adrenal_R: 15630,
    TG263.Glnd_Lacrimal: 59101,
    TG263.Glnd_Lacrimal_L: 59103,
    TG263.Glnd_Lacrimal_R: 59102,
    TG263.Glnd_Parathyroid: 13890,
    TG263.Glnd_Subling_L: 59805,
    TG263.Glnd_Subling_R: 59804,
    TG263.Glnd_Sublings: 320440,
    TG263.Glnd_Submand_L: 59803,
    TG263.Glnd_Submand_R: 59802,
    TG263.Glnd_Submands: 320442,
    TG263.Glnd_Thymus: 9607,
    TG263.Glnd_Thyroid: 9603,
    TG263.Glottis: 55414,
    TG263.Hardpalate: 55023,
    TG263.Heart: 7088,
    TG263.Hemisphere_L: 61819,
    TG263.Hemisphere_R: 67292,
    TG263.Hippocampi: 275020,
    TG263.Hippocampus_L: 275024,
    TG263.Hippocampus_R: 275022,
    TG263.Humerus_L: 23131,
    TG263.Humerus_R: 23130,
    TG263.Hypothalmus: 62008,
    TG263.Ileum: 7208,
    TG263.Jejunum: 7207,
    TG263.Joint_Elbow: 35289,
    TG263.Joint_Elbow_L: 35295,
    TG263.Joint_Elbow_R: 35294,
    TG263.Joint_Glenohum: 25912,
    TG263.Joint_Glenohum_L: 25929,
    TG263.Joint_Glenohum_R: 25927,
    TG263.Joint_TM: 54832,
    TG263.Joint_TM_L: 54834,
    TG263.Joint_TM_R: 54833,
    TG263.Kidney_Cortex: 15581,
    TG263.Kidney_Cortex_L: 15584,
    TG263.Kidney_Cortex_R: 15583,
    TG263.Kidney_Hilum_L: 15942,
    TG263.Kidney_Hilum_R: 15941,
    TG263.Kidney_Hilums: 15610,
    TG263.Kidney_L: 7205,
    TG263.Kidney_Pelvis_L: 15579,
    TG263.Kidney_Pelvis_R: 15578,
    TG263.Kidney_R: 7204,
    TG263.Kidneys: 264815,
    TG263.Knee: 24974,
    TG263.Knee_L: 24978,
    TG263.Knee_R: 24977,
    TG263.LN: 5034,
    TG263.LN_Ax_Apical: 23394,
    TG263.LN_Ax_Apical_L: 73265,
    TG263.LN_Ax_Apical_R: 73264,
    TG263.LN_Ax_Central_L: 73263,
    TG263.LN_Ax_Central_R: 73262,
    TG263.LN_Ax_Centrals: 233482,
    TG263.LN_Ax_L1_L: 276001,
    TG263.LN_Ax_L1_R: 275999,
    TG263.LN_Ax_L2_L: 276005,
    TG263.LN_Ax_L2_R: 276003,
    TG263.LN_Ax_L3_L: 276009,
    TG263.LN_Ax_L3_R: 276007,
    TG263.LN_Ax_L: 73250,
    TG263.LN_Ax_Lateral_L: 73256,
    TG263.LN_Ax_Lateral_R: 73255,
    TG263.LN_Ax_Laterals: 233458,
    TG263.LN_Ax_Pectoral_L: 73253,
    TG263.LN_Ax_Pectoral_R: 73252,
    TG263.LN_Ax_Pectorals: 233446,
    TG263.LN_Ax_R: 73249,
    TG263.LN_Ax_Subscap_L: 73259,
    TG263.LN_Ax_Subscap_R: 73258,
    TG263.LN_Ax_Subscaps: 233470,
    TG263.LN_Brachioceph_L: 5946,
    TG263.LN_Brachioceph_R: 5945,
    TG263.LN_Brachiocephs: 5944,
    TG263.LN_Bronchpulm_L: 5967,
    TG263.LN_Bronchpulm_R: 5966,
    TG263.LN_Bronchpulms: 5965,
    TG263.LN_Diaphragmatic: 12773,
    TG263.LN_IMN_L: 5934,
    TG263.LN_IMN_R: 5933,
    TG263.LN_IMNs: 5849,
    TG263.LN_Iliac_Ext_L: 229177,
    TG263.LN_Iliac_Ext_R: 229177,
    TG263.LN_Iliac_Int_L: 224275,
    TG263.LN_Iliac_L: 224269,
    TG263.LN_Iliac_R: 224269,
    TG263.LN_Inguinofem: 236337,
    TG263.LN_Inguinofem_L: 236341,
    TG263.LN_Inguinofem_R: 236339,
    TG263.LN_Intercostals: 5932,
    TG263.LN_Ligamentarter: 74033,
    TG263.LN_Mediastinals: 12774,
    TG263.LN_Neck_IA_L: 235616,
    TG263.LN_Neck_IA_R: 235614,
    TG263.LN_Neck_IB_L: 232676,
    TG263.LN_Neck_IB_R: 232673,
    TG263.LN_Neck_IIA_L: 241975,
    TG263.LN_Neck_IIA_R: 241973,
    TG263.LN_Neck_IIB_L: 241979,
    TG263.LN_Neck_IIB_R: 241977,
    TG263.LN_Neck_III_L: 241953,
    TG263.LN_Neck_III_R: 241951,
    TG263.LN_Neck_II_L: 265660,
    TG263.LN_Neck_II_R: 265658,
    TG263.LN_Neck_IV_L: 241959,
    TG263.LN_Neck_IV_R: 241957,
    TG263.LN_Neck_VA_L: 265629,
    TG263.LN_Neck_VA_R: 265626,
    TG263.LN_Neck_VC_L: 232721,
    TG263.LN_Neck_VC_R: 232719,
    TG263.LN_Neck_VI_L: 241971,
    TG263.LN_Neck_VI_R: 241969,
    TG263.LN_Neck_V_L: 241965,
    TG263.LN_Neck_V_R: 241963,
    TG263.LN_Obturator_L: 16676,
    TG263.LN_Obturator_R: 16676,
    TG263.LN_Paraaortic: 223899,
    TG263.LN_Paramammary_L: 232600,
    TG263.LN_Paramammary_R: 232598,
    TG263.LN_Paramammarys: 44313,
    TG263.LN_Parasternal_L: 5934,
    TG263.LN_Parasternal_R: 5933,
    TG263.LN_Parasternals: 5849,
    TG263.LN_Portahepatis: 15758,
    TG263.LN_Presacral_L: 234280,
    TG263.LN_Presacral_R: 234280,
    TG263.LN_Pulmonary_L: 5970,
    TG263.LN_Pulmonary_R: 5969,
    TG263.LN_Pulmonarys: 5968,
    TG263.LN_Sclav_L: 232719,
    TG263.LN_Sclav_R: 232721,
    TG263.LN_Supmammary_L: 232604,
    TG263.LN_Supmammary_R: 232602,
    TG263.LN_Supmammarys: 12785,
    TG263.LN_Trachbrnchs: 5950,
    TG263.LN_Trachbrnchs_L: 5952,
    TG263.LN_Trachbrnchs_R: 5951,
    TG263.LN_lliac_Int_R: 224275,
    TG263.Laryngl_Pharynx: 54880,
    TG263.Larynx: 55097,
    TG263.Larynx_SG: 55476,
    TG263.Lens: 58241,
    TG263.Lens_L: 58243,
    TG263.Lens_R: 58242,
    TG263.Lig_Hepatogastrc: 16520,
    TG263.Lips: 59815,
    TG263.Liver: 7197,
    TG263.Lobe_Frontal: 61824,
    TG263.Lobe_Frontal_L: 72970,
    TG263.Lobe_Frontal_R: 72969,
    TG263.Lobe_Occipital: 67325,
    TG263.Lobe_Occipital_L: 72976,
    TG263.Lobe_Occipital_R: 72975,
    TG263.Lobe_Parietal: 61826,
    TG263.Lobe_Parietal_L: 72974,
    TG263.Lobe_Parietal_R: 72973,
    TG263.Lobe_Temporal: 61825,
    TG263.Lobe_Temporal_L: 72972,
    TG263.Lobe_Temporal_R: 72971,
    TG263.Lung_L: 7310,
    TG263.Lung_LLL: 7371,
    TG263.Lung_LUL: 7370,
    TG263.Lung_R: 7309,
    TG263.Lung_RLL: 7337,
    TG263.Lung_RML: 7383,
    TG263.Lung_RUL: 7333,
    TG263.Lungs: 68877,
    TG263.Malleus: 52753,
    TG263.Malleus_L: 74053,
    TG263.Malleus_R: 74052,
    TG263.Maxilla: 9711,
    TG263.Maxilla_L: 53650,
    TG263.Maxilla_R: 53649,
    TG263.Mediastinum: 9826,
    TG263.Musc: 30316,
    TG263.Musc_Constrict: 46620,
    TG263.Musc_Constrict_I: 46623,
    TG263.Musc_Constrict_M: 46622,
    TG263.Musc_Constrict_S: 46621,
    TG263.Musc_Digastric_L: 46293,
    TG263.Musc_Digastric_R: 46292,
    TG263.Musc_Masseter: 48996,
    TG263.Musc_Masseter_L: 48998,
    TG263.Musc_Masseter_R: 48997,
    TG263.Musc_Platysma_L: 45740,
    TG263.Musc_Platysma_R: 45739,
    TG263.Musc_Sclmast_L: 13409,
    TG263.Musc_Sclmast_R: 13408,
    TG263.Musc_Temporal_L: 49008,
    TG263.Musc_Temporal_R: 49007,
    TG263.Nasalconcha_LI: 54738,
    TG263.Nasalconcha_RI: 54737,
    TG263.Nasopharynx: 54878,
    TG263.Nose: 46472,
    TG263.Nrv_Root: 5981,
    TG263.OpticChiasm: 62045,
    TG263.OpticNrv: 50863,
    TG263.OpticNrv_L: 50878,
    TG263.OpticNrv_R: 50875,
    TG263.Orbit_L: 54668,
    TG263.Orbit_R: 54667,
    TG263.Oropharynx: 54879,
    TG263.Ovaries: 7409,
    TG263.Ovary_L: 7214,
    TG263.Ovary_R: 7213,
    TG263.Palate_Soft: 55021,
    TG263.Pancreas: 7198,
    TG263.Pancreas_Head: 10468,
    TG263.Pancreas_Tail: 14519,
    TG263.Parametrium: 77061,
    TG263.Parotid_L: 59798,
    TG263.Parotid_R: 59797,
    TG263.Parotids: 320436,
    TG263.PenileBulb: 19614,
    TG263.Penis: 9707,
    TG263.Pericardium: 9869,
    TG263.Perineum: 9579,
    TG263.Peritoneum: 9908,
    TG263.Pharynx: 46688,
    TG263.Pineal: 62033,
    TG263.Pituitary: 13889,
    TG263.Pons: 67943,
    TG263.Proc_Condyloid_L: 52838,
    TG263.Proc_Condyloid_R: 52840,
    TG263.Proc_Coronoid_L: 52835,
    TG263.Proc_Coronoid_R: 52834,
    TG263.Prostate: 9600,
    TG263.Pterygoid_Lat_L: 49017,
    TG263.Pterygoid_Lat_R: 49016,
    TG263.Pterygoid_Med_L: 49013,
    TG263.Pterygoid_Med_R: 49012,
    TG263.PubicSymphys: 16950,
    TG263.PubicSymphys_L: 16597,
    TG263.PubicSymphys_R: 16596,
    TG263.Radius_L: 23465,
    TG263.Radius_R: 23464,
    TG263.Rectal_Wall: 14626,
    TG263.Rectum: 14544,
    TG263.Retina_L: 58303,
    TG263.Retina_R: 58302,
    TG263.Retinas: 58301,
    TG263.Rib01_L: 7987,
    TG263.Rib01_R: 7857,
    TG263.Rib02_L: 8012,
    TG263.Rib02_R: 7882,
    TG263.Rib03_L: 8039,
    TG263.Rib03_R: 7909,
    TG263.Rib04_L: 8148,
    TG263.Rib04_R: 7957,
    TG263.Rib05_L: 8093,
    TG263.Rib05_R: 8066,
    TG263.Rib06_L: 8202,
    TG263.Rib06_R: 8175,
    TG263.Rib07_L: 8256,
    TG263.Rib07_R: 8229,
    TG263.Rib08_L: 8310,
    TG263.Rib08_R: 8283,
    TG263.Rib09_L: 8391,
    TG263.Rib09_R: 8364,
    TG263.Rib10_L: 8472,
    TG263.Rib10_R: 8445,
    TG263.Rib11_L: 8532,
    TG263.Rib11_R: 8531,
    TG263.Rib12_L: 8534,
    TG263.Rib12_R: 8533,
    TG263.Rib: 7574,
    TG263.SacralPlex: 5909,
    TG263.Sacrum: 16202,
    TG263.Scalp: 46494,
    TG263.Scapula_L: 13396,
    TG263.Scapula_R: 13395,
    TG263.Scrotum: 18252,
    TG263.SeminalVes: 19387,
    TG263.Sinus_Ethmoid: 84115,
    TG263.Sinus_Frontal: 57417,
    TG263.Sinus_Frontal_L: 57419,
    TG263.Sinus_Frontal_R: 57418,
    TG263.Sinus_Maxilry: 57715,
    TG263.Sinus_Maxilry_L: 57717,
    TG263.Sinus_Maxilry_R: 57716,
    TG263.Sinus_Sphenoid: 54683,
    TG263.Sinus_Sphenoid_L: 54708,
    TG263.Sinus_Sphenoid_R: 54707,
    TG263.Skin: 7163,
    TG263.Skin_Perineum: 20429,
    TG263.Skull: 46565,
    TG263.Spc_Retrophars: 286702,
    TG263.Spc_Supraclav_L: 45797,
    TG263.Spc_Supraclav_R: 45796,
    TG263.Sphincter_Anal: 15710,
    TG263.SpinalCanal: 9680,
    TG263.SpinalCord: 7647,
    TG263.SpinalCord_Cerv: 71166,
    TG263.SpinalCord_Lum: 71168,
    TG263.SpinalCord_Sac: 256623,
    TG263.SpinalCord_Thor: 71167,
    TG263.Spleen: 7196,
    TG263.Spleen_Hilum: 15841,
    TG263.Spongiosum: 19617,
    TG263.Stapes: 52751,
    TG263.Stapes_L: 74049,
    TG263.Stapes_R: 74048,
    TG263.Stomach: 7148,
    TG263.Sys_Ventricular: 242787,
    TG263.Tendon: 9721,
    TG263.Tendon_Quad: 46900,
    TG263.Testis: 7210,
    TG263.Testis_L: 7212,
    TG263.Testis_R: 7211,
    TG263.ThecalSac: 83720,
    TG263.Thoracic_Duct: 5031,
    TG263.Tongue: 54640,
    TG263.Tongue_Base: 54645,
    TG263.Tongue_Oral: 54644,
    TG263.Tongue_Oral_L: 281502,
    TG263.Tongue_Oral_R: 281500,
    TG263.Tonsil: 9609,
    TG263.Trachea: 7394,
    TG263.Ureter_L: 17888,
    TG263.Ureter_R: 17887,
    TG263.Ureters: 264814,
    TG263.Urethra: 19667,
    TG263.Uterus: 17558,
    TG263.VB_C1: 12519,
    TG263.VB_C2: 12520,
    TG263.VB_C3: 12521,
    TG263.VB_C4: 12522,
    TG263.VB_C5: 12523,
    TG263.VB_C6: 12524,
    TG263.VB_C7: 12525,
    TG263.VB_C: 72063,
    TG263.VB_L1: 13072,
    TG263.VB_L2: 13073,
    TG263.VB_L3: 13074,
    TG263.VB_L4: 13075,
    TG263.VB_L5: 13076,
    TG263.VB_L: 72065,
    TG263.VB_S1: 13077,
    TG263.VB_S2: 13078,
    TG263.VB_S3: 13079,
    TG263.VB_S4: 13080,
    TG263.VB_S5: 13081,
    TG263.VB_S: 12526,
    TG263.VB_T01: 9165,
    TG263.VB_T02: 9187,
    TG263.VB_T03: 9209,
    TG263.VB_T04: 9248,
    TG263.VB_T05: 9922,
    TG263.VB_T06: 9945,
    TG263.VB_T07: 9968,
    TG263.VB_T08: 9991,
    TG263.VB_T09: 10014,
    TG263.VB_T10: 10037,
    TG263.VB_T11: 10059,
    TG263.VB_T12: 10081,
    TG263.VB_T: 9139,
    TG263.VBs: 11945,
    TG263.V_Azygos: 4838,
    TG263.V_Brachioceph_L: 4761,
    TG263.V_Brachioceph_R: 4751,
    TG263.V_Iliac_Ext_L: 18886,
    TG263.V_Iliac_Ext_R: 18885,
    TG263.V_Iliac_Int_L: 18810,
    TG263.V_Iliac_Int_R: 18809,
    TG263.V_Iliac_L: 21387,
    TG263.V_Iliac_R: 21388,
    TG263.V_Jugular_Ext_L: 13112,
    TG263.V_Jugular_Ext_R: 13111,
    TG263.V_Jugular_Int_L: 4754,
    TG263.V_Jugular_Int_R: 4762,
    TG263.V_Portal: 66645,
    TG263.V_Pulmonary: 66643,
    TG263.V_Subclavian_L: 4763,
    TG263.V_Subclavian_R: 4755,
    TG263.V_Subclavians: 4725,
    TG263.V_Venacava_I: 10951,
    TG263.V_Venacava_S: 4720,
    TG263.Vagina: 19949,
    TG263.Valve_Aortic: 7236,
    TG263.Valve_Mitral: 7235,
    TG263.Valve_Pulmonic: 7246,
    TG263.Valve_Tricuspid: 7234,
    TG263.Ventricle: 7100,
    TG263.Ventricle_L: 7101,
    TG263.Ventricle_R: 7098,
    TG263.VocalCord_L: 55459,
    TG263.VocalCord_R: 55458,
    TG263.VocalCords: 323919,
    TG263.Vomer: 9710,
    TG263.Vulva: 20462,
    TG263.Wall_Vagina: 19971,
}
