"""
This **package** gives functions and classes for analysis
"""
import numpy as np


class MdoutReader():
    """
    This **class** is used to read the mdout file generated by SPONGE

    Suppose we have a mdout file named "example.mdout" like this::

        step    Time    Temperature     Potential   LJ
        0       0       300.0           100.0       100.0
        1       0.1     299.8           101.1       101.1

    Then we can use the following codes to read it::

        from Xponge.analysis import MdoutReader
        mdout = MdoutReader("example.mdout")
        print(mdout.step, mdout.Time, mdout.Temperature, mdout.Potential, mdout.LJ)

    :param filename: the name of the mdout file
    """
    def __init__(self, filename):
        with open(filename) as f:
            self.content = f.readline().split()
            self.data = np.loadtxt(f)
        self.content_index = {self.content[i]: i for i in range(len(self.content))}

    def __getattribute__(self, attr):
        if attr not in ("content", "content_index", "data") and attr in self.content_index.keys():
            return self.data[:, self.content_index[attr]]
        return super().__getattribute__(attr)
