# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class Integration(object):
    """NOTE: This class is auto generated by the swagger code generator program.    
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_info': 'str',
        'configuration': 'str',
        'created_time': 'int',
        'debug_mode': 'bool',
        'default_converter_id': 'ConverterId',
        'downlink_converter_id': 'ConverterId',
        'enabled': 'bool',
        'id': 'IntegrationId',
        'name': 'str',
        'remote': 'bool',
        'routing_key': 'str',
        'secret': 'str',
        'tenant_id': 'TenantId',
        'type': 'str'
    }

    attribute_map = {
        'additional_info': 'additionalInfo',
        'configuration': 'configuration',
        'created_time': 'createdTime',
        'debug_mode': 'debugMode',
        'default_converter_id': 'defaultConverterId',
        'downlink_converter_id': 'downlinkConverterId',
        'enabled': 'enabled',
        'id': 'id',
        'name': 'name',
        'remote': 'remote',
        'routing_key': 'routingKey',
        'secret': 'secret',
        'tenant_id': 'tenantId',
        'type': 'type'
    }

    def __init__(self, additional_info=None, configuration=None, created_time=None, debug_mode=None, default_converter_id=None, downlink_converter_id=None, enabled=None, id=None, name=None, remote=None, routing_key=None, secret=None, tenant_id=None, type=None):  # noqa: E501
        """Integration - a model defined in Swagger"""  # noqa: E501

        self._additional_info = None
        self._configuration = None
        self._created_time = None
        self._debug_mode = None
        self._default_converter_id = None
        self._downlink_converter_id = None
        self._enabled = None
        self._id = None
        self._name = None
        self._remote = None
        self._routing_key = None
        self._secret = None
        self._tenant_id = None
        self._type = None
        self.discriminator = None

        if additional_info is not None:
            self.additional_info = additional_info
        if configuration is not None:
            self.configuration = configuration
        if created_time is not None:
            self.created_time = created_time
        if debug_mode is not None:
            self.debug_mode = debug_mode
        if default_converter_id is not None:
            self.default_converter_id = default_converter_id
        if downlink_converter_id is not None:
            self.downlink_converter_id = downlink_converter_id
        if enabled is not None:
            self.enabled = enabled
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if remote is not None:
            self.remote = remote
        if routing_key is not None:
            self.routing_key = routing_key
        if secret is not None:
            self.secret = secret
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if type is not None:
            self.type = type

    @property
    def additional_info(self):
        """Gets the additional_info of this Integration.  # noqa: E501


        :return: The additional_info of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """Sets the additional_info of this Integration.


        :param additional_info: The additional_info of this Integration.  # noqa: E501
        :type: str
        """

        self._additional_info = additional_info

    @property
    def configuration(self):
        """Gets the configuration of this Integration.  # noqa: E501


        :return: The configuration of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this Integration.


        :param configuration: The configuration of this Integration.  # noqa: E501
        :type: str
        """

        self._configuration = configuration

    @property
    def created_time(self):
        """Gets the created_time of this Integration.  # noqa: E501


        :return: The created_time of this Integration.  # noqa: E501
        :rtype: int
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this Integration.


        :param created_time: The created_time of this Integration.  # noqa: E501
        :type: int
        """

        self._created_time = created_time

    @property
    def debug_mode(self):
        """Gets the debug_mode of this Integration.  # noqa: E501


        :return: The debug_mode of this Integration.  # noqa: E501
        :rtype: bool
        """
        return self._debug_mode

    @debug_mode.setter
    def debug_mode(self, debug_mode):
        """Sets the debug_mode of this Integration.


        :param debug_mode: The debug_mode of this Integration.  # noqa: E501
        :type: bool
        """

        self._debug_mode = debug_mode

    @property
    def default_converter_id(self):
        """Gets the default_converter_id of this Integration.  # noqa: E501


        :return: The default_converter_id of this Integration.  # noqa: E501
        :rtype: ConverterId
        """
        return self._default_converter_id

    @default_converter_id.setter
    def default_converter_id(self, default_converter_id):
        """Sets the default_converter_id of this Integration.


        :param default_converter_id: The default_converter_id of this Integration.  # noqa: E501
        :type: ConverterId
        """

        self._default_converter_id = default_converter_id

    @property
    def downlink_converter_id(self):
        """Gets the downlink_converter_id of this Integration.  # noqa: E501


        :return: The downlink_converter_id of this Integration.  # noqa: E501
        :rtype: ConverterId
        """
        return self._downlink_converter_id

    @downlink_converter_id.setter
    def downlink_converter_id(self, downlink_converter_id):
        """Sets the downlink_converter_id of this Integration.


        :param downlink_converter_id: The downlink_converter_id of this Integration.  # noqa: E501
        :type: ConverterId
        """

        self._downlink_converter_id = downlink_converter_id

    @property
    def enabled(self):
        """Gets the enabled of this Integration.  # noqa: E501


        :return: The enabled of this Integration.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this Integration.


        :param enabled: The enabled of this Integration.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def id(self):
        """Gets the id of this Integration.  # noqa: E501


        :return: The id of this Integration.  # noqa: E501
        :rtype: IntegrationId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Integration.


        :param id: The id of this Integration.  # noqa: E501
        :type: IntegrationId
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Integration.  # noqa: E501


        :return: The name of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Integration.


        :param name: The name of this Integration.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def remote(self):
        """Gets the remote of this Integration.  # noqa: E501


        :return: The remote of this Integration.  # noqa: E501
        :rtype: bool
        """
        return self._remote

    @remote.setter
    def remote(self, remote):
        """Sets the remote of this Integration.


        :param remote: The remote of this Integration.  # noqa: E501
        :type: bool
        """

        self._remote = remote

    @property
    def routing_key(self):
        """Gets the routing_key of this Integration.  # noqa: E501


        :return: The routing_key of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._routing_key

    @routing_key.setter
    def routing_key(self, routing_key):
        """Sets the routing_key of this Integration.


        :param routing_key: The routing_key of this Integration.  # noqa: E501
        :type: str
        """

        self._routing_key = routing_key

    @property
    def secret(self):
        """Gets the secret of this Integration.  # noqa: E501


        :return: The secret of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this Integration.


        :param secret: The secret of this Integration.  # noqa: E501
        :type: str
        """

        self._secret = secret

    @property
    def tenant_id(self):
        """Gets the tenant_id of this Integration.  # noqa: E501


        :return: The tenant_id of this Integration.  # noqa: E501
        :rtype: TenantId
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this Integration.


        :param tenant_id: The tenant_id of this Integration.  # noqa: E501
        :type: TenantId
        """

        self._tenant_id = tenant_id

    @property
    def type(self):
        """Gets the type of this Integration.  # noqa: E501


        :return: The type of this Integration.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Integration.


        :param type: The type of this Integration.  # noqa: E501
        :type: str
        """
        allowed_values = ["OCEANCONNECT", "SIGFOX", "THINGPARK", "TPE", "TMOBILE_IOT_CDP", "HTTP", "MQTT", "AWS_IOT", "AWS_SQS", "AWS_KINESIS", "IBM_WATSON_IOT", "TTN", "AZURE_EVENT_HUB", "OPC_UA", "CUSTOM", "UDP", "TCP", "KAFKA"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Integration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Integration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
