# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class GroupPermission(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_time': 'int',
        'entity_group_id': 'EntityGroupId',
        'entity_group_type': 'str',
        'id': 'GroupPermissionId',
        'name': 'str',
        'public': 'bool',
        'role_id': 'RoleId',
        'tenant_id': 'TenantId',
        'user_group_id': 'EntityGroupId',
        'is_public': 'bool'
    }

    attribute_map = {
        'created_time': 'createdTime',
        'entity_group_id': 'entityGroupId',
        'entity_group_type': 'entityGroupType',
        'id': 'id',
        'name': 'name',
        'public': 'public',
        'role_id': 'roleId',
        'tenant_id': 'tenantId',
        'user_group_id': 'userGroupId',
        'is_public': 'isPublic'
    }

    def __init__(self, created_time=None, entity_group_id=None, entity_group_type=None, id=None, name=None, public=None, role_id=None, tenant_id=None, user_group_id=None, is_public=False):  # noqa: E501
        """GroupPermission - a model defined in Swagger"""  # noqa: E501

        self._created_time = None
        self._entity_group_id = None
        self._entity_group_type = None
        self._id = None
        self._name = None
        self._public = None
        self._role_id = None
        self._tenant_id = None
        self._user_group_id = None
        self._is_public = None
        self.discriminator = None

        if created_time is not None:
            self.created_time = created_time
        if entity_group_id is not None:
            self.entity_group_id = entity_group_id
        if entity_group_type is not None:
            self.entity_group_type = entity_group_type
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if public is not None:
            self.public = public
        if role_id is not None:
            self.role_id = role_id
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if user_group_id is not None:
            self.user_group_id = user_group_id
        self.is_public = is_public

    @property
    def created_time(self):
        """Gets the created_time of this GroupPermission.  # noqa: E501


        :return: The created_time of this GroupPermission.  # noqa: E501
        :rtype: int
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this GroupPermission.


        :param created_time: The created_time of this GroupPermission.  # noqa: E501
        :type: int
        """

        self._created_time = created_time

    @property
    def entity_group_id(self):
        """Gets the entity_group_id of this GroupPermission.  # noqa: E501


        :return: The entity_group_id of this GroupPermission.  # noqa: E501
        :rtype: EntityGroupId
        """
        return self._entity_group_id

    @entity_group_id.setter
    def entity_group_id(self, entity_group_id):
        """Sets the entity_group_id of this GroupPermission.


        :param entity_group_id: The entity_group_id of this GroupPermission.  # noqa: E501
        :type: EntityGroupId
        """

        self._entity_group_id = entity_group_id

    @property
    def entity_group_type(self):
        """Gets the entity_group_type of this GroupPermission.  # noqa: E501


        :return: The entity_group_type of this GroupPermission.  # noqa: E501
        :rtype: str
        """
        return self._entity_group_type

    @entity_group_type.setter
    def entity_group_type(self, entity_group_type):
        """Sets the entity_group_type of this GroupPermission.


        :param entity_group_type: The entity_group_type of this GroupPermission.  # noqa: E501
        :type: str
        """
        allowed_values = ["TENANT", "CUSTOMER", "USER", "DASHBOARD", "ASSET", "DEVICE", "ALARM", "ENTITY_GROUP", "CONVERTER", "INTEGRATION", "RULE_CHAIN", "RULE_NODE", "SCHEDULER_EVENT", "BLOB_ENTITY", "ENTITY_VIEW", "WIDGETS_BUNDLE", "WIDGET_TYPE", "ROLE", "GROUP_PERMISSION"]  # noqa: E501
        if entity_group_type not in allowed_values:
            raise ValueError(
                "Invalid value for `entity_group_type` ({0}), must be one of {1}"  # noqa: E501
                .format(entity_group_type, allowed_values)
            )

        self._entity_group_type = entity_group_type

    @property
    def id(self):
        """Gets the id of this GroupPermission.  # noqa: E501


        :return: The id of this GroupPermission.  # noqa: E501
        :rtype: GroupPermissionId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GroupPermission.


        :param id: The id of this GroupPermission.  # noqa: E501
        :type: GroupPermissionId
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this GroupPermission.  # noqa: E501


        :return: The name of this GroupPermission.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GroupPermission.


        :param name: The name of this GroupPermission.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def public(self):
        """Gets the public of this GroupPermission.  # noqa: E501


        :return: The public of this GroupPermission.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this GroupPermission.


        :param public: The public of this GroupPermission.  # noqa: E501
        :type: bool
        """

        self._public = public

    @property
    def role_id(self):
        """Gets the role_id of this GroupPermission.  # noqa: E501


        :return: The role_id of this GroupPermission.  # noqa: E501
        :rtype: RoleId
        """
        return self._role_id

    @role_id.setter
    def role_id(self, role_id):
        """Sets the role_id of this GroupPermission.


        :param role_id: The role_id of this GroupPermission.  # noqa: E501
        :type: RoleId
        """

        self._role_id = role_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this GroupPermission.  # noqa: E501


        :return: The tenant_id of this GroupPermission.  # noqa: E501
        :rtype: TenantId
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this GroupPermission.


        :param tenant_id: The tenant_id of this GroupPermission.  # noqa: E501
        :type: TenantId
        """

        self._tenant_id = tenant_id

    @property
    def user_group_id(self):
        """Gets the user_group_id of this GroupPermission.  # noqa: E501


        :return: The user_group_id of this GroupPermission.  # noqa: E501
        :rtype: EntityGroupId
        """
        return self._user_group_id

    @user_group_id.setter
    def user_group_id(self, user_group_id):
        """Sets the user_group_id of this GroupPermission.


        :param user_group_id: The user_group_id of this GroupPermission.  # noqa: E501
        :type: EntityGroupId
        """

        self._user_group_id = user_group_id

    @property
    def is_public(self):
        """Gets the is_public of this GroupPermission.  # noqa: E501


        :return: The is_public of this GroupPermission.  # noqa: E501
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """Sets the is_public of this GroupPermission.


        :param is_public: The is_public of this GroupPermission.  # noqa: E501
        :type: bool
        """
        if is_public is None:
            raise ValueError("Invalid value for `is_public`, must not be `None`")  # noqa: E501

        self._is_public = is_public

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GroupPermission, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupPermission):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
