# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six

from tb_rest_client.models.models_ce import Asset


class Asset(Asset):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {**Asset.swagger_types, "owner_id": "EntityId"}
    attribute_map = {**Asset.attribute_map, "owner_id": "ownerId"}

    def __init__(self, additional_info=None, created_time=None, customer_id=None, id=None, label=None, name=None, owner_id=None, tenant_id=None, type=None):  # noqa: E501
        """Asset - a model defined in Swagger"""  # noqa: E501

        super().__init__(additional_info, created_time, customer_id, id, label, name, tenant_id, type)
        self._owner_id = owner_id

    @property
    def owner_id(self):
        """Gets the owner_id of this Asset.  # noqa: E501


        :return: The owner_id of this Asset.  # noqa: E501
        :rtype: EntityId
        """
        return self._owner_id

    @owner_id.setter
    def owner_id(self, owner_id):
        """Sets the owner_id of this Asset.


        :param owner_id: The owner_id of this Asset.  # noqa: E501
        :type: EntityId
        """

        self._owner_id = owner_id
