# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class WidgetType(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alias': 'str',
        'bundle_alias': 'str',
        'created_time': 'int',
        'descriptor': 'str',
        'id': 'WidgetTypeId',
        'name': 'str',
        'tenant_id': 'TenantId'
    }

    attribute_map = {
        'alias': 'alias',
        'bundle_alias': 'bundleAlias',
        'created_time': 'createdTime',
        'descriptor': 'descriptor',
        'id': 'id',
        'name': 'name',
        'tenant_id': 'tenantId'
    }

    def __init__(self, alias=None, bundle_alias=None, created_time=None, descriptor=None, id=None, name=None, tenant_id=None):  # noqa: E501
        """WidgetType - a model defined in Swagger"""  # noqa: E501

        self._alias = None
        self._bundle_alias = None
        self._created_time = None
        self._descriptor = None
        self._id = None
        self._name = None
        self._tenant_id = None
        self.discriminator = None

        if alias is not None:
            self.alias = alias
        if bundle_alias is not None:
            self.bundle_alias = bundle_alias
        if created_time is not None:
            self.created_time = created_time
        if descriptor is not None:
            self.descriptor = descriptor
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if tenant_id is not None:
            self.tenant_id = tenant_id

    @property
    def alias(self):
        """Gets the alias of this WidgetType.  # noqa: E501


        :return: The alias of this WidgetType.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this WidgetType.


        :param alias: The alias of this WidgetType.  # noqa: E501
        :type: str
        """

        self._alias = alias

    @property
    def bundle_alias(self):
        """Gets the bundle_alias of this WidgetType.  # noqa: E501


        :return: The bundle_alias of this WidgetType.  # noqa: E501
        :rtype: str
        """
        return self._bundle_alias

    @bundle_alias.setter
    def bundle_alias(self, bundle_alias):
        """Sets the bundle_alias of this WidgetType.


        :param bundle_alias: The bundle_alias of this WidgetType.  # noqa: E501
        :type: str
        """

        self._bundle_alias = bundle_alias

    @property
    def created_time(self):
        """Gets the created_time of this WidgetType.  # noqa: E501


        :return: The created_time of this WidgetType.  # noqa: E501
        :rtype: int
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this WidgetType.


        :param created_time: The created_time of this WidgetType.  # noqa: E501
        :type: int
        """

        self._created_time = created_time

    @property
    def descriptor(self):
        """Gets the descriptor of this WidgetType.  # noqa: E501


        :return: The descriptor of this WidgetType.  # noqa: E501
        :rtype: str
        """
        return self._descriptor

    @descriptor.setter
    def descriptor(self, descriptor):
        """Sets the descriptor of this WidgetType.


        :param descriptor: The descriptor of this WidgetType.  # noqa: E501
        :type: str
        """

        self._descriptor = descriptor

    @property
    def id(self):
        """Gets the id of this WidgetType.  # noqa: E501


        :return: The id of this WidgetType.  # noqa: E501
        :rtype: WidgetTypeId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WidgetType.


        :param id: The id of this WidgetType.  # noqa: E501
        :type: WidgetTypeId
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this WidgetType.  # noqa: E501


        :return: The name of this WidgetType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WidgetType.


        :param name: The name of this WidgetType.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tenant_id(self):
        """Gets the tenant_id of this WidgetType.  # noqa: E501


        :return: The tenant_id of this WidgetType.  # noqa: E501
        :rtype: TenantId
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this WidgetType.


        :param tenant_id: The tenant_id of this WidgetType.  # noqa: E501
        :type: TenantId
        """

        self._tenant_id = tenant_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WidgetType, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WidgetType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
